/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "grd-dbus-gdm.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_remote_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.RemoteDisplay
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusGdmRemoteDisplay
 * @title: GrdDBusGdmRemoteDisplay
 * @short_description: Generated C code for the org.gnome.DisplayManager.RemoteDisplay D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.RemoteDisplay ---- */

static const _ExtendedGDBusPropertyInfo _grd_dbus_gdm_remote_display_property_info_remote_id =
{
  {
    -1,
    (gchar *) "RemoteId",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "remote-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _grd_dbus_gdm_remote_display_property_info_session_id =
{
  {
    -1,
    (gchar *) "SessionId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-id",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _grd_dbus_gdm_remote_display_property_info_pointers[] =
{
  &_grd_dbus_gdm_remote_display_property_info_remote_id.parent_struct,
  &_grd_dbus_gdm_remote_display_property_info_session_id.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _grd_dbus_gdm_remote_display_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.RemoteDisplay",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_grd_dbus_gdm_remote_display_property_info_pointers,
    NULL
  },
  "remote-display",
};


/**
 * grd_dbus_gdm_remote_display_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
grd_dbus_gdm_remote_display_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct;
}

/**
 * grd_dbus_gdm_remote_display_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GrdDBusGdmRemoteDisplay interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
grd_dbus_gdm_remote_display_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "remote-id");
  g_object_class_override_property (klass, property_id_begin++, "session-id");
  return property_id_begin - 1;
}



/**
 * GrdDBusGdmRemoteDisplay:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>.
 */

/**
 * GrdDBusGdmRemoteDisplayIface:
 * @parent_iface: The parent interface.
 * @get_remote_id: Getter for the #GrdDBusGdmRemoteDisplay:remote-id property.
 * @get_session_id: Getter for the #GrdDBusGdmRemoteDisplay:session-id property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>.
 */

typedef GrdDBusGdmRemoteDisplayIface GrdDBusGdmRemoteDisplayInterface;
G_DEFINE_INTERFACE (GrdDBusGdmRemoteDisplay, grd_dbus_gdm_remote_display, G_TYPE_OBJECT)

static void
grd_dbus_gdm_remote_display_default_init (GrdDBusGdmRemoteDisplayIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * GrdDBusGdmRemoteDisplay:remote-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.RemoteId">"RemoteId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("remote-id", "RemoteId", "RemoteId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GrdDBusGdmRemoteDisplay:session-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.SessionId">"SessionId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("session-id", "SessionId", "SessionId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * grd_dbus_gdm_remote_display_get_remote_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.RemoteId">"RemoteId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grd_dbus_gdm_remote_display_dup_remote_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grd_dbus_gdm_remote_display_get_remote_id (GrdDBusGdmRemoteDisplay *object)
{
  g_return_val_if_fail (GRD_DBUS_GDM_IS_REMOTE_DISPLAY (object), NULL);

  return GRD_DBUS_GDM_REMOTE_DISPLAY_GET_IFACE (object)->get_remote_id (object);
}

/**
 * grd_dbus_gdm_remote_display_dup_remote_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.RemoteId">"RemoteId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grd_dbus_gdm_remote_display_dup_remote_id (GrdDBusGdmRemoteDisplay *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "remote-id", &value, NULL);
  return value;
}

/**
 * grd_dbus_gdm_remote_display_set_remote_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.RemoteId">"RemoteId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_gdm_remote_display_set_remote_id (GrdDBusGdmRemoteDisplay *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "remote-id", value, NULL);
}

/**
 * grd_dbus_gdm_remote_display_get_session_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use grd_dbus_gdm_remote_display_dup_session_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
grd_dbus_gdm_remote_display_get_session_id (GrdDBusGdmRemoteDisplay *object)
{
  g_return_val_if_fail (GRD_DBUS_GDM_IS_REMOTE_DISPLAY (object), NULL);

  return GRD_DBUS_GDM_REMOTE_DISPLAY_GET_IFACE (object)->get_session_id (object);
}

/**
 * grd_dbus_gdm_remote_display_dup_session_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
grd_dbus_gdm_remote_display_dup_session_id (GrdDBusGdmRemoteDisplay *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "session-id", &value, NULL);
  return value;
}

/**
 * grd_dbus_gdm_remote_display_set_session_id: (skip)
 * @object: A #GrdDBusGdmRemoteDisplay.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-DisplayManager-RemoteDisplay.SessionId">"SessionId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
grd_dbus_gdm_remote_display_set_session_id (GrdDBusGdmRemoteDisplay *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "session-id", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * GrdDBusGdmRemoteDisplayProxy:
 *
 * The #GrdDBusGdmRemoteDisplayProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmRemoteDisplayProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmRemoteDisplayProxy.
 */

struct _GrdDBusGdmRemoteDisplayProxyPrivate
{
  GData *qdata;
};

static void grd_dbus_gdm_remote_display_proxy_iface_init (GrdDBusGdmRemoteDisplayIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayProxy, grd_dbus_gdm_remote_display_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GrdDBusGdmRemoteDisplayProxy)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY, grd_dbus_gdm_remote_display_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayProxy, grd_dbus_gdm_remote_display_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY, grd_dbus_gdm_remote_display_proxy_iface_init))

#endif
static void
grd_dbus_gdm_remote_display_proxy_finalize (GObject *object)
{
  GrdDBusGdmRemoteDisplayProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (grd_dbus_gdm_remote_display_proxy_parent_class)->finalize (object);
}

static void
grd_dbus_gdm_remote_display_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_gdm_remote_display_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
grd_dbus_gdm_remote_display_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.DisplayManager.RemoteDisplay: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
grd_dbus_gdm_remote_display_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_gdm_remote_display_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.DisplayManager.RemoteDisplay", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) grd_dbus_gdm_remote_display_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
grd_dbus_gdm_remote_display_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
grd_dbus_gdm_remote_display_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GrdDBusGdmRemoteDisplayProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
grd_dbus_gdm_remote_display_proxy_get_remote_id (GrdDBusGdmRemoteDisplay *object)
{
  GrdDBusGdmRemoteDisplayProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RemoteId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
grd_dbus_gdm_remote_display_proxy_get_session_id (GrdDBusGdmRemoteDisplay *object)
{
  GrdDBusGdmRemoteDisplayProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
grd_dbus_gdm_remote_display_proxy_init (GrdDBusGdmRemoteDisplayProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = grd_dbus_gdm_remote_display_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY, GrdDBusGdmRemoteDisplayProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), grd_dbus_gdm_remote_display_interface_info ());
}

static void
grd_dbus_gdm_remote_display_proxy_class_init (GrdDBusGdmRemoteDisplayProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = grd_dbus_gdm_remote_display_proxy_finalize;
  gobject_class->get_property = grd_dbus_gdm_remote_display_proxy_get_property;
  gobject_class->set_property = grd_dbus_gdm_remote_display_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = grd_dbus_gdm_remote_display_proxy_g_signal;
  proxy_class->g_properties_changed = grd_dbus_gdm_remote_display_proxy_g_properties_changed;

  grd_dbus_gdm_remote_display_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusGdmRemoteDisplayProxyPrivate));
#endif
}

static void
grd_dbus_gdm_remote_display_proxy_iface_init (GrdDBusGdmRemoteDisplayIface *iface)
{
  iface->get_remote_id = grd_dbus_gdm_remote_display_proxy_get_remote_id;
  iface->get_session_id = grd_dbus_gdm_remote_display_proxy_get_session_id;
}

/**
 * grd_dbus_gdm_remote_display_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_remote_display_proxy_new_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_remote_display_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_remote_display_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplay", NULL);
}

/**
 * grd_dbus_gdm_remote_display_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_remote_display_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_remote_display_proxy_new().
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplay *
grd_dbus_gdm_remote_display_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_remote_display_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_remote_display_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplay *
grd_dbus_gdm_remote_display_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplay", NULL);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
  else
    return NULL;
}


/**
 * grd_dbus_gdm_remote_display_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grd_dbus_gdm_remote_display_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_remote_display_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_remote_display_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_remote_display_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplay", NULL);
}

/**
 * grd_dbus_gdm_remote_display_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_remote_display_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_remote_display_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplay *
grd_dbus_gdm_remote_display_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_remote_display_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grd_dbus_gdm_remote_display_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_remote_display_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplay *
grd_dbus_gdm_remote_display_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplay", NULL);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GrdDBusGdmRemoteDisplaySkeleton:
 *
 * The #GrdDBusGdmRemoteDisplaySkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmRemoteDisplaySkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmRemoteDisplaySkeleton.
 */

struct _GrdDBusGdmRemoteDisplaySkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_grd_dbus_gdm_remote_display_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_grd_dbus_gdm_remote_display_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_grd_dbus_gdm_remote_display_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _grd_dbus_gdm_remote_display_skeleton_vtable =
{
  _grd_dbus_gdm_remote_display_skeleton_handle_method_call,
  _grd_dbus_gdm_remote_display_skeleton_handle_get_property,
  _grd_dbus_gdm_remote_display_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return grd_dbus_gdm_remote_display_interface_info ();
}

static GDBusInterfaceVTable *
grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_grd_dbus_gdm_remote_display_skeleton_vtable;
}

static GVariant *
grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_grd_dbus_gdm_remote_display_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _grd_dbus_gdm_remote_display_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _grd_dbus_gdm_remote_display_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _grd_dbus_gdm_remote_display_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.RemoteDisplay", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _grd_dbus_gdm_remote_display_emit_changed (gpointer user_data);

static void
grd_dbus_gdm_remote_display_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _grd_dbus_gdm_remote_display_emit_changed (skeleton);
}

static void grd_dbus_gdm_remote_display_skeleton_iface_init (GrdDBusGdmRemoteDisplayIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplaySkeleton, grd_dbus_gdm_remote_display_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GrdDBusGdmRemoteDisplaySkeleton)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY, grd_dbus_gdm_remote_display_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplaySkeleton, grd_dbus_gdm_remote_display_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY, grd_dbus_gdm_remote_display_skeleton_iface_init))

#endif
static void
grd_dbus_gdm_remote_display_skeleton_finalize (GObject *object)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (grd_dbus_gdm_remote_display_skeleton_parent_class)->finalize (object);
}

static void
grd_dbus_gdm_remote_display_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_grd_dbus_gdm_remote_display_emit_changed (gpointer user_data)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.DisplayManager.RemoteDisplay",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_grd_dbus_gdm_remote_display_schedule_emit_changed (GrdDBusGdmRemoteDisplaySkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
grd_dbus_gdm_remote_display_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _grd_dbus_gdm_remote_display_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _grd_dbus_gdm_remote_display_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
grd_dbus_gdm_remote_display_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _grd_dbus_gdm_remote_display_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _grd_dbus_gdm_remote_display_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
grd_dbus_gdm_remote_display_skeleton_init (GrdDBusGdmRemoteDisplaySkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = grd_dbus_gdm_remote_display_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_SKELETON, GrdDBusGdmRemoteDisplaySkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *
grd_dbus_gdm_remote_display_skeleton_get_remote_id (GrdDBusGdmRemoteDisplay *object)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
grd_dbus_gdm_remote_display_skeleton_get_session_id (GrdDBusGdmRemoteDisplay *object)
{
  GrdDBusGdmRemoteDisplaySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
grd_dbus_gdm_remote_display_skeleton_class_init (GrdDBusGdmRemoteDisplaySkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = grd_dbus_gdm_remote_display_skeleton_finalize;
  gobject_class->get_property = grd_dbus_gdm_remote_display_skeleton_get_property;
  gobject_class->set_property = grd_dbus_gdm_remote_display_skeleton_set_property;
  gobject_class->notify       = grd_dbus_gdm_remote_display_skeleton_notify;


  grd_dbus_gdm_remote_display_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = grd_dbus_gdm_remote_display_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = grd_dbus_gdm_remote_display_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusGdmRemoteDisplaySkeletonPrivate));
#endif
}

static void
grd_dbus_gdm_remote_display_skeleton_iface_init (GrdDBusGdmRemoteDisplayIface *iface)
{
  iface->get_remote_id = grd_dbus_gdm_remote_display_skeleton_get_remote_id;
  iface->get_session_id = grd_dbus_gdm_remote_display_skeleton_get_session_id;
}

/**
 * grd_dbus_gdm_remote_display_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplaySkeleton): The skeleton object.
 */
GrdDBusGdmRemoteDisplay *
grd_dbus_gdm_remote_display_skeleton_new (void)
{
  return GRD_DBUS_GDM_REMOTE_DISPLAY (g_object_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.DisplayManager.RemoteDisplayFactory
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusGdmRemoteDisplayFactory
 * @title: GrdDBusGdmRemoteDisplayFactory
 * @short_description: Generated C code for the org.gnome.DisplayManager.RemoteDisplayFactory D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.DisplayManager.RemoteDisplayFactory ---- */

static const _ExtendedGDBusArgInfo _grd_dbus_gdm_remote_display_factory_method_info_create_remote_display_IN_ARG_remote_id =
{
  {
    -1,
    (gchar *) "remote_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _grd_dbus_gdm_remote_display_factory_method_info_create_remote_display_IN_ARG_pointers[] =
{
  &_grd_dbus_gdm_remote_display_factory_method_info_create_remote_display_IN_ARG_remote_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _grd_dbus_gdm_remote_display_factory_method_info_create_remote_display =
{
  {
    -1,
    (gchar *) "CreateRemoteDisplay",
    (GDBusArgInfo **) &_grd_dbus_gdm_remote_display_factory_method_info_create_remote_display_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-create-remote-display",
  FALSE
};

static const GDBusMethodInfo * const _grd_dbus_gdm_remote_display_factory_method_info_pointers[] =
{
  &_grd_dbus_gdm_remote_display_factory_method_info_create_remote_display.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _grd_dbus_gdm_remote_display_factory_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.DisplayManager.RemoteDisplayFactory",
    (GDBusMethodInfo **) &_grd_dbus_gdm_remote_display_factory_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "remote-display-factory",
};


/**
 * grd_dbus_gdm_remote_display_factory_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
grd_dbus_gdm_remote_display_factory_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct;
}

/**
 * grd_dbus_gdm_remote_display_factory_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GrdDBusGdmRemoteDisplayFactory interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
grd_dbus_gdm_remote_display_factory_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
grd_dbus_gdm_remote_display_factory_method_marshal_create_remote_display (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GrdDBusGdmRemoteDisplayFactory:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>.
 */

/**
 * GrdDBusGdmRemoteDisplayFactoryIface:
 * @parent_iface: The parent interface.
 * @handle_create_remote_display: Handler for the #GrdDBusGdmRemoteDisplayFactory::handle-create-remote-display signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>.
 */

typedef GrdDBusGdmRemoteDisplayFactoryIface GrdDBusGdmRemoteDisplayFactoryInterface;
G_DEFINE_INTERFACE (GrdDBusGdmRemoteDisplayFactory, grd_dbus_gdm_remote_display_factory, G_TYPE_OBJECT)

static void
grd_dbus_gdm_remote_display_factory_default_init (GrdDBusGdmRemoteDisplayFactoryIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GrdDBusGdmRemoteDisplayFactory::handle-create-remote-display:
   * @object: A #GrdDBusGdmRemoteDisplayFactory.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_remote_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteDisplayFactory.CreateRemoteDisplay">CreateRemoteDisplay()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call grd_dbus_gdm_remote_display_factory_complete_create_remote_display() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-remote-display",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GrdDBusGdmRemoteDisplayFactoryIface, handle_create_remote_display),
    g_signal_accumulator_true_handled,
    NULL,
      grd_dbus_gdm_remote_display_factory_method_marshal_create_remote_display,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

}

/**
 * grd_dbus_gdm_remote_display_factory_call_create_remote_display:
 * @proxy: A #GrdDBusGdmRemoteDisplayFactoryProxy.
 * @arg_remote_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteDisplayFactory.CreateRemoteDisplay">CreateRemoteDisplay()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_remote_display_factory_call_create_remote_display_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_remote_display_factory_call_create_remote_display_sync() for the synchronous, blocking version of this method.
 */
void
grd_dbus_gdm_remote_display_factory_call_create_remote_display (
    GrdDBusGdmRemoteDisplayFactory *proxy,
    const gchar *arg_remote_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateRemoteDisplay",
    g_variant_new ("(o)",
                   arg_remote_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * grd_dbus_gdm_remote_display_factory_call_create_remote_display_finish:
 * @proxy: A #GrdDBusGdmRemoteDisplayFactoryProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_remote_display_factory_call_create_remote_display().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with grd_dbus_gdm_remote_display_factory_call_create_remote_display().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_gdm_remote_display_factory_call_create_remote_display_finish (
    GrdDBusGdmRemoteDisplayFactory *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_gdm_remote_display_factory_call_create_remote_display_sync:
 * @proxy: A #GrdDBusGdmRemoteDisplayFactoryProxy.
 * @arg_remote_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteDisplayFactory.CreateRemoteDisplay">CreateRemoteDisplay()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_remote_display_factory_call_create_remote_display() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
grd_dbus_gdm_remote_display_factory_call_create_remote_display_sync (
    GrdDBusGdmRemoteDisplayFactory *proxy,
    const gchar *arg_remote_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateRemoteDisplay",
    g_variant_new ("(o)",
                   arg_remote_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * grd_dbus_gdm_remote_display_factory_complete_create_remote_display:
 * @object: A #GrdDBusGdmRemoteDisplayFactory.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-DisplayManager-RemoteDisplayFactory.CreateRemoteDisplay">CreateRemoteDisplay()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
grd_dbus_gdm_remote_display_factory_complete_create_remote_display (
    GrdDBusGdmRemoteDisplayFactory *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GrdDBusGdmRemoteDisplayFactoryProxy:
 *
 * The #GrdDBusGdmRemoteDisplayFactoryProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmRemoteDisplayFactoryProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmRemoteDisplayFactoryProxy.
 */

struct _GrdDBusGdmRemoteDisplayFactoryProxyPrivate
{
  GData *qdata;
};

static void grd_dbus_gdm_remote_display_factory_proxy_iface_init (GrdDBusGdmRemoteDisplayFactoryIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayFactoryProxy, grd_dbus_gdm_remote_display_factory_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GrdDBusGdmRemoteDisplayFactoryProxy)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY, grd_dbus_gdm_remote_display_factory_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayFactoryProxy, grd_dbus_gdm_remote_display_factory_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY, grd_dbus_gdm_remote_display_factory_proxy_iface_init))

#endif
static void
grd_dbus_gdm_remote_display_factory_proxy_finalize (GObject *object)
{
  GrdDBusGdmRemoteDisplayFactoryProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (grd_dbus_gdm_remote_display_factory_proxy_parent_class)->finalize (object);
}

static void
grd_dbus_gdm_remote_display_factory_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_remote_display_factory_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_remote_display_factory_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
grd_dbus_gdm_remote_display_factory_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GrdDBusGdmRemoteDisplayFactoryProxy *proxy = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
grd_dbus_gdm_remote_display_factory_proxy_init (GrdDBusGdmRemoteDisplayFactoryProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = grd_dbus_gdm_remote_display_factory_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY, GrdDBusGdmRemoteDisplayFactoryProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), grd_dbus_gdm_remote_display_factory_interface_info ());
}

static void
grd_dbus_gdm_remote_display_factory_proxy_class_init (GrdDBusGdmRemoteDisplayFactoryProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = grd_dbus_gdm_remote_display_factory_proxy_finalize;
  gobject_class->get_property = grd_dbus_gdm_remote_display_factory_proxy_get_property;
  gobject_class->set_property = grd_dbus_gdm_remote_display_factory_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = grd_dbus_gdm_remote_display_factory_proxy_g_signal;
  proxy_class->g_properties_changed = grd_dbus_gdm_remote_display_factory_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusGdmRemoteDisplayFactoryProxyPrivate));
#endif
}

static void
grd_dbus_gdm_remote_display_factory_proxy_iface_init (GrdDBusGdmRemoteDisplayFactoryIface *iface G_GNUC_UNUSED)
{
}

/**
 * grd_dbus_gdm_remote_display_factory_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_remote_display_factory_proxy_new_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_remote_display_factory_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_remote_display_factory_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplayFactory", NULL);
}

/**
 * grd_dbus_gdm_remote_display_factory_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_remote_display_factory_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_remote_display_factory_proxy_new().
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplayFactory *
grd_dbus_gdm_remote_display_factory_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_remote_display_factory_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_remote_display_factory_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplayFactory *
grd_dbus_gdm_remote_display_factory_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplayFactory", NULL);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
  else
    return NULL;
}


/**
 * grd_dbus_gdm_remote_display_factory_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grd_dbus_gdm_remote_display_factory_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_remote_display_factory_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplayFactory", NULL);
}

/**
 * grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_remote_display_factory_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_remote_display_factory_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplayFactory *
grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grd_dbus_gdm_remote_display_factory_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_remote_display_factory_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
GrdDBusGdmRemoteDisplayFactory *
grd_dbus_gdm_remote_display_factory_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.DisplayManager.RemoteDisplayFactory", NULL);
  if (ret != NULL)
    return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GrdDBusGdmRemoteDisplayFactorySkeleton:
 *
 * The #GrdDBusGdmRemoteDisplayFactorySkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmRemoteDisplayFactorySkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmRemoteDisplayFactorySkeleton.
 */

struct _GrdDBusGdmRemoteDisplayFactorySkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_grd_dbus_gdm_remote_display_factory_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_grd_dbus_gdm_remote_display_factory_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_grd_dbus_gdm_remote_display_factory_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _grd_dbus_gdm_remote_display_factory_skeleton_vtable =
{
  _grd_dbus_gdm_remote_display_factory_skeleton_handle_method_call,
  _grd_dbus_gdm_remote_display_factory_skeleton_handle_get_property,
  _grd_dbus_gdm_remote_display_factory_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return grd_dbus_gdm_remote_display_factory_interface_info ();
}

static GDBusInterfaceVTable *
grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_grd_dbus_gdm_remote_display_factory_skeleton_vtable;
}

static GVariant *
grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_grd_dbus_gdm_remote_display_factory_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _grd_dbus_gdm_remote_display_factory_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _grd_dbus_gdm_remote_display_factory_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _grd_dbus_gdm_remote_display_factory_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.DisplayManager.RemoteDisplayFactory", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void grd_dbus_gdm_remote_display_factory_skeleton_iface_init (GrdDBusGdmRemoteDisplayFactoryIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayFactorySkeleton, grd_dbus_gdm_remote_display_factory_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GrdDBusGdmRemoteDisplayFactorySkeleton)
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY, grd_dbus_gdm_remote_display_factory_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmRemoteDisplayFactorySkeleton, grd_dbus_gdm_remote_display_factory_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY, grd_dbus_gdm_remote_display_factory_skeleton_iface_init))

#endif
static void
grd_dbus_gdm_remote_display_factory_skeleton_finalize (GObject *object)
{
  GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton = GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (grd_dbus_gdm_remote_display_factory_skeleton_parent_class)->finalize (object);
}

static void
grd_dbus_gdm_remote_display_factory_skeleton_init (GrdDBusGdmRemoteDisplayFactorySkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = grd_dbus_gdm_remote_display_factory_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_SKELETON, GrdDBusGdmRemoteDisplayFactorySkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
grd_dbus_gdm_remote_display_factory_skeleton_class_init (GrdDBusGdmRemoteDisplayFactorySkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = grd_dbus_gdm_remote_display_factory_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = grd_dbus_gdm_remote_display_factory_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GrdDBusGdmRemoteDisplayFactorySkeletonPrivate));
#endif
}

static void
grd_dbus_gdm_remote_display_factory_skeleton_iface_init (GrdDBusGdmRemoteDisplayFactoryIface *iface G_GNUC_UNUSED)
{
}

/**
 * grd_dbus_gdm_remote_display_factory_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>.
 *
 * Returns: (transfer full) (type GrdDBusGdmRemoteDisplayFactorySkeleton): The skeleton object.
 */
GrdDBusGdmRemoteDisplayFactory *
grd_dbus_gdm_remote_display_factory_skeleton_new (void)
{
  return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (g_object_new (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusGdmObject
 * @title: GrdDBusGdmObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #GrdDBusGdmObject, #GrdDBusGdmObjectProxy, and #GrdDBusGdmObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * GrdDBusGdmObject:
 *
 * The #GrdDBusGdmObject type is a specialized container of interfaces.
 */

/**
 * GrdDBusGdmObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #GrdDBusGdmObject interface.
 */

typedef GrdDBusGdmObjectIface GrdDBusGdmObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (GrdDBusGdmObject, grd_dbus_gdm_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
grd_dbus_gdm_object_default_init (GrdDBusGdmObjectIface *iface)
{
  /**
   * GrdDBusGdmObject:remote-display:
   *
   * The #GrdDBusGdmRemoteDisplay instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("remote-display", "remote-display", "remote-display", GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * GrdDBusGdmObject:remote-display-factory:
   *
   * The #GrdDBusGdmRemoteDisplayFactory instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("remote-display-factory", "remote-display-factory", "remote-display-factory", GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * grd_dbus_gdm_object_get_remote_display:
 * @object: A #GrdDBusGdmObject.
 *
 * Gets the #GrdDBusGdmRemoteDisplay instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #GrdDBusGdmRemoteDisplay that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
GrdDBusGdmRemoteDisplay *grd_dbus_gdm_object_get_remote_display (GrdDBusGdmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplay");
  if (ret == NULL)
    return NULL;
  return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
}

/**
 * grd_dbus_gdm_object_get_remote_display_factory:
 * @object: A #GrdDBusGdmObject.
 *
 * Gets the #GrdDBusGdmRemoteDisplayFactory instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #GrdDBusGdmRemoteDisplayFactory that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
GrdDBusGdmRemoteDisplayFactory *grd_dbus_gdm_object_get_remote_display_factory (GrdDBusGdmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplayFactory");
  if (ret == NULL)
    return NULL;
  return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
}


/**
 * grd_dbus_gdm_object_peek_remote_display: (skip)
 * @object: A #GrdDBusGdmObject.
 *
 * Like grd_dbus_gdm_object_get_remote_display() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #GrdDBusGdmRemoteDisplay or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
GrdDBusGdmRemoteDisplay *grd_dbus_gdm_object_peek_remote_display (GrdDBusGdmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplay");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return GRD_DBUS_GDM_REMOTE_DISPLAY (ret);
}

/**
 * grd_dbus_gdm_object_peek_remote_display_factory: (skip)
 * @object: A #GrdDBusGdmObject.
 *
 * Like grd_dbus_gdm_object_get_remote_display_factory() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #GrdDBusGdmRemoteDisplayFactory or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
GrdDBusGdmRemoteDisplayFactory *grd_dbus_gdm_object_peek_remote_display_factory (GrdDBusGdmObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplayFactory");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return GRD_DBUS_GDM_REMOTE_DISPLAY_FACTORY (ret);
}


static void
grd_dbus_gdm_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * GrdDBusGdmObjectProxy:
 *
 * The #GrdDBusGdmObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmObjectProxy.
 */

static void
grd_dbus_gdm_object_proxy__grd_dbus_gdm_object_iface_init (GrdDBusGdmObjectIface *iface G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = grd_dbus_gdm_object_notify;
  iface->interface_removed = grd_dbus_gdm_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmObjectProxy, grd_dbus_gdm_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_OBJECT, grd_dbus_gdm_object_proxy__grd_dbus_gdm_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, grd_dbus_gdm_object_proxy__g_dbus_object_iface_init))

static void
grd_dbus_gdm_object_proxy_init (GrdDBusGdmObjectProxy *object G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
grd_dbus_gdm_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  GrdDBusGdmObjectProxy *object = GRD_DBUS_GDM_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplay");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplayFactory");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
grd_dbus_gdm_object_proxy_class_init (GrdDBusGdmObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = grd_dbus_gdm_object_proxy_set_property;
  gobject_class->get_property = grd_dbus_gdm_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "remote-display");
  g_object_class_override_property (gobject_class, 2, "remote-display-factory");
}

/**
 * grd_dbus_gdm_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
GrdDBusGdmObjectProxy *
grd_dbus_gdm_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return GRD_DBUS_GDM_OBJECT_PROXY (g_object_new (GRD_DBUS_GDM_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * GrdDBusGdmObjectSkeleton:
 *
 * The #GrdDBusGdmObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmObjectSkeleton.
 */

static void
grd_dbus_gdm_object_skeleton__grd_dbus_gdm_object_iface_init (GrdDBusGdmObjectIface *iface G_GNUC_UNUSED)
{
}


static void
grd_dbus_gdm_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = grd_dbus_gdm_object_notify;
  iface->interface_removed = grd_dbus_gdm_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (GrdDBusGdmObjectSkeleton, grd_dbus_gdm_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (GRD_DBUS_GDM_TYPE_OBJECT, grd_dbus_gdm_object_skeleton__grd_dbus_gdm_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, grd_dbus_gdm_object_skeleton__g_dbus_object_iface_init))

static void
grd_dbus_gdm_object_skeleton_init (GrdDBusGdmObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  GrdDBusGdmObjectSkeleton *object = GRD_DBUS_GDM_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (GRD_DBUS_GDM_IS_REMOTE_DISPLAY (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.DisplayManager.RemoteDisplay");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (GRD_DBUS_GDM_IS_REMOTE_DISPLAY_FACTORY (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.DisplayManager.RemoteDisplayFactory");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
grd_dbus_gdm_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  GrdDBusGdmObjectSkeleton *object = GRD_DBUS_GDM_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplay");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.DisplayManager.RemoteDisplayFactory");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
grd_dbus_gdm_object_skeleton_class_init (GrdDBusGdmObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = grd_dbus_gdm_object_skeleton_set_property;
  gobject_class->get_property = grd_dbus_gdm_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "remote-display");
  g_object_class_override_property (gobject_class, 2, "remote-display-factory");
}

/**
 * grd_dbus_gdm_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
GrdDBusGdmObjectSkeleton *
grd_dbus_gdm_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return GRD_DBUS_GDM_OBJECT_SKELETON (g_object_new (GRD_DBUS_GDM_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * grd_dbus_gdm_object_skeleton_set_remote_display:
 * @object: A #GrdDBusGdmObjectSkeleton.
 * @interface_: (nullable): A #GrdDBusGdmRemoteDisplay or %NULL to clear the interface.
 *
 * Sets the #GrdDBusGdmRemoteDisplay instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplay.top_of_page">org.gnome.DisplayManager.RemoteDisplay</link> on @object.
 */
void grd_dbus_gdm_object_skeleton_set_remote_display (GrdDBusGdmObjectSkeleton *object, GrdDBusGdmRemoteDisplay *interface_)
{
  g_object_set (G_OBJECT (object), "remote-display", interface_, NULL);
}

/**
 * grd_dbus_gdm_object_skeleton_set_remote_display_factory:
 * @object: A #GrdDBusGdmObjectSkeleton.
 * @interface_: (nullable): A #GrdDBusGdmRemoteDisplayFactory or %NULL to clear the interface.
 *
 * Sets the #GrdDBusGdmRemoteDisplayFactory instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-DisplayManager-RemoteDisplayFactory.top_of_page">org.gnome.DisplayManager.RemoteDisplayFactory</link> on @object.
 */
void grd_dbus_gdm_object_skeleton_set_remote_display_factory (GrdDBusGdmObjectSkeleton *object, GrdDBusGdmRemoteDisplayFactory *interface_)
{
  g_object_set (G_OBJECT (object), "remote-display-factory", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GrdDBusGdmObjectManagerClient
 * @title: GrdDBusGdmObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses grd_dbus_gdm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * GrdDBusGdmObjectManagerClient:
 *
 * The #GrdDBusGdmObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GrdDBusGdmObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GrdDBusGdmObjectManagerClient.
 */

G_DEFINE_TYPE (GrdDBusGdmObjectManagerClient, grd_dbus_gdm_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
grd_dbus_gdm_object_manager_client_init (GrdDBusGdmObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
grd_dbus_gdm_object_manager_client_class_init (GrdDBusGdmObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * grd_dbus_gdm_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #GrdDBusGdmObjectProxy.
 */
GType
grd_dbus_gdm_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return GRD_DBUS_GDM_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.DisplayManager.RemoteDisplay", (gpointer) (guintptr) (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.DisplayManager.RemoteDisplayFactory", (gpointer) (guintptr) (GRD_DBUS_GDM_TYPE_REMOTE_DISPLAY_FACTORY_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * grd_dbus_gdm_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using grd_dbus_gdm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_object_manager_client_new_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", grd_dbus_gdm_object_manager_client_get_proxy_type, NULL);
}

/**
 * grd_dbus_gdm_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_object_manager_client_new().
 *
 * Returns: (transfer full) (type GrdDBusGdmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
grd_dbus_gdm_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using grd_dbus_gdm_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
grd_dbus_gdm_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", grd_dbus_gdm_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * grd_dbus_gdm_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like grd_dbus_gdm_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call grd_dbus_gdm_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See grd_dbus_gdm_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
grd_dbus_gdm_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (GRD_DBUS_GDM_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", grd_dbus_gdm_object_manager_client_get_proxy_type, NULL);
}

/**
 * grd_dbus_gdm_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to grd_dbus_gdm_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with grd_dbus_gdm_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type GrdDBusGdmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
grd_dbus_gdm_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * grd_dbus_gdm_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like grd_dbus_gdm_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See grd_dbus_gdm_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GrdDBusGdmObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
grd_dbus_gdm_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (GRD_DBUS_GDM_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", grd_dbus_gdm_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


