/* theme-nostalgia.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from theme-nostalgia.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2010-2013 Robert Ancell
   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define PUZZLE_VIEW_gap_factor 0.5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;

#define TYPE_NOSTALGIA_THEME (nostalgia_theme_get_type ())
#define NOSTALGIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOSTALGIA_THEME, NostalgiaTheme))
#define NOSTALGIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOSTALGIA_THEME, NostalgiaThemeClass))
#define IS_NOSTALGIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOSTALGIA_THEME))
#define IS_NOSTALGIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOSTALGIA_THEME))
#define NOSTALGIA_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOSTALGIA_THEME, NostalgiaThemeClass))

typedef struct _NostalgiaTheme NostalgiaTheme;
typedef struct _NostalgiaThemeClass NostalgiaThemeClass;
typedef struct _NostalgiaThemePrivate NostalgiaThemePrivate;
enum  {
	NOSTALGIA_THEME_0_PROPERTY,
	NOSTALGIA_THEME_NUM_PROPERTIES
};
static GParamSpec* nostalgia_theme_properties[NOSTALGIA_THEME_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _TilePrivate TilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GObjectClass parent_class;
	void (*configure) (Theme* self, guint size);
	void (*draw_arrow) (Theme* self, cairo_t* context);
	void (*draw_socket) (Theme* self, cairo_t* context);
	void (*draw_highlight) (Theme* self, cairo_t* context, gboolean has_tile);
	void (*draw_paused_tile) (Theme* self, cairo_t* context);
	void (*draw_tile) (Theme* self, cairo_t* context, Tile* tile, gboolean highlight);
	void (*set_animation_level) (Theme* self, guint8 animation_level);
};

struct _NostalgiaTheme {
	Theme parent_instance;
	NostalgiaThemePrivate * priv;
};

struct _NostalgiaThemeClass {
	ThemeClass parent_class;
};

struct _NostalgiaThemePrivate {
	cairo_pattern_t* tile_colors[10];
	cairo_pattern_t* paused_color;
	cairo_pattern_t* text_colors[10];
	cairo_pattern_t* black_text_color;
	cairo_pattern_t* white_text_color;
	guint size;
	guint8 animation_level;
	gdouble arrow_half_h;
	gdouble neg_arrow_half_h;
	gdouble arrow_depth;
	gdouble arrow_dx;
	gdouble arrow_dy;
	gdouble neg_arrow_dy;
	gdouble arrow_w;
	gdouble arrow_x;
	gdouble arrow_w_minus_depth;
	gdouble socket_depth;
	gdouble size_minus_socket_depth;
	gdouble size_minus_two_socket_depths;
	cairo_pattern_t* highlight_tile_pattern;
	gdouble tile_depth;
	gdouble size_minus_tile_depth;
	gdouble tile_dx;
	gdouble tile_dy;
	gdouble size_minus_tile_dx;
	gdouble half_tile_size;
	gdouble half_tile_size_minus_dy;
	gdouble half_tile_size_plus_dy;
	gdouble size_minus_one;
	gdouble font_size;
	gdouble north_number_y;
	gdouble south_number_y;
	gdouble east_number_x;
	gdouble west_number_x;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	guint8 north;
	guint8 west;
	guint8 east;
	guint8 south;
};

struct _TileClass {
	GObjectClass parent_class;
};

static gint NostalgiaTheme_private_offset;
static gpointer nostalgia_theme_parent_class = NULL;

VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType nostalgia_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NostalgiaTheme, g_object_unref)
VALA_EXTERN void theme_configure (Theme* self,
                      guint size);
VALA_EXTERN void theme_set_animation_level (Theme* self,
                                guint8 animation_level);
VALA_EXTERN void theme_draw_arrow (Theme* self,
                       cairo_t* context);
VALA_EXTERN void theme_draw_socket (Theme* self,
                        cairo_t* context);
VALA_EXTERN void theme_draw_highlight (Theme* self,
                           cairo_t* context,
                           gboolean has_tile);
VALA_EXTERN void theme_draw_paused_tile (Theme* self,
                             cairo_t* context);
VALA_EXTERN void theme_draw_tile (Theme* self,
                      cairo_t* context,
                      Tile* tile,
                      gboolean highlight);
static cairo_pattern_t* nostalgia_theme_make_color_pattern (const gchar* color);
static gdouble nostalgia_theme_hex_value (gchar c);
static void nostalgia_theme_real_configure (Theme* base,
                                     guint new_size);
static void nostalgia_theme_configure_arrow (NostalgiaTheme* self,
                                      guint new_size);
static void nostalgia_theme_configure_socket (NostalgiaTheme* self,
                                       guint new_size);
static void nostalgia_theme_real_set_animation_level (Theme* base,
                                               guint8 new_animation_level);
static void nostalgia_theme_real_draw_arrow (Theme* base,
                                      cairo_t* context);
static void nostalgia_theme_real_draw_socket (Theme* base,
                                       cairo_t* context);
static void nostalgia_theme_real_draw_highlight (Theme* base,
                                          cairo_t* context,
                                          gboolean has_tile);
static void nostalgia_theme_real_draw_paused_tile (Theme* base,
                                            cairo_t* context);
static void nostalgia_theme_draw_tile_background (NostalgiaTheme* self,
                                           cairo_t* context,
                                           cairo_pattern_t* north_color,
                                           cairo_pattern_t* east_color,
                                           cairo_pattern_t* south_color,
                                           cairo_pattern_t* west_color);
static void nostalgia_theme_real_draw_tile (Theme* base,
                                     cairo_t* context,
                                     Tile* tile,
                                     gboolean highlight);
static void nostalgia_theme_draw_number (cairo_t* context,
                                  cairo_pattern_t* text_color,
                                  gdouble x,
                                  gdouble y,
                                  guint8 number);
VALA_EXTERN NostalgiaTheme* nostalgia_theme_new (void);
VALA_EXTERN NostalgiaTheme* nostalgia_theme_construct (GType object_type);
VALA_EXTERN Theme* theme_construct (GType object_type);
static GObject * nostalgia_theme_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void nostalgia_theme_finalize (GObject * obj);
static GType nostalgia_theme_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
nostalgia_theme_get_instance_private (NostalgiaTheme* self)
{
	return G_STRUCT_MEMBER_P (self, NostalgiaTheme_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static cairo_pattern_t*
nostalgia_theme_make_color_pattern (const gchar* color)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* result;
	g_return_val_if_fail (color != NULL, NULL);
	r = ((nostalgia_theme_hex_value (string_get (color, (glong) 0)) * 16.0) + nostalgia_theme_hex_value (string_get (color, (glong) 1))) / 255.0;
	g = ((nostalgia_theme_hex_value (string_get (color, (glong) 2)) * 16.0) + nostalgia_theme_hex_value (string_get (color, (glong) 3))) / 255.0;
	b = ((nostalgia_theme_hex_value (string_get (color, (glong) 4)) * 16.0) + nostalgia_theme_hex_value (string_get (color, (glong) 5))) / 255.0;
	_tmp0_ = cairo_pattern_create_rgb (r, g, b);
	result = _tmp0_;
	return result;
}

static gdouble
nostalgia_theme_hex_value (gchar c)
{
	gboolean _tmp0_ = FALSE;
	gdouble result;
	if (c >= '0') {
		_tmp0_ = c <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gdouble) (c - '0');
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (c >= 'a') {
			_tmp1_ = c <= 'f';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = (gdouble) ((c - 'a') + 10);
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (c >= 'A') {
				_tmp2_ = c <= 'F';
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = (gdouble) ((c - 'A') + 10);
				return result;
			} else {
				result = 0.0;
				return result;
			}
		}
	}
}

static void
nostalgia_theme_real_configure (Theme* base,
                                guint new_size)
{
	NostalgiaTheme * self;
	gboolean _tmp0_ = FALSE;
	gdouble highlight_radius = 0.0;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	self = (NostalgiaTheme*) base;
	if (self->priv->size != ((guint) 0)) {
		_tmp0_ = self->priv->size == new_size;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	nostalgia_theme_configure_arrow (self, new_size);
	nostalgia_theme_configure_socket (self, new_size);
	self->priv->half_tile_size = new_size * 0.5;
	highlight_radius = new_size * 0.45;
	_tmp1_ = cairo_pattern_create_radial (self->priv->half_tile_size, self->priv->half_tile_size, 0.0, self->priv->half_tile_size, self->priv->half_tile_size, highlight_radius);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	self->priv->highlight_tile_pattern = _tmp1_;
	_tmp2_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp2_, 0.0, 1.0, 1.0, 1.0, 1.0);
	_tmp3_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp3_, 0.2, 1.0, 1.0, 1.0, 0.8);
	_tmp4_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp4_, 0.3, 1.0, 1.0, 1.0, 0.5);
	_tmp5_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp5_, 0.4, 1.0, 1.0, 1.0, 0.2);
	_tmp6_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp6_, 0.5, 1.0, 1.0, 1.0, 0.1);
	_tmp7_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp7_, 1.0, 1.0, 1.0, 1.0, 0.0);
	self->priv->tile_depth = MIN (new_size * 0.05, 4.0);
	self->priv->size_minus_tile_depth = ((gdouble) new_size) - self->priv->tile_depth;
	self->priv->tile_dx = (G_SQRT2 + 1.0) * self->priv->tile_depth;
	self->priv->tile_dy = G_SQRT2 * self->priv->tile_depth;
	self->priv->size_minus_tile_dx = ((gdouble) new_size) - self->priv->tile_dx;
	self->priv->half_tile_size_minus_dy = self->priv->half_tile_size - self->priv->tile_dy;
	self->priv->half_tile_size_plus_dy = self->priv->half_tile_size + self->priv->tile_dy;
	self->priv->size_minus_one = (gdouble) (new_size - 1);
	self->priv->font_size = new_size / 3.5;
	self->priv->north_number_y = new_size / 5.0;
	self->priv->south_number_y = (new_size * 4.0) / 5.0;
	self->priv->east_number_x = self->priv->south_number_y;
	self->priv->west_number_x = self->priv->north_number_y;
	self->priv->size = new_size;
}

static void
nostalgia_theme_real_set_animation_level (Theme* base,
                                          guint8 new_animation_level)
{
	NostalgiaTheme * self;
	self = (NostalgiaTheme*) base;
	self->priv->animation_level = new_animation_level;
	nostalgia_theme_configure_arrow (self, self->priv->size);
	nostalgia_theme_configure_socket (self, self->priv->size);
}

static void
nostalgia_theme_configure_arrow (NostalgiaTheme* self,
                                 guint new_size)
{
	g_return_if_fail (self != NULL);
	self->priv->arrow_half_h = new_size * 0.75;
	self->priv->neg_arrow_half_h = -self->priv->arrow_half_h;
	self->priv->arrow_depth = MIN (new_size * 0.025, 2.0) - (((gdouble) self->priv->animation_level) / 6.0);
	self->priv->arrow_depth = MAX (self->priv->arrow_depth, 0.0);
	self->priv->arrow_dx = G_SQRT2 * self->priv->arrow_depth;
	self->priv->arrow_dy = self->priv->arrow_half_h - (6.1623 * self->priv->arrow_depth);
	self->priv->neg_arrow_dy = -self->priv->arrow_dy;
	self->priv->arrow_w = (new_size * PUZZLE_VIEW_gap_factor) * 0.5;
	self->priv->arrow_x = ((new_size * PUZZLE_VIEW_gap_factor) - self->priv->arrow_w) * 0.5;
	self->priv->arrow_w_minus_depth = self->priv->arrow_w - self->priv->arrow_depth;
}

static void
nostalgia_theme_configure_socket (NostalgiaTheme* self,
                                  guint new_size)
{
	g_return_if_fail (self != NULL);
	self->priv->socket_depth = MIN (new_size * 0.05, 4.0) - (((gdouble) self->priv->animation_level) / 4.0);
	self->priv->socket_depth = MAX (self->priv->socket_depth, 0.0);
	self->priv->size_minus_socket_depth = ((gdouble) new_size) - self->priv->socket_depth;
	self->priv->size_minus_two_socket_depths = ((gdouble) new_size) - (self->priv->socket_depth * 2.0);
}

static void
nostalgia_theme_real_draw_arrow (Theme* base,
                                 cairo_t* context)
{
	NostalgiaTheme * self;
	self = (NostalgiaTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_translate (context, self->priv->arrow_x, 0.0);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.125);
	} else {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, (0.125 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
	cairo_move_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_line_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, self->priv->arrow_w_minus_depth, self->priv->arrow_dy);
	cairo_line_to (context, self->priv->arrow_w_minus_depth, self->priv->neg_arrow_dy);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.6, 0.6, 0.5, 0.125);
	} else {
		cairo_set_source_rgba (context, 0.6, 0.6, 0.5, (0.125 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
	cairo_move_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_line_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, self->priv->arrow_w_minus_depth, self->priv->arrow_dy);
	cairo_line_to (context, self->priv->arrow_dx, 0.0);
	cairo_line_to (context, self->priv->arrow_w_minus_depth, self->priv->neg_arrow_dy);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	} else {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, (0.25 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
}

static void
nostalgia_theme_real_draw_socket (Theme* base,
                                  cairo_t* context)
{
	NostalgiaTheme * self;
	self = (NostalgiaTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_rectangle (context, self->priv->socket_depth, self->priv->socket_depth, self->priv->size_minus_two_socket_depths, self->priv->size_minus_two_socket_depths);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.125);
	} else {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, (0.125 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
	cairo_move_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, self->priv->size_minus_socket_depth, self->priv->socket_depth);
	cairo_line_to (context, self->priv->size_minus_socket_depth, self->priv->size_minus_socket_depth);
	cairo_line_to (context, self->priv->socket_depth, self->priv->size_minus_socket_depth);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.6, 0.6, 0.5, 0.125);
	} else {
		cairo_set_source_rgba (context, 0.6, 0.6, 0.5, (0.125 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, 0.0, 0.0);
	cairo_line_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->socket_depth, self->priv->size_minus_socket_depth);
	cairo_line_to (context, self->priv->socket_depth, self->priv->socket_depth);
	cairo_line_to (context, self->priv->size_minus_socket_depth, self->priv->socket_depth);
	cairo_close_path (context);
	if (((gint) self->priv->animation_level) == 0) {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	} else {
		cairo_set_source_rgba (context, 0.0, 0.0, 0.0, (0.25 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0);
	}
	cairo_fill (context);
}

static void
nostalgia_theme_real_draw_highlight (Theme* base,
                                     cairo_t* context,
                                     gboolean has_tile)
{
	NostalgiaTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (NostalgiaTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->highlight_tile_pattern;
	cairo_set_source (context, _tmp0_);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_fill (context);
}

static void
nostalgia_theme_real_draw_paused_tile (Theme* base,
                                       cairo_t* context)
{
	NostalgiaTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	self = (NostalgiaTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->paused_color;
	_tmp1_ = self->priv->paused_color;
	_tmp2_ = self->priv->paused_color;
	_tmp3_ = self->priv->paused_color;
	nostalgia_theme_draw_tile_background (self, context, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}

static void
nostalgia_theme_real_draw_tile (Theme* base,
                                cairo_t* context,
                                Tile* tile,
                                gboolean highlight)
{
	NostalgiaTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	self = (NostalgiaTheme*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->tile_colors[tile->north];
	_tmp1_ = self->priv->tile_colors[tile->east];
	_tmp2_ = self->priv->tile_colors[tile->south];
	_tmp3_ = self->priv->tile_colors[tile->west];
	nostalgia_theme_draw_tile_background (self, context, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	cairo_select_font_face (context, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, self->priv->font_size);
	_tmp4_ = self->priv->text_colors[tile->north];
	nostalgia_theme_draw_number (context, _tmp4_, self->priv->half_tile_size, self->priv->north_number_y, tile->north);
	_tmp5_ = self->priv->text_colors[tile->south];
	nostalgia_theme_draw_number (context, _tmp5_, self->priv->half_tile_size, self->priv->south_number_y, tile->south);
	_tmp6_ = self->priv->text_colors[tile->east];
	nostalgia_theme_draw_number (context, _tmp6_, self->priv->east_number_x, self->priv->half_tile_size, tile->east);
	_tmp7_ = self->priv->text_colors[tile->west];
	nostalgia_theme_draw_number (context, _tmp7_, self->priv->west_number_x, self->priv->half_tile_size, tile->west);
	if (highlight) {
		cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.3);
		cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, (gdouble) self->priv->size);
		cairo_fill (context);
	}
}

static void
nostalgia_theme_draw_tile_background (NostalgiaTheme* self,
                                      cairo_t* context,
                                      cairo_pattern_t* north_color,
                                      cairo_pattern_t* east_color,
                                      cairo_pattern_t* south_color,
                                      cairo_pattern_t* west_color)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (north_color != NULL);
	g_return_if_fail (east_color != NULL);
	g_return_if_fail (south_color != NULL);
	g_return_if_fail (west_color != NULL);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, self->priv->half_tile_size);
	cairo_set_source (context, north_color);
	cairo_fill (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, self->priv->size_minus_tile_dx, self->priv->tile_depth);
	cairo_line_to (context, self->priv->tile_dx, self->priv->tile_depth);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size_minus_dy);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.125);
	cairo_fill (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size_minus_dy);
	cairo_line_to (context, self->priv->size_minus_tile_dx, self->priv->tile_depth);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	cairo_fill (context);
	cairo_rectangle (context, 0.0, self->priv->half_tile_size, (gdouble) self->priv->size, self->priv->half_tile_size);
	cairo_set_source (context, south_color);
	cairo_fill (context);
	cairo_move_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->tile_dx, self->priv->size_minus_tile_depth);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size_plus_dy);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.125);
	cairo_fill (context);
	cairo_move_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size_plus_dy);
	cairo_line_to (context, self->priv->size_minus_tile_dx, self->priv->size_minus_tile_depth);
	cairo_line_to (context, self->priv->tile_dx, self->priv->size_minus_tile_depth);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	cairo_fill (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source (context, east_color);
	cairo_fill (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->size_minus_tile_depth, self->priv->size_minus_tile_dx);
	cairo_line_to (context, self->priv->half_tile_size_plus_dy, self->priv->half_tile_size);
	cairo_line_to (context, self->priv->size_minus_tile_depth, self->priv->tile_dx);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.125);
	cairo_fill (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->size_minus_tile_depth, self->priv->size_minus_tile_dx);
	cairo_line_to (context, self->priv->size_minus_tile_depth, self->priv->tile_dx);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	cairo_fill (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source (context, west_color);
	cairo_fill (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->tile_depth, self->priv->size_minus_tile_dx);
	cairo_line_to (context, self->priv->tile_depth, self->priv->tile_dx);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.125);
	cairo_fill (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_line_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->tile_depth, self->priv->size_minus_tile_dx);
	cairo_line_to (context, self->priv->half_tile_size_minus_dy, self->priv->half_tile_size);
	cairo_line_to (context, self->priv->tile_depth, self->priv->tile_dx);
	cairo_close_path (context);
	cairo_set_source_rgba (context, 0.0, 0.0, 0.0, 0.25);
	cairo_fill (context);
	cairo_set_line_width (context, 1.0);
	cairo_set_source_rgb (context, 0.0, 0.0, 0.0);
	cairo_rectangle (context, 0.5, 0.5, self->priv->size_minus_one, self->priv->size_minus_one);
	cairo_stroke (context);
}

static void
nostalgia_theme_draw_number (cairo_t* context,
                             cairo_pattern_t* text_color,
                             gdouble x,
                             gdouble y,
                             guint8 number)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (text_color != NULL);
	cairo_set_source (context, text_color);
	_tmp0_ = g_strdup_printf ("%hu", (gushort) number);
	text = _tmp0_;
	cairo_text_extents (context, text, &_tmp1_);
	extents = _tmp1_;
	_tmp2_ = extents;
	_tmp3_ = extents;
	cairo_move_to (context, x - (_tmp2_.width / 2.0), y + (_tmp3_.height / 2.0));
	cairo_show_text (context, text);
	_g_free0 (text);
}

NostalgiaTheme*
nostalgia_theme_construct (GType object_type)
{
	NostalgiaTheme * self = NULL;
	self = (NostalgiaTheme*) theme_construct (object_type);
	return self;
}

NostalgiaTheme*
nostalgia_theme_new (void)
{
	return nostalgia_theme_construct (TYPE_NOSTALGIA_THEME);
}

static GObject *
nostalgia_theme_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NostalgiaTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	cairo_pattern_t* _tmp13_;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_pattern_t* _tmp17_;
	cairo_pattern_t* _tmp18_;
	cairo_pattern_t* _tmp19_;
	cairo_pattern_t* _tmp20_;
	parent_class = G_OBJECT_CLASS (nostalgia_theme_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOSTALGIA_THEME, NostalgiaTheme);
	_tmp0_ = nostalgia_theme_make_color_pattern ("000000");
	_cairo_pattern_destroy0 (self->priv->tile_colors[0]);
	self->priv->tile_colors[0] = _tmp0_;
	_tmp1_ = nostalgia_theme_make_color_pattern ("C17D11");
	_cairo_pattern_destroy0 (self->priv->tile_colors[1]);
	self->priv->tile_colors[1] = _tmp1_;
	_tmp2_ = nostalgia_theme_make_color_pattern ("CC0000");
	_cairo_pattern_destroy0 (self->priv->tile_colors[2]);
	self->priv->tile_colors[2] = _tmp2_;
	_tmp3_ = nostalgia_theme_make_color_pattern ("F57900");
	_cairo_pattern_destroy0 (self->priv->tile_colors[3]);
	self->priv->tile_colors[3] = _tmp3_;
	_tmp4_ = nostalgia_theme_make_color_pattern ("EDD400");
	_cairo_pattern_destroy0 (self->priv->tile_colors[4]);
	self->priv->tile_colors[4] = _tmp4_;
	_tmp5_ = nostalgia_theme_make_color_pattern ("73D216");
	_cairo_pattern_destroy0 (self->priv->tile_colors[5]);
	self->priv->tile_colors[5] = _tmp5_;
	_tmp6_ = nostalgia_theme_make_color_pattern ("3465A4");
	_cairo_pattern_destroy0 (self->priv->tile_colors[6]);
	self->priv->tile_colors[6] = _tmp6_;
	_tmp7_ = nostalgia_theme_make_color_pattern ("75507B");
	_cairo_pattern_destroy0 (self->priv->tile_colors[7]);
	self->priv->tile_colors[7] = _tmp7_;
	_tmp8_ = nostalgia_theme_make_color_pattern ("BABDB6");
	_cairo_pattern_destroy0 (self->priv->tile_colors[8]);
	self->priv->tile_colors[8] = _tmp8_;
	_tmp9_ = nostalgia_theme_make_color_pattern ("FFFFFF");
	_cairo_pattern_destroy0 (self->priv->tile_colors[9]);
	self->priv->tile_colors[9] = _tmp9_;
	_tmp10_ = nostalgia_theme_make_color_pattern ("CCCCCC");
	_cairo_pattern_destroy0 (self->priv->paused_color);
	self->priv->paused_color = _tmp10_;
	_tmp11_ = self->priv->white_text_color;
	self->priv->text_colors[0] = _tmp11_;
	_tmp12_ = self->priv->white_text_color;
	self->priv->text_colors[1] = _tmp12_;
	_tmp13_ = self->priv->white_text_color;
	self->priv->text_colors[2] = _tmp13_;
	_tmp14_ = self->priv->white_text_color;
	self->priv->text_colors[3] = _tmp14_;
	_tmp15_ = self->priv->black_text_color;
	self->priv->text_colors[4] = _tmp15_;
	_tmp16_ = self->priv->black_text_color;
	self->priv->text_colors[5] = _tmp16_;
	_tmp17_ = self->priv->white_text_color;
	self->priv->text_colors[6] = _tmp17_;
	_tmp18_ = self->priv->white_text_color;
	self->priv->text_colors[7] = _tmp18_;
	_tmp19_ = self->priv->black_text_color;
	self->priv->text_colors[8] = _tmp19_;
	_tmp20_ = self->priv->black_text_color;
	self->priv->text_colors[9] = _tmp20_;
	return obj;
}

static void
nostalgia_theme_class_init (NostalgiaThemeClass * klass,
                            gpointer klass_data)
{
	nostalgia_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NostalgiaTheme_private_offset);
	((ThemeClass *) klass)->configure = (void (*) (Theme*, guint)) nostalgia_theme_real_configure;
	((ThemeClass *) klass)->set_animation_level = (void (*) (Theme*, guint8)) nostalgia_theme_real_set_animation_level;
	((ThemeClass *) klass)->draw_arrow = (void (*) (Theme*, cairo_t*)) nostalgia_theme_real_draw_arrow;
	((ThemeClass *) klass)->draw_socket = (void (*) (Theme*, cairo_t*)) nostalgia_theme_real_draw_socket;
	((ThemeClass *) klass)->draw_highlight = (void (*) (Theme*, cairo_t*, gboolean)) nostalgia_theme_real_draw_highlight;
	((ThemeClass *) klass)->draw_paused_tile = (void (*) (Theme*, cairo_t*)) nostalgia_theme_real_draw_paused_tile;
	((ThemeClass *) klass)->draw_tile = (void (*) (Theme*, cairo_t*, Tile*, gboolean)) nostalgia_theme_real_draw_tile;
	G_OBJECT_CLASS (klass)->constructor = nostalgia_theme_constructor;
	G_OBJECT_CLASS (klass)->finalize = nostalgia_theme_finalize;
}

static void
nostalgia_theme_instance_init (NostalgiaTheme * self,
                               gpointer klass)
{
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	self->priv = nostalgia_theme_get_instance_private (self);
	_tmp0_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
	self->priv->black_text_color = _tmp0_;
	_tmp1_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
	self->priv->white_text_color = _tmp1_;
	self->priv->size = (guint) 0;
	self->priv->animation_level = (guint8) 0;
}

static void
nostalgia_theme_finalize (GObject * obj)
{
	NostalgiaTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOSTALGIA_THEME, NostalgiaTheme);
	_vala_array_destroy (self->priv->tile_colors, 10, (GDestroyNotify) cairo_pattern_destroy);
	_cairo_pattern_destroy0 (self->priv->paused_color);
	_cairo_pattern_destroy0 (self->priv->black_text_color);
	_cairo_pattern_destroy0 (self->priv->white_text_color);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	G_OBJECT_CLASS (nostalgia_theme_parent_class)->finalize (obj);
}

static GType
nostalgia_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NostalgiaThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nostalgia_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NostalgiaTheme), 0, (GInstanceInitFunc) nostalgia_theme_instance_init, NULL };
	GType nostalgia_theme_type_id;
	nostalgia_theme_type_id = g_type_register_static (TYPE_THEME, "NostalgiaTheme", &g_define_type_info, 0);
	NostalgiaTheme_private_offset = g_type_add_instance_private (nostalgia_theme_type_id, sizeof (NostalgiaThemePrivate));
	return nostalgia_theme_type_id;
}

GType
nostalgia_theme_get_type (void)
{
	static volatile gsize nostalgia_theme_type_id__once = 0;
	if (g_once_init_enter (&nostalgia_theme_type_id__once)) {
		GType nostalgia_theme_type_id;
		nostalgia_theme_type_id = nostalgia_theme_get_type_once ();
		g_once_init_leave (&nostalgia_theme_type_id__once, nostalgia_theme_type_id);
	}
	return nostalgia_theme_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

