/* gpx-parser-fit.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-parser-fit.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2013-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define _XOPEN_SOURCE

#include "gpx.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <stdio.h>

#define GPX_FIT_FILE_MAX_LOCAL_DEFINITIONS 16
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GPX_FIT_FILE_TYPE_FIELD_DEFINITION (gpx_fit_file_field_definition_get_type ())
typedef struct _GpxFitFileFieldDefinition GpxFitFileFieldDefinition;

#define GPX_FIT_FILE_TYPE_FIELD_DEFINITION_HEADER (gpx_fit_file_field_definition_header_get_type ())
typedef struct _GpxFitFileFieldDefinitionHeader GpxFitFileFieldDefinitionHeader;
enum  {
	GPX_FIT_FILE_0_PROPERTY,
	GPX_FIT_FILE_NUM_PROPERTIES
};
static GParamSpec* gpx_fit_file_properties[GPX_FIT_FILE_NUM_PROPERTIES];
typedef enum  {
	GPX_FIT_FILE_FIT_TYPES_LAP = 19,
	GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY = 20
} GpxFitFileFitTypes;

#define GPX_FIT_FILE_TYPE_FIT_TYPES (gpx_fit_file_fit_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GpxFitFileFieldDefinitionHeader {
	guint8 def_num;
	guint8 size;
	guint8 base_type;
};

struct _GpxFitFileFieldDefinition {
	gboolean endian;
	guint16 type;
	GpxFitFileFieldDefinitionHeader* fields;
	gint fields_length1;
	gint _fields_size_;
};

struct _GpxFitFilePrivate {
	GpxTrack* track;
	guint32 data_length;
	GpxFitFileFieldDefinition* defs;
	gint defs_length1;
	gint _defs_size_;
};

static gint GpxFitFile_private_offset;
static gpointer gpx_fit_file_parent_class = NULL;

static GType gpx_fit_file_field_definition_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType gpx_fit_file_field_definition_header_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GpxFitFileFieldDefinitionHeader* gpx_fit_file_field_definition_header_dup (const GpxFitFileFieldDefinitionHeader* self);
static void gpx_fit_file_field_definition_header_free (GpxFitFileFieldDefinitionHeader* self);
static GpxFitFileFieldDefinition* gpx_fit_file_field_definition_dup (const GpxFitFileFieldDefinition* self);
static void gpx_fit_file_field_definition_free (GpxFitFileFieldDefinition* self);
static void gpx_fit_file_field_definition_copy (const GpxFitFileFieldDefinition* self,
                                         GpxFitFileFieldDefinition* dest);
static void gpx_fit_file_field_definition_destroy (GpxFitFileFieldDefinition* self);
static GType gpx_fit_file_fit_types_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _vala_GpxFitFileFieldDefinition_array_free (GpxFitFileFieldDefinition * array,
                                                 gssize array_length);
static GpxFitFileFieldDefinition* gpx_fit_file_get_field_def (GpxFitFile* self,
                                                       guint id);
static void gpx_fit_file_parse_apply_definition_endian (GpxFitFile* self,
                                                 GDataInputStream* fs,
                                                 GpxFitFileFieldDefinition* def);
static void gpx_fit_file_parse_header (GpxFitFile* self,
                                GDataInputStream* fs,
                                GError** error);
static gboolean gpx_fit_file_parse_record (GpxFitFile* self,
                                    GDataInputStream* fs);
static void gpx_fit_file_parse_definition_record (GpxFitFile* self,
                                           GDataInputStream* fs,
                                           guint8 local_message_type,
                                           GError** error);
static void gpx_fit_file_parse_data_record (GpxFitFile* self,
                                     GDataInputStream* fs,
                                     guint8 local_message_type,
                                     GError** error);
static guint32 gpx_fit_file_parse_field (GpxFitFile* self,
                                  GpxFitFileFieldDefinitionHeader* field,
                                  GDataInputStream* fp,
                                  GError** error);
static void gpx_fit_file_parse_data_record_lap (GpxFitFile* self,
                                         GDataInputStream* fs,
                                         GpxFitFileFieldDefinition* def,
                                         GError** error);
static void gpx_fit_file_parse_data_record_activity_summary (GpxFitFile* self,
                                                      GDataInputStream* fs,
                                                      GpxFitFileFieldDefinition* def,
                                                      GError** error);
static GpxFitFileFieldDefinitionHeader* _vala_array_dup1 (GpxFitFileFieldDefinitionHeader* self,
                                                   gssize length);
static void gpx_fit_file_finalize (GObject * obj);
static GType gpx_fit_file_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gpx_fit_file_get_instance_private (GpxFitFile* self)
{
	return G_STRUCT_MEMBER_P (self, GpxFitFile_private_offset);
}

static GType
gpx_fit_file_fit_types_get_type_once (void)
{
	static const GEnumValue values[] = {{GPX_FIT_FILE_FIT_TYPES_LAP, "GPX_FIT_FILE_FIT_TYPES_LAP", "lap"}, {GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY, "GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY", "activity-summary"}, {0, NULL, NULL}};
	GType gpx_fit_file_fit_types_type_id;
	gpx_fit_file_fit_types_type_id = g_enum_register_static ("GpxFitFileFitTypes", values);
	return gpx_fit_file_fit_types_type_id;
}

static GType
gpx_fit_file_fit_types_get_type (void)
{
	static volatile gsize gpx_fit_file_fit_types_type_id__once = 0;
	if (g_once_init_enter (&gpx_fit_file_fit_types_type_id__once)) {
		GType gpx_fit_file_fit_types_type_id;
		gpx_fit_file_fit_types_type_id = gpx_fit_file_fit_types_get_type_once ();
		g_once_init_leave (&gpx_fit_file_fit_types_type_id__once, gpx_fit_file_fit_types_type_id);
	}
	return gpx_fit_file_fit_types_type_id__once;
}

static void
_vala_GpxFitFileFieldDefinition_array_free (GpxFitFileFieldDefinition * array,
                                            gssize array_length)
{
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (array != NULL) {
#line 175 "gpx-parser-fit.c"
		gssize i;
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_fit_file_field_definition_destroy (&array[i]);
#line 181 "gpx-parser-fit.c"
		}
	}
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	g_free (array);
#line 186 "gpx-parser-fit.c"
}

/**
         * Get the field description belonging to the id.
         */
static GpxFitFileFieldDefinition*
gpx_fit_file_get_field_def (GpxFitFile* self,
                            guint id)
{
	GpxFitFileFieldDefinition* _tmp0_;
	gint _tmp0__length1;
	GpxFitFileFieldDefinition* result;
#line 53 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (id >= ((guint) GPX_FIT_FILE_MAX_LOCAL_DEFINITIONS)) {
#line 53 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_error ("gpx-parser-fit.vala:53: To many local definitions specified.");
#line 203 "gpx-parser-fit.c"
	}
#line 54 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = self->priv->defs;
#line 54 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0__length1 = self->priv->defs_length1;
#line 54 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	result = &_tmp0_[id];
#line 54 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return result;
#line 213 "gpx-parser-fit.c"
}

/**
         * Depending on the definition, switch endianess
         */
static void
gpx_fit_file_parse_apply_definition_endian (GpxFitFile* self,
                                            GDataInputStream* fs,
                                            GpxFitFileFieldDefinition* def)
{
#line 62 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if ((*def).endian) {
#line 63 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_data_input_stream_set_byte_order (fs, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
#line 228 "gpx-parser-fit.c"
	} else {
#line 65 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_data_input_stream_set_byte_order (fs, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
#line 232 "gpx-parser-fit.c"
	}
}

/**
         * Parse the file.
         */
static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return self ? g_object_ref (self) : NULL;
#line 244 "gpx-parser-fit.c"
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 105 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return self ? g_error_copy (self) : NULL;
#line 252 "gpx-parser-fit.c"
}

GpxFitFile*
gpx_fit_file_construct (GType object_type,
                        GFile* file,
                        GError** error)
{
	GpxFitFile * self = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 72 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self = (GpxFitFile*) gpx_file_base_construct (object_type);
#line 75 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 75 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_g_object_unref0 (((GpxFileBase*) self)->file);
#line 75 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	((GpxFileBase*) self)->file = _tmp0_;
#line 271 "gpx-parser-fit.c"
	{
		GFileInputStream* istr = NULL;
		GFileInputStream* _tmp1_;
		GDataInputStream* fs = NULL;
		GFileInputStream* _tmp2_;
		GDataInputStream* _tmp3_;
		GDataInputStream* _tmp4_;
		GDataInputStream* _tmp6_;
		GDataInputStream* _tmp8_;
		GpxTrack* _tmp10_;
#line 77 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp1_ = g_file_read (file, NULL, &_inner_error0_);
#line 77 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		istr = _tmp1_;
#line 77 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 77 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 290 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
#line 79 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp2_ = istr;
#line 79 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
#line 79 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		fs = _tmp3_;
#line 80 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp4_ = fs;
#line 80 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_tmp4_ == NULL) {
#line 305 "gpx-parser-fit.c"
			GError* _tmp5_;
#line 81 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp5_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, "Failed to create input stream.");
#line 81 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_inner_error0_ = _tmp5_;
#line 81 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_g_object_unref0 (fs);
#line 81 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_g_object_unref0 (istr);
#line 81 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 317 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
#line 84 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp6_ = fs;
#line 84 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (g_data_input_stream_get_byte_order (_tmp6_) != G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
#line 326 "gpx-parser-fit.c"
			GDataInputStream* _tmp7_;
#line 85 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp7_ = fs;
#line 85 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_data_input_stream_set_byte_order (_tmp7_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
#line 332 "gpx-parser-fit.c"
		}
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp8_ = fs;
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		gpx_fit_file_parse_header (self, _tmp8_, &_inner_error0_);
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_g_object_unref0 (fs);
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_g_object_unref0 (istr);
#line 90 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 346 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
#line 92 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		while (TRUE) {
#line 353 "gpx-parser-fit.c"
			GDataInputStream* _tmp9_;
#line 92 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp9_ = fs;
#line 92 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (!gpx_fit_file_parse_record (self, _tmp9_)) {
#line 92 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				break;
#line 361 "gpx-parser-fit.c"
			}
		}
#line 96 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp10_ = self->priv->track;
#line 96 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_tmp10_ != NULL) {
#line 368 "gpx-parser-fit.c"
			GpxTrack* _tmp11_;
			GpxTrack* _tmp12_;
			GpxTrack* _tmp13_;
#line 97 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp11_ = self->priv->track;
#line 97 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_track_filter_points (_tmp11_);
#line 98 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp12_ = self->priv->track;
#line 98 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 98 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp13_);
#line 382 "gpx-parser-fit.c"
		}
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_object_unref0 (fs);
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_object_unref0 (istr);
#line 388 "gpx-parser-fit.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GError* _tmp16_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		err = _inner_error0_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = NULL;
#line 101 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp14_ = err;
#line 101 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp15_ = _tmp14_->message;
#line 101 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp16_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, _tmp15_);
#line 101 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = _tmp16_;
#line 101 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_error_free0 (err);
#line 411 "gpx-parser-fit.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		err = _inner_error0_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = NULL;
#line 103 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp17_ = err;
#line 103 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp18_ = _tmp17_->message;
#line 103 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp19_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, _tmp18_);
#line 103 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = _tmp19_;
#line 103 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_error_free0 (err);
#line 435 "gpx-parser-fit.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_gpx_file_error:
	{
		GError* err = NULL;
		GError* _tmp20_;
		GError* _tmp21_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		err = _inner_error0_;
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = NULL;
#line 105 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp20_ = err;
#line 105 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp21_ = _g_error_copy0 (_tmp20_);
#line 105 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = _tmp21_;
#line 105 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_error_free0 (err);
#line 456 "gpx-parser-fit.c"
		goto __finally0;
	}
	__finally0:
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_g_object_unref0 (self);
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return NULL;
#line 470 "gpx-parser-fit.c"
		} else {
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 76 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return NULL;
#line 478 "gpx-parser-fit.c"
		}
	}
#line 72 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return self;
#line 483 "gpx-parser-fit.c"
}

GpxFitFile*
gpx_fit_file_new (GFile* file,
                  GError** error)
{
#line 72 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return gpx_fit_file_construct (GPX_TYPE_FIT_FILE, file, error);
#line 492 "gpx-parser-fit.c"
}

/**
         * Parse record
         */
static gboolean
gpx_fit_file_parse_record (GpxFitFile* self,
                           GDataInputStream* fs)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		guint8 record_id = 0U;
		gboolean normal_header = FALSE;
		gboolean definition_header = FALSE;
		guint8 local_message_type = 0U;
#line 115 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (self->priv->data_length == ((guint32) 0)) {
#line 115 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			result = FALSE;
#line 115 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return result;
#line 515 "gpx-parser-fit.c"
		}
#line 116 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		record_id = g_data_input_stream_read_byte (fs, NULL, &_inner_error0_);
#line 116 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 521 "gpx-parser-fit.c"
			goto __catch0_g_error;
		}
#line 117 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		self->priv->data_length = self->priv->data_length - 1;
#line 120 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		normal_header = ((gint) (record_id & 0x80)) == 0;
#line 125 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (normal_header) {
#line 127 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			definition_header = ((gint) (record_id & 0x40)) > 0;
#line 128 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			local_message_type = record_id & 0x0F;
#line 534 "gpx-parser-fit.c"
		} else {
#line 133 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			definition_header = FALSE;
#line 135 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			local_message_type = (guint8) ((record_id & 0x60) >> 5);
#line 540 "gpx-parser-fit.c"
		}
#line 140 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (definition_header) {
#line 141 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_fit_file_parse_definition_record (self, fs, local_message_type, &_inner_error0_);
#line 141 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 548 "gpx-parser-fit.c"
				goto __catch0_g_error;
			}
		} else {
#line 143 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_fit_file_parse_data_record (self, fs, local_message_type, &_inner_error0_);
#line 143 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 556 "gpx-parser-fit.c"
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 114 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_clear_error (&_inner_error0_);
#line 146 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		result = FALSE;
#line 146 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		return result;
#line 570 "gpx-parser-fit.c"
	}
	__finally0:
#line 114 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 575 "gpx-parser-fit.c"
		gboolean _tmp0_ = FALSE;
#line 114 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 114 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		g_clear_error (&_inner_error0_);
#line 114 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		return _tmp0_;
#line 583 "gpx-parser-fit.c"
	}
#line 148 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	result = TRUE;
#line 148 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return result;
#line 589 "gpx-parser-fit.c"
}

static void
gpx_fit_file_parse_definition_record (GpxFitFile* self,
                                      GDataInputStream* fs,
                                      guint8 local_message_type,
                                      GError** error)
{
	GpxFitFileFieldDefinition* def = NULL;
	GpxFitFileFieldDefinition* _tmp0_;
	guint8 endian = 0U;
	GpxFitFileFieldDefinition* _tmp1_;
	guint16 _tmp2_ = 0U;
	guint8 num_fields = 0U;
	GpxFitFileFieldDefinitionHeader* _tmp3_;
	GError* _inner_error0_ = NULL;
#line 153 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = gpx_fit_file_get_field_def (self, (guint) local_message_type);
#line 153 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	def = _tmp0_;
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	g_input_stream_skip ((GInputStream*) fs, (gsize) 1, NULL, &_inner_error0_);
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 620 "gpx-parser-fit.c"
		} else {
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 156 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 628 "gpx-parser-fit.c"
		}
	}
#line 157 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->data_length = self->priv->data_length - 1;
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	endian = g_data_input_stream_read_byte (fs, NULL, &_inner_error0_);
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 643 "gpx-parser-fit.c"
		} else {
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 160 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 651 "gpx-parser-fit.c"
		}
	}
#line 161 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->data_length = self->priv->data_length - 1;
#line 162 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (((gint) endian) == 1) {
#line 163 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		(*def).endian = TRUE;
#line 660 "gpx-parser-fit.c"
	} else {
#line 165 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		(*def).endian = FALSE;
#line 664 "gpx-parser-fit.c"
	}
#line 168 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp1_ = def;
#line 168 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	gpx_fit_file_parse_apply_definition_endian (self, fs, _tmp1_);
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp2_ = g_data_input_stream_read_uint16 (fs, NULL, &_inner_error0_);
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 680 "gpx-parser-fit.c"
		} else {
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 688 "gpx-parser-fit.c"
		}
	}
#line 170 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*def).type = _tmp2_;
#line 171 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->data_length = self->priv->data_length - 2;
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	num_fields = g_data_input_stream_read_byte (fs, NULL, &_inner_error0_);
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 705 "gpx-parser-fit.c"
		} else {
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 174 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 713 "gpx-parser-fit.c"
		}
	}
#line 175 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->data_length = self->priv->data_length - 1;
#line 176 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp3_ = g_new0 (GpxFitFileFieldDefinitionHeader, num_fields);
#line 176 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*def).fields = (g_free ((*def).fields), NULL);
#line 176 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*def).fields = _tmp3_;
#line 176 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*def).fields_length1 = num_fields;
#line 176 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*def)._fields_size_ = (*def).fields_length1;
#line 728 "gpx-parser-fit.c"
	{
		guint8 field = 0U;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		field = (guint8) 0;
#line 733 "gpx-parser-fit.c"
		{
			gboolean _tmp4_ = FALSE;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp4_ = TRUE;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			while (TRUE) {
#line 740 "gpx-parser-fit.c"
				GpxFitFileFieldDefinitionHeader* header = NULL;
				guint8* temp = NULL;
				guint8* _tmp6_;
				gint temp_length1;
				gint _temp_size_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				guint8* _tmp8_;
				gint _tmp8__length1;
				GpxFitFileFieldDefinition* _tmp9_;
				GpxFitFileFieldDefinitionHeader* _tmp10_;
				gint _tmp10__length1;
				GpxFitFileFieldDefinitionHeader* _tmp11_;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (!_tmp4_) {
#line 756 "gpx-parser-fit.c"
					guint8 _tmp5_;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					_tmp5_ = field;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					field = _tmp5_ + 1;
#line 762 "gpx-parser-fit.c"
				}
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp4_ = FALSE;
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (!(field < num_fields)) {
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					break;
#line 770 "gpx-parser-fit.c"
				}
#line 179 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp6_ = g_new0 (guint8, sizeof (GpxFitFileFieldDefinitionHeader));
#line 179 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				temp = _tmp6_;
#line 179 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				temp_length1 = sizeof (GpxFitFileFieldDefinitionHeader);
#line 179 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_temp_size_ = temp_length1;
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp7_ = temp;
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp7__length1 = temp_length1;
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				g_input_stream_read ((GInputStream*) fs, _tmp7_, (gsize) _tmp7__length1, NULL, &_inner_error0_);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_propagate_error (error, _inner_error0_);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						temp = (g_free (temp), NULL);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						return;
#line 796 "gpx-parser-fit.c"
					} else {
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						temp = (g_free (temp), NULL);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_clear_error (&_inner_error0_);
#line 180 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						return;
#line 806 "gpx-parser-fit.c"
					}
				}
#line 181 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp8_ = temp;
#line 181 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp8__length1 = temp_length1;
#line 181 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				header = (GpxFitFileFieldDefinitionHeader*) (&_tmp8_[0]);
#line 182 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp9_ = def;
#line 182 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp10_ = (*_tmp9_).fields;
#line 182 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp10__length1 = (*_tmp9_).fields_length1;
#line 182 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp11_ = header;
#line 182 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp10_[field] = *_tmp11_;
#line 183 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				self->priv->data_length = self->priv->data_length - ((guint32) sizeof (GpxFitFileFieldDefinitionHeader));
#line 177 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				temp = (g_free (temp), NULL);
#line 829 "gpx-parser-fit.c"
			}
		}
	}
}

static guint32
gpx_fit_file_parse_field (GpxFitFile* self,
                          GpxFitFileFieldDefinitionHeader* field,
                          GDataInputStream* fp,
                          GError** error)
{
	guint32 retv = 0U;
	GpxFitFileFieldDefinitionHeader _tmp0_;
	GError* _inner_error0_ = NULL;
	guint32 result;
#line 188 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	retv = (guint32) 0;
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = *field;
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	switch (_tmp0_.base_type) {
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 1:
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 2:
#line 855 "gpx-parser-fit.c"
		{
			guint8 _tmp1_ = 0U;
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp1_ = g_data_input_stream_read_byte (fp, NULL, &_inner_error0_);
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 864 "gpx-parser-fit.c"
					guint32 _tmp2_ = 0U;
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp2_;
#line 870 "gpx-parser-fit.c"
				} else {
					guint32 _tmp3_ = 0U;
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp3_;
#line 879 "gpx-parser-fit.c"
				}
			}
#line 193 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			retv = (guint32) _tmp1_;
#line 194 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			self->priv->data_length = self->priv->data_length - 1;
#line 195 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 888 "gpx-parser-fit.c"
		}
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 0x83:
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 0x84:
#line 894 "gpx-parser-fit.c"
		{
			guint16 _tmp4_ = 0U;
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp4_ = g_data_input_stream_read_uint16 (fp, NULL, &_inner_error0_);
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 903 "gpx-parser-fit.c"
					guint32 _tmp5_ = 0U;
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp5_;
#line 909 "gpx-parser-fit.c"
				} else {
					guint32 _tmp6_ = 0U;
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp6_;
#line 918 "gpx-parser-fit.c"
				}
			}
#line 198 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			retv = (guint32) _tmp4_;
#line 199 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			self->priv->data_length = self->priv->data_length - 2;
#line 200 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 927 "gpx-parser-fit.c"
		}
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 0x85:
#line 190 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case 0x86:
#line 933 "gpx-parser-fit.c"
		{
			guint32 _tmp7_ = 0U;
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp7_ = g_data_input_stream_read_uint32 (fp, NULL, &_inner_error0_);
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 942 "gpx-parser-fit.c"
					guint32 _tmp8_ = 0U;
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp8_;
#line 948 "gpx-parser-fit.c"
				} else {
					guint32 _tmp9_ = 0U;
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp9_;
#line 957 "gpx-parser-fit.c"
				}
			}
#line 203 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			retv = _tmp7_;
#line 204 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			self->priv->data_length = self->priv->data_length - 4;
#line 205 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 966 "gpx-parser-fit.c"
		}
		default:
		{
			GpxFitFileFieldDefinitionHeader _tmp10_;
			GpxFitFileFieldDefinitionHeader _tmp13_;
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp10_ = *field;
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_input_stream_skip ((GInputStream*) fp, (gsize) _tmp10_.size, NULL, &_inner_error0_);
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 980 "gpx-parser-fit.c"
					guint32 _tmp11_ = 0U;
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp11_;
#line 986 "gpx-parser-fit.c"
				} else {
					guint32 _tmp12_ = 0U;
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 207 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return _tmp12_;
#line 995 "gpx-parser-fit.c"
				}
			}
#line 208 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp13_ = *field;
#line 208 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			self->priv->data_length = self->priv->data_length - _tmp13_.size;
#line 209 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 1004 "gpx-parser-fit.c"
		}
	}
#line 211 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	result = retv;
#line 211 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return result;
#line 1011 "gpx-parser-fit.c"
}

static void
gpx_fit_file_parse_data_record_lap (GpxFitFile* self,
                                    GDataInputStream* fs,
                                    GpxFitFileFieldDefinition* def,
                                    GError** error)
{
	GpxFitFileFieldDefinitionHeader* _tmp0_;
	gint _tmp0__length1;
	GpxTrack* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = (*def).fields;
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0__length1 = (*def).fields_length1;
#line 1028 "gpx-parser-fit.c"
	{
		GpxFitFileFieldDefinitionHeader* field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		field_collection = _tmp0_;
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		field_collection_length1 = _tmp0__length1;
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
#line 1040 "gpx-parser-fit.c"
			GpxFitFileFieldDefinitionHeader field = {0};
#line 216 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			field = field_collection[field_it];
#line 1044 "gpx-parser-fit.c"
			{
				GpxFitFileFieldDefinitionHeader _tmp1_;
#line 217 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp1_ = field;
#line 217 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				switch (_tmp1_.def_num) {
#line 217 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 11:
#line 1053 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp2_;
						GpxTrack* _tmp3_;
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp2_ = field;
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp2_, fs, &_inner_error0_);
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1070 "gpx-parser-fit.c"
							} else {
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 220 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1078 "gpx-parser-fit.c"
							}
						}
#line 221 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp3_ = self->priv->track;
#line 221 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp3_->hrmt.calories = val;
#line 222 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1087 "gpx-parser-fit.c"
					}
#line 217 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 15:
#line 1091 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp4_;
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp4_ = field;
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp4_, fs, &_inner_error0_);
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1107 "gpx-parser-fit.c"
							} else {
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 226 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1115 "gpx-parser-fit.c"
							}
						}
#line 227 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1120 "gpx-parser-fit.c"
					}
#line 217 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 16:
#line 1124 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp5_;
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp5_ = field;
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp5_, fs, &_inner_error0_);
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1140 "gpx-parser-fit.c"
							} else {
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 230 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1148 "gpx-parser-fit.c"
							}
						}
#line 231 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1153 "gpx-parser-fit.c"
					}
					default:
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp6_;
						GpxFitFileFieldDefinitionHeader _tmp7_;
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp6_ = field;
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp6_, fs, &_inner_error0_);
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1172 "gpx-parser-fit.c"
							} else {
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 233 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1180 "gpx-parser-fit.c"
							}
						}
#line 234 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp7_ = field;
#line 234 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_debug ("gpx-parser-fit.vala:234: %d %u", (gint) _tmp7_.def_num, (guint) val);
#line 235 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1189 "gpx-parser-fit.c"
					}
				}
			}
		}
	}
#line 239 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp8_ = self->priv->track;
#line 239 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (_tmp8_ != NULL) {
#line 1199 "gpx-parser-fit.c"
		GpxTrack* _tmp9_;
		GpxTrack* _tmp10_;
		GpxTrack* _tmp11_;
#line 240 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp9_ = self->priv->track;
#line 240 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		gpx_track_filter_points (_tmp9_);
#line 241 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp10_ = self->priv->track;
#line 241 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 241 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp11_);
#line 242 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_object_unref0 (self->priv->track);
#line 242 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		self->priv->track = NULL;
#line 1217 "gpx-parser-fit.c"
	}
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 3317 "glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 3317 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 3318 "glib-2.0.vapi"
	*result = _result_;
#line 3318 "glib-2.0.vapi"
	return;
#line 1235 "gpx-parser-fit.c"
}

static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gchar* result;
#line 3326 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 3326 "glib-2.0.vapi"
	buffer = _tmp0_;
#line 3326 "glib-2.0.vapi"
	buffer_length1 = 64;
#line 3326 "glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 3327 "glib-2.0.vapi"
	strftime (buffer, (gint) buffer_length1, format, &(*self));
#line 3328 "glib-2.0.vapi"
	_tmp1_ = g_strdup ((const gchar*) buffer);
#line 3328 "glib-2.0.vapi"
	result = _tmp1_;
#line 3328 "glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 3328 "glib-2.0.vapi"
	return result;
#line 1266 "gpx-parser-fit.c"
}

static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 313 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 1274 "gpx-parser-fit.c"
}

static void
gpx_fit_file_parse_data_record_activity_summary (GpxFitFile* self,
                                                 GDataInputStream* fs,
                                                 GpxFitFileFieldDefinition* def,
                                                 GError** error)
{
	GpxTrack* _tmp0_;
	GpxPoint* p = NULL;
	GpxPoint* _tmp2_;
	GpxFitFileFieldDefinitionHeader* _tmp3_;
	gint _tmp3__length1;
	GpxPoint* lastp = NULL;
	GpxTrack* _tmp24_;
	GpxPoint* _tmp25_;
	GpxPoint* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GpxPoint* _tmp28_;
	GpxPoint* _tmp31_;
	GError* _inner_error0_ = NULL;
#line 247 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = self->priv->track;
#line 247 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (_tmp0_ == NULL) {
#line 1300 "gpx-parser-fit.c"
		GpxTrack* _tmp1_;
#line 248 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp1_ = gpx_track_new ();
#line 248 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_object_unref0 (self->priv->track);
#line 248 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		self->priv->track = _tmp1_;
#line 1308 "gpx-parser-fit.c"
	}
#line 250 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp2_ = gpx_point_new ();
#line 250 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	p = _tmp2_;
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp3_ = (*def).fields;
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp3__length1 = (*def).fields_length1;
#line 1318 "gpx-parser-fit.c"
	{
		GpxFitFileFieldDefinitionHeader* field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		field_collection = _tmp3_;
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		field_collection_length1 = _tmp3__length1;
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
#line 1330 "gpx-parser-fit.c"
			GpxFitFileFieldDefinitionHeader field = {0};
#line 251 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			field = field_collection[field_it];
#line 1334 "gpx-parser-fit.c"
			{
				GpxFitFileFieldDefinitionHeader _tmp4_;
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp4_ = field;
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				switch (_tmp4_.def_num) {
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 253:
#line 1343 "gpx-parser-fit.c"
					{
						guint32 timestp = 0U;
						GpxFitFileFieldDefinitionHeader _tmp5_;
						struct tm t = {0};
						struct tm _tmp6_ = {0};
						gchar* str = NULL;
						gchar* _tmp7_;
						GpxPoint* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp5_ = field;
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						timestp = gpx_fit_file_parse_field (self, &_tmp5_, fs, &_inner_error0_);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1368 "gpx-parser-fit.c"
							} else {
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 255 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1378 "gpx-parser-fit.c"
							}
						}
#line 256 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						timestp = timestp + 631065600;
#line 257 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_time_local ((time_t) timestp, &_tmp6_);
#line 257 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						t = _tmp6_;
#line 258 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp7_ = g_time_format (&t, "%FT%T%z");
#line 258 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						str = _tmp7_;
#line 259 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp8_ = p;
#line 259 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp9_ = str;
#line 259 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp10_ = g_strdup (_tmp9_);
#line 259 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_g_free0 (_tmp8_->time);
#line 259 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp8_->time = _tmp10_;
#line 260 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_g_free0 (str);
#line 260 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1405 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 0:
#line 1409 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp11_;
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp11_ = field;
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp11_, fs, &_inner_error0_);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1427 "gpx-parser-fit.c"
							} else {
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 263 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1437 "gpx-parser-fit.c"
							}
						}
#line 264 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0x7FFFFFFF)) {
#line 1442 "gpx-parser-fit.c"
							gdouble lat_dec = 0.0;
							GpxPoint* _tmp12_;
#line 265 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							lat_dec = ((gdouble) val) * (180.0 / pow (2.0, 31.0));
#line 266 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp12_ = p;
#line 266 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							gpx_point_set_position_lat (_tmp12_, lat_dec);
#line 1451 "gpx-parser-fit.c"
						}
#line 268 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1455 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 1:
#line 1459 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp13_;
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp13_ = field;
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp13_, fs, &_inner_error0_);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1477 "gpx-parser-fit.c"
							} else {
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 271 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1487 "gpx-parser-fit.c"
							}
						}
#line 272 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0x7FFFFFFF)) {
#line 1492 "gpx-parser-fit.c"
							gdouble lon_dec = 0.0;
							GpxPoint* _tmp14_;
#line 273 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							lon_dec = ((gdouble) val) * (180.0 / pow (2.0, 31.0));
#line 274 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp14_ = p;
#line 274 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							gpx_point_set_position_lon (_tmp14_, lon_dec);
#line 1501 "gpx-parser-fit.c"
						}
#line 276 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1505 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 2:
#line 1509 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp15_;
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp15_ = field;
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp15_, fs, &_inner_error0_);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1527 "gpx-parser-fit.c"
							} else {
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 279 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1537 "gpx-parser-fit.c"
							}
						}
#line 280 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0xFFFF)) {
#line 1542 "gpx-parser-fit.c"
							GpxPoint* _tmp16_;
#line 281 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp16_ = p;
#line 281 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp16_->elevation = (val / 5.0) - 500;
#line 1548 "gpx-parser-fit.c"
						}
#line 283 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1552 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 3:
#line 1556 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp17_;
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp17_ = field;
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp17_, fs, &_inner_error0_);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1574 "gpx-parser-fit.c"
							} else {
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 286 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1584 "gpx-parser-fit.c"
							}
						}
#line 287 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0xFF)) {
#line 1589 "gpx-parser-fit.c"
							GpxPoint* _tmp18_;
#line 288 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp18_ = p;
#line 288 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp18_->tpe.heartrate = (gint) val;
#line 1595 "gpx-parser-fit.c"
						}
#line 290 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1599 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 4:
#line 1603 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp19_;
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp19_ = field;
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp19_, fs, &_inner_error0_);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1621 "gpx-parser-fit.c"
							} else {
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 293 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1631 "gpx-parser-fit.c"
							}
						}
#line 294 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0xFF)) {
#line 1636 "gpx-parser-fit.c"
							GpxPoint* _tmp20_;
#line 295 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp20_ = p;
#line 295 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							_tmp20_->cadence = val;
#line 1642 "gpx-parser-fit.c"
						}
#line 297 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1646 "gpx-parser-fit.c"
					}
#line 252 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					case 18:
#line 1650 "gpx-parser-fit.c"
					{
						guint32 val = 0U;
						GpxFitFileFieldDefinitionHeader _tmp21_;
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp21_ = field;
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						val = gpx_fit_file_parse_field (self, &_tmp21_, fs, &_inner_error0_);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1668 "gpx-parser-fit.c"
							} else {
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 300 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1678 "gpx-parser-fit.c"
							}
						}
#line 301 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (val != ((guint32) 0xFF)) {
#line 302 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							g_debug ("gpx-parser-fit.vala:302: Cycles: %u", (guint) val);
#line 1685 "gpx-parser-fit.c"
						}
#line 304 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1689 "gpx-parser-fit.c"
					}
					default:
					{
						GpxFitFileFieldDefinitionHeader _tmp22_;
						GpxFitFileFieldDefinitionHeader _tmp23_;
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp22_ = field;
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_input_stream_skip ((GInputStream*) fs, (gsize) _tmp22_.size, NULL, &_inner_error0_);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1709 "gpx-parser-fit.c"
							} else {
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								_gpx_point_unref0 (p);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 306 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 1719 "gpx-parser-fit.c"
							}
						}
#line 307 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp23_ = field;
#line 307 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						self->priv->data_length = self->priv->data_length - _tmp23_.size;
#line 308 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						break;
#line 1728 "gpx-parser-fit.c"
					}
				}
			}
		}
	}
#line 313 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp24_ = self->priv->track;
#line 313 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp25_ = gpx_track_get_last (_tmp24_);
#line 313 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp26_ = _gpx_point_ref0 (_tmp25_);
#line 313 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	lastp = _tmp26_;
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp28_ = lastp;
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (_tmp28_ != NULL) {
#line 1746 "gpx-parser-fit.c"
		GpxPoint* _tmp29_;
		GpxPoint* _tmp30_;
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp29_ = lastp;
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp30_ = p;
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp27_ = gpx_point_get_time (_tmp29_) == gpx_point_get_time (_tmp30_);
#line 1755 "gpx-parser-fit.c"
	} else {
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp27_ = FALSE;
#line 1759 "gpx-parser-fit.c"
	}
#line 314 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (_tmp27_) {
#line 315 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_gpx_point_unref0 (lastp);
#line 315 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_gpx_point_unref0 (p);
#line 315 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		return;
#line 1769 "gpx-parser-fit.c"
	}
#line 317 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp31_ = p;
#line 317 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (gpx_point_has_position (_tmp31_)) {
#line 1775 "gpx-parser-fit.c"
		gboolean _tmp32_ = FALSE;
		GpxPoint* _tmp33_;
		GpxTrack* _tmp55_;
		GpxPoint* _tmp56_;
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp33_ = lastp;
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_tmp33_ != NULL) {
#line 1784 "gpx-parser-fit.c"
			GpxPoint* _tmp34_;
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp34_ = lastp;
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp32_ = !gpx_point_has_position (_tmp34_);
#line 1790 "gpx-parser-fit.c"
		} else {
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp32_ = FALSE;
#line 1794 "gpx-parser-fit.c"
		}
#line 318 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_tmp32_) {
#line 1798 "gpx-parser-fit.c"
			GList* ll = NULL;
			GpxTrack* _tmp35_;
			GList* _tmp36_;
			GList* _tmp37_;
#line 320 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp35_ = self->priv->track;
#line 320 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp36_ = _tmp35_->points;
#line 320 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp37_ = g_list_last (_tmp36_);
#line 320 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			ll = _tmp37_;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			while (TRUE) {
#line 1813 "gpx-parser-fit.c"
				gboolean _tmp38_ = FALSE;
				GList* _tmp39_;
				GpxPoint* last = NULL;
				GList* _tmp42_;
				gconstpointer _tmp43_;
				GpxPoint* _tmp44_;
				GpxPoint* _tmp45_;
				GpxPoint* _tmp46_;
				GpxPoint* _tmp47_;
				GpxPoint* _tmp48_;
				GpxPoint* _tmp49_;
				GpxPoint* _tmp50_;
				GpxPoint* _tmp51_;
				GpxPoint* _tmp52_;
				GList* _tmp53_;
				GList* _tmp54_;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp39_ = ll;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (_tmp39_ != NULL) {
#line 1834 "gpx-parser-fit.c"
					GList* _tmp40_;
					gconstpointer _tmp41_;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					_tmp40_ = ll;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					_tmp41_ = _tmp40_->data;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					_tmp38_ = !gpx_point_has_position ((GpxPoint*) _tmp41_);
#line 1843 "gpx-parser-fit.c"
				} else {
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					_tmp38_ = FALSE;
#line 1847 "gpx-parser-fit.c"
				}
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (!_tmp38_) {
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					break;
#line 1853 "gpx-parser-fit.c"
				}
#line 322 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp42_ = ll;
#line 322 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp43_ = _tmp42_->data;
#line 322 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp44_ = _gpx_point_ref0 ((GpxPoint*) _tmp43_);
#line 322 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				last = _tmp44_;
#line 323 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp45_ = last;
#line 323 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp46_ = p;
#line 323 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp45_->lat_dec = _tmp46_->lat_dec;
#line 324 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp47_ = last;
#line 324 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp48_ = p;
#line 324 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp47_->lon_dec = _tmp48_->lon_dec;
#line 325 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp49_ = last;
#line 325 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp50_ = p;
#line 325 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp49_->lat = _tmp50_->lat;
#line 326 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp51_ = last;
#line 326 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp52_ = p;
#line 326 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp51_->lon = _tmp52_->lon;
#line 327 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp53_ = ll;
#line 327 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp54_ = _tmp53_->prev;
#line 327 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				ll = _tmp54_;
#line 321 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_gpx_point_unref0 (last);
#line 1895 "gpx-parser-fit.c"
			}
		}
#line 330 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp55_ = self->priv->track;
#line 330 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp56_ = p;
#line 330 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		gpx_track_add_point (_tmp55_, _tmp56_);
#line 1904 "gpx-parser-fit.c"
	} else {
		GpxPoint* _tmp57_;
#line 332 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp57_ = lastp;
#line 332 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (_tmp57_ != NULL) {
#line 1911 "gpx-parser-fit.c"
			GpxPoint* _tmp58_;
			GpxPoint* _tmp59_;
			GpxPoint* _tmp60_;
			GpxPoint* _tmp61_;
			GpxPoint* _tmp62_;
			GpxPoint* _tmp63_;
			GpxPoint* _tmp64_;
			GpxPoint* _tmp65_;
			GpxTrack* _tmp66_;
			GpxPoint* _tmp67_;
#line 333 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp58_ = p;
#line 333 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp59_ = lastp;
#line 333 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp58_->lat_dec = _tmp59_->lat_dec;
#line 334 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp60_ = p;
#line 334 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp61_ = lastp;
#line 334 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp60_->lon_dec = _tmp61_->lon_dec;
#line 335 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp62_ = p;
#line 335 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp63_ = lastp;
#line 335 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp62_->lat = _tmp63_->lat;
#line 336 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp64_ = p;
#line 336 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp65_ = lastp;
#line 336 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp64_->lon = _tmp65_->lon;
#line 337 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp66_ = self->priv->track;
#line 337 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp67_ = p;
#line 337 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_track_add_point (_tmp66_, _tmp67_);
#line 1952 "gpx-parser-fit.c"
		} else {
			GpxTrack* _tmp68_;
			GpxPoint* _tmp69_;
#line 339 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp68_ = self->priv->track;
#line 339 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp69_ = p;
#line 339 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_track_add_point (_tmp68_, _tmp69_);
#line 1962 "gpx-parser-fit.c"
		}
	}
#line 245 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_gpx_point_unref0 (lastp);
#line 245 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_gpx_point_unref0 (p);
#line 1969 "gpx-parser-fit.c"
}

static void
gpx_fit_file_parse_data_record (GpxFitFile* self,
                                GDataInputStream* fs,
                                guint8 local_message_type,
                                GError** error)
{
	GpxFitFileFieldDefinition* def = NULL;
	GpxFitFileFieldDefinition* _tmp0_;
	GpxFitFileFieldDefinition* _tmp1_;
	GpxFitFileFieldDefinition* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 345 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = gpx_fit_file_get_field_def (self, (guint) local_message_type);
#line 345 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	def = _tmp0_;
#line 348 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp1_ = def;
#line 348 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	gpx_fit_file_parse_apply_definition_endian (self, fs, _tmp1_);
#line 349 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp2_ = def;
#line 349 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	switch ((*_tmp2_).type) {
#line 349 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY:
#line 1997 "gpx-parser-fit.c"
		{
			GpxFitFileFieldDefinition* _tmp3_;
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp3_ = def;
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_fit_file_parse_data_record_activity_summary (self, fs, _tmp3_, &_inner_error0_);
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return;
#line 2012 "gpx-parser-fit.c"
				} else {
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 352 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return;
#line 2020 "gpx-parser-fit.c"
				}
			}
#line 354 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 2025 "gpx-parser-fit.c"
		}
#line 349 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		case GPX_FIT_FILE_FIT_TYPES_LAP:
#line 2029 "gpx-parser-fit.c"
		{
			GpxFitFileFieldDefinition* _tmp4_;
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp4_ = def;
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			gpx_fit_file_parse_data_record_lap (self, fs, _tmp4_, &_inner_error0_);
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_propagate_error (error, _inner_error0_);
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return;
#line 2044 "gpx-parser-fit.c"
				} else {
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					g_clear_error (&_inner_error0_);
#line 356 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					return;
#line 2052 "gpx-parser-fit.c"
				}
			}
#line 357 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 2057 "gpx-parser-fit.c"
		}
		default:
		{
			GpxFitFileFieldDefinition* _tmp5_;
			GpxFitFileFieldDefinition* _tmp6_;
			GpxFitFileFieldDefinitionHeader* _tmp7_;
			gint _tmp7__length1;
#line 359 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp5_ = def;
#line 359 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_debug ("gpx-parser-fit.vala:359: Unknown record: %d", (gint) (*_tmp5_).type);
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp6_ = def;
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp7_ = (*_tmp6_).fields;
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp7__length1 = (*_tmp6_).fields_length1;
#line 2075 "gpx-parser-fit.c"
			{
				GpxFitFileFieldDefinitionHeader* field_collection = NULL;
				gint field_collection_length1 = 0;
				gint _field_collection_size_ = 0;
				gint field_it = 0;
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				field_collection = _tmp7_;
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				field_collection_length1 = _tmp7__length1;
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
#line 2087 "gpx-parser-fit.c"
					GpxFitFileFieldDefinitionHeader field = {0};
#line 360 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
					field = field_collection[field_it];
#line 2091 "gpx-parser-fit.c"
					{
						GpxFitFileFieldDefinitionHeader _tmp8_;
						GpxFitFileFieldDefinitionHeader _tmp9_;
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp8_ = field;
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						g_input_stream_skip ((GInputStream*) fs, (gsize) _tmp8_.size, NULL, &_inner_error0_);
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
							if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_propagate_error (error, _inner_error0_);
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 2107 "gpx-parser-fit.c"
							} else {
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								g_clear_error (&_inner_error0_);
#line 361 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
								return;
#line 2115 "gpx-parser-fit.c"
							}
						}
#line 362 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						_tmp9_ = field;
#line 362 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
						self->priv->data_length = self->priv->data_length - _tmp9_.size;
#line 2122 "gpx-parser-fit.c"
					}
				}
			}
#line 364 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			break;
#line 2128 "gpx-parser-fit.c"
		}
	}
}

/**
         * Parse the header.
         */
static void
gpx_fit_file_parse_header (GpxFitFile* self,
                           GDataInputStream* fs,
                           GError** error)
{
	GError* _inner_error0_ = NULL;
	{
		guint8 _tmp0_ = 0U;
		guchar header_size = '\0';
		gboolean _tmp2_ = FALSE;
		guint8 _tmp4_ = 0U;
		guchar version = '\0';
		guchar low = '\0';
		guchar high = '\0';
		guint16 _tmp5_ = 0U;
		guint16 profver = 0U;
		guint32 _tmp6_ = 0U;
		guint8* signature = NULL;
		guint8* _tmp7_;
		gint signature_length1;
		gint _signature_size_;
		gssize size = 0L;
		guint8* _tmp8_;
		gint _tmp8__length1;
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp0_ = g_data_input_stream_read_byte (fs, NULL, &_inner_error0_);
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2166 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2171 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2180 "gpx-parser-fit.c"
		}
#line 376 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		header_size = (guchar) _tmp0_;
#line 377 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (((gint) header_size) == EOF) {
#line 2186 "gpx-parser-fit.c"
			GError* _tmp1_;
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp1_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "Empty header");
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_inner_error0_ = _tmp1_;
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2194 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2199 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 378 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2208 "gpx-parser-fit.c"
		}
#line 380 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (((gint) header_size) == 12) {
#line 380 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp2_ = TRUE;
#line 2214 "gpx-parser-fit.c"
		} else {
#line 380 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp2_ = ((gint) header_size) == 14;
#line 2218 "gpx-parser-fit.c"
		}
#line 380 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (!_tmp2_) {
#line 2222 "gpx-parser-fit.c"
			GError* _tmp3_;
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp3_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "Unsupported FIT Header size");
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_inner_error0_ = _tmp3_;
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2230 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2235 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 381 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2244 "gpx-parser-fit.c"
		}
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp4_ = g_data_input_stream_read_byte (fs, NULL, &_inner_error0_);
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2252 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2257 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2266 "gpx-parser-fit.c"
		}
#line 386 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		version = (guchar) _tmp4_;
#line 387 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		low = version & 0x0f;
#line 388 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		high = (guchar) ((version & 0xf0) >> 4);
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp5_ = g_data_input_stream_read_uint16 (fs, NULL, &_inner_error0_);
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2280 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2285 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2294 "gpx-parser-fit.c"
		}
#line 391 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		profver = (guint16) _tmp5_;
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp6_ = g_data_input_stream_read_uint32 (fs, NULL, &_inner_error0_);
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2304 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2309 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2318 "gpx-parser-fit.c"
		}
#line 394 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		self->priv->data_length = (guint32) _tmp6_;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp7_ = g_new0 (guint8, 4);
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp7_[0] = (guint8) 0;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp7_[1] = (guint8) 0;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp7_[2] = (guint8) 0;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp7_[3] = (guint8) 0;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		signature = _tmp7_;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		signature_length1 = 4;
#line 397 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_signature_size_ = signature_length1;
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp8_ = signature;
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp8__length1 = signature_length1;
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		size = g_input_stream_read ((GInputStream*) fs, _tmp8_, (gsize) _tmp8__length1, NULL, &_inner_error0_);
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			signature = (g_free (signature), NULL);
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2350 "gpx-parser-fit.c"
				goto __catch0_g_io_error;
			}
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2355 "gpx-parser-fit.c"
				goto __catch0_gpx_file_error;
			}
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 398 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2364 "gpx-parser-fit.c"
		}
#line 399 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (size == ((gssize) 4)) {
#line 2368 "gpx-parser-fit.c"
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			guint8* _tmp12_;
			gint _tmp12__length1;
			guint8 _tmp13_;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp12_ = signature;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp12__length1 = signature_length1;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			_tmp13_ = _tmp12_[0];
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_tmp13_ == ((guint8) '.')) {
#line 2383 "gpx-parser-fit.c"
				guint8* _tmp14_;
				gint _tmp14__length1;
				guint8 _tmp15_;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp14_ = signature;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp14__length1 = signature_length1;
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp15_ = _tmp14_[1];
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp11_ = _tmp15_ == ((guint8) 'F');
#line 2395 "gpx-parser-fit.c"
			} else {
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp11_ = FALSE;
#line 2399 "gpx-parser-fit.c"
			}
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_tmp11_) {
#line 2403 "gpx-parser-fit.c"
				guint8* _tmp16_;
				gint _tmp16__length1;
				guint8 _tmp17_;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp16_ = signature;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp16__length1 = signature_length1;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp17_ = _tmp16_[2];
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp10_ = _tmp17_ == ((guint8) 'I');
#line 2415 "gpx-parser-fit.c"
			} else {
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp10_ = FALSE;
#line 2419 "gpx-parser-fit.c"
			}
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (_tmp10_) {
#line 2423 "gpx-parser-fit.c"
				guint8* _tmp18_;
				gint _tmp18__length1;
				guint8 _tmp19_;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp18_ = signature;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp18__length1 = signature_length1;
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp19_ = _tmp18_[3];
#line 401 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp9_ = _tmp19_ == ((guint8) 'T');
#line 2435 "gpx-parser-fit.c"
			} else {
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp9_ = FALSE;
#line 2439 "gpx-parser-fit.c"
			}
#line 400 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (!_tmp9_) {
#line 2443 "gpx-parser-fit.c"
				GError* _tmp20_;
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_tmp20_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "No valid FIT signature found.");
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				_inner_error0_ = _tmp20_;
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				signature = (g_free (signature), NULL);
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 2453 "gpx-parser-fit.c"
					goto __catch0_g_io_error;
				}
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2458 "gpx-parser-fit.c"
					goto __catch0_gpx_file_error;
				}
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				g_clear_error (&_inner_error0_);
#line 404 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				return;
#line 2467 "gpx-parser-fit.c"
			}
		}
#line 408 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if (((gint) header_size) == 14) {
#line 2472 "gpx-parser-fit.c"
			guint16 crc = 0U;
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			crc = g_data_input_stream_read_uint16 (fs, NULL, &_inner_error0_);
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				signature = (g_free (signature), NULL);
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (_inner_error0_->domain == G_IO_ERROR) {
#line 2482 "gpx-parser-fit.c"
					goto __catch0_g_io_error;
				}
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				if (_inner_error0_->domain == GPX_FILE_ERROR) {
#line 2487 "gpx-parser-fit.c"
					goto __catch0_gpx_file_error;
				}
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				g_clear_error (&_inner_error0_);
#line 409 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
				return;
#line 2496 "gpx-parser-fit.c"
			}
		}
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		signature = (g_free (signature), NULL);
#line 2501 "gpx-parser-fit.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		GError* _tmp22_;
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		err = _inner_error0_;
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = NULL;
#line 413 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp21_ = err;
#line 413 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp22_ = _g_error_copy0 (_tmp21_);
#line 413 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = _tmp22_;
#line 413 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_error_free0 (err);
#line 2521 "gpx-parser-fit.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_gpx_file_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		GError* _tmp24_;
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		err = _inner_error0_;
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = NULL;
#line 415 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp23_ = err;
#line 415 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_tmp24_ = _g_error_copy0 (_tmp23_);
#line 415 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_inner_error0_ = _tmp24_;
#line 415 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		_g_error_free0 (err);
#line 2542 "gpx-parser-fit.c"
		goto __finally0;
	}
	__finally0:
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		if ((_inner_error0_->domain == GPX_FILE_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_propagate_error (error, _inner_error0_);
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2554 "gpx-parser-fit.c"
		} else {
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			g_clear_error (&_inner_error0_);
#line 373 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
			return;
#line 2562 "gpx-parser-fit.c"
		}
	}
}

static GpxFitFileFieldDefinitionHeader*
_vala_array_dup1 (GpxFitFileFieldDefinitionHeader* self,
                  gssize length)
{
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	if (length > 0) {
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
		return _vala_memdup2 (self, length * sizeof (GpxFitFileFieldDefinitionHeader));
#line 2575 "gpx-parser-fit.c"
	}
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return NULL;
#line 2579 "gpx-parser-fit.c"
}

static void
gpx_fit_file_field_definition_copy (const GpxFitFileFieldDefinition* self,
                                    GpxFitFileFieldDefinition* dest)
{
	GpxFitFileFieldDefinitionHeader* _tmp0_;
	gint _tmp0__length1;
	GpxFitFileFieldDefinitionHeader* _tmp1_;
	gint _tmp1__length1;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest).endian = (*self).endian;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest).type = (*self).type;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = (*self).fields;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0__length1 = (*self).fields_length1;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp1__length1 = _tmp0__length1;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest).fields = (g_free ((*dest).fields), NULL);
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest).fields = _tmp1_;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest).fields_length1 = _tmp1__length1;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*dest)._fields_size_ = (*dest).fields_length1;
#line 2610 "gpx-parser-fit.c"
}

static void
gpx_fit_file_field_definition_destroy (GpxFitFileFieldDefinition* self)
{
#line 37 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	(*self).fields = (g_free ((*self).fields), NULL);
#line 2618 "gpx-parser-fit.c"
}

static GpxFitFileFieldDefinition*
gpx_fit_file_field_definition_dup (const GpxFitFileFieldDefinition* self)
{
	GpxFitFileFieldDefinition* dup;
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	dup = g_new0 (GpxFitFileFieldDefinition, 1);
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	gpx_fit_file_field_definition_copy (self, dup);
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return dup;
#line 2631 "gpx-parser-fit.c"
}

static void
gpx_fit_file_field_definition_free (GpxFitFileFieldDefinition* self)
{
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	gpx_fit_file_field_definition_destroy (self);
#line 34 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	g_free (self);
#line 2641 "gpx-parser-fit.c"
}

static GType
gpx_fit_file_field_definition_get_type_once (void)
{
	GType gpx_fit_file_field_definition_type_id;
	gpx_fit_file_field_definition_type_id = g_boxed_type_register_static ("GpxFitFileFieldDefinition", (GBoxedCopyFunc) gpx_fit_file_field_definition_dup, (GBoxedFreeFunc) gpx_fit_file_field_definition_free);
	return gpx_fit_file_field_definition_type_id;
}

static GType
gpx_fit_file_field_definition_get_type (void)
{
	static volatile gsize gpx_fit_file_field_definition_type_id__once = 0;
	if (g_once_init_enter (&gpx_fit_file_field_definition_type_id__once)) {
		GType gpx_fit_file_field_definition_type_id;
		gpx_fit_file_field_definition_type_id = gpx_fit_file_field_definition_get_type_once ();
		g_once_init_leave (&gpx_fit_file_field_definition_type_id__once, gpx_fit_file_field_definition_type_id);
	}
	return gpx_fit_file_field_definition_type_id__once;
}

static GpxFitFileFieldDefinitionHeader*
gpx_fit_file_field_definition_header_dup (const GpxFitFileFieldDefinitionHeader* self)
{
	GpxFitFileFieldDefinitionHeader* dup;
#line 42 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	dup = g_new0 (GpxFitFileFieldDefinitionHeader, 1);
#line 42 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	memcpy (dup, self, sizeof (GpxFitFileFieldDefinitionHeader));
#line 42 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	return dup;
#line 2674 "gpx-parser-fit.c"
}

static void
gpx_fit_file_field_definition_header_free (GpxFitFileFieldDefinitionHeader* self)
{
#line 42 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	g_free (self);
#line 2682 "gpx-parser-fit.c"
}

static GType
gpx_fit_file_field_definition_header_get_type_once (void)
{
	GType gpx_fit_file_field_definition_header_type_id;
	gpx_fit_file_field_definition_header_type_id = g_boxed_type_register_static ("GpxFitFileFieldDefinitionHeader", (GBoxedCopyFunc) gpx_fit_file_field_definition_header_dup, (GBoxedFreeFunc) gpx_fit_file_field_definition_header_free);
	return gpx_fit_file_field_definition_header_type_id;
}

static GType
gpx_fit_file_field_definition_header_get_type (void)
{
	static volatile gsize gpx_fit_file_field_definition_header_type_id__once = 0;
	if (g_once_init_enter (&gpx_fit_file_field_definition_header_type_id__once)) {
		GType gpx_fit_file_field_definition_header_type_id;
		gpx_fit_file_field_definition_header_type_id = gpx_fit_file_field_definition_header_get_type_once ();
		g_once_init_leave (&gpx_fit_file_field_definition_header_type_id__once, gpx_fit_file_field_definition_header_type_id);
	}
	return gpx_fit_file_field_definition_header_type_id__once;
}

static void
gpx_fit_file_class_init (GpxFitFileClass * klass,
                         gpointer klass_data)
{
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	gpx_fit_file_parent_class = g_type_class_peek_parent (klass);
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	g_type_class_adjust_private_offset (klass, &GpxFitFile_private_offset);
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_fit_file_finalize;
#line 2715 "gpx-parser-fit.c"
}

static void
gpx_fit_file_instance_init (GpxFitFile * self,
                            gpointer klass)
{
	GpxFitFileFieldDefinition* _tmp0_;
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv = gpx_fit_file_get_instance_private (self);
#line 26 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->track = NULL;
#line 27 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->data_length = (guint32) 0;
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_tmp0_ = g_new0 (GpxFitFileFieldDefinition, GPX_FIT_FILE_MAX_LOCAL_DEFINITIONS);
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->defs = _tmp0_;
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->defs_length1 = GPX_FIT_FILE_MAX_LOCAL_DEFINITIONS;
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->_defs_size_ = self->priv->defs_length1;
#line 2737 "gpx-parser-fit.c"
}

static void
gpx_fit_file_finalize (GObject * obj)
{
	GpxFitFile * self;
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_FIT_FILE, GpxFitFile);
#line 26 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	_g_object_unref0 (self->priv->track);
#line 41 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	self->priv->defs = (_vala_GpxFitFileFieldDefinition_array_free (self->priv->defs, self->priv->defs_length1), NULL);
#line 22 "../gpx-viewer/libgpx/gpx-parser-fit.vala"
	G_OBJECT_CLASS (gpx_fit_file_parent_class)->finalize (obj);
#line 2752 "gpx-parser-fit.c"
}

static GType
gpx_fit_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxFitFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_fit_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxFitFile), 0, (GInstanceInitFunc) gpx_fit_file_instance_init, NULL };
	GType gpx_fit_file_type_id;
	gpx_fit_file_type_id = g_type_register_static (GPX_TYPE_FILE_BASE, "GpxFitFile", &g_define_type_info, 0);
	GpxFitFile_private_offset = g_type_add_instance_private (gpx_fit_file_type_id, sizeof (GpxFitFilePrivate));
	return gpx_fit_file_type_id;
}

GType
gpx_fit_file_get_type (void)
{
	static volatile gsize gpx_fit_file_type_id__once = 0;
	if (g_once_init_enter (&gpx_fit_file_type_id__once)) {
		GType gpx_fit_file_type_id;
		gpx_fit_file_type_id = gpx_fit_file_get_type_once ();
		g_once_init_leave (&gpx_fit_file_type_id__once, gpx_fit_file_type_id);
	}
	return gpx_fit_file_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

