/* gpx-viewer-map-view.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-viewer-map-view.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gpx.h"
#include <champlain/champlain.h>
#include <clutter/clutter.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <champlain-gtk/champlain-gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_VIEWER_MAP_VIEW_0_PROPERTY,
	GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY,
	GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY,
	GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY,
	GPX_VIEWER_MAP_VIEW_NUM_PROPERTIES
};
static GParamSpec* gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GPX_VIEWER_MAP_VIEW_CLICKED_SIGNAL,
	GPX_VIEWER_MAP_VIEW_ZOOM_LEVEL_CHANGED_SIGNAL,
	GPX_VIEWER_MAP_VIEW_NUM_SIGNALS
};
static guint gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_NUM_SIGNALS] = {0};

struct _GpxViewerMapViewPrivate {
	ChamplainView* view;
	ClutterColor waypoint_color;
	ChamplainMarker* click_marker;
	ChamplainMarkerLayer* waypoint_layer;
	gboolean _show_waypoints;
	ChamplainMarkerLayer* marker_layer;
	gboolean _show_markers;
	GtkListStore* map_source_list;
	gchar* _map_source;
};

static gint GpxViewerMapView_private_offset;
static gpointer gpx_viewer_map_view_parent_class = NULL;

static void __lambda6_ (GpxViewerMapView* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static gboolean gpx_viewer_map_view_button_press_callback (GpxViewerMapView* self,
                                                    ClutterButtonEvent* event);
static gboolean _gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                        ClutterButtonEvent* event,
                                                                                        gpointer self);
static void gpx_viewer_map_view_switch_map_source (GpxViewerMapView* self,
                                            const gchar* id);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void gpx_viewer_map_view_finalize (GObject * obj);
static GType gpx_viewer_map_view_get_type_once (void);
static void _vala_gpx_viewer_map_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gpx_viewer_map_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gpx_viewer_map_view_get_instance_private (GpxViewerMapView* self)
{
	return G_STRUCT_MEMBER_P (self, GpxViewerMapView_private_offset);
}

ChamplainMarker*
gpx_viewer_map_view_create_marker (GpxViewerMapView* self,
                                   GpxPoint* p,
                                   const gchar* icon,
                                   gint size)
{
	ChamplainLabel* marker = NULL;
	GtkIconInfo* info = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconInfo* _tmp1_;
	GtkIconInfo* _tmp2_;
	ChamplainLabel* _tmp14_;
	ChamplainLabel* _tmp16_;
	ChamplainLabel* _tmp17_;
	GError* _inner_error0_ = NULL;
	ChamplainMarker* result;
#line 38 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	marker = NULL;
#line 39 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 39 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = gtk_icon_theme_lookup_icon (_tmp0_, icon, size, 0);
#line 39 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	info = _tmp1_;
#line 42 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = info;
#line 42 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (_tmp2_ != NULL) {
#line 149 "gpx-viewer-map-view.c"
		gchar* path = NULL;
		GtkIconInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 44 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp3_ = info;
#line 44 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp4_ = gtk_icon_info_get_filename (_tmp3_);
#line 44 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 44 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		path = _tmp5_;
#line 45 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp6_ = path;
#line 45 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		if (_tmp6_ != NULL) {
#line 167 "gpx-viewer-map-view.c"
			ChamplainLabel* _tmp13_;
			{
				ChamplainLabel* _tmp7_ = NULL;
				const gchar* _tmp8_;
				ChamplainLabel* _tmp9_;
				ChamplainLabel* _tmp10_;
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp8_ = path;
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp9_ = (ChamplainLabel*) champlain_label_new_from_file (_tmp8_, &_inner_error0_);
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp7_ = _tmp9_;
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "gpx-viewer-map-view.c"
					goto __catch0_g_error;
				}
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp10_ = _tmp7_;
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp7_ = NULL;
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				if (_tmp10_ != NULL) {
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					g_object_ref_sink (_tmp10_);
#line 193 "gpx-viewer-map-view.c"
				}
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_object_unref0 (marker);
#line 47 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				marker = _tmp10_;
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_object_unref0 (_tmp7_);
#line 201 "gpx-viewer-map-view.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp11_;
				const gchar* _tmp12_;
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				e = _inner_error0_;
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_inner_error0_ = NULL;
#line 49 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp11_ = e;
#line 49 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp12_ = _tmp11_->message;
#line 49 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				g_warning ("gpx-viewer-map-view.vala:49: %s", _tmp12_);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_error_free0 (e);
#line 221 "gpx-viewer-map-view.c"
			}
			__finally0:
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_free0 (path);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_object_unref0 (info);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_g_object_unref0 (marker);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				g_clear_error (&_inner_error0_);
#line 46 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				return NULL;
#line 238 "gpx-viewer-map-view.c"
			}
#line 51 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
			_tmp13_ = marker;
#line 51 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
			champlain_label_set_draw_background (_tmp13_, FALSE);
#line 244 "gpx-viewer-map-view.c"
		}
#line 42 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_g_free0 (path);
#line 248 "gpx-viewer-map-view.c"
	} else {
#line 54 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_debug ("gpx-viewer-map-view.vala:54: Info is null: %s", icon);
#line 252 "gpx-viewer-map-view.c"
	}
#line 55 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp14_ = marker;
#line 55 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (_tmp14_ == NULL) {
#line 258 "gpx-viewer-map-view.c"
		ChamplainLabel* _tmp15_;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp15_ = (ChamplainLabel*) champlain_label_new ();
#line 56 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_object_ref_sink (_tmp15_);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_g_object_unref0 (marker);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		marker = _tmp15_;
#line 268 "gpx-viewer-map-view.c"
	}
#line 58 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp16_ = marker;
#line 58 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	clutter_actor_set_size ((ClutterActor*) _tmp16_, (gfloat) size, (gfloat) size);
#line 60 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp17_ = marker;
#line 60 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_location_set_location ((ChamplainLocation*) _tmp17_, (gdouble) ((gfloat) p->lat_dec), (gdouble) ((gfloat) p->lon_dec));
#line 61 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = (ChamplainMarker*) marker;
#line 61 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (info);
#line 61 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 284 "gpx-viewer-map-view.c"
}

/**
 * Show marker at Point
 */
void
gpx_viewer_map_view_click_marker_show (GpxViewerMapView* self,
                                       GpxPoint* p)
{
	ChamplainMarker* _tmp0_;
#line 68 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->click_marker;
#line 68 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (_tmp0_ == NULL) {
#line 299 "gpx-viewer-map-view.c"
		ChamplainMarker* _tmp1_;
		ChamplainMarker* _tmp2_;
		ChamplainMarker* _tmp3_;
#line 70 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp1_ = gpx_viewer_map_view_create_marker (self, p, "pin-blue", 100);
#line 70 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_g_object_unref0 (self->priv->click_marker);
#line 70 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		self->priv->click_marker = _tmp1_;
#line 71 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp2_ = self->priv->click_marker;
#line 71 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		gpx_viewer_map_view_add_marker (self, _tmp2_);
#line 72 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp3_ = self->priv->click_marker;
#line 72 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		clutter_actor_show ((ClutterActor*) _tmp3_);
#line 317 "gpx-viewer-map-view.c"
	} else {
		ChamplainMarker* _tmp4_;
		ChamplainMarker* _tmp5_;
#line 74 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp4_ = self->priv->click_marker;
#line 74 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		champlain_location_set_location ((ChamplainLocation*) _tmp4_, (gdouble) ((gfloat) p->lat_dec), (gdouble) ((gfloat) p->lon_dec));
#line 75 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp5_ = self->priv->click_marker;
#line 75 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		clutter_actor_show ((ClutterActor*) _tmp5_);
#line 329 "gpx-viewer-map-view.c"
	}
}

void
gpx_viewer_map_view_click_marker_hide (GpxViewerMapView* self)
{
	ChamplainMarker* _tmp0_;
#line 80 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->click_marker;
#line 80 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	clutter_actor_hide ((ClutterActor*) _tmp0_);
#line 341 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_increase_zoom_level (GpxViewerMapView* self)
{
	ChamplainView* _tmp0_;
	ChamplainView* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
#line 84 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
#line 84 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
#line 84 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = champlain_view_get_zoom_level (_tmp1_);
#line 84 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp3_ = _tmp2_;
#line 84 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_view_set_zoom_level (_tmp1_, _tmp3_ + 1);
#line 361 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_decrease_zoom_level (GpxViewerMapView* self)
{
	ChamplainView* _tmp0_;
	ChamplainView* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
#line 88 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
#line 88 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
#line 88 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = champlain_view_get_zoom_level (_tmp1_);
#line 88 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp3_ = _tmp2_;
#line 88 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_view_set_zoom_level (_tmp1_, _tmp3_ - 1);
#line 381 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_add_waypoint (GpxViewerMapView* self,
                                  GpxPoint* p)
{
	ChamplainMarker* marker = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ClutterColor _tmp2_;
	ChamplainLabel* _tmp3_;
	ChamplainMarkerLayer* _tmp4_;
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = gpx_point_get_name (p);
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = _tmp0_;
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = self->priv->waypoint_color;
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp3_ = (ChamplainLabel*) champlain_label_new_with_text (_tmp1_, "Serif 12", NULL, &_tmp2_);
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_ref_sink (_tmp3_);
#line 106 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	marker = (ChamplainMarker*) _tmp3_;
#line 107 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_location_set_location ((ChamplainLocation*) marker, p->lat_dec, p->lon_dec);
#line 108 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp4_ = self->priv->waypoint_layer;
#line 108 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_marker_layer_add_marker (_tmp4_, marker);
#line 104 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (marker);
#line 414 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_add_marker (GpxViewerMapView* self,
                                ChamplainMarker* marker)
{
	ChamplainMarkerLayer* _tmp0_;
#line 124 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->marker_layer;
#line 124 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_marker_layer_add_marker (_tmp0_, marker);
#line 426 "gpx-viewer-map-view.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 142 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 434 "gpx-viewer-map-view.c"
}

GtkTreeModel*
gpx_viewer_map_view_get_model (GpxViewerMapView* self)
{
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* result;
#line 142 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->map_source_list;
#line 142 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp0_) : NULL);
#line 142 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = _tmp1_;
#line 142 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 451 "gpx-viewer-map-view.c"
}

static void
__lambda6_ (GpxViewerMapView* self)
{
	ChamplainView* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ChamplainView* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	ChamplainView* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->view;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = champlain_view_get_zoom_level (_tmp0_);
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = _tmp1_;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp3_ = self->priv->view;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp4_ = champlain_view_get_min_zoom_level (_tmp3_);
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp5_ = _tmp4_;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp6_ = self->priv->view;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp7_ = champlain_view_get_max_zoom_level (_tmp6_);
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp8_ = _tmp7_;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_signal_emit (self, gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_ZOOM_LEVEL_CHANGED_SIGNAL], 0, _tmp2_, _tmp5_, _tmp8_);
#line 486 "gpx-viewer-map-view.c"
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
#line 174 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	__lambda6_ ((GpxViewerMapView*) self);
#line 496 "gpx-viewer-map-view.c"
}

static gboolean
_gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                               ClutterButtonEvent* event,
                                                                               gpointer self)
{
	gboolean result;
	result = gpx_viewer_map_view_button_press_callback ((GpxViewerMapView*) self, event);
#line 184 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 508 "gpx-viewer-map-view.c"
}

GpxViewerMapView*
gpx_viewer_map_view_construct (GType object_type)
{
	GpxViewerMapView * self = NULL;
	ChamplainView* _tmp0_;
	ChamplainView* _tmp1_;
	ChamplainMapSourceFactory* fact = NULL;
	ChamplainMapSourceFactory* _tmp2_;
	GSList* l = NULL;
	ChamplainMapSourceFactory* _tmp3_;
	GSList* _tmp4_;
	GSList* _tmp5_;
	ChamplainView* _tmp21_;
	ChamplainView* _tmp22_;
	ChamplainMarkerLayer* _tmp23_;
	ChamplainView* _tmp24_;
	ChamplainMarkerLayer* _tmp25_;
	ChamplainMarkerLayer* _tmp26_;
	ChamplainView* _tmp27_;
	ChamplainView* _tmp28_;
#line 145 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self = (GpxViewerMapView*) g_object_new (object_type, NULL);
#line 147 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = gtk_champlain_embed_get_view ((GtkChamplainEmbed*) self);
#line 147 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->view = _tmp0_;
#line 148 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_debug ("gpx-viewer-map-view.vala:148: MapView init");
#line 150 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->waypoint_color.red = (guint8) 0xf3;
#line 151 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->waypoint_color.green = (guint8) 0x94;
#line 152 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->waypoint_color.blue = (guint8) 0x07;
#line 153 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->waypoint_color.alpha = (guint8) 0xff;
#line 157 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = self->priv->view;
#line 157 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_view_set_kinetic_mode (_tmp1_, TRUE);
#line 160 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = champlain_map_source_factory_dup_default ();
#line 160 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	fact = _tmp2_;
#line 161 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp3_ = fact;
#line 161 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp4_ = champlain_map_source_factory_get_registered (_tmp3_);
#line 161 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	l = _tmp4_;
#line 162 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp5_ = l;
#line 563 "gpx-viewer-map-view.c"
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
#line 162 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		a_collection = _tmp5_;
#line 162 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
#line 571 "gpx-viewer-map-view.c"
			ChamplainMapSourceDesc* a = NULL;
#line 162 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
			a = (ChamplainMapSourceDesc*) a_it->data;
#line 575 "gpx-viewer-map-view.c"
			{
				GtkTreeIter iter = {0};
				const gchar* _tmp6_;
				GtkListStore* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				GtkListStore* _tmp13_;
				GtkTreeIter _tmp14_;
				ChamplainMapSourceDesc* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				ChamplainMapSourceDesc* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
#line 166 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp6_ = self->priv->_map_source;
#line 166 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				if (_tmp6_ == NULL) {
#line 593 "gpx-viewer-map-view.c"
					ChamplainMapSourceDesc* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					_tmp7_ = a;
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					_tmp8_ = champlain_map_source_desc_get_id (_tmp7_);
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					_tmp9_ = _tmp8_;
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					_tmp10_ = g_strdup (_tmp9_);
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					_g_free0 (self->priv->_map_source);
#line 167 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
					self->priv->_map_source = _tmp10_;
#line 610 "gpx-viewer-map-view.c"
				}
#line 170 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp11_ = self->priv->map_source_list;
#line 170 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				gtk_list_store_append (_tmp11_, &_tmp12_);
#line 170 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				iter = _tmp12_;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp13_ = self->priv->map_source_list;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp14_ = iter;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp15_ = a;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp16_ = champlain_map_source_desc_get_name (_tmp15_);
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp17_ = _tmp16_;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp18_ = a;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp19_ = champlain_map_source_desc_get_id (_tmp18_);
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				_tmp20_ = _tmp19_;
#line 171 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
				gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp17_, 1, _tmp20_, -1);
#line 636 "gpx-viewer-map-view.c"
			}
		}
	}
#line 174 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp21_ = self->priv->view;
#line 174 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_signal_connect_object ((GObject*) _tmp21_, "notify::zoom-level", (GCallback) ___lambda6__g_object_notify, self, 0);
#line 179 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp22_ = self->priv->view;
#line 179 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp23_ = self->priv->waypoint_layer;
#line 179 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_view_add_layer (_tmp22_, (ChamplainLayer*) _tmp23_);
#line 180 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp24_ = self->priv->view;
#line 180 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp25_ = self->priv->marker_layer;
#line 180 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	champlain_view_add_layer (_tmp24_, (ChamplainLayer*) _tmp25_);
#line 181 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp26_ = self->priv->marker_layer;
#line 181 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	clutter_actor_show ((ClutterActor*) _tmp26_);
#line 183 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp27_ = self->priv->view;
#line 183 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	clutter_actor_set_reactive ((ClutterActor*) _tmp27_, TRUE);
#line 184 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp28_ = self->priv->view;
#line 184 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_signal_connect_object ((ClutterActor*) _tmp28_, "button-release-event", (GCallback) _gpx_viewer_map_view_button_press_callback_clutter_actor_button_release_event, self, 0);
#line 145 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	(l == NULL) ? NULL : (l = (g_slist_free (l), NULL));
#line 145 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (fact);
#line 145 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return self;
#line 674 "gpx-viewer-map-view.c"
}

GpxViewerMapView*
gpx_viewer_map_view_new (void)
{
#line 145 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return gpx_viewer_map_view_construct (GPX_VIEWER_TYPE_MAP_VIEW);
#line 682 "gpx-viewer-map-view.c"
}

static gboolean
gpx_viewer_map_view_button_press_callback (GpxViewerMapView* self,
                                           ClutterButtonEvent* event)
{
	GdkModifierType default_modifiers = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 189 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	default_modifiers = gtk_accelerator_get_default_mod_mask ();
#line 190 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (event->button == ((guint32) GDK_BUTTON_PRIMARY)) {
#line 191 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp0_ = (event->modifier_state & CLUTTER_CONTROL_MASK) == CLUTTER_CONTROL_MASK;
#line 698 "gpx-viewer-map-view.c"
	} else {
#line 190 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp0_ = FALSE;
#line 702 "gpx-viewer-map-view.c"
	}
#line 190 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (_tmp0_) {
#line 706 "gpx-viewer-map-view.c"
		gdouble lat = 0.0;
		gdouble lon = 0.0;
		ChamplainView* _tmp1_;
		ChamplainView* _tmp2_;
#line 194 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp1_ = self->priv->view;
#line 194 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		lat = champlain_view_y_to_latitude (_tmp1_, (gdouble) event->y);
#line 195 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp2_ = self->priv->view;
#line 195 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		lon = champlain_view_x_to_longitude (_tmp2_, (gdouble) event->x);
#line 196 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_signal_emit (self, gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_CLICKED_SIGNAL], 0, lat, lon);
#line 197 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		result = TRUE;
#line 197 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		return result;
#line 725 "gpx-viewer-map-view.c"
	}
#line 199 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = FALSE;
#line 199 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 731 "gpx-viewer-map-view.c"
}

static void
gpx_viewer_map_view_switch_map_source (GpxViewerMapView* self,
                                       const gchar* id)
{
	ChamplainMapSourceFactory* fact = NULL;
	ChamplainMapSourceFactory* _tmp0_;
	ChamplainMapSource* source = NULL;
	ChamplainMapSource* _tmp1_;
	ChamplainMapSource* _tmp2_;
#line 204 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = champlain_map_source_factory_dup_default ();
#line 204 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	fact = _tmp0_;
#line 205 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = champlain_map_source_factory_create_cached_source (fact, id);
#line 205 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 205 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	source = _tmp2_;
#line 206 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (source != NULL) {
#line 755 "gpx-viewer-map-view.c"
		ChamplainView* _tmp3_;
		gchar* _tmp4_;
		ChamplainView* _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		ChamplainView* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		ChamplainView* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
#line 208 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp3_ = self->priv->view;
#line 208 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		champlain_view_set_map_source (_tmp3_, source);
#line 209 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp4_ = g_strdup (id);
#line 209 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_g_free0 (self->priv->_map_source);
#line 209 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		self->priv->_map_source = _tmp4_;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp5_ = self->priv->view;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp6_ = champlain_view_get_zoom_level (_tmp5_);
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp7_ = _tmp6_;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp8_ = self->priv->view;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp9_ = champlain_view_get_min_zoom_level (_tmp8_);
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp10_ = _tmp9_;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp11_ = self->priv->view;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp12_ = champlain_view_get_max_zoom_level (_tmp11_);
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		_tmp13_ = _tmp12_;
#line 210 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_signal_emit (self, gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_ZOOM_LEVEL_CHANGED_SIGNAL], 0, _tmp7_, _tmp10_, _tmp13_);
#line 797 "gpx-viewer-map-view.c"
	} else {
#line 215 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_error ("gpx-viewer-map-view.vala:215: Failed to get map source");
#line 801 "gpx-viewer-map-view.c"
	}
#line 202 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (source);
#line 202 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (fact);
#line 807 "gpx-viewer-map-view.c"
}

gboolean
gpx_viewer_map_view_get_show_waypoints (GpxViewerMapView* self)
{
	gboolean result;
#line 97 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = self->priv->_show_waypoints;
#line 97 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 818 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_set_show_waypoints (GpxViewerMapView* self,
                                        gboolean value)
{
	ChamplainMarkerLayer* _tmp0_;
#line 99 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->_show_waypoints = value;
#line 100 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->waypoint_layer;
#line 100 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_set ((ClutterActor*) _tmp0_, "visible", self->priv->_show_waypoints, NULL);
#line 98 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY]);
#line 834 "gpx-viewer-map-view.c"
}

gboolean
gpx_viewer_map_view_get_show_markers (GpxViewerMapView* self)
{
	gboolean result;
#line 115 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = self->priv->_show_markers;
#line 115 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 845 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_set_show_markers (GpxViewerMapView* self,
                                      gboolean value)
{
	ChamplainMarkerLayer* _tmp0_;
#line 117 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->_show_markers = value;
#line 118 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->marker_layer;
#line 118 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_set ((ClutterActor*) _tmp0_, "visible", self->priv->_show_markers, NULL);
#line 116 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY]);
#line 861 "gpx-viewer-map-view.c"
}

const gchar*
gpx_viewer_map_view_get_map_source (GpxViewerMapView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 133 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->_map_source;
#line 133 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	result = _tmp0_;
#line 133 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	return result;
#line 875 "gpx-viewer-map-view.c"
}

void
gpx_viewer_map_view_set_map_source (GpxViewerMapView* self,
                                    const gchar* value)
{
	const gchar* _tmp0_;
#line 135 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = self->priv->_map_source;
#line 135 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (g_strcmp0 (value, _tmp0_) == 0) {
#line 135 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		return;
#line 889 "gpx-viewer-map-view.c"
	}
#line 136 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	gpx_viewer_map_view_switch_map_source (self, value);
#line 134 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY]);
#line 895 "gpx-viewer-map-view.c"
}

static void
g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data1 = closure->data;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 920 "gpx-viewer-map-view.c"
	} else {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data2 = closure->data;
#line 926 "gpx-viewer-map-view.c"
	}
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
#line 932 "gpx-viewer-map-view.c"
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_return_if_fail (n_param_values == 4);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data1 = closure->data;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 957 "gpx-viewer-map-view.c"
	} else {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		data2 = closure->data;
#line 963 "gpx-viewer-map-view.c"
	}
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
#line 969 "gpx-viewer-map-view.c"
}

static void
gpx_viewer_map_view_class_init (GpxViewerMapViewClass * klass,
                                gpointer klass_data)
{
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	gpx_viewer_map_view_parent_class = g_type_class_peek_parent (klass);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_type_class_adjust_private_offset (klass, &GpxViewerMapView_private_offset);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_viewer_map_view_get_property;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_viewer_map_view_set_property;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_viewer_map_view_finalize;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY] = g_param_spec_boolean ("show-waypoints", "show-waypoints", "show-waypoints", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY] = g_param_spec_boolean ("show-markers", "show-markers", "show-markers", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY, gpx_viewer_map_view_properties[GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY] = g_param_spec_string ("map-source", "map-source", "map-source", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 992 "gpx-viewer-map-view.c"
	/**
	 * @param lat_dec the latitude of the click point in dec.
	 * @param lon_dec the longitude of the click point.
	 * 
	 * Fired when the users right or middle clicks on the  map.
	 */
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_CLICKED_SIGNAL] = g_signal_new ("clicked", GPX_VIEWER_TYPE_MAP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
#line 1001 "gpx-viewer-map-view.c"
	/**
	 * @param zoom the current zoom level.
	 * @param min_zoom the minimum supported zoom level.
	 * @param max_zoom the maximum supported zoom level.
	 * 
	 * Fired when the zoomlevel changed.
	 */
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	gpx_viewer_map_view_signals[GPX_VIEWER_MAP_VIEW_ZOOM_LEVEL_CHANGED_SIGNAL] = g_signal_new ("zoom-level-changed", GPX_VIEWER_TYPE_MAP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
#line 1011 "gpx-viewer-map-view.c"
}

static void
gpx_viewer_map_view_instance_init (GpxViewerMapView * self,
                                   gpointer klass)
{
	ChamplainMarkerLayer* _tmp0_;
	ChamplainMarkerLayer* _tmp1_;
	GtkListStore* _tmp2_;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv = gpx_viewer_map_view_get_instance_private (self);
#line 26 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->view = NULL;
#line 31 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->click_marker = NULL;
#line 94 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp0_ = champlain_marker_layer_new ();
#line 94 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_ref_sink (_tmp0_);
#line 94 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->waypoint_layer = _tmp0_;
#line 95 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->_show_waypoints = FALSE;
#line 111 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp1_ = champlain_marker_layer_new ();
#line 111 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_object_ref_sink (_tmp1_);
#line 111 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->marker_layer = _tmp1_;
#line 113 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->_show_markers = TRUE;
#line 129 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 129 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->map_source_list = _tmp2_;
#line 131 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self->priv->_map_source = NULL;
#line 1049 "gpx-viewer-map-view.c"
}

static void
gpx_viewer_map_view_finalize (GObject * obj)
{
	GpxViewerMapView * self;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
#line 222 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	g_debug ("gpx-viewer-map-view.vala:222: Destroying map-view");
#line 31 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (self->priv->click_marker);
#line 94 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (self->priv->waypoint_layer);
#line 111 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (self->priv->marker_layer);
#line 129 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_object_unref0 (self->priv->map_source_list);
#line 131 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	_g_free0 (self->priv->_map_source);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	G_OBJECT_CLASS (gpx_viewer_map_view_parent_class)->finalize (obj);
#line 1072 "gpx-viewer-map-view.c"
}

static GType
gpx_viewer_map_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxViewerMapViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_viewer_map_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxViewerMapView), 0, (GInstanceInitFunc) gpx_viewer_map_view_instance_init, NULL };
	GType gpx_viewer_map_view_type_id;
	gpx_viewer_map_view_type_id = g_type_register_static (gtk_champlain_embed_get_type (), "GpxViewerMapView", &g_define_type_info, 0);
	GpxViewerMapView_private_offset = g_type_add_instance_private (gpx_viewer_map_view_type_id, sizeof (GpxViewerMapViewPrivate));
	return gpx_viewer_map_view_type_id;
}

GType
gpx_viewer_map_view_get_type (void)
{
	static volatile gsize gpx_viewer_map_view_type_id__once = 0;
	if (g_once_init_enter (&gpx_viewer_map_view_type_id__once)) {
		GType gpx_viewer_map_view_type_id;
		gpx_viewer_map_view_type_id = gpx_viewer_map_view_get_type_once ();
		g_once_init_leave (&gpx_viewer_map_view_type_id__once, gpx_viewer_map_view_type_id);
	}
	return gpx_viewer_map_view_type_id__once;
}

static void
_vala_gpx_viewer_map_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GpxViewerMapView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	switch (property_id) {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_value_set_boolean (value, gpx_viewer_map_view_get_show_waypoints (self));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_value_set_boolean (value, gpx_viewer_map_view_get_show_markers (self));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		g_value_set_string (value, gpx_viewer_map_view_get_map_source (self));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 1125 "gpx-viewer-map-view.c"
		default:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 1131 "gpx-viewer-map-view.c"
	}
}

static void
_vala_gpx_viewer_map_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GpxViewerMapView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_MAP_VIEW, GpxViewerMapView);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
	switch (property_id) {
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_SHOW_WAYPOINTS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		gpx_viewer_map_view_set_show_waypoints (self, g_value_get_boolean (value));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_SHOW_MARKERS_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		gpx_viewer_map_view_set_show_markers (self, g_value_get_boolean (value));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		case GPX_VIEWER_MAP_VIEW_MAP_SOURCE_PROPERTY:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		gpx_viewer_map_view_set_map_source (self, g_value_get_string (value));
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 1163 "gpx-viewer-map-view.c"
		default:
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "../gpx-viewer/libgpx/gpx-viewer-map-view.vala"
		break;
#line 1169 "gpx-viewer-map-view.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

