// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
)

// AlertmanagerLimitsSpecApplyConfiguration represents a declarative configuration of the AlertmanagerLimitsSpec type for use
// with apply.
type AlertmanagerLimitsSpecApplyConfiguration struct {
	MaxSilences        *int32                 `json:"maxSilences,omitempty"`
	MaxPerSilenceBytes *monitoringv1.ByteSize `json:"maxPerSilenceBytes,omitempty"`
}

// AlertmanagerLimitsSpecApplyConfiguration constructs a declarative configuration of the AlertmanagerLimitsSpec type for use with
// apply.
func AlertmanagerLimitsSpec() *AlertmanagerLimitsSpecApplyConfiguration {
	return &AlertmanagerLimitsSpecApplyConfiguration{}
}

// WithMaxSilences sets the MaxSilences field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxSilences field is set to the value of the last call.
func (b *AlertmanagerLimitsSpecApplyConfiguration) WithMaxSilences(value int32) *AlertmanagerLimitsSpecApplyConfiguration {
	b.MaxSilences = &value
	return b
}

// WithMaxPerSilenceBytes sets the MaxPerSilenceBytes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxPerSilenceBytes field is set to the value of the last call.
func (b *AlertmanagerLimitsSpecApplyConfiguration) WithMaxPerSilenceBytes(value monitoringv1.ByteSize) *AlertmanagerLimitsSpecApplyConfiguration {
	b.MaxPerSilenceBytes = &value
	return b
}
