{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure which contains a single flags value, its name, and its
-- nickname.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.FlagsValue
    ( 

-- * Exported types
    FlagsValue(..)                          ,
    newZeroFlagsValue                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFlagsValueMethod                 ,
#endif



 -- * Properties


-- ** value #attr:value#
-- | the flags value

#if defined(ENABLE_OVERLOADING)
    flagsValue_value                        ,
#endif
    getFlagsValueValue                      ,
    setFlagsValueValue                      ,


-- ** valueName #attr:valueName#
-- | the name of the value

    clearFlagsValueValueName                ,
#if defined(ENABLE_OVERLOADING)
    flagsValue_valueName                    ,
#endif
    getFlagsValueValueName                  ,
    setFlagsValueValueName                  ,


-- ** valueNick #attr:valueNick#
-- | the nickname of the value

    clearFlagsValueValueNick                ,
#if defined(ENABLE_OVERLOADING)
    flagsValue_valueNick                    ,
#endif
    getFlagsValueValueNick                  ,
    setFlagsValueValueNick                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype FlagsValue = FlagsValue (SP.ManagedPtr FlagsValue)
    deriving (Eq)

instance SP.ManagedPtrNewtype FlagsValue where
    toManagedPtr (FlagsValue p) = p

instance BoxedPtr FlagsValue where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr FlagsValue)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr FlagsValue where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'FlagsValue' struct initialized to zero.
newZeroFlagsValue :: MonadIO m => m FlagsValue
newZeroFlagsValue = liftIO $ boxedPtrCalloc >>= wrapPtr FlagsValue

instance tag ~ 'AttrSet => Constructible FlagsValue tag where
    new _ attrs = do
        o <- newZeroFlagsValue
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsValue #value
-- @
getFlagsValueValue :: MonadIO m => FlagsValue -> m Word32
getFlagsValueValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsValue [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsValueValue :: MonadIO m => FlagsValue -> Word32 -> m ()
setFlagsValueValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FlagsValueValueFieldInfo
instance AttrInfo FlagsValueValueFieldInfo where
    type AttrBaseTypeConstraint FlagsValueValueFieldInfo = (~) FlagsValue
    type AttrAllowedOps FlagsValueValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FlagsValueValueFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FlagsValueValueFieldInfo = (~)Word32
    type AttrTransferType FlagsValueValueFieldInfo = Word32
    type AttrGetType FlagsValueValueFieldInfo = Word32
    type AttrLabel FlagsValueValueFieldInfo = "value"
    type AttrOrigin FlagsValueValueFieldInfo = FlagsValue
    attrGet = getFlagsValueValue
    attrSet = setFlagsValueValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsValue.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsValue.html#g:attr:value"
        })

flagsValue_value :: AttrLabelProxy "value"
flagsValue_value = AttrLabelProxy

#endif


-- | Get the value of the “@value_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsValue #valueName
-- @
getFlagsValueValueName :: MonadIO m => FlagsValue -> m (Maybe T.Text)
getFlagsValueValueName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsValue [ #valueName 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsValueValueName :: MonadIO m => FlagsValue -> CString -> m ()
setFlagsValueValueName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@value_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueName
-- @
clearFlagsValueValueName :: MonadIO m => FlagsValue -> m ()
clearFlagsValueValueName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data FlagsValueValueNameFieldInfo
instance AttrInfo FlagsValueValueNameFieldInfo where
    type AttrBaseTypeConstraint FlagsValueValueNameFieldInfo = (~) FlagsValue
    type AttrAllowedOps FlagsValueValueNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FlagsValueValueNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint FlagsValueValueNameFieldInfo = (~)CString
    type AttrTransferType FlagsValueValueNameFieldInfo = CString
    type AttrGetType FlagsValueValueNameFieldInfo = Maybe T.Text
    type AttrLabel FlagsValueValueNameFieldInfo = "value_name"
    type AttrOrigin FlagsValueValueNameFieldInfo = FlagsValue
    attrGet = getFlagsValueValueName
    attrSet = setFlagsValueValueName
    attrConstruct = undefined
    attrClear = clearFlagsValueValueName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsValue.valueName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsValue.html#g:attr:valueName"
        })

flagsValue_valueName :: AttrLabelProxy "valueName"
flagsValue_valueName = AttrLabelProxy

#endif


-- | Get the value of the “@value_nick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' flagsValue #valueNick
-- @
getFlagsValueValueNick :: MonadIO m => FlagsValue -> m (Maybe T.Text)
getFlagsValueValueNick s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value_nick@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' flagsValue [ #valueNick 'Data.GI.Base.Attributes.:=' value ]
-- @
setFlagsValueValueNick :: MonadIO m => FlagsValue -> CString -> m ()
setFlagsValueValueNick s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@value_nick@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #valueNick
-- @
clearFlagsValueValueNick :: MonadIO m => FlagsValue -> m ()
clearFlagsValueValueNick s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data FlagsValueValueNickFieldInfo
instance AttrInfo FlagsValueValueNickFieldInfo where
    type AttrBaseTypeConstraint FlagsValueValueNickFieldInfo = (~) FlagsValue
    type AttrAllowedOps FlagsValueValueNickFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FlagsValueValueNickFieldInfo = (~) CString
    type AttrTransferTypeConstraint FlagsValueValueNickFieldInfo = (~)CString
    type AttrTransferType FlagsValueValueNickFieldInfo = CString
    type AttrGetType FlagsValueValueNickFieldInfo = Maybe T.Text
    type AttrLabel FlagsValueValueNickFieldInfo = "value_nick"
    type AttrOrigin FlagsValueValueNickFieldInfo = FlagsValue
    attrGet = getFlagsValueValueNick
    attrSet = setFlagsValueValueNick
    attrConstruct = undefined
    attrClear = clearFlagsValueValueNick
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.FlagsValue.valueNick"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-FlagsValue.html#g:attr:valueNick"
        })

flagsValue_valueNick :: AttrLabelProxy "valueNick"
flagsValue_valueNick = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FlagsValue
type instance O.AttributeList FlagsValue = FlagsValueAttributeList
type FlagsValueAttributeList = ('[ '("value", FlagsValueValueFieldInfo), '("valueName", FlagsValueValueNameFieldInfo), '("valueNick", FlagsValueValueNickFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFlagsValueMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFlagsValueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFlagsValueMethod t FlagsValue, O.OverloadedMethod info FlagsValue p) => OL.IsLabel t (FlagsValue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFlagsValueMethod t FlagsValue, O.OverloadedMethod info FlagsValue p, R.HasField t FlagsValue p) => R.HasField t FlagsValue p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFlagsValueMethod t FlagsValue, O.OverloadedMethodInfo info FlagsValue) => OL.IsLabel t (O.MethodProxy info FlagsValue) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


