{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure containing a weak reference to a t'GI.GObject.Objects.Object.Object'.
-- 
-- A @GWeakRef@ can either be empty (i.e. point to 'P.Nothing'), or point to an
-- object for as long as at least one \"strong\" reference to that object
-- exists. Before the object\'s t'GI.GObject.Structs.ObjectClass.ObjectClass'.@/dispose/@ method is called,
-- every t'GI.GObject.Structs.WeakRef.WeakRef' associated with becomes empty (i.e. points to 'P.Nothing').
-- 
-- Like t'GI.GObject.Structs.Value.Value', t'GI.GObject.Structs.WeakRef.WeakRef' can be statically allocated, stack- or
-- heap-allocated, or embedded in larger structures.
-- 
-- Unlike @/g_object_weak_ref()/@ and @/g_object_add_weak_pointer()/@, this weak
-- reference is thread-safe: converting a weak pointer to a reference is
-- atomic with respect to invalidation of weak pointers to destroyed
-- objects.
-- 
-- If the object\'s t'GI.GObject.Structs.ObjectClass.ObjectClass'.@/dispose/@ method results in additional
-- references to the object being held (‘re-referencing’), any @/GWeakRefs/@ taken
-- before it was disposed will continue to point to 'P.Nothing'.  Any @/GWeakRefs/@ taken
-- during disposal and after re-referencing, or after disposal has returned due
-- to the re-referencing, will continue to point to the object until its refcount
-- goes back to zero, at which point they too will be invalidated.
-- 
-- It is invalid to take a t'GI.GObject.Structs.WeakRef.WeakRef' on an object during t'GI.GObject.Structs.ObjectClass.ObjectClass'.@/dispose/@
-- without first having or creating a strong reference to the object.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.WeakRef
    ( 

-- * Exported types
    WeakRef(..)                             ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveWeakRefMethod                    ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype WeakRef = WeakRef (SP.ManagedPtr WeakRef)
    deriving (Eq)

instance SP.ManagedPtrNewtype WeakRef where
    toManagedPtr (WeakRef p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr WeakRef where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WeakRef
type instance O.AttributeList WeakRef = WeakRefAttributeList
type WeakRefAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveWeakRefMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWeakRefMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWeakRefMethod t WeakRef, O.OverloadedMethod info WeakRef p) => OL.IsLabel t (WeakRef -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWeakRefMethod t WeakRef, O.OverloadedMethod info WeakRef p, R.HasField t WeakRef p) => R.HasField t WeakRef p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWeakRefMethod t WeakRef, O.OverloadedMethodInfo info WeakRef) => OL.IsLabel t (O.MethodProxy info WeakRef) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


