// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{SparqlConnection, SparqlValueType};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute, pin::Pin, ptr};

glib::wrapper! {
    #[doc(alias = "TrackerSparqlCursor")]
    pub struct SparqlCursor(Object<ffi::TrackerSparqlCursor, ffi::TrackerSparqlCursorClass>);

    match fn {
        type_ => || ffi::tracker_sparql_cursor_get_type(),
    }
}

impl SparqlCursor {
    #[doc(alias = "tracker_sparql_cursor_close")]
    pub fn close(&self) {
        unsafe {
            ffi::tracker_sparql_cursor_close(self.to_glib_none().0);
        }
    }

    #[doc(alias = "tracker_sparql_cursor_get_boolean")]
    #[doc(alias = "get_boolean")]
    pub fn is_boolean(&self, column: i32) -> bool {
        unsafe {
            from_glib(ffi::tracker_sparql_cursor_get_boolean(
                self.to_glib_none().0,
                column,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_cursor_get_connection")]
    #[doc(alias = "get_connection")]
    pub fn connection(&self) -> Option<SparqlConnection> {
        unsafe {
            from_glib_none(ffi::tracker_sparql_cursor_get_connection(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_2")))]
    #[doc(alias = "tracker_sparql_cursor_get_datetime")]
    #[doc(alias = "get_datetime")]
    pub fn datetime(&self, column: i32) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::tracker_sparql_cursor_get_datetime(
                self.to_glib_none().0,
                column,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_cursor_get_double")]
    #[doc(alias = "get_double")]
    pub fn double(&self, column: i32) -> f64 {
        unsafe { ffi::tracker_sparql_cursor_get_double(self.to_glib_none().0, column) }
    }

    #[doc(alias = "tracker_sparql_cursor_get_integer")]
    #[doc(alias = "get_integer")]
    pub fn integer(&self, column: i32) -> i64 {
        unsafe { ffi::tracker_sparql_cursor_get_integer(self.to_glib_none().0, column) }
    }

    #[doc(alias = "tracker_sparql_cursor_get_n_columns")]
    #[doc(alias = "get_n_columns")]
    pub fn n_columns(&self) -> i32 {
        unsafe { ffi::tracker_sparql_cursor_get_n_columns(self.to_glib_none().0) }
    }

    #[doc(alias = "tracker_sparql_cursor_get_value_type")]
    #[doc(alias = "get_value_type")]
    pub fn value_type(&self, column: i32) -> SparqlValueType {
        unsafe {
            from_glib(ffi::tracker_sparql_cursor_get_value_type(
                self.to_glib_none().0,
                column,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_cursor_get_variable_name")]
    #[doc(alias = "get_variable_name")]
    pub fn variable_name(&self, column: i32) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::tracker_sparql_cursor_get_variable_name(
                self.to_glib_none().0,
                column,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_cursor_is_bound")]
    pub fn is_bound(&self, column: i32) -> bool {
        unsafe {
            from_glib(ffi::tracker_sparql_cursor_is_bound(
                self.to_glib_none().0,
                column,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_cursor_next")]
    pub fn next(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<bool, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::tracker_sparql_cursor_next(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "tracker_sparql_cursor_next_async")]
    pub fn next_async<P: FnOnce(Result<bool, glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn next_async_trampoline<
            P: FnOnce(Result<bool, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::tracker_sparql_cursor_next_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = next_async_trampoline::<P>;
        unsafe {
            ffi::tracker_sparql_cursor_next_async(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn next_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<bool, glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.next_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[cfg_attr(feature = "v3_5", deprecated = "Since 3.5")]
    #[allow(deprecated)]
    #[doc(alias = "tracker_sparql_cursor_rewind")]
    pub fn rewind(&self) {
        unsafe {
            ffi::tracker_sparql_cursor_rewind(self.to_glib_none().0);
        }
    }

    #[doc(alias = "n-columns")]
    pub fn connect_n_columns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_columns_trampoline<F: Fn(&SparqlCursor) + 'static>(
            this: *mut ffi::TrackerSparqlCursor,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-columns\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_n_columns_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for SparqlCursor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SparqlCursor")
    }
}
