// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{SparqlConnection, SparqlCursor};
use glib::{prelude::*, translate::*};
use std::{boxed::Box as Box_, fmt, pin::Pin, ptr};

glib::wrapper! {
    #[doc(alias = "TrackerSparqlStatement")]
    pub struct SparqlStatement(Object<ffi::TrackerSparqlStatement, ffi::TrackerSparqlStatementClass>);

    match fn {
        type_ => || ffi::tracker_sparql_statement_get_type(),
    }
}

impl SparqlStatement {
    #[doc(alias = "tracker_sparql_statement_bind_boolean")]
    pub fn bind_boolean(&self, name: &str, value: bool) {
        unsafe {
            ffi::tracker_sparql_statement_bind_boolean(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v3_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_2")))]
    #[doc(alias = "tracker_sparql_statement_bind_datetime")]
    pub fn bind_datetime(&self, name: &str, value: &glib::DateTime) {
        unsafe {
            ffi::tracker_sparql_statement_bind_datetime(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_sparql_statement_bind_double")]
    pub fn bind_double(&self, name: &str, value: f64) {
        unsafe {
            ffi::tracker_sparql_statement_bind_double(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_sparql_statement_bind_int")]
    pub fn bind_int(&self, name: &str, value: i64) {
        unsafe {
            ffi::tracker_sparql_statement_bind_int(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value,
            );
        }
    }

    #[doc(alias = "tracker_sparql_statement_bind_string")]
    pub fn bind_string(&self, name: &str, value: &str) {
        unsafe {
            ffi::tracker_sparql_statement_bind_string(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "tracker_sparql_statement_clear_bindings")]
    pub fn clear_bindings(&self) {
        unsafe {
            ffi::tracker_sparql_statement_clear_bindings(self.to_glib_none().0);
        }
    }

    #[doc(alias = "tracker_sparql_statement_execute")]
    pub fn execute(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<SparqlCursor, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::tracker_sparql_statement_execute(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "tracker_sparql_statement_execute_async")]
    pub fn execute_async<P: FnOnce(Result<SparqlCursor, glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn execute_async_trampoline<
            P: FnOnce(Result<SparqlCursor, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::tracker_sparql_statement_execute_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = execute_async_trampoline::<P>;
        unsafe {
            ffi::tracker_sparql_statement_execute_async(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn execute_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<SparqlCursor, glib::Error>> + 'static>>
    {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.execute_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "tracker_sparql_statement_get_connection")]
    #[doc(alias = "get_connection")]
    pub fn connection(&self) -> Option<SparqlConnection> {
        unsafe {
            from_glib_none(ffi::tracker_sparql_statement_get_connection(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "tracker_sparql_statement_get_sparql")]
    #[doc(alias = "get_sparql")]
    pub fn sparql(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::tracker_sparql_statement_get_sparql(
                self.to_glib_none().0,
            ))
        }
    }

    //#[cfg(any(feature = "v3_3", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_3")))]
    //#[doc(alias = "tracker_sparql_statement_serialize_async")]
    //pub fn serialize_async<P: FnOnce(Result<gio::InputStream, glib::Error>) + 'static>(&self, flags: /*Ignored*/SerializeFlags, format: /*Ignored*/RdfFormat, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: P) {
    //    unsafe { TODO: call ffi:tracker_sparql_statement_serialize_async() }
    //}

    //
    //#[cfg(any(feature = "v3_3", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v3_3")))]
    //pub fn serialize_future(&self, flags: /*Ignored*/SerializeFlags, format: /*Ignored*/RdfFormat) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::InputStream, glib::Error>> + 'static>> {

    //Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.serialize_async(
    //        flags,
    //        format,
    //        Some(cancellable),
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    #[cfg(any(feature = "v3_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_5")))]
    #[doc(alias = "tracker_sparql_statement_update")]
    pub fn update(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::tracker_sparql_statement_update(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v3_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_5")))]
    #[doc(alias = "tracker_sparql_statement_update_async")]
    pub fn update_async<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn update_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::tracker_sparql_statement_update_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = update_async_trampoline::<P>;
        unsafe {
            ffi::tracker_sparql_statement_update_async(
                self.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(any(feature = "v3_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v3_5")))]
    pub fn update_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.update_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }
}

impl fmt::Display for SparqlStatement {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SparqlStatement")
    }
}
