#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 259
#define LARGE_STATE_COUNT 4
#define SYMBOL_COUNT 116
#define ALIAS_COUNT 0
#define TOKEN_COUNT 56
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 18
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 30

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_LPAREN = 3,
  anon_sym_COMMA = 4,
  anon_sym_RPAREN = 5,
  anon_sym_module = 6,
  anon_sym_function = 7,
  anon_sym_EQ = 8,
  anon_sym_include = 9,
  anon_sym_use = 10,
  sym_include_path = 11,
  anon_sym_LBRACE = 12,
  anon_sym_RBRACE = 13,
  anon_sym_for = 14,
  anon_sym_intersection_for = 15,
  anon_sym_let = 16,
  anon_sym_assign = 17,
  anon_sym_if = 18,
  anon_sym_else = 19,
  anon_sym_STAR = 20,
  anon_sym_BANG = 21,
  anon_sym_POUND = 22,
  anon_sym_PERCENT = 23,
  anon_sym_LBRACK = 24,
  anon_sym_COLON = 25,
  anon_sym_RBRACK = 26,
  anon_sym_each = 27,
  anon_sym_DOT = 28,
  anon_sym_DASH = 29,
  anon_sym_PLUS = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_AMP_AMP = 32,
  anon_sym_EQ_EQ = 33,
  anon_sym_BANG_EQ = 34,
  anon_sym_LT = 35,
  anon_sym_GT = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_GT_EQ = 38,
  anon_sym_SLASH = 39,
  anon_sym_CARET = 40,
  anon_sym_QMARK = 41,
  anon_sym_assert = 42,
  anon_sym_echo = 43,
  anon_sym_DOLLAR = 44,
  sym_escape_sequence = 45,
  anon_sym_DQUOTE = 46,
  aux_sym_string_token1 = 47,
  sym_integer = 48,
  sym_float = 49,
  anon_sym_true = 50,
  anon_sym_false = 51,
  sym_undef = 52,
  sym_block_comment = 53,
  anon_sym_SLASH_SLASH = 54,
  aux_sym_line_comment_token1 = 55,
  sym_source_file = 56,
  sym_expression = 57,
  sym_statement = 58,
  sym__item = 59,
  sym_parameter = 60,
  sym_parameters = 61,
  sym_var_declaration = 62,
  sym_module_item = 63,
  sym_function_item = 64,
  sym_include_statement = 65,
  sym_use_statement = 66,
  sym_assignment = 67,
  sym_union_block = 68,
  sym_for_block = 69,
  sym_intersection_for_block = 70,
  sym_let_block = 71,
  sym_assign_block = 72,
  sym_if_block = 73,
  sym_modifier = 74,
  sym_transform_chain = 75,
  sym_module_call = 76,
  sym_arguments = 77,
  sym_assignments = 78,
  sym_parenthesized_expression = 79,
  sym_condition_update_clause = 80,
  sym_let_expression = 81,
  sym_literal = 82,
  sym_function_lit = 83,
  sym_range = 84,
  sym_list = 85,
  sym__list_cell = 86,
  sym__comprehension_cell = 87,
  sym_each = 88,
  sym_list_comprehension = 89,
  sym_let_prefix = 90,
  sym_for_clause = 91,
  sym_if_clause = 92,
  sym_function_call = 93,
  sym_index_expression = 94,
  sym_dot_index_expression = 95,
  sym_unary_expression = 96,
  sym_binary_expression = 97,
  sym_ternary_expression = 98,
  sym_assert_statement = 99,
  sym_assert_expression = 100,
  sym_echo_expression = 101,
  sym_special_variable = 102,
  sym__variable_name = 103,
  sym_string = 104,
  sym_number = 105,
  sym_boolean = 106,
  sym_line_comment = 107,
  aux_sym_source_file_repeat1 = 108,
  aux_sym_parameters_repeat1 = 109,
  aux_sym_union_block_repeat1 = 110,
  aux_sym_transform_chain_repeat1 = 111,
  aux_sym_arguments_repeat1 = 112,
  aux_sym_assignments_repeat1 = 113,
  aux_sym_list_repeat1 = 114,
  aux_sym_string_repeat1 = 115,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_module] = "module",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_include] = "include",
  [anon_sym_use] = "use",
  [sym_include_path] = "include_path",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [anon_sym_assert] = "assert",
  [anon_sym_echo] = "echo",
  [anon_sym_DOLLAR] = "$",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_undef] = "undef",
  [sym_block_comment] = "block_comment",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_line_comment_token1] = "line_comment_token1",
  [sym_source_file] = "source_file",
  [sym_expression] = "expression",
  [sym_statement] = "statement",
  [sym__item] = "_item",
  [sym_parameter] = "parameter",
  [sym_parameters] = "parameters",
  [sym_var_declaration] = "var_declaration",
  [sym_module_item] = "module_item",
  [sym_function_item] = "function_item",
  [sym_include_statement] = "include_statement",
  [sym_use_statement] = "use_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_assignments] = "assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym_let_expression] = "let_expression",
  [sym_literal] = "literal",
  [sym_function_lit] = "function_lit",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym__comprehension_cell] = "_comprehension_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_let_prefix] = "let_prefix",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_assert_statement] = "assert_statement",
  [sym_assert_expression] = "assert_expression",
  [sym_echo_expression] = "echo_expression",
  [sym_special_variable] = "special_variable",
  [sym__variable_name] = "_variable_name",
  [sym_string] = "string",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_line_comment] = "line_comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_transform_chain_repeat1] = "transform_chain_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_assignments_repeat1] = "assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_use] = anon_sym_use,
  [sym_include_path] = sym_include_path,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_undef] = sym_undef,
  [sym_block_comment] = sym_block_comment,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_line_comment_token1] = aux_sym_line_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym_expression] = sym_expression,
  [sym_statement] = sym_statement,
  [sym__item] = sym__item,
  [sym_parameter] = sym_parameter,
  [sym_parameters] = sym_parameters,
  [sym_var_declaration] = sym_var_declaration,
  [sym_module_item] = sym_module_item,
  [sym_function_item] = sym_function_item,
  [sym_include_statement] = sym_include_statement,
  [sym_use_statement] = sym_use_statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_assignments] = sym_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym_let_expression] = sym_let_expression,
  [sym_literal] = sym_literal,
  [sym_function_lit] = sym_function_lit,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym__comprehension_cell] = sym__comprehension_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_let_prefix] = sym_let_prefix,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_assert_statement] = sym_assert_statement,
  [sym_assert_expression] = sym_assert_expression,
  [sym_echo_expression] = sym_echo_expression,
  [sym_special_variable] = sym_special_variable,
  [sym__variable_name] = sym__variable_name,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_line_comment] = sym_line_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_transform_chain_repeat1] = aux_sym_transform_chain_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_assignments_repeat1] = aux_sym_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_undef] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_line_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_item] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym__comprehension_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_let_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_echo_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transform_chain_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_expression = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_statement = 16,
  field_update = 17,
  field_value = 18,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_expression] = "expression",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_statement] = "statement",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 3},
  [7] = {.index = 12, .length = 1},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 2},
  [11] = {.index = 19, .length = 2},
  [12] = {.index = 21, .length = 4},
  [13] = {.index = 25, .length = 2},
  [14] = {.index = 27, .length = 1},
  [15] = {.index = 28, .length = 2},
  [16] = {.index = 30, .length = 2},
  [17] = {.index = 32, .length = 3},
  [18] = {.index = 35, .length = 3},
  [19] = {.index = 38, .length = 1},
  [20] = {.index = 39, .length = 3},
  [21] = {.index = 42, .length = 3},
  [22] = {.index = 45, .length = 2},
  [23] = {.index = 47, .length = 2},
  [24] = {.index = 49, .length = 3},
  [25] = {.index = 52, .length = 3},
  [26] = {.index = 55, .length = 3},
  [27] = {.index = 58, .length = 4},
  [28] = {.index = 62, .length = 4},
  [29] = {.index = 66, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_arguments, 1},
    {field_statement, 2},
  [7] =
    {field_name, 0},
    {field_value, 2},
  [9] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [12] =
    {field_arguments, 1},
  [13] =
    {field_body, 2},
    {field_parameters, 1},
  [15] =
    {field_arguments, 1},
    {field_expression, 2},
  [17] =
    {field_left, 0},
    {field_right, 2},
  [19] =
    {field_index, 2},
    {field_value, 0},
  [21] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [25] =
    {field_name, 1},
    {field_parameters, 2},
  [27] =
    {field_value, 0},
  [28] =
    {field_end, 3},
    {field_start, 1},
  [30] =
    {field_condition, 2},
    {field_consequence, 3},
  [32] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [35] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [38] =
    {field_condition, 2},
  [39] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [42] =
    {field_alternative, 5},
    {field_condition, 2},
    {field_consequence, 3},
  [45] =
    {field_condition, 2},
    {field_update, 4},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
  [49] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [52] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [58] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [62] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [66] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 24,
  [30] = 30,
  [31] = 25,
  [32] = 27,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 34,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 18,
  [93] = 17,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 15,
  [109] = 16,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 114,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 137,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 57,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 200,
  [221] = 218,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 31,
        '"', 56,
        '#', 32,
        '$', 54,
        '%', 33,
        '&', 3,
        '(', 23,
        ')', 25,
        '*', 30,
        '+', 41,
        ',', 24,
        '-', 40,
        '.', 38,
        '/', 50,
        ':', 35,
        ';', 22,
        '<', 46,
        '=', 26,
        '>', 47,
        '?', 52,
        '[', 34,
        '\\', 9,
        ']', 36,
        '^', 51,
        '{', 28,
        '|', 11,
        '}', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 31,
        '#', 32,
        '%', 33,
        '&', 3,
        '(', 23,
        ')', 25,
        '*', 30,
        '+', 41,
        ',', 24,
        '-', 39,
        '.', 37,
        '/', 50,
        ':', 35,
        ';', 22,
        '<', 46,
        '=', 26,
        '>', 47,
        '?', 52,
        '[', 34,
        ']', 36,
        '^', 51,
        '{', 28,
        '|', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(56);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0) ADVANCE(61);
      END_STATE();
    case 3:
      if (lookahead == '&') ADVANCE(43);
      END_STATE();
    case 4:
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(67);
      END_STATE();
    case 5:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead == '/') ADVANCE(65);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(5);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(4);
      if (lookahead == '<') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '>') ADVANCE(27);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == 'u') ADVANCE(10);
      if (lookahead == 'x') ADVANCE(19);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 10:
      if (lookahead == '{') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 11:
      if (lookahead == '|') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 14:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 18:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 20:
      if (eof) ADVANCE(21);
      ADVANCE_MAP(
        '!', 31,
        '"', 56,
        '#', 32,
        '$', 54,
        '%', 33,
        '&', 3,
        '(', 23,
        ')', 25,
        '*', 30,
        '+', 41,
        ',', 24,
        '-', 40,
        '.', 38,
        '/', 50,
        ':', 35,
        ';', 22,
        '<', 46,
        '=', 26,
        '>', 47,
        '?', 52,
        '[', 34,
        ']', 36,
        '^', 51,
        '{', 28,
        '|', 11,
        '}', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(44);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(48);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(49);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(6);
      if (lookahead == '/') ADVANCE(67);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(61);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_block_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(73);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(73);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead != 0) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '/') ADVANCE(68);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(73);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(73);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'e', 2,
        'f', 3,
        'i', 4,
        'l', 5,
        'm', 6,
        't', 7,
        'u', 8,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(9);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(10);
      if (lookahead == 'c') ADVANCE(11);
      if (lookahead == 'l') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'c') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 's') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(27);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(30);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(39);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(42);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'g') ADVANCE(50);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_echo);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(56);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 53:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_undef);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(64);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(67);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(72);
      END_STATE();
    case 72:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 73:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 0},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 2},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 2},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 7},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 72},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 7},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_line_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_undef] = ACTIONS(1),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_SLASH_SLASH] = ACTIONS(5),
  },
  [1] = {
    [sym_source_file] = STATE(255),
    [sym_statement] = STATE(144),
    [sym__item] = STATE(160),
    [sym_var_declaration] = STATE(144),
    [sym_module_item] = STATE(144),
    [sym_function_item] = STATE(144),
    [sym_include_statement] = STATE(120),
    [sym_use_statement] = STATE(160),
    [sym_assignment] = STATE(245),
    [sym_union_block] = STATE(120),
    [sym_for_block] = STATE(120),
    [sym_intersection_for_block] = STATE(120),
    [sym_let_block] = STATE(120),
    [sym_assign_block] = STATE(120),
    [sym_if_block] = STATE(120),
    [sym_modifier] = STATE(179),
    [sym_transform_chain] = STATE(120),
    [sym_module_call] = STATE(68),
    [sym_assert_statement] = STATE(120),
    [sym_special_variable] = STATE(80),
    [sym__variable_name] = STATE(254),
    [sym_line_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(21),
    [aux_sym_transform_chain_repeat1] = STATE(164),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_module] = ACTIONS(13),
    [anon_sym_function] = ACTIONS(15),
    [anon_sym_include] = ACTIONS(17),
    [anon_sym_use] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_for] = ACTIONS(23),
    [anon_sym_intersection_for] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_assign] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_POUND] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(33),
    [anon_sym_assert] = ACTIONS(35),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_SLASH_SLASH] = ACTIONS(5),
  },
  [2] = {
    [sym_expression] = STATE(84),
    [sym_parenthesized_expression] = STATE(104),
    [sym_let_expression] = STATE(104),
    [sym_literal] = STATE(104),
    [sym_function_lit] = STATE(101),
    [sym_range] = STATE(101),
    [sym_list] = STATE(101),
    [sym_function_call] = STATE(104),
    [sym_index_expression] = STATE(104),
    [sym_dot_index_expression] = STATE(104),
    [sym_unary_expression] = STATE(104),
    [sym_binary_expression] = STATE(104),
    [sym_ternary_expression] = STATE(104),
    [sym_assert_expression] = STATE(104),
    [sym_echo_expression] = STATE(104),
    [sym_special_variable] = STATE(80),
    [sym__variable_name] = STATE(104),
    [sym_string] = STATE(101),
    [sym_number] = STATE(101),
    [sym_boolean] = STATE(101),
    [sym_line_comment] = STATE(2),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_SEMI] = ACTIONS(41),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(41),
    [anon_sym_function] = ACTIONS(45),
    [anon_sym_let] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_COLON] = ACTIONS(41),
    [anon_sym_RBRACK] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(41),
    [anon_sym_AMP_AMP] = ACTIONS(41),
    [anon_sym_EQ_EQ] = ACTIONS(41),
    [anon_sym_BANG_EQ] = ACTIONS(41),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(49),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(41),
    [anon_sym_SLASH] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(41),
    [anon_sym_QMARK] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_echo] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_integer] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(67),
    [anon_sym_false] = ACTIONS(67),
    [sym_undef] = ACTIONS(69),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_SLASH_SLASH] = ACTIONS(5),
  },
  [3] = {
    [sym_expression] = STATE(85),
    [sym_parenthesized_expression] = STATE(104),
    [sym_let_expression] = STATE(104),
    [sym_literal] = STATE(104),
    [sym_function_lit] = STATE(101),
    [sym_range] = STATE(101),
    [sym_list] = STATE(101),
    [sym_function_call] = STATE(104),
    [sym_index_expression] = STATE(104),
    [sym_dot_index_expression] = STATE(104),
    [sym_unary_expression] = STATE(104),
    [sym_binary_expression] = STATE(104),
    [sym_ternary_expression] = STATE(104),
    [sym_assert_expression] = STATE(104),
    [sym_echo_expression] = STATE(104),
    [sym_special_variable] = STATE(80),
    [sym__variable_name] = STATE(104),
    [sym_string] = STATE(101),
    [sym_number] = STATE(101),
    [sym_boolean] = STATE(101),
    [sym_line_comment] = STATE(3),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_SEMI] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(45),
    [anon_sym_let] = ACTIONS(47),
    [anon_sym_else] = ACTIONS(73),
    [anon_sym_STAR] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PERCENT] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_COLON] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(71),
    [anon_sym_DOT] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(71),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_EQ_EQ] = ACTIONS(71),
    [anon_sym_BANG_EQ] = ACTIONS(71),
    [anon_sym_LT] = ACTIONS(73),
    [anon_sym_GT] = ACTIONS(73),
    [anon_sym_LT_EQ] = ACTIONS(71),
    [anon_sym_GT_EQ] = ACTIONS(71),
    [anon_sym_SLASH] = ACTIONS(73),
    [anon_sym_CARET] = ACTIONS(71),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_assert] = ACTIONS(59),
    [anon_sym_echo] = ACTIONS(61),
    [anon_sym_DOLLAR] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [sym_integer] = ACTIONS(65),
    [sym_float] = ACTIONS(65),
    [anon_sym_true] = ACTIONS(67),
    [anon_sym_false] = ACTIONS(67),
    [sym_undef] = ACTIONS(69),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_SLASH_SLASH] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 30,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(83), 1,
      anon_sym_RBRACK,
    ACTIONS(85), 1,
      anon_sym_each,
    STATE(4), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(117), 1,
      sym_expression,
    STATE(197), 1,
      sym_let_prefix,
    STATE(216), 1,
      sym__list_cell,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(238), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [111] = 30,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(87), 1,
      anon_sym_RBRACK,
    STATE(5), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(128), 1,
      sym_expression,
    STATE(197), 1,
      sym_let_prefix,
    STATE(223), 1,
      sym__list_cell,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(238), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [222] = 30,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(89), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(128), 1,
      sym_expression,
    STATE(197), 1,
      sym_let_prefix,
    STATE(223), 1,
      sym__list_cell,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(238), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [333] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(7), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(186), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [441] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(8), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(189), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [549] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(9), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(187), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [657] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(10), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(182), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [765] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(11), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(181), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [873] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(112), 1,
      sym_expression,
    STATE(180), 1,
      sym__comprehension_cell,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(194), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [981] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    STATE(13), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(128), 1,
      sym_expression,
    STATE(197), 1,
      sym_let_prefix,
    STATE(223), 1,
      sym__list_cell,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(238), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [1089] = 28,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(85), 1,
      anon_sym_each,
    STATE(14), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(138), 1,
      sym_expression,
    STATE(197), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(253), 2,
      sym_each,
      sym_list_comprehension,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [1194] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(15), 1,
      sym_line_comment,
    ACTIONS(93), 22,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(95), 22,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [1252] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(16), 1,
      sym_line_comment,
    ACTIONS(97), 22,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(99), 22,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [1310] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(17), 1,
      sym_line_comment,
    ACTIONS(101), 22,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(103), 22,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [1368] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(18), 1,
      sym_line_comment,
    ACTIONS(105), 22,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(107), 22,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [1426] = 27,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(19), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(113), 1,
      sym_expression,
    STATE(191), 1,
      sym_list_comprehension,
    STATE(229), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [1527] = 27,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(75), 1,
      anon_sym_for,
    ACTIONS(77), 1,
      anon_sym_let,
    ACTIONS(79), 1,
      anon_sym_if,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(20), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(111), 1,
      sym_expression,
    STATE(184), 1,
      sym_list_comprehension,
    STATE(229), 1,
      sym_let_prefix,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(190), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [1628] = 29,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_use,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(109), 1,
      ts_builtin_sym_end,
    STATE(21), 1,
      sym_line_comment,
    STATE(22), 1,
      aux_sym_source_file_repeat1,
    STATE(68), 1,
      sym_module_call,
    STATE(80), 1,
      sym_special_variable,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(245), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
    STATE(160), 2,
      sym__item,
      sym_use_statement,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 4,
      sym_statement,
      sym_var_declaration,
      sym_module_item,
      sym_function_item,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [1731] = 28,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(111), 1,
      ts_builtin_sym_end,
    ACTIONS(113), 1,
      sym_identifier,
    ACTIONS(116), 1,
      anon_sym_SEMI,
    ACTIONS(119), 1,
      anon_sym_module,
    ACTIONS(122), 1,
      anon_sym_function,
    ACTIONS(125), 1,
      anon_sym_include,
    ACTIONS(128), 1,
      anon_sym_use,
    ACTIONS(131), 1,
      anon_sym_LBRACE,
    ACTIONS(134), 1,
      anon_sym_for,
    ACTIONS(137), 1,
      anon_sym_intersection_for,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(143), 1,
      anon_sym_assign,
    ACTIONS(146), 1,
      anon_sym_if,
    ACTIONS(152), 1,
      anon_sym_assert,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    STATE(68), 1,
      sym_module_call,
    STATE(80), 1,
      sym_special_variable,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(245), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
    STATE(22), 2,
      sym_line_comment,
      aux_sym_source_file_repeat1,
    STATE(160), 2,
      sym__item,
      sym_use_statement,
    ACTIONS(149), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 4,
      sym_statement,
      sym_var_declaration,
      sym_module_item,
      sym_function_item,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [1832] = 23,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(23), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(81), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(158), 3,
      anon_sym_for,
      anon_sym_if,
      anon_sym_each,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [1922] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(160), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(132), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(235), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2015] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(162), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(114), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(200), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2108] = 27,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(164), 1,
      sym_identifier,
    ACTIONS(167), 1,
      anon_sym_SEMI,
    ACTIONS(170), 1,
      anon_sym_module,
    ACTIONS(173), 1,
      anon_sym_function,
    ACTIONS(176), 1,
      anon_sym_include,
    ACTIONS(179), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_RBRACE,
    ACTIONS(184), 1,
      anon_sym_for,
    ACTIONS(187), 1,
      anon_sym_intersection_for,
    ACTIONS(190), 1,
      anon_sym_let,
    ACTIONS(193), 1,
      anon_sym_assign,
    ACTIONS(196), 1,
      anon_sym_if,
    ACTIONS(202), 1,
      anon_sym_assert,
    ACTIONS(205), 1,
      anon_sym_DOLLAR,
    STATE(68), 1,
      sym_module_call,
    STATE(80), 1,
      sym_special_variable,
    STATE(162), 1,
      sym__item,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(245), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
    STATE(26), 2,
      sym_line_comment,
      aux_sym_union_block_repeat1,
    ACTIONS(199), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 4,
      sym_statement,
      sym_var_declaration,
      sym_module_item,
      sym_function_item,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [2205] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(208), 1,
      anon_sym_RPAREN,
    STATE(27), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(132), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(235), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2298] = 28,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(210), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      aux_sym_union_block_repeat1,
    STATE(28), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_module_call,
    STATE(80), 1,
      sym_special_variable,
    STATE(162), 1,
      sym__item,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(245), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 4,
      sym_statement,
      sym_var_declaration,
      sym_module_item,
      sym_function_item,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [2397] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(212), 1,
      anon_sym_RPAREN,
    STATE(29), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(132), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(235), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2490] = 28,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(13), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_function,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(214), 1,
      anon_sym_RBRACE,
    STATE(28), 1,
      aux_sym_union_block_repeat1,
    STATE(30), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_module_call,
    STATE(80), 1,
      sym_special_variable,
    STATE(162), 1,
      sym__item,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(245), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(144), 4,
      sym_statement,
      sym_var_declaration,
      sym_module_item,
      sym_function_item,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [2589] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(216), 1,
      anon_sym_RPAREN,
    STATE(31), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(115), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(220), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2682] = 25,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    ACTIONS(218), 1,
      anon_sym_RPAREN,
    STATE(32), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(132), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(235), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2775] = 24,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(33), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(132), 1,
      sym_expression,
    STATE(134), 1,
      sym__variable_name,
    STATE(235), 1,
      sym_assignment,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 11,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
  [2865] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(34), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(137), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [2950] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(35), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(140), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3035] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(36), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(88), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3120] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(37), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(90), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3205] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(38), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(91), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3290] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(39), 1,
      sym_line_comment,
    STATE(77), 1,
      sym_expression,
    STATE(80), 1,
      sym_special_variable,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3375] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(40), 1,
      sym_line_comment,
    STATE(78), 1,
      sym_expression,
    STATE(80), 1,
      sym_special_variable,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3460] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(41), 1,
      sym_line_comment,
    STATE(79), 1,
      sym_expression,
    STATE(80), 1,
      sym_special_variable,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3545] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(42), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(143), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3630] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(43), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(116), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3715] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(44), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(125), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3800] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(45), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(145), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3885] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(46), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(87), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [3970] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(47), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(89), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4055] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(48), 1,
      sym_line_comment,
    STATE(76), 1,
      sym_expression,
    STATE(80), 1,
      sym_special_variable,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4140] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(49), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(152), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4225] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(50), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(146), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4310] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(51), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(147), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4395] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(52), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(83), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4480] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(53), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(86), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4565] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(54), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(149), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4650] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(55), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(81), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4735] = 22,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_LBRACK,
    ACTIONS(55), 1,
      anon_sym_DASH,
    ACTIONS(57), 1,
      anon_sym_PLUS,
    ACTIONS(59), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      anon_sym_echo,
    ACTIONS(63), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      sym_undef,
    ACTIONS(81), 1,
      anon_sym_BANG,
    STATE(56), 1,
      sym_line_comment,
    STATE(80), 1,
      sym_special_variable,
    STATE(138), 1,
      sym_expression,
    ACTIONS(65), 2,
      sym_integer,
      sym_float,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(101), 6,
      sym_function_lit,
      sym_range,
      sym_list,
      sym_string,
      sym_number,
      sym_boolean,
    STATE(104), 12,
      sym_parenthesized_expression,
      sym_let_expression,
      sym_literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
      sym_assert_expression,
      sym_echo_expression,
      sym__variable_name,
  [4820] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(57), 1,
      sym_line_comment,
    ACTIONS(220), 13,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_assert,
      sym_identifier,
    ACTIONS(222), 22,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4869] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(58), 1,
      sym_line_comment,
    ACTIONS(226), 12,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(224), 16,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [4911] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(59), 1,
      sym_line_comment,
    ACTIONS(230), 12,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(228), 16,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [4953] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(60), 1,
      sym_line_comment,
    ACTIONS(234), 11,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(232), 17,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [4995] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(61), 1,
      sym_line_comment,
    ACTIONS(238), 12,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(236), 16,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [5037] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(62), 1,
      sym_line_comment,
    ACTIONS(242), 11,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(240), 17,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [5079] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(63), 1,
      sym_line_comment,
    ACTIONS(246), 11,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(244), 17,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [5121] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(64), 1,
      sym_line_comment,
    ACTIONS(250), 11,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(248), 17,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [5163] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(65), 1,
      sym_line_comment,
    ACTIONS(254), 12,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(252), 16,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [5205] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(66), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_module_call,
    STATE(121), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5274] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(67), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_module_call,
    STATE(126), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5343] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(119), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    STATE(68), 2,
      sym_module_call,
      sym_line_comment,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5410] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(69), 1,
      sym_line_comment,
    STATE(124), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5479] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(70), 1,
      sym_line_comment,
    STATE(135), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5548] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(71), 1,
      sym_line_comment,
    STATE(141), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5617] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(72), 1,
      sym_line_comment,
    STATE(130), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5686] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(73), 1,
      sym_line_comment,
    STATE(122), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5755] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(74), 1,
      sym_line_comment,
    STATE(133), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5824] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(11), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_include,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_for,
    ACTIONS(25), 1,
      anon_sym_intersection_for,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_assign,
    ACTIONS(31), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(256), 1,
      sym_identifier,
    STATE(68), 1,
      sym_module_call,
    STATE(75), 1,
      sym_line_comment,
    STATE(127), 1,
      sym_statement,
    STATE(164), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(120), 9,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_transform_chain,
      sym_assert_statement,
  [5893] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(76), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(258), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [5958] = 14,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(77), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(286), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [6015] = 13,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(78), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(288), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(286), 13,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [6070] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    STATE(79), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(288), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(286), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6117] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(80), 1,
      sym_line_comment,
    ACTIONS(292), 4,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(290), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6156] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(81), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(294), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6221] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(82), 1,
      sym_line_comment,
    ACTIONS(298), 4,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(296), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6260] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(83), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(300), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6325] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(84), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(302), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6390] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(85), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(304), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [6455] = 10,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(86), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(288), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(286), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [6504] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    STATE(87), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(308), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(306), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6551] = 12,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(88), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(288), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(286), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [6604] = 12,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(89), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(308), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(306), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [6657] = 16,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(90), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(286), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6718] = 15,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    STATE(91), 1,
      sym_line_comment,
    STATE(94), 1,
      sym_arguments,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(286), 9,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [6777] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym_line_comment,
    ACTIONS(105), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(107), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6815] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym_line_comment,
    ACTIONS(101), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(103), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6853] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(94), 1,
      sym_line_comment,
    ACTIONS(312), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(310), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6891] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(95), 1,
      sym_line_comment,
    ACTIONS(316), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(314), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6929] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(96), 1,
      sym_line_comment,
    ACTIONS(320), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(318), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [6967] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym_line_comment,
    ACTIONS(324), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(322), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7005] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym_line_comment,
    ACTIONS(328), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(326), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7043] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym_line_comment,
    ACTIONS(332), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(330), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7081] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym_line_comment,
    ACTIONS(336), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(334), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7119] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(101), 1,
      sym_line_comment,
    ACTIONS(340), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(338), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7157] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(102), 1,
      sym_line_comment,
    ACTIONS(344), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(342), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7195] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(103), 1,
      sym_line_comment,
    ACTIONS(348), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(346), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7233] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(104), 1,
      sym_line_comment,
    ACTIONS(352), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(350), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7271] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(105), 1,
      sym_line_comment,
    ACTIONS(356), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(354), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7309] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(106), 1,
      sym_line_comment,
    ACTIONS(360), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(358), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7347] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(107), 1,
      sym_line_comment,
    ACTIONS(364), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(362), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7385] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(108), 1,
      sym_line_comment,
    ACTIONS(93), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(95), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7423] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(109), 1,
      sym_line_comment,
    ACTIONS(97), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(99), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7461] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(110), 1,
      sym_line_comment,
    ACTIONS(368), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(366), 21,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [7499] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(111), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(370), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [7562] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(112), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(372), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [7625] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(113), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(374), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [7688] = 20,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(376), 1,
      anon_sym_COMMA,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
    STATE(94), 1,
      sym_arguments,
    STATE(114), 1,
      sym_line_comment,
    STATE(218), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7754] = 20,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(380), 1,
      anon_sym_COMMA,
    ACTIONS(382), 1,
      anon_sym_RPAREN,
    STATE(94), 1,
      sym_arguments,
    STATE(115), 1,
      sym_line_comment,
    STATE(221), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7820] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(116), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(384), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7882] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(388), 1,
      anon_sym_COLON,
    STATE(94), 1,
      sym_arguments,
    STATE(117), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(386), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [7946] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(118), 1,
      sym_line_comment,
    ACTIONS(390), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(392), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [7981] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(119), 1,
      sym_line_comment,
    ACTIONS(394), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(396), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8016] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(120), 1,
      sym_line_comment,
    ACTIONS(398), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(400), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8051] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(121), 1,
      sym_line_comment,
    ACTIONS(402), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(404), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8086] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(122), 1,
      sym_line_comment,
    ACTIONS(406), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(408), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8121] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(414), 1,
      anon_sym_SEMI,
    STATE(123), 1,
      sym_line_comment,
    ACTIONS(410), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(412), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8158] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(124), 1,
      sym_line_comment,
    ACTIONS(416), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(418), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8193] = 19,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(420), 1,
      anon_sym_COLON,
    ACTIONS(422), 1,
      anon_sym_RBRACK,
    STATE(94), 1,
      sym_arguments,
    STATE(125), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8256] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(126), 1,
      sym_line_comment,
    ACTIONS(424), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(426), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8291] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(432), 1,
      anon_sym_else,
    STATE(127), 1,
      sym_line_comment,
    ACTIONS(428), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(430), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [8328] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(128), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(386), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8389] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(129), 1,
      sym_line_comment,
    ACTIONS(434), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(436), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8424] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(130), 1,
      sym_line_comment,
    ACTIONS(438), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(440), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8459] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(131), 1,
      sym_line_comment,
    ACTIONS(442), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(444), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8494] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    STATE(94), 1,
      sym_arguments,
    STATE(132), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(446), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [8555] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(133), 1,
      sym_line_comment,
    ACTIONS(448), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(450), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8590] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(452), 1,
      anon_sym_EQ,
    STATE(134), 1,
      sym_line_comment,
    ACTIONS(352), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(350), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [8627] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(135), 1,
      sym_line_comment,
    ACTIONS(454), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(456), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      sym_identifier,
  [8662] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(136), 1,
      sym_line_comment,
    ACTIONS(460), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(458), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [8696] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(94), 1,
      sym_arguments,
    STATE(137), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8756] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(464), 1,
      anon_sym_RPAREN,
    STATE(94), 1,
      sym_arguments,
    STATE(138), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8816] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(139), 1,
      sym_line_comment,
    ACTIONS(466), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(468), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [8850] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(470), 1,
      anon_sym_RBRACK,
    STATE(94), 1,
      sym_arguments,
    STATE(140), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8910] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(141), 1,
      sym_line_comment,
    ACTIONS(472), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(474), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [8944] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(142), 1,
      sym_line_comment,
    ACTIONS(476), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(478), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [8978] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(480), 1,
      anon_sym_COLON,
    STATE(94), 1,
      sym_arguments,
    STATE(143), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9038] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(144), 1,
      sym_line_comment,
    ACTIONS(482), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(484), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9072] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(486), 1,
      anon_sym_SEMI,
    STATE(94), 1,
      sym_arguments,
    STATE(145), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9132] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(488), 1,
      anon_sym_SEMI,
    STATE(94), 1,
      sym_arguments,
    STATE(146), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9192] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(490), 1,
      anon_sym_RBRACK,
    STATE(94), 1,
      sym_arguments,
    STATE(147), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9252] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(148), 1,
      sym_line_comment,
    ACTIONS(494), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(492), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9286] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(496), 1,
      anon_sym_SEMI,
    STATE(94), 1,
      sym_arguments,
    STATE(149), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9346] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(150), 1,
      sym_line_comment,
    ACTIONS(500), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(498), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9380] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(151), 1,
      sym_line_comment,
    ACTIONS(504), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(502), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9414] = 18,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_DOT,
    ACTIONS(270), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(272), 1,
      anon_sym_AMP_AMP,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    ACTIONS(282), 1,
      anon_sym_CARET,
    ACTIONS(284), 1,
      anon_sym_QMARK,
    ACTIONS(506), 1,
      anon_sym_SEMI,
    STATE(94), 1,
      sym_arguments,
    STATE(152), 1,
      sym_line_comment,
    ACTIONS(262), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(268), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(274), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(276), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(278), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9474] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(153), 1,
      sym_line_comment,
    ACTIONS(510), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(508), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9508] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(154), 1,
      sym_line_comment,
    ACTIONS(514), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(512), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9542] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(155), 1,
      sym_line_comment,
    ACTIONS(518), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(516), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9576] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(156), 1,
      sym_line_comment,
    ACTIONS(522), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(520), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9610] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(157), 1,
      sym_line_comment,
    ACTIONS(526), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(524), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9644] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(158), 1,
      sym_line_comment,
    ACTIONS(222), 6,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
    ACTIONS(220), 14,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      anon_sym_each,
      anon_sym_DASH,
      anon_sym_assert,
      anon_sym_echo,
      sym_identifier,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
  [9678] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(159), 1,
      sym_line_comment,
    ACTIONS(528), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(530), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9711] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(160), 1,
      sym_line_comment,
    ACTIONS(532), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(534), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9744] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(540), 1,
      anon_sym_SEMI,
    STATE(161), 1,
      sym_line_comment,
    ACTIONS(536), 7,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(538), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9779] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(162), 1,
      sym_line_comment,
    ACTIONS(544), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      anon_sym_DOLLAR,
    ACTIONS(542), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9811] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(163), 1,
      sym_line_comment,
    ACTIONS(548), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(546), 8,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_assert,
      sym_identifier,
  [9839] = 8,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(550), 1,
      sym_identifier,
    STATE(70), 1,
      sym_module_call,
    STATE(164), 1,
      sym_line_comment,
    STATE(168), 1,
      aux_sym_transform_chain_repeat1,
    STATE(179), 1,
      sym_modifier,
    ACTIONS(33), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [9867] = 11,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(554), 1,
      anon_sym_COMMA,
    ACTIONS(556), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(165), 1,
      sym_line_comment,
    STATE(198), 1,
      sym__variable_name,
    STATE(215), 1,
      sym_parameter,
    STATE(242), 1,
      sym_assignment,
  [9901] = 10,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(558), 1,
      anon_sym_SEMI,
    ACTIONS(560), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(166), 1,
      sym_line_comment,
    STATE(183), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [9932] = 10,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(562), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(167), 1,
      sym_line_comment,
    STATE(198), 1,
      sym__variable_name,
    STATE(242), 1,
      sym_assignment,
    STATE(243), 1,
      sym_parameter,
  [9963] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(564), 1,
      sym_identifier,
    STATE(179), 1,
      sym_modifier,
    STATE(168), 2,
      sym_line_comment,
      aux_sym_transform_chain_repeat1,
    ACTIONS(566), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
  [9986] = 10,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(569), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(169), 1,
      sym_line_comment,
    STATE(198), 1,
      sym__variable_name,
    STATE(242), 1,
      sym_assignment,
    STATE(243), 1,
      sym_parameter,
  [10017] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(170), 1,
      sym_line_comment,
    STATE(213), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10045] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(573), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(171), 1,
      sym_line_comment,
    STATE(217), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10073] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(575), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(172), 1,
      sym_line_comment,
    STATE(211), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10101] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(173), 1,
      sym_line_comment,
    STATE(207), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10129] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(560), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(174), 1,
      sym_line_comment,
    STATE(203), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10157] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    STATE(80), 1,
      sym_special_variable,
    STATE(175), 1,
      sym_line_comment,
    STATE(198), 1,
      sym__variable_name,
    STATE(242), 1,
      sym_assignment,
    STATE(243), 1,
      sym_parameter,
  [10185] = 9,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
    STATE(80), 1,
      sym_special_variable,
    STATE(176), 1,
      sym_line_comment,
    STATE(217), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10213] = 8,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(37), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      sym_identifier,
    STATE(80), 1,
      sym_special_variable,
    STATE(177), 1,
      sym_line_comment,
    STATE(217), 1,
      sym_assignment,
    STATE(254), 1,
      sym__variable_name,
  [10238] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(178), 1,
      sym_line_comment,
    ACTIONS(581), 5,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_identifier,
  [10255] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(179), 1,
      sym_line_comment,
    ACTIONS(583), 5,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_identifier,
  [10272] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(587), 1,
      anon_sym_else,
    STATE(180), 1,
      sym_line_comment,
    ACTIONS(585), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [10290] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(181), 1,
      sym_line_comment,
    ACTIONS(589), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10306] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(182), 1,
      sym_line_comment,
    ACTIONS(591), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10322] = 7,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(593), 1,
      anon_sym_SEMI,
    ACTIONS(595), 1,
      anon_sym_COMMA,
    ACTIONS(597), 1,
      anon_sym_RPAREN,
    STATE(183), 1,
      sym_line_comment,
    STATE(196), 1,
      aux_sym_assignments_repeat1,
  [10344] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(184), 1,
      sym_line_comment,
    ACTIONS(370), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10360] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(185), 1,
      sym_line_comment,
    ACTIONS(599), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10376] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(186), 1,
      sym_line_comment,
    ACTIONS(601), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10392] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(605), 1,
      anon_sym_else,
    STATE(187), 1,
      sym_line_comment,
    ACTIONS(603), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [10410] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(609), 1,
      anon_sym_COMMA,
    ACTIONS(607), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(188), 2,
      sym_line_comment,
      aux_sym_assignments_repeat1,
  [10428] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(189), 1,
      sym_line_comment,
    ACTIONS(612), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10444] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(190), 1,
      sym_line_comment,
    ACTIONS(614), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10460] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(191), 1,
      sym_line_comment,
    ACTIONS(374), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10476] = 5,
    ACTIONS(619), 1,
      anon_sym_DQUOTE,
    ACTIONS(621), 1,
      sym_block_comment,
    ACTIONS(623), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(616), 2,
      sym_escape_sequence,
      aux_sym_string_token1,
    STATE(192), 2,
      sym_line_comment,
      aux_sym_string_repeat1,
  [10494] = 6,
    ACTIONS(621), 1,
      sym_block_comment,
    ACTIONS(623), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(627), 1,
      anon_sym_DQUOTE,
    STATE(192), 1,
      aux_sym_string_repeat1,
    STATE(193), 1,
      sym_line_comment,
    ACTIONS(625), 2,
      sym_escape_sequence,
      aux_sym_string_token1,
  [10514] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(194), 1,
      sym_line_comment,
    ACTIONS(372), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [10530] = 6,
    ACTIONS(621), 1,
      sym_block_comment,
    ACTIONS(623), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(629), 1,
      anon_sym_DQUOTE,
    STATE(193), 1,
      aux_sym_string_repeat1,
    STATE(195), 1,
      sym_line_comment,
    ACTIONS(625), 2,
      sym_escape_sequence,
      aux_sym_string_token1,
  [10550] = 7,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
    ACTIONS(631), 1,
      anon_sym_SEMI,
    ACTIONS(633), 1,
      anon_sym_COMMA,
    STATE(188), 1,
      aux_sym_assignments_repeat1,
    STATE(196), 1,
      sym_line_comment,
  [10572] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(635), 1,
      anon_sym_for,
    ACTIONS(637), 1,
      anon_sym_if,
    ACTIONS(639), 1,
      anon_sym_each,
    STATE(197), 1,
      sym_line_comment,
  [10591] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(643), 1,
      anon_sym_EQ,
    STATE(198), 1,
      sym_line_comment,
    ACTIONS(641), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10608] = 5,
    ACTIONS(621), 1,
      sym_block_comment,
    ACTIONS(623), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(647), 1,
      anon_sym_DQUOTE,
    STATE(199), 1,
      sym_line_comment,
    ACTIONS(645), 2,
      sym_escape_sequence,
      aux_sym_string_token1,
  [10625] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(376), 1,
      anon_sym_COMMA,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
    STATE(200), 1,
      sym_line_comment,
    STATE(218), 1,
      aux_sym_arguments_repeat1,
  [10644] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(579), 1,
      anon_sym_RPAREN,
    ACTIONS(633), 1,
      anon_sym_COMMA,
    STATE(188), 1,
      aux_sym_assignments_repeat1,
    STATE(201), 1,
      sym_line_comment,
  [10663] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(87), 1,
      anon_sym_RBRACK,
    ACTIONS(649), 1,
      anon_sym_COMMA,
    STATE(202), 1,
      sym_line_comment,
    STATE(219), 1,
      aux_sym_list_repeat1,
  [10682] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(595), 1,
      anon_sym_COMMA,
    ACTIONS(597), 1,
      anon_sym_RPAREN,
    STATE(201), 1,
      aux_sym_assignments_repeat1,
    STATE(203), 1,
      sym_line_comment,
  [10701] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(651), 1,
      anon_sym_LPAREN,
    STATE(204), 1,
      sym_line_comment,
    STATE(11), 2,
      sym_assignments,
      sym_condition_update_clause,
  [10718] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(446), 1,
      anon_sym_RPAREN,
    ACTIONS(653), 1,
      anon_sym_COMMA,
    STATE(205), 2,
      sym_line_comment,
      aux_sym_arguments_repeat1,
  [10735] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(656), 1,
      anon_sym_COMMA,
    ACTIONS(659), 1,
      anon_sym_RPAREN,
    STATE(206), 2,
      sym_line_comment,
      aux_sym_parameters_repeat1,
  [10752] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(663), 1,
      anon_sym_RPAREN,
    STATE(207), 1,
      sym_line_comment,
    STATE(210), 1,
      aux_sym_assignments_repeat1,
  [10771] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(651), 1,
      anon_sym_LPAREN,
    STATE(208), 1,
      sym_line_comment,
    STATE(8), 2,
      sym_assignments,
      sym_condition_update_clause,
  [10788] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(290), 1,
      anon_sym_EQ,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_arguments,
    STATE(209), 1,
      sym_line_comment,
  [10807] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(667), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_assignments_repeat1,
    STATE(210), 1,
      sym_line_comment,
  [10826] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(669), 1,
      anon_sym_RPAREN,
    STATE(211), 1,
      sym_line_comment,
    STATE(212), 1,
      aux_sym_assignments_repeat1,
  [10845] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(671), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_assignments_repeat1,
    STATE(212), 1,
      sym_line_comment,
  [10864] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(673), 1,
      anon_sym_RPAREN,
    STATE(213), 1,
      sym_line_comment,
    STATE(214), 1,
      aux_sym_assignments_repeat1,
  [10883] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(675), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_assignments_repeat1,
    STATE(214), 1,
      sym_line_comment,
  [10902] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(677), 1,
      anon_sym_COMMA,
    ACTIONS(679), 1,
      anon_sym_RPAREN,
    STATE(215), 1,
      sym_line_comment,
    STATE(222), 1,
      aux_sym_parameters_repeat1,
  [10921] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(681), 1,
      anon_sym_COMMA,
    ACTIONS(683), 1,
      anon_sym_RBRACK,
    STATE(202), 1,
      aux_sym_list_repeat1,
    STATE(216), 1,
      sym_line_comment,
  [10940] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(217), 1,
      sym_line_comment,
    ACTIONS(607), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [10955] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(160), 1,
      anon_sym_RPAREN,
    ACTIONS(685), 1,
      anon_sym_COMMA,
    STATE(205), 1,
      aux_sym_arguments_repeat1,
    STATE(218), 1,
      sym_line_comment,
  [10974] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(687), 1,
      anon_sym_COMMA,
    ACTIONS(690), 1,
      anon_sym_RBRACK,
    STATE(219), 2,
      sym_line_comment,
      aux_sym_list_repeat1,
  [10991] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(380), 1,
      anon_sym_COMMA,
    ACTIONS(382), 1,
      anon_sym_RPAREN,
    STATE(220), 1,
      sym_line_comment,
    STATE(221), 1,
      aux_sym_arguments_repeat1,
  [11010] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(212), 1,
      anon_sym_RPAREN,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    STATE(205), 1,
      aux_sym_arguments_repeat1,
    STATE(221), 1,
      sym_line_comment,
  [11029] = 6,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(569), 1,
      anon_sym_RPAREN,
    ACTIONS(694), 1,
      anon_sym_COMMA,
    STATE(206), 1,
      aux_sym_parameters_repeat1,
    STATE(222), 1,
      sym_line_comment,
  [11048] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(223), 1,
      sym_line_comment,
    ACTIONS(690), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11062] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_arguments,
    STATE(224), 1,
      sym_line_comment,
  [11078] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    STATE(74), 1,
      sym_arguments,
    STATE(225), 1,
      sym_line_comment,
  [11094] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      sym_parameters,
    STATE(226), 1,
      sym_line_comment,
  [11110] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(23), 1,
      sym_assignments,
    STATE(227), 1,
      sym_line_comment,
  [11126] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(9), 1,
      sym_parenthesized_expression,
    STATE(228), 1,
      sym_line_comment,
  [11142] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(635), 1,
      anon_sym_for,
    ACTIONS(637), 1,
      anon_sym_if,
    STATE(229), 1,
      sym_line_comment,
  [11158] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(66), 1,
      sym_assignments,
    STATE(230), 1,
      sym_line_comment,
  [11174] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(73), 1,
      sym_assignments,
    STATE(231), 1,
      sym_line_comment,
  [11190] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_assignments,
    STATE(232), 1,
      sym_line_comment,
  [11206] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    STATE(75), 1,
      sym_parenthesized_expression,
    STATE(233), 1,
      sym_line_comment,
  [11222] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(69), 1,
      sym_assignments,
    STATE(234), 1,
      sym_line_comment,
  [11238] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(235), 1,
      sym_line_comment,
    ACTIONS(446), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11252] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(698), 1,
      anon_sym_LPAREN,
    STATE(72), 1,
      sym_assignments,
    STATE(236), 1,
      sym_line_comment,
  [11268] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(71), 1,
      sym_parameters,
    STATE(237), 1,
      sym_line_comment,
  [11284] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(238), 1,
      sym_line_comment,
    ACTIONS(386), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11298] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_arguments,
    STATE(239), 1,
      sym_line_comment,
  [11314] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(665), 1,
      anon_sym_LPAREN,
    STATE(3), 1,
      sym_arguments,
    STATE(240), 1,
      sym_line_comment,
  [11330] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(696), 1,
      anon_sym_LPAREN,
    STATE(241), 1,
      sym_line_comment,
    STATE(251), 1,
      sym_parameters,
  [11346] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(242), 1,
      sym_line_comment,
    ACTIONS(641), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11360] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    STATE(243), 1,
      sym_line_comment,
    ACTIONS(659), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [11374] = 5,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(700), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      sym_parenthesized_expression,
    STATE(244), 1,
      sym_line_comment,
  [11390] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(702), 1,
      anon_sym_SEMI,
    STATE(245), 1,
      sym_line_comment,
  [11403] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(704), 1,
      sym_include_path,
    STATE(246), 1,
      sym_line_comment,
  [11416] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(679), 1,
      anon_sym_RPAREN,
    STATE(247), 1,
      sym_line_comment,
  [11429] = 4,
    ACTIONS(621), 1,
      sym_block_comment,
    ACTIONS(623), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(706), 1,
      aux_sym_line_comment_token1,
    STATE(248), 1,
      sym_line_comment,
  [11442] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(708), 1,
      sym_identifier,
    STATE(249), 1,
      sym_line_comment,
  [11455] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(710), 1,
      sym_include_path,
    STATE(250), 1,
      sym_line_comment,
  [11468] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(712), 1,
      anon_sym_EQ,
    STATE(251), 1,
      sym_line_comment,
  [11481] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(714), 1,
      sym_identifier,
    STATE(252), 1,
      sym_line_comment,
  [11494] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(716), 1,
      anon_sym_RPAREN,
    STATE(253), 1,
      sym_line_comment,
  [11507] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(643), 1,
      anon_sym_EQ,
    STATE(254), 1,
      sym_line_comment,
  [11520] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(718), 1,
      ts_builtin_sym_end,
    STATE(255), 1,
      sym_line_comment,
  [11533] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(720), 1,
      sym_identifier,
    STATE(256), 1,
      sym_line_comment,
  [11546] = 4,
    ACTIONS(3), 1,
      sym_block_comment,
    ACTIONS(5), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(722), 1,
      sym_identifier,
    STATE(257), 1,
      sym_line_comment,
  [11559] = 1,
    ACTIONS(724), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(4)] = 0,
  [SMALL_STATE(5)] = 111,
  [SMALL_STATE(6)] = 222,
  [SMALL_STATE(7)] = 333,
  [SMALL_STATE(8)] = 441,
  [SMALL_STATE(9)] = 549,
  [SMALL_STATE(10)] = 657,
  [SMALL_STATE(11)] = 765,
  [SMALL_STATE(12)] = 873,
  [SMALL_STATE(13)] = 981,
  [SMALL_STATE(14)] = 1089,
  [SMALL_STATE(15)] = 1194,
  [SMALL_STATE(16)] = 1252,
  [SMALL_STATE(17)] = 1310,
  [SMALL_STATE(18)] = 1368,
  [SMALL_STATE(19)] = 1426,
  [SMALL_STATE(20)] = 1527,
  [SMALL_STATE(21)] = 1628,
  [SMALL_STATE(22)] = 1731,
  [SMALL_STATE(23)] = 1832,
  [SMALL_STATE(24)] = 1922,
  [SMALL_STATE(25)] = 2015,
  [SMALL_STATE(26)] = 2108,
  [SMALL_STATE(27)] = 2205,
  [SMALL_STATE(28)] = 2298,
  [SMALL_STATE(29)] = 2397,
  [SMALL_STATE(30)] = 2490,
  [SMALL_STATE(31)] = 2589,
  [SMALL_STATE(32)] = 2682,
  [SMALL_STATE(33)] = 2775,
  [SMALL_STATE(34)] = 2865,
  [SMALL_STATE(35)] = 2950,
  [SMALL_STATE(36)] = 3035,
  [SMALL_STATE(37)] = 3120,
  [SMALL_STATE(38)] = 3205,
  [SMALL_STATE(39)] = 3290,
  [SMALL_STATE(40)] = 3375,
  [SMALL_STATE(41)] = 3460,
  [SMALL_STATE(42)] = 3545,
  [SMALL_STATE(43)] = 3630,
  [SMALL_STATE(44)] = 3715,
  [SMALL_STATE(45)] = 3800,
  [SMALL_STATE(46)] = 3885,
  [SMALL_STATE(47)] = 3970,
  [SMALL_STATE(48)] = 4055,
  [SMALL_STATE(49)] = 4140,
  [SMALL_STATE(50)] = 4225,
  [SMALL_STATE(51)] = 4310,
  [SMALL_STATE(52)] = 4395,
  [SMALL_STATE(53)] = 4480,
  [SMALL_STATE(54)] = 4565,
  [SMALL_STATE(55)] = 4650,
  [SMALL_STATE(56)] = 4735,
  [SMALL_STATE(57)] = 4820,
  [SMALL_STATE(58)] = 4869,
  [SMALL_STATE(59)] = 4911,
  [SMALL_STATE(60)] = 4953,
  [SMALL_STATE(61)] = 4995,
  [SMALL_STATE(62)] = 5037,
  [SMALL_STATE(63)] = 5079,
  [SMALL_STATE(64)] = 5121,
  [SMALL_STATE(65)] = 5163,
  [SMALL_STATE(66)] = 5205,
  [SMALL_STATE(67)] = 5274,
  [SMALL_STATE(68)] = 5343,
  [SMALL_STATE(69)] = 5410,
  [SMALL_STATE(70)] = 5479,
  [SMALL_STATE(71)] = 5548,
  [SMALL_STATE(72)] = 5617,
  [SMALL_STATE(73)] = 5686,
  [SMALL_STATE(74)] = 5755,
  [SMALL_STATE(75)] = 5824,
  [SMALL_STATE(76)] = 5893,
  [SMALL_STATE(77)] = 5958,
  [SMALL_STATE(78)] = 6015,
  [SMALL_STATE(79)] = 6070,
  [SMALL_STATE(80)] = 6117,
  [SMALL_STATE(81)] = 6156,
  [SMALL_STATE(82)] = 6221,
  [SMALL_STATE(83)] = 6260,
  [SMALL_STATE(84)] = 6325,
  [SMALL_STATE(85)] = 6390,
  [SMALL_STATE(86)] = 6455,
  [SMALL_STATE(87)] = 6504,
  [SMALL_STATE(88)] = 6551,
  [SMALL_STATE(89)] = 6604,
  [SMALL_STATE(90)] = 6657,
  [SMALL_STATE(91)] = 6718,
  [SMALL_STATE(92)] = 6777,
  [SMALL_STATE(93)] = 6815,
  [SMALL_STATE(94)] = 6853,
  [SMALL_STATE(95)] = 6891,
  [SMALL_STATE(96)] = 6929,
  [SMALL_STATE(97)] = 6967,
  [SMALL_STATE(98)] = 7005,
  [SMALL_STATE(99)] = 7043,
  [SMALL_STATE(100)] = 7081,
  [SMALL_STATE(101)] = 7119,
  [SMALL_STATE(102)] = 7157,
  [SMALL_STATE(103)] = 7195,
  [SMALL_STATE(104)] = 7233,
  [SMALL_STATE(105)] = 7271,
  [SMALL_STATE(106)] = 7309,
  [SMALL_STATE(107)] = 7347,
  [SMALL_STATE(108)] = 7385,
  [SMALL_STATE(109)] = 7423,
  [SMALL_STATE(110)] = 7461,
  [SMALL_STATE(111)] = 7499,
  [SMALL_STATE(112)] = 7562,
  [SMALL_STATE(113)] = 7625,
  [SMALL_STATE(114)] = 7688,
  [SMALL_STATE(115)] = 7754,
  [SMALL_STATE(116)] = 7820,
  [SMALL_STATE(117)] = 7882,
  [SMALL_STATE(118)] = 7946,
  [SMALL_STATE(119)] = 7981,
  [SMALL_STATE(120)] = 8016,
  [SMALL_STATE(121)] = 8051,
  [SMALL_STATE(122)] = 8086,
  [SMALL_STATE(123)] = 8121,
  [SMALL_STATE(124)] = 8158,
  [SMALL_STATE(125)] = 8193,
  [SMALL_STATE(126)] = 8256,
  [SMALL_STATE(127)] = 8291,
  [SMALL_STATE(128)] = 8328,
  [SMALL_STATE(129)] = 8389,
  [SMALL_STATE(130)] = 8424,
  [SMALL_STATE(131)] = 8459,
  [SMALL_STATE(132)] = 8494,
  [SMALL_STATE(133)] = 8555,
  [SMALL_STATE(134)] = 8590,
  [SMALL_STATE(135)] = 8627,
  [SMALL_STATE(136)] = 8662,
  [SMALL_STATE(137)] = 8696,
  [SMALL_STATE(138)] = 8756,
  [SMALL_STATE(139)] = 8816,
  [SMALL_STATE(140)] = 8850,
  [SMALL_STATE(141)] = 8910,
  [SMALL_STATE(142)] = 8944,
  [SMALL_STATE(143)] = 8978,
  [SMALL_STATE(144)] = 9038,
  [SMALL_STATE(145)] = 9072,
  [SMALL_STATE(146)] = 9132,
  [SMALL_STATE(147)] = 9192,
  [SMALL_STATE(148)] = 9252,
  [SMALL_STATE(149)] = 9286,
  [SMALL_STATE(150)] = 9346,
  [SMALL_STATE(151)] = 9380,
  [SMALL_STATE(152)] = 9414,
  [SMALL_STATE(153)] = 9474,
  [SMALL_STATE(154)] = 9508,
  [SMALL_STATE(155)] = 9542,
  [SMALL_STATE(156)] = 9576,
  [SMALL_STATE(157)] = 9610,
  [SMALL_STATE(158)] = 9644,
  [SMALL_STATE(159)] = 9678,
  [SMALL_STATE(160)] = 9711,
  [SMALL_STATE(161)] = 9744,
  [SMALL_STATE(162)] = 9779,
  [SMALL_STATE(163)] = 9811,
  [SMALL_STATE(164)] = 9839,
  [SMALL_STATE(165)] = 9867,
  [SMALL_STATE(166)] = 9901,
  [SMALL_STATE(167)] = 9932,
  [SMALL_STATE(168)] = 9963,
  [SMALL_STATE(169)] = 9986,
  [SMALL_STATE(170)] = 10017,
  [SMALL_STATE(171)] = 10045,
  [SMALL_STATE(172)] = 10073,
  [SMALL_STATE(173)] = 10101,
  [SMALL_STATE(174)] = 10129,
  [SMALL_STATE(175)] = 10157,
  [SMALL_STATE(176)] = 10185,
  [SMALL_STATE(177)] = 10213,
  [SMALL_STATE(178)] = 10238,
  [SMALL_STATE(179)] = 10255,
  [SMALL_STATE(180)] = 10272,
  [SMALL_STATE(181)] = 10290,
  [SMALL_STATE(182)] = 10306,
  [SMALL_STATE(183)] = 10322,
  [SMALL_STATE(184)] = 10344,
  [SMALL_STATE(185)] = 10360,
  [SMALL_STATE(186)] = 10376,
  [SMALL_STATE(187)] = 10392,
  [SMALL_STATE(188)] = 10410,
  [SMALL_STATE(189)] = 10428,
  [SMALL_STATE(190)] = 10444,
  [SMALL_STATE(191)] = 10460,
  [SMALL_STATE(192)] = 10476,
  [SMALL_STATE(193)] = 10494,
  [SMALL_STATE(194)] = 10514,
  [SMALL_STATE(195)] = 10530,
  [SMALL_STATE(196)] = 10550,
  [SMALL_STATE(197)] = 10572,
  [SMALL_STATE(198)] = 10591,
  [SMALL_STATE(199)] = 10608,
  [SMALL_STATE(200)] = 10625,
  [SMALL_STATE(201)] = 10644,
  [SMALL_STATE(202)] = 10663,
  [SMALL_STATE(203)] = 10682,
  [SMALL_STATE(204)] = 10701,
  [SMALL_STATE(205)] = 10718,
  [SMALL_STATE(206)] = 10735,
  [SMALL_STATE(207)] = 10752,
  [SMALL_STATE(208)] = 10771,
  [SMALL_STATE(209)] = 10788,
  [SMALL_STATE(210)] = 10807,
  [SMALL_STATE(211)] = 10826,
  [SMALL_STATE(212)] = 10845,
  [SMALL_STATE(213)] = 10864,
  [SMALL_STATE(214)] = 10883,
  [SMALL_STATE(215)] = 10902,
  [SMALL_STATE(216)] = 10921,
  [SMALL_STATE(217)] = 10940,
  [SMALL_STATE(218)] = 10955,
  [SMALL_STATE(219)] = 10974,
  [SMALL_STATE(220)] = 10991,
  [SMALL_STATE(221)] = 11010,
  [SMALL_STATE(222)] = 11029,
  [SMALL_STATE(223)] = 11048,
  [SMALL_STATE(224)] = 11062,
  [SMALL_STATE(225)] = 11078,
  [SMALL_STATE(226)] = 11094,
  [SMALL_STATE(227)] = 11110,
  [SMALL_STATE(228)] = 11126,
  [SMALL_STATE(229)] = 11142,
  [SMALL_STATE(230)] = 11158,
  [SMALL_STATE(231)] = 11174,
  [SMALL_STATE(232)] = 11190,
  [SMALL_STATE(233)] = 11206,
  [SMALL_STATE(234)] = 11222,
  [SMALL_STATE(235)] = 11238,
  [SMALL_STATE(236)] = 11252,
  [SMALL_STATE(237)] = 11268,
  [SMALL_STATE(238)] = 11284,
  [SMALL_STATE(239)] = 11298,
  [SMALL_STATE(240)] = 11314,
  [SMALL_STATE(241)] = 11330,
  [SMALL_STATE(242)] = 11346,
  [SMALL_STATE(243)] = 11360,
  [SMALL_STATE(244)] = 11374,
  [SMALL_STATE(245)] = 11390,
  [SMALL_STATE(246)] = 11403,
  [SMALL_STATE(247)] = 11416,
  [SMALL_STATE(248)] = 11429,
  [SMALL_STATE(249)] = 11442,
  [SMALL_STATE(250)] = 11455,
  [SMALL_STATE(251)] = 11468,
  [SMALL_STATE(252)] = 11481,
  [SMALL_STATE(253)] = 11494,
  [SMALL_STATE(254)] = 11507,
  [SMALL_STATE(255)] = 11520,
  [SMALL_STATE(256)] = 11533,
  [SMALL_STATE(257)] = 11546,
  [SMALL_STATE(258)] = 11559,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [41] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_expression, 2, 0, 7),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert_expression, 2, 0, 7),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_echo_expression, 2, 0, 7),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_echo_expression, 2, 0, 7),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3, 0, 0),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4, 0, 0),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4, 0, 0),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 5, 0, 0),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 5, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2, 0, 0),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(209),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(120),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(252),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(257),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(250),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(246),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(30),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(236),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(230),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(178),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(225),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(256),
  [158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_prefix, 2, 0, 0),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [164] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(209),
  [167] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(120),
  [170] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(252),
  [173] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(257),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(250),
  [179] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(30),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0),
  [184] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(236),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(230),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [199] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(178),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(225),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2, 0, 0), SHIFT_REPEAT(256),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3, 0, 0),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3, 0, 0),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 5, 0, 0),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 5, 0, 0),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignments, 4, 0, 0),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignments, 4, 0, 0),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2, 0, 0),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2, 0, 0),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignments, 3, 0, 0),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignments, 3, 0, 0),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignments, 2, 0, 0),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignments, 2, 0, 0),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignments, 5, 0, 0),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignments, 5, 0, 0),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 4, 0, 0),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 4, 0, 0),
  [256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, 0, 17),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [276] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [280] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 10),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 10),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1, 0, 0),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_name, 1, 0, 0),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, 0, 2),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_special_variable, 2, 0, 0),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_special_variable, 2, 0, 0),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_lit, 3, 0, 8),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_expression, 3, 0, 9),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_echo_expression, 3, 0, 9),
  [306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, 0, 1),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, 0, 1),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 0),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 0),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2, 0, 0),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, 0, 14),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, 0, 14),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 0),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1, 0, 0),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1, 0, 0),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, 0, 15),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, 0, 15),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5, 0, 0),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5, 0, 0),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1, 0, 0),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, 0, 20),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, 0, 20),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, 0, 11),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, 0, 11),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2, 0, 0),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 1, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 3, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, 0, 5),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3, 0, 0),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3, 0, 0),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2, 0, 0),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, 0, 0),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, 0, 0),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, 0, 2),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, 0, 2),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, 0, 2),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, 0, 2),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 2, 0, 0),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, 0, 2),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, 0, 2),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, 0, 12),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, 0, 12),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, 0, 3),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, 0, 3),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2, 0, 0),
  [436] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2, 0, 0),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, 0, 2),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, 0, 2),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 3, 0, 0),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 3, 0, 0),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 0),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_statement, 3, 0, 4),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert_statement, 3, 0, 4),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 3, 0, 0),
  [456] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 3, 0, 0),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, 0, 26),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, 0, 26),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_item, 6, 0, 13),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_item, 6, 0, 13),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_item, 4, 0, 6),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_item, 4, 0, 6),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declaration, 2, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declaration, 2, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 1, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 1, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, 0, 19),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, 0, 19),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, 0, 22),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, 0, 22),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, 0, 23),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, 0, 23),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, 0, 24),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, 0, 24),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, 0, 25),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, 0, 25),
  [516] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, 0, 27),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, 0, 27),
  [520] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, 0, 28),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, 0, 28),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, 0, 29),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, 0, 29),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 3, 0, 0),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 3, 0, 0),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1, 0, 0),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1, 0, 0),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 2, 0, 0),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 2, 0, 0),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 1, 0, 0),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 1, 0, 0),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, 0, 1),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, 0, 1),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_transform_chain_repeat1, 2, 0, 0),
  [566] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_transform_chain_repeat1, 2, 0, 0), SHIFT_REPEAT(178),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1, 0, 0),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_transform_chain_repeat1, 1, 0, 0),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 4, 0, 16),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [589] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 4, 0, 0),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, 0, 18),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 3, 0, 0),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 6, 0, 21),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, 0, 3),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_assignments_repeat1, 2, 0, 0),
  [609] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_assignments_repeat1, 2, 0, 0), SHIFT_REPEAT(177),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 3, 0, 0),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 1, 0, 0),
  [616] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(199),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [629] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, 0, 0),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1, 0, 0),
  [647] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1, 0, 0),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 0), SHIFT_REPEAT(33),
  [656] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(175),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [687] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(13),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [718] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line_comment, 2, 0, 0),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
