/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_icl.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_icl.h"

static bool icl_render_basic_Sampler00Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_render_basic_Sampler00Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_render_basic_SamplerBottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 9) {
        return true;
    }
    return false;
}
static bool icl_render_basic_SamplersBusy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 9) {
        return true;
    }
    return false;
}

static void
icl_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "e3cd52cf-c6b0-4019-b369-3bc9c75a0cbc";
    metric_set->counters = calloc(41, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = icl__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_basic__gti_read_throughput__read,
                .max_uint64 = icl__render_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_basic__gti_write_throughput__read,
                .max_uint64 = icl__render_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_basic__l3_shader_throughput__read,
                .max_uint64 = icl__render_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler00 Bottleneck",
                .symbol_name = "Sampler00Bottleneck",
                .desc = "The percentage of time in which Slice0 Sampler0 has been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__sampler00_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = icl_render_basic_Sampler00Bottleneck_availability,
            },

            {
                .name = "Sampler00 Busy",
                .symbol_name = "Sampler00Busy",
                .desc = "The percentage of time in which Slice0 Sampler0 has been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__sampler00_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = icl_render_basic_Sampler00Busy_availability,
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = icl_render_basic_SamplerBottleneck_availability,
            },

            {
                .name = "Sampler Cache Misses",
                .symbol_name = "SamplerL1Misses",
                .desc = "The total number of sampler cache misses in all LODs in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_basic__sampler_l1_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers have been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = icl_render_basic_SamplersBusy_availability,
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_basic__slm_bytes_read__read,
                .max_uint64 = icl__render_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_basic__slm_bytes_written__read,
                .max_uint64 = icl__render_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_basic__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 41);
}


static void
icl_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "04546170-d541-4804-96f8-007a454a3f2c";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = icl__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = icl__compute_basic__eu_avg_ipc_rate__read,
                .max_float = icl__compute_basic__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__gti_read_throughput__read,
                .max_uint64 = icl__compute_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__gti_write_throughput__read,
                .max_uint64 = icl__compute_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__l3_shader_throughput__read,
                .max_uint64 = icl__compute_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__compute_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__compute_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__slm_bytes_read__read,
                .max_uint64 = icl__compute_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__slm_bytes_written__read,
                .max_uint64 = icl__compute_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Typed Atomics Accesses",
                .symbol_name = "TypedAtomics",
                .desc = "The total number of typed atomic accesses via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__compute_basic__typed_atomics__read,
                .max_uint64 = icl__compute_basic__typed_atomics__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Bytes Read",
                .symbol_name = "TypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__typed_bytes_read__read,
                .max_uint64 = icl__compute_basic__typed_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Typed Bytes Written",
                .symbol_name = "TypedBytesWritten",
                .desc = "The total number of untyped memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__typed_bytes_written__read,
                .max_uint64 = icl__compute_basic__typed_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Bytes Read",
                .symbol_name = "UntypedBytesRead",
                .desc = "The total number of typed memory bytes read via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__untyped_bytes_read__read,
                .max_uint64 = icl__compute_basic__untyped_bytes_read__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes",
                .symbol_name = "UntypedBytesWritten",
                .desc = "The total number of untyped memory bytes written via Data Port.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_basic__untyped_bytes_written__read,
                .max_uint64 = icl__compute_basic__untyped_bytes_written__max,
                .group = "L3/Data Port",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 40);
}

static bool icl_compute_extended_EuA32UntypedReads00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuA32UntypedWrites00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuA64UntypedReads00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuA64UntypedWrites00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuTypedAtomics00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuTypedReads00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_EuTypedWrites00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedAtomics00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedAtomicsPerCacheLine_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedReads00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedReadsPerCacheLine_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedWrites00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_TypedWritesPerCacheLine_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_UntypedReads00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_UntypedWrites00_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_extended_UntypedWritesPerCacheLine_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_compute_extended_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Extended metrics set";
    metric_set->symbol_name = "ComputeExtended";
    metric_set->hw_config_guid = "43eb7fc1-dc5e-45e2-a90a-0053f5397271";
    metric_set->counters = calloc(22, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_compute_extended_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__compute_extended__avg_gpu_core_frequency__read,
                .max_uint64 = icl__compute_extended__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_extended__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "Eu A32 Untyped Reads 00",
                .symbol_name = "EuA32UntypedReads00",
                .desc = "Slice0 Dualsubslice 0 Eu A32 Untyped Reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_a32_untyped_reads00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuA32UntypedReads00_availability,
            },

            {
                .name = "Eu A32 Untyped Writes 00",
                .symbol_name = "EuA32UntypedWrites00",
                .desc = "Slice0 Dualsubslice 0 Eu A32 Untyped Writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_a32_untyped_writes00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuA32UntypedWrites00_availability,
            },

            {
                .name = "Eu 64 Untyped Reads 00",
                .symbol_name = "EuA64UntypedReads00",
                .desc = "Slice0 Dualsubslice 0 Eu 64 Untyped Reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_float = icl__compute_extended__eu_a64_untyped_reads00__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuA64UntypedReads00_availability,
            },

            {
                .name = "Eu A64 Untyped Writes 00",
                .symbol_name = "EuA64UntypedWrites00",
                .desc = "Slice0 Dualsubslice 0 Eu A64 Untyped Writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_a64_untyped_writes00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuA64UntypedWrites00_availability,
            },

            {
                .name = "Eu Typed Atomics 00",
                .symbol_name = "EuTypedAtomics00",
                .desc = "Slice0 Dualsubslice 0 Eu Typed Atomics",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_typed_atomics00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuTypedAtomics00_availability,
            },

            {
                .name = "Eu Typed Reads 00",
                .symbol_name = "EuTypedReads00",
                .desc = "Slice0 Dualsubslice 0 Eu Typed Reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_typed_reads00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuTypedReads00_availability,
            },

            {
                .name = "Eu Typed Writes 00",
                .symbol_name = "EuTypedWrites00",
                .desc = "Slice0 Dualsubslice 0 Eu Typed Writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__eu_typed_writes00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_EuTypedWrites00_availability,
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_extended__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__compute_extended__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__compute_extended__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Typed Atomics 00",
                .symbol_name = "TypedAtomics00",
                .desc = "Slice 0 Dualsubslice 0 typed atomics.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__typed_atomics00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedAtomics00_availability,
            },

            {
                .name = "TypedAtomicsPerCacheLine",
                .symbol_name = "TypedAtomicsPerCacheLine",
                .desc = "The ratio of EU typed atomics requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = icl__compute_extended__typed_atomics_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedAtomicsPerCacheLine_availability,
            },

            {
                .name = "Typed Reads 00",
                .symbol_name = "TypedReads00",
                .desc = "Slice 0 Dualsubslice 0 typed reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__typed_reads00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedReads00_availability,
            },

            {
                .name = "TypedReadsPerCacheLine",
                .symbol_name = "TypedReadsPerCacheLine",
                .desc = "The ratio of EU typed read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = icl__compute_extended__typed_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedReadsPerCacheLine_availability,
            },

            {
                .name = "Typed Writes 00",
                .symbol_name = "TypedWrites00",
                .desc = "Slice 0 Dualsubslice 0 typed writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__typed_writes00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedWrites00_availability,
            },

            {
                .name = "TypedWritesPerCacheLine",
                .symbol_name = "TypedWritesPerCacheLine",
                .desc = "The ratio of EU typed write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = icl__compute_extended__typed_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_TypedWritesPerCacheLine_availability,
            },

            {
                .name = "Untyped Reads 00",
                .symbol_name = "UntypedReads00",
                .desc = "Slice 0 Dualsubslice 0 untyped reads (including SLM reads).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__untyped_reads00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_UntypedReads00_availability,
            },

            {
                .name = "UntypedReadsPerCacheLine",
                .symbol_name = "UntypedReadsPerCacheLine",
                .desc = "The ratio of EU untyped read requests to L3 cache line reads.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = icl__compute_extended__untyped_reads_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "Untyped Writes 00",
                .symbol_name = "UntypedWrites00",
                .desc = "Slice 0 Dualsubslice 0 untyped writes (including SLM writes).",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_extended__untyped_writes00__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_UntypedWrites00_availability,
            },

            {
                .name = "UntypedWritesPerCacheLine",
                .symbol_name = "UntypedWritesPerCacheLine",
                .desc = "The ratio of EU untyped write requests to L3 cache line writes.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES,
                .read_float = icl__compute_extended__untyped_writes_per_cache_line__read,
                .max_float = NULL /* undefined */,
                .group = "L3/Data Port",
                .availability = icl_compute_extended_UntypedWritesPerCacheLine_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 22);
}

static bool icl_compute_l3_cache_L3Bank00Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank01Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank02Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank03Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank04Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank05Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank06Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_compute_l3_cache_L3Bank07Accesses_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_compute_l3_cache_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics L3 Cache metrics set";
    metric_set->symbol_name = "ComputeL3Cache";
    metric_set->hw_config_guid = "05d5e01f-0800-4975-b36b-7b169cad3fab";
    metric_set->counters = calloc(55, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_compute_l3_cache_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__compute_l3_cache__avg_gpu_core_frequency__read,
                .max_uint64 = icl__compute_l3_cache__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = icl__compute_l3_cache__eu_avg_ipc_rate__read,
                .max_float = icl__compute_l3_cache__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Binary Instruction",
                .symbol_name = "EuBinaryFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing binary instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_binary_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Binary Instruction",
                .symbol_name = "EuBinaryFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing binary instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_binary_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU0 Hybrid Instruction",
                .symbol_name = "EuHybridFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_hybrid_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Hybrid Instruction",
                .symbol_name = "EuHybridFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_hybrid_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU0 Move Instruction",
                .symbol_name = "EuMoveFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing move instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_move_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Move Instruction",
                .symbol_name = "EuMoveFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing move instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_move_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Ternary Instruction",
                .symbol_name = "EuTernaryFpu0Instruction",
                .desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_ternary_fpu0_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU1 Ternary Instruction",
                .symbol_name = "EuTernaryFpu1Instruction",
                .desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__eu_ternary_fpu1_instruction__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes/Instructions",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__compute_l3_cache__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__compute_l3_cache__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__compute_l3_cache__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__gti_read_throughput__read,
                .max_uint64 = icl__compute_l3_cache__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__gti_write_throughput__read,
                .max_uint64 = icl__compute_l3_cache__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Accesses",
                .symbol_name = "L3Accesses",
                .desc = "The total number of L3 accesses from all entities.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
            },

            {
                .name = "Slice0 L3 Bank0 Accesses",
                .symbol_name = "L3Bank00Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank0.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank00_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank00Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank1 Accesses",
                .symbol_name = "L3Bank01Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank01_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank01Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank2 Accesses",
                .symbol_name = "L3Bank02Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank2.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank02_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank02Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank3 Accesses",
                .symbol_name = "L3Bank03Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank03_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank03Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank4 Accesses",
                .symbol_name = "L3Bank04Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank4.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank04_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank04Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank5 Accesses",
                .symbol_name = "L3Bank05Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank5.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank05_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank05Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank6 Accesses",
                .symbol_name = "L3Bank06Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank6.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank06_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank06Accesses_availability,
            },

            {
                .name = "Slice0 L3 Bank7 Accesses",
                .symbol_name = "L3Bank07Accesses",
                .desc = "The total number of accesses to Slice0 L3 Bank7.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_bank07_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3",
                .availability = icl_compute_l3_cache_L3Bank07Accesses_availability,
            },

            {
                .name = "L3 Lookup Accesses w/o IC",
                .symbol_name = "L3Lookups",
                .desc = "The total number of L3 cache lookup accesses w/o IC.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__l3_lookups__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/TAG",
            },

            {
                .name = "L3 Sampler Throughput",
                .symbol_name = "L3SamplerThroughput",
                .desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__l3_sampler_throughput__read,
                .max_uint64 = icl__compute_l3_cache__l3_sampler_throughput__max,
                .group = "L3/Sampler",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__l3_shader_throughput__read,
                .max_uint64 = icl__compute_l3_cache__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "L3 Total Throughput",
                .symbol_name = "L3TotalThroughput",
                .desc = "The total number of GPU memory bytes transferred via L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__l3_total_throughput__read,
                .max_uint64 = icl__compute_l3_cache__l3_total_throughput__max,
                .group = "L3",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Accesses",
                .symbol_name = "SamplerAccesses",
                .desc = "The total number of messages send to samplers.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__sampler_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__compute_l3_cache__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__compute_l3_cache__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__compute_l3_cache__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__compute_l3_cache__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__slm_bytes_read__read,
                .max_uint64 = icl__compute_l3_cache__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__compute_l3_cache__slm_bytes_written__read,
                .max_uint64 = icl__compute_l3_cache__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__compute_l3_cache__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 55);
}


static void
icl_add_render_pipe_profile_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics set for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "03c7a167-2abc-4ba6-878a-f1d80082abca";
    metric_set->counters = calloc(43, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_render_pipe_profile_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__render_pipe_profile__avg_gpu_core_frequency__read,
                .max_uint64 = icl__render_pipe_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC Bottleneck",
                .symbol_name = "BcBottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__bc_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Barycentric Calc",
            },

            {
                .name = "Clipper Bottleneck",
                .symbol_name = "ClBottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__cl_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CL Stall",
                .symbol_name = "ClStall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__cl_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Bottleneck",
                .symbol_name = "DsBottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__ds_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Stall",
                .symbol_name = "DsStall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__ds_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Bottleneck",
                .symbol_name = "EarlyDepthBottleneck",
                .desc = "The percentage of time in which early depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__early_depth_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__render_pipe_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__render_pipe_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Bottleneck",
                .symbol_name = "GsBottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__gs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Hi-Depth Bottleneck",
                .symbol_name = "HiDepthBottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__hi_depth_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Bottleneck",
                .symbol_name = "HsBottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__hs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Stall",
                .symbol_name = "HsStall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__hs_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_pipe_profile__l3_shader_throughput__read,
                .max_uint64 = icl__render_pipe_profile__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__render_pipe_profile__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__render_pipe_profile__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__render_pipe_profile__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Strip-Fans Bottleneck",
                .symbol_name = "SfBottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__sf_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "SF Stall",
                .symbol_name = "SfStall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__sf_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_pipe_profile__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_pipe_profile__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__render_pipe_profile__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_pipe_profile__slm_bytes_read__read,
                .max_uint64 = icl__render_pipe_profile__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__render_pipe_profile__slm_bytes_written__read,
                .max_uint64 = icl__render_pipe_profile__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SO Bottleneck",
                .symbol_name = "SoBottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__so_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "SO Stall",
                .symbol_name = "SoStall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__so_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "VF Bottleneck",
                .symbol_name = "VfBottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__vf_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Input Assembler",
            },

            {
                .name = "VS Bottleneck",
                .symbol_name = "VsBottleneck",
                .desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__render_pipe_profile__vs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__render_pipe_profile__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 43);
}


static void
icl_add_hdc_and_sf_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF";
    metric_set->symbol_name = "HDCAndSF";
    metric_set->hw_config_guid = "c5cbc488-6569-41dd-9128-42bf6f0d317c";
    metric_set->counters = calloc(41, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_hdc_and_sf_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__hdc_and_sf__avg_gpu_core_frequency__read,
                .max_uint64 = icl__hdc_and_sf__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__hdc_and_sf__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__hdc_and_sf__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__hdc_and_sf__l3_shader_throughput__read,
                .max_uint64 = icl__hdc_and_sf__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Slice0 Dualsubslice0 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader00AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
            },

            {
                .name = "Slice0 Dualsubslice1 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader01AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
            },

            {
                .name = "Slice0 Dualsubslice2 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader02AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
            },

            {
                .name = "Slice0 Dualsubslice3 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader03AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice3)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__non_sampler_shader03_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Polygon Data Ready",
                .symbol_name = "PolyDataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__poly_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe/Strip-Fans",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__hdc_and_sf__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__hdc_and_sf__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__hdc_and_sf__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__hdc_and_sf__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__hdc_and_sf__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__hdc_and_sf__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__hdc_and_sf__slm_bytes_read__read,
                .max_uint64 = icl__hdc_and_sf__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__hdc_and_sf__slm_bytes_written__read,
                .max_uint64 = icl__hdc_and_sf__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__hdc_and_sf__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__hdc_and_sf__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 41);
}

static bool icl_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_rasterizer_and_pixel_backend_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend";
    metric_set->symbol_name = "RasterizerAndPixelBackend";
    metric_set->hw_config_guid = "0316ce4f-e03f-4738-8262-13528fce8eea";
    metric_set->counters = calloc(44, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_rasterizer_and_pixel_backend_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read,
                .max_uint64 = icl__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__l3_shader_throughput__read,
                .max_uint64 = icl__rasterizer_and_pixel_backend__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Slice0 Pipe0 PS Output Available",
                .symbol_name = "PSOutput00Available",
                .desc = "The percentage of time in which slice0 pipe0 PS output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_output00_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe1 PS Output Available",
                .symbol_name = "PSOutput01Available",
                .desc = "The percentage of time in which slice0 pipe1 PS output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_output01_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData00Ready",
                .desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__pixel_data00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData01Ready",
                .desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__pixel_data01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Slice0 Pipe0 Pixel Values Ready",
                .symbol_name = "PixelValues00Ready",
                .desc = "The percentage of time in which slice0 pipe0 pixel values are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__pixel_values00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe1 Pixel Values Ready",
                .symbol_name = "PixelValues01Ready",
                .desc = "The percentage of time in which slice0 pipe1 pixel values are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__pixel_values01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Rasterizer Input Available",
                .symbol_name = "Rasterizer0InputAvailable",
                .desc = "The percentage of time in which slice0 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__rasterizer0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = icl_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability,
            },

            {
                .name = "Slice0 Rasterizer Output Ready",
                .symbol_name = "Rasterizer0OutputReady",
                .desc = "The percentage of time in which slice0 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__rasterizer0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = icl_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__slm_bytes_read__read,
                .max_uint64 = icl__rasterizer_and_pixel_backend__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__rasterizer_and_pixel_backend__slm_bytes_written__read,
                .max_uint64 = icl__rasterizer_and_pixel_backend__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__rasterizer_and_pixel_backend__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__rasterizer_and_pixel_backend__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}

static bool icl_l3_1_L30Bank0Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank1Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank2Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank3Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank4Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank5Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank6Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_l3_1_L30Bank7Active_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_l3_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set L3_1";
    metric_set->symbol_name = "L3_1";
    metric_set->hw_config_guid = "21d69ec3-91e1-48a8-acd6-c0c4ec6e819a";
    metric_set->counters = calloc(44, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_l3_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__l3_1__avg_gpu_core_frequency__read,
                .max_uint64 = icl__l3_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__l3_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__l3_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank0 Active",
                .symbol_name = "L30Bank0Active",
                .desc = "The percentage of time in which slice0 L3 bank0 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank0Active_availability,
            },

            {
                .name = "Slice0 L3 Bank1 Active",
                .symbol_name = "L30Bank1Active",
                .desc = "The percentage of time in which slice0 L3 bank1 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank1Active_availability,
            },

            {
                .name = "Slice0 L3 Bank2 Active",
                .symbol_name = "L30Bank2Active",
                .desc = "The percentage of time in which slice0 L3 bank2 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank2_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank2Active_availability,
            },

            {
                .name = "Slice0 L3 Bank3 Active",
                .symbol_name = "L30Bank3Active",
                .desc = "The percentage of time in which slice0 L3 bank3 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank3_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank3Active_availability,
            },

            {
                .name = "Slice0 L3 Bank4 Active",
                .symbol_name = "L30Bank4Active",
                .desc = "The percentage of time in which slice0 L3 bank4 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank4_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank4Active_availability,
            },

            {
                .name = "Slice0 L3 Bank5 Active",
                .symbol_name = "L30Bank5Active",
                .desc = "The percentage of time in which slice0 L3 bank5 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank5_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank5Active_availability,
            },

            {
                .name = "Slice0 L3 Bank6 Active",
                .symbol_name = "L30Bank6Active",
                .desc = "The percentage of time in which slice0 L3 bank6 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank6_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank6Active_availability,
            },

            {
                .name = "Slice0 L3 Bank7 Active",
                .symbol_name = "L30Bank7Active",
                .desc = "The percentage of time in which slice0 L3 bank7 is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__l30_bank7_active__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_1_L30Bank7Active_availability,
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__l3_1__l3_shader_throughput__read,
                .max_uint64 = icl__l3_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__l3_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__l3_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__l3_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__l3_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__l3_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__l3_1__slm_bytes_read__read,
                .max_uint64 = icl__l3_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__l3_1__slm_bytes_written__read,
                .max_uint64 = icl__l3_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}

static bool icl_l3_2_L30Bank0Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_l3_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L2Bank0 stalled metric set";
    metric_set->symbol_name = "L3_2";
    metric_set->hw_config_guid = "e60e9155-6830-4aec-baf2-1c3c15a73869";
    metric_set->counters = calloc(29, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_l3_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__l3_2__avg_gpu_core_frequency__read,
                .max_uint64 = icl__l3_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__l3_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__l3_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank0 Stalled",
                .symbol_name = "L30Bank0Stalled",
                .desc = "The percentage of time in which slice0 L3 bank0 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__l30_bank0_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_2_L30Bank0Stalled_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 29);
}

static bool icl_l3_3_L30Bank1Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_l3_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L2Bank1 stalled metric set";
    metric_set->symbol_name = "L3_3";
    metric_set->hw_config_guid = "47c364d5-1799-4d17-9447-add9358c6451";
    metric_set->counters = calloc(29, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_l3_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__l3_3__avg_gpu_core_frequency__read,
                .max_uint64 = icl__l3_3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__l3_3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__l3_3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank1 Stalled",
                .symbol_name = "L30Bank1Stalled",
                .desc = "The percentage of time in which slice0 L3 bank1 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__l30_bank1_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_3_L30Bank1Stalled_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_3__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_3__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_3__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 29);
}

static bool icl_l3_4_L30Bank4Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_l3_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L2Bank4 stalled metric set";
    metric_set->symbol_name = "L3_4";
    metric_set->hw_config_guid = "e5ab5c08-3130-4469-8eaf-b23d3dc817d4";
    metric_set->counters = calloc(29, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_l3_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__l3_4__avg_gpu_core_frequency__read,
                .max_uint64 = icl__l3_4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__l3_4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__l3_4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank4 Stalled",
                .symbol_name = "L30Bank4Stalled",
                .desc = "The percentage of time in which slice0 L3 bank4 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__l30_bank4_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_4_L30Bank4Stalled_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_4__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_4__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_4__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 29);
}

static bool icl_l3_5_L30Bank5Stalled_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
icl_add_l3_5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L2Bank5 stalled metric set";
    metric_set->symbol_name = "L3_5";
    metric_set->hw_config_guid = "6cdf23c1-f725-414c-959a-c90fa5571b1f";
    metric_set->counters = calloc(29, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_l3_5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__l3_5__avg_gpu_core_frequency__read,
                .max_uint64 = icl__l3_5__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__l3_5__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__l3_5__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank5 Stalled",
                .symbol_name = "L30Bank5Stalled",
                .desc = "The percentage of time in which slice0 L3 bank5 is stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__l30_bank5_stalled__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = icl_l3_5_L30Bank5Stalled_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__l3_5__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__l3_5__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__l3_5__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 29);
}

static bool icl_sampler_1_Sampler00InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler01InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler02InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler03InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler04InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler05InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler06InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_sampler_1_Sampler07InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}

static void
icl_add_sampler_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set Sampler 1";
    metric_set->symbol_name = "Sampler_1";
    metric_set->hw_config_guid = "51a2eb6d-9fad-4489-8f22-ab845fe7882a";
    metric_set->counters = calloc(43, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_sampler_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__sampler_1__avg_gpu_core_frequency__read,
                .max_uint64 = icl__sampler_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__sampler_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__sampler_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_1__l3_shader_throughput__read,
                .max_uint64 = icl__sampler_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Subslice0 Input Available",
                .symbol_name = "Sampler00InputAvailable",
                .desc = "The percentage of time in which slice0 subslice0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler00_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler00InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice1 Input Available",
                .symbol_name = "Sampler01InputAvailable",
                .desc = "The percentage of time in which slice0 subslice1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler01_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler01InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice2 Input Available",
                .symbol_name = "Sampler02InputAvailable",
                .desc = "The percentage of time in which slice0 subslice2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler02_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler02InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice3 Input Available",
                .symbol_name = "Sampler03InputAvailable",
                .desc = "The percentage of time in which slice0 subslice3 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler03_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler03InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice4 Input Available",
                .symbol_name = "Sampler04InputAvailable",
                .desc = "The percentage of time in which slice0 subslice4 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler04_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler04InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice5 Input Available",
                .symbol_name = "Sampler05InputAvailable",
                .desc = "The percentage of time in which slice0 subslice5 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler05_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler05InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice6 Input Available",
                .symbol_name = "Sampler06InputAvailable",
                .desc = "The percentage of time in which slice0 subslice6 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler06_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler06InputAvailable_availability,
            },

            {
                .name = "Slice0 Subslice7 Input Available",
                .symbol_name = "Sampler07InputAvailable",
                .desc = "The percentage of time in which slice0 subslice7 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__sampler07_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_1_Sampler07InputAvailable_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__sampler_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__sampler_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_1__slm_bytes_read__read,
                .max_uint64 = icl__sampler_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_1__slm_bytes_written__read,
                .max_uint64 = icl__sampler_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 43);
}

static bool icl_sampler_2_Sampler00OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler01OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler02OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler03OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler04OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler05OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler06OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_sampler_2_Sampler07OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}

static void
icl_add_sampler_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set Sampler 2";
    metric_set->symbol_name = "Sampler_2";
    metric_set->hw_config_guid = "afc0f021-8c33-4d60-803d-93487f96c7c1";
    metric_set->counters = calloc(44, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_sampler_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__sampler_2__avg_gpu_core_frequency__read,
                .max_uint64 = icl__sampler_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__sampler_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__sampler_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_2__l3_shader_throughput__read,
                .max_uint64 = icl__sampler_2__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Subslice0 Sampler Output Ready",
                .symbol_name = "Sampler00OutputReady",
                .desc = "The percentage of time in which slice0 subslice0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler00_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler00OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice1 Sampler Output Ready",
                .symbol_name = "Sampler01OutputReady",
                .desc = "The percentage of time in which slice0 subslice1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler01_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler01OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice2 Sampler Output Ready",
                .symbol_name = "Sampler02OutputReady",
                .desc = "The percentage of time in which slice0 subslice2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler02_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler02OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice3 Sampler Output Ready",
                .symbol_name = "Sampler03OutputReady",
                .desc = "The percentage of time in which slice0 subslice3 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler03_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler03OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice4 Sampler Output Ready",
                .symbol_name = "Sampler04OutputReady",
                .desc = "The percentage of time in which slice0 subslice4 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler04_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler04OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice5 Sampler Output Ready",
                .symbol_name = "Sampler05OutputReady",
                .desc = "The percentage of time in which slice0 subslice5 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler05_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler05OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice6 Sampler Output Ready",
                .symbol_name = "Sampler06OutputReady",
                .desc = "The percentage of time in which slice0 subslice6 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler06_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler06OutputReady_availability,
            },

            {
                .name = "Slice0 Subslice7 Sampler Output Ready",
                .symbol_name = "Sampler07OutputReady",
                .desc = "The percentage of time in which slice0 subslice7 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__sampler07_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = icl_sampler_2_Sampler07OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__sampler_2__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__sampler_2__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__sampler_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_2__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_2__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__sampler_2__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_2__slm_bytes_read__read,
                .max_uint64 = icl__sampler_2__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__sampler_2__slm_bytes_written__read,
                .max_uint64 = icl__sampler_2__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__sampler_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__sampler_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}

static bool icl_tdl_1_PSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread03ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread04ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread05ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread06ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_tdl_1_PSThread07ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}

static void
icl_add_tdl_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TDL_1";
    metric_set->symbol_name = "TDL_1";
    metric_set->hw_config_guid = "eddc2f32-b196-4a72-9bf8-21770e35f8bd";
    metric_set->counters = calloc(51, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_tdl_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__tdl_1__avg_gpu_core_frequency__read,
                .max_uint64 = icl__tdl_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__tdl_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_1__l3_shader_throughput__read,
                .max_uint64 = icl__tdl_1__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher",
                .symbol_name = "PSThread00ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread00ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher",
                .symbol_name = "PSThread01ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread01ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher",
                .symbol_name = "PSThread02ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread02ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice3 Thread Dispatcher",
                .symbol_name = "PSThread03ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread03_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread03ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice4 Thread Dispatcher",
                .symbol_name = "PSThread04ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice4 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread04_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread04ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice5 Thread Dispatcher",
                .symbol_name = "PSThread05ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice5 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread05_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread05ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice6 Thread Dispatcher",
                .symbol_name = "PSThread06ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice6 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread06_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread06ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Subslice7 Thread Dispatcher",
                .symbol_name = "PSThread07ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice7 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_thread07_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_1_PSThread07ReadyForDispatch_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS EU Active",
                .symbol_name = "PsEuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Active per Thread",
                .symbol_name = "PsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_1__ps_eu_active_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "FS EU Stall",
                .symbol_name = "PsEuStall",
                .desc = "The percentage of time in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "FS AVG Stall per Thread",
                .symbol_name = "PsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_1__ps_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_1__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_1__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_1__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_1__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_1__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_1__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_1__slm_bytes_read__read,
                .max_uint64 = icl__tdl_1__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_1__slm_bytes_written__read,
                .max_uint64 = icl__tdl_1__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS EU Active",
                .symbol_name = "VsEuActive",
                .desc = "The percentage of time in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__vs_eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Active per Thread",
                .symbol_name = "VsEuActivePerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_1__vs_eu_active_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS EU Stall",
                .symbol_name = "VsEuStall",
                .desc = "The percentage of time in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__vs_eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS AVG Stall per Thread",
                .symbol_name = "VsEuStallPerThread",
                .desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_1__vs_eu_stall_per_thread__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_1__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 51);
}

static bool icl_tdl_2_NonPSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread02ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread03ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread04ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread05ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread06ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_tdl_2_NonPSThread07ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}

static void
icl_add_tdl_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TDL_2";
    metric_set->symbol_name = "TDL_2";
    metric_set->hw_config_guid = "c6d3af7b-037b-4656-95e1-4f838f0a2c14";
    metric_set->counters = calloc(44, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_tdl_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__tdl_2__avg_gpu_core_frequency__read,
                .max_uint64 = icl__tdl_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ is full",
                .symbol_name = "GTRequestQueueFull",
                .desc = "The percentage of time when SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__gt_request_queue_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__tdl_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_2__l3_shader_throughput__read,
                .max_uint64 = icl__tdl_2__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher",
                .symbol_name = "NonPSThread00ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread00ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher",
                .symbol_name = "NonPSThread01ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread01ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher",
                .symbol_name = "NonPSThread02ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread02_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread02ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice3 Thread Dispatcher",
                .symbol_name = "NonPSThread03ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread03_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread03ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice4 Thread Dispatcher",
                .symbol_name = "NonPSThread04ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice4 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread04_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread04ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice5 Thread Dispatcher",
                .symbol_name = "NonPSThread05ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice5 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread05_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread05ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice6 Thread Dispatcher",
                .symbol_name = "NonPSThread06ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice6 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread06_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread06ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice7 Thread Dispatcher",
                .symbol_name = "NonPSThread07ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice7 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__non_ps_thread07_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_2_NonPSThread07ReadyForDispatch_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_2__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_2__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_2__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_2__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_2__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_2__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_2__slm_bytes_read__read,
                .max_uint64 = icl__tdl_2__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_2__slm_bytes_written__read,
                .max_uint64 = icl__tdl_2__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_2__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}

static bool icl_tdl_3_ThreadHeader00ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader00ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader01ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader01ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader02ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader02ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 4) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader03ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader03ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 8) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader04ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader04ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 16) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader05ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader05ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 32) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader06ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader06ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 64) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader07ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}
static bool icl_tdl_3_ThreadHeader07ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 128) {
        return true;
    }
    return false;
}

static void
icl_add_tdl_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TDL_3";
    metric_set->symbol_name = "TDL_3";
    metric_set->hw_config_guid = "fd25ec19-3ed1-40c9-8648-1d2387449a92";
    metric_set->counters = calloc(51, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_tdl_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__tdl_3__avg_gpu_core_frequency__read,
                .max_uint64 = icl__tdl_3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Both FPU Pipes Active",
                .symbol_name = "EuFpuBothActive",
                .desc = "The percentage of time in which both EU FPU pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__eu_fpu_both_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__tdl_3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__tdl_3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_3__l3_shader_throughput__read,
                .max_uint64 = icl__tdl_3__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Both FPU Active",
                .symbol_name = "PsEuBothFpuActive",
                .desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__ps_eu_both_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_3__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = icl__tdl_3__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = icl__tdl_3__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_3__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_3__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = icl__tdl_3__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_3__slm_bytes_read__read,
                .max_uint64 = icl__tdl_3__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = icl__tdl_3__slm_bytes_written__read,
                .max_uint64 = icl__tdl_3__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader00ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header00_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader00ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader00ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header00_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader00ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader01ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header01_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader01ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader01ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header01_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader01ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader02ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header02_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader02ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader02ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header02_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader02ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice3 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader03ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice3 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header03_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader03ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice3 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader03ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice3 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header03_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader03ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice4 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader04ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice4 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header04_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader04ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice4 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader04ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice4 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header04_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader04ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice5 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader05ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice5 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header05_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader05ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice5 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader05ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice5 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header05_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader05ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice6 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader06ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice6 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header06_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader06ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice6 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader06ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice6 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header06_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader06ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice7 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader07ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice7 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header07_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader07ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 Subslice7 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader07ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 subslice7 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__thread_header07_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = icl_tdl_3_ThreadHeader07ReadyPort1_availability,
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__tdl_3__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__tdl_3__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 51);
}


static void
icl_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Gpu Rings Busyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "40dc79f2-88c8-47c6-8f86-f509e39fbe5d";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AnyRingBusy",
                .symbol_name = "AnyRingBusy",
                .desc = "The percentage of time when any command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__any_ring_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__gpu_busyness__avg_gpu_core_frequency__read,
                .max_uint64 = icl__gpu_busyness__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Blitter Ring Busy",
                .symbol_name = "BlitterBusy",
                .desc = "The percentage of time when blitter command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__blitter_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__gpu_busyness__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__gpu_busyness__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Posh Ring Busy",
                .symbol_name = "PoshEngineBusy",
                .desc = "The percentage of time when posh command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__posh_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox0 Ring Busy",
                .symbol_name = "Vdbox0Busy",
                .desc = "The percentage of time when Vdbox0 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__vdbox0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox1 Ring Busy",
                .symbol_name = "Vdbox1Busy",
                .desc = "The percentage of time when Vdbox1 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__vdbox1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vebox Ring Busy",
                .symbol_name = "VeboxBusy",
                .desc = "The percentage of time when vebox command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__gpu_busyness__vebox_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}


static void
icl_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "e617cfd5-6cc5-4143-8994-cd36cebb921f";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = icl__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.16666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.6666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = icl__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}


static void
icl_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "eca4858e-27a4-4bcf-a57f-2616e2f08950";
    metric_set->counters = calloc(21, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    icl_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = icl__async_compute__avg_gpu_core_frequency__read,
                .max_uint64 = icl__async_compute__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS FPU0 Pipe Active",
                .symbol_name = "CsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__cs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "CS FPU1 Pipe Active",
                .symbol_name = "CsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__cs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU FPU0 Pipe Active",
                .symbol_name = "Fpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU1 Pipe Active",
                .symbol_name = "Fpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = icl__async_compute__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = icl__async_compute__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "PS FPU0 Pipe Active",
                .symbol_name = "PsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__ps_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS FPU1 Pipe Active",
                .symbol_name = "PsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__ps_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS FPU0 Pipe Active",
                .symbol_name = "VsFpu0Active",
                .desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__vs_fpu0_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS FPU1 Pipe Active",
                .symbol_name = "VsFpu1Active",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = icl__async_compute__vs_fpu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = icl__async_compute__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 21);
}

void
intel_perf_load_metrics_icl(struct intel_perf *perf)
{
    icl_add_render_basic_metric_set(perf);
    icl_add_compute_basic_metric_set(perf);
    icl_add_compute_extended_metric_set(perf);
    icl_add_compute_l3_cache_metric_set(perf);
    icl_add_render_pipe_profile_metric_set(perf);
    icl_add_hdc_and_sf_metric_set(perf);
    icl_add_rasterizer_and_pixel_backend_metric_set(perf);
    icl_add_l3_1_metric_set(perf);
    icl_add_l3_2_metric_set(perf);
    icl_add_l3_3_metric_set(perf);
    icl_add_l3_4_metric_set(perf);
    icl_add_l3_5_metric_set(perf);
    icl_add_sampler_1_metric_set(perf);
    icl_add_sampler_2_metric_set(perf);
    icl_add_tdl_1_metric_set(perf);
    icl_add_tdl_2_metric_set(perf);
    icl_add_tdl_3_metric_set(perf);
    icl_add_gpu_busyness_metric_set(perf);
    icl_add_test_oa_metric_set(perf);
    icl_add_async_compute_metric_set(perf);
}
