// Copyright 2018 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: networking/v1alpha3/service_entry.proto

// $schema: istio.networking.v1alpha3.ServiceEntry
// $title: Service Entry
// $description: Configuration affecting service registry.
// $location: https://istio.io/docs/reference/config/networking/service-entry.html
// $aliases: [/docs/reference/config/networking/v1alpha3/service-entry]

// `ServiceEntry` enables adding additional entries into Istio's
// internal service registry, so that auto-discovered services in the
// mesh can access/route to these manually specified services. A
// service entry describes the properties of a service (DNS name,
// VIPs, ports, protocols, endpoints). These services could be
// external to the mesh (e.g., web APIs) or mesh-internal services
// that are not part of the platform's service registry (e.g., a set
// of VMs talking to services in Kubernetes). In addition, the
// endpoints of a service entry can also be dynamically selected by
// using the `workloadSelector` field. These endpoints can be VM
// workloads declared using the `WorkloadEntry` object or Kubernetes
// pods. The ability to select both pods and VMs under a single
// service allows for migration of services from VMs to Kubernetes
// without having to change the existing DNS names associated with the
// services.
//
// The following example declares a few external APIs accessed by internal
// applications over HTTPS. The sidecar inspects the SNI value in the
// ClientHello message to route to the appropriate external service.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-https
// spec:
//   hosts:
//   - api.dropboxapi.com
//   - www.googleapis.com
//   - api.facebook.com
//   location: MESH_EXTERNAL
//   ports:
//   - number: 443
//     name: https
//     protocol: TLS
//   resolution: DNS
// ```
//
// The following configuration adds a set of MongoDB instances running on
// unmanaged VMs to Istio's registry, so that these services can be treated
// as any other service in the mesh. The associated DestinationRule is used
// to initiate mTLS connections to the database instances.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-mongocluster
// spec:
//   hosts:
//   - mymongodb.somedomain # not used
//   addresses:
//   - 192.192.192.192/24 # VIPs
//   ports:
//   - number: 27018
//     name: mongodb
//     protocol: MONGO
//   location: MESH_INTERNAL
//   resolution: STATIC
//   endpoints:
//   - address: 2.2.2.2
//   - address: 3.3.3.3
// ```
//
// and the associated DestinationRule
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: mtls-mongocluster
// spec:
//   host: mymongodb.somedomain
//   trafficPolicy:
//     tls:
//       mode: MUTUAL
//       clientCertificate: /etc/certs/myclientcert.pem
//       privateKey: /etc/certs/client_private_key.pem
//       caCertificates: /etc/certs/rootcacerts.pem
// ```
//
// The following example uses a combination of service entry and TLS
// routing in a virtual service to steer traffic based on the SNI value to
// an internal egress firewall.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-redirect
// spec:
//   hosts:
//   - wikipedia.org
//   - "*.wikipedia.org"
//   location: MESH_EXTERNAL
//   ports:
//   - number: 443
//     name: https
//     protocol: TLS
//   resolution: NONE
// ```
//
// And the associated VirtualService to route based on the SNI value.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//   name: tls-routing
// spec:
//   hosts:
//   - wikipedia.org
//   - "*.wikipedia.org"
//   tls:
//   - match:
//     - sniHosts:
//       - wikipedia.org
//       - "*.wikipedia.org"
//     route:
//     - destination:
//         host: internal-egress-firewall.ns1.svc.cluster.local
// ```
//
// The virtual service with TLS match serves to override the default SNI
// match. In the absence of a virtual service, traffic will be forwarded to
// the wikipedia domains.
//
// The following example demonstrates the use of a dedicated egress gateway
// through which all external service traffic is forwarded.
// The 'exportTo' field allows for control over the visibility of a service
// declaration to other namespaces in the mesh. By default, a service is exported
// to all namespaces. The following example restricts the visibility to the
// current namespace, represented by ".", so that it cannot be used by other
// namespaces.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-httpbin
//   namespace: egress
// spec:
//   hosts:
//   - example.com
//   exportTo:
//   - "."
//   location: MESH_EXTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: DNS
// ```
//
// Define a gateway to handle all egress traffic.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//  name: istio-egressgateway
//  namespace: istio-system
// spec:
//  selector:
//    istio: egressgateway
//  servers:
//  - port:
//      number: 80
//      name: http
//      protocol: HTTP
//    hosts:
//    - "*"
// ```
//
// And the associated `VirtualService` to route from the sidecar to the
// gateway service (`istio-egressgateway.istio-system.svc.cluster.local`), as
// well as route from the gateway to the external service. Note that the
// virtual service is exported to all namespaces enabling them to route traffic
// through the gateway to the external service. Forcing traffic to go through
// a managed middle proxy like this is a common practice.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//   name: gateway-routing
//   namespace: egress
// spec:
//   hosts:
//   - example.com
//   exportTo:
//   - "*"
//   gateways:
//   - mesh
//   - istio-egressgateway
//   http:
//   - match:
//     - port: 80
//       gateways:
//       - mesh
//     route:
//     - destination:
//         host: istio-egressgateway.istio-system.svc.cluster.local
//   - match:
//     - port: 80
//       gateways:
//       - istio-egressgateway
//     route:
//     - destination:
//         host: example.com
// ```
//
// The following example demonstrates the use of wildcards in the hosts for
// external services. If the connection has to be routed to the IP address
// requested by the application (i.e. application resolves DNS and attempts
// to connect to a specific IP), the resolution mode must be set to `NONE`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-wildcard-example
// spec:
//   hosts:
//   - "*.bar.com"
//   location: MESH_EXTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: NONE
// ```
//
// The following example demonstrates a service that is available via a
// Unix Domain Socket on the host of the client. The resolution must be
// set to STATIC to use Unix address endpoints.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: unix-domain-socket-example
// spec:
//   hosts:
//   - "example.unix.local"
//   location: MESH_EXTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: STATIC
//   endpoints:
//   - address: unix:///var/run/example/socket
// ```
//
// For HTTP-based services, it is possible to create a `VirtualService`
// backed by multiple DNS addressable endpoints. In such a scenario, the
// application can use the `HTTP_PROXY` environment variable to transparently
// reroute API calls for the `VirtualService` to a chosen backend. For
// example, the following configuration creates a non-existent external
// service called foo.bar.com backed by three domains: us.foo.bar.com:8080,
// uk.foo.bar.com:9080, and in.foo.bar.com:7080
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-dns
// spec:
//   hosts:
//   - foo.bar.com
//   location: MESH_EXTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: DNS
//   endpoints:
//   - address: us.foo.bar.com
//     ports:
//       http: 8080
//   - address: uk.foo.bar.com
//     ports:
//       http: 9080
//   - address: in.foo.bar.com
//     ports:
//       http: 7080
// ```
//
// With `HTTP_PROXY=http://localhost/`, calls from the application to
// `http://foo.bar.com` will be load balanced across the three domains
// specified above. In other words, a call to `http://foo.bar.com/baz` would
// be translated to `http://uk.foo.bar.com/baz`.
//
// The following example illustrates the usage of a `ServiceEntry`
// containing a subject alternate name
// whose format conforms to the [SPIFFE standard](https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE-ID.md):
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: httpbin
//   namespace: httpbin-ns
// spec:
//   hosts:
//   - example.com
//   location: MESH_INTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: STATIC
//   endpoints:
//   - address: 2.2.2.2
//   - address: 3.3.3.3
//   subjectAltNames:
//   - "spiffe://cluster.local/ns/httpbin-ns/sa/httpbin-service-account"
// ```
//
// The following example demonstrates the use of `ServiceEntry` with a
// `workloadSelector` to handle the migration of a service
// `details.bookinfo.com` from VMs to Kubernetes. The service has two
// VM-based instances with sidecars as well as a set of Kubernetes
// pods managed by a standard deployment object. Consumers of this
// service in the mesh will be automatically load balanced across the
// VMs and Kubernetes.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: WorkloadEntry
// metadata:
//   name: details-vm-1
// spec:
//   serviceAccount: details
//   address: 2.2.2.2
//   labels:
//     app: details
//     instance-id: vm1
// ---
// apiVersion: networking.istio.io/v1
// kind: WorkloadEntry
// metadata:
//   name: details-vm-2
// spec:
//   serviceAccount: details
//   address: 3.3.3.3
//   labels:
//     app: details
//     instance-id: vm2
// ```
//
// Assuming there is also a Kubernetes deployment with pod labels
// `app: details` using the same service account `details`, the
// following service entry declares a service spanning both VMs and
// Kubernetes:
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: details-svc
// spec:
//   hosts:
//   - details.bookinfo.com
//   location: MESH_INTERNAL
//   ports:
//   - number: 80
//     name: http
//     protocol: HTTP
//   resolution: STATIC
//   workloadSelector:
//     labels:
//       app: details
// ```

package v1alpha3

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1alpha11 "istio.io/api/analysis/v1alpha1"
	v1alpha1 "istio.io/api/meta/v1alpha1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Location specifies whether the service is part of Istio mesh or
// outside the mesh.  Location determines the behavior of several
// features, such as service-to-service mTLS authentication, policy
// enforcement, etc.
type ServiceEntry_Location int32

const (
	// Signifies that the service is external to the mesh. Typically used
	// to indicate external services consumed through APIs.
	ServiceEntry_MESH_EXTERNAL ServiceEntry_Location = 0
	// Signifies that the service is part of the mesh. Typically used to
	// indicate services added explicitly as part of expanding the service
	// mesh to include unmanaged infrastructure (e.g., VMs added to a
	// Kubernetes based service mesh).
	ServiceEntry_MESH_INTERNAL ServiceEntry_Location = 1
)

// Enum value maps for ServiceEntry_Location.
var (
	ServiceEntry_Location_name = map[int32]string{
		0: "MESH_EXTERNAL",
		1: "MESH_INTERNAL",
	}
	ServiceEntry_Location_value = map[string]int32{
		"MESH_EXTERNAL": 0,
		"MESH_INTERNAL": 1,
	}
)

func (x ServiceEntry_Location) Enum() *ServiceEntry_Location {
	p := new(ServiceEntry_Location)
	*p = x
	return p
}

func (x ServiceEntry_Location) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceEntry_Location) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_service_entry_proto_enumTypes[0].Descriptor()
}

func (ServiceEntry_Location) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_service_entry_proto_enumTypes[0]
}

func (x ServiceEntry_Location) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceEntry_Location.Descriptor instead.
func (ServiceEntry_Location) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{0, 0}
}

// Resolution determines how the proxy will resolve the IP addresses of
// the network endpoints associated with the service, so that it can
// route to one of them. The resolution mode specified here has no impact
// on how the application resolves the IP address associated with the
// service. The application may still have to use DNS to resolve the
// service to an IP so that the outbound traffic can be captured by the
// Proxy. Alternatively, for HTTP services, the application could
// directly communicate with the proxy (e.g., by setting HTTP_PROXY) to
// talk to these services.
type ServiceEntry_Resolution int32

const (
	// Assume that incoming connections have already been resolved (to a
	// specific destination IP address). Such connections are typically
	// routed via the proxy using mechanisms such as IP table REDIRECT/
	// eBPF. After performing any routing related transformations, the
	// proxy will forward the connection to the IP address to which the
	// connection was bound.
	ServiceEntry_NONE ServiceEntry_Resolution = 0
	// Use the static IP addresses specified in endpoints (see below) as the
	// backing instances associated with the service.
	ServiceEntry_STATIC ServiceEntry_Resolution = 1
	// Attempt to resolve the IP address by querying the ambient DNS,
	// asynchronously. If no endpoints are specified, the proxy
	// will resolve the DNS address specified in the hosts field, if
	// wildcards are not used. If endpoints are specified, the DNS
	// addresses specified in the endpoints will be resolved to determine
	// the destination IP address.  DNS resolution cannot be used with Unix
	// domain socket endpoints.
	ServiceEntry_DNS ServiceEntry_Resolution = 2
	// Attempt to resolve the IP address by querying the ambient DNS,
	// asynchronously. Unlike `DNS`, `DNS_ROUND_ROBIN` only uses the
	// first IP address returned when a new connection needs to be initiated
	// without relying on complete results of DNS resolution, and connections
	// made to hosts will be retained even if DNS records change frequently
	// eliminating draining connection pools and connection cycling.
	// This is best suited for large web scale services that
	// must be accessed via DNS. The proxy will resolve the DNS address
	// specified in the hosts field, if wildcards are not used. DNS resolution
	// cannot be used with Unix domain socket endpoints.
	ServiceEntry_DNS_ROUND_ROBIN ServiceEntry_Resolution = 3
	// DYNAMIC_DNS will attempt to resolve the host name specified in
	// the Host header or SNI to an IP address when handling traffic. This
	// allows multiple DNS addresses to be represented by a single wildcard
	// `host` entry without having to explicitly enumerate all possible
	// endpoints. During DNS proxying, ztunnel will resolve all subdomains
	// matching the wildcard host name to a VIP which isn't used for routing
	// outside the mesh. `DYNAMIC_DNS` will provide configuration to a
	// waypoint proxy to recover the original host name using information
	// from SNI or a Host header in an HTTP Request. This original host name
	// will then be resolved so that traffic can be routed to the intended
	// IP address. This method of handling wildcard traffic is not
	// compatible with raw TCP traffic where the original host cannot
	// be recovered. `DYNAMIC_DNS` is only supported for wildcard hosts,
	// `MESH_EXTERNAL` location and in ambient mode. The ServiceEntry must
	// be bound to a waypoint. Specified endpoints will be ignored.
	ServiceEntry_DYNAMIC_DNS ServiceEntry_Resolution = 4
)

// Enum value maps for ServiceEntry_Resolution.
var (
	ServiceEntry_Resolution_name = map[int32]string{
		0: "NONE",
		1: "STATIC",
		2: "DNS",
		3: "DNS_ROUND_ROBIN",
		4: "DYNAMIC_DNS",
	}
	ServiceEntry_Resolution_value = map[string]int32{
		"NONE":            0,
		"STATIC":          1,
		"DNS":             2,
		"DNS_ROUND_ROBIN": 3,
		"DYNAMIC_DNS":     4,
	}
)

func (x ServiceEntry_Resolution) Enum() *ServiceEntry_Resolution {
	p := new(ServiceEntry_Resolution)
	*p = x
	return p
}

func (x ServiceEntry_Resolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceEntry_Resolution) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_service_entry_proto_enumTypes[1].Descriptor()
}

func (ServiceEntry_Resolution) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_service_entry_proto_enumTypes[1]
}

func (x ServiceEntry_Resolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceEntry_Resolution.Descriptor instead.
func (ServiceEntry_Resolution) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{0, 1}
}

// ServiceEntry enables adding additional entries into Istio's internal
// service registry.
//
// <!-- crd generation tags
// +cue-gen:ServiceEntry:groupName:networking.istio.io
// +cue-gen:ServiceEntry:versions:v1,v1beta1,v1alpha3
// +cue-gen:ServiceEntry:annotations:helm.sh/resource-policy=keep
// +cue-gen:ServiceEntry:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:ServiceEntry:subresource:status
// +cue-gen:ServiceEntry:scope:Namespaced
// +cue-gen:ServiceEntry:resource:categories=istio-io,networking-istio-io,shortNames=se,plural=serviceentries
// +cue-gen:ServiceEntry:printerColumn:name=Hosts,type=string,JSONPath=.spec.hosts,description="The hosts associated with the ServiceEntry"
// +cue-gen:ServiceEntry:printerColumn:name=Location,type=string,JSONPath=.spec.location,description="Whether the service is external to the
// mesh or part of the mesh (MESH_EXTERNAL or MESH_INTERNAL)"
// +cue-gen:ServiceEntry:printerColumn:name=Resolution,type=string,JSONPath=.spec.resolution,description="Service resolution mode for the hosts
// (NONE, STATIC, or DNS)"
// +cue-gen:ServiceEntry:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:ServiceEntry:preserveUnknownFields:false
// +cue-gen:ServiceEntry:spec:required
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// istiostatus-override: ServiceEntryStatus: istio.io/api/networking/v1alpha3
// -->
// +kubebuilder:validation:XValidation:message="only one of WorkloadSelector or Endpoints can be set",rule="oneof(self.workloadSelector, self.endpoints)"
// +kubebuilder:validation:XValidation:message="CIDR addresses are allowed only for NONE/STATIC resolution types",rule="!(default(self.addresses, []).exists(k, k.contains('/')) && !(default(self.resolution, 'NONE') in ['STATIC', 'NONE']))"
// +kubebuilder:validation:XValidation:message="NONE mode cannot set endpoints",rule="default(self.resolution, 'NONE') == 'NONE' ? !has(self.endpoints) : true"
// +kubebuilder:validation:XValidation:message="DNS_ROUND_ROBIN mode cannot have multiple endpoints",rule="default(self.resolution, ”) == 'DNS_ROUND_ROBIN' ? default(self.endpoints, []).size() <= 1 : true"
type ServiceEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The hosts associated with the ServiceEntry. Could be a DNS
	// name with wildcard prefix.
	//
	// 1. The hosts field is used to select matching hosts in VirtualServices and DestinationRules.
	// 2. For HTTP traffic the HTTP Host/Authority header will be matched against the hosts field.
	// 3. For HTTPs or TLS traffic containing Server Name Indication (SNI), the SNI value
	// will be matched against the hosts field.
	//
	// **NOTE 1:** When resolution is set to type DNS and no endpoints
	// are specified, the host field will be used as the DNS name of the
	// endpoint to route traffic to.
	//
	// **NOTE 2:** If the hostname matches with the name of a service
	// from another service registry such as Kubernetes that also
	// supplies its own set of endpoints, the ServiceEntry will be
	// treated as a decorator of the existing Kubernetes
	// service. Properties in the service entry will be added to the
	// Kubernetes service if applicable. Currently, only the following
	// additional properties will be considered by `istiod`:
	//
	//  1. subjectAltNames: In addition to verifying the SANs of the
	//     service accounts associated with the pods of the service, the
	//     SANs specified here will also be verified.
	//
	// **NOTE 3:** Ztunnel and Waypoint proxies do not support wildcard hosts.
	//
	// +kubebuilder:validation:MinItems=1
	// +kubebuilder:validation:MaxItems=256
	// +protoc-gen-crd:list-value-validation:XValidation:message="hostname cannot be wildcard",rule="self != '*'"
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// The virtual IP addresses associated with the service. Could be CIDR
	// prefix. For HTTP traffic, generated route configurations will include http route
	// domains for both the `addresses` and `hosts` field values and the destination will
	// be identified based on the HTTP Host/Authority header.
	// If one or more IP addresses are specified,
	// the incoming traffic will be identified as belonging to this service
	// if the destination IP matches the IP/CIDRs specified in the addresses
	// field. If the Addresses field is empty, traffic will be identified
	// solely based on the destination port. In such scenarios, the port on
	// which the service is being accessed must not be shared by any other
	// service in the mesh. In other words, the sidecar will behave as a
	// simple TCP proxy, forwarding incoming traffic on a specified port to
	// the specified destination endpoint IP/host. Unix domain socket
	// addresses are not supported in this field. Although the API allows
	// specifying addresses in a list, multiple addresses will not be used by a single host.
	// This means manual specification of dual-stack addressing is not supported.
	// +kubebuilder:validation:MaxItems=256
	// +protoc-gen-crd:list-value-validation:MaxLength=64
	Addresses []string `protobuf:"bytes,2,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// The ports associated with the external service. If the
	// Endpoints are Unix domain socket addresses, there must be exactly one
	// port.
	// +listType=map
	// +listMapKey=name
	// +kubebuilder:validation:MaxItems=256
	// +kubebuilder:validation:XValidation:message="port number cannot be duplicated",rule="self.all(l1, self.exists_one(l2, l1.number == l2.number))"
	Ports []*ServicePort `protobuf:"bytes,3,rep,name=ports,proto3" json:"ports,omitempty"`
	// Specify whether the service should be considered external to the mesh
	// or part of the mesh.
	Location ServiceEntry_Location `protobuf:"varint,4,opt,name=location,proto3,enum=istio.networking.v1alpha3.ServiceEntry_Location" json:"location,omitempty"`
	// Service resolution mode for the hosts. Care must be taken
	// when setting the resolution mode to NONE for a TCP port without
	// accompanying IP addresses. In such cases, traffic to any IP on
	// said port will be allowed (i.e. `0.0.0.0:<port>`).
	Resolution ServiceEntry_Resolution `protobuf:"varint,5,opt,name=resolution,proto3,enum=istio.networking.v1alpha3.ServiceEntry_Resolution" json:"resolution,omitempty"`
	// One or more endpoints associated with the service. Only one of
	// `endpoints` or `workloadSelector` can be specified.
	// +kubebuilder:validation:MaxItems=4096
	Endpoints []*WorkloadEntry `protobuf:"bytes,6,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Applicable only for MESH_INTERNAL services. Only one of
	// `endpoints` or `workloadSelector` can be specified. Selects one
	// or more Kubernetes pods or VM workloads (specified using
	// `WorkloadEntry`) based on their labels. The `WorkloadEntry` object
	// representing the VMs should be defined in the same namespace as
	// the ServiceEntry.
	WorkloadSelector *WorkloadSelector `protobuf:"bytes,9,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	// A list of namespaces to which this service is exported. Exporting a service
	// allows it to be used by sidecars, gateways and virtual services defined in
	// other namespaces. This feature provides a mechanism for service owners
	// and mesh administrators to control the visibility of services across
	// namespace boundaries.
	//
	// If no namespaces are specified then the service is exported to all
	// namespaces by default.
	//
	// The value "." is reserved and defines an export to the same namespace that
	// the service is declared in. Similarly the value "*" is reserved and
	// defines an export to all namespaces.
	//
	// For a Kubernetes Service, the equivalent effect can be achieved by setting
	// the annotation "networking.istio.io/exportTo" to a comma-separated list
	// of namespace names.
	//
	// **Note:** Ztunnel and Waypoint proxies not support this field and will read it at "*".
	ExportTo []string `protobuf:"bytes,7,rep,name=export_to,json=exportTo,proto3" json:"export_to,omitempty"`
	// If specified, the proxy will verify that the server certificate's
	// subject alternate name matches one of the specified values.
	//
	// NOTE: When using the workloadEntry with workloadSelectors, the
	// service account specified in the workloadEntry will also be used
	// to derive the additional subject alternate names that should be
	// verified.
	SubjectAltNames []string `protobuf:"bytes,8,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ServiceEntry) Reset() {
	*x = ServiceEntry{}
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceEntry) ProtoMessage() {}

func (x *ServiceEntry) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceEntry.ProtoReflect.Descriptor instead.
func (*ServiceEntry) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{0}
}

func (x *ServiceEntry) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *ServiceEntry) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *ServiceEntry) GetPorts() []*ServicePort {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *ServiceEntry) GetLocation() ServiceEntry_Location {
	if x != nil {
		return x.Location
	}
	return ServiceEntry_MESH_EXTERNAL
}

func (x *ServiceEntry) GetResolution() ServiceEntry_Resolution {
	if x != nil {
		return x.Resolution
	}
	return ServiceEntry_NONE
}

func (x *ServiceEntry) GetEndpoints() []*WorkloadEntry {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *ServiceEntry) GetWorkloadSelector() *WorkloadSelector {
	if x != nil {
		return x.WorkloadSelector
	}
	return nil
}

func (x *ServiceEntry) GetExportTo() []string {
	if x != nil {
		return x.ExportTo
	}
	return nil
}

func (x *ServiceEntry) GetSubjectAltNames() []string {
	if x != nil {
		return x.SubjectAltNames
	}
	return nil
}

// ServicePort describes the properties of a specific port of a service.
type ServicePort struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A valid non-negative integer port number.
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// The protocol exposed on the port.
	// MUST be one of HTTP|HTTPS|GRPC|HTTP2|MONGO|TCP|TLS.
	// TLS implies the connection will be routed based on the SNI header to
	// the destination without terminating the TLS connection.
	// +kubebuilder:validation:MaxLength=256
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Label assigned to the port.
	// +kubebuilder:validation:MaxLength=256
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The port number on the endpoint where the traffic will be
	// received. If unset, default to `number`.
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	TargetPort    uint32 `protobuf:"varint,4,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServicePort) Reset() {
	*x = ServicePort{}
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServicePort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePort) ProtoMessage() {}

func (x *ServicePort) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePort.ProtoReflect.Descriptor instead.
func (*ServicePort) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{1}
}

func (x *ServicePort) GetNumber() uint32 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *ServicePort) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ServicePort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServicePort) GetTargetPort() uint32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

type ServiceEntryStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Current service state of ServiceEntry.
	// More info: https://istio.io/docs/reference/config/config-status/
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	Conditions []*v1alpha1.IstioCondition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Includes any errors or warnings detected by Istio's analyzers.
	// +optional
	// +patchMergeKey=type
	// +patchStrategy=merge
	ValidationMessages []*v1alpha11.AnalysisMessageBase `protobuf:"bytes,2,rep,name=validation_messages,json=validationMessages,proto3" json:"validation_messages,omitempty"`
	// Resource Generation to which the Reconciled Condition refers.
	// When this value is not equal to the object's metadata generation, reconciled condition  calculation for the current
	// generation is still in progress.  See https://istio.io/latest/docs/reference/config/config-status/ for more info.
	// +optional
	ObservedGeneration int64 `protobuf:"varint,3,opt,name=observed_generation,json=observedGeneration,proto3" json:"observed_generation,omitempty"`
	// List of addresses which were assigned to this ServiceEntry.
	// +optional
	Addresses     []*ServiceEntryAddress `protobuf:"bytes,10,rep,name=addresses,proto3" json:"addresses,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceEntryStatus) Reset() {
	*x = ServiceEntryStatus{}
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceEntryStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceEntryStatus) ProtoMessage() {}

func (x *ServiceEntryStatus) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceEntryStatus.ProtoReflect.Descriptor instead.
func (*ServiceEntryStatus) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{2}
}

func (x *ServiceEntryStatus) GetConditions() []*v1alpha1.IstioCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *ServiceEntryStatus) GetValidationMessages() []*v1alpha11.AnalysisMessageBase {
	if x != nil {
		return x.ValidationMessages
	}
	return nil
}

func (x *ServiceEntryStatus) GetObservedGeneration() int64 {
	if x != nil {
		return x.ObservedGeneration
	}
	return 0
}

func (x *ServiceEntryStatus) GetAddresses() []*ServiceEntryAddress {
	if x != nil {
		return x.Addresses
	}
	return nil
}

// A minor abstraction to allow for adding hostnames if relevant.
type ServiceEntryAddress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address (e.g. 192.168.0.2)
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The host name associated with this address
	Host          string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceEntryAddress) Reset() {
	*x = ServiceEntryAddress{}
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceEntryAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceEntryAddress) ProtoMessage() {}

func (x *ServiceEntryAddress) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_service_entry_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceEntryAddress.ProtoReflect.Descriptor instead.
func (*ServiceEntryAddress) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_service_entry_proto_rawDescGZIP(), []int{3}
}

func (x *ServiceEntryAddress) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *ServiceEntryAddress) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

var File_networking_v1alpha3_service_entry_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_service_entry_proto_rawDesc = "" +
	"\n" +
	"'networking/v1alpha3/service_entry.proto\x12\x19istio.networking.v1alpha3\x1a\x1fanalysis/v1alpha1/message.proto\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1ameta/v1alpha1/status.proto\x1a!networking/v1alpha3/sidecar.proto\x1a(networking/v1alpha3/workload_entry.proto\"\x98\x05\n" +
	"\fServiceEntry\x12\x1a\n" +
	"\x05hosts\x18\x01 \x03(\tB\x04\xe2A\x01\x02R\x05hosts\x12\x1c\n" +
	"\taddresses\x18\x02 \x03(\tR\taddresses\x12<\n" +
	"\x05ports\x18\x03 \x03(\v2&.istio.networking.v1alpha3.ServicePortR\x05ports\x12L\n" +
	"\blocation\x18\x04 \x01(\x0e20.istio.networking.v1alpha3.ServiceEntry.LocationR\blocation\x12R\n" +
	"\n" +
	"resolution\x18\x05 \x01(\x0e22.istio.networking.v1alpha3.ServiceEntry.ResolutionR\n" +
	"resolution\x12F\n" +
	"\tendpoints\x18\x06 \x03(\v2(.istio.networking.v1alpha3.WorkloadEntryR\tendpoints\x12X\n" +
	"\x11workload_selector\x18\t \x01(\v2+.istio.networking.v1alpha3.WorkloadSelectorR\x10workloadSelector\x12\x1b\n" +
	"\texport_to\x18\a \x03(\tR\bexportTo\x12*\n" +
	"\x11subject_alt_names\x18\b \x03(\tR\x0fsubjectAltNames\"0\n" +
	"\bLocation\x12\x11\n" +
	"\rMESH_EXTERNAL\x10\x00\x12\x11\n" +
	"\rMESH_INTERNAL\x10\x01\"Q\n" +
	"\n" +
	"Resolution\x12\b\n" +
	"\x04NONE\x10\x00\x12\n" +
	"\n" +
	"\x06STATIC\x10\x01\x12\a\n" +
	"\x03DNS\x10\x02\x12\x13\n" +
	"\x0fDNS_ROUND_ROBIN\x10\x03\x12\x0f\n" +
	"\vDYNAMIC_DNS\x10\x04\"\x82\x01\n" +
	"\vServicePort\x12\x1c\n" +
	"\x06number\x18\x01 \x01(\rB\x04\xe2A\x01\x02R\x06number\x12\x1a\n" +
	"\bprotocol\x18\x02 \x01(\tR\bprotocol\x12\x18\n" +
	"\x04name\x18\x03 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12\x1f\n" +
	"\vtarget_port\x18\x04 \x01(\rR\n" +
	"targetPort\"\xb7\x02\n" +
	"\x12ServiceEntryStatus\x12C\n" +
	"\n" +
	"conditions\x18\x01 \x03(\v2#.istio.meta.v1alpha1.IstioConditionR\n" +
	"conditions\x12]\n" +
	"\x13validation_messages\x18\x02 \x03(\v2,.istio.analysis.v1alpha1.AnalysisMessageBaseR\x12validationMessages\x12/\n" +
	"\x13observed_generation\x18\x03 \x01(\x03R\x12observedGeneration\x12L\n" +
	"\taddresses\x18\n" +
	" \x03(\v2..istio.networking.v1alpha3.ServiceEntryAddressR\taddresses\"?\n" +
	"\x13ServiceEntryAddress\x12\x14\n" +
	"\x05value\x18\x01 \x01(\tR\x05value\x12\x12\n" +
	"\x04host\x18\x02 \x01(\tR\x04hostB\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_service_entry_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_service_entry_proto_rawDescData []byte
)

func file_networking_v1alpha3_service_entry_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_service_entry_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_service_entry_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_service_entry_proto_rawDesc), len(file_networking_v1alpha3_service_entry_proto_rawDesc)))
	})
	return file_networking_v1alpha3_service_entry_proto_rawDescData
}

var file_networking_v1alpha3_service_entry_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_networking_v1alpha3_service_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_networking_v1alpha3_service_entry_proto_goTypes = []any{
	(ServiceEntry_Location)(0),            // 0: istio.networking.v1alpha3.ServiceEntry.Location
	(ServiceEntry_Resolution)(0),          // 1: istio.networking.v1alpha3.ServiceEntry.Resolution
	(*ServiceEntry)(nil),                  // 2: istio.networking.v1alpha3.ServiceEntry
	(*ServicePort)(nil),                   // 3: istio.networking.v1alpha3.ServicePort
	(*ServiceEntryStatus)(nil),            // 4: istio.networking.v1alpha3.ServiceEntryStatus
	(*ServiceEntryAddress)(nil),           // 5: istio.networking.v1alpha3.ServiceEntryAddress
	(*WorkloadEntry)(nil),                 // 6: istio.networking.v1alpha3.WorkloadEntry
	(*WorkloadSelector)(nil),              // 7: istio.networking.v1alpha3.WorkloadSelector
	(*v1alpha1.IstioCondition)(nil),       // 8: istio.meta.v1alpha1.IstioCondition
	(*v1alpha11.AnalysisMessageBase)(nil), // 9: istio.analysis.v1alpha1.AnalysisMessageBase
}
var file_networking_v1alpha3_service_entry_proto_depIdxs = []int32{
	3, // 0: istio.networking.v1alpha3.ServiceEntry.ports:type_name -> istio.networking.v1alpha3.ServicePort
	0, // 1: istio.networking.v1alpha3.ServiceEntry.location:type_name -> istio.networking.v1alpha3.ServiceEntry.Location
	1, // 2: istio.networking.v1alpha3.ServiceEntry.resolution:type_name -> istio.networking.v1alpha3.ServiceEntry.Resolution
	6, // 3: istio.networking.v1alpha3.ServiceEntry.endpoints:type_name -> istio.networking.v1alpha3.WorkloadEntry
	7, // 4: istio.networking.v1alpha3.ServiceEntry.workload_selector:type_name -> istio.networking.v1alpha3.WorkloadSelector
	8, // 5: istio.networking.v1alpha3.ServiceEntryStatus.conditions:type_name -> istio.meta.v1alpha1.IstioCondition
	9, // 6: istio.networking.v1alpha3.ServiceEntryStatus.validation_messages:type_name -> istio.analysis.v1alpha1.AnalysisMessageBase
	5, // 7: istio.networking.v1alpha3.ServiceEntryStatus.addresses:type_name -> istio.networking.v1alpha3.ServiceEntryAddress
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_service_entry_proto_init() }
func file_networking_v1alpha3_service_entry_proto_init() {
	if File_networking_v1alpha3_service_entry_proto != nil {
		return
	}
	file_networking_v1alpha3_sidecar_proto_init()
	file_networking_v1alpha3_workload_entry_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_service_entry_proto_rawDesc), len(file_networking_v1alpha3_service_entry_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_service_entry_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_service_entry_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_service_entry_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_service_entry_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_service_entry_proto = out.File
	file_networking_v1alpha3_service_entry_proto_goTypes = nil
	file_networking_v1alpha3_service_entry_proto_depIdxs = nil
}
