#include "ffmpeg.h"

// NOTE: All test frames MUST be 720p in order for us to provide the correct dimensions in the AVCodecContext!
// See FFmpegVideoDecoder::tryInitializeRenderer() for details.

// 720p 60 FPS H.264 with 1 reference frame
const uint8_t FFmpegVideoDecoder::k_H264TestFrame[] = {
    0x00, 0x00, 0x00, 0x01, 0x67, 0x64, 0x00, 0x20, 0xac, 0x2b, 0x40, 0x28, 0x02, 0xdd, 0x80, 0xb5, 0x06, 0x06, 0x06, 0xa5, 0x00, 0x00, 0x03, 0x03, 0xe8, 0x00, 0x01, 0xd4, 0xc0, 0x8f, 0x4a, 0xa0,
    0x00, 0x00, 0x00, 0x01, 0x68, 0xee, 0x3c, 0xb0,
    0x00, 0x00, 0x00, 0x01, 0x65, 0xb8, 0x02, 0x01, 0x67, 0x25, 0x1b, 0xf4, 0xfa, 0x7d, 0x40, 0x1a, 0x78, 0xe5, 0x10, 0x52, 0xc2, 0xee, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0xc6, 0xef, 0xbb, 0x81, 0x85, 0x2d, 0x47, 0xda, 0xca, 0x4c, 0x00, 0x00, 0x03, 0x00, 0x02, 0x7b, 0xcf, 0x80, 0x00, 0x45, 0x40, 0x01, 0x8d, 0xa6, 0x00, 0x01, 0x64, 0x00, 0x0e, 0x03, 0xc8, 0x00, 0x0e, 0x10, 0x00, 0xbd, 0xc5, 0x00, 0x01, 0x11, 0x00, 0x0e, 0xa3, 0x80, 0x00, 0x38, 0xa0,
    0x00, 0x00, 0x01, 0x65, 0x00, 0x6e, 0x2e, 0x00, 0x83, 0x7f, 0xb4, 0x8e, 0x79, 0xa5, 0xff, 0x84, 0x3f, 0x7f, 0x34, 0x3f, 0x97, 0x1b, 0xaf, 0x31, 0x5f, 0x6e, 0xaa, 0xb6, 0xac, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x78, 0x36, 0x9d, 0xa4, 0x65, 0xf9, 0x1e, 0x5b, 0x3a, 0xb0, 0x40, 0x00, 0x00, 0x03, 0x00, 0x00, 0x41, 0x80, 0x00, 0xc5, 0xc8, 0x00, 0x00, 0xfa, 0x00, 0x03, 0x24, 0x00, 0x0e, 0x20, 0x00, 0x3f, 0x80, 0x01, 0x32, 0x00, 0x08, 0x68, 0x00, 0x3e, 0xc0, 0x03, 0x8a,
    0x00, 0x00, 0x01, 0x65, 0x00, 0x37, 0x0b, 0x80, 0x21, 0x7f, 0xe3, 0x85, 0x1c, 0xd9, 0xff, 0xe1, 0x1b, 0x01, 0xfa, 0xc0, 0x3e, 0x11, 0x7e, 0xfe, 0x45, 0x5c, 0x43, 0x69, 0x31, 0x4b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x02, 0x24, 0xae, 0x1a, 0xbb, 0xae, 0x75, 0x9e, 0x35, 0xae, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x03, 0x64, 0x00, 0x09, 0x98, 0x00, 0x1e, 0xc0, 0x00, 0x64, 0x80, 0x01, 0xc4, 0x00, 0x07, 0xf0, 0x00, 0x42, 0xf0, 0x00, 0x00, 0xe1, 0x98, 0x00, 0x05, 0x4b, 0x28, 0x00, 0x06, 0x04,
    0x00, 0x00, 0x01, 0x65, 0x00, 0x14, 0xa2, 0xe0, 0x08, 0x5f, 0xe3, 0x85, 0x1c, 0xd9, 0xff, 0xe1, 0x1b, 0x01, 0xfa, 0xc0, 0x3e, 0x11, 0x7e, 0xfe, 0x45, 0x5c, 0x43, 0x69, 0x31, 0x4b, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x02, 0x24, 0xb9, 0x7d, 0xb4, 0x70, 0x4d, 0x15, 0xc5, 0x0a, 0x4e, 0x60, 0x00, 0x00, 0x03, 0x00, 0x00, 0x26, 0xa8, 0xb0, 0x00, 0x13, 0xcd, 0xcc, 0x00, 0x07, 0x48, 0x88, 0x00, 0x06, 0x29, 0x69, 0x00, 0x01, 0x16, 0xac, 0x80, 0x00, 0x9e, 0x4e, 0x80, 0x00, 0x3f, 0x84, 0x20, 0x00, 0x6f, 0x41, 0xa0, 0x00, 0x20, 0x00, 0x02, 0x16, 0xb8, 0x00, 0x08, 0x08
};

// 720p 60 FPS HEVC Main with 1 reference frame
const uint8_t FFmpegVideoDecoder::k_HEVCMainTestFrame[] = {
    0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01, 0xff, 0xff, 0x01, 0x40, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x78, 0xac, 0x09,
    0x00, 0x00, 0x00, 0x01, 0x42, 0x01, 0x01, 0x01, 0x40, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x78, 0xa0, 0x02, 0x80, 0x80, 0x2e, 0x1f, 0x13, 0x96, 0xb4, 0xa4, 0x25, 0x92, 0xe3, 0x01, 0x6a, 0x0c, 0x0c, 0x0d, 0x48, 0x20, 0x00, 0x00, 0x03, 0x00, 0x20, 0x00, 0x00, 0x07, 0x85, 0xf1, 0xa2, 0xd0,
    0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc0, 0xf7, 0xc0, 0xcc, 0x90,
    0x00, 0x00, 0x00, 0x01, 0x2a, 0x01, 0xac, 0x0c, 0xf0, 0xe6, 0xf6, 0x5e, 0xff, 0xd9, 0x97, 0xeb, 0x44, 0x7d, 0x1f, 0xa4, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x03, 0x52, 0x7c, 0x4e, 0x5b, 0xfe, 0xbe, 0xc2, 0x87, 0x20, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x2b, 0x60,
};

// 720p 60 FPS HEVC Main10 with 1 reference frame
const uint8_t FFmpegVideoDecoder::k_HEVCMain10TestFrame[] = {
    0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01, 0xff, 0xff, 0x02, 0x20, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x78, 0xac, 0x09,
    0x00, 0x00, 0x00, 0x01, 0x42, 0x01, 0x01, 0x02, 0x20, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x78, 0xa0, 0x02, 0x80, 0x80, 0x2e, 0x1f, 0x12, 0xd9, 0x6b, 0x4a, 0x42, 0x59, 0x2e, 0x30, 0x16, 0xa0, 0xc0, 0xc0, 0xd4, 0x82, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x03, 0x00, 0x78, 0x5f, 0x1a, 0x2d,
    0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc0, 0xf3, 0xc0, 0x4c, 0x90,
    0x00, 0x00, 0x00, 0x01, 0x2a, 0x01, 0xac, 0x0c, 0xf0, 0xbc, 0x48, 0x02, 0x6f, 0xff, 0xd3, 0xee, 0x76, 0xf2, 0x4e, 0x53, 0x5f, 0x1e, 0xbb, 0x79, 0x03, 0x0e, 0xd5, 0x68, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x07, 0xb4,
    0x00, 0x00, 0x00, 0x01, 0x2a, 0x01, 0x26, 0x43, 0x03, 0x3c, 0x2f, 0x48, 0x02, 0x6f, 0xff, 0xd3, 0xee, 0x76, 0xf2, 0x4e, 0x53, 0x5f, 0x1e, 0xbb, 0x79, 0x03, 0x0e, 0xd5, 0x68, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x05, 0xb4,
    0x00, 0x00, 0x00, 0x01, 0x2a, 0x01, 0x2d, 0xc3, 0x03, 0x3c, 0x2f, 0x48, 0x02, 0x6f, 0xff, 0xd3, 0xee, 0x76, 0xf2, 0x4e, 0x53, 0x5f, 0x1e, 0xbb, 0x79, 0x03, 0x0e, 0xd5, 0x68, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x04, 0x24,
    0x00, 0x00, 0x00, 0x01, 0x2a, 0x01, 0x36, 0x83, 0x03, 0x3c, 0x2f, 0x48, 0x02, 0x6f, 0xff, 0xd3, 0xee, 0x76, 0xf2, 0x4e, 0x53, 0x5f, 0x1e, 0xbb, 0x79, 0x03, 0x0e, 0xd5, 0x68, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x07, 0xb4
};

// 720p 60 FPS AV1 Main 8-bit
const uint8_t FFmpegVideoDecoder::k_AV1Main8TestFrame[] = {
    0x12, 0x00, 0x0A, 0x10, 0x00, 0x00, 0x00, 0x43, 0xFC, 0x13, 0xFC, 0x0B, 0x3C, 0x02, 0x4E, 0x88, 0x30, 0x30, 0x30, 0xA0, 0x32, 0x8E, 0x81, 0x80, 0x00, 0x10, 0x00, 0x4B, 0x00, 0x10, 0xC2, 0xFB, 0xE1, 0x52, 0x49, 0xFF, 0xE0, 0x00, 0x28, 0xB8, 0xB4, 0x5D, 0x8F, 0xF0, 0x01, 0x33, 0xAC, 0x5D, 0xD3, 0xCB, 0xF0, 0xFB, 0x2F, 0x59, 0xE9, 0xBF, 0x5B, 0x6E, 0x2C, 0x7A, 0x2B, 0xD1, 0xC5, 0x45, 0x24, 0x93, 0xC7, 0x92, 0x89, 0x89, 0x4E, 0x6F, 0x04, 0x58, 0x09, 0xD1, 0x70, 0x67, 0xE9, 0xB6, 0x09, 0x1A, 0x35, 0xB6, 0x37, 0x4E, 0x7D, 0x61, 0xC3, 0xF5, 0xBD, 0x48, 0xA4, 0x23, 0x60, 0x59, 0xA2, 0xA0, 0x21, 0xDA, 0x20, 0x92, 0xDB, 0xB9, 0x31, 0x43, 0xFB, 0x86, 0xD2, 0x51, 0xF2, 0x05, 0x5F, 0x44, 0x35, 0xF0, 0xB9, 0x06, 0x3D, 0xB1, 0xB1, 0x58, 0x2F, 0x4C, 0x36, 0xCF, 0x82, 0x73, 0x40, 0x1F, 0x9F, 0xBB, 0x42, 0x58, 0xCD, 0x8E, 0x29, 0xEF, 0x7A, 0x2D, 0xD8, 0x26, 0xAA, 0x78, 0xA9, 0x6F, 0x07, 0x8A, 0x84, 0x53, 0x56, 0x3A, 0x7F, 0x0F, 0xC2, 0xF8, 0x24, 0xF1, 0x26, 0xF0, 0x54, 0x42, 0x63, 0x46, 0x15, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// 720p 60 FPS AV1 Main 10-bit
const uint8_t FFmpegVideoDecoder::k_AV1Main10TestFrame[] = {
    0x12, 0x00, 0x0A, 0x10, 0x00, 0x00, 0x00, 0x43, 0xFC, 0x13, 0xFC, 0x0B, 0x3C, 0x02, 0x4E, 0xA8, 0x30, 0x30, 0x30, 0xA0, 0x32, 0x8B, 0x81, 0x80, 0x00, 0x10, 0x00, 0x4B, 0x00, 0x10, 0xC2, 0xFB, 0xE1, 0x52, 0x49, 0xFF, 0xE0, 0x00, 0x28, 0xB8, 0xB4, 0x5D, 0x8F, 0xF0, 0x01, 0x33, 0xAC, 0x5D, 0xD3, 0xCB, 0xF0, 0xFB, 0x2F, 0x59, 0xE9, 0xBF, 0x5B, 0x6E, 0x2C, 0x7A, 0x2B, 0xD1, 0xC5, 0x45, 0x24, 0x93, 0xC7, 0x92, 0x89, 0x89, 0x4E, 0x6F, 0x04, 0x58, 0x09, 0xD1, 0x70, 0x67, 0xE9, 0xB6, 0x09, 0x1A, 0x35, 0xB6, 0x37, 0x4E, 0x7D, 0x61, 0xC3, 0xF5, 0xBD, 0x48, 0xA4, 0x23, 0x60, 0x59, 0xA2, 0xA0, 0x21, 0xDA, 0x20, 0x92, 0xDB, 0xB9, 0x31, 0x43, 0xFB, 0x85, 0xD9, 0x3B, 0x4F, 0xF3, 0x96, 0x05, 0x0A, 0x98, 0x6E, 0xCE, 0xC5, 0x3F, 0xCD, 0x18, 0x6D, 0x2C, 0x17, 0x49, 0x68, 0xC3, 0x4A, 0xC0, 0xF5, 0x58, 0x0C, 0xA4, 0xDE, 0xF6, 0x4A, 0x11, 0x24, 0xC2, 0xE0, 0x24, 0xB7, 0x00, 0xCB, 0x71, 0x96, 0xDA, 0x35, 0xFD, 0xBA, 0x3F, 0xD9, 0xB7, 0x58, 0xF2, 0x28, 0x14, 0x2D, 0xB0, 0xE9, 0xE3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// 720p H.264 High 4:4:4
// ffmpeg -i green128.png -pix_fmt yuv444p -colorspace smpte170m -color_trc smpte170m -color_primaries smpte170m -c:v libx264 -bsf:v filter_units=remove_types=6 test8_444.h264
// xxd -i test8_444.h264
const uint8_t FFmpegVideoDecoder::k_h264High_444TestFrame[] = {
  0x00, 0x00, 0x00, 0x01, 0x67, 0xf4, 0x00, 0x1f, 0x91, 0x9b, 0x28, 0x0a,
  0x00, 0xb7, 0x60, 0x2d, 0x41, 0x81, 0x81, 0x90, 0x00, 0x00, 0x03, 0x00,
  0x10, 0x00, 0x00, 0x03, 0x03, 0x20, 0xf1, 0x83, 0x19, 0x60, 0x00, 0x00,
  0x00, 0x01, 0x68, 0xeb, 0xe3, 0xc4, 0x48, 0x44, 0x00, 0x00, 0x01, 0x65,
  0x88, 0x84, 0x00, 0x2b, 0xff, 0xfe, 0xf5, 0xdb, 0xf3, 0x2c, 0x93, 0x97,
  0x37, 0xc0, 0xa5, 0x7d, 0x51, 0xf0, 0x29, 0x74, 0xec, 0x3f, 0xff, 0x07,
  0xb6, 0x53, 0xd1, 0x9d, 0x16, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x59, 0x20, 0x00, 0x00, 0x03, 0x00, 0x69, 0xa0, 0x00,
  0x09, 0x84, 0x00, 0x01, 0x59, 0x80, 0x00, 0x44, 0xe0, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x0b, 0x29,
};

// 720p HEVC RExt8 4:4:4
// ffmpeg -i green128.png -pix_fmt yuv444p -colorspace smpte170m -color_trc smpte170m -color_primaries smpte170m -c:v libx265 -x265-params info=0 test8_444.hevc
// xxd -i test8_444.hevc
const uint8_t FFmpegVideoDecoder::k_HEVCRExt8_444TestFrame[] = {
  0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01, 0xff, 0xff, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x5d,
  0x95, 0x98, 0x09, 0x00, 0x00, 0x00, 0x01, 0x42, 0x01, 0x01, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x5d,
  0x90, 0x00, 0x50, 0x10, 0x05, 0xa2, 0xcb, 0x2b, 0x34, 0x92, 0x65, 0x78,
  0x0b, 0x50, 0x60, 0x60, 0x60, 0x40, 0x00, 0x00, 0x03, 0x00, 0x40, 0x00,
  0x00, 0x06, 0x42, 0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc1, 0x72, 0x86,
  0x0c, 0x46, 0x24, 0x00, 0x00, 0x01, 0x28, 0x01, 0xaf, 0x1d, 0x18, 0x69,
  0x57, 0x59, 0x55, 0x54, 0x51, 0x34, 0xd2, 0x4a, 0xf7, 0xcf, 0x80, 0xff,
  0xf1, 0xcc, 0x1f, 0xc9, 0x84, 0x7d, 0xf8, 0xb6, 0xba, 0xfa, 0xcd, 0x61,
  0xb5, 0xe3, 0xc1, 0x02, 0x19, 0x26, 0x30, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x04, 0xf4, 0xa8, 0x17,
  0x96, 0x03, 0x4c, 0x4e, 0x1a, 0x80, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x09, 0xf8, 0x93, 0x0b,
  0x93, 0x40, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x48, 0xc0, 0x87, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x01, 0xa3, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0xb5, 0x80, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x0b, 0xd8, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x51, 0xc0, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x01, 0x39, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x02, 0xca, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x04, 0x74, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x07, 0x6c, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x27, 0xa0,
};

// 720p HEVC RExt10 4:4:4
// ffmpeg -i green128.png -pix_fmt yuv444p10 -colorspace bt2020nc -color_trc smpte2084 -color_primaries bt2020 -c:v libx265 -x265-params info=0 test10_444.hevc
// xxd -i test10_444.hevc
const uint8_t FFmpegVideoDecoder::k_HEVCRExt10_444TestFrame[] = {
  0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01, 0xff, 0xff, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9c, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x5d,
  0x95, 0x98, 0x09, 0x00, 0x00, 0x00, 0x01, 0x42, 0x01, 0x01, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9c, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x5d,
  0x90, 0x00, 0x50, 0x10, 0x05, 0xa2, 0x6c, 0xb2, 0xb3, 0x49, 0x26, 0x57,
  0x80, 0xb5, 0x09, 0x10, 0x09, 0x04, 0x00, 0x00, 0x03, 0x00, 0x04, 0x00,
  0x00, 0x03, 0x00, 0x64, 0x20, 0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc1,
  0x72, 0x86, 0x0c, 0x46, 0x24, 0x00, 0x00, 0x01, 0x28, 0x01, 0xaf, 0x1d,
  0x18, 0x69, 0x57, 0x59, 0x55, 0x54, 0x51, 0x34, 0xd2, 0x4a, 0xf7, 0xcf,
  0x80, 0xff, 0xf1, 0xef, 0x9f, 0xc9, 0x84, 0x7d, 0xf8, 0xb6, 0xba, 0xfa,
  0xcd, 0x61, 0xb5, 0xe3, 0xc1, 0x02, 0x19, 0x26, 0x30, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x04, 0xf4,
  0xa8, 0x17, 0x96, 0x03, 0x4c, 0x4e, 0x1a, 0x80, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x09, 0xf8,
  0x93, 0x0b, 0x93, 0x40, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x48, 0xc0, 0x87,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x01, 0xa3, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0xb5, 0x80, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x0b, 0xd8, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x51,
  0xc0, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x01, 0x39, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x02, 0xca, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x04, 0x74,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x07, 0x6c, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x27, 0xa0,
};

// 720p AV1 High8 4:4:4
// ffmpeg -i green128.png -pix_fmt yuv444p -colorspace smpte170m -color_trc smpte170m -color_primaries smpte170m -c:v libaom-av1 test8_444.obu
// xxd -i test8_444.obu
const uint8_t FFmpegVideoDecoder::k_AV1High8_444TestFrame[] = {
  0x12, 0x00, 0x0a, 0x0e, 0x20, 0x00, 0x00, 0x2d, 0x4c, 0xff, 0xb3, 0xdf,
  0xff, 0x9a, 0x0c, 0x0c, 0x0c, 0x20, 0x32, 0x25, 0x10, 0x00, 0x90, 0x00,
  0x00, 0x00, 0xa0, 0x00, 0x00, 0x80, 0x0c, 0x80, 0xad, 0xfd, 0xdb, 0x2e,
  0x81, 0x37, 0x40, 0xfd, 0x19, 0x97, 0xdc, 0x15, 0x72, 0x1d, 0xe0, 0xff,
  0x00, 0x35, 0x9d, 0x2c, 0x10, 0x7d, 0x17, 0x58, 0x60,
};

// 720p AV1 High10 4:4:4
// ffmpeg -i green128.png -pix_fmt yuv444p10 -colorspace bt2020nc -color_trc smpte2084 -color_primaries bt2020 -c:v libaom-av1 test10_444.obu
// xxd -i test10_444.obu
const uint8_t FFmpegVideoDecoder::k_AV1High10_444TestFrame[] = {
  0x12, 0x00, 0x0a, 0x0e, 0x20, 0x00, 0x00, 0x2d, 0x4c, 0xff, 0xb3, 0xdf,
  0xff, 0x9e, 0x12, 0x20, 0x12, 0x20, 0x32, 0x25, 0x10, 0x00, 0x90, 0x00,
  0x00, 0x00, 0xa0, 0x00, 0x00, 0x80, 0x0c, 0x80, 0xad, 0xfe, 0x04, 0x70,
  0x81, 0x37, 0x40, 0xfd, 0x19, 0x97, 0xdc, 0x15, 0x72, 0x1d, 0xe0, 0xff,
  0x00, 0x35, 0x9d, 0x2c, 0x10, 0x7d, 0x17, 0x58, 0x60,
};
