/* ConversationList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConversationList.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <camel/camel.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <handy.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#define MAIL_CONVERSATION_LIST_MARK_READ_TIMEOUT_SECONDS 5
#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_REFRESH "refresh"
#define MAIL_MAIN_WINDOW_ACTION_MARK_READ "mark-read"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD "mark-unread"
#define MAIL_MAIN_WINDOW_ACTION_MARK_STAR "mark-star"
#define MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR "mark-unstar"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_CONVERSATION_LIST (mail_conversation_list_get_type ())
#define MAIL_CONVERSATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_LIST, MailConversationList))
#define MAIL_CONVERSATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_LIST, MailConversationListClass))
#define MAIL_IS_CONVERSATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_LIST))
#define MAIL_IS_CONVERSATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_LIST))
#define MAIL_CONVERSATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_LIST, MailConversationListClass))

typedef struct _MailConversationList MailConversationList;
typedef struct _MailConversationListClass MailConversationListClass;
typedef struct _MailConversationListPrivate MailConversationListPrivate;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;

#define MAIL_TYPE_CONVERSATION_ITEM_MODEL (mail_conversation_item_model_get_type ())
#define MAIL_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel))
#define MAIL_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))
#define MAIL_IS_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_IS_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_CONVERSATION_ITEM_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))

typedef struct _MailConversationItemModel MailConversationItemModel;
typedef struct _MailConversationItemModelClass MailConversationItemModelClass;

#define TYPE_VIRTUALIZING_LIST_BOX_MODEL (virtualizing_list_box_model_get_type ())
#define VIRTUALIZING_LIST_BOX_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModel))
#define VIRTUALIZING_LIST_BOX_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModelClass))
#define IS_VIRTUALIZING_LIST_BOX_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL))
#define IS_VIRTUALIZING_LIST_BOX_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX_MODEL))
#define VIRTUALIZING_LIST_BOX_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX_MODEL, VirtualizingListBoxModelClass))

typedef struct _VirtualizingListBoxModel VirtualizingListBoxModel;
typedef struct _VirtualizingListBoxModelClass VirtualizingListBoxModelClass;

#define MAIL_TYPE_CONVERSATION_LIST_STORE (mail_conversation_list_store_get_type ())
#define MAIL_CONVERSATION_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_LIST_STORE, MailConversationListStore))
#define MAIL_CONVERSATION_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_LIST_STORE, MailConversationListStoreClass))
#define MAIL_IS_CONVERSATION_LIST_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_LIST_STORE))
#define MAIL_IS_CONVERSATION_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_LIST_STORE))
#define MAIL_CONVERSATION_LIST_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_LIST_STORE, MailConversationListStoreClass))

typedef struct _MailConversationListStore MailConversationListStore;
typedef struct _MailConversationListStoreClass MailConversationListStoreClass;

#define TYPE_VIRTUALIZING_LIST_BOX (virtualizing_list_box_get_type ())
#define VIRTUALIZING_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBox))
#define VIRTUALIZING_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBoxClass))
#define IS_VIRTUALIZING_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX))
#define IS_VIRTUALIZING_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX))
#define VIRTUALIZING_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX, VirtualizingListBoxClass))

typedef struct _VirtualizingListBox VirtualizingListBox;
typedef struct _VirtualizingListBoxClass VirtualizingListBoxClass;
enum  {
	MAIL_CONVERSATION_LIST_0_PROPERTY,
	MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY,
	MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY,
	MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY,
	MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY,
	MAIL_CONVERSATION_LIST_NUM_PROPERTIES
};
static GParamSpec* mail_conversation_list_properties[MAIL_CONVERSATION_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block30Data Block30Data;
#define __vala_CamelFolderInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelFolderInfo_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailConversationListLoadFolderData MailConversationListLoadFolderData;
typedef struct _MailConversationListRefreshFolderData MailConversationListRefreshFolderData;
typedef struct _Block31Data Block31Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH,
	MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH
} MailMoveOperationMoveType;

#define MAIL_MOVE_OPERATION_TYPE_MOVE_TYPE (mail_move_operation_move_type_get_type ())
typedef struct _Block32Data Block32Data;

#define MAIL_TYPE_MOVE_OPERATION (mail_move_operation_get_type ())
#define MAIL_MOVE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MOVE_OPERATION, MailMoveOperation))
#define MAIL_MOVE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MOVE_OPERATION, MailMoveOperationClass))
#define MAIL_IS_MOVE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MOVE_OPERATION))
#define MAIL_IS_MOVE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MOVE_OPERATION))
#define MAIL_MOVE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MOVE_OPERATION, MailMoveOperationClass))

typedef struct _MailMoveOperation MailMoveOperation;
typedef struct _MailMoveOperationClass MailMoveOperationClass;
typedef struct _MailConversationListMoveSelectedMessagesData MailConversationListMoveSelectedMessagesData;
typedef gboolean (*MailConversationListStoreRowVisibilityFunc) (GObject* row, gpointer user_data);

#define TYPE_VIRTUALIZING_LIST_BOX_ROW (virtualizing_list_box_row_get_type ())
#define VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRow))
#define VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))
#define IS_VIRTUALIZING_LIST_BOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define IS_VIRTUALIZING_LIST_BOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIRTUALIZING_LIST_BOX_ROW))
#define VIRTUALIZING_LIST_BOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRowClass))

typedef struct _VirtualizingListBoxRow VirtualizingListBoxRow;
typedef struct _VirtualizingListBoxRowClass VirtualizingListBoxRowClass;

#define MAIL_TYPE_CONVERSATION_LIST_ITEM (mail_conversation_list_item_get_type ())
#define MAIL_CONVERSATION_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItem))
#define MAIL_CONVERSATION_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItemClass))
#define MAIL_IS_CONVERSATION_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM))
#define MAIL_IS_CONVERSATION_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_LIST_ITEM))
#define MAIL_CONVERSATION_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_LIST_ITEM, MailConversationListItemClass))

typedef struct _MailConversationListItem MailConversationListItem;
typedef struct _MailConversationListItemClass MailConversationListItemClass;
typedef struct _Block33Data Block33Data;
typedef struct _VirtualizingListBoxPrivate VirtualizingListBoxPrivate;
typedef VirtualizingListBoxRow* (*VirtualizingListBoxRowFactoryMethod) (GObject* item, VirtualizingListBoxRow* old_widget, gpointer user_data);
typedef struct _Block34Data Block34Data;
enum  {
	MAIL_CONVERSATION_LIST_CONVERSATION_SELECTED_SIGNAL,
	MAIL_CONVERSATION_LIST_CONVERSATION_FOCUSED_SIGNAL,
	MAIL_CONVERSATION_LIST_NUM_SIGNALS
};
static guint mail_conversation_list_signals[MAIL_CONVERSATION_LIST_NUM_SIGNALS] = {0};

struct _MailConversationList {
	GtkBox parent_instance;
	MailConversationListPrivate * priv;
};

struct _MailConversationListClass {
	GtkBoxClass parent_class;
};

struct _MailConversationListPrivate {
	GeeMap* _folder_info_per_account;
	GeeHashMap* _folders;
	GeeHashMap* _folder_info_flags;
	HdyHeaderBar* _search_header;
	GCancellable* cancellable;
	GeeHashMap* threads;
	GRecMutex __lock_threads;
	GeeHashMap* conversations;
	GRecMutex __lock_conversations;
	MailConversationListStore* list_store;
	VirtualizingListBox* list_box;
	GtkSearchEntry* search_entry;
	GraniteSwitchModelButton* hide_read_switch;
	GraniteSwitchModelButton* hide_unstarred_switch;
	GtkMenuButton* filter_button;
	GtkStack* refresh_stack;
	guint mark_read_timeout_id;
	GRecMutex __lock_folder_info_per_account;
	GRecMutex __lock_folders;
};

struct _Block30Data {
	int _ref_count_;
	MailConversationList* self;
	MailBackendAccount* current_account;
};

struct _MailConversationListLoadFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailConversationList* self;
	GeeMap* folder_info_per_account;
	GeeMap* _tmp0_;
	GeeMap* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	guint previous_items;
	MailConversationListStore* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	MailConversationListStore* _tmp11_;
	MailConversationListStore* _tmp12_;
	GCancellable* _tmp13_;
	GeeMap* _tmp14_;
	GeeIterator* _folder_info_entry_it;
	GeeMap* _tmp15_;
	GeeIterator* _tmp16_;
	Block30Data* _data30_;
	GeeIterator* _tmp17_;
	GeeMapEntry* folder_info_entry;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	GeeMapEntry* _tmp20_;
	gconstpointer _tmp21_;
	gconstpointer _tmp22_;
	MailBackendAccount* _tmp23_;
	CamelFolderInfo* current_folder_info;
	GeeMapEntry* _tmp24_;
	gconstpointer _tmp25_;
	gconstpointer _tmp26_;
	CamelFolderInfo* _tmp27_;
	CamelFolderInfo* _tmp28_;
	CamelStore* camel_store;
	MailBackendAccount* _tmp29_;
	CamelService* _tmp30_;
	CamelService* _tmp31_;
	CamelStore* _tmp32_;
	CamelFolder* folder;
	CamelStore* _tmp33_;
	CamelFolderInfo* _tmp34_;
	const gchar* _tmp35_;
	GCancellable* _tmp36_;
	CamelFolder* _tmp37_;
	GeeHashMap* _tmp38_;
	MailBackendAccount* _tmp39_;
	CamelService* _tmp40_;
	CamelService* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	CamelFolder* _tmp44_;
	CamelFolderInfoFlags info_flags;
	MailBackendAccount* _tmp45_;
	CamelService* _tmp46_;
	CamelService* _tmp47_;
	CamelFolderInfo* _tmp48_;
	GeeHashMap* _tmp49_;
	MailBackendAccount* _tmp50_;
	CamelService* _tmp51_;
	CamelService* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	CamelFolder* _tmp55_;
	GPtrArray* search_result_uids;
	MailBackendAccount* _tmp56_;
	CamelService* _tmp57_;
	CamelService* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	GPtrArray* _tmp61_;
	GPtrArray* _tmp62_;
	CamelFolderThread* thread;
	CamelFolder* _tmp63_;
	GPtrArray* _tmp64_;
	CamelFolderThread* _tmp65_;
	GeeHashMap* _tmp66_;
	MailBackendAccount* _tmp67_;
	CamelService* _tmp68_;
	CamelService* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	CamelFolderThread* _tmp72_;
	CamelFolderThreadNode* child;
	CamelFolderThread* _tmp73_;
	CamelFolderThreadNode* _tmp74_;
	CamelFolderThreadNode* _tmp75_;
	GCancellable* _tmp76_;
	GeeHashMap* _tmp77_;
	MailBackendAccount* _tmp78_;
	CamelService* _tmp79_;
	CamelService* _tmp80_;
	const gchar* _tmp81_;
	const gchar* _tmp82_;
	gpointer _tmp83_;
	CamelFolderThreadNode* _tmp84_;
	CamelFolderThread* _tmp85_;
	MailBackendAccount* _tmp86_;
	CamelService* _tmp87_;
	CamelService* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	CamelFolderThreadNode* _tmp91_;
	CamelFolderThreadNode* _tmp92_;
	GError* e;
	GError* _tmp93_;
	GError* _tmp94_;
	const gchar* _tmp95_;
	GeeHashMap* _tmp96_;
	GeeHashMap* _tmp97_;
	GeeHashMap* _tmp98_;
	GeeMap* _tmp99_;
	GeeHashMap* _tmp100_;
	GeeHashMap* _tmp101_;
	GeeHashMap* _tmp102_;
	GeeHashMap* _tmp103_;
	GeeHashMap* _tmp104_;
	GeeHashMap* _tmp105_;
	MailConversationListStore* _tmp106_;
	MailConversationListStore* _tmp107_;
	GError* _inner_error0_;
};

struct _MailConversationListRefreshFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailConversationList* self;
	GCancellable* cancellable;
	GtkStack* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeIterator* _folder_it;
	GeeHashMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	CamelFolder* folder;
	GeeIterator* _tmp9_;
	gpointer _tmp10_;
	CamelFolder* _tmp11_;
	GError* e;
	CamelFolder* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	CamelFolder* _tmp15_;
	CamelStore* _tmp16_;
	CamelStore* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GeeHashMap* _tmp22_;
	GtkStack* _tmp23_;
	GError* _inner_error0_;
};

struct _Block31Data {
	int _ref_count_;
	MailConversationList* self;
	gint removed;
};

struct _Block32Data {
	int _ref_count_;
	MailConversationList* self;
	MailConversationItemModel** moved_conversation_items;
	gint moved_conversation_items_length1;
	gint _moved_conversation_items_size_;
	gpointer _async_data_;
};

struct _MailConversationListMoveSelectedMessagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailConversationList* self;
	MailMoveOperationMoveType move_type;
	GVariant* dst_folder_full_name;
	gchar* error_message;
	guint result;
	Block32Data* _data32_;
	gchar* _tmp0_;
	MailConversationItemModel** _tmp1_;
	GeeHashMap* move_threads;
	GeeHashMap* _tmp2_;
	GeeHashSet* selected_rows;
	VirtualizingListBox* _tmp3_;
	GeeHashSet* _tmp4_;
	gint selected_rows_start_index;
	MailConversationListStore* _tmp5_;
	GeeHashSet* _tmp6_;
	gint _tmp7_;
	gpointer* _tmp8_;
	GObject** _tmp9_;
	gint _tmp9__length1;
	GObject* _tmp10_;
	gint _tmp11_;
	GeeIterator* _selected_row_it;
	GeeHashSet* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GObject* selected_row;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	MailConversationItemModel* selected_item_model;
	GObject* _tmp17_;
	MailConversationItemModel* _tmp18_;
	MailConversationItemModel* _tmp19_;
	MailConversationItemModel* _tmp20_;
	MailConversationItemModel* _tmp21_;
	GeeHashMap* _tmp22_;
	MailConversationItemModel* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gpointer _tmp26_;
	GeeArrayList* _tmp27_;
	gboolean _tmp28_;
	GeeHashMap* _tmp29_;
	MailConversationItemModel* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	GeeHashMap* _tmp35_;
	MailConversationItemModel* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gpointer _tmp39_;
	GeeArrayList* _tmp40_;
	MailConversationItemModel* _tmp41_;
	CamelFolderThreadNode* _tmp42_;
	CamelFolderThreadNode* _tmp43_;
	MailConversationListStore* _tmp44_;
	MailConversationListStore* _tmp45_;
	MailConversationListStore* _tmp46_;
	VirtualizingListBox* _tmp47_;
	guint moved;
	GeeIterator* _service_uid_it;
	GeeHashMap* _tmp48_;
	GeeSet* _tmp49_;
	GeeSet* _tmp50_;
	GeeSet* _tmp51_;
	GeeIterator* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	gchar* service_uid;
	GeeIterator* _tmp55_;
	gpointer _tmp56_;
	guint n_messages_moved;
	MailMoveOperation* move_operation;
	GeeHashMap* _tmp57_;
	const gchar* _tmp58_;
	gpointer _tmp59_;
	CamelFolder* _tmp60_;
	GeeHashMap* _tmp61_;
	const gchar* _tmp62_;
	gpointer _tmp63_;
	GeeArrayList* _tmp64_;
	MailMoveOperation* _tmp65_;
	MailMoveOperation* _tmp66_;
	MailMoveOperation* _tmp67_;
	GError* e;
	GError* _tmp68_;
	const gchar* _tmp69_;
	GError* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	MailConversationItemModel** _tmp74_;
	gint _tmp74__length1;
	GError* _inner_error0_;
};

struct _Block33Data {
	int _ref_count_;
	MailConversationList* self;
	MailConversationListItem* row;
};

struct _VirtualizingListBox {
	GtkContainer parent_instance;
	VirtualizingListBoxPrivate * priv;
	VirtualizingListBoxRowFactoryMethod factory_func;
	gpointer factory_func_target;
	GDestroyNotify factory_func_target_destroy_notify;
};

struct _VirtualizingListBoxClass {
	GtkContainerClass parent_class;
};

struct _Block34Data {
	int _ref_count_;
	MailConversationList* self;
	GObject* row;
};

static gint MailConversationList_private_offset;
static gpointer mail_conversation_list_parent_class = NULL;

VALA_EXTERN GType mail_conversation_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationList, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
VALA_EXTERN GType mail_conversation_item_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationItemModel, g_object_unref)
VALA_EXTERN GType virtualizing_list_box_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBoxModel, g_object_unref)
VALA_EXTERN GType mail_conversation_list_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationListStore, g_object_unref)
VALA_EXTERN GType virtualizing_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBox, g_object_unref)
static void mail_conversation_list_set_thread_flag (CamelFolderThreadNode* node,
                                             CamelMessageFlags flag);
static void mail_conversation_list_load_folder_data_free (gpointer _data);
VALA_EXTERN void mail_conversation_list_load_folder (MailConversationList* self,
                                         GeeMap* folder_info_per_account,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void mail_conversation_list_load_folder_finish (MailConversationList* self,
                                                GAsyncResult* _res_);
static gboolean mail_conversation_list_load_folder_co (MailConversationListLoadFolderData* _data_);
VALA_EXTERN GeeMap* mail_conversation_list_get_folder_info_per_account (MailConversationList* self);
static void mail_conversation_list_set_folder_info_per_account (MailConversationList* self,
                                                         GeeMap* value);
VALA_EXTERN guint virtualizing_list_box_model_get_n_items (VirtualizingListBoxModel* self);
VALA_EXTERN GeeHashMap* mail_conversation_list_get_folders (MailConversationList* self);
VALA_EXTERN void mail_conversation_list_store_remove_all (MailConversationListStore* self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static CamelFolderInfo* _vala_CamelFolderInfo_copy (CamelFolderInfo* self);
static void _vala_CamelFolderInfo_free (CamelFolderInfo* self);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
static void mail_conversation_list_load_folder_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
VALA_EXTERN CamelFolderInfoFlags mail_utils_get_full_folder_info_flags (CamelService* service,
                                                            CamelFolderInfo* folderinfo);
VALA_EXTERN GeeHashMap* mail_conversation_list_get_folder_info_flags (MailConversationList* self);
static void _________lambda39_ (Block30Data* _data30_,
                         CamelFolderChangeInfo* change_info);
static void mail_conversation_list_folder_changed (MailConversationList* self,
                                            CamelFolderChangeInfo* change_info,
                                            const gchar* service_uid,
                                            GCancellable* cancellable);
static void __________lambda39__camel_folder_changed (CamelFolder* _sender,
                                               CamelFolderChangeInfo* changes,
                                               gpointer self);
static GPtrArray* mail_conversation_list_get_search_result_uids (MailConversationList* self,
                                                          const gchar* service_uid);
static void mail_conversation_list_add_conversation_item (MailConversationList* self,
                                                   CamelFolderInfoFlags folder_info_flags,
                                                   CamelFolderThreadNode* child,
                                                   CamelFolderThread* thread,
                                                   const gchar* service_uid);
static void mail_conversation_list_refresh_folder_data_free (gpointer _data);
VALA_EXTERN void mail_conversation_list_refresh_folder (MailConversationList* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void mail_conversation_list_refresh_folder_finish (MailConversationList* self,
                                                   GAsyncResult* _res_);
static gboolean mail_conversation_list_refresh_folder_co (MailConversationListRefreshFolderData* _data_);
static void mail_conversation_list_refresh_folder_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void ____lambda40_ (Block31Data* _data31_,
                    const gchar* uid);
VALA_EXTERN void mail_conversation_list_store_remove (MailConversationListStore* self,
                                          MailConversationItemModel* data);
static void _____lambda40__gfunc (gconstpointer data,
                           gpointer self);
VALA_EXTERN gboolean mail_conversation_item_model_is_older_than (MailConversationItemModel* self,
                                                     CamelFolderThreadNode* other_node);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN MailConversationItemModel* mail_conversation_item_model_new (CamelFolderInfoFlags folder_info_flags,
                                                             CamelFolderThreadNode* node,
                                                             CamelFolderThread* thread,
                                                             const gchar* service_uid);
VALA_EXTERN MailConversationItemModel* mail_conversation_item_model_construct (GType object_type,
                                                                   CamelFolderInfoFlags folder_info_flags,
                                                                   CamelFolderThreadNode* node,
                                                                   CamelFolderThread* thread,
                                                                   const gchar* service_uid);
VALA_EXTERN void mail_conversation_list_store_add (MailConversationListStore* self,
                                       MailConversationItemModel* data);
static gboolean mail_conversation_list_filter_function (GObject* obj);
VALA_EXTERN gboolean mail_conversation_item_model_get_deleted (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_hidden (MailConversationItemModel* self);
static gint mail_conversation_list_thread_sort_function (MailConversationItemModel* item1,
                                                  MailConversationItemModel* item2);
VALA_EXTERN gint64 mail_conversation_item_model_get_timestamp (MailConversationItemModel* self);
VALA_EXTERN void mail_conversation_list_mark_read_selected_messages (MailConversationList* self);
VALA_EXTERN GeeHashSet* virtualizing_list_box_get_selected_rows (VirtualizingListBox* self);
VALA_EXTERN CamelFolderThreadNode* mail_conversation_item_model_get_node (MailConversationItemModel* self);
VALA_EXTERN void mail_conversation_list_mark_star_selected_messages (MailConversationList* self);
VALA_EXTERN void mail_conversation_list_mark_unread_selected_messages (MailConversationList* self);
VALA_EXTERN void mail_conversation_list_mark_unstar_selected_messages (MailConversationList* self);
static void mail_conversation_list_move_selected_messages_data_free (gpointer _data);
VALA_EXTERN GType mail_move_operation_move_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void mail_conversation_list_move_selected_messages (MailConversationList* self,
                                                    MailMoveOperationMoveType move_type,
                                                    GVariant* dst_folder_full_name,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN guint mail_conversation_list_move_selected_messages_finish (MailConversationList* self,
                                                            GAsyncResult* _res_,
                                                            gchar** error_message);
static gboolean mail_conversation_list_move_selected_messages_co (MailConversationListMoveSelectedMessagesData* _data_);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
VALA_EXTERN gint virtualizing_list_box_model_get_index_of (VirtualizingListBoxModel* self,
                                               GObject* item);
VALA_EXTERN void mail_conversation_item_model_set_hidden (MailConversationItemModel* self,
                                              gboolean value);
static void _vala_array_add6 (MailConversationItemModel** * array,
                       gint* length,
                       gint* size,
                       MailConversationItemModel* value);
VALA_EXTERN const gchar* mail_conversation_item_model_get_service_uid (MailConversationItemModel* self);
VALA_EXTERN void virtualizing_list_box_select_row_at_index (VirtualizingListBox* self,
                                                gint index);
VALA_EXTERN GType mail_move_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMoveOperation, g_object_unref)
VALA_EXTERN void mail_move_operation_new (CamelFolder* _src_folder,
                              MailMoveOperationMoveType _move_type,
                              GeeArrayList* threads,
                              GVariant* dst_folder_full_name,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN MailMoveOperation* mail_move_operation_new_finish (GAsyncResult* _res_,
                                                   guint* n_messages_moved,
                                                   GError** error);
VALA_EXTERN void mail_move_operation_construct (GType object_type,
                                    CamelFolder* _src_folder,
                                    MailMoveOperationMoveType _move_type,
                                    GeeArrayList* threads,
                                    GVariant* dst_folder_full_name,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN MailMoveOperation* mail_move_operation_construct_finish (GAsyncResult* _res_,
                                                         guint* n_messages_moved,
                                                         GError** error);
static void mail_conversation_list_move_selected_messages_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void _____lambda43_ (Block32Data* _data32_);
static void mail_conversation_list_unhide_conversations (MailConversationList* self,
                                                  MailConversationItemModel** moved_conversation_items,
                                                  gint moved_conversation_items_length1);
static void ______lambda43__mail_move_operation_undone (MailMoveOperation* _sender,
                                                 gpointer self);
VALA_EXTERN MailConversationList* mail_conversation_list_new (void);
VALA_EXTERN MailConversationList* mail_conversation_list_construct (GType object_type);
static void mail_conversation_list_set_folders (MailConversationList* self,
                                         GeeHashMap* value);
static void mail_conversation_list_set_folder_info_flags (MailConversationList* self,
                                                   GeeHashMap* value);
VALA_EXTERN HdyHeaderBar* mail_conversation_list_get_search_header (MailConversationList* self);
static void mail_conversation_list_set_search_header (MailConversationList* self,
                                               HdyHeaderBar* value);
static GObject * mail_conversation_list_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN MailConversationListStore* mail_conversation_list_store_new (void);
VALA_EXTERN MailConversationListStore* mail_conversation_list_store_construct (GType object_type);
VALA_EXTERN void mail_conversation_list_store_set_sort_func (MailConversationListStore* self,
                                                 GCompareDataFunc function,
                                                 gpointer function_target);
static gint _mail_conversation_list_thread_sort_function_gcompare_data_func (gconstpointer a,
                                                                      gconstpointer b,
                                                                      gpointer self);
VALA_EXTERN void mail_conversation_list_store_set_filter_func (MailConversationListStore* self,
                                                   MailConversationListStoreRowVisibilityFunc function,
                                                   gpointer function_target);
static gboolean _mail_conversation_list_filter_function_mail_conversation_list_store_row_visibility_func (GObject* row,
                                                                                                   gpointer self);
VALA_EXTERN VirtualizingListBox* virtualizing_list_box_new (void);
VALA_EXTERN VirtualizingListBox* virtualizing_list_box_construct (GType object_type);
VALA_EXTERN void virtualizing_list_box_set_activate_on_single_click (VirtualizingListBox* self,
                                                         gboolean value);
VALA_EXTERN void virtualizing_list_box_set_model (VirtualizingListBox* self,
                                      VirtualizingListBoxModel* value);
VALA_EXTERN void virtualizing_list_box_set_selection_mode (VirtualizingListBox* self,
                                               GtkSelectionMode value);
VALA_EXTERN GType virtualizing_list_box_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VirtualizingListBoxRow, g_object_unref)
static VirtualizingListBoxRow* _mail_conversation_list___lambda44_ (MailConversationList* self,
                                                             GObject* item,
                                                             VirtualizingListBoxRow* old_widget);
VALA_EXTERN GType mail_conversation_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationListItem, g_object_unref)
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
VALA_EXTERN MailConversationListItem* mail_conversation_list_item_new (void);
VALA_EXTERN MailConversationListItem* mail_conversation_list_item_construct (GType object_type);
static void ___lambda49_ (Block33Data* _data33_);
VALA_EXTERN VirtualizingListBoxRow* virtualizing_list_box_get_selected_row_widget (VirtualizingListBox* self);
VALA_EXTERN void virtualizing_list_box_select_row (VirtualizingListBox* self,
                                       VirtualizingListBoxRow* row);
static void ____lambda49__mail_conversation_list_item_select (MailConversationListItem* _sender,
                                                       gpointer self);
VALA_EXTERN void mail_conversation_list_item_assign (MailConversationListItem* self,
                                         MailConversationItemModel* data);
static VirtualizingListBoxRow* __mail_conversation_list___lambda44__virtualizing_list_box_row_factory_method (GObject* item,
                                                                                                       VirtualizingListBoxRow* old_widget,
                                                                                                       gpointer self);
VALA_EXTERN void mail_move_operation_bind_spinner (GtkSpinner* _spinner);
static void _mail_conversation_list___lambda50_ (MailConversationList* self);
static void __mail_conversation_list___lambda50__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                           gpointer self);
static void _mail_conversation_list___lambda51_ (MailConversationList* self,
                                          GObject* row);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
VALA_EXTERN gboolean mail_conversation_item_model_get_unread (MailConversationItemModel* self);
static gboolean ____lambda52_ (Block34Data* _data34_);
static gboolean _____lambda52__gsource_func (gpointer self);
static void __mail_conversation_list___lambda51__virtualizing_list_box_row_activated (VirtualizingListBox* _sender,
                                                                               GObject* row,
                                                                               gpointer self);
static void _mail_conversation_list___lambda53_ (MailConversationList* self,
                                          GObject* row);
VALA_EXTERN gboolean mail_conversation_item_model_get_flagged (MailConversationItemModel* self);
static void __mail_conversation_list___lambda53__virtualizing_list_box_row_selected (VirtualizingListBox* _sender,
                                                                              GObject* row,
                                                                              gpointer self);
static void _mail_conversation_list___lambda54_ (MailConversationList* self);
static void __mail_conversation_list___lambda54__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void _mail_conversation_list___lambda55_ (MailConversationList* self);
static void __mail_conversation_list___lambda55__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void mail_conversation_list_finalize (GObject * obj);
static GType mail_conversation_list_get_type_once (void);
static void _vala_mail_conversation_list_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_mail_conversation_list_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_conversation_list_get_instance_private (MailConversationList* self)
{
	return G_STRUCT_MEMBER_P (self, MailConversationList_private_offset);
}

static void
mail_conversation_list_set_thread_flag (CamelFolderThreadNode* node,
                                        CamelMessageFlags flag)
{
	void* _tmp0_;
	CamelMessageFlags _tmp1_;
	CamelMessageFlags _tmp2_;
	if (node == NULL) {
		return;
	}
	_tmp0_ = camel_folder_thread_node_get_item (node);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, camel_message_info_get_type (), CamelMessageInfo), "flags", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!((((gint) _tmp2_) & flag) == flag)) {
		void* _tmp3_;
		_tmp3_ = camel_folder_thread_node_get_item (node);
		camel_message_info_set_flags (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, camel_message_info_get_type (), CamelMessageInfo), (guint32) flag, (guint32) (~0));
	}
	{
		CamelFolderThreadNode* child = NULL;
		CamelFolderThreadNode* _tmp4_;
		_tmp4_ = camel_folder_thread_node_get_child (node);
		child = _tmp4_;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				CamelFolderThreadNode* _tmp8_;
				CamelFolderThreadNode* _tmp9_;
				if (!_tmp5_) {
					CamelFolderThreadNode* _tmp6_;
					CamelFolderThreadNode* _tmp7_;
					_tmp6_ = child;
					_tmp7_ = camel_folder_thread_node_get_next (_tmp6_);
					child = _tmp7_;
				}
				_tmp5_ = FALSE;
				_tmp8_ = child;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = child;
				mail_conversation_list_set_thread_flag (_tmp9_, flag);
			}
		}
	}
}

static void
mail_conversation_list_load_folder_data_free (gpointer _data)
{
	MailConversationListLoadFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder_info_per_account);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailConversationListLoadFolderData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_conversation_list_load_folder (MailConversationList* self,
                                    GeeMap* folder_info_per_account,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	MailConversationListLoadFolderData* _data_;
	MailConversationList* _tmp0_;
	GeeMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder_info_per_account != NULL);
	_data_ = g_slice_new0 (MailConversationListLoadFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_conversation_list_load_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder_info_per_account);
	_g_object_unref0 (_data_->folder_info_per_account);
	_data_->folder_info_per_account = _tmp1_;
	mail_conversation_list_load_folder_co (_data_);
}

void
mail_conversation_list_load_folder_finish (MailConversationList* self,
                                           GAsyncResult* _res_)
{
	MailConversationListLoadFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		MailConversationList* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->current_account);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static CamelFolderInfo*
_vala_CamelFolderInfo_copy (CamelFolderInfo* self)
{
	return g_boxed_copy (camel_folder_info_get_type (), self);
}

static gpointer
__vala_CamelFolderInfo_copy0 (gpointer self)
{
	return self ? _vala_CamelFolderInfo_copy (self) : NULL;
}

static void
_vala_CamelFolderInfo_free (CamelFolderInfo* self)
{
	g_boxed_free (camel_folder_info_get_type (), self);
}

static void
mail_conversation_list_load_folder_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	MailConversationListLoadFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_conversation_list_load_folder_co (_data_);
}

static void
_________lambda39_ (Block30Data* _data30_,
                    CamelFolderChangeInfo* change_info)
{
	MailConversationList* self;
	MailBackendAccount* _tmp0_;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	self = _data30_->self;
	g_return_if_fail (change_info != NULL);
	_tmp0_ = _data30_->current_account;
	_tmp1_ = mail_backend_account_get_service (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = camel_service_get_uid (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->cancellable;
	mail_conversation_list_folder_changed (self, change_info, _tmp4_, _tmp5_);
}

static void
__________lambda39__camel_folder_changed (CamelFolder* _sender,
                                          CamelFolderChangeInfo* changes,
                                          gpointer self)
{
	_________lambda39_ (self, changes);
}

static gboolean
mail_conversation_list_load_folder_co (MailConversationListLoadFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_folder_info_per_account;
		g_rec_mutex_lock (&_data_->self->priv->__lock_folder_info_per_account);
		{
			mail_conversation_list_set_folder_info_per_account (_data_->self, _data_->folder_info_per_account);
		}
		__finally0:
		{
			_data_->_tmp1_ = _data_->self->priv->_folder_info_per_account;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_folder_info_per_account);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->self->priv->cancellable;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->cancellable;
		g_cancellable_cancel (_data_->_tmp3_);
	}
	g_signal_emit (_data_->self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_FOCUSED_SIGNAL], 0, NULL);
	g_signal_emit (_data_->self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_SELECTED_SIGNAL], 0, NULL);
	_data_->_tmp4_ = _data_->self->priv->list_store;
	_data_->previous_items = virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _data_->_tmp4_);
	{
		_data_->_tmp5_ = _data_->self->priv->conversations;
		g_rec_mutex_lock (&_data_->self->priv->__lock_conversations);
		{
			{
				_data_->_tmp6_ = _data_->self->priv->_folders;
				g_rec_mutex_lock (&_data_->self->priv->__lock_folders);
				{
					{
						_data_->_tmp7_ = _data_->self->priv->threads;
						g_rec_mutex_lock (&_data_->self->priv->__lock_threads);
						{
							_data_->_tmp8_ = _data_->self->priv->conversations;
							gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp8_);
							_data_->_tmp9_ = _data_->self->priv->_folders;
							gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp9_);
							_data_->_tmp10_ = _data_->self->priv->threads;
							gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp10_);
							_data_->_tmp11_ = _data_->self->priv->list_store;
							mail_conversation_list_store_remove_all (_data_->_tmp11_);
							_data_->_tmp12_ = _data_->self->priv->list_store;
							g_list_model_items_changed ((GListModel*) _data_->_tmp12_, (guint) 0, _data_->previous_items, (guint) 0);
							_data_->_tmp13_ = g_cancellable_new ();
							_g_object_unref0 (_data_->self->priv->cancellable);
							_data_->self->priv->cancellable = _data_->_tmp13_;
							{
								_data_->_tmp14_ = _data_->self->priv->_folder_info_per_account;
								g_rec_mutex_lock (&_data_->self->priv->__lock_folder_info_per_account);
								{
									{
										_data_->_tmp15_ = _data_->self->priv->_folder_info_per_account;
										_data_->_tmp16_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp15_);
										_data_->_folder_info_entry_it = _data_->_tmp16_;
										while (TRUE) {
											_data_->_data30_ = g_slice_new0 (Block30Data);
											_data_->_data30_->_ref_count_ = 1;
											_data_->_data30_->self = g_object_ref (_data_->self);
											_data_->_tmp17_ = _data_->_folder_info_entry_it;
											if (!gee_iterator_next (_data_->_tmp17_)) {
												block30_data_unref (_data_->_data30_);
												_data_->_data30_ = NULL;
												break;
											}
											_data_->_tmp18_ = _data_->_folder_info_entry_it;
											_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
											_data_->folder_info_entry = (GeeMapEntry*) _data_->_tmp19_;
											_data_->_tmp20_ = _data_->folder_info_entry;
											_data_->_tmp21_ = gee_map_entry_get_key (_data_->_tmp20_);
											_data_->_tmp22_ = _data_->_tmp21_;
											_data_->_tmp23_ = _g_object_ref0 ((MailBackendAccount*) _data_->_tmp22_);
											_data_->_data30_->current_account = _data_->_tmp23_;
											_data_->_tmp24_ = _data_->folder_info_entry;
											_data_->_tmp25_ = gee_map_entry_get_value (_data_->_tmp24_);
											_data_->_tmp26_ = _data_->_tmp25_;
											_data_->_tmp27_ = __vala_CamelFolderInfo_copy0 ((CamelFolderInfo*) _data_->_tmp26_);
											_data_->current_folder_info = _data_->_tmp27_;
											_data_->_tmp28_ = _data_->current_folder_info;
											if (_data_->_tmp28_ == NULL) {
												__vala_CamelFolderInfo_free0 (_data_->current_folder_info);
												_g_object_unref0 (_data_->folder_info_entry);
												block30_data_unref (_data_->_data30_);
												_data_->_data30_ = NULL;
												continue;
											}
											{
												_data_->_tmp29_ = _data_->_data30_->current_account;
												_data_->_tmp30_ = mail_backend_account_get_service (_data_->_tmp29_);
												_data_->_tmp31_ = _data_->_tmp30_;
												_data_->_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, camel_store_get_type (), CamelStore));
												_data_->camel_store = _data_->_tmp32_;
												_data_->_tmp33_ = _data_->camel_store;
												_data_->_tmp34_ = _data_->current_folder_info;
												_data_->_tmp35_ = _data_->_tmp34_->full_name;
												_data_->_tmp36_ = _data_->self->priv->cancellable;
												_data_->_state_ = 1;
												camel_store_get_folder (_data_->_tmp33_, _data_->_tmp35_, 0, G_PRIORITY_DEFAULT, _data_->_tmp36_, mail_conversation_list_load_folder_ready, _data_);
												return FALSE;
												_state_1:
												_data_->_tmp37_ = camel_store_get_folder_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error0_);
												_data_->folder = _data_->_tmp37_;
												if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
													_g_object_unref0 (_data_->camel_store);
													goto __catch5_g_error;
												}
												_data_->_tmp38_ = _data_->self->priv->_folders;
												_data_->_tmp39_ = _data_->_data30_->current_account;
												_data_->_tmp40_ = mail_backend_account_get_service (_data_->_tmp39_);
												_data_->_tmp41_ = _data_->_tmp40_;
												_data_->_tmp42_ = camel_service_get_uid (_data_->_tmp41_);
												_data_->_tmp43_ = _data_->_tmp42_;
												_data_->_tmp44_ = _data_->folder;
												gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp38_, _data_->_tmp43_, _data_->_tmp44_);
												_data_->_tmp45_ = _data_->_data30_->current_account;
												_data_->_tmp46_ = mail_backend_account_get_service (_data_->_tmp45_);
												_data_->_tmp47_ = _data_->_tmp46_;
												_data_->_tmp48_ = _data_->current_folder_info;
												_data_->info_flags = mail_utils_get_full_folder_info_flags (_data_->_tmp47_, _data_->_tmp48_);
												_data_->_tmp49_ = _data_->self->priv->_folder_info_flags;
												_data_->_tmp50_ = _data_->_data30_->current_account;
												_data_->_tmp51_ = mail_backend_account_get_service (_data_->_tmp50_);
												_data_->_tmp52_ = _data_->_tmp51_;
												_data_->_tmp53_ = camel_service_get_uid (_data_->_tmp52_);
												_data_->_tmp54_ = _data_->_tmp53_;
												gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp49_, _data_->_tmp54_, (gpointer) ((gintptr) _data_->info_flags));
												_data_->_tmp55_ = _data_->folder;
												g_signal_connect_data (_data_->_tmp55_, "changed", (GCallback) __________lambda39__camel_folder_changed, block30_data_ref (_data_->_data30_), (GClosureNotify) block30_data_unref, 0);
												_data_->_tmp56_ = _data_->_data30_->current_account;
												_data_->_tmp57_ = mail_backend_account_get_service (_data_->_tmp56_);
												_data_->_tmp58_ = _data_->_tmp57_;
												_data_->_tmp59_ = camel_service_get_uid (_data_->_tmp58_);
												_data_->_tmp60_ = _data_->_tmp59_;
												_data_->_tmp61_ = mail_conversation_list_get_search_result_uids (_data_->self, _data_->_tmp60_);
												_data_->search_result_uids = _data_->_tmp61_;
												_data_->_tmp62_ = _data_->search_result_uids;
												if (_data_->_tmp62_ != NULL) {
													_data_->_tmp63_ = _data_->folder;
													_data_->_tmp64_ = _data_->search_result_uids;
													_data_->_tmp65_ = camel_folder_thread_new (_data_->_tmp63_, (GPtrArray*) _data_->_tmp64_, CAMEL_FOLDER_THREAD_FLAG_NONE);
													_data_->thread = _data_->_tmp65_;
													_data_->_tmp66_ = _data_->self->priv->threads;
													_data_->_tmp67_ = _data_->_data30_->current_account;
													_data_->_tmp68_ = mail_backend_account_get_service (_data_->_tmp67_);
													_data_->_tmp69_ = _data_->_tmp68_;
													_data_->_tmp70_ = camel_service_get_uid (_data_->_tmp69_);
													_data_->_tmp71_ = _data_->_tmp70_;
													_data_->_tmp72_ = _data_->thread;
													gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp66_, _data_->_tmp71_, _data_->_tmp72_);
													_data_->_tmp73_ = _data_->thread;
													_data_->_tmp74_ = camel_folder_thread_get_tree (_data_->_tmp73_);
													_data_->child = _data_->_tmp74_;
													while (TRUE) {
														_data_->_tmp75_ = _data_->child;
														if (!(_data_->_tmp75_ != NULL)) {
															break;
														}
														_data_->_tmp76_ = _data_->self->priv->cancellable;
														if (g_cancellable_is_cancelled (_data_->_tmp76_)) {
															break;
														}
														_data_->_tmp77_ = _data_->self->priv->_folder_info_flags;
														_data_->_tmp78_ = _data_->_data30_->current_account;
														_data_->_tmp79_ = mail_backend_account_get_service (_data_->_tmp78_);
														_data_->_tmp80_ = _data_->_tmp79_;
														_data_->_tmp81_ = camel_service_get_uid (_data_->_tmp80_);
														_data_->_tmp82_ = _data_->_tmp81_;
														_data_->_tmp83_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp77_, _data_->_tmp82_);
														_data_->_tmp84_ = _data_->child;
														_data_->_tmp85_ = _data_->thread;
														_data_->_tmp86_ = _data_->_data30_->current_account;
														_data_->_tmp87_ = mail_backend_account_get_service (_data_->_tmp86_);
														_data_->_tmp88_ = _data_->_tmp87_;
														_data_->_tmp89_ = camel_service_get_uid (_data_->_tmp88_);
														_data_->_tmp90_ = _data_->_tmp89_;
														mail_conversation_list_add_conversation_item (_data_->self, (CamelFolderInfoFlags) ((gintptr) _data_->_tmp83_), _data_->_tmp84_, _data_->_tmp85_, _data_->_tmp90_);
														_data_->_tmp91_ = _data_->child;
														_data_->_tmp92_ = camel_folder_thread_node_get_next (_data_->_tmp91_);
														_data_->child = _data_->_tmp92_;
													}
													_g_object_unref0 (_data_->thread);
												}
												_g_ptr_array_unref0 (_data_->search_result_uids);
												_g_object_unref0 (_data_->folder);
												_g_object_unref0 (_data_->camel_store);
											}
											goto __finally5;
											__catch5_g_error:
											{
												_data_->e = _data_->_inner_error0_;
												_data_->_inner_error0_ = NULL;
												_data_->_tmp93_ = _data_->e;
												if (!g_error_matches (_data_->_tmp93_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
													_data_->_tmp94_ = _data_->e;
													_data_->_tmp95_ = _data_->_tmp94_->message;
													g_critical ("ConversationList.vala:288: %s", _data_->_tmp95_);
												}
												_g_error_free0 (_data_->e);
											}
											__finally5:
											if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
												__vala_CamelFolderInfo_free0 (_data_->current_folder_info);
												_g_object_unref0 (_data_->folder_info_entry);
												block30_data_unref (_data_->_data30_);
												_data_->_data30_ = NULL;
												_g_object_unref0 (_data_->_folder_info_entry_it);
												{
													_data_->_tmp96_ = _data_->self->priv->threads;
													g_rec_mutex_unlock (&_data_->self->priv->__lock_threads);
												}
												{
													_data_->_tmp97_ = _data_->self->priv->_folders;
													g_rec_mutex_unlock (&_data_->self->priv->__lock_folders);
												}
												{
													_data_->_tmp98_ = _data_->self->priv->conversations;
													g_rec_mutex_unlock (&_data_->self->priv->__lock_conversations);
												}
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
												g_clear_error (&_data_->_inner_error0_);
												g_object_unref (_data_->_async_result);
												return FALSE;
											}
											__vala_CamelFolderInfo_free0 (_data_->current_folder_info);
											_g_object_unref0 (_data_->folder_info_entry);
											block30_data_unref (_data_->_data30_);
											_data_->_data30_ = NULL;
										}
										_g_object_unref0 (_data_->_folder_info_entry_it);
									}
								}
								__finally4:
								{
									_data_->_tmp99_ = _data_->self->priv->_folder_info_per_account;
									g_rec_mutex_unlock (&_data_->self->priv->__lock_folder_info_per_account);
								}
								if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
									{
										_data_->_tmp100_ = _data_->self->priv->_folders;
										g_rec_mutex_unlock (&_data_->self->priv->__lock_folders);
									}
									{
										_data_->_tmp101_ = _data_->self->priv->conversations;
										g_rec_mutex_unlock (&_data_->self->priv->__lock_conversations);
									}
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
									g_clear_error (&_data_->_inner_error0_);
									g_object_unref (_data_->_async_result);
									return FALSE;
								}
							}
						}
						__finally3:
						{
							_data_->_tmp102_ = _data_->self->priv->threads;
							g_rec_mutex_unlock (&_data_->self->priv->__lock_threads);
						}
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							{
								_data_->_tmp103_ = _data_->self->priv->conversations;
								g_rec_mutex_unlock (&_data_->self->priv->__lock_conversations);
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
							g_clear_error (&_data_->_inner_error0_);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
				}
				__finally2:
				{
					_data_->_tmp104_ = _data_->self->priv->_folders;
					g_rec_mutex_unlock (&_data_->self->priv->__lock_folders);
				}
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
		__finally1:
		{
			_data_->_tmp105_ = _data_->self->priv->conversations;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_conversations);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp106_ = _data_->self->priv->list_store;
	_data_->_tmp107_ = _data_->self->priv->list_store;
	g_list_model_items_changed ((GListModel*) _data_->_tmp106_, (guint) 0, (guint) 0, virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _data_->_tmp107_));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_conversation_list_refresh_folder_data_free (gpointer _data)
{
	MailConversationListRefreshFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailConversationListRefreshFolderData, _data_);
}

void
mail_conversation_list_refresh_folder (MailConversationList* self,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	MailConversationListRefreshFolderData* _data_;
	MailConversationList* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailConversationListRefreshFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_conversation_list_refresh_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	mail_conversation_list_refresh_folder_co (_data_);
}

void
mail_conversation_list_refresh_folder_finish (MailConversationList* self,
                                              GAsyncResult* _res_)
{
	MailConversationListRefreshFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static void
mail_conversation_list_refresh_folder_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	MailConversationListRefreshFolderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_conversation_list_refresh_folder_co (_data_);
}

static gboolean
mail_conversation_list_refresh_folder_co (MailConversationListRefreshFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->refresh_stack;
	gtk_stack_set_visible_child_name (_data_->_tmp0_, "spinner");
	{
		_data_->_tmp1_ = _data_->self->priv->_folders;
		g_rec_mutex_lock (&_data_->self->priv->__lock_folders);
		{
			{
				_data_->_tmp2_ = _data_->self->priv->_folders;
				_data_->_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _data_->_tmp2_);
				_data_->_tmp4_ = _data_->_tmp3_;
				_data_->_tmp5_ = _data_->_tmp4_;
				_data_->_tmp6_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp5_);
				_data_->_tmp7_ = _data_->_tmp6_;
				_g_object_unref0 (_data_->_tmp5_);
				_data_->_folder_it = _data_->_tmp7_;
				while (TRUE) {
					_data_->_tmp8_ = _data_->_folder_it;
					if (!gee_iterator_next (_data_->_tmp8_)) {
						break;
					}
					_data_->_tmp9_ = _data_->_folder_it;
					_data_->_tmp10_ = gee_iterator_get (_data_->_tmp9_);
					_data_->folder = (CamelFolder*) _data_->_tmp10_;
					{
						_data_->_tmp11_ = _data_->folder;
						_data_->_state_ = 1;
						camel_folder_refresh_info (_data_->_tmp11_, G_PRIORITY_DEFAULT, _data_->cancellable, mail_conversation_list_refresh_folder_ready, _data_);
						return FALSE;
						_state_1:
						camel_folder_refresh_info_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_error:
					{
						_data_->e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp12_ = _data_->folder;
						_data_->_tmp13_ = camel_folder_get_display_name (_data_->_tmp12_);
						_data_->_tmp14_ = _data_->_tmp13_;
						_data_->_tmp15_ = _data_->folder;
						_data_->_tmp16_ = camel_folder_get_parent_store (_data_->_tmp15_);
						_data_->_tmp17_ = _data_->_tmp16_;
						_data_->_tmp18_ = camel_service_get_display_name ((CamelService*) _data_->_tmp17_);
						_data_->_tmp19_ = _data_->_tmp18_;
						_data_->_tmp20_ = _data_->e;
						_data_->_tmp21_ = _data_->_tmp20_->message;
						g_warning ("ConversationList.vala:307: Error fetching messages for '%s' from '%s':" \
" %s", _data_->_tmp14_, _data_->_tmp19_, _data_->_tmp21_);
						_g_error_free0 (_data_->e);
					}
					__finally1:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->folder);
						_g_object_unref0 (_data_->_folder_it);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_g_object_unref0 (_data_->folder);
				}
				_g_object_unref0 (_data_->_folder_it);
			}
		}
		__finally0:
		{
			_data_->_tmp22_ = _data_->self->priv->_folders;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_folders);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp23_ = _data_->self->priv->refresh_stack;
	gtk_stack_set_visible_child_name (_data_->_tmp23_, "button");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		MailConversationList* self;
		self = _data31_->self;
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
____lambda40_ (Block31Data* _data31_,
               const gchar* uid)
{
	MailConversationList* self;
	MailConversationItemModel* item = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	MailConversationItemModel* _tmp2_;
	self = _data31_->self;
	g_return_if_fail (uid != NULL);
	_tmp0_ = self->priv->conversations;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, uid);
	item = (MailConversationItemModel*) _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		GeeHashMap* _tmp3_;
		MailConversationListStore* _tmp4_;
		MailConversationItemModel* _tmp5_;
		gint _tmp6_;
		_tmp3_ = self->priv->conversations;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, uid, NULL);
		_tmp4_ = self->priv->list_store;
		_tmp5_ = item;
		mail_conversation_list_store_remove (_tmp4_, _tmp5_);
		_tmp6_ = _data31_->removed;
		_data31_->removed = _tmp6_ + 1;
	}
	_g_object_unref0 (item);
}

static void
_____lambda40__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda40_ (self, (const gchar*) data);
}

static void
mail_conversation_list_folder_changed (MailConversationList* self,
                                       CamelFolderChangeInfo* change_info,
                                       const gchar* service_uid,
                                       GCancellable* cancellable)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (change_info != NULL);
	g_return_if_fail (service_uid != NULL);
	g_return_if_fail (cancellable != NULL);
	if (g_cancellable_is_cancelled (cancellable)) {
		return;
	}
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->conversations;
		g_rec_mutex_lock (&self->priv->__lock_conversations);
		{
			{
				GeeHashMap* _tmp1_;
				_tmp1_ = self->priv->threads;
				g_rec_mutex_lock (&self->priv->__lock_threads);
				{
					Block31Data* _data31_;
					GPtrArray* search_result_uids = NULL;
					GPtrArray* _tmp2_;
					GPtrArray* _tmp3_;
					GeeHashMap* _tmp6_;
					GeeHashMap* _tmp7_;
					gpointer _tmp8_;
					CamelFolder* _tmp9_;
					GPtrArray* _tmp10_;
					CamelFolderThread* _tmp11_;
					CamelFolderThread* _tmp12_;
					GPtrArray* _tmp13_;
					CamelFolderThreadNode* child = NULL;
					GeeHashMap* _tmp14_;
					gpointer _tmp15_;
					CamelFolderThread* _tmp16_;
					CamelFolderThreadNode* _tmp17_;
					CamelFolderThreadNode* _tmp18_;
					MailConversationListStore* _tmp53_;
					MailConversationListStore* _tmp54_;
					_data31_ = g_slice_new0 (Block31Data);
					_data31_->_ref_count_ = 1;
					_data31_->self = g_object_ref (self);
					_tmp2_ = mail_conversation_list_get_search_result_uids (self, service_uid);
					search_result_uids = _tmp2_;
					_tmp3_ = search_result_uids;
					if (_tmp3_ == NULL) {
						_g_ptr_array_unref0 (search_result_uids);
						block31_data_unref (_data31_);
						_data31_ = NULL;
						{
							GeeHashMap* _tmp4_;
							_tmp4_ = self->priv->threads;
							g_rec_mutex_unlock (&self->priv->__lock_threads);
						}
						{
							GeeHashMap* _tmp5_;
							_tmp5_ = self->priv->conversations;
							g_rec_mutex_unlock (&self->priv->__lock_conversations);
						}
						return;
					}
					_tmp6_ = self->priv->threads;
					_tmp7_ = self->priv->_folders;
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, service_uid);
					_tmp9_ = (CamelFolder*) _tmp8_;
					_tmp10_ = search_result_uids;
					_tmp11_ = camel_folder_thread_new (_tmp9_, (GPtrArray*) _tmp10_, CAMEL_FOLDER_THREAD_FLAG_NONE);
					_tmp12_ = _tmp11_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, service_uid, _tmp12_);
					_g_object_unref0 (_tmp12_);
					_g_object_unref0 (_tmp9_);
					_data31_->removed = 0;
					_tmp13_ = camel_folder_change_info_get_removed_uids (change_info);
					g_ptr_array_foreach (_tmp13_, _____lambda40__gfunc, _data31_);
					_tmp14_ = self->priv->threads;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, service_uid);
					_tmp16_ = (CamelFolderThread*) _tmp15_;
					_tmp17_ = camel_folder_thread_get_tree (_tmp16_);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp16_);
					child = _tmp18_;
					while (TRUE) {
						CamelFolderThreadNode* _tmp19_;
						MailConversationItemModel* item = NULL;
						GeeHashMap* _tmp22_;
						CamelFolderThreadNode* _tmp23_;
						void* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						gpointer _tmp27_;
						MailConversationItemModel* _tmp28_;
						CamelFolderThreadNode* _tmp51_;
						CamelFolderThreadNode* _tmp52_;
						_tmp19_ = child;
						if (!(_tmp19_ != NULL)) {
							break;
						}
						if (g_cancellable_is_cancelled (cancellable)) {
							_g_ptr_array_unref0 (search_result_uids);
							block31_data_unref (_data31_);
							_data31_ = NULL;
							{
								GeeHashMap* _tmp20_;
								_tmp20_ = self->priv->threads;
								g_rec_mutex_unlock (&self->priv->__lock_threads);
							}
							{
								GeeHashMap* _tmp21_;
								_tmp21_ = self->priv->conversations;
								g_rec_mutex_unlock (&self->priv->__lock_conversations);
							}
							return;
						}
						_tmp22_ = self->priv->conversations;
						_tmp23_ = child;
						_tmp24_ = camel_folder_thread_node_get_item (_tmp23_);
						_tmp25_ = camel_message_info_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, camel_message_info_get_type (), CamelMessageInfo));
						_tmp26_ = _tmp25_;
						_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp22_, _tmp26_);
						item = (MailConversationItemModel*) _tmp27_;
						_tmp28_ = item;
						if (_tmp28_ == NULL) {
							GeeHashMap* _tmp29_;
							gpointer _tmp30_;
							CamelFolderThreadNode* _tmp31_;
							GeeHashMap* _tmp32_;
							gpointer _tmp33_;
							CamelFolderThread* _tmp34_;
							_tmp29_ = self->priv->_folder_info_flags;
							_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, service_uid);
							_tmp31_ = child;
							_tmp32_ = self->priv->threads;
							_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, service_uid);
							_tmp34_ = (CamelFolderThread*) _tmp33_;
							mail_conversation_list_add_conversation_item (self, (CamelFolderInfoFlags) ((gintptr) _tmp30_), _tmp31_, _tmp34_, service_uid);
							_g_object_unref0 (_tmp34_);
						} else {
							MailConversationItemModel* _tmp35_;
							CamelFolderThreadNode* _tmp36_;
							_tmp35_ = item;
							_tmp36_ = child;
							if (mail_conversation_item_model_is_older_than (_tmp35_, _tmp36_)) {
								GeeHashMap* _tmp37_;
								CamelFolderThreadNode* _tmp38_;
								void* _tmp39_;
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								MailConversationListStore* _tmp42_;
								MailConversationItemModel* _tmp43_;
								gint _tmp44_;
								GeeHashMap* _tmp45_;
								gpointer _tmp46_;
								CamelFolderThreadNode* _tmp47_;
								GeeHashMap* _tmp48_;
								gpointer _tmp49_;
								CamelFolderThread* _tmp50_;
								_tmp37_ = self->priv->conversations;
								_tmp38_ = child;
								_tmp39_ = camel_folder_thread_node_get_item (_tmp38_);
								_tmp40_ = camel_message_info_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, camel_message_info_get_type (), CamelMessageInfo));
								_tmp41_ = _tmp40_;
								gee_abstract_map_unset ((GeeAbstractMap*) _tmp37_, _tmp41_, NULL);
								_tmp42_ = self->priv->list_store;
								_tmp43_ = item;
								mail_conversation_list_store_remove (_tmp42_, _tmp43_);
								_tmp44_ = _data31_->removed;
								_data31_->removed = _tmp44_ + 1;
								_tmp45_ = self->priv->_folder_info_flags;
								_tmp46_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp45_, service_uid);
								_tmp47_ = child;
								_tmp48_ = self->priv->threads;
								_tmp49_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp48_, service_uid);
								_tmp50_ = (CamelFolderThread*) _tmp49_;
								mail_conversation_list_add_conversation_item (self, (CamelFolderInfoFlags) ((gintptr) _tmp46_), _tmp47_, _tmp50_, service_uid);
								_g_object_unref0 (_tmp50_);
							}
						}
						_tmp51_ = child;
						_tmp52_ = camel_folder_thread_node_get_next (_tmp51_);
						child = _tmp52_;
						_g_object_unref0 (item);
					}
					_tmp53_ = self->priv->list_store;
					_tmp54_ = self->priv->list_store;
					g_list_model_items_changed ((GListModel*) _tmp53_, (guint) 0, (guint) _data31_->removed, virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _tmp54_));
					_g_ptr_array_unref0 (search_result_uids);
					block31_data_unref (_data31_);
					_data31_ = NULL;
				}
				__finally1:
				{
					GeeHashMap* _tmp55_;
					_tmp55_ = self->priv->threads;
					g_rec_mutex_unlock (&self->priv->__lock_threads);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp56_;
			_tmp56_ = self->priv->conversations;
			g_rec_mutex_unlock (&self->priv->__lock_conversations);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static GPtrArray*
mail_conversation_list_get_search_result_uids (MailConversationList* self,
                                               const gchar* service_uid)
{
	GtkStyleContext* style_context = NULL;
	GtkMenuButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GraniteSwitchModelButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (service_uid != NULL, NULL);
	_tmp0_ = self->priv->filter_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	style_context = _tmp2_;
	_tmp4_ = self->priv->hide_read_switch;
	_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		GraniteSwitchModelButton* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->hide_unstarred_switch;
		_tmp8_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_;
	}
	if (_tmp3_) {
		GtkStyleContext* _tmp10_;
		_tmp10_ = style_context;
		if (!gtk_style_context_has_class (_tmp10_, GRANITE_STYLE_CLASS_ACCENT)) {
			GtkStyleContext* _tmp11_;
			_tmp11_ = style_context;
			gtk_style_context_add_class (_tmp11_, GRANITE_STYLE_CLASS_ACCENT);
		}
	} else {
		GtkStyleContext* _tmp12_;
		_tmp12_ = style_context;
		if (gtk_style_context_has_class (_tmp12_, GRANITE_STYLE_CLASS_ACCENT)) {
			GtkStyleContext* _tmp13_;
			_tmp13_ = style_context;
			gtk_style_context_remove_class (_tmp13_, GRANITE_STYLE_CLASS_ACCENT);
		}
	}
	{
		GeeHashMap* _tmp14_;
		_tmp14_ = self->priv->_folders;
		g_rec_mutex_lock (&self->priv->__lock_folders);
		{
			GeeHashMap* _tmp15_;
			gpointer _tmp16_;
			CamelFolder* _tmp17_;
			gboolean _tmp18_;
			gboolean has_current_search_query = FALSE;
			GtkSearchEntry* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gchar** current_search_expressions = NULL;
			gchar** _tmp40_;
			gint current_search_expressions_length1;
			gint _current_search_expressions_size_;
			GraniteSwitchModelButton* _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			GraniteSwitchModelButton* _tmp45_;
			gboolean _tmp46_;
			gboolean _tmp47_;
			gchar* search_query = NULL;
			gchar** _tmp61_;
			gint _tmp61__length1;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp15_ = self->priv->_folders;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, service_uid);
			_tmp17_ = (CamelFolder*) _tmp16_;
			_tmp18_ = _tmp17_ == NULL;
			_g_object_unref0 (_tmp17_);
			if (_tmp18_) {
				result = NULL;
				{
					GeeHashMap* _tmp19_;
					_tmp19_ = self->priv->_folders;
					g_rec_mutex_unlock (&self->priv->__lock_folders);
				}
				_g_object_unref0 (style_context);
				return result;
			}
			_tmp20_ = self->priv->search_entry;
			_tmp21_ = gtk_entry_get_text ((GtkEntry*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_strip (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strcmp0 (_tmp24_, "") != 0;
			_g_free0 (_tmp24_);
			has_current_search_query = _tmp25_;
			if (!has_current_search_query) {
				GraniteSwitchModelButton* _tmp28_;
				gboolean _tmp29_;
				gboolean _tmp30_;
				_tmp28_ = self->priv->hide_read_switch;
				_tmp29_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp27_ = !_tmp30_;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GraniteSwitchModelButton* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = self->priv->hide_unstarred_switch;
				_tmp32_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp26_ = !_tmp33_;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				GeeHashMap* _tmp34_;
				gpointer _tmp35_;
				CamelFolder* _tmp36_;
				GPtrArray* _tmp37_;
				GPtrArray* _tmp38_;
				_tmp34_ = self->priv->_folders;
				_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, service_uid);
				_tmp36_ = (CamelFolder*) _tmp35_;
				_tmp37_ = camel_folder_dup_uids (_tmp36_);
				_tmp38_ = _tmp37_;
				_g_object_unref0 (_tmp36_);
				result = _tmp38_;
				{
					GeeHashMap* _tmp39_;
					_tmp39_ = self->priv->_folders;
					g_rec_mutex_unlock (&self->priv->__lock_folders);
				}
				_g_object_unref0 (style_context);
				return result;
			}
			_tmp40_ = g_new0 (gchar*, 0 + 1);
			current_search_expressions = _tmp40_;
			current_search_expressions_length1 = 0;
			_current_search_expressions_size_ = current_search_expressions_length1;
			_tmp41_ = self->priv->hide_read_switch;
			_tmp42_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp41_);
			_tmp43_ = _tmp42_;
			if (_tmp43_) {
				gchar* _tmp44_;
				_tmp44_ = g_strdup ("(not (system-flag \"Seen\"))");
				_vala_array_add3 (&current_search_expressions, &current_search_expressions_length1, &_current_search_expressions_size_, _tmp44_);
			}
			_tmp45_ = self->priv->hide_unstarred_switch;
			_tmp46_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_) {
				gchar* _tmp48_;
				_tmp48_ = g_strdup ("(system-flag \"Flagged\")");
				_vala_array_add4 (&current_search_expressions, &current_search_expressions_length1, &_current_search_expressions_size_, _tmp48_);
			}
			if (has_current_search_query) {
				GString* sb = NULL;
				GString* _tmp49_;
				GString* _tmp50_;
				GtkSearchEntry* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				gchar* encoded_query = NULL;
				GString* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp49_ = g_string_new ("");
				sb = _tmp49_;
				_tmp50_ = sb;
				_tmp51_ = self->priv->search_entry;
				_tmp52_ = gtk_entry_get_text ((GtkEntry*) _tmp51_);
				_tmp53_ = _tmp52_;
				camel_sexp_encode_string (_tmp50_, _tmp53_);
				_tmp54_ = sb;
				_tmp55_ = _tmp54_->str;
				_tmp56_ = g_strdup (_tmp55_);
				encoded_query = _tmp56_;
				_tmp57_ = encoded_query;
				_tmp58_ = encoded_query;
				_tmp59_ = encoded_query;
				_tmp60_ = g_strdup_printf ("(or (header-contains \"From\" %s)(header-contains \"Subject\" %s)(body" \
"-contains %s))", _tmp57_, _tmp58_, _tmp59_);
				_vala_array_add5 (&current_search_expressions, &current_search_expressions_length1, &_current_search_expressions_size_, _tmp60_);
				_g_free0 (encoded_query);
				_g_string_free0 (sb);
			}
			_tmp61_ = current_search_expressions;
			_tmp61__length1 = current_search_expressions_length1;
			_tmp62_ = _vala_g_strjoinv ("", _tmp61_, (gint) _tmp61__length1);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat ("(match-all (and ", _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat (_tmp65_, "))", NULL);
			_tmp67_ = _tmp66_;
			_g_free0 (_tmp65_);
			_g_free0 (_tmp63_);
			search_query = _tmp67_;
			{
				GPtrArray* uids = NULL;
				GeeHashMap* _tmp68_;
				gpointer _tmp69_;
				CamelFolder* _tmp70_;
				const gchar* _tmp71_;
				GCancellable* _tmp72_;
				GPtrArray* _tmp73_ = NULL;
				uids = NULL;
				_tmp68_ = self->priv->_folders;
				_tmp69_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp68_, service_uid);
				_tmp70_ = (CamelFolder*) _tmp69_;
				_tmp71_ = search_query;
				_tmp72_ = self->priv->cancellable;
				camel_folder_search_sync (_tmp70_, _tmp71_, &_tmp73_, _tmp72_, &_inner_error0_);
				_g_ptr_array_unref0 (uids);
				uids = _tmp73_;
				_g_object_unref0 (_tmp70_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_ptr_array_unref0 (uids);
					goto __catch1_g_error;
				}
				result = uids;
				_g_free0 (search_query);
				current_search_expressions = (_vala_array_free (current_search_expressions, current_search_expressions_length1, (GDestroyNotify) g_free), NULL);
				{
					GeeHashMap* _tmp74_;
					_tmp74_ = self->priv->_folders;
					g_rec_mutex_unlock (&self->priv->__lock_folders);
				}
				_g_object_unref0 (style_context);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp75_;
				GeeHashMap* _tmp78_;
				gpointer _tmp79_;
				CamelFolder* _tmp80_;
				GPtrArray* _tmp81_;
				GPtrArray* _tmp82_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp75_ = e;
				if (!g_error_matches (_tmp75_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					GError* _tmp76_;
					const gchar* _tmp77_;
					_tmp76_ = e;
					_tmp77_ = _tmp76_->message;
					g_warning ("ConversationList.vala:414: Error while searching: %s", _tmp77_);
				}
				_tmp78_ = self->priv->_folders;
				_tmp79_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp78_, service_uid);
				_tmp80_ = (CamelFolder*) _tmp79_;
				_tmp81_ = camel_folder_dup_uids (_tmp80_);
				_tmp82_ = _tmp81_;
				_g_object_unref0 (_tmp80_);
				result = _tmp82_;
				_g_error_free0 (e);
				_g_free0 (search_query);
				current_search_expressions = (_vala_array_free (current_search_expressions, current_search_expressions_length1, (GDestroyNotify) g_free), NULL);
				{
					GeeHashMap* _tmp83_;
					_tmp83_ = self->priv->_folders;
					g_rec_mutex_unlock (&self->priv->__lock_folders);
				}
				_g_object_unref0 (style_context);
				return result;
			}
			__finally1:
			_g_free0 (search_query);
			current_search_expressions = (_vala_array_free (current_search_expressions, current_search_expressions_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (style_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		__finally0:
		{
			GeeHashMap* _tmp84_;
			_tmp84_ = self->priv->_folders;
			g_rec_mutex_unlock (&self->priv->__lock_folders);
		}
		_g_object_unref0 (style_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
mail_conversation_list_add_conversation_item (MailConversationList* self,
                                              CamelFolderInfoFlags folder_info_flags,
                                              CamelFolderThreadNode* child,
                                              CamelFolderThread* thread,
                                              const gchar* service_uid)
{
	MailConversationItemModel* item = NULL;
	MailConversationItemModel* _tmp0_;
	GeeHashMap* _tmp1_;
	void* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	MailConversationListStore* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	g_return_if_fail (thread != NULL);
	g_return_if_fail (service_uid != NULL);
	_tmp0_ = mail_conversation_item_model_new (folder_info_flags, child, thread, service_uid);
	item = _tmp0_;
	_tmp1_ = self->priv->conversations;
	_tmp2_ = camel_folder_thread_node_get_item (child);
	_tmp3_ = camel_message_info_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, camel_message_info_get_type (), CamelMessageInfo));
	_tmp4_ = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp4_, item);
	_tmp5_ = self->priv->list_store;
	mail_conversation_list_store_add (_tmp5_, item);
	_g_object_unref0 (item);
}

static gboolean
mail_conversation_list_filter_function (GObject* obj)
{
	gboolean result;
	g_return_val_if_fail (obj != NULL, FALSE);
	if (MAIL_IS_CONVERSATION_ITEM_MODEL (obj)) {
		MailConversationItemModel* conversation_item = NULL;
		MailConversationItemModel* _tmp0_;
		gboolean _tmp1_ = FALSE;
		MailConversationItemModel* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		conversation_item = _tmp0_;
		_tmp2_ = conversation_item;
		_tmp3_ = mail_conversation_item_model_get_deleted (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			MailConversationItemModel* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = conversation_item;
			_tmp6_ = mail_conversation_item_model_get_hidden (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = !_tmp7_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		_g_object_unref0 (conversation_item);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gint
mail_conversation_list_thread_sort_function (MailConversationItemModel* item1,
                                             MailConversationItemModel* item2)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint result;
	g_return_val_if_fail (item1 != NULL, 0);
	g_return_val_if_fail (item2 != NULL, 0);
	_tmp0_ = mail_conversation_item_model_get_timestamp (item2);
	_tmp1_ = _tmp0_;
	_tmp2_ = mail_conversation_item_model_get_timestamp (item1);
	_tmp3_ = _tmp2_;
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}

void
mail_conversation_list_mark_read_selected_messages (MailConversationList* self)
{
	GeeHashSet* selected_rows = NULL;
	VirtualizingListBox* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = virtualizing_list_box_get_selected_rows (_tmp0_);
	selected_rows = _tmp1_;
	{
		GeeIterator* _row_it = NULL;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = selected_rows;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_row_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GObject* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GObject* _tmp7_;
			CamelFolderThreadNode* _tmp8_;
			CamelFolderThreadNode* _tmp9_;
			void* _tmp10_;
			_tmp4_ = _row_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _row_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			row = (GObject*) _tmp6_;
			_tmp7_ = row;
			_tmp8_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
			_tmp9_ = _tmp8_;
			_tmp10_ = camel_folder_thread_node_get_item (_tmp9_);
			camel_message_info_set_flags (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, camel_message_info_get_type (), CamelMessageInfo), (guint32) CAMEL_MESSAGE_SEEN, (guint32) (~0));
		}
		_g_object_unref0 (_row_it);
	}
	_g_object_unref0 (selected_rows);
}

void
mail_conversation_list_mark_star_selected_messages (MailConversationList* self)
{
	GeeHashSet* selected_rows = NULL;
	VirtualizingListBox* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = virtualizing_list_box_get_selected_rows (_tmp0_);
	selected_rows = _tmp1_;
	{
		GeeIterator* _row_it = NULL;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = selected_rows;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_row_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GObject* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GObject* _tmp7_;
			CamelFolderThreadNode* _tmp8_;
			CamelFolderThreadNode* _tmp9_;
			void* _tmp10_;
			_tmp4_ = _row_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _row_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			row = (GObject*) _tmp6_;
			_tmp7_ = row;
			_tmp8_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
			_tmp9_ = _tmp8_;
			_tmp10_ = camel_folder_thread_node_get_item (_tmp9_);
			camel_message_info_set_flags (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, camel_message_info_get_type (), CamelMessageInfo), (guint32) CAMEL_MESSAGE_FLAGGED, (guint32) (~0));
		}
		_g_object_unref0 (_row_it);
	}
	_g_object_unref0 (selected_rows);
}

void
mail_conversation_list_mark_unread_selected_messages (MailConversationList* self)
{
	GeeHashSet* selected_rows = NULL;
	VirtualizingListBox* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = virtualizing_list_box_get_selected_rows (_tmp0_);
	selected_rows = _tmp1_;
	{
		GeeIterator* _row_it = NULL;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = selected_rows;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_row_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GObject* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GObject* _tmp7_;
			CamelFolderThreadNode* _tmp8_;
			CamelFolderThreadNode* _tmp9_;
			void* _tmp10_;
			_tmp4_ = _row_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _row_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			row = (GObject*) _tmp6_;
			_tmp7_ = row;
			_tmp8_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
			_tmp9_ = _tmp8_;
			_tmp10_ = camel_folder_thread_node_get_item (_tmp9_);
			camel_message_info_set_flags (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, camel_message_info_get_type (), CamelMessageInfo), (guint32) CAMEL_MESSAGE_SEEN, (guint32) 0);
		}
		_g_object_unref0 (_row_it);
	}
	_g_object_unref0 (selected_rows);
}

void
mail_conversation_list_mark_unstar_selected_messages (MailConversationList* self)
{
	GeeHashSet* selected_rows = NULL;
	VirtualizingListBox* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_box;
	_tmp1_ = virtualizing_list_box_get_selected_rows (_tmp0_);
	selected_rows = _tmp1_;
	{
		GeeIterator* _row_it = NULL;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = selected_rows;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_row_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GObject* row = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GObject* _tmp7_;
			CamelFolderThreadNode* _tmp8_;
			CamelFolderThreadNode* _tmp9_;
			void* _tmp10_;
			_tmp4_ = _row_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _row_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			row = (GObject*) _tmp6_;
			_tmp7_ = row;
			_tmp8_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
			_tmp9_ = _tmp8_;
			_tmp10_ = camel_folder_thread_node_get_item (_tmp9_);
			camel_message_info_set_flags (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, camel_message_info_get_type (), CamelMessageInfo), (guint32) CAMEL_MESSAGE_FLAGGED, (guint32) 0);
		}
		_g_object_unref0 (_row_it);
	}
	_g_object_unref0 (selected_rows);
}

static void
mail_conversation_list_move_selected_messages_data_free (gpointer _data)
{
	MailConversationListMoveSelectedMessagesData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->dst_folder_full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailConversationListMoveSelectedMessagesData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
mail_conversation_list_move_selected_messages (MailConversationList* self,
                                               MailMoveOperationMoveType move_type,
                                               GVariant* dst_folder_full_name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	MailConversationListMoveSelectedMessagesData* _data_;
	MailConversationList* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailConversationListMoveSelectedMessagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_conversation_list_move_selected_messages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->move_type = move_type;
	_tmp1_ = _g_variant_ref0 (dst_folder_full_name);
	_g_variant_unref0 (_data_->dst_folder_full_name);
	_data_->dst_folder_full_name = _tmp1_;
	mail_conversation_list_move_selected_messages_co (_data_);
}

guint
mail_conversation_list_move_selected_messages_finish (MailConversationList* self,
                                                      GAsyncResult* _res_,
                                                      gchar** error_message)
{
	guint result;
	MailConversationListMoveSelectedMessagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (error_message) {
		*error_message = _data_->error_message;
	} else {
		_g_free0 (_data_->error_message);
	}
	_data_->error_message = NULL;
	result = _data_->result;
	return result;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		MailConversationList* self;
		self = _data32_->self;
		_data32_->moved_conversation_items = (_vala_array_free (_data32_->moved_conversation_items, _data32_->moved_conversation_items_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
_vala_array_add6 (MailConversationItemModel** * array,
                  gint* length,
                  gint* size,
                  MailConversationItemModel* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (MailConversationItemModel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
mail_conversation_list_move_selected_messages_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	MailConversationListMoveSelectedMessagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_conversation_list_move_selected_messages_co (_data_);
}

static void
_____lambda43_ (Block32Data* _data32_)
{
	MailConversationList* self;
	MailConversationItemModel** _tmp0_;
	gint _tmp0__length1;
	self = _data32_->self;
	_tmp0_ = _data32_->moved_conversation_items;
	_tmp0__length1 = _data32_->moved_conversation_items_length1;
	mail_conversation_list_unhide_conversations (self, _tmp0_, (gint) _tmp0__length1);
}

static void
______lambda43__mail_move_operation_undone (MailMoveOperation* _sender,
                                            gpointer self)
{
	_____lambda43_ (self);
}

static gboolean
mail_conversation_list_move_selected_messages_co (MailConversationListMoveSelectedMessagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data32_ = g_slice_new0 (Block32Data);
	_data_->_data32_->_ref_count_ = 1;
	_data_->_data32_->self = g_object_ref (_data_->self);
	_data_->_data32_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup ("");
	_g_free0 (_data_->error_message);
	_data_->error_message = _data_->_tmp0_;
	_data_->_tmp1_ = g_new0 (MailConversationItemModel*, 0 + 1);
	_data_->_data32_->moved_conversation_items = _data_->_tmp1_;
	_data_->_data32_->moved_conversation_items_length1 = 0;
	_data_->_data32_->_moved_conversation_items_size_ = _data_->_data32_->moved_conversation_items_length1;
	_data_->_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->move_threads = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->list_box;
	_data_->_tmp4_ = virtualizing_list_box_get_selected_rows (_data_->_tmp3_);
	_data_->selected_rows = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->list_store;
	_data_->_tmp6_ = _data_->selected_rows;
	_data_->_tmp7_ = 0;
	_data_->_tmp8_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp6_, &_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp9__length1 = _data_->_tmp7_;
	_data_->_tmp10_ = _data_->_tmp9_[0];
	_data_->_tmp11_ = virtualizing_list_box_model_get_index_of ((VirtualizingListBoxModel*) _data_->_tmp5_, _data_->_tmp10_);
	_data_->_tmp9_ = (g_free (_data_->_tmp9_), NULL);
	_data_->selected_rows_start_index = _data_->_tmp11_;
	{
		_data_->_tmp12_ = _data_->selected_rows;
		_data_->_tmp13_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp12_);
		_data_->_selected_row_it = _data_->_tmp13_;
		while (TRUE) {
			_data_->_tmp14_ = _data_->_selected_row_it;
			if (!gee_iterator_next (_data_->_tmp14_)) {
				break;
			}
			_data_->_tmp15_ = _data_->_selected_row_it;
			_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
			_data_->selected_row = (GObject*) _data_->_tmp16_;
			_data_->_tmp17_ = _data_->selected_row;
			_data_->_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
			_data_->selected_item_model = _data_->_tmp18_;
			_data_->_tmp19_ = _data_->selected_item_model;
			mail_conversation_item_model_set_hidden (_data_->_tmp19_, TRUE);
			_data_->_tmp20_ = _data_->selected_item_model;
			_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
			_vala_array_add6 (&_data_->_data32_->moved_conversation_items, &_data_->_data32_->moved_conversation_items_length1, &_data_->_data32_->_moved_conversation_items_size_, _data_->_tmp21_);
			_data_->_tmp22_ = _data_->move_threads;
			_data_->_tmp23_ = _data_->selected_item_model;
			_data_->_tmp24_ = mail_conversation_item_model_get_service_uid (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp22_, _data_->_tmp25_);
			_data_->_tmp27_ = (GeeArrayList*) _data_->_tmp26_;
			_data_->_tmp28_ = _data_->_tmp27_ == NULL;
			_g_object_unref0 (_data_->_tmp27_);
			if (_data_->_tmp28_) {
				_data_->_tmp29_ = _data_->move_threads;
				_data_->_tmp30_ = _data_->selected_item_model;
				_data_->_tmp31_ = mail_conversation_item_model_get_service_uid (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				_data_->_tmp33_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
				_data_->_tmp34_ = _data_->_tmp33_;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp29_, _data_->_tmp32_, _data_->_tmp34_);
				_g_object_unref0 (_data_->_tmp34_);
			}
			_data_->_tmp35_ = _data_->move_threads;
			_data_->_tmp36_ = _data_->selected_item_model;
			_data_->_tmp37_ = mail_conversation_item_model_get_service_uid (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp35_, _data_->_tmp38_);
			_data_->_tmp40_ = (GeeArrayList*) _data_->_tmp39_;
			_data_->_tmp41_ = _data_->selected_item_model;
			_data_->_tmp42_ = mail_conversation_item_model_get_node (_data_->_tmp41_);
			_data_->_tmp43_ = _data_->_tmp42_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp40_, _data_->_tmp43_);
			_g_object_unref0 (_data_->_tmp40_);
			_g_object_unref0 (_data_->selected_item_model);
		}
		_g_object_unref0 (_data_->_selected_row_it);
	}
	_data_->_tmp44_ = _data_->self->priv->list_store;
	_data_->_tmp45_ = _data_->self->priv->list_store;
	_data_->_tmp46_ = _data_->self->priv->list_store;
	g_list_model_items_changed ((GListModel*) _data_->_tmp44_, (guint) 0, virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _data_->_tmp45_), virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _data_->_tmp46_));
	_data_->_tmp47_ = _data_->self->priv->list_box;
	virtualizing_list_box_select_row_at_index (_data_->_tmp47_, _data_->selected_rows_start_index + 1);
	_data_->moved = (guint) 0;
	{
		_data_->_tmp48_ = _data_->move_threads;
		_data_->_tmp49_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp51_ = _data_->_tmp50_;
		_data_->_tmp52_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		_g_object_unref0 (_data_->_tmp51_);
		_data_->_service_uid_it = _data_->_tmp53_;
		while (TRUE) {
			_data_->_tmp54_ = _data_->_service_uid_it;
			if (!gee_iterator_next (_data_->_tmp54_)) {
				break;
			}
			_data_->_tmp55_ = _data_->_service_uid_it;
			_data_->_tmp56_ = gee_iterator_get (_data_->_tmp55_);
			_data_->service_uid = (gchar*) _data_->_tmp56_;
			{
				_data_->_tmp57_ = _data_->self->priv->_folders;
				_data_->_tmp58_ = _data_->service_uid;
				_data_->_tmp59_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp57_, _data_->_tmp58_);
				_data_->_tmp60_ = (CamelFolder*) _data_->_tmp59_;
				_data_->_tmp61_ = _data_->move_threads;
				_data_->_tmp62_ = _data_->service_uid;
				_data_->_tmp63_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp61_, _data_->_tmp62_);
				_data_->_tmp64_ = (GeeArrayList*) _data_->_tmp63_;
				_data_->_state_ = 1;
				mail_move_operation_new (_data_->_tmp60_, _data_->move_type, _data_->_tmp64_, _data_->dst_folder_full_name, mail_conversation_list_move_selected_messages_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp65_ = mail_move_operation_new_finish (_data_->_res_, &_data_->n_messages_moved, &_data_->_inner_error0_);
				_data_->_tmp66_ = _data_->_tmp65_;
				_g_object_unref0 (_data_->_tmp64_);
				_g_object_unref0 (_data_->_tmp60_);
				_data_->move_operation = _data_->_tmp66_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp67_ = _data_->move_operation;
				g_signal_connect_data (_data_->_tmp67_, "undone", (GCallback) ______lambda43__mail_move_operation_undone, block32_data_ref (_data_->_data32_), (GClosureNotify) block32_data_unref, 0);
				_data_->moved += _data_->n_messages_moved;
				_g_object_unref0 (_data_->move_operation);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp68_ = _data_->e;
				_data_->_tmp69_ = _data_->_tmp68_->message;
				g_warning ("ConversationList.vala:501: Failed to prepare move operation: %s", _data_->_tmp69_);
				_data_->_tmp70_ = _data_->e;
				_data_->_tmp71_ = _data_->_tmp70_->message;
				_data_->_tmp72_ = g_strdup (_data_->_tmp71_);
				_g_free0 (_data_->error_message);
				_data_->error_message = _data_->_tmp72_;
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->service_uid);
				_g_object_unref0 (_data_->_service_uid_it);
				_g_object_unref0 (_data_->selected_rows);
				_g_object_unref0 (_data_->move_threads);
				block32_data_unref (_data_->_data32_);
				_data_->_data32_ = NULL;
				_g_free0 (_data_->error_message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->service_uid);
		}
		_g_object_unref0 (_data_->_service_uid_it);
	}
	_data_->_tmp73_ = _data_->error_message;
	if (g_strcmp0 (_data_->_tmp73_, "") != 0) {
		_data_->_tmp74_ = _data_->_data32_->moved_conversation_items;
		_data_->_tmp74__length1 = _data_->_data32_->moved_conversation_items_length1;
		mail_conversation_list_unhide_conversations (_data_->self, _data_->_tmp74_, (gint) _data_->_tmp74__length1);
	}
	_data_->result = _data_->moved;
	_g_object_unref0 (_data_->selected_rows);
	_g_object_unref0 (_data_->move_threads);
	block32_data_unref (_data_->_data32_);
	_data_->_data32_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_conversation_list_unhide_conversations (MailConversationList* self,
                                             MailConversationItemModel** moved_conversation_items,
                                             gint moved_conversation_items_length1)
{
	MailConversationListStore* _tmp2_;
	MailConversationListStore* _tmp3_;
	MailConversationListStore* _tmp4_;
	g_return_if_fail (self != NULL);
	{
		MailConversationItemModel** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = moved_conversation_items;
		item_collection_length1 = moved_conversation_items_length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			MailConversationItemModel* _tmp0_;
			MailConversationItemModel* item = NULL;
			_tmp0_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp0_;
			{
				MailConversationItemModel* _tmp1_;
				_tmp1_ = item;
				mail_conversation_item_model_set_hidden (_tmp1_, FALSE);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp2_ = self->priv->list_store;
	_tmp3_ = self->priv->list_store;
	_tmp4_ = self->priv->list_store;
	g_list_model_items_changed ((GListModel*) _tmp2_, (guint) 0, virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _tmp3_), virtualizing_list_box_model_get_n_items ((VirtualizingListBoxModel*) _tmp4_));
}

MailConversationList*
mail_conversation_list_construct (GType object_type)
{
	MailConversationList * self = NULL;
	self = (MailConversationList*) g_object_new (object_type, NULL);
	return self;
}

MailConversationList*
mail_conversation_list_new (void)
{
	return mail_conversation_list_construct (MAIL_TYPE_CONVERSATION_LIST);
}

GeeMap*
mail_conversation_list_get_folder_info_per_account (MailConversationList* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder_info_per_account;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_set_folder_info_per_account (MailConversationList* self,
                                                    GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_get_folder_info_per_account (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder_info_per_account);
		self->priv->_folder_info_per_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY]);
	}
}

GeeHashMap*
mail_conversation_list_get_folders (MailConversationList* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folders;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_set_folders (MailConversationList* self,
                                    GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_get_folders (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folders);
		self->priv->_folders = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY]);
	}
}

GeeHashMap*
mail_conversation_list_get_folder_info_flags (MailConversationList* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder_info_flags;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_set_folder_info_flags (MailConversationList* self,
                                              GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_get_folder_info_flags (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folder_info_flags);
		self->priv->_folder_info_flags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY]);
	}
}

HdyHeaderBar*
mail_conversation_list_get_search_header (MailConversationList* self)
{
	HdyHeaderBar* result;
	HdyHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_header;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_list_set_search_header (MailConversationList* self,
                                          HdyHeaderBar* value)
{
	HdyHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_list_get_search_header (self);
	if (old_value != value) {
		HdyHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_header);
		self->priv->_search_header = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY]);
	}
}

static gint
_mail_conversation_list_thread_sort_function_gcompare_data_func (gconstpointer a,
                                                                 gconstpointer b,
                                                                 gpointer self)
{
	gint result;
	result = mail_conversation_list_thread_sort_function ((MailConversationItemModel*) a, (MailConversationItemModel*) b);
	return result;
}

static gboolean
_mail_conversation_list_filter_function_mail_conversation_list_store_row_visibility_func (GObject* row,
                                                                                          gpointer self)
{
	gboolean result;
	result = mail_conversation_list_filter_function (row);
	return result;
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		MailConversationList* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->row);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
___lambda49_ (Block33Data* _data33_)
{
	MailConversationList* self;
	VirtualizingListBox* _tmp0_;
	VirtualizingListBoxRow* _tmp1_;
	VirtualizingListBoxRow* _tmp2_;
	MailConversationListItem* _tmp3_;
	self = _data33_->self;
	_tmp0_ = self->priv->list_box;
	_tmp1_ = virtualizing_list_box_get_selected_row_widget (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data33_->row;
	if (_tmp2_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_VIRTUALIZING_LIST_BOX_ROW, VirtualizingListBoxRow)) {
		VirtualizingListBox* _tmp4_;
		MailConversationListItem* _tmp5_;
		_tmp4_ = self->priv->list_box;
		_tmp5_ = _data33_->row;
		virtualizing_list_box_select_row (_tmp4_, (VirtualizingListBoxRow*) _tmp5_);
	}
}

static void
____lambda49__mail_conversation_list_item_select (MailConversationListItem* _sender,
                                                  gpointer self)
{
	___lambda49_ (self);
}

static VirtualizingListBoxRow*
_mail_conversation_list___lambda44_ (MailConversationList* self,
                                     GObject* item,
                                     VirtualizingListBoxRow* old_widget)
{
	Block33Data* _data33_;
	MailConversationListItem* _tmp3_;
	MailConversationListItem* _tmp4_;
	MailConversationListItem* _tmp5_;
	VirtualizingListBoxRow* _tmp6_;
	VirtualizingListBoxRow* result;
	g_return_val_if_fail (item != NULL, NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_data33_->row = NULL;
	if (old_widget != NULL) {
		MailConversationListItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (MAIL_IS_CONVERSATION_LIST_ITEM (old_widget) ? ((MailConversationListItem*) old_widget) : NULL);
		_g_object_unref0 (_data33_->row);
		_data33_->row = _tmp0_;
	} else {
		MailConversationListItem* _tmp1_;
		MailConversationListItem* _tmp2_;
		_tmp1_ = mail_conversation_list_item_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (_data33_->row);
		_data33_->row = _tmp1_;
		_tmp2_ = _data33_->row;
		g_signal_connect_data (_tmp2_, "select", (GCallback) ____lambda49__mail_conversation_list_item_select, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	}
	_tmp3_ = _data33_->row;
	mail_conversation_list_item_assign (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (item, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
	_tmp4_ = _data33_->row;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	_tmp5_ = _data33_->row;
	_tmp6_ = _g_object_ref0 ((VirtualizingListBoxRow*) _tmp5_);
	result = _tmp6_;
	block33_data_unref (_data33_);
	_data33_ = NULL;
	return result;
}

static VirtualizingListBoxRow*
__mail_conversation_list___lambda44__virtualizing_list_box_row_factory_method (GObject* item,
                                                                               VirtualizingListBoxRow* old_widget,
                                                                               gpointer self)
{
	VirtualizingListBoxRow* result;
	result = _mail_conversation_list___lambda44_ ((MailConversationList*) self, item, old_widget);
	return result;
}

static void
_mail_conversation_list___lambda50_ (MailConversationList* self)
{
	GeeMap* _tmp0_;
	_tmp0_ = self->priv->_folder_info_per_account;
	mail_conversation_list_load_folder (self, _tmp0_, NULL, NULL);
}

static void
__mail_conversation_list___lambda50__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                      gpointer self)
{
	_mail_conversation_list___lambda50_ ((MailConversationList*) self);
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		MailConversationList* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->row);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static gboolean
____lambda52_ (Block34Data* _data34_)
{
	MailConversationList* self;
	CamelFolderThreadNode* _tmp0_;
	CamelFolderThreadNode* _tmp1_;
	gboolean result;
	self = _data34_->self;
	_tmp0_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_data34_->row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
	_tmp1_ = _tmp0_;
	mail_conversation_list_set_thread_flag (_tmp1_, CAMEL_MESSAGE_SEEN);
	self->priv->mark_read_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
_____lambda52__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda52_ (self);
	return result;
}

static void
_mail_conversation_list___lambda51_ (MailConversationList* self,
                                     GObject* row)
{
	Block34Data* _data34_;
	GObject* _tmp0_;
	g_return_if_fail (row != NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (row);
	_g_object_unref0 (_data34_->row);
	_data34_->row = _tmp0_;
	if (self->priv->mark_read_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->mark_read_timeout_id);
		self->priv->mark_read_timeout_id = (guint) 0;
	}
	if (_data34_->row == NULL) {
		g_signal_emit (self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_FOCUSED_SIGNAL], 0, NULL);
	} else {
		CamelFolderThreadNode* _tmp1_;
		CamelFolderThreadNode* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (_data34_->row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp2_ = _tmp1_;
		g_signal_emit (self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_FOCUSED_SIGNAL], 0, _tmp2_);
		_tmp3_ = mail_conversation_item_model_get_unread (G_TYPE_CHECK_INSTANCE_CAST (_data34_->row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			self->priv->mark_read_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) MAIL_CONVERSATION_LIST_MARK_READ_TIMEOUT_SECONDS, _____lambda52__gsource_func, block34_data_ref (_data34_), block34_data_unref);
		}
	}
	block34_data_unref (_data34_);
	_data34_ = NULL;
}

static void
__mail_conversation_list___lambda51__virtualizing_list_box_row_activated (VirtualizingListBox* _sender,
                                                                          GObject* row,
                                                                          gpointer self)
{
	_mail_conversation_list___lambda51_ ((MailConversationList*) self, row);
}

static void
_mail_conversation_list___lambda53_ (MailConversationList* self,
                                     GObject* row)
{
	g_return_if_fail (row != NULL);
	if (row == NULL) {
		g_signal_emit (self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_SELECTED_SIGNAL], 0, NULL);
	} else {
		GtkApplicationWindow* window = NULL;
		GtkWidget* _tmp0_;
		GtkApplicationWindow* _tmp1_;
		GActionMap* win_action_map = NULL;
		GtkApplicationWindow* _tmp2_;
		GActionGroup* _tmp3_;
		GActionMap* _tmp4_;
		GAction* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GActionMap* _tmp8_;
		GAction* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		GActionMap* _tmp12_;
		GAction* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GActionMap* _tmp16_;
		GAction* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		CamelFolderThreadNode* _tmp20_;
		CamelFolderThreadNode* _tmp21_;
		_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_window_get_type (), GtkApplicationWindow));
		window = _tmp1_;
		_tmp2_ = window;
		_tmp3_ = gtk_widget_get_action_group ((GtkWidget*) _tmp2_, MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX);
		win_action_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_action_map_get_type (), GActionMap);
		_tmp4_ = win_action_map;
		_tmp5_ = g_action_map_lookup_action (_tmp4_, MAIL_MAIN_WINDOW_ACTION_MARK_READ);
		_tmp6_ = mail_conversation_item_model_get_unread (G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp7_ = _tmp6_;
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), _tmp7_);
		_tmp8_ = win_action_map;
		_tmp9_ = g_action_map_lookup_action (_tmp8_, MAIL_MAIN_WINDOW_ACTION_MARK_UNREAD);
		_tmp10_ = mail_conversation_item_model_get_unread (G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp11_ = _tmp10_;
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction), !_tmp11_);
		_tmp12_ = win_action_map;
		_tmp13_ = g_action_map_lookup_action (_tmp12_, MAIL_MAIN_WINDOW_ACTION_MARK_STAR);
		_tmp14_ = mail_conversation_item_model_get_flagged (G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp15_ = _tmp14_;
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_simple_action_get_type (), GSimpleAction), !_tmp15_);
		_tmp16_ = win_action_map;
		_tmp17_ = g_action_map_lookup_action (_tmp16_, MAIL_MAIN_WINDOW_ACTION_MARK_UNSTAR);
		_tmp18_ = mail_conversation_item_model_get_flagged (G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp19_ = _tmp18_;
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_simple_action_get_type (), GSimpleAction), _tmp19_);
		_tmp20_ = mail_conversation_item_model_get_node (G_TYPE_CHECK_INSTANCE_CAST (row, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel));
		_tmp21_ = _tmp20_;
		g_signal_emit (self, mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_SELECTED_SIGNAL], 0, _tmp21_);
		_g_object_unref0 (window);
	}
}

static void
__mail_conversation_list___lambda53__virtualizing_list_box_row_selected (VirtualizingListBox* _sender,
                                                                         GObject* row,
                                                                         gpointer self)
{
	_mail_conversation_list___lambda53_ ((MailConversationList*) self, row);
}

static void
_mail_conversation_list___lambda54_ (MailConversationList* self)
{
	GeeMap* _tmp0_;
	_tmp0_ = self->priv->_folder_info_per_account;
	mail_conversation_list_load_folder (self, _tmp0_, NULL, NULL);
}

static void
__mail_conversation_list___lambda54__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
	_mail_conversation_list___lambda54_ ((MailConversationList*) self);
}

static void
_mail_conversation_list___lambda55_ (MailConversationList* self)
{
	GeeMap* _tmp0_;
	_tmp0_ = self->priv->_folder_info_per_account;
	mail_conversation_list_load_folder (self, _tmp0_, NULL, NULL);
}

static void
__mail_conversation_list___lambda55__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
	_mail_conversation_list___lambda55_ ((MailConversationList*) self);
}

static GObject *
mail_conversation_list_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailConversationList * self;
	GtkStyleContext* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	MailConversationListStore* _tmp7_;
	MailConversationListStore* _tmp8_;
	MailConversationListStore* _tmp9_;
	MailConversationListStore* _tmp10_;
	VirtualizingListBoxModel* _tmp11_;
	VirtualizingListBox* _tmp12_ = NULL;
	VirtualizingListBox* _tmp13_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp14_;
	GtkApplication* _tmp15_;
	gchar* _tmp16_;
	GtkSearchEntry* _tmp17_ = NULL;
	GraniteSwitchModelButton* _tmp18_;
	GraniteSwitchModelButton* _tmp19_;
	GtkBox* filter_menu_popover_box = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	GraniteSwitchModelButton* _tmp22_;
	GtkBox* _tmp23_;
	GraniteSwitchModelButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkPopover* filter_popover = NULL;
	GtkBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkPopover* _tmp28_ = NULL;
	GtkImage* _tmp29_;
	GtkPopover* _tmp30_;
	GtkPopover* _tmp31_;
	gchar* _tmp32_;
	GtkMenuButton* _tmp33_ = NULL;
	GtkSearchEntry* _tmp34_;
	GtkWidget* _tmp35_;
	HdyHeaderBar* _tmp36_ = NULL;
	HdyHeaderBar* _tmp37_;
	HdyHeaderBar* _tmp38_;
	GtkMenuButton* _tmp39_;
	HdyHeaderBar* _tmp40_;
	GtkStyleContext* _tmp41_;
	GtkScrolledWindow* scrolled_window = NULL;
	VirtualizingListBox* _tmp42_;
	GtkWidget* _tmp43_;
	GtkScrolledWindow* _tmp44_ = NULL;
	GtkButton* refresh_button = NULL;
	gchar* _tmp45_;
	GtkButton* _tmp46_ = NULL;
	GtkButton* _tmp47_;
	GtkApplication* _tmp48_;
	GtkButton* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GtkSpinner* refresh_spinner = NULL;
	gchar* _tmp57_;
	GtkSpinner* _tmp58_ = NULL;
	GtkStack* _tmp59_ = NULL;
	GtkStack* _tmp60_;
	GtkButton* _tmp61_;
	GtkStack* _tmp62_;
	GtkSpinner* _tmp63_;
	GtkStack* _tmp64_;
	GtkButton* _tmp65_;
	GtkSpinner* move_spinner = NULL;
	GtkSpinner* _tmp66_ = NULL;
	GtkSpinner* _tmp67_;
	GtkActionBar* conversation_action_bar = NULL;
	GtkActionBar* _tmp68_;
	GtkActionBar* _tmp69_;
	GtkStack* _tmp70_;
	GtkActionBar* _tmp71_;
	GtkSpinner* _tmp72_;
	GtkActionBar* _tmp73_;
	GtkStyleContext* _tmp74_;
	HdyHeaderBar* _tmp75_;
	GtkScrolledWindow* _tmp76_;
	GtkActionBar* _tmp77_;
	GtkSearchEntry* _tmp78_;
	VirtualizingListBox* _tmp79_;
	VirtualizingListBox* _tmp80_;
	GraniteSwitchModelButton* _tmp81_;
	GraniteSwitchModelButton* _tmp82_;
	parent_class = G_OBJECT_CLASS (mail_conversation_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_LIST, MailConversationList);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_VIEW);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, MAIL_TYPE_CONVERSATION_ITEM_MODEL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->conversations);
	self->priv->conversations = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, camel_folder_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	mail_conversation_list_set_folders (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, camel_folder_info_flags_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp5_ = _tmp4_;
	mail_conversation_list_set_folder_info_flags (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, camel_folder_thread_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->threads);
	self->priv->threads = _tmp6_;
	_tmp7_ = mail_conversation_list_store_new ();
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp7_;
	_tmp8_ = self->priv->list_store;
	mail_conversation_list_store_set_sort_func (_tmp8_, _mail_conversation_list_thread_sort_function_gcompare_data_func, NULL);
	_tmp9_ = self->priv->list_store;
	mail_conversation_list_store_set_filter_func (_tmp9_, _mail_conversation_list_filter_function_mail_conversation_list_store_row_visibility_func, NULL);
	_tmp10_ = self->priv->list_store;
	_tmp11_ = _g_object_ref0 ((VirtualizingListBoxModel*) _tmp10_);
	_tmp12_ = virtualizing_list_box_new ();
	virtualizing_list_box_set_activate_on_single_click (_tmp12_, TRUE);
	virtualizing_list_box_set_model (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	virtualizing_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp12_;
	_tmp13_ = self->priv->list_box;
	(_tmp13_->factory_func_target_destroy_notify == NULL) ? NULL : (_tmp13_->factory_func_target_destroy_notify (_tmp13_->factory_func_target), NULL);
	_tmp13_->factory_func = NULL;
	_tmp13_->factory_func_target = NULL;
	_tmp13_->factory_func_target_destroy_notify = NULL;
	_tmp13_->factory_func = __mail_conversation_list___lambda44__virtualizing_list_box_row_factory_method;
	_tmp13_->factory_func_target = g_object_ref (self);
	_tmp13_->factory_func_target_destroy_notify = g_object_unref;
	_tmp14_ = g_application_get_default ();
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp15_;
	_tmp16_ = g_strdup (_ ("Search Mail"));
	_tmp17_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp17_, _tmp16_);
	_g_free0 (_tmp16_);
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp17_;
	_tmp18_ = granite_switch_model_button_new (_ ("Hide read conversations"));
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->hide_read_switch);
	self->priv->hide_read_switch = _tmp18_;
	_tmp19_ = granite_switch_model_button_new (_ ("Hide unstarred conversations"));
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->hide_unstarred_switch);
	self->priv->hide_unstarred_switch = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 3);
	g_object_ref_sink (_tmp20_);
	filter_menu_popover_box = _tmp20_;
	_tmp21_ = filter_menu_popover_box;
	_tmp22_ = self->priv->hide_read_switch;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = filter_menu_popover_box;
	_tmp24_ = self->priv->hide_unstarred_switch;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = filter_menu_popover_box;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_tmp26_ = filter_menu_popover_box;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_set ((GtkContainer*) _tmp28_, "child", _tmp27_, NULL);
	_g_object_unref0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	filter_popover = _tmp28_;
	_tmp29_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-filter-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = filter_popover;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_tmp32_ = g_strdup (_ ("Filter Conversations"));
	_tmp33_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp33_, (GtkWidget*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	gtk_menu_button_set_popover (_tmp33_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp33_, _tmp32_);
	_g_free0 (_tmp32_);
	gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->filter_button);
	self->priv->filter_button = _tmp33_;
	_tmp34_ = self->priv->search_entry;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_custom_title (_tmp36_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	mail_conversation_list_set_search_header (self, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = self->priv->_search_header;
	_tmp39_ = self->priv->filter_button;
	hdy_header_bar_pack_end (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->_search_header;
	_tmp41_ = gtk_widget_get_style_context ((GtkWidget*) _tmp40_);
	gtk_style_context_add_class (_tmp41_, GTK_STYLE_CLASS_FLAT);
	_tmp42_ = self->priv->list_box;
	_tmp43_ = _g_object_ref0 ((GtkWidget*) _tmp42_);
	_tmp44_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp44_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set ((GtkWidget*) _tmp44_, "width-request", 158, NULL);
	g_object_set ((GtkWidget*) _tmp44_, "expand", TRUE, NULL);
	g_object_set ((GtkContainer*) _tmp44_, "child", _tmp43_, NULL);
	_g_object_unref0 (_tmp43_);
	g_object_ref_sink (_tmp44_);
	scrolled_window = _tmp44_;
	_tmp45_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_REFRESH);
	_tmp46_ = (GtkButton*) gtk_button_new_from_icon_name ("view-refresh-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp46_, _tmp45_);
	_g_free0 (_tmp45_);
	g_object_ref_sink (_tmp46_);
	refresh_button = _tmp46_;
	_tmp47_ = refresh_button;
	_tmp48_ = application_instance;
	_tmp49_ = refresh_button;
	_tmp50_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp53_ = _tmp52_ = gtk_application_get_accels_for_action (_tmp48_, _tmp51_);
	_tmp54_ = _tmp53_;
	_tmp54__length1 = _vala_array_length (_tmp52_);
	_tmp55_ = granite_markup_accel_tooltip (_tmp54_, (gint) _vala_array_length (_tmp52_), _ ("Fetch new messages"));
	_tmp56_ = _tmp55_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp47_, _tmp56_);
	_g_free0 (_tmp56_);
	_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
	_tmp57_ = g_strdup (_ ("Fetching new messages…"));
	_tmp58_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_set (_tmp58_, "active", TRUE, NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp58_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp58_, GTK_ALIGN_CENTER);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp58_, _tmp57_);
	_g_free0 (_tmp57_);
	g_object_ref_sink (_tmp58_);
	refresh_spinner = _tmp58_;
	_tmp59_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp59_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->refresh_stack);
	self->priv->refresh_stack = _tmp59_;
	_tmp60_ = self->priv->refresh_stack;
	_tmp61_ = refresh_button;
	gtk_stack_add_named (_tmp60_, (GtkWidget*) _tmp61_, "button");
	_tmp62_ = self->priv->refresh_stack;
	_tmp63_ = refresh_spinner;
	gtk_stack_add_named (_tmp62_, (GtkWidget*) _tmp63_, "spinner");
	_tmp64_ = self->priv->refresh_stack;
	_tmp65_ = refresh_button;
	gtk_stack_set_visible_child (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_set (_tmp66_, "active", TRUE, NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp66_, GTK_ALIGN_CENTER);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp66_, TRUE);
	g_object_ref_sink (_tmp66_);
	move_spinner = _tmp66_;
	_tmp67_ = move_spinner;
	mail_move_operation_bind_spinner (_tmp67_);
	_tmp68_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp68_);
	conversation_action_bar = _tmp68_;
	_tmp69_ = conversation_action_bar;
	_tmp70_ = self->priv->refresh_stack;
	gtk_action_bar_pack_start (_tmp69_, (GtkWidget*) _tmp70_);
	_tmp71_ = conversation_action_bar;
	_tmp72_ = move_spinner;
	gtk_action_bar_pack_end (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = conversation_action_bar;
	_tmp74_ = gtk_widget_get_style_context ((GtkWidget*) _tmp73_);
	gtk_style_context_add_class (_tmp74_, GTK_STYLE_CLASS_FLAT);
	_tmp75_ = self->priv->_search_header;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp75_);
	_tmp76_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp76_);
	_tmp77_ = conversation_action_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp77_);
	_tmp78_ = self->priv->search_entry;
	g_signal_connect_object (_tmp78_, "search-changed", (GCallback) __mail_conversation_list___lambda50__gtk_search_entry_search_changed, self, 0);
	_tmp79_ = self->priv->list_box;
	g_signal_connect_object (_tmp79_, "row-activated", (GCallback) __mail_conversation_list___lambda51__virtualizing_list_box_row_activated, self, 0);
	_tmp80_ = self->priv->list_box;
	g_signal_connect_object (_tmp80_, "row-selected", (GCallback) __mail_conversation_list___lambda53__virtualizing_list_box_row_selected, self, 0);
	_tmp81_ = self->priv->hide_read_switch;
	g_signal_connect_object ((GtkToggleButton*) _tmp81_, "toggled", (GCallback) __mail_conversation_list___lambda54__gtk_toggle_button_toggled, self, 0);
	_tmp82_ = self->priv->hide_unstarred_switch;
	g_signal_connect_object ((GtkToggleButton*) _tmp82_, "toggled", (GCallback) __mail_conversation_list___lambda55__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (conversation_action_bar);
	_g_object_unref0 (move_spinner);
	_g_object_unref0 (refresh_spinner);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (filter_popover);
	_g_object_unref0 (filter_menu_popover_box);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
mail_conversation_list_class_init (MailConversationListClass * klass,
                                   gpointer klass_data)
{
	mail_conversation_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailConversationList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_conversation_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_conversation_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_conversation_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_conversation_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY] = g_param_spec_object ("folder-info-per-account", "folder-info-per-account", "folder-info-per-account", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY] = g_param_spec_object ("folders", "folders", "folders", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY] = g_param_spec_object ("folder-info-flags", "folder-info-flags", "folder-info-flags", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY, mail_conversation_list_properties[MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY] = g_param_spec_object ("search-header", "search-header", "search-header", hdy_header_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_SELECTED_SIGNAL] = g_signal_new ("conversation-selected", MAIL_TYPE_CONVERSATION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	mail_conversation_list_signals[MAIL_CONVERSATION_LIST_CONVERSATION_FOCUSED_SIGNAL] = g_signal_new ("conversation-focused", MAIL_TYPE_CONVERSATION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
mail_conversation_list_instance_init (MailConversationList * self,
                                      gpointer klass)
{
	self->priv = mail_conversation_list_get_instance_private (self);
	self->priv->cancellable = NULL;
	g_rec_mutex_init (&self->priv->__lock_threads);
	g_rec_mutex_init (&self->priv->__lock_conversations);
	self->priv->mark_read_timeout_id = (guint) 0;
	g_rec_mutex_init (&self->priv->__lock_folder_info_per_account);
	g_rec_mutex_init (&self->priv->__lock_folders);
}

static void
mail_conversation_list_finalize (GObject * obj)
{
	MailConversationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_LIST, MailConversationList);
	_g_object_unref0 (self->priv->_folder_info_per_account);
	_g_object_unref0 (self->priv->_folders);
	_g_object_unref0 (self->priv->_folder_info_flags);
	_g_object_unref0 (self->priv->_search_header);
	_g_object_unref0 (self->priv->cancellable);
	g_rec_mutex_clear (&self->priv->__lock_threads);
	_g_object_unref0 (self->priv->threads);
	g_rec_mutex_clear (&self->priv->__lock_conversations);
	_g_object_unref0 (self->priv->conversations);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->hide_read_switch);
	_g_object_unref0 (self->priv->hide_unstarred_switch);
	_g_object_unref0 (self->priv->filter_button);
	_g_object_unref0 (self->priv->refresh_stack);
	g_rec_mutex_clear (&self->priv->__lock_folder_info_per_account);
	g_rec_mutex_clear (&self->priv->__lock_folders);
	G_OBJECT_CLASS (mail_conversation_list_parent_class)->finalize (obj);
}

static GType
mail_conversation_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailConversationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_conversation_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailConversationList), 0, (GInstanceInitFunc) mail_conversation_list_instance_init, NULL };
	GType mail_conversation_list_type_id;
	mail_conversation_list_type_id = g_type_register_static (gtk_box_get_type (), "MailConversationList", &g_define_type_info, 0);
	MailConversationList_private_offset = g_type_add_instance_private (mail_conversation_list_type_id, sizeof (MailConversationListPrivate));
	return mail_conversation_list_type_id;
}

GType
mail_conversation_list_get_type (void)
{
	static volatile gsize mail_conversation_list_type_id__once = 0;
	if (g_once_init_enter (&mail_conversation_list_type_id__once)) {
		GType mail_conversation_list_type_id;
		mail_conversation_list_type_id = mail_conversation_list_get_type_once ();
		g_once_init_leave (&mail_conversation_list_type_id__once, mail_conversation_list_type_id);
	}
	return mail_conversation_list_type_id__once;
}

static void
_vala_mail_conversation_list_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MailConversationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONVERSATION_LIST, MailConversationList);
	switch (property_id) {
		case MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY:
		g_value_set_object (value, mail_conversation_list_get_folder_info_per_account (self));
		break;
		case MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY:
		g_value_set_object (value, mail_conversation_list_get_folders (self));
		break;
		case MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY:
		g_value_set_object (value, mail_conversation_list_get_folder_info_flags (self));
		break;
		case MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY:
		g_value_set_object (value, mail_conversation_list_get_search_header (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_conversation_list_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MailConversationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONVERSATION_LIST, MailConversationList);
	switch (property_id) {
		case MAIL_CONVERSATION_LIST_FOLDER_INFO_PER_ACCOUNT_PROPERTY:
		mail_conversation_list_set_folder_info_per_account (self, g_value_get_object (value));
		break;
		case MAIL_CONVERSATION_LIST_FOLDERS_PROPERTY:
		mail_conversation_list_set_folders (self, g_value_get_object (value));
		break;
		case MAIL_CONVERSATION_LIST_FOLDER_INFO_FLAGS_PROPERTY:
		mail_conversation_list_set_folder_info_flags (self, g_value_get_object (value));
		break;
		case MAIL_CONVERSATION_LIST_SEARCH_HEADER_PROPERTY:
		mail_conversation_list_set_search_header (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

