/* PngSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PngSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_PNG_FILE_FORMAT_PROPERTIES (png_file_format_properties_get_type ())
#define PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties))
#define PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))
#define IS_PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define IS_PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define PNG_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))

typedef struct _PngFileFormatProperties PngFileFormatProperties;
typedef struct _PngFileFormatPropertiesClass PngFileFormatPropertiesClass;
typedef struct _PngFileFormatPropertiesPrivate PngFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

struct _PngFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	PngFileFormatPropertiesPrivate * priv;
};

struct _PngFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

static gpointer png_file_format_properties_parent_class = NULL;
static gchar** png_file_format_properties_known_extensions;
static gint png_file_format_properties_known_extensions_length1;
static gchar** png_file_format_properties_known_extensions = NULL;
static gint png_file_format_properties_known_extensions_length1 = 0;
static gint _png_file_format_properties_known_extensions_size_ = 0;
static gchar** png_file_format_properties_known_mime_types;
static gint png_file_format_properties_known_mime_types_length1;
static gchar** png_file_format_properties_known_mime_types = NULL;
static gint png_file_format_properties_known_mime_types_length1 = 0;
static gint _png_file_format_properties_known_mime_types_size_ = 0;
static PngFileFormatProperties* png_file_format_properties_instance;
static PngFileFormatProperties* png_file_format_properties_instance = NULL;
static gpointer png_sniffer_parent_class = NULL;
static gpointer png_reader_parent_class = NULL;
static gpointer png_writer_parent_class = NULL;
static gpointer png_metadata_writer_parent_class = NULL;
static gpointer png_file_format_driver_parent_class = NULL;
static PngFileFormatDriver* png_file_format_driver_instance;
static PngFileFormatDriver* png_file_format_driver_instance = NULL;

VALA_EXTERN GType png_file_format_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void png_file_format_properties_init (void);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_new (void);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_construct (GType object_type);
VALA_EXTERN PngFileFormatProperties* png_file_format_properties_get_instance (void);
static PhotoFileFormat png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                              gint* result_length1);
static gchar** _vala_array_dup18 (gchar** self,
                           gssize length);
static gchar* png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                        gint* result_length1);
static gchar** _vala_array_dup19 (gchar** self,
                           gssize length);
static void png_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType png_file_format_properties_get_type_once (void);
static gboolean png_sniffer_is_png_file (GFile* file,
                                  GError** error);
static DetectedPhotoInformation* png_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  GError** error);
static GType png_sniffer_get_type_once (void);
static GdkPixbuf* png_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
static GType png_reader_get_type_once (void);
static void png_writer_real_write (PhotoFileWriter* base,
                            GdkPixbuf* pixbuf,
                            JpegQuality quality,
                            GError** error);
static GType png_writer_get_type_once (void);
static void png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                              PhotoMetadata* metadata,
                                              GError** error);
static GType png_metadata_writer_get_type_once (void);
static PhotoFileFormatProperties* png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static gboolean png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static PhotoFileMetadataWriter* png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                             const gchar* filepath);
static PhotoFileSniffer* png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                              GFile* file,
                                                              PhotoFileSnifferOptions options);
static PhotoMetadata* png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static void png_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType png_file_format_driver_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const guint8 PNG_SNIFFER_MAGIC_SEQUENCE[8] = {(guint8) 137, (guint8) 80, (guint8) 78, (guint8) 71, (guint8) 13, (guint8) 10, (guint8) 26, (guint8) 10};

void
png_file_format_properties_init (void)
{
	PngFileFormatProperties* _tmp0_;
	_tmp0_ = png_file_format_properties_new ();
	_photo_file_format_properties_unref0 (png_file_format_properties_instance);
	png_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

PngFileFormatProperties*
png_file_format_properties_get_instance (void)
{
	PngFileFormatProperties* _tmp0_;
	PngFileFormatProperties* _tmp1_;
	PngFileFormatProperties* result;
	_tmp0_ = png_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	PhotoFileFormat result;
	self = (PngFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_PNG;
	return result;
}

static PhotoFileFormatFlags
png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (PngFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (PngFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("PNG"));
	result = _tmp0_;
	return result;
}

static gchar*
png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PngFileFormatProperties*) base;
	_tmp0_ = png_file_format_properties_known_extensions;
	_tmp0__length1 = png_file_format_properties_known_extensions_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup18 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                      gint* result_length1)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PngFileFormatProperties*) base;
	_tmp0_ = png_file_format_properties_known_extensions;
	_tmp0__length1 = png_file_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup18 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PngFileFormatProperties*) base;
	_tmp0_ = png_file_format_properties_known_mime_types;
	_tmp0__length1 = png_file_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup19 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                gint* result_length1)
{
	PngFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PngFileFormatProperties*) base;
	_tmp0_ = png_file_format_properties_known_mime_types;
	_tmp0__length1 = png_file_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup19 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PngFileFormatProperties*
png_file_format_properties_construct (GType object_type)
{
	PngFileFormatProperties* self = NULL;
	self = (PngFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

PngFileFormatProperties*
png_file_format_properties_new (void)
{
	return png_file_format_properties_construct (TYPE_PNG_FILE_FORMAT_PROPERTIES);
}

static void
png_file_format_properties_class_init (PngFileFormatPropertiesClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	png_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = png_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) png_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) png_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) png_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("png");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	png_file_format_properties_known_extensions = _tmp1_;
	png_file_format_properties_known_extensions_length1 = 1;
	_png_file_format_properties_known_extensions_size_ = png_file_format_properties_known_extensions_length1;
	_tmp2_ = g_strdup ("image/png");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	png_file_format_properties_known_mime_types = _tmp3_;
	png_file_format_properties_known_mime_types_length1 = 1;
	_png_file_format_properties_known_mime_types_size_ = png_file_format_properties_known_mime_types_length1;
}

static void
png_file_format_properties_instance_init (PngFileFormatProperties * self,
                                          gpointer klass)
{
}

static void
png_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	PngFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (png_file_format_properties_parent_class)->finalize (obj);
}

static GType
png_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatProperties), 0, (GInstanceInitFunc) png_file_format_properties_instance_init, NULL };
	GType png_file_format_properties_type_id;
	png_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "PngFileFormatProperties", &g_define_type_info, 0);
	return png_file_format_properties_type_id;
}

GType
png_file_format_properties_get_type (void)
{
	static volatile gsize png_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&png_file_format_properties_type_id__once)) {
		GType png_file_format_properties_type_id;
		png_file_format_properties_type_id = png_file_format_properties_get_type_once ();
		g_once_init_leave (&png_file_format_properties_type_id__once, png_file_format_properties_type_id);
	}
	return png_file_format_properties_type_id__once;
}

PngSniffer*
png_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	PngSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PngSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

PngSniffer*
png_sniffer_new (GFile* file,
                 PhotoFileSnifferOptions options)
{
	return png_sniffer_construct (TYPE_PNG_SNIFFER, file, options);
}

static gboolean
png_sniffer_is_png_file (GFile* file,
                         GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp2_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	GFileInputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_new0 (guint8, G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE));
	file_lead_sequence = _tmp2_;
	file_lead_sequence_length1 = G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp3_ = instream;
	_tmp4_ = file_lead_sequence;
	_tmp4__length1 = file_lead_sequence_length1;
	g_input_stream_read ((GInputStream*) _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp5_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8 _tmp9_;
				guint8 _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE))) {
					break;
				}
				_tmp8_ = file_lead_sequence;
				_tmp8__length1 = file_lead_sequence_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = PNG_SNIFFER_MAGIC_SEQUENCE[i];
				if (_tmp9_ != _tmp10_) {
					result = FALSE;
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
					_g_object_unref0 (instream);
					return result;
				}
			}
		}
	}
	result = TRUE;
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	_g_object_unref0 (instream);
	return result;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
png_sniffer_real_sniff (PhotoFileSniffer* base,
                        GError** error)
{
	PngSniffer * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_;
	DetectedPhotoInformation* _tmp7_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (PngSniffer*) base;
	_tmp1_ = ((PhotoFileSniffer*) self)->file;
	_tmp0_ = png_sniffer_is_png_file (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = PHOTO_FILE_SNIFFER_CLASS (png_sniffer_parent_class)->sniff ((PhotoFileSniffer*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), &_inner_error0_);
	detected = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = detected;
	if (_tmp3_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		return result;
	}
	_tmp5_ = detected;
	if (_tmp5_->file_format == PHOTO_FILE_FORMAT_PNG) {
		DetectedPhotoInformation* _tmp6_;
		_tmp6_ = detected;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = _detected_photo_information_ref0 (_tmp4_);
	result = _tmp7_;
	_detected_photo_information_unref0 (detected);
	return result;
}

static void
png_sniffer_class_init (PngSnifferClass * klass,
                        gpointer klass_data)
{
	png_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) png_sniffer_real_sniff;
}

static void
png_sniffer_instance_init (PngSniffer * self,
                           gpointer klass)
{
}

static GType
png_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngSniffer), 0, (GInstanceInitFunc) png_sniffer_instance_init, NULL };
	GType png_sniffer_type_id;
	png_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "PngSniffer", &g_define_type_info, 0);
	return png_sniffer_type_id;
}

GType
png_sniffer_get_type (void)
{
	static volatile gsize png_sniffer_type_id__once = 0;
	if (g_once_init_enter (&png_sniffer_type_id__once)) {
		GType png_sniffer_type_id;
		png_sniffer_type_id = png_sniffer_get_type_once ();
		g_once_init_leave (&png_sniffer_type_id__once, png_sniffer_type_id);
	}
	return png_sniffer_type_id__once;
}

PngReader*
png_reader_construct (GType object_type,
                      const gchar* filepath)
{
	PngReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngReader*
png_reader_new (const gchar* filepath)
{
	return png_reader_construct (TYPE_PNG_READER, filepath);
}

static GdkPixbuf*
png_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	PngReader * self;
	GdkPixbuf* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (PngReader*) base;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_result_ = NULL;
	_tmp2_ = *full;
	if (_tmp2_.width > 9999) {
		_tmp1_ = TRUE;
	} else {
		Dimensions _tmp3_;
		_tmp3_ = *full;
		_tmp1_ = _tmp3_.height > 9999;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		Dimensions _tmp5_;
		_tmp5_ = *scaled;
		if (_tmp5_.width < 100) {
			_tmp4_ = TRUE;
		} else {
			Dimensions _tmp6_;
			_tmp6_ = *scaled;
			_tmp4_ = _tmp6_.height < 100;
		}
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Dimensions prefetch_dimensions = {0};
		Dimensions _tmp7_ = {0};
		GdkPixbuf* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		Dimensions _tmp11_;
		Dimensions _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		Dimensions _tmp17_;
		Dimensions _tmp18_;
		GdkPixbuf* _tmp19_;
		dimensions_get_scaled_by_constraint (full, 1000, SCALE_CONSTRAINT_DIMENSIONS, &_tmp7_);
		prefetch_dimensions = _tmp7_;
		_tmp9_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = prefetch_dimensions;
		_tmp12_ = prefetch_dimensions;
		_tmp13_ = gdk_pixbuf_new_from_file_at_scale (_tmp10_, _tmp11_.width, _tmp12_.height, FALSE, &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp10_);
		_tmp8_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp15_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp15_;
		_tmp16_ = _result_;
		_tmp17_ = *scaled;
		_tmp18_ = *scaled;
		_tmp19_ = gdk_pixbuf_scale_simple (_tmp16_, _tmp17_.width, _tmp18_.height, GDK_INTERP_HYPER);
		_g_object_unref0 (_result_);
		_result_ = _tmp19_;
		_g_object_unref0 (_tmp8_);
	} else {
		GdkPixbuf* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		Dimensions _tmp23_;
		Dimensions _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		GdkPixbuf* _tmp27_;
		_tmp21_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = *scaled;
		_tmp24_ = *scaled;
		_tmp25_ = gdk_pixbuf_new_from_file_at_scale (_tmp22_, _tmp23_.width, _tmp24_.height, FALSE, &_inner_error0_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp22_);
		_tmp20_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp27_ = _tmp20_;
		_tmp20_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp27_;
		_g_object_unref0 (_tmp20_);
	}
	result = _result_;
	return result;
}

static void
png_reader_class_init (PngReaderClass * klass,
                       gpointer klass_data)
{
	png_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) png_reader_real_scaled_read;
}

static void
png_reader_instance_init (PngReader * self,
                          gpointer klass)
{
}

static GType
png_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngReader), 0, (GInstanceInitFunc) png_reader_instance_init, NULL };
	GType png_reader_type_id;
	png_reader_type_id = g_type_register_static (TYPE_GDK_READER, "PngReader", &g_define_type_info, 0);
	return png_reader_type_id;
}

GType
png_reader_get_type (void)
{
	static volatile gsize png_reader_type_id__once = 0;
	if (g_once_init_enter (&png_reader_type_id__once)) {
		GType png_reader_type_id;
		png_reader_type_id = png_reader_get_type_once ();
		g_once_init_leave (&png_reader_type_id__once, png_reader_type_id);
	}
	return png_reader_type_id__once;
}

PngWriter*
png_writer_construct (GType object_type,
                      const gchar* filepath)
{
	PngWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngWriter*) photo_file_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngWriter*
png_writer_new (const gchar* filepath)
{
	return png_writer_construct (TYPE_PNG_WRITER, filepath);
}

static void
png_writer_real_write (PhotoFileWriter* base,
                       GdkPixbuf* pixbuf,
                       JpegQuality quality,
                       GError** error)
{
	PngWriter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (PngWriter*) base;
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	gdk_pixbuf_save (pixbuf, _tmp1_, "png", &_inner_error0_, "compression", "9", NULL, NULL);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
png_writer_class_init (PngWriterClass * klass,
                       gpointer klass_data)
{
	png_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) png_writer_real_write;
}

static void
png_writer_instance_init (PngWriter * self,
                          gpointer klass)
{
}

static GType
png_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngWriter), 0, (GInstanceInitFunc) png_writer_instance_init, NULL };
	GType png_writer_type_id;
	png_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "PngWriter", &g_define_type_info, 0);
	return png_writer_type_id;
}

GType
png_writer_get_type (void)
{
	static volatile gsize png_writer_type_id__once = 0;
	if (g_once_init_enter (&png_writer_type_id__once)) {
		GType png_writer_type_id;
		png_writer_type_id = png_writer_get_type_once ();
		g_once_init_leave (&png_writer_type_id__once, png_writer_type_id);
	}
	return png_writer_type_id__once;
}

PngMetadataWriter*
png_metadata_writer_construct (GType object_type,
                               const gchar* filepath)
{
	PngMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PngMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_PNG);
	return self;
}

PngMetadataWriter*
png_metadata_writer_new (const gchar* filepath)
{
	return png_metadata_writer_construct (TYPE_PNG_METADATA_WRITER, filepath);
}

static void
png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                         PhotoMetadata* metadata,
                                         GError** error)
{
	PngMetadataWriter * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (PngMetadataWriter*) base;
	g_return_if_fail (metadata != NULL);
	_tmp0_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	photo_metadata_write_to_file (metadata, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
png_metadata_writer_class_init (PngMetadataWriterClass * klass,
                                gpointer klass_data)
{
	png_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) png_metadata_writer_real_write_metadata;
}

static void
png_metadata_writer_instance_init (PngMetadataWriter * self,
                                   gpointer klass)
{
}

static GType
png_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngMetadataWriter), 0, (GInstanceInitFunc) png_metadata_writer_instance_init, NULL };
	GType png_metadata_writer_type_id;
	png_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "PngMetadataWriter", &g_define_type_info, 0);
	return png_metadata_writer_type_id;
}

GType
png_metadata_writer_get_type (void)
{
	static volatile gsize png_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&png_metadata_writer_type_id__once)) {
		GType png_metadata_writer_type_id;
		png_metadata_writer_type_id = png_metadata_writer_get_type_once ();
		g_once_init_leave (&png_metadata_writer_type_id__once, png_metadata_writer_type_id);
	}
	return png_metadata_writer_type_id__once;
}

void
png_file_format_driver_init (void)
{
	PngFileFormatDriver* _tmp0_;
	_tmp0_ = png_file_format_driver_new ();
	_photo_file_format_driver_unref0 (png_file_format_driver_instance);
	png_file_format_driver_instance = _tmp0_;
	png_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

PngFileFormatDriver*
png_file_format_driver_get_instance (void)
{
	PngFileFormatDriver* _tmp0_;
	PngFileFormatDriver* _tmp1_;
	PngFileFormatDriver* result;
	_tmp0_ = png_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	PngFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (PngFileFormatDriver*) base;
	_tmp0_ = png_file_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngReader* _tmp0_;
	PhotoFileReader* result;
	self = (PngFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_reader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static gboolean
png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	gboolean result;
	self = (PngFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static gboolean
png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	gboolean result;
	self = (PngFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static PhotoFileWriter*
png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngWriter* _tmp0_;
	PhotoFileWriter* result;
	self = (PngFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_writer_new (filepath);
	result = (PhotoFileWriter*) _tmp0_;
	return result;
}

static PhotoFileMetadataWriter*
png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                    const gchar* filepath)
{
	PngFileFormatDriver * self;
	PngMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = (PngFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = png_metadata_writer_new (filepath);
	result = (PhotoFileMetadataWriter*) _tmp0_;
	return result;
}

static PhotoFileSniffer*
png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                            GFile* file,
                                            PhotoFileSnifferOptions options)
{
	PngFileFormatDriver * self;
	PngSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (PngFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = png_sniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

static PhotoMetadata*
png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	PngFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (PngFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

PngFileFormatDriver*
png_file_format_driver_construct (GType object_type)
{
	PngFileFormatDriver* self = NULL;
	self = (PngFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

PngFileFormatDriver*
png_file_format_driver_new (void)
{
	return png_file_format_driver_construct (TYPE_PNG_FILE_FORMAT_DRIVER);
}

static void
png_file_format_driver_class_init (PngFileFormatDriverClass * klass,
                                   gpointer klass_data)
{
	png_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = png_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) png_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) png_file_format_driver_real_create_sniffer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) png_file_format_driver_real_create_metadata;
}

static void
png_file_format_driver_instance_init (PngFileFormatDriver * self,
                                      gpointer klass)
{
}

static void
png_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	PngFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (png_file_format_driver_parent_class)->finalize (obj);
}

static GType
png_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatDriver), 0, (GInstanceInitFunc) png_file_format_driver_instance_init, NULL };
	GType png_file_format_driver_type_id;
	png_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "PngFileFormatDriver", &g_define_type_info, 0);
	return png_file_format_driver_type_id;
}

GType
png_file_format_driver_get_type (void)
{
	static volatile gsize png_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&png_file_format_driver_type_id__once)) {
		GType png_file_format_driver_type_id;
		png_file_format_driver_type_id = png_file_format_driver_get_type_once ();
		g_once_init_leave (&png_file_format_driver_type_id__once, png_file_format_driver_type_id);
	}
	return png_file_format_driver_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

