/* BasicProperties.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BasicProperties.vala, do not modify */

/*
* Copyright (c) 2011-2014 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <geocode-glib/geocode-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_BASIC_PROPERTIES (basic_properties_get_type ())
#define BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_PROPERTIES, BasicProperties))
#define BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))
#define IS_BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_PROPERTIES))
#define IS_BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_PROPERTIES))
#define BASIC_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))

typedef struct _BasicProperties BasicProperties;
typedef struct _BasicPropertiesClass BasicPropertiesClass;
typedef struct _BasicPropertiesPrivate BasicPropertiesPrivate;
enum  {
	BASIC_PROPERTIES_0_PROPERTY,
	BASIC_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* basic_properties_properties[BASIC_PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_IMPORT_SOURCE (import_source_get_type ())
#define IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE, ImportSource))
#define IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE, ImportSourceClass))
#define IS_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE))
#define IS_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE))
#define IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE, ImportSourceClass))

typedef struct _ImportSource ImportSource;
typedef struct _ImportSourceClass ImportSourceClass;

#define TYPE_PHOTO_IMPORT_SOURCE (photo_import_source_get_type ())
#define PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource))
#define PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))
#define IS_PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_SOURCE))
#define IS_PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_SOURCE))
#define PHOTO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))

typedef struct _PhotoImportSource PhotoImportSource;
typedef struct _PhotoImportSourceClass PhotoImportSourceClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _dimensions_free0(var) ((var == NULL) ? NULL : (var = (dimensions_free (var), NULL)))

#define TYPE_VIDEO_IMPORT_SOURCE (video_import_source_get_type ())
#define VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource))
#define VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))
#define IS_VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_SOURCE))
#define IS_VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_SOURCE))
#define VIDEO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))

typedef struct _VideoImportSource VideoImportSource;
typedef struct _VideoImportSourceClass VideoImportSourceClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define BASIC_PROPERTIES_TYPE_EXIF_ITEM (basic_properties_exif_item_get_type ())
#define BASIC_PROPERTIES_EXIF_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BASIC_PROPERTIES_TYPE_EXIF_ITEM, BasicPropertiesExifItem))
#define BASIC_PROPERTIES_EXIF_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BASIC_PROPERTIES_TYPE_EXIF_ITEM, BasicPropertiesExifItemClass))
#define BASIC_PROPERTIES_IS_EXIF_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BASIC_PROPERTIES_TYPE_EXIF_ITEM))
#define BASIC_PROPERTIES_IS_EXIF_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BASIC_PROPERTIES_TYPE_EXIF_ITEM))
#define BASIC_PROPERTIES_EXIF_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BASIC_PROPERTIES_TYPE_EXIF_ITEM, BasicPropertiesExifItemClass))

typedef struct _BasicPropertiesExifItem BasicPropertiesExifItem;
typedef struct _BasicPropertiesExifItemClass BasicPropertiesExifItemClass;
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BasicPropertiesCreatePlaceLabelData BasicPropertiesCreatePlaceLabelData;
typedef struct _BasicPropertiesExifItemPrivate BasicPropertiesExifItemPrivate;
enum  {
	BASIC_PROPERTIES_EXIF_ITEM_0_PROPERTY,
	BASIC_PROPERTIES_EXIF_ITEM_NUM_PROPERTIES
};
static GParamSpec* basic_properties_exif_item_properties[BASIC_PROPERTIES_EXIF_ITEM_NUM_PROPERTIES];

struct _BasicProperties {
	Properties parent_instance;
	BasicPropertiesPrivate * priv;
};

struct _BasicPropertiesClass {
	PropertiesClass parent_class;
};

struct _BasicPropertiesPrivate {
	gint64 start_time;
	gint64 end_time;
	Dimensions dimensions;
	EditableTitle* title_entry;
	MediaSource* source;
	PropertiesLabel* place_label;
	gint photo_count;
	gint event_count;
	gint video_count;
	gchar* camera_make;
	gchar* camera_model;
	gchar* exposure;
	gchar* exposure_bias;
	gchar* flash;
	gchar* focal_length;
	gdouble gps_lat;
	gchar* gps_lat_ref;
	gdouble gps_long;
	gchar* gps_long_ref;
	gdouble gps_alt;
	gchar* title;
	gchar* aperture;
	gchar* iso;
	gdouble clip_duration;
	gchar* raw_developer;
	gchar* raw_assoc;
	guint64 filesize;
};

struct _BasicPropertiesCreatePlaceLabelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BasicProperties* self;
	gdouble lat;
	gdouble _long_;
	GeocodeLocation* location;
	GeocodeLocation* _tmp0_;
	GeocodeReverse* reverse;
	GeocodeReverse* _tmp1_;
	GeocodePlace* place;
	GeocodePlace* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	PropertiesLabel* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	PropertiesLabel* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	PropertiesLabel* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	PropertiesLabel* _tmp27_;
	PropertiesLabel* _tmp28_;
	GError* e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_;
};

struct _BasicPropertiesExifItem {
	GtkFlowBoxChild parent_instance;
	BasicPropertiesExifItemPrivate * priv;
};

struct _BasicPropertiesExifItemClass {
	GtkFlowBoxChildClass parent_class;
};

static gint BasicProperties_private_offset;
static gpointer basic_properties_parent_class = NULL;
static gpointer basic_properties_exif_item_parent_class = NULL;

VALA_EXTERN GType basic_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BasicProperties* basic_properties_new (void);
VALA_EXTERN BasicProperties* basic_properties_construct (GType object_type);
static void basic_properties_real_clear_properties (Properties* base);
static void basic_properties_real_get_single_properties (Properties* base,
                                                  DataView* view);
VALA_EXTERN GType import_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_import_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint64 import_source_get_exposure_time (ImportSource* self);
VALA_EXTERN PhotoMetadata* photo_import_source_get_metadata (PhotoImportSource* self);
VALA_EXTERN GType video_import_source_get_type (void) G_GNUC_CONST ;
static void basic_properties_real_get_multiple_properties (Properties* base,
                                                    GeeIterable* iter);
static void basic_properties_real_get_properties (Properties* base,
                                           Page* current_page);
static void basic_properties_real_internal_update_properties (Properties* base,
                                                       Page* page);
static void basic_properties_title_entry_changed (BasicProperties* self);
static void _basic_properties_title_entry_changed_editable_title_changed (EditableTitle* _sender,
                                                                   const gchar* new_title,
                                                                   gpointer self);
static void basic_properties_attach_item_count_label (BasicProperties* self,
                                               const gchar* text);
static void basic_properties_create_place_label (BasicProperties* self,
                                          gdouble lat,
                                          gdouble _long_,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void basic_properties_create_place_label_finish (BasicProperties* self,
                                                 GAsyncResult* _res_);
static GType basic_properties_exif_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static BasicPropertiesExifItem* basic_properties_exif_item_new (const gchar* icon_name,
                                                         const gchar* tooltip_text,
                                                         const gchar* data);
static BasicPropertiesExifItem* basic_properties_exif_item_construct (GType object_type,
                                                               const gchar* icon_name,
                                                               const gchar* tooltip_text,
                                                               const gchar* data);
static void basic_properties_real_save_changes_to_source (Properties* base);
static void basic_properties_create_place_label_data_free (gpointer _data);
static gboolean basic_properties_create_place_label_co (BasicPropertiesCreatePlaceLabelData* _data_);
static void basic_properties_create_place_label_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static GType basic_properties_exif_item_get_type_once (void);
static void basic_properties_finalize (GObject * obj);
static GType basic_properties_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
basic_properties_get_instance_private (BasicProperties* self)
{
	return G_STRUCT_MEMBER_P (self, BasicProperties_private_offset);
}

BasicProperties*
basic_properties_construct (GType object_type)
{
	BasicProperties * self = NULL;
	self = (BasicProperties*) properties_construct (object_type);
	return self;
}

BasicProperties*
basic_properties_new (void)
{
	return basic_properties_construct (TYPE_BASIC_PROPERTIES);
}

static void
basic_properties_real_clear_properties (Properties* base)
{
	BasicProperties * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (BasicProperties*) base;
	PROPERTIES_CLASS (basic_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->camera_make);
	self->priv->camera_make = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->camera_model);
	self->priv->camera_model = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->title);
	self->priv->title = _tmp2_;
	self->priv->start_time = (gint64) 0;
	self->priv->end_time = (gint64) 0;
	dimensions_init (&self->priv->dimensions, 0, 0);
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->flash);
	self->priv->flash = _tmp3_;
	self->priv->filesize = (guint64) 0;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->focal_length);
	self->priv->focal_length = _tmp4_;
	self->priv->gps_lat = 0.0;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->gps_lat_ref);
	self->priv->gps_lat_ref = _tmp5_;
	self->priv->gps_long = 0.0;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->priv->gps_long_ref);
	self->priv->gps_long_ref = _tmp6_;
	self->priv->photo_count = -1;
	self->priv->event_count = -1;
	self->priv->video_count = -1;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->priv->exposure);
	self->priv->exposure = _tmp7_;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->priv->exposure_bias);
	self->priv->exposure_bias = _tmp8_;
	_tmp9_ = g_strdup ("");
	_g_free0 (self->priv->aperture);
	self->priv->aperture = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (self->priv->iso);
	self->priv->iso = _tmp10_;
	self->priv->clip_duration = 0.0;
	_tmp11_ = g_strdup ("");
	_g_free0 (self->priv->raw_developer);
	self->priv->raw_developer = _tmp11_;
	_tmp12_ = g_strdup ("");
	_g_free0 (self->priv->raw_assoc);
	self->priv->raw_assoc = _tmp12_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

static void
basic_properties_real_get_single_properties (Properties* base,
                                             DataView* view)
{
	BasicProperties * self;
	gboolean _tmp0_ = FALSE;
	DataSource* _tmp1_;
	DataSource* _tmp2_;
	MediaSource* source = NULL;
	DataSource* _tmp5_;
	DataSource* _tmp6_;
	MediaSource* _tmp7_;
	MediaSource* _tmp8_;
	MediaSource* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	MediaSource* _tmp12_;
	self = (BasicProperties*) base;
	g_return_if_fail (view != NULL);
	PROPERTIES_CLASS (basic_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), view);
	_tmp1_ = data_view_get_source (view);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DataSource* _tmp3_;
		DataSource* _tmp4_;
		_tmp3_ = data_view_get_source (view);
		_tmp4_ = _tmp3_;
		_tmp0_ = !IS_MEDIA_SOURCE (_tmp4_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = data_view_get_source (view);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
	source = _tmp7_;
	_tmp8_ = source;
	self->priv->filesize = media_source_get_master_filesize (_tmp8_);
	_tmp9_ = source;
	_tmp10_ = data_object_get_name ((DataObject*) _tmp9_);
	_g_free0 (self->priv->title);
	self->priv->title = _tmp10_;
	_tmp12_ = source;
	if (IS_PHOTO_SOURCE (_tmp12_)) {
		_tmp11_ = TRUE;
	} else {
		MediaSource* _tmp13_;
		_tmp13_ = source;
		_tmp11_ = IS_PHOTO_IMPORT_SOURCE (_tmp13_);
	}
	if (_tmp11_) {
		gint64 _tmp14_ = 0LL;
		MediaSource* _tmp15_;
		PhotoMetadata* _tmp18_ = NULL;
		MediaSource* _tmp19_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp24_;
		PhotoMetadata* _tmp25_;
		MediaSource* _tmp65_;
		gboolean _tmp68_ = FALSE;
		MediaSource* _tmp69_;
		_tmp15_ = source;
		if (IS_PHOTO_SOURCE (_tmp15_)) {
			MediaSource* _tmp16_;
			_tmp16_ = source;
			_tmp14_ = media_source_get_exposure_time ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO_SOURCE, PhotoSource));
		} else {
			MediaSource* _tmp17_;
			_tmp17_ = source;
			_tmp14_ = import_source_get_exposure_time ((ImportSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
		}
		self->priv->start_time = _tmp14_;
		self->priv->end_time = self->priv->start_time;
		_tmp19_ = source;
		if (IS_PHOTO_SOURCE (_tmp19_)) {
			MediaSource* _tmp20_;
			PhotoMetadata* _tmp21_;
			_tmp20_ = source;
			_tmp21_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_PHOTO_SOURCE, PhotoSource));
			_media_metadata_unref0 (_tmp18_);
			_tmp18_ = _tmp21_;
		} else {
			MediaSource* _tmp22_;
			PhotoMetadata* _tmp23_;
			_tmp22_ = source;
			_tmp23_ = photo_import_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
			_media_metadata_unref0 (_tmp18_);
			_tmp18_ = _tmp23_;
		}
		_tmp24_ = _media_metadata_ref0 (_tmp18_);
		metadata = _tmp24_;
		_tmp25_ = metadata;
		if (_tmp25_ != NULL) {
			PhotoMetadata* _tmp26_;
			gchar* _tmp27_;
			PhotoMetadata* _tmp28_;
			gchar* _tmp29_;
			PhotoMetadata* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			PhotoMetadata* _tmp34_;
			gchar* _tmp35_;
			PhotoMetadata* _tmp36_;
			gchar* _tmp37_;
			PhotoMetadata* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			PhotoMetadata* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_;
			Dimensions _tmp46_ = {0};
			PhotoMetadata* _tmp47_;
			Dimensions* _tmp48_;
			Dimensions* _tmp49_;
			gboolean _tmp50_;
			PhotoMetadata* _tmp57_;
			gchar* _tmp58_;
			PhotoMetadata* _tmp59_;
			gdouble _tmp60_ = 0.0;
			gchar* _tmp61_ = NULL;
			gdouble _tmp62_ = 0.0;
			gchar* _tmp63_ = NULL;
			gdouble _tmp64_ = 0.0;
			_tmp26_ = metadata;
			_tmp27_ = photo_metadata_get_camera_make (_tmp26_);
			_g_free0 (self->priv->camera_make);
			self->priv->camera_make = _tmp27_;
			_tmp28_ = metadata;
			_tmp29_ = photo_metadata_get_camera_model (_tmp28_);
			_g_free0 (self->priv->camera_model);
			self->priv->camera_model = _tmp29_;
			_tmp30_ = metadata;
			_tmp31_ = photo_metadata_get_exposure_string (_tmp30_);
			_g_free0 (self->priv->exposure);
			self->priv->exposure = _tmp31_;
			_tmp32_ = self->priv->exposure;
			if (_tmp32_ == NULL) {
				gchar* _tmp33_;
				_tmp33_ = g_strdup ("");
				_g_free0 (self->priv->exposure);
				self->priv->exposure = _tmp33_;
			}
			_tmp34_ = metadata;
			_tmp35_ = photo_metadata_get_exposure_bias (_tmp34_);
			_g_free0 (self->priv->exposure_bias);
			self->priv->exposure_bias = _tmp35_;
			_tmp36_ = metadata;
			_tmp37_ = photo_metadata_get_flash_string (_tmp36_);
			_g_free0 (self->priv->flash);
			self->priv->flash = _tmp37_;
			_tmp38_ = metadata;
			_tmp39_ = photo_metadata_get_aperture_string (_tmp38_, TRUE);
			_g_free0 (self->priv->aperture);
			self->priv->aperture = _tmp39_;
			_tmp40_ = self->priv->aperture;
			if (_tmp40_ == NULL) {
				gchar* _tmp41_;
				_tmp41_ = g_strdup ("");
				_g_free0 (self->priv->aperture);
				self->priv->aperture = _tmp41_;
			}
			_tmp42_ = metadata;
			_tmp43_ = photo_metadata_get_iso_string (_tmp42_);
			_g_free0 (self->priv->iso);
			self->priv->iso = _tmp43_;
			_tmp44_ = self->priv->iso;
			if (_tmp44_ == NULL) {
				gchar* _tmp45_;
				_tmp45_ = g_strdup ("");
				_g_free0 (self->priv->iso);
				self->priv->iso = _tmp45_;
			}
			_tmp47_ = metadata;
			_tmp48_ = photo_metadata_get_pixel_dimensions (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = _tmp49_ != NULL;
			_dimensions_free0 (_tmp49_);
			if (_tmp50_) {
				PhotoMetadata* _tmp51_;
				PhotoMetadata* _tmp52_;
				Dimensions* _tmp53_;
				Dimensions* _tmp54_;
				Dimensions _tmp55_;
				Dimensions _tmp56_ = {0};
				_tmp51_ = metadata;
				_tmp52_ = metadata;
				_tmp53_ = photo_metadata_get_pixel_dimensions (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = *_tmp54_;
				orientation_rotate_dimensions (photo_metadata_get_orientation (_tmp51_), &_tmp55_, &_tmp56_);
				_tmp46_ = _tmp56_;
				_dimensions_free0 (_tmp54_);
			} else {
				dimensions_init (&_tmp46_, 0, 0);
			}
			self->priv->dimensions = _tmp46_;
			_tmp57_ = metadata;
			_tmp58_ = photo_metadata_get_focal_length_string (_tmp57_);
			_g_free0 (self->priv->focal_length);
			self->priv->focal_length = _tmp58_;
			_tmp59_ = metadata;
			photo_metadata_get_gps (_tmp59_, &_tmp60_, &_tmp61_, &_tmp62_, &_tmp63_, &_tmp64_);
			self->priv->gps_long = _tmp60_;
			_g_free0 (self->priv->gps_long_ref);
			self->priv->gps_long_ref = _tmp61_;
			self->priv->gps_lat = _tmp62_;
			_g_free0 (self->priv->gps_lat_ref);
			self->priv->gps_lat_ref = _tmp63_;
			self->priv->gps_alt = _tmp64_;
		}
		_tmp65_ = source;
		if (IS_PHOTO_SOURCE (_tmp65_)) {
			MediaSource* _tmp66_;
			Dimensions _tmp67_ = {0};
			_tmp66_ = source;
			media_source_get_dimensions ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_PHOTO_SOURCE, PhotoSource), PHOTO_EXCEPTION_NONE, &_tmp67_);
			self->priv->dimensions = _tmp67_;
		}
		_tmp69_ = source;
		if (IS_PHOTO (_tmp69_)) {
			MediaSource* _tmp70_;
			_tmp70_ = source;
			_tmp68_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_RAW;
		} else {
			_tmp68_ = FALSE;
		}
		if (_tmp68_) {
			Photo* photo = NULL;
			MediaSource* _tmp71_;
			Photo* _tmp72_;
			Photo* _tmp73_;
			gchar* _tmp74_;
			const gchar* _tmp75_ = NULL;
			Photo* _tmp76_;
			gchar* _tmp77_;
			_tmp71_ = source;
			_tmp72_ = _g_object_ref0 (IS_PHOTO (_tmp71_) ? ((Photo*) _tmp71_) : NULL);
			photo = _tmp72_;
			_tmp73_ = photo;
			_tmp74_ = raw_developer_get_label (photo_get_raw_developer (_tmp73_));
			_g_free0 (self->priv->raw_developer);
			self->priv->raw_developer = _tmp74_;
			_tmp76_ = photo;
			if (photo_is_raw_developer_available (_tmp76_, RAW_DEVELOPER_CAMERA)) {
				_tmp75_ = _ ("RAW+JPEG");
			} else {
				_tmp75_ = "";
			}
			_tmp77_ = g_strdup (_tmp75_);
			_g_free0 (self->priv->raw_assoc);
			self->priv->raw_assoc = _tmp77_;
			_g_object_unref0 (photo);
		}
		_media_metadata_unref0 (metadata);
		_media_metadata_unref0 (_tmp18_);
	} else {
		MediaSource* _tmp78_;
		_tmp78_ = source;
		if (IS_EVENT_SOURCE (_tmp78_)) {
			EventSource* event_source = NULL;
			MediaSource* _tmp79_;
			EventSource* _tmp80_;
			EventSource* _tmp81_;
			EventSource* _tmp82_;
			gint event_photo_count = 0;
			gint event_video_count = 0;
			EventSource* _tmp83_;
			GeeCollection* _tmp84_;
			GeeCollection* _tmp85_;
			gint _tmp86_ = 0;
			gint _tmp87_ = 0;
			_tmp79_ = source;
			_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_EVENT_SOURCE, EventSource));
			event_source = _tmp80_;
			_tmp81_ = event_source;
			self->priv->start_time = event_source_get_start_time (_tmp81_);
			_tmp82_ = event_source;
			self->priv->end_time = event_source_get_end_time (_tmp82_);
			_tmp83_ = event_source;
			_tmp84_ = event_source_get_media (_tmp83_);
			_tmp85_ = _tmp84_;
			media_source_collection_count_media (_tmp85_, &_tmp86_, &_tmp87_);
			event_photo_count = _tmp86_;
			event_video_count = _tmp87_;
			_g_object_unref0 (_tmp85_);
			self->priv->photo_count = event_photo_count;
			self->priv->video_count = event_video_count;
			_g_object_unref0 (event_source);
		} else {
			gboolean _tmp88_ = FALSE;
			MediaSource* _tmp89_;
			_tmp89_ = source;
			if (IS_VIDEO_SOURCE (_tmp89_)) {
				_tmp88_ = TRUE;
			} else {
				MediaSource* _tmp90_;
				_tmp90_ = source;
				_tmp88_ = IS_VIDEO_IMPORT_SOURCE (_tmp90_);
			}
			if (_tmp88_) {
				MediaSource* _tmp91_;
				_tmp91_ = source;
				if (IS_VIDEO_SOURCE (_tmp91_)) {
					Video* video = NULL;
					MediaSource* _tmp92_;
					Video* _tmp93_;
					Video* _tmp94_;
					Video* _tmp95_;
					Video* _tmp98_;
					_tmp92_ = source;
					_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, TYPE_VIDEO, Video));
					video = _tmp93_;
					_tmp94_ = video;
					self->priv->clip_duration = video_get_clip_duration (_tmp94_);
					_tmp95_ = video;
					if (video_get_is_interpretable (_tmp95_)) {
						Video* _tmp96_;
						Dimensions _tmp97_ = {0};
						_tmp96_ = video;
						video_get_frame_dimensions (_tmp96_, &_tmp97_);
						self->priv->dimensions = _tmp97_;
					}
					_tmp98_ = video;
					self->priv->start_time = media_source_get_exposure_time ((MediaSource*) _tmp98_);
					_g_object_unref0 (video);
				} else {
					MediaSource* _tmp99_;
					_tmp99_ = source;
					self->priv->start_time = import_source_get_exposure_time ((ImportSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource));
				}
				self->priv->end_time = self->priv->start_time;
			}
		}
	}
	_g_object_unref0 (source);
}

static void
basic_properties_real_get_multiple_properties (Properties* base,
                                               GeeIterable* iter)
{
	BasicProperties * self;
	self = (BasicProperties*) base;
	PROPERTIES_CLASS (basic_properties_parent_class)->get_multiple_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), iter);
	self->priv->photo_count = 0;
	self->priv->video_count = 0;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (iter);
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataSource* source = NULL;
			DataView* _tmp4_;
			DataSource* _tmp5_;
			DataSource* _tmp6_;
			DataSource* _tmp7_;
			gboolean _tmp8_ = FALSE;
			DataSource* _tmp9_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			_tmp5_ = data_view_get_source (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			source = _tmp7_;
			_tmp9_ = source;
			if (IS_PHOTO_SOURCE (_tmp9_)) {
				_tmp8_ = TRUE;
			} else {
				DataSource* _tmp10_;
				_tmp10_ = source;
				_tmp8_ = IS_PHOTO_IMPORT_SOURCE (_tmp10_);
			}
			if (_tmp8_) {
				gint64 _tmp11_ = 0LL;
				DataSource* _tmp12_;
				gint64 exposure_time = 0LL;
				gint _tmp17_;
				_tmp12_ = source;
				if (IS_PHOTO_SOURCE (_tmp12_)) {
					DataSource* _tmp13_;
					_tmp13_ = source;
					_tmp11_ = media_source_get_exposure_time ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_SOURCE, PhotoSource));
				} else {
					DataSource* _tmp14_;
					_tmp14_ = source;
					_tmp11_ = import_source_get_exposure_time ((ImportSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
				}
				exposure_time = _tmp11_;
				if (exposure_time != ((gint64) 0)) {
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					if (self->priv->start_time == ((gint64) 0)) {
						_tmp15_ = TRUE;
					} else {
						_tmp15_ = exposure_time < self->priv->start_time;
					}
					if (_tmp15_) {
						self->priv->start_time = exposure_time;
					}
					if (self->priv->end_time == ((gint64) 0)) {
						_tmp16_ = TRUE;
					} else {
						_tmp16_ = exposure_time > self->priv->end_time;
					}
					if (_tmp16_) {
						self->priv->end_time = exposure_time;
					}
				}
				_tmp17_ = self->priv->photo_count;
				self->priv->photo_count = _tmp17_ + 1;
			} else {
				DataSource* _tmp18_;
				_tmp18_ = source;
				if (IS_EVENT_SOURCE (_tmp18_)) {
					EventSource* event_source = NULL;
					DataSource* _tmp19_;
					EventSource* _tmp20_;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					gint event_photo_count = 0;
					gint event_video_count = 0;
					EventSource* _tmp34_;
					GeeCollection* _tmp35_;
					GeeCollection* _tmp36_;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_;
					_tmp19_ = source;
					_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_EVENT_SOURCE, EventSource));
					event_source = _tmp20_;
					if (self->priv->event_count == -1) {
						self->priv->event_count = 0;
					}
					if (self->priv->start_time == ((gint64) 0)) {
						_tmp22_ = TRUE;
					} else {
						EventSource* _tmp23_;
						_tmp23_ = event_source;
						_tmp22_ = event_source_get_start_time (_tmp23_) < self->priv->start_time;
					}
					if (_tmp22_) {
						EventSource* _tmp24_;
						_tmp24_ = event_source;
						_tmp21_ = event_source_get_start_time (_tmp24_) != ((gint64) 0);
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						EventSource* _tmp25_;
						_tmp25_ = event_source;
						self->priv->start_time = event_source_get_start_time (_tmp25_);
					}
					if (self->priv->end_time == ((gint64) 0)) {
						_tmp27_ = TRUE;
					} else {
						EventSource* _tmp28_;
						_tmp28_ = event_source;
						_tmp27_ = event_source_get_end_time (_tmp28_) > self->priv->end_time;
					}
					if (_tmp27_) {
						EventSource* _tmp29_;
						_tmp29_ = event_source;
						_tmp26_ = event_source_get_end_time (_tmp29_) != ((gint64) 0);
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						EventSource* _tmp30_;
						_tmp30_ = event_source;
						self->priv->end_time = event_source_get_end_time (_tmp30_);
					} else {
						gboolean _tmp31_ = FALSE;
						if (self->priv->end_time == ((gint64) 0)) {
							_tmp31_ = TRUE;
						} else {
							EventSource* _tmp32_;
							_tmp32_ = event_source;
							_tmp31_ = event_source_get_start_time (_tmp32_) > self->priv->end_time;
						}
						if (_tmp31_) {
							EventSource* _tmp33_;
							_tmp33_ = event_source;
							self->priv->end_time = event_source_get_start_time (_tmp33_);
						}
					}
					_tmp34_ = event_source;
					_tmp35_ = event_source_get_media (_tmp34_);
					_tmp36_ = _tmp35_;
					media_source_collection_count_media (_tmp36_, &_tmp37_, &_tmp38_);
					event_photo_count = _tmp37_;
					event_video_count = _tmp38_;
					_g_object_unref0 (_tmp36_);
					self->priv->photo_count = self->priv->photo_count + event_photo_count;
					self->priv->video_count = self->priv->video_count + event_video_count;
					_tmp39_ = self->priv->event_count;
					self->priv->event_count = _tmp39_ + 1;
					_g_object_unref0 (event_source);
				} else {
					gboolean _tmp40_ = FALSE;
					DataSource* _tmp41_;
					_tmp41_ = source;
					if (IS_VIDEO_SOURCE (_tmp41_)) {
						_tmp40_ = TRUE;
					} else {
						DataSource* _tmp42_;
						_tmp42_ = source;
						_tmp40_ = IS_VIDEO_IMPORT_SOURCE (_tmp42_);
					}
					if (_tmp40_) {
						gint64 _tmp43_ = 0LL;
						DataSource* _tmp44_;
						gint64 exposure_time = 0LL;
						gint _tmp49_;
						_tmp44_ = source;
						if (IS_VIDEO_SOURCE (_tmp44_)) {
							DataSource* _tmp45_;
							_tmp45_ = source;
							_tmp43_ = media_source_get_exposure_time ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_VIDEO_SOURCE, VideoSource));
						} else {
							DataSource* _tmp46_;
							_tmp46_ = source;
							_tmp43_ = import_source_get_exposure_time ((ImportSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource));
						}
						exposure_time = _tmp43_;
						if (exposure_time != ((gint64) 0)) {
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							if (self->priv->start_time == ((gint64) 0)) {
								_tmp47_ = TRUE;
							} else {
								_tmp47_ = exposure_time < self->priv->start_time;
							}
							if (_tmp47_) {
								self->priv->start_time = exposure_time;
							}
							if (self->priv->end_time == ((gint64) 0)) {
								_tmp48_ = TRUE;
							} else {
								_tmp48_ = exposure_time > self->priv->end_time;
							}
							if (_tmp48_) {
								self->priv->end_time = exposure_time;
							}
						}
						_tmp49_ = self->priv->video_count;
						self->priv->video_count = _tmp49_ + 1;
					}
				}
			}
			_g_object_unref0 (source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
}

static void
basic_properties_real_get_properties (Properties* base,
                                      Page* current_page)
{
	BasicProperties * self;
	self = (BasicProperties*) base;
	g_return_if_fail (current_page != NULL);
	PROPERTIES_CLASS (basic_properties_parent_class)->get_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), current_page);
	if (self->priv->end_time == ((gint64) 0)) {
		self->priv->end_time = self->priv->start_time;
	}
	if (self->priv->start_time == ((gint64) 0)) {
		self->priv->start_time = self->priv->end_time;
	}
}

static void
_basic_properties_title_entry_changed_editable_title_changed (EditableTitle* _sender,
                                                              const gchar* new_title,
                                                              gpointer self)
{
	basic_properties_title_entry_changed ((BasicProperties*) self);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
basic_properties_real_internal_update_properties (Properties* base,
                                                  Page* page)
{
	BasicProperties * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_;
	gboolean _tmp71_ = FALSE;
	const gchar* _tmp72_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	const gchar* _tmp78_;
	GtkFlowBox* flowbox = NULL;
	GtkFlowBox* _tmp95_;
	GtkFlowBox* _tmp96_;
	GtkFlowBox* _tmp97_;
	GtkFlowBox* _tmp98_;
	GtkFlowBox* _tmp99_;
	GtkFlowBox* _tmp100_;
	GtkFlowBox* _tmp101_;
	gboolean _tmp102_ = FALSE;
	const gchar* _tmp103_;
	gboolean _tmp109_ = FALSE;
	const gchar* _tmp110_;
	gboolean _tmp116_ = FALSE;
	const gchar* _tmp117_;
	gboolean _tmp123_ = FALSE;
	const gchar* _tmp124_;
	gboolean _tmp130_ = FALSE;
	const gchar* _tmp131_;
	gboolean _tmp137_ = FALSE;
	const gchar* _tmp138_;
	self = (BasicProperties*) base;
	g_return_if_fail (page != NULL);
	PROPERTIES_CLASS (basic_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), page);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->title;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		EditableTitle* _tmp4_;
		EditableTitle* _tmp5_;
		EditableTitle* _tmp6_;
		EditableTitle* _tmp7_;
		guint _tmp8_;
		_tmp3_ = self->priv->title;
		_tmp4_ = editable_title_new (_tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->title_entry);
		self->priv->title_entry = _tmp4_;
		_tmp5_ = self->priv->title_entry;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Title"));
		_tmp6_ = self->priv->title_entry;
		g_signal_connect_object (_tmp6_, "changed", (GCallback) _basic_properties_title_entry_changed_editable_title_changed, self, 0);
		_tmp7_ = self->priv->title_entry;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, 0, 2, 1);
		_tmp8_ = ((Properties*) self)->line_count;
		((Properties*) self)->line_count = _tmp8_ + 1;
	}
	if (self->priv->photo_count >= 0) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = self->priv->video_count >= 0;
	}
	if (_tmp9_) {
		PropertiesHeader* label = NULL;
		PropertiesHeader* _tmp10_;
		PropertiesHeader* _tmp11_;
		_tmp10_ = properties_header_new (_ ("Items:"));
		g_object_ref_sink (_tmp10_);
		label = _tmp10_;
		_tmp11_ = label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp11_, 0, (gint) ((Properties*) self)->line_count, 1, 1);
		if (self->priv->event_count >= 0) {
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = g_strdup_printf (ngettext ("%d Event", "%d Events", (gulong) self->priv->event_count), self->priv->event_count);
			_tmp13_ = _tmp12_;
			basic_properties_attach_item_count_label (self, _tmp13_);
			_g_free0 (_tmp13_);
		}
		if (self->priv->photo_count > 0) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) self->priv->photo_count), self->priv->photo_count);
			_tmp15_ = _tmp14_;
			basic_properties_attach_item_count_label (self, _tmp15_);
			_g_free0 (_tmp15_);
		}
		if (self->priv->video_count > 0) {
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) self->priv->video_count), self->priv->video_count);
			_tmp17_ = _tmp16_;
			basic_properties_attach_item_count_label (self, _tmp17_);
			_g_free0 (_tmp17_);
		}
		_g_object_unref0 (label);
	}
	if (self->priv->start_time != ((gint64) 0)) {
		GDateTime* start_dt = NULL;
		GDateTime* _tmp18_;
		gchar* start_date = NULL;
		GDateTime* _tmp19_;
		gchar* _tmp20_;
		gchar* start_time = NULL;
		GDateTime* _tmp21_;
		gchar* _tmp22_;
		GDateTime* end_dt = NULL;
		GDateTime* _tmp23_;
		gchar* end_date = NULL;
		GDateTime* _tmp24_;
		gchar* _tmp25_;
		gchar* end_time = NULL;
		GDateTime* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp18_ = g_date_time_new_from_unix_local (self->priv->start_time);
		start_dt = _tmp18_;
		_tmp19_ = start_dt;
		_tmp20_ = properties_get_prettyprint_date ((Properties*) self, _tmp19_);
		start_date = _tmp20_;
		_tmp21_ = start_dt;
		_tmp22_ = properties_get_prettyprint_time ((Properties*) self, _tmp21_);
		start_time = _tmp22_;
		_tmp23_ = g_date_time_new_from_unix_local (self->priv->end_time);
		end_dt = _tmp23_;
		_tmp24_ = end_dt;
		_tmp25_ = properties_get_prettyprint_date ((Properties*) self, _tmp24_);
		end_date = _tmp25_;
		_tmp26_ = end_dt;
		_tmp27_ = properties_get_prettyprint_time ((Properties*) self, _tmp26_);
		end_time = _tmp27_;
		_tmp28_ = start_date;
		_tmp29_ = end_date;
		if (g_strcmp0 (_tmp28_, _tmp29_) == 0) {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = start_time;
			_tmp31_ = end_time;
			if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
				PropertiesLabel* datetime_label = NULL;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				PropertiesLabel* _tmp36_;
				PropertiesLabel* _tmp37_;
				PropertiesLabel* _tmp38_;
				guint _tmp39_;
				_tmp32_ = start_date;
				_tmp33_ = start_time;
				_tmp34_ = g_strdup_printf ("%s at %s", _tmp32_, _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = properties_label_new (_tmp35_);
				g_object_ref_sink (_tmp36_);
				_tmp37_ = _tmp36_;
				_g_free0 (_tmp35_);
				datetime_label = _tmp37_;
				_tmp38_ = datetime_label;
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp38_, 0, (gint) ((Properties*) self)->line_count, 2, 1);
				_tmp39_ = ((Properties*) self)->line_count;
				((Properties*) self)->line_count = _tmp39_ + 1;
				_g_object_unref0 (datetime_label);
			} else {
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = start_date;
				properties_add_line ((Properties*) self, _ ("Date:"), _tmp40_);
				_tmp41_ = start_time;
				properties_add_line ((Properties*) self, _ ("From:"), _tmp41_);
				_tmp42_ = end_time;
				properties_add_line ((Properties*) self, _ ("To:"), _tmp42_);
			}
		} else {
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			_tmp43_ = start_date;
			properties_add_line ((Properties*) self, _ ("From:"), _tmp43_);
			_tmp44_ = end_date;
			properties_add_line ((Properties*) self, _ ("To:"), _tmp44_);
		}
		_g_free0 (end_time);
		_g_free0 (end_date);
		_g_date_time_unref0 (end_dt);
		_g_free0 (start_time);
		_g_free0 (start_date);
		_g_date_time_unref0 (start_dt);
	}
	if (self->priv->gps_lat != 0.0) {
		_tmp45_ = self->priv->gps_long != 0.0;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		PropertiesLabel* _tmp46_;
		PropertiesLabel* _tmp47_;
		PropertiesLabel* _tmp48_;
		PropertiesLabel* _tmp49_;
		guint _tmp50_;
		_tmp46_ = properties_label_new ("");
		g_object_ref_sink (_tmp46_);
		_g_object_unref0 (self->priv->place_label);
		self->priv->place_label = _tmp46_;
		_tmp47_ = self->priv->place_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp47_, TRUE);
		_tmp48_ = self->priv->place_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp48_, FALSE);
		basic_properties_create_place_label (self, self->priv->gps_lat, self->priv->gps_long, NULL, NULL);
		_tmp49_ = self->priv->place_label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp49_, 0, (gint) ((Properties*) self)->line_count, 2, 1);
		_tmp50_ = ((Properties*) self)->line_count;
		((Properties*) self)->line_count = _tmp50_ + 1;
	}
	if (dimensions_has_area (&self->priv->dimensions)) {
		PropertiesLabel* size_label = NULL;
		gchar* _tmp51_;
		gchar* _tmp52_;
		Dimensions _tmp53_;
		Dimensions _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		PropertiesLabel* _tmp57_;
		PropertiesLabel* _tmp58_;
		PropertiesLabel* _tmp59_;
		guint _tmp60_;
		_tmp51_ = g_format_size_full ((guint64) ((gint64) self->priv->filesize), G_FORMAT_SIZE_DEFAULT);
		_tmp52_ = _tmp51_;
		_tmp53_ = self->priv->dimensions;
		_tmp54_ = self->priv->dimensions;
		_tmp55_ = g_strdup_printf ("%s — %d &#215; %d", _tmp52_, _tmp53_.width, _tmp54_.height);
		_tmp56_ = _tmp55_;
		_tmp57_ = properties_label_new (_tmp56_);
		g_object_ref_sink (_tmp57_);
		_tmp58_ = _tmp57_;
		_g_free0 (_tmp56_);
		_g_free0 (_tmp52_);
		size_label = _tmp58_;
		_tmp59_ = size_label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp59_, 0, (gint) ((Properties*) self)->line_count, 2, 1);
		_tmp60_ = ((Properties*) self)->line_count;
		((Properties*) self)->line_count = _tmp60_ + 1;
		_g_object_unref0 (size_label);
	}
	if (self->priv->clip_duration > 0.0) {
		PropertiesLabel* duration_label = NULL;
		gchar* _tmp61_;
		gchar* _tmp62_;
		PropertiesLabel* _tmp63_;
		PropertiesLabel* _tmp64_;
		PropertiesLabel* _tmp65_;
		guint _tmp66_;
		_tmp61_ = g_strdup_printf (ngettext ("%.1f second", "%.1f seconds", (gulong) self->priv->clip_duration), self->priv->clip_duration);
		_tmp62_ = _tmp61_;
		_tmp63_ = properties_label_new (_tmp62_);
		g_object_ref_sink (_tmp63_);
		_tmp64_ = _tmp63_;
		_g_free0 (_tmp62_);
		duration_label = _tmp64_;
		_tmp65_ = duration_label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp65_, 0, (gint) ((Properties*) self)->line_count, 2, 1);
		_tmp66_ = ((Properties*) self)->line_count;
		((Properties*) self)->line_count = _tmp66_ + 1;
		_g_object_unref0 (duration_label);
	}
	_tmp68_ = self->priv->raw_developer;
	if (_tmp68_ != NULL) {
		const gchar* _tmp69_;
		_tmp69_ = self->priv->raw_developer;
		_tmp67_ = g_strcmp0 (_tmp69_, "") != 0;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		const gchar* _tmp70_;
		_tmp70_ = self->priv->raw_developer;
		properties_add_line ((Properties*) self, _ ("Developer:"), _tmp70_);
	}
	_tmp72_ = self->priv->raw_assoc;
	if (_tmp72_ != NULL) {
		const gchar* _tmp73_;
		_tmp73_ = self->priv->raw_assoc;
		_tmp71_ = g_strcmp0 (_tmp73_, "") != 0;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		const gchar* _tmp74_;
		_tmp74_ = self->priv->raw_assoc;
		properties_add_line ((Properties*) self, "", _tmp74_);
	}
	_tmp78_ = self->priv->camera_make;
	if (_tmp78_ != NULL) {
		const gchar* _tmp79_;
		_tmp79_ = self->priv->camera_make;
		_tmp77_ = g_strcmp0 (_tmp79_, "") != 0;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		const gchar* _tmp80_;
		_tmp80_ = self->priv->camera_model;
		_tmp76_ = _tmp80_ != NULL;
	} else {
		_tmp76_ = FALSE;
	}
	if (_tmp76_) {
		const gchar* _tmp81_;
		_tmp81_ = self->priv->camera_model;
		_tmp75_ = g_strcmp0 (_tmp81_, "") != 0;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		gchar* camera_string = NULL;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		PropertiesLabel* camera_label = NULL;
		const gchar* _tmp91_;
		PropertiesLabel* _tmp92_;
		PropertiesLabel* _tmp93_;
		PropertiesLabel* _tmp94_;
		_tmp82_ = self->priv->camera_model;
		_tmp83_ = self->priv->camera_make;
		if (string_contains (_tmp82_, _tmp83_)) {
			const gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp84_ = self->priv->camera_model;
			_tmp85_ = g_strdup (_tmp84_);
			_g_free0 (camera_string);
			camera_string = _tmp85_;
		} else {
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			_tmp86_ = self->priv->camera_make;
			_tmp87_ = g_strconcat (_tmp86_, " ", NULL);
			_tmp88_ = _tmp87_;
			_tmp89_ = self->priv->camera_model;
			_tmp90_ = g_strconcat (_tmp88_, _tmp89_, NULL);
			_g_free0 (camera_string);
			camera_string = _tmp90_;
			_g_free0 (_tmp88_);
		}
		_tmp91_ = camera_string;
		_tmp92_ = properties_label_new (_tmp91_);
		g_object_ref_sink (_tmp92_);
		camera_label = _tmp92_;
		_tmp93_ = camera_label;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp93_, 12);
		_tmp94_ = camera_label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp94_, 0, 8, 2, 1);
		_g_object_unref0 (camera_label);
		_g_free0 (camera_string);
	}
	_tmp95_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp95_);
	flowbox = _tmp95_;
	_tmp96_ = flowbox;
	gtk_flow_box_set_column_spacing (_tmp96_, (guint) 12);
	_tmp97_ = flowbox;
	gtk_flow_box_set_row_spacing (_tmp97_, (guint) 12);
	_tmp98_ = flowbox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp98_, TRUE);
	_tmp99_ = flowbox;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp99_, 12);
	_tmp100_ = flowbox;
	gtk_flow_box_set_selection_mode (_tmp100_, GTK_SELECTION_NONE);
	_tmp101_ = flowbox;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp101_, 0, 9, 2, 1);
	_tmp103_ = self->priv->aperture;
	if (_tmp103_ != NULL) {
		const gchar* _tmp104_;
		_tmp104_ = self->priv->aperture;
		_tmp102_ = g_strcmp0 (_tmp104_, "") != 0;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		BasicPropertiesExifItem* aperture_item = NULL;
		const gchar* _tmp105_;
		BasicPropertiesExifItem* _tmp106_;
		GtkFlowBox* _tmp107_;
		BasicPropertiesExifItem* _tmp108_;
		_tmp105_ = self->priv->aperture;
		_tmp106_ = basic_properties_exif_item_new ("aperture-symbolic", _ ("Aperture"), _tmp105_);
		g_object_ref_sink (_tmp106_);
		aperture_item = _tmp106_;
		_tmp107_ = flowbox;
		_tmp108_ = aperture_item;
		gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
		_g_object_unref0 (aperture_item);
	}
	_tmp110_ = self->priv->focal_length;
	if (_tmp110_ != NULL) {
		const gchar* _tmp111_;
		_tmp111_ = self->priv->focal_length;
		_tmp109_ = g_strcmp0 (_tmp111_, "") != 0;
	} else {
		_tmp109_ = FALSE;
	}
	if (_tmp109_) {
		BasicPropertiesExifItem* focal_length_item = NULL;
		const gchar* _tmp112_;
		BasicPropertiesExifItem* _tmp113_;
		GtkFlowBox* _tmp114_;
		BasicPropertiesExifItem* _tmp115_;
		_tmp112_ = self->priv->focal_length;
		_tmp113_ = basic_properties_exif_item_new ("focal-length-symbolic", _ ("Focal length"), _tmp112_);
		g_object_ref_sink (_tmp113_);
		focal_length_item = _tmp113_;
		_tmp114_ = flowbox;
		_tmp115_ = focal_length_item;
		gtk_container_add ((GtkContainer*) _tmp114_, (GtkWidget*) _tmp115_);
		_g_object_unref0 (focal_length_item);
	}
	_tmp117_ = self->priv->exposure;
	if (_tmp117_ != NULL) {
		const gchar* _tmp118_;
		_tmp118_ = self->priv->exposure;
		_tmp116_ = g_strcmp0 (_tmp118_, "") != 0;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		BasicPropertiesExifItem* exposure_item = NULL;
		const gchar* _tmp119_;
		BasicPropertiesExifItem* _tmp120_;
		GtkFlowBox* _tmp121_;
		BasicPropertiesExifItem* _tmp122_;
		_tmp119_ = self->priv->exposure;
		_tmp120_ = basic_properties_exif_item_new ("exposure-symbolic", _ ("Exposure"), _tmp119_);
		g_object_ref_sink (_tmp120_);
		exposure_item = _tmp120_;
		_tmp121_ = flowbox;
		_tmp122_ = exposure_item;
		gtk_container_add ((GtkContainer*) _tmp121_, (GtkWidget*) _tmp122_);
		_g_object_unref0 (exposure_item);
	}
	_tmp124_ = self->priv->iso;
	if (_tmp124_ != NULL) {
		const gchar* _tmp125_;
		_tmp125_ = self->priv->iso;
		_tmp123_ = g_strcmp0 (_tmp125_, "") != 0;
	} else {
		_tmp123_ = FALSE;
	}
	if (_tmp123_) {
		BasicPropertiesExifItem* iso_item = NULL;
		const gchar* _tmp126_;
		BasicPropertiesExifItem* _tmp127_;
		GtkFlowBox* _tmp128_;
		BasicPropertiesExifItem* _tmp129_;
		_tmp126_ = self->priv->iso;
		_tmp127_ = basic_properties_exif_item_new ("iso-symbolic", _ ("ISO"), _tmp126_);
		g_object_ref_sink (_tmp127_);
		iso_item = _tmp127_;
		_tmp128_ = flowbox;
		_tmp129_ = iso_item;
		gtk_container_add ((GtkContainer*) _tmp128_, (GtkWidget*) _tmp129_);
		_g_object_unref0 (iso_item);
	}
	_tmp131_ = self->priv->exposure_bias;
	if (_tmp131_ != NULL) {
		const gchar* _tmp132_;
		_tmp132_ = self->priv->exposure_bias;
		_tmp130_ = g_strcmp0 (_tmp132_, "") != 0;
	} else {
		_tmp130_ = FALSE;
	}
	if (_tmp130_) {
		BasicPropertiesExifItem* exposure_bias_item = NULL;
		const gchar* _tmp133_;
		BasicPropertiesExifItem* _tmp134_;
		GtkFlowBox* _tmp135_;
		BasicPropertiesExifItem* _tmp136_;
		_tmp133_ = self->priv->exposure_bias;
		_tmp134_ = basic_properties_exif_item_new ("exposure-bias-symbolic", _ ("Exposure bias"), _tmp133_);
		g_object_ref_sink (_tmp134_);
		exposure_bias_item = _tmp134_;
		_tmp135_ = flowbox;
		_tmp136_ = exposure_bias_item;
		gtk_container_add ((GtkContainer*) _tmp135_, (GtkWidget*) _tmp136_);
		_g_object_unref0 (exposure_bias_item);
	}
	_tmp138_ = self->priv->flash;
	if (_tmp138_ != NULL) {
		const gchar* _tmp139_;
		_tmp139_ = self->priv->flash;
		_tmp137_ = g_strcmp0 (_tmp139_, "") != 0;
	} else {
		_tmp137_ = FALSE;
	}
	if (_tmp137_) {
		BasicPropertiesExifItem* flash_item = NULL;
		const gchar* _tmp140_;
		BasicPropertiesExifItem* _tmp141_;
		GtkFlowBox* _tmp142_;
		BasicPropertiesExifItem* _tmp143_;
		_tmp140_ = self->priv->flash;
		_tmp141_ = basic_properties_exif_item_new ("flash-symbolic", _ ("Flash"), _tmp140_);
		g_object_ref_sink (_tmp141_);
		flash_item = _tmp141_;
		_tmp142_ = flowbox;
		_tmp143_ = flash_item;
		gtk_container_add ((GtkContainer*) _tmp142_, (GtkWidget*) _tmp143_);
		_g_object_unref0 (flash_item);
	}
	_g_object_unref0 (flowbox);
}

static void
basic_properties_real_save_changes_to_source (Properties* base)
{
	BasicProperties * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MediaSource* _tmp2_;
	self = (BasicProperties*) base;
	_tmp2_ = self->priv->source;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->title;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		MediaSource* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->title;
		_tmp5_ = self->priv->source;
		_tmp6_ = data_object_get_name ((DataObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp7_) != 0;
		_g_free0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CommandManager* _tmp8_;
		CommandManager* _tmp9_;
		MediaSource* _tmp10_;
		const gchar* _tmp11_;
		EditTitleCommand* _tmp12_;
		EditTitleCommand* _tmp13_;
		_tmp8_ = app_window_get_command_manager ();
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->source;
		_tmp11_ = self->priv->title;
		_tmp12_ = edit_title_command_new (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		command_manager_execute (_tmp9_, (Command*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		_command_manager_unref0 (_tmp9_);
	}
}

static void
basic_properties_create_place_label_data_free (gpointer _data)
{
	BasicPropertiesCreatePlaceLabelData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BasicPropertiesCreatePlaceLabelData, _data_);
}

static void
basic_properties_create_place_label (BasicProperties* self,
                                     gdouble lat,
                                     gdouble _long_,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BasicPropertiesCreatePlaceLabelData* _data_;
	BasicProperties* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BasicPropertiesCreatePlaceLabelData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, basic_properties_create_place_label_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->lat = lat;
	_data_->_long_ = _long_;
	basic_properties_create_place_label_co (_data_);
}

static void
basic_properties_create_place_label_finish (BasicProperties* self,
                                            GAsyncResult* _res_)
{
	BasicPropertiesCreatePlaceLabelData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
basic_properties_create_place_label_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	BasicPropertiesCreatePlaceLabelData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	basic_properties_create_place_label_co (_data_);
}

static gboolean
basic_properties_create_place_label_co (BasicPropertiesCreatePlaceLabelData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geocode_location_new (_data_->lat, _data_->_long_, (gdouble) GEOCODE_LOCATION_ACCURACY_UNKNOWN);
	_data_->location = _data_->_tmp0_;
	_data_->_tmp1_ = geocode_reverse_new_for_location (_data_->location);
	_data_->reverse = _data_->_tmp1_;
	{
		_data_->_state_ = 1;
		geocode_reverse_resolve_async (_data_->reverse, NULL, basic_properties_create_place_label_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = geocode_reverse_resolve_finish (_data_->reverse, _data_->_res_, &_data_->_inner_error0_);
		_data_->place = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = geocode_place_get_state (_data_->place);
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = geocode_place_get_town (_data_->place);
			if (_data_->_tmp4_ != NULL) {
				_data_->_tmp5_ = _data_->self->priv->place_label;
				_data_->_tmp6_ = geocode_place_get_town (_data_->place);
				_data_->_tmp7_ = g_strconcat (_data_->_tmp6_, ", ", NULL);
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = geocode_place_get_state (_data_->place);
				_data_->_tmp10_ = g_strconcat (_data_->_tmp8_, _data_->_tmp9_, NULL);
				_data_->_tmp11_ = _data_->_tmp10_;
				gtk_label_set_label ((GtkLabel*) _data_->_tmp5_, _data_->_tmp11_);
				_g_free0 (_data_->_tmp11_);
				_g_free0 (_data_->_tmp8_);
			} else {
				_data_->_tmp12_ = geocode_place_get_county (_data_->place);
				if (_data_->_tmp12_ != NULL) {
					_data_->_tmp13_ = _data_->self->priv->place_label;
					_data_->_tmp14_ = geocode_place_get_county (_data_->place);
					_data_->_tmp15_ = g_strconcat (_data_->_tmp14_, ", ", NULL);
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp17_ = geocode_place_get_state (_data_->place);
					_data_->_tmp18_ = g_strconcat (_data_->_tmp16_, _data_->_tmp17_, NULL);
					_data_->_tmp19_ = _data_->_tmp18_;
					gtk_label_set_label ((GtkLabel*) _data_->_tmp13_, _data_->_tmp19_);
					_g_free0 (_data_->_tmp19_);
					_g_free0 (_data_->_tmp16_);
				} else {
					_data_->_tmp20_ = _data_->self->priv->place_label;
					_data_->_tmp21_ = geocode_place_get_state (_data_->place);
					_data_->_tmp22_ = g_strconcat (_data_->_tmp21_, ", ", NULL);
					_data_->_tmp23_ = _data_->_tmp22_;
					_data_->_tmp24_ = geocode_place_get_country (_data_->place);
					_data_->_tmp25_ = g_strconcat (_data_->_tmp23_, _data_->_tmp24_, NULL);
					_data_->_tmp26_ = _data_->_tmp25_;
					gtk_label_set_label ((GtkLabel*) _data_->_tmp20_, _data_->_tmp26_);
					_g_free0 (_data_->_tmp26_);
					_g_free0 (_data_->_tmp23_);
				}
			}
			_data_->_tmp27_ = _data_->self->priv->place_label;
			gtk_widget_set_no_show_all ((GtkWidget*) _data_->_tmp27_, FALSE);
			_data_->_tmp28_ = _data_->self->priv->place_label;
			gtk_widget_set_visible ((GtkWidget*) _data_->_tmp28_, TRUE);
		}
		_g_object_unref0 (_data_->place);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp29_ = _data_->e;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning ("BasicProperties.vala:409: Failed to obtain place for %f, %f: %s", _data_->lat, _data_->_long_, _data_->_tmp30_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->reverse);
		_g_object_unref0 (_data_->location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->reverse);
	_g_object_unref0 (_data_->location);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
basic_properties_title_entry_changed (BasicProperties* self)
{
	EditableTitle* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_entry;
	_tmp1_ = editable_title_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->title);
	self->priv->title = _tmp3_;
}

static void
basic_properties_attach_item_count_label (BasicProperties* self,
                                          const gchar* text)
{
	PropertiesLabel* label = NULL;
	PropertiesLabel* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = properties_label_new (text);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) label, 1, (gint) ((Properties*) self)->line_count, 1, 1);
	_tmp1_ = ((Properties*) self)->line_count;
	((Properties*) self)->line_count = _tmp1_ + 1;
	_g_object_unref0 (label);
}

static BasicPropertiesExifItem*
basic_properties_exif_item_construct (GType object_type,
                                      const gchar* icon_name,
                                      const gchar* tooltip_text,
                                      const gchar* data)
{
	BasicPropertiesExifItem * self = NULL;
	GtkImage* icon = NULL;
	GtkImage* _tmp0_;
	PropertiesLabel* label = NULL;
	PropertiesLabel* _tmp1_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp2_;
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (tooltip_text != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	self = (BasicPropertiesExifItem*) g_object_new (object_type, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	icon = _tmp0_;
	_tmp1_ = properties_label_new (data);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	grid = _tmp2_;
	gtk_grid_set_column_spacing (grid, 6);
	gtk_widget_set_tooltip_text ((GtkWidget*) grid, _ (tooltip_text));
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) icon);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (grid);
	_g_object_unref0 (label);
	_g_object_unref0 (icon);
	return self;
}

static BasicPropertiesExifItem*
basic_properties_exif_item_new (const gchar* icon_name,
                                const gchar* tooltip_text,
                                const gchar* data)
{
	return basic_properties_exif_item_construct (BASIC_PROPERTIES_TYPE_EXIF_ITEM, icon_name, tooltip_text, data);
}

static void
basic_properties_exif_item_class_init (BasicPropertiesExifItemClass * klass,
                                       gpointer klass_data)
{
	basic_properties_exif_item_parent_class = g_type_class_peek_parent (klass);
}

static void
basic_properties_exif_item_instance_init (BasicPropertiesExifItem * self,
                                          gpointer klass)
{
}

static GType
basic_properties_exif_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BasicPropertiesExifItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_properties_exif_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicPropertiesExifItem), 0, (GInstanceInitFunc) basic_properties_exif_item_instance_init, NULL };
	GType basic_properties_exif_item_type_id;
	basic_properties_exif_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "BasicPropertiesExifItem", &g_define_type_info, 0);
	return basic_properties_exif_item_type_id;
}

static GType
basic_properties_exif_item_get_type (void)
{
	static volatile gsize basic_properties_exif_item_type_id__once = 0;
	if (g_once_init_enter (&basic_properties_exif_item_type_id__once)) {
		GType basic_properties_exif_item_type_id;
		basic_properties_exif_item_type_id = basic_properties_exif_item_get_type_once ();
		g_once_init_leave (&basic_properties_exif_item_type_id__once, basic_properties_exif_item_type_id);
	}
	return basic_properties_exif_item_type_id__once;
}

static void
basic_properties_class_init (BasicPropertiesClass * klass,
                             gpointer klass_data)
{
	basic_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BasicProperties_private_offset);
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) basic_properties_real_clear_properties;
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) basic_properties_real_get_single_properties;
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties*, GeeIterable*)) basic_properties_real_get_multiple_properties;
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties*, Page*)) basic_properties_real_get_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) basic_properties_real_internal_update_properties;
	((PropertiesClass *) klass)->save_changes_to_source = (void (*) (Properties*)) basic_properties_real_save_changes_to_source;
	G_OBJECT_CLASS (klass)->finalize = basic_properties_finalize;
}

static void
basic_properties_instance_init (BasicProperties * self,
                                gpointer klass)
{
	self->priv = basic_properties_get_instance_private (self);
	self->priv->start_time = (gint64) 0;
	self->priv->end_time = (gint64) 0;
}

static void
basic_properties_finalize (GObject * obj)
{
	BasicProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASIC_PROPERTIES, BasicProperties);
	_g_object_unref0 (self->priv->title_entry);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->place_label);
	_g_free0 (self->priv->camera_make);
	_g_free0 (self->priv->camera_model);
	_g_free0 (self->priv->exposure);
	_g_free0 (self->priv->exposure_bias);
	_g_free0 (self->priv->flash);
	_g_free0 (self->priv->focal_length);
	_g_free0 (self->priv->gps_lat_ref);
	_g_free0 (self->priv->gps_long_ref);
	_g_free0 (self->priv->title);
	_g_free0 (self->priv->aperture);
	_g_free0 (self->priv->iso);
	_g_free0 (self->priv->raw_developer);
	_g_free0 (self->priv->raw_assoc);
	G_OBJECT_CLASS (basic_properties_parent_class)->finalize (obj);
}

static GType
basic_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BasicPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicProperties), 0, (GInstanceInitFunc) basic_properties_instance_init, NULL };
	GType basic_properties_type_id;
	basic_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "BasicProperties", &g_define_type_info, 0);
	BasicProperties_private_offset = g_type_add_instance_private (basic_properties_type_id, sizeof (BasicPropertiesPrivate));
	return basic_properties_type_id;
}

GType
basic_properties_get_type (void)
{
	static volatile gsize basic_properties_type_id__once = 0;
	if (g_once_init_enter (&basic_properties_type_id__once)) {
		GType basic_properties_type_id;
		basic_properties_type_id = basic_properties_get_type_once ();
		g_once_init_leave (&basic_properties_type_id__once, basic_properties_type_id);
	}
	return basic_properties_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

