/* SunriseSunsetCalculator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SunriseSunsetCalculator.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/
/*
* The following code was ported from gnome-settings-daemon
* https://gitlab.gnome.org/GNOME/gnome-settings-daemon/-/blob/02295dee94bebcdd246c40ccf0120eb2ab714416/plugins/color/gsd-night-light-common.c
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR (settings_daemon_utils_sunrise_sunset_calculator_get_type ())
#define SETTINGS_DAEMON_UTILS_SUNRISE_SUNSET_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR, SettingsDaemonUtilsSunriseSunsetCalculator))
#define SETTINGS_DAEMON_UTILS_SUNRISE_SUNSET_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR, SettingsDaemonUtilsSunriseSunsetCalculatorClass))
#define SETTINGS_DAEMON_UTILS_IS_SUNRISE_SUNSET_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR))
#define SETTINGS_DAEMON_UTILS_IS_SUNRISE_SUNSET_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR))
#define SETTINGS_DAEMON_UTILS_SUNRISE_SUNSET_CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR, SettingsDaemonUtilsSunriseSunsetCalculatorClass))

typedef struct _SettingsDaemonUtilsSunriseSunsetCalculator SettingsDaemonUtilsSunriseSunsetCalculator;
typedef struct _SettingsDaemonUtilsSunriseSunsetCalculatorClass SettingsDaemonUtilsSunriseSunsetCalculatorClass;
typedef struct _SettingsDaemonUtilsSunriseSunsetCalculatorPrivate SettingsDaemonUtilsSunriseSunsetCalculatorPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SettingsDaemonUtilsParamSpecSunriseSunsetCalculator SettingsDaemonUtilsParamSpecSunriseSunsetCalculator;

struct _SettingsDaemonUtilsSunriseSunsetCalculator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SettingsDaemonUtilsSunriseSunsetCalculatorPrivate * priv;
};

struct _SettingsDaemonUtilsSunriseSunsetCalculatorClass {
	GTypeClass parent_class;
	void (*finalize) (SettingsDaemonUtilsSunriseSunsetCalculator *self);
};

struct _SettingsDaemonUtilsParamSpecSunriseSunsetCalculator {
	GParamSpec parent_instance;
};

static gpointer settings_daemon_utils_sunrise_sunset_calculator_parent_class = NULL;

VALA_EXTERN gpointer settings_daemon_utils_sunrise_sunset_calculator_ref (gpointer instance);
VALA_EXTERN void settings_daemon_utils_sunrise_sunset_calculator_unref (gpointer instance);
VALA_EXTERN GParamSpec* settings_daemon_utils_param_spec_sunrise_sunset_calculator (const gchar* name,
                                                                        const gchar* nick,
                                                                        const gchar* blurb,
                                                                        GType object_type,
                                                                        GParamFlags flags);
VALA_EXTERN void settings_daemon_utils_value_set_sunrise_sunset_calculator (GValue* value,
                                                                gpointer v_object);
VALA_EXTERN void settings_daemon_utils_value_take_sunrise_sunset_calculator (GValue* value,
                                                                 gpointer v_object);
VALA_EXTERN gpointer settings_daemon_utils_value_get_sunrise_sunset_calculator (const GValue* value);
VALA_EXTERN GType settings_daemon_utils_sunrise_sunset_calculator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonUtilsSunriseSunsetCalculator, settings_daemon_utils_sunrise_sunset_calculator_unref)
VALA_EXTERN gboolean settings_daemon_utils_sunrise_sunset_calculator_get_sunrise_and_sunset (GDateTime* dt,
                                                                                 gdouble pos_lat,
                                                                                 gdouble pos_long,
                                                                                 gdouble* sunrise,
                                                                                 gdouble* sunset);
static gdouble settings_daemon_utils_sunrise_sunset_calculator_deg2rad (gdouble degrees);
static gdouble settings_daemon_utils_sunrise_sunset_calculator_rad2deg (gdouble radians);
VALA_EXTERN SettingsDaemonUtilsSunriseSunsetCalculator* settings_daemon_utils_sunrise_sunset_calculator_new (void);
VALA_EXTERN SettingsDaemonUtilsSunriseSunsetCalculator* settings_daemon_utils_sunrise_sunset_calculator_construct (GType object_type);
static void settings_daemon_utils_sunrise_sunset_calculator_finalize (SettingsDaemonUtilsSunriseSunsetCalculator * obj);
static GType settings_daemon_utils_sunrise_sunset_calculator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gboolean
settings_daemon_utils_sunrise_sunset_calculator_get_sunrise_and_sunset (GDateTime* dt,
                                                                        gdouble pos_lat,
                                                                        gdouble pos_long,
                                                                        gdouble* sunrise,
                                                                        gdouble* sunset)
{
	gdouble _vala_sunrise = 0.0;
	gdouble _vala_sunset = 0.0;
	GDateTime* dt_zero = NULL;
	GDateTime* _tmp0_;
	GTimeSpan ts = 0LL;
	GDateTime* _tmp1_;
	static const gint _G_USEC_PER_SEC = 1000000;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gdouble tz_offset = 0.0;
	gdouble date_as_number = 0.0;
	gdouble time_past_local_midnight = 0.0;
	gdouble julian_day = 0.0;
	gdouble julian_century = 0.0;
	gdouble geom_mean_long_sun = 0.0;
	gdouble geom_mean_anom_sun = 0.0;
	gdouble eccent_earth_orbit = 0.0;
	gdouble sun_eq_of_ctr = 0.0;
	gdouble sun_true_long = 0.0;
	gdouble sun_app_long = 0.0;
	gdouble mean_obliq_ecliptic = 0.0;
	gdouble obliq_corr = 0.0;
	gdouble sun_declin = 0.0;
	gdouble var_y = 0.0;
	gdouble eq_of_time = 0.0;
	gdouble ha_sunrise = 0.0;
	gdouble solar_noon = 0.0;
	gdouble sunrise_time = 0.0;
	gdouble sunset_time = 0.0;
	gboolean result;
	g_return_val_if_fail (dt != NULL, FALSE);
	_vala_sunrise = -1.0;
	_vala_sunset = -1.0;
	_tmp0_ = g_date_time_new_utc (1900, 1, 1, 0, 0, (gdouble) 0);
	dt_zero = _tmp0_;
	_tmp1_ = dt_zero;
	ts = g_date_time_difference (dt, _tmp1_);
	if (pos_lat <= ((gdouble) 90.0f)) {
		_tmp2_ = pos_lat >= ((gdouble) (-90.0f));
	} else {
		_tmp2_ = FALSE;
	}
	if (!_tmp2_) {
		result = FALSE;
		_g_date_time_unref0 (dt_zero);
		if (sunrise) {
			*sunrise = _vala_sunrise;
		}
		if (sunset) {
			*sunset = _vala_sunset;
		}
		return result;
	}
	if (pos_long <= ((gdouble) 180.0f)) {
		_tmp3_ = pos_long >= ((gdouble) (-180.0f));
	} else {
		_tmp3_ = FALSE;
	}
	if (!_tmp3_) {
		result = FALSE;
		_g_date_time_unref0 (dt_zero);
		if (sunrise) {
			*sunrise = _vala_sunrise;
		}
		if (sunset) {
			*sunset = _vala_sunset;
		}
		return result;
	}
	tz_offset = ((((gdouble) g_date_time_get_utc_offset (dt)) / _G_USEC_PER_SEC) / 60) / 60;
	date_as_number = (gdouble) (((((ts / _G_USEC_PER_SEC) / 24) / 60) / 60) + 2);
	time_past_local_midnight = (gdouble) 0;
	julian_day = ((date_as_number + 2415018.5) + time_past_local_midnight) - (tz_offset / 24);
	julian_century = (julian_day - 2451545) / 36525;
	geom_mean_long_sun = fmod (280.46646 + (julian_century * (36000.76983 + (julian_century * 0.0003032))), (gdouble) 360);
	geom_mean_anom_sun = 357.52911 + (julian_century * (35999.05029 - (0.0001537 * julian_century)));
	eccent_earth_orbit = 0.016708634 - (julian_century * (0.000042037 + (0.0000001267 * julian_century)));
	sun_eq_of_ctr = ((sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_anom_sun)) * (1.914602 - (julian_century * (0.004817 + (0.000014 * julian_century))))) + (sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (2 * geom_mean_anom_sun)) * (0.019993 - (0.000101 * julian_century)))) + (sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (3 * geom_mean_anom_sun)) * 0.000289);
	sun_true_long = geom_mean_long_sun + sun_eq_of_ctr;
	sun_app_long = (sun_true_long - 0.00569) - (0.00478 * sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (125.04 - (1934.136 * julian_century))));
	mean_obliq_ecliptic = 23 + ((26 + ((21.448 - (julian_century * (46.815 + (julian_century * (0.00059 - (julian_century * 0.001813)))))) / 60)) / 60);
	obliq_corr = mean_obliq_ecliptic + (0.00256 * cos (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (125.04 - (1934.136 * julian_century))));
	sun_declin = settings_daemon_utils_sunrise_sunset_calculator_rad2deg (asin (sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (obliq_corr)) * sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (sun_app_long))));
	var_y = tan (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (obliq_corr / 2)) * tan (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (obliq_corr / 2));
	eq_of_time = 4 * settings_daemon_utils_sunrise_sunset_calculator_rad2deg (((((var_y * sin (2 * settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_long_sun))) - ((2 * eccent_earth_orbit) * sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_anom_sun)))) + ((((4 * eccent_earth_orbit) * var_y) * sin (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_anom_sun))) * cos (2 * settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_long_sun)))) - (((0.5 * var_y) * var_y) * sin (4 * settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_long_sun)))) - (((1.25 * eccent_earth_orbit) * eccent_earth_orbit) * sin (2 * settings_daemon_utils_sunrise_sunset_calculator_deg2rad (geom_mean_anom_sun))));
	ha_sunrise = settings_daemon_utils_sunrise_sunset_calculator_rad2deg (acos ((cos (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (90.833)) / (cos (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (pos_lat)) * cos (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (sun_declin)))) - (tan (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (pos_lat)) * tan (settings_daemon_utils_sunrise_sunset_calculator_deg2rad (sun_declin)))));
	solar_noon = (((720 - (4 * pos_long)) - eq_of_time) + (tz_offset * 60)) / 1440;
	sunrise_time = solar_noon - ((ha_sunrise * 4) / 1440);
	sunset_time = solar_noon + ((ha_sunrise * 4) / 1440);
	_vala_sunrise = sunrise_time * 24;
	_vala_sunset = sunset_time * 24;
	result = TRUE;
	_g_date_time_unref0 (dt_zero);
	if (sunrise) {
		*sunrise = _vala_sunrise;
	}
	if (sunset) {
		*sunset = _vala_sunset;
	}
	return result;
}

static gdouble
settings_daemon_utils_sunrise_sunset_calculator_deg2rad (gdouble degrees)
{
	gdouble result;
	result = (G_PI * degrees) / 180.0f;
	return result;
}

static gdouble
settings_daemon_utils_sunrise_sunset_calculator_rad2deg (gdouble radians)
{
	gdouble result;
	result = radians * (180.0f / G_PI);
	return result;
}

SettingsDaemonUtilsSunriseSunsetCalculator*
settings_daemon_utils_sunrise_sunset_calculator_construct (GType object_type)
{
	SettingsDaemonUtilsSunriseSunsetCalculator* self = NULL;
	self = (SettingsDaemonUtilsSunriseSunsetCalculator*) g_type_create_instance (object_type);
	return self;
}

SettingsDaemonUtilsSunriseSunsetCalculator*
settings_daemon_utils_sunrise_sunset_calculator_new (void)
{
	return settings_daemon_utils_sunrise_sunset_calculator_construct (SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR);
}

static void
settings_daemon_utils_value_sunrise_sunset_calculator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
settings_daemon_utils_value_sunrise_sunset_calculator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		settings_daemon_utils_sunrise_sunset_calculator_unref (value->data[0].v_pointer);
	}
}

static void
settings_daemon_utils_value_sunrise_sunset_calculator_copy_value (const GValue* src_value,
                                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = settings_daemon_utils_sunrise_sunset_calculator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
settings_daemon_utils_value_sunrise_sunset_calculator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
settings_daemon_utils_value_sunrise_sunset_calculator_collect_value (GValue* value,
                                                                     guint n_collect_values,
                                                                     GTypeCValue* collect_values,
                                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SettingsDaemonUtilsSunriseSunsetCalculator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = settings_daemon_utils_sunrise_sunset_calculator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
settings_daemon_utils_value_sunrise_sunset_calculator_lcopy_value (const GValue* value,
                                                                   guint n_collect_values,
                                                                   GTypeCValue* collect_values,
                                                                   guint collect_flags)
{
	SettingsDaemonUtilsSunriseSunsetCalculator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = settings_daemon_utils_sunrise_sunset_calculator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
settings_daemon_utils_param_spec_sunrise_sunset_calculator (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags)
{
	SettingsDaemonUtilsParamSpecSunriseSunsetCalculator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
settings_daemon_utils_value_get_sunrise_sunset_calculator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR), NULL);
	return value->data[0].v_pointer;
}

void
settings_daemon_utils_value_set_sunrise_sunset_calculator (GValue* value,
                                                           gpointer v_object)
{
	SettingsDaemonUtilsSunriseSunsetCalculator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		settings_daemon_utils_sunrise_sunset_calculator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		settings_daemon_utils_sunrise_sunset_calculator_unref (old);
	}
}

void
settings_daemon_utils_value_take_sunrise_sunset_calculator (GValue* value,
                                                            gpointer v_object)
{
	SettingsDaemonUtilsSunriseSunsetCalculator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		settings_daemon_utils_sunrise_sunset_calculator_unref (old);
	}
}

static void
settings_daemon_utils_sunrise_sunset_calculator_class_init (SettingsDaemonUtilsSunriseSunsetCalculatorClass * klass,
                                                            gpointer klass_data)
{
	settings_daemon_utils_sunrise_sunset_calculator_parent_class = g_type_class_peek_parent (klass);
	((SettingsDaemonUtilsSunriseSunsetCalculatorClass *) klass)->finalize = settings_daemon_utils_sunrise_sunset_calculator_finalize;
}

static void
settings_daemon_utils_sunrise_sunset_calculator_instance_init (SettingsDaemonUtilsSunriseSunsetCalculator * self,
                                                               gpointer klass)
{
	self->ref_count = 1;
}

static void
settings_daemon_utils_sunrise_sunset_calculator_finalize (SettingsDaemonUtilsSunriseSunsetCalculator * obj)
{
	SettingsDaemonUtilsSunriseSunsetCalculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_UTILS_TYPE_SUNRISE_SUNSET_CALCULATOR, SettingsDaemonUtilsSunriseSunsetCalculator);
	g_signal_handlers_destroy (self);
}

static GType
settings_daemon_utils_sunrise_sunset_calculator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { settings_daemon_utils_value_sunrise_sunset_calculator_init, settings_daemon_utils_value_sunrise_sunset_calculator_free_value, settings_daemon_utils_value_sunrise_sunset_calculator_copy_value, settings_daemon_utils_value_sunrise_sunset_calculator_peek_pointer, "p", settings_daemon_utils_value_sunrise_sunset_calculator_collect_value, "p", settings_daemon_utils_value_sunrise_sunset_calculator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonUtilsSunriseSunsetCalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_utils_sunrise_sunset_calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonUtilsSunriseSunsetCalculator), 0, (GInstanceInitFunc) settings_daemon_utils_sunrise_sunset_calculator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType settings_daemon_utils_sunrise_sunset_calculator_type_id;
	settings_daemon_utils_sunrise_sunset_calculator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SettingsDaemonUtilsSunriseSunsetCalculator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return settings_daemon_utils_sunrise_sunset_calculator_type_id;
}

GType
settings_daemon_utils_sunrise_sunset_calculator_get_type (void)
{
	static volatile gsize settings_daemon_utils_sunrise_sunset_calculator_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_utils_sunrise_sunset_calculator_type_id__once)) {
		GType settings_daemon_utils_sunrise_sunset_calculator_type_id;
		settings_daemon_utils_sunrise_sunset_calculator_type_id = settings_daemon_utils_sunrise_sunset_calculator_get_type_once ();
		g_once_init_leave (&settings_daemon_utils_sunrise_sunset_calculator_type_id__once, settings_daemon_utils_sunrise_sunset_calculator_type_id);
	}
	return settings_daemon_utils_sunrise_sunset_calculator_type_id__once;
}

gpointer
settings_daemon_utils_sunrise_sunset_calculator_ref (gpointer instance)
{
	SettingsDaemonUtilsSunriseSunsetCalculator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
settings_daemon_utils_sunrise_sunset_calculator_unref (gpointer instance)
{
	SettingsDaemonUtilsSunriseSunsetCalculator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SETTINGS_DAEMON_UTILS_SUNRISE_SUNSET_CALCULATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

