/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/*
Peek Copyright (c) 2015-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define PEEK_UTILS_NUMBER_FORMAT "%02" G_GINT64_MODIFIER "d"
#define PEEK_UTILS_TIME_FORMAT PEEK_UTILS_NUMBER_FORMAT ":" PEEK_UTILS_NUMBER_FORMAT
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _PeekParamSpecUtils PeekParamSpecUtils;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PeekParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer peek_utils_parent_class = NULL;

static gchar* peek_utils_read_instream_as_utf8 (GInputStream* stream);
static void peek_utils_finalize (PeekUtils * obj);
static GType peek_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
peek_utils_get_temp_dir (void)
{
	gchar* cache_dir_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* cache_dir = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "peek", NULL);
	cache_dir_path = _tmp1_;
	_tmp2_ = cache_dir_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	cache_dir = _tmp3_;
	{
		GFile* _tmp4_;
		_tmp4_ = cache_dir;
		g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		if (g_error_matches (_tmp5_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			const gchar* _tmp6_;
			_tmp6_ = cache_dir_path;
			g_debug ("utils.vala:23: Cache directory does already exist %s\n", _tmp6_);
		} else {
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = stderr;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "Error: %s\n", _tmp9_);
			_tmp10_ = g_get_tmp_dir ();
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			_g_error_free0 (e);
			_g_object_unref0 (cache_dir);
			_g_free0 (cache_dir_path);
			return result;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cache_dir);
		_g_free0 (cache_dir_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = cache_dir;
	_tmp13_ = g_file_get_path (_tmp12_);
	result = _tmp13_;
	_g_object_unref0 (cache_dir);
	_g_free0 (cache_dir_path);
	return result;
}

gchar*
peek_utils_create_temp_file (const gchar* extension,
                             GError** error)
{
	gchar* temp_dir = NULL;
	gchar* _tmp0_;
	gchar* file_name = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint fd = 0;
	gchar* result;
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = peek_utils_get_temp_dir ();
	temp_dir = _tmp0_;
	_tmp1_ = g_strconcat ("peekXXXXXX.", extension, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_build_filename (temp_dir, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file_name = _tmp4_;
	fd = g_mkstemp (file_name);
	close (fd);
	g_debug ("utils.vala:38: Temp file: %s\n", file_name);
	result = file_name;
	_g_free0 (temp_dir);
	return result;
}

gboolean
peek_utils_is_exit_status_success (gint status)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_spawn_check_exit_status (status, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Error: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = FALSE;
	return result;
}

gboolean
peek_utils_check_for_executable (const gchar* executable)
{
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint args_length1;
	gint _args_size_;
	gint status = 0;
	gchar* output = NULL;
	gchar* errorout = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (executable != NULL, FALSE);
	_tmp0_ = g_strdup ("which");
	_tmp1_ = g_strdup (executable);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	args = _tmp2_;
	args_length1 = 2;
	_args_size_ = args_length1;
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		g_spawn_sync (NULL, args, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp3_;
		_g_free0 (errorout);
		errorout = _tmp4_;
		status = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (errorout);
			_g_free0 (output);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		g_debug ("utils.vala:68: Looking for executable %s (%i): %s%s", executable, status, output, errorout);
		result = peek_utils_is_exit_status_success (status);
		_g_free0 (errorout);
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("utils.vala:72: Error: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_free0 (errorout);
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	_g_free0 (errorout);
	_g_free0 (output);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gchar*
peek_utils_get_file_extension_for_format (PeekOutputFormat output_format)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = peek_output_format_to_string (output_format);
	result = _tmp0_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gboolean
peek_utils_string_is_empty (const gchar* str)
{
	gunichar c = 0U;
	gboolean result;
	if (str == NULL) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar _tmp1_ = 0U;
				gboolean _tmp2_;
				gboolean _tmp3_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				_tmp2_ = string_get_next_char (str, &i, &_tmp1_);
				c = _tmp1_;
				if (!_tmp2_) {
					break;
				}
				if (!g_unichar_isspace (c)) {
					_tmp3_ = !g_unichar_iscntrl (c);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

gint
peek_utils_make_even (gint i)
{
	gint result;
	result = (i / 2) * 2;
	return result;
}

/**
    * Returns available system memory in kiB.
    * Returns -1 if memory could not be read
    */
static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

gint
peek_utils_get_available_system_memory (void)
{
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gchar* line = NULL;
	gint result;
	_tmp0_ = g_fopen ("/proc/meminfo", "r");
	stream = _tmp0_;
	_tmp1_ = stream;
	_vala_assert (_tmp1_ != NULL, "stream != null");
	while (TRUE) {
		FILE* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = stream;
		_tmp3_ = g_file_stream_read_line (_tmp2_);
		_g_free0 (line);
		line = _tmp3_;
		_tmp4_ = line;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = line;
		if (g_str_has_prefix (_tmp5_, "MemAvailable")) {
			gint memory = 0;
			const gchar* _tmp6_;
			memory = 0;
			_tmp6_ = line;
			sscanf (_tmp6_, "MemAvailable: %d kB", &memory);
			result = memory;
			_g_free0 (line);
			_fclose0 (stream);
			return result;
		}
	}
	result = -1;
	_g_free0 (line);
	_fclose0 (stream);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
peek_utils_get_command_failed_message (gchar** argv,
                                       gint argv_length1,
                                       GSubprocess* subprocess)
{
	gint status = 0;
	gint term_sig = 0;
	gchar* output = NULL;
	gchar* message = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* result;
	status = -1;
	term_sig = 0;
	output = NULL;
	if (subprocess != NULL) {
		GInputStream* stdout_pipe = NULL;
		GInputStream* _tmp0_;
		GInputStream* _tmp1_;
		GInputStream* _tmp2_;
		status = g_subprocess_get_status (subprocess);
		if (g_subprocess_get_if_signaled (subprocess)) {
			term_sig = g_subprocess_get_term_sig (subprocess);
		}
		_tmp0_ = g_subprocess_get_stdout_pipe (subprocess);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		stdout_pipe = _tmp1_;
		_tmp2_ = stdout_pipe;
		if (_tmp2_ != NULL) {
			GInputStream* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = stdout_pipe;
			_tmp4_ = peek_utils_read_instream_as_utf8 (_tmp3_);
			_g_free0 (output);
			output = _tmp4_;
		}
		_g_object_unref0 (stdout_pipe);
	}
	_tmp5_ = _vala_g_strjoinv (" ", argv, (gint) argv_length1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("Command \"%s\" failed with status %i (received signal %i).", _tmp6_, status, term_sig);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	message = _tmp8_;
	_tmp9_ = output;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = message;
		_tmp11_ = output;
		_tmp12_ = g_strdup_printf ("\n\nOutput:\n%s", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
		_g_free0 (message);
		message = _tmp14_;
		_g_free0 (_tmp13_);
	}
	result = message;
	_g_free0 (output);
	return result;
}

static gchar*
peek_utils_read_instream_as_utf8 (GInputStream* stream)
{
	GString* output = NULL;
	GString* _tmp0_;
	GDataInputStream* dis = NULL;
	GDataInputStream* _tmp1_;
	gchar* line = NULL;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	_tmp1_ = g_data_input_stream_new (stream);
	dis = _tmp1_;
	{
		while (TRUE) {
			gchar* _tmp2_ = NULL;
			GDataInputStream* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp3_ = dis;
			_tmp4_ = g_data_input_stream_read_line_utf8 (_tmp3_, NULL, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_string_free0 (output);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_free0 (line);
			line = _tmp5_;
			_tmp6_ = line;
			if (!(_tmp6_ != NULL)) {
				_g_free0 (_tmp2_);
				break;
			}
			_tmp7_ = output;
			_tmp8_ = line;
			g_string_append (_tmp7_, _tmp8_);
			_g_free0 (_tmp2_);
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = stderr;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		fprintf (_tmp9_, "Error: %s\n", _tmp11_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_string_free0 (output);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_string_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = output;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_free0 (line);
	_g_object_unref0 (dis);
	_g_string_free0 (output);
	return result;
}

gchar*
peek_utils_format_time (gint64 seconds)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (PEEK_UTILS_TIME_FORMAT, seconds / 60, seconds % 60);
	result = _tmp0_;
	return result;
}

PeekUtils*
peek_utils_construct (GType object_type)
{
	PeekUtils* self = NULL;
	self = (PeekUtils*) g_type_create_instance (object_type);
	return self;
}

PeekUtils*
peek_utils_new (void)
{
	return peek_utils_construct (PEEK_TYPE_UTILS);
}

static void
peek_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
peek_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		peek_utils_unref (value->data[0].v_pointer);
	}
}

static void
peek_value_utils_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = peek_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
peek_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
peek_value_utils_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PeekUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = peek_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
peek_value_utils_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	PeekUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = peek_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
peek_param_spec_utils (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	PeekParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PEEK_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
peek_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
peek_value_set_utils (GValue* value,
                      gpointer v_object)
{
	PeekUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		peek_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_utils_unref (old);
	}
}

void
peek_value_take_utils (GValue* value,
                       gpointer v_object)
{
	PeekUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_utils_unref (old);
	}
}

static void
peek_utils_class_init (PeekUtilsClass * klass,
                       gpointer klass_data)
{
	peek_utils_parent_class = g_type_class_peek_parent (klass);
	((PeekUtilsClass *) klass)->finalize = peek_utils_finalize;
}

static void
peek_utils_instance_init (PeekUtils * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
peek_utils_finalize (PeekUtils * obj)
{
	PeekUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_TYPE_UTILS, PeekUtils);
	g_signal_handlers_destroy (self);
}

static GType
peek_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { peek_value_utils_init, peek_value_utils_free_value, peek_value_utils_copy_value, peek_value_utils_peek_pointer, "p", peek_value_utils_collect_value, "p", peek_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PeekUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekUtils), 0, (GInstanceInitFunc) peek_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType peek_utils_type_id;
	peek_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PeekUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return peek_utils_type_id;
}

GType
peek_utils_get_type (void)
{
	static volatile gsize peek_utils_type_id__once = 0;
	if (g_once_init_enter (&peek_utils_type_id__once)) {
		GType peek_utils_type_id;
		peek_utils_type_id = peek_utils_get_type_once ();
		g_once_init_leave (&peek_utils_type_id__once, peek_utils_type_id);
	}
	return peek_utils_type_id__once;
}

gpointer
peek_utils_ref (gpointer instance)
{
	PeekUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
peek_utils_unref (gpointer instance)
{
	PeekUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PEEK_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

