/* Generated by wayland-scanner 1.24.0 */

#ifndef WLR_OUTPUT_POWER_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define WLR_OUTPUT_POWER_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wlr_output_power_management_unstable_v1 The wlr_output_power_management_unstable_v1 protocol
 * Control power management modes of outputs
 *
 * @section page_desc_wlr_output_power_management_unstable_v1 Description
 *
 * This protocol allows clients to control power management modes
 * of outputs that are currently part of the compositor space. The
 * intent is to allow special clients like desktop shells to power
 * down outputs when the system is idle.
 *
 * To modify outputs not currently part of the compositor space see
 * wlr-output-management.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_wlr_output_power_management_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_output_power_manager_v1 - manager to create per-output power management
 * - @subpage page_iface_zwlr_output_power_v1 - adjust power management mode for an output
 * @section page_copyright_wlr_output_power_management_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Purism SPC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct zwlr_output_power_manager_v1;
struct zwlr_output_power_v1;

#ifndef ZWLR_OUTPUT_POWER_MANAGER_V1_INTERFACE
#define ZWLR_OUTPUT_POWER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_power_manager_v1 zwlr_output_power_manager_v1
 * @section page_iface_zwlr_output_power_manager_v1_desc Description
 *
 * This interface is a manager that allows creating per-output power
 * management mode controls.
 * @section page_iface_zwlr_output_power_manager_v1_api API
 * See @ref iface_zwlr_output_power_manager_v1.
 */
/**
 * @defgroup iface_zwlr_output_power_manager_v1 The zwlr_output_power_manager_v1 interface
 *
 * This interface is a manager that allows creating per-output power
 * management mode controls.
 */
extern const struct wl_interface zwlr_output_power_manager_v1_interface;
#endif
#ifndef ZWLR_OUTPUT_POWER_V1_INTERFACE
#define ZWLR_OUTPUT_POWER_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_power_v1 zwlr_output_power_v1
 * @section page_iface_zwlr_output_power_v1_desc Description
 *
 * This object offers requests to set the power management mode of
 * an output.
 * @section page_iface_zwlr_output_power_v1_api API
 * See @ref iface_zwlr_output_power_v1.
 */
/**
 * @defgroup iface_zwlr_output_power_v1 The zwlr_output_power_v1 interface
 *
 * This object offers requests to set the power management mode of
 * an output.
 */
extern const struct wl_interface zwlr_output_power_v1_interface;
#endif

#define ZWLR_OUTPUT_POWER_MANAGER_V1_GET_OUTPUT_POWER 0
#define ZWLR_OUTPUT_POWER_MANAGER_V1_DESTROY 1


/**
 * @ingroup iface_zwlr_output_power_manager_v1
 */
#define ZWLR_OUTPUT_POWER_MANAGER_V1_GET_OUTPUT_POWER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_power_manager_v1
 */
#define ZWLR_OUTPUT_POWER_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_output_power_manager_v1 */
static inline void
zwlr_output_power_manager_v1_set_user_data(struct zwlr_output_power_manager_v1 *zwlr_output_power_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_power_manager_v1, user_data);
}

/** @ingroup iface_zwlr_output_power_manager_v1 */
static inline void *
zwlr_output_power_manager_v1_get_user_data(struct zwlr_output_power_manager_v1 *zwlr_output_power_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_power_manager_v1);
}

static inline uint32_t
zwlr_output_power_manager_v1_get_version(struct zwlr_output_power_manager_v1 *zwlr_output_power_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_manager_v1);
}

/**
 * @ingroup iface_zwlr_output_power_manager_v1
 *
 * Create a output power management mode control that can be used to
 * adjust the power management mode for a given output.
 */
static inline struct zwlr_output_power_v1 *
zwlr_output_power_manager_v1_get_output_power(struct zwlr_output_power_manager_v1 *zwlr_output_power_manager_v1, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_power_manager_v1,
			 ZWLR_OUTPUT_POWER_MANAGER_V1_GET_OUTPUT_POWER, &zwlr_output_power_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_manager_v1), 0, NULL, output);

	return (struct zwlr_output_power_v1 *) id;
}

/**
 * @ingroup iface_zwlr_output_power_manager_v1
 *
 * All objects created by the manager will still remain valid, until their
 * appropriate destroy request has been called.
 */
static inline void
zwlr_output_power_manager_v1_destroy(struct zwlr_output_power_manager_v1 *zwlr_output_power_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_power_manager_v1,
			 ZWLR_OUTPUT_POWER_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWLR_OUTPUT_POWER_V1_MODE_ENUM
#define ZWLR_OUTPUT_POWER_V1_MODE_ENUM
enum zwlr_output_power_v1_mode {
	/**
	 * Output is turned off.
	 */
	ZWLR_OUTPUT_POWER_V1_MODE_OFF = 0,
	/**
	 * Output is turned on, no power saving
	 */
	ZWLR_OUTPUT_POWER_V1_MODE_ON = 1,
};
#endif /* ZWLR_OUTPUT_POWER_V1_MODE_ENUM */

#ifndef ZWLR_OUTPUT_POWER_V1_ERROR_ENUM
#define ZWLR_OUTPUT_POWER_V1_ERROR_ENUM
enum zwlr_output_power_v1_error {
	/**
	 * inexistent power save mode
	 */
	ZWLR_OUTPUT_POWER_V1_ERROR_INVALID_MODE = 1,
};
#endif /* ZWLR_OUTPUT_POWER_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_output_power_v1
 * @struct zwlr_output_power_v1_listener
 */
struct zwlr_output_power_v1_listener {
	/**
	 * Report a power management mode change
	 *
	 * Report the power management mode change of an output.
	 *
	 * The mode event is sent after an output changed its power
	 * management mode. The reason can be a client using set_mode or
	 * the compositor deciding to change an output's mode. This event
	 * is also sent immediately when the object is created so the
	 * client is informed about the current power management mode.
	 * @param mode the output's new power management mode
	 */
	void (*mode)(void *data,
		     struct zwlr_output_power_v1 *zwlr_output_power_v1,
		     uint32_t mode);
	/**
	 * object no longer valid
	 *
	 * This event indicates that the output power management mode
	 * control is no longer valid. This can happen for a number of
	 * reasons, including: - The output doesn't support power
	 * management - Another client already has exclusive power
	 * management mode control for this output - The output disappeared
	 *
	 * Upon receiving this event, the client should destroy this
	 * object.
	 */
	void (*failed)(void *data,
		       struct zwlr_output_power_v1 *zwlr_output_power_v1);
};

/**
 * @ingroup iface_zwlr_output_power_v1
 */
static inline int
zwlr_output_power_v1_add_listener(struct zwlr_output_power_v1 *zwlr_output_power_v1,
				  const struct zwlr_output_power_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_output_power_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_OUTPUT_POWER_V1_SET_MODE 0
#define ZWLR_OUTPUT_POWER_V1_DESTROY 1

/**
 * @ingroup iface_zwlr_output_power_v1
 */
#define ZWLR_OUTPUT_POWER_V1_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_power_v1
 */
#define ZWLR_OUTPUT_POWER_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_output_power_v1
 */
#define ZWLR_OUTPUT_POWER_V1_SET_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_power_v1
 */
#define ZWLR_OUTPUT_POWER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_output_power_v1 */
static inline void
zwlr_output_power_v1_set_user_data(struct zwlr_output_power_v1 *zwlr_output_power_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_power_v1, user_data);
}

/** @ingroup iface_zwlr_output_power_v1 */
static inline void *
zwlr_output_power_v1_get_user_data(struct zwlr_output_power_v1 *zwlr_output_power_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_power_v1);
}

static inline uint32_t
zwlr_output_power_v1_get_version(struct zwlr_output_power_v1 *zwlr_output_power_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_v1);
}

/**
 * @ingroup iface_zwlr_output_power_v1
 *
 * Set an output's power save mode to the given mode. The mode change
 * is effective immediately. If the output does not support the given
 * mode a failed event is sent.
 */
static inline void
zwlr_output_power_v1_set_mode(struct zwlr_output_power_v1 *zwlr_output_power_v1, uint32_t mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_power_v1,
			 ZWLR_OUTPUT_POWER_V1_SET_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_v1), 0, mode);
}

/**
 * @ingroup iface_zwlr_output_power_v1
 *
 * Destroys the output power management mode control object.
 */
static inline void
zwlr_output_power_v1_destroy(struct zwlr_output_power_v1 *zwlr_output_power_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_power_v1,
			 ZWLR_OUTPUT_POWER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_power_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
