/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration};


/// struct for typed errors of method [`plan`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlanError {
    UnknownValue(serde_json::Value),
}


pub async fn plan(configuration: &configuration::Configuration, from_place: &str, to_place: &str, detailed_transfers: bool, via: Option<Vec<String>>, via_minimum_stay: Option<Vec<i32>>, time: Option<String>, max_transfers: Option<i32>, max_travel_time: Option<i32>, min_transfer_time: Option<i32>, additional_transfer_time: Option<i32>, transfer_time_factor: Option<f64>, max_matching_distance: Option<f64>, pedestrian_profile: Option<models::PedestrianProfile>, use_routed_transfers: Option<bool>, transit_modes: Option<Vec<models::Mode>>, direct_modes: Option<Vec<models::Mode>>, pre_transit_modes: Option<Vec<models::Mode>>, post_transit_modes: Option<Vec<models::Mode>>, direct_rental_form_factors: Option<Vec<models::RentalFormFactor>>, pre_transit_rental_form_factors: Option<Vec<models::RentalFormFactor>>, post_transit_rental_form_factors: Option<Vec<models::RentalFormFactor>>, direct_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, pre_transit_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, post_transit_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, direct_rental_providers: Option<Vec<String>>, pre_transit_rental_providers: Option<Vec<String>>, post_transit_rental_providers: Option<Vec<String>>, num_itineraries: Option<i32>, page_cursor: Option<&str>, timetable_view: Option<bool>, arrive_by: Option<bool>, search_window: Option<i32>, require_bike_transport: Option<bool>, max_pre_transit_time: Option<i32>, max_post_transit_time: Option<i32>, max_direct_time: Option<i32>, timeout: Option<i32>) -> Result<models::Plan200Response, Error<PlanError>> {
    let local_var_configuration = configuration;

    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/api/v1/plan", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("fromPlace", &from_place.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("toPlace", &to_place.to_string())]);
    if let Some(ref local_var_str) = via {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("via".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("via", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = via_minimum_stay {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("viaMinimumStay".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("viaMinimumStay", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = time {
        local_var_req_builder = local_var_req_builder.query(&[("time", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_transfers {
        local_var_req_builder = local_var_req_builder.query(&[("maxTransfers", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_travel_time {
        local_var_req_builder = local_var_req_builder.query(&[("maxTravelTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = min_transfer_time {
        local_var_req_builder = local_var_req_builder.query(&[("minTransferTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = additional_transfer_time {
        local_var_req_builder = local_var_req_builder.query(&[("additionalTransferTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = transfer_time_factor {
        local_var_req_builder = local_var_req_builder.query(&[("transferTimeFactor", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_matching_distance {
        local_var_req_builder = local_var_req_builder.query(&[("maxMatchingDistance", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pedestrian_profile {
        local_var_req_builder = local_var_req_builder.query(&[("pedestrianProfile", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = use_routed_transfers {
        local_var_req_builder = local_var_req_builder.query(&[("useRoutedTransfers", &local_var_str.to_string())]);
    }
    local_var_req_builder = local_var_req_builder.query(&[("detailedTransfers", &detailed_transfers.to_string())]);
    if let Some(ref local_var_str) = transit_modes {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("transitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("transitModes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = direct_modes {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("directModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("directModes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = pre_transit_modes {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("preTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("preTransitModes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = post_transit_modes {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("postTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("postTransitModes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = direct_rental_form_factors {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("directRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("directRentalFormFactors", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = pre_transit_rental_form_factors {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("preTransitRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("preTransitRentalFormFactors", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = post_transit_rental_form_factors {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("postTransitRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("postTransitRentalFormFactors", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = direct_rental_propulsion_types {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("directRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("directRentalPropulsionTypes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = pre_transit_rental_propulsion_types {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("preTransitRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("preTransitRentalPropulsionTypes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = post_transit_rental_propulsion_types {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("postTransitRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("postTransitRentalPropulsionTypes", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = direct_rental_providers {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("directRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("directRentalProviders", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = pre_transit_rental_providers {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("preTransitRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("preTransitRentalProviders", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = post_transit_rental_providers {
        local_var_req_builder = match "multi" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("postTransitRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("postTransitRentalProviders", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = num_itineraries {
        local_var_req_builder = local_var_req_builder.query(&[("numItineraries", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page_cursor {
        local_var_req_builder = local_var_req_builder.query(&[("pageCursor", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = timetable_view {
        local_var_req_builder = local_var_req_builder.query(&[("timetableView", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = arrive_by {
        local_var_req_builder = local_var_req_builder.query(&[("arriveBy", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_window {
        local_var_req_builder = local_var_req_builder.query(&[("searchWindow", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = require_bike_transport {
        local_var_req_builder = local_var_req_builder.query(&[("requireBikeTransport", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_pre_transit_time {
        local_var_req_builder = local_var_req_builder.query(&[("maxPreTransitTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_post_transit_time {
        local_var_req_builder = local_var_req_builder.query(&[("maxPostTransitTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = max_direct_time {
        local_var_req_builder = local_var_req_builder.query(&[("maxDirectTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = timeout {
        local_var_req_builder = local_var_req_builder.query(&[("timeout", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<PlanError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

