/* rygel-photo-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-photo-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_PHOTO_ITEM_0_PROPERTY,
	RYGEL_PHOTO_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_photo_item_properties[RYGEL_PHOTO_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer rygel_photo_item_parent_class = NULL;

VALA_EXTERN gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
VALA_EXTERN void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
static gint rygel_photo_item_real_compare_by_property (RygelMediaObject* base,
                                                RygelMediaObject* media_object,
                                                const gchar* property);
static gchar* rygel_photo_item_get_first (RygelPhotoItem* self,
                                   GList* contributors);
static void rygel_photo_item_real_apply_didl_lite (RygelMediaObject* base,
                                            GUPnPDIDLLiteObject* didl_object);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GUPnPDIDLLiteObject* rygel_photo_item_real_serialize (RygelMediaObject* base,
                                                      RygelSerializer* serializer,
                                                      RygelHTTPServer* http_server,
                                                      GError** error);
static GType rygel_photo_item_get_type_once (void);

RygelPhotoItem*
rygel_photo_item_construct (GType object_type,
                            const gchar* id,
                            RygelMediaContainer* parent,
                            const gchar* title,
                            const gchar* upnp_class)
{
	RygelPhotoItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelPhotoItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

RygelPhotoItem*
rygel_photo_item_new (const gchar* id,
                      RygelMediaContainer* parent,
                      const gchar* title,
                      const gchar* upnp_class)
{
	return rygel_photo_item_construct (RYGEL_TYPE_PHOTO_ITEM, id, parent, title, upnp_class);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
rygel_photo_item_real_compare_by_property (RygelMediaObject* base,
                                           RygelMediaObject* media_object,
                                           const gchar* property)
{
	RygelPhotoItem * self;
	RygelPhotoItem* item = NULL;
	RygelPhotoItem* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	gint result;
	self = (RygelPhotoItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_PHOTO_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (RYGEL_IS_PHOTO_ITEM (media_object) ? ((RygelPhotoItem*) media_object) : NULL);
	item = _tmp0_;
	_tmp1_ = property;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	switch (0) {
		default:
		{
			RygelPhotoItem* _tmp4_;
			_tmp4_ = item;
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_photo_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem), (RygelMediaObject*) _tmp4_, property);
			_g_object_unref0 (item);
			return result;
		}
	}
}

static gchar*
rygel_photo_item_get_first (RygelPhotoItem* self,
                            GList* contributors)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (contributors != NULL) {
		gconstpointer _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = contributors->data;
		_tmp1_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
rygel_photo_item_real_apply_didl_lite (RygelMediaObject* base,
                                       GUPnPDIDLLiteObject* didl_object)
{
	RygelPhotoItem * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (RygelPhotoItem*) base;
	g_return_if_fail (didl_object != NULL);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_photo_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem), didl_object);
	_tmp0_ = gupnp_didl_lite_object_get_creators (didl_object);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_photo_item_get_first (self, _tmp1_);
	_tmp3_ = _tmp2_;
	rygel_media_object_set_creator ((RygelMediaObject*) self, _tmp3_);
	_g_free0 (_tmp3_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
}

static GUPnPDIDLLiteObject*
rygel_photo_item_real_serialize (RygelMediaObject* base,
                                 RygelSerializer* serializer,
                                 RygelHTTPServer* http_server,
                                 GError** error)
{
	RygelPhotoItem * self;
	GUPnPDIDLLiteObject* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp0_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelPhotoItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_photo_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_IMAGE_ITEM, RygelImageItem), serializer, http_server, &_inner_error0_);
	didl_item = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	result = didl_item;
	return result;
}

static void
rygel_photo_item_class_init (RygelPhotoItemClass * klass,
                             gpointer klass_data)
{
	rygel_photo_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject*, RygelMediaObject*, const gchar*)) rygel_photo_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject*, GUPnPDIDLLiteObject*)) rygel_photo_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_photo_item_real_serialize;
}

static void
rygel_photo_item_instance_init (RygelPhotoItem * self,
                                gpointer klass)
{
}

/**
 * Represents a photo item.
 */
 G_GNUC_NO_INLINE static GType
rygel_photo_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPhotoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_photo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPhotoItem), 0, (GInstanceInitFunc) rygel_photo_item_instance_init, NULL };
	GType rygel_photo_item_type_id;
	rygel_photo_item_type_id = g_type_register_static (RYGEL_TYPE_IMAGE_ITEM, "RygelPhotoItem", &g_define_type_info, 0);
	return rygel_photo_item_type_id;
}

GType
rygel_photo_item_get_type (void)
{
	static volatile gsize rygel_photo_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_photo_item_type_id__once)) {
		GType rygel_photo_item_type_id;
		rygel_photo_item_type_id = rygel_photo_item_get_type_once ();
		g_once_init_leave (&rygel_photo_item_type_id__once, rygel_photo_item_type_id);
	}
	return rygel_photo_item_type_id__once;
}

