/* rygel-subtitle.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-subtitle.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include "rygel-core.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

static gpointer rygel_subtitle_parent_class = NULL;

VALA_EXTERN RygelMediaResource* rygel_subtitle_get_resource (RygelSubtitle* self,
                                                 const gchar* protocol,
                                                 gint index);
VALA_EXTERN void rygel_subtitle_add_didl_node (RygelSubtitle* self,
                                   GUPnPDIDLLiteItem* didl_item);
static RygelMediaResource* rygel_subtitle_real_get_resource (RygelSubtitle* self,
                                                      const gchar* protocol,
                                                      gint index);
static void rygel_subtitle_finalize (RygelSubtitle * obj);
static GType rygel_subtitle_get_type_once (void);

RygelSubtitle*
rygel_subtitle_construct (GType object_type,
                          const gchar* mime_type,
                          const gchar* caption_type,
                          const gchar* file_extension)
{
	RygelSubtitle* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (caption_type != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	self = (RygelSubtitle*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (mime_type);
	_g_free0 (self->mime_type);
	self->mime_type = _tmp0_;
	_tmp1_ = g_strdup (caption_type);
	_g_free0 (self->caption_type);
	self->caption_type = _tmp1_;
	_tmp2_ = g_strdup (file_extension);
	_g_free0 (self->file_extension);
	self->file_extension = _tmp2_;
	return self;
}

RygelSubtitle*
rygel_subtitle_new (const gchar* mime_type,
                    const gchar* caption_type,
                    const gchar* file_extension)
{
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE, mime_type, caption_type, file_extension);
}

void
rygel_subtitle_add_didl_node (RygelSubtitle* self,
                              GUPnPDIDLLiteItem* didl_item)
{
	xmlNode* item_node = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* root_node = NULL;
	xmlDoc* _tmp2_;
	xmlNode* _tmp3_;
	xmlNs* sec_ns = NULL;
	xmlNs* _tmp4_;
	xmlNode* sec_node = NULL;
	const gchar* _tmp5_;
	xmlNode* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = gupnp_didl_lite_object_get_xml_node ((GUPnPDIDLLiteObject*) didl_item);
	_tmp1_ = _tmp0_;
	item_node = _tmp1_;
	_tmp2_ = item_node->doc;
	_tmp3_ = xmlDocGetRootElement (_tmp2_);
	root_node = _tmp3_;
	_tmp4_ = rygel_xml_utils_get_namespace (root_node, "http://www.sec.co.kr/", "sec");
	sec_ns = _tmp4_;
	_tmp5_ = self->uri;
	_tmp6_ = xmlNewChild (item_node, sec_ns, (xmlChar*) "CaptionInfoEx", (xmlChar*) _tmp5_);
	sec_node = _tmp6_;
	_tmp7_ = self->caption_type;
	xmlNewNsProp (sec_node, sec_ns, (xmlChar*) "type", (xmlChar*) _tmp7_);
}

static RygelMediaResource*
rygel_subtitle_real_get_resource (RygelSubtitle* self,
                                  const gchar* protocol,
                                  gint index)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp1_;
	const gchar* _tmp2_;
	GUPnPDLNAFlags _tmp3_;
	GUPnPDLNAFlags _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	RygelMediaResource* result;
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s_subtitle_%2d", protocol, index);
	name = _tmp0_;
	_tmp1_ = rygel_media_resource_new (name);
	res = _tmp1_;
	rygel_media_resource_set_size (res, self->size);
	_tmp2_ = self->mime_type;
	rygel_media_resource_set_mime_type (res, _tmp2_);
	rygel_media_resource_set_protocol (res, protocol);
	_tmp3_ = rygel_media_resource_get_dlna_flags (res);
	_tmp4_ = _tmp3_;
	rygel_media_resource_set_dlna_flags (res, _tmp4_ | (((GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL) | GUPNP_DLNA_FLAGS_DLNA_V15));
	rygel_media_resource_set_dlna_operation (res, GUPNP_DLNA_OPERATION_RANGE);
	rygel_media_resource_set_dlna_conversion (res, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp5_ = self->file_extension;
	rygel_media_resource_set_extension (res, _tmp5_);
	_tmp6_ = self->uri;
	rygel_media_resource_set_uri (res, _tmp6_);
	result = res;
	_g_free0 (name);
	return result;
}

RygelMediaResource*
rygel_subtitle_get_resource (RygelSubtitle* self,
                             const gchar* protocol,
                             gint index)
{
	RygelSubtitleClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_SUBTITLE_GET_CLASS (self);
	if (_klass_->get_resource) {
		return _klass_->get_resource (self, protocol, index);
	}
	return NULL;
}

static void
rygel_value_subtitle_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_value_subtitle_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_subtitle_unref (value->data[0].v_pointer);
	}
}

static void
rygel_value_subtitle_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_value_subtitle_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_value_subtitle_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelSubtitle * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_subtitle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_value_subtitle_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	RygelSubtitle ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_param_spec_subtitle (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	RygelParamSpecSubtitle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_value_get_subtitle (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
	return value->data[0].v_pointer;
}

void
rygel_value_set_subtitle (GValue* value,
                          gpointer v_object)
{
	RygelSubtitle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_subtitle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}

void
rygel_value_take_subtitle (GValue* value,
                           gpointer v_object)
{
	RygelSubtitle * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}

static void
rygel_subtitle_class_init (RygelSubtitleClass * klass,
                           gpointer klass_data)
{
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	((RygelSubtitleClass *) klass)->finalize = rygel_subtitle_finalize;
	((RygelSubtitleClass *) klass)->get_resource = (RygelMediaResource* (*) (RygelSubtitle*, const gchar*, gint)) rygel_subtitle_real_get_resource;
}

static void
rygel_subtitle_instance_init (RygelSubtitle * self,
                              gpointer klass)
{
	self->size = (gint64) -1;
	self->ref_count = 1;
}

static void
rygel_subtitle_finalize (RygelSubtitle * obj)
{
	RygelSubtitle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
	g_signal_handlers_destroy (self);
	_g_free0 (self->uri);
	_g_free0 (self->mime_type);
	_g_free0 (self->caption_type);
	_g_free0 (self->file_extension);
}

/**
 * Represents a subtitle for a video.
 */
 G_GNUC_NO_INLINE static GType
rygel_subtitle_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_subtitle_type_id;
	rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return rygel_subtitle_type_id;
}

GType
rygel_subtitle_get_type (void)
{
	static volatile gsize rygel_subtitle_type_id__once = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__once)) {
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = rygel_subtitle_get_type_once ();
		g_once_init_leave (&rygel_subtitle_type_id__once, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__once;
}

gpointer
rygel_subtitle_ref (gpointer instance)
{
	RygelSubtitle * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_subtitle_unref (gpointer instance)
{
	RygelSubtitle * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

