/* localsearch-query.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-query.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Ivan Frade <ivan.frade@nokia.com>
 *          Jens Georg <jensg@openismus.com>
 *          Luis de Bethencourt <luisbg@collabora.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <tinysparql.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelLocalSearchParamSpecQuery RygelLocalSearchParamSpecQuery;

struct _RygelLocalSearchParamSpecQuery {
	GParamSpec parent_instance;
};

static gpointer rygel_local_search_query_parent_class = NULL;

static gchar* rygel_local_search_query_real_to_string (RygelLocalSearchQuery* self);
static void rygel_local_search_query_finalize (RygelLocalSearchQuery * obj);
static GType rygel_local_search_query_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelLocalSearchQuery*
rygel_local_search_query_construct (GType object_type,
                                    RygelLocalSearchQueryTriplets* triplets)
{
	RygelLocalSearchQuery* self = NULL;
	RygelLocalSearchQueryTriplets* _tmp0_;
	g_return_val_if_fail (triplets != NULL, NULL);
	self = (RygelLocalSearchQuery*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (triplets);
	_g_object_unref0 (self->triplets);
	self->triplets = _tmp0_;
	return self;
}

void
rygel_local_search_query_execute (RygelLocalSearchQuery* self,
                                  TrackerSparqlConnection* resources,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelLocalSearchQueryClass* _klass_;
	_klass_ = RYGEL_LOCAL_SEARCH_QUERY_GET_CLASS (self);
	if (_klass_->execute) {
		_klass_->execute (self, resources, _callback_, _user_data_);
	}
}

void
rygel_local_search_query_execute_finish (RygelLocalSearchQuery* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	RygelLocalSearchQueryClass* _klass_;
	_klass_ = RYGEL_LOCAL_SEARCH_QUERY_GET_CLASS (self);
	if (_klass_->execute_finish) {
		_klass_->execute_finish (self, _res_, error);
	}
}

static gchar*
rygel_local_search_query_real_to_string (RygelLocalSearchQuery* self)
{
	RygelLocalSearchQueryTriplets* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->triplets;
	_tmp1_ = rygel_local_search_query_triplets_serialize (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
rygel_local_search_query_to_string (RygelLocalSearchQuery* self)
{
	RygelLocalSearchQueryClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_LOCAL_SEARCH_QUERY_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

/**
     * Convenience function to combine Query.escape_string and
     * Regex.escape_string in one function call
     *
     * @param literal A string to escape
     *
     * @return A newly allocated string with the sparql-escaped regex-escaped
     * version of literal. The returned string should be freed with g_free()
     * when no longer needed.
     */
gchar*
rygel_local_search_query_escape_regex (const gchar* literal)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = g_regex_escape_string (literal, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_local_search_query_escape_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
     * tracker_sparql_escape_string: Escapes a string so that it can be
     * used in a SPARQL query. Copied from LocalSearch project.
     *
     * @param literal A string to escape
     *
     * @return A newly-allocated string with the escaped version of
     * literal. The returned string should be freed with g_free() when no
     * longer needed.
     */
gchar*
rygel_local_search_query_escape_string (const gchar* literal)
{
	GString* str = NULL;
	GString* _tmp0_;
	gchar* p = NULL;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	p = literal;
	while (TRUE) {
		gchar* _tmp1_;
		gsize len = 0UL;
		gchar* _tmp2_;
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp14_;
		_tmp1_ = p;
		if (!((*_tmp1_) != '\0')) {
			break;
		}
		_tmp2_ = p;
		len = strcspn ((const gchar*) _tmp2_, "\t\n\r\b\f\"\\");
		_tmp3_ = str;
		_tmp4_ = p;
		g_string_append_len (_tmp3_, (const gchar*) _tmp4_, (gssize) ((glong) len));
		_tmp5_ = p;
		p = _tmp5_ + len;
		_tmp6_ = p;
		switch (*_tmp6_) {
			case '\t':
			{
				GString* _tmp7_;
				_tmp7_ = str;
				g_string_append (_tmp7_, "\\t");
				break;
			}
			case '\n':
			{
				GString* _tmp8_;
				_tmp8_ = str;
				g_string_append (_tmp8_, "\\n");
				break;
			}
			case '\r':
			{
				GString* _tmp9_;
				_tmp9_ = str;
				g_string_append (_tmp9_, "\\r");
				break;
			}
			case '\b':
			{
				GString* _tmp10_;
				_tmp10_ = str;
				g_string_append (_tmp10_, "\\b");
				break;
			}
			case '\f':
			{
				GString* _tmp11_;
				_tmp11_ = str;
				g_string_append (_tmp11_, "\\f");
				break;
			}
			case '"':
			{
				GString* _tmp12_;
				_tmp12_ = str;
				g_string_append (_tmp12_, "\\\"");
				break;
			}
			case '\\':
			{
				GString* _tmp13_;
				_tmp13_ = str;
				g_string_append (_tmp13_, "\\\\");
				break;
			}
			default:
			{
				continue;
			}
		}
		_tmp14_ = p;
		p = _tmp14_ + 1;
	}
	_tmp15_ = str;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (str);
	return result;
}

static void
rygel_local_search_value_query_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_local_search_value_query_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_local_search_query_unref (value->data[0].v_pointer);
	}
}

static void
rygel_local_search_value_query_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_local_search_query_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_local_search_value_query_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_local_search_value_query_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelLocalSearchQuery * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_local_search_query_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_local_search_value_query_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	RygelLocalSearchQuery ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_local_search_query_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_local_search_param_spec_query (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	RygelLocalSearchParamSpecQuery* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_LOCAL_SEARCH_TYPE_QUERY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_local_search_value_get_query (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LOCAL_SEARCH_TYPE_QUERY), NULL);
	return value->data[0].v_pointer;
}

void
rygel_local_search_value_set_query (GValue* value,
                                    gpointer v_object)
{
	RygelLocalSearchQuery * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LOCAL_SEARCH_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_LOCAL_SEARCH_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_local_search_query_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_local_search_query_unref (old);
	}
}

void
rygel_local_search_value_take_query (GValue* value,
                                     gpointer v_object)
{
	RygelLocalSearchQuery * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_LOCAL_SEARCH_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_LOCAL_SEARCH_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_local_search_query_unref (old);
	}
}

static void
rygel_local_search_query_class_init (RygelLocalSearchQueryClass * klass,
                                     gpointer klass_data)
{
	rygel_local_search_query_parent_class = g_type_class_peek_parent (klass);
	((RygelLocalSearchQueryClass *) klass)->finalize = rygel_local_search_query_finalize;
	((RygelLocalSearchQueryClass *) klass)->to_string = (gchar* (*) (RygelLocalSearchQuery*)) rygel_local_search_query_real_to_string;
}

static void
rygel_local_search_query_instance_init (RygelLocalSearchQuery * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_local_search_query_finalize (RygelLocalSearchQuery * obj)
{
	RygelLocalSearchQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_QUERY, RygelLocalSearchQuery);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->triplets);
}

/**
 * Represents LocalSearch SPARQL query
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_query_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_local_search_value_query_init, rygel_local_search_value_query_free_value, rygel_local_search_value_query_copy_value, rygel_local_search_value_query_peek_pointer, "p", rygel_local_search_value_query_collect_value, "p", rygel_local_search_value_query_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchQuery), 0, (GInstanceInitFunc) rygel_local_search_query_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_local_search_query_type_id;
	rygel_local_search_query_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelLocalSearchQuery", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return rygel_local_search_query_type_id;
}

GType
rygel_local_search_query_get_type (void)
{
	static volatile gsize rygel_local_search_query_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_query_type_id__once)) {
		GType rygel_local_search_query_type_id;
		rygel_local_search_query_type_id = rygel_local_search_query_get_type_once ();
		g_once_init_leave (&rygel_local_search_query_type_id__once, rygel_local_search_query_type_id);
	}
	return rygel_local_search_query_type_id__once;
}

gpointer
rygel_local_search_query_ref (gpointer instance)
{
	RygelLocalSearchQuery * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_local_search_query_unref (gpointer instance)
{
	RygelLocalSearchQuery * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_LOCAL_SEARCH_QUERY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

