/* rygel-media-export-extractor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-export-extractor.vala, do not modify */

/*
 * Copyright (C) 2016 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "mx-constants.h"
#include <libgupnp-av/gupnp-av.h>

#define RYGEL_MEDIA_EXPORT_EXTRACTOR_INVALID_CHARS "()[]<>{}!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CONVERT_CHARS "\t_\\."
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCK_PATTERN "%s[^%s]*%s"
#define UPNP_CLASS_VIDEO "object.item.videoItem"
#define UPNP_CLASS_PHOTO "object.item.imageItem.photo"
#define UPNP_CLASS_MUSIC "object.item.audioItem.musicTrack"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXTRACTOR_ERROR (extractor_error_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR (rygel_media_export_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractorClass))

typedef struct _RygelMediaExportExtractor RygelMediaExportExtractor;
typedef struct _RygelMediaExportExtractorClass RygelMediaExportExtractorClass;
typedef struct _RygelMediaExportExtractorPrivate RygelMediaExportExtractorPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_EXTRACTOR_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY,
	RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY,
	RYGEL_MEDIA_EXPORT_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_extractor_properties[RYGEL_MEDIA_EXPORT_EXTRACTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER (rygel_media_export_dvd_parser_get_type ())
#define RYGEL_MEDIA_EXPORT_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParser))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_IS_DVD_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER))
#define RYGEL_MEDIA_EXPORT_DVD_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DVD_PARSER, RygelMediaExportDVDParserClass))

typedef struct _RygelMediaExportDVDParser RygelMediaExportDVDParser;
typedef struct _RygelMediaExportDVDParserClass RygelMediaExportDVDParserClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR (rygel_media_export_playlist_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractor))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_EXTRACTOR, RygelMediaExportPlaylistExtractorClass))

typedef struct _RygelMediaExportPlaylistExtractor RygelMediaExportPlaylistExtractor;
typedef struct _RygelMediaExportPlaylistExtractorClass RygelMediaExportPlaylistExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR (rygel_media_export_image_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractor))
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_IMAGE_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_IMAGE_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IMAGE_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_IMAGE_EXTRACTOR, RygelMediaExportImageExtractorClass))

typedef struct _RygelMediaExportImageExtractor RygelMediaExportImageExtractor;
typedef struct _RygelMediaExportImageExtractorClass RygelMediaExportImageExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR (rygel_media_export_generic_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractor))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_GENERIC_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_GENERIC_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_GENERIC_EXTRACTOR, RygelMediaExportGenericExtractorClass))

typedef struct _RygelMediaExportGenericExtractor RygelMediaExportGenericExtractor;
typedef struct _RygelMediaExportGenericExtractorClass RygelMediaExportGenericExtractorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _RygelMediaExportExtractorRunData RygelMediaExportExtractorRunData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	EXTRACTOR_ERROR_GENERAL,
	EXTRACTOR_ERROR_INVALID
} ExtractorError;
#define EXTRACTOR_ERROR extractor_error_quark ()

struct _RygelMediaExportExtractor {
	GObject parent_instance;
	RygelMediaExportExtractorPrivate * priv;
	GVariantDict* serialized_info;
};

struct _RygelMediaExportExtractorClass {
	GObjectClass parent_class;
	void (*run) (RygelMediaExportExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelMediaExportExtractor* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportExtractorPrivate {
	GFile* _file;
	gboolean _extract_metadata;
};

struct _RygelMediaExportExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaExportExtractor* self;
	GFileInfo* file_info;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	gchar* display_name;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* title;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GVariantDict* _tmp7_;
	const gchar* _tmp8_;
	GVariantDict* _tmp9_;
	const gchar* _tmp10_;
	guint64 mtime;
	GVariantDict* _tmp11_;
	GDateTime* dt;
	GDateTime* _tmp12_;
	gchar* date;
	GDateTime* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GVariantDict* _tmp18_;
	const gchar* _tmp19_;
	gchar* content_type;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	GVariantDict* _tmp24_;
	const gchar* _tmp25_;
	GVariantDict* _tmp26_;
	gboolean _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GVariantDict* _tmp30_;
	GVariantDict* _tmp31_;
	const gchar* _tmp32_;
	GVariantDict* _tmp33_;
	gchar* id;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GVariantDict* _tmp39_;
	const gchar* _tmp40_;
	GVariantDict* _tmp41_;
	GFile* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GError* _inner_error0_;
};

static gint RygelMediaExportExtractor_private_offset;
static gpointer rygel_media_export_extractor_parent_class = NULL;
static GRegex* rygel_media_export_extractor_char_remove_regex;
static GRegex* rygel_media_export_extractor_char_remove_regex = NULL;
static GRegex* rygel_media_export_extractor_char_convert_regex;
static GRegex* rygel_media_export_extractor_char_convert_regex = NULL;
static GRegex* rygel_media_export_extractor_space_compress_regex;
static GRegex* rygel_media_export_extractor_space_compress_regex = NULL;
static GRegex** rygel_media_export_extractor_block_regexes;
static gint rygel_media_export_extractor_block_regexes_length1;
static GRegex** rygel_media_export_extractor_block_regexes = NULL;
static gint rygel_media_export_extractor_block_regexes_length1 = 0;
static gint _rygel_media_export_extractor_block_regexes_size_ = 0;
static GRegex** rygel_media_export_extractor_blacklist_regexes;
static gint rygel_media_export_extractor_blacklist_regexes_length1;
static GRegex** rygel_media_export_extractor_blacklist_regexes = NULL;
static gint rygel_media_export_extractor_blacklist_regexes_length1 = 0;
static gint _rygel_media_export_extractor_blacklist_regexes_size_ = 0;
static GRegex** rygel_media_export_extractor_video_suffix_regexes;
static gint rygel_media_export_extractor_video_suffix_regexes_length1;
static GRegex** rygel_media_export_extractor_video_suffix_regexes = NULL;
static gint rygel_media_export_extractor_video_suffix_regexes_length1 = 0;
static gint _rygel_media_export_extractor_video_suffix_regexes_size_ = 0;

VALA_EXTERN GQuark extractor_error_quark (void);
VALA_EXTERN GType extractor_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_export_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportExtractor, g_object_unref)
VALA_EXTERN void rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error);
VALA_EXTERN RygelMediaExportExtractor* rygel_media_export_extractor_create_for_file (GFile* file,
                                                                         const gchar* content_type,
                                                                         gboolean extract_metadata);
static RygelMediaExportExtractor* rygel_media_export_extractor_new (GFile* file,
                                                             gboolean extract_metadata);
static RygelMediaExportExtractor* rygel_media_export_extractor_construct (GType object_type,
                                                                   GFile* file,
                                                                   gboolean extract_metadata);
VALA_EXTERN RygelMediaExportDVDParser* rygel_media_export_dvd_parser_new (GFile* file);
VALA_EXTERN RygelMediaExportDVDParser* rygel_media_export_dvd_parser_construct (GType object_type,
                                                                    GFile* file);
VALA_EXTERN GType rygel_media_export_dvd_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportDVDParser, g_object_unref)
VALA_EXTERN RygelMediaExportPlaylistExtractor* rygel_media_export_playlist_extractor_new (GFile* file);
VALA_EXTERN RygelMediaExportPlaylistExtractor* rygel_media_export_playlist_extractor_construct (GType object_type,
                                                                                    GFile* file);
VALA_EXTERN GType rygel_media_export_playlist_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportPlaylistExtractor, g_object_unref)
VALA_EXTERN RygelMediaExportImageExtractor* rygel_media_export_image_extractor_new (GFile* file);
VALA_EXTERN RygelMediaExportImageExtractor* rygel_media_export_image_extractor_construct (GType object_type,
                                                                              GFile* file);
VALA_EXTERN GType rygel_media_export_image_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportImageExtractor, g_object_unref)
VALA_EXTERN RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_new (GFile* file);
VALA_EXTERN RygelMediaExportGenericExtractor* rygel_media_export_generic_extractor_construct (GType object_type,
                                                                                  GFile* file);
VALA_EXTERN GType rygel_media_export_generic_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaExportGenericExtractor, g_object_unref)
static void rygel_media_export_extractor_real_constructed (GObject* base);
static void rygel_media_export_extractor_real_run_data_free (gpointer _data);
static void rygel_media_export_extractor_real_run (RygelMediaExportExtractor* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean rygel_media_export_extractor_real_run_co (RygelMediaExportExtractorRunData* _data_);
VALA_EXTERN GFile* rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self);
static void rygel_media_export_extractor_run_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN gboolean rygel_media_export_extractor_get_extract_metadata (RygelMediaExportExtractor* self);
static gchar* rygel_media_export_extractor_strip_invalid_entities (RygelMediaExportExtractor* self,
                                                            const gchar* original);
VALA_EXTERN GVariant* rygel_media_export_extractor_get (RygelMediaExportExtractor* self);
static void _vala_array_add1 (GRegex** * array,
                       gint* length,
                       gint* size,
                       GRegex* value);
static void _vala_array_add2 (GRegex** * array,
                       gint* length,
                       gint* size,
                       GRegex* value);
static void _vala_array_add3 (GRegex** * array,
                       gint* length,
                       gint* size,
                       GRegex* value);
VALA_EXTERN void rygel_media_export_extractor_set_file (RygelMediaExportExtractor* self,
                                            GFile* value);
VALA_EXTERN void rygel_media_export_extractor_set_extract_metadata (RygelMediaExportExtractor* self,
                                                        gboolean value);
static void rygel_media_export_extractor_finalize (GObject * obj);
static GType rygel_media_export_extractor_get_type_once (void);
static void _vala_rygel_media_export_extractor_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_media_export_extractor_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS[4] = {"()", "{}", "[]", "<>"};
static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST[14] = {"720p", "1080p", "x264", "ws", "proper", "real.repack", "repack", "hdtv", "pdtv", "notv", "dsr", "DVDRip", "divx", "xvid"};
static const gchar* RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES[22] = {"webm", "mkv", "flv", "ogv", "ogg", "avi", "mov", "wmv", "mp4", "m4v", "mpeg", "mpg", "iso", "mp3", "m4a", "png", "jpg", "jpeg", "ogv", "oga", "3gp", "xml"};

GQuark
extractor_error_quark (void)
{
	return g_quark_from_static_string ("extractor-error-quark");
}

 G_GNUC_NO_INLINE static GType
extractor_error_get_type_once (void)
{
	static const GEnumValue values[] = {{EXTRACTOR_ERROR_GENERAL, "EXTRACTOR_ERROR_GENERAL", "general"}, {EXTRACTOR_ERROR_INVALID, "EXTRACTOR_ERROR_INVALID", "invalid"}, {0, NULL, NULL}};
	GType extractor_error_type_id;
	extractor_error_type_id = g_enum_register_static ("ExtractorError", values);
	return extractor_error_type_id;
}

GType
extractor_error_get_type (void)
{
	static volatile gsize extractor_error_type_id__once = 0;
	if (g_once_init_enter (&extractor_error_type_id__once)) {
		GType extractor_error_type_id;
		extractor_error_type_id = extractor_error_get_type_once ();
		g_once_init_leave (&extractor_error_type_id__once, extractor_error_type_id);
	}
	return extractor_error_type_id__once;
}

static inline gpointer
rygel_media_export_extractor_get_instance_private (RygelMediaExportExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportExtractor_private_offset);
}

/**
     * Factory method for creating specific extractors depending on the
     * content type of the file
     */
RygelMediaExportExtractor*
rygel_media_export_extractor_create_for_file (GFile* file,
                                              const gchar* content_type,
                                              gboolean extract_metadata)
{
	gboolean _tmp1_ = FALSE;
	gboolean is_text = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelMediaExportGenericExtractor* _tmp6_;
	RygelMediaExportExtractor* result;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (content_type != NULL, NULL);
	if (!extract_metadata) {
		RygelMediaExportExtractor* _tmp0_;
		_tmp0_ = rygel_media_export_extractor_new (file, FALSE);
		result = _tmp0_;
		return result;
	}
	if (g_str_has_prefix (content_type, "text/")) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_str_has_suffix (content_type, "xml");
	}
	is_text = _tmp1_;
	if (g_strcmp0 (content_type, "application/x-cd-image") == 0) {
		RygelMediaExportDVDParser* _tmp2_;
		_tmp2_ = rygel_media_export_dvd_parser_new (file);
		result = (RygelMediaExportExtractor*) _tmp2_;
		return result;
	}
	if (is_text) {
		RygelMediaExportPlaylistExtractor* _tmp3_;
		_tmp3_ = rygel_media_export_playlist_extractor_new (file);
		result = (RygelMediaExportExtractor*) _tmp3_;
		return result;
	}
	if (g_strcmp0 (content_type, "image/jpeg") == 0) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (content_type, "image/png") == 0;
	}
	if (_tmp4_) {
		RygelMediaExportImageExtractor* _tmp5_;
		_tmp5_ = rygel_media_export_image_extractor_new (file);
		result = (RygelMediaExportExtractor*) _tmp5_;
		return result;
	}
	_tmp6_ = rygel_media_export_generic_extractor_new (file);
	result = (RygelMediaExportExtractor*) _tmp6_;
	return result;
}

static RygelMediaExportExtractor*
rygel_media_export_extractor_construct (GType object_type,
                                        GFile* file,
                                        gboolean extract_metadata)
{
	RygelMediaExportExtractor * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (RygelMediaExportExtractor*) g_object_new (object_type, "file", file, "extract-metadata", extract_metadata, NULL);
	return self;
}

static RygelMediaExportExtractor*
rygel_media_export_extractor_new (GFile* file,
                                  gboolean extract_metadata)
{
	return rygel_media_export_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, file, extract_metadata);
}

static void
rygel_media_export_extractor_real_constructed (GObject* base)
{
	RygelMediaExportExtractor * self;
	GVariantDict* _tmp0_;
	self = (RygelMediaExportExtractor*) base;
	_tmp0_ = g_variant_dict_new (NULL);
	_g_variant_dict_unref0 (self->serialized_info);
	self->serialized_info = _tmp0_;
}

static void
rygel_media_export_extractor_real_run_data_free (gpointer _data)
{
	RygelMediaExportExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportExtractorRunData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_media_export_extractor_real_run (RygelMediaExportExtractor* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	RygelMediaExportExtractorRunData* _data_;
	RygelMediaExportExtractor* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportExtractorRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_extractor_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_extractor_real_run_co (_data_);
}

static void
rygel_media_export_extractor_real_run_finish (RygelMediaExportExtractor* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	RygelMediaExportExtractorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_media_export_extractor_run_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelMediaExportExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_extractor_real_run_co (_data_);
}

static gboolean
rygel_media_export_extractor_real_run_co (RygelMediaExportExtractorRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_file;
	_data_->_state_ = 1;
	g_file_query_info_async (_data_->_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_media_export_extractor_run_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->file_info = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = g_file_info_get_display_name (_data_->file_info);
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->display_name = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->_extract_metadata;
	if (_data_->_tmp4_) {
		_data_->_tmp5_ = _data_->display_name;
		_data_->_tmp6_ = rygel_media_export_extractor_strip_invalid_entities (_data_->self, _data_->_tmp5_);
		_data_->title = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->self->serialized_info;
		_data_->_tmp8_ = _data_->title;
		g_variant_dict_insert (_data_->_tmp7_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _data_->_tmp8_, NULL);
		_g_free0 (_data_->title);
	} else {
		_data_->_tmp9_ = _data_->self->serialized_info;
		_data_->_tmp10_ = _data_->display_name;
		g_variant_dict_insert (_data_->_tmp9_, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, "s", _data_->_tmp10_, NULL);
	}
	_data_->mtime = g_file_info_get_attribute_uint64 (_data_->file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_data_->_tmp11_ = _data_->self->serialized_info;
	g_variant_dict_insert (_data_->_tmp11_, RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED, "t", _data_->mtime, NULL);
	_data_->_tmp12_ = g_date_time_new_from_unix_utc ((gint64) _data_->mtime);
	_data_->dt = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->dt;
	_data_->_tmp14_ = g_date_time_format (_data_->_tmp13_, "%Y-%m-%dT%H:%M:%S");
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_strdup_printf ("%sZ", _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	_g_free0 (_data_->_tmp15_);
	_data_->date = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->self->serialized_info;
	_data_->_tmp19_ = _data_->date;
	g_variant_dict_insert (_data_->_tmp18_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _data_->_tmp19_, NULL);
	_data_->_tmp20_ = g_file_info_get_content_type (_data_->file_info);
	_data_->_tmp21_ = g_content_type_get_mime_type (_data_->_tmp20_);
	_data_->content_type = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->self->priv->_extract_metadata;
	if (!_data_->_tmp22_) {
		_data_->_tmp23_ = _data_->content_type;
		if (g_str_has_prefix (_data_->_tmp23_, "video/")) {
			_data_->_tmp24_ = _data_->self->serialized_info;
			g_variant_dict_insert (_data_->_tmp24_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_VIDEO, NULL);
		} else {
			_data_->_tmp25_ = _data_->content_type;
			if (g_str_has_prefix (_data_->_tmp25_, "image/")) {
				_data_->_tmp26_ = _data_->self->serialized_info;
				g_variant_dict_insert (_data_->_tmp26_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_PHOTO, NULL);
			} else {
				_data_->_tmp28_ = _data_->content_type;
				if (g_str_has_prefix (_data_->_tmp28_, "audio/")) {
					_data_->_tmp27_ = TRUE;
				} else {
					_data_->_tmp29_ = _data_->content_type;
					_data_->_tmp27_ = g_strcmp0 (_data_->_tmp29_, "application/ogg") == 0;
				}
				if (_data_->_tmp27_) {
					_data_->_tmp30_ = _data_->self->serialized_info;
					g_variant_dict_insert (_data_->_tmp30_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, "s", UPNP_CLASS_MUSIC, NULL);
				} else {
				}
			}
		}
	}
	_data_->_tmp31_ = _data_->self->serialized_info;
	_data_->_tmp32_ = _data_->content_type;
	g_variant_dict_insert (_data_->_tmp31_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, "s", _data_->_tmp32_, NULL);
	_data_->_tmp33_ = _data_->self->serialized_info;
	g_variant_dict_insert (_data_->_tmp33_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE, "t", g_file_info_get_size (_data_->file_info), NULL);
	_data_->_tmp34_ = _data_->self->priv->_file;
	_data_->_tmp35_ = g_file_get_uri (_data_->_tmp34_);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _data_->_tmp36_, (gsize) -1);
	_data_->_tmp38_ = _data_->_tmp37_;
	_g_free0 (_data_->_tmp36_);
	_data_->id = _data_->_tmp38_;
	_data_->_tmp39_ = _data_->self->serialized_info;
	_data_->_tmp40_ = _data_->id;
	g_variant_dict_insert (_data_->_tmp39_, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, "s", _data_->_tmp40_, NULL);
	_data_->_tmp41_ = _data_->self->serialized_info;
	_data_->_tmp42_ = _data_->self->priv->_file;
	_data_->_tmp43_ = g_file_get_uri (_data_->_tmp42_);
	_data_->_tmp44_ = _data_->_tmp43_;
	g_variant_dict_insert (_data_->_tmp41_, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, "s", _data_->_tmp44_, NULL);
	_g_free0 (_data_->_tmp44_);
	_g_free0 (_data_->id);
	_g_free0 (_data_->content_type);
	_g_free0 (_data_->date);
	_g_date_time_unref0 (_data_->dt);
	_g_free0 (_data_->display_name);
	_g_object_unref0 (_data_->file_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_media_export_extractor_run (RygelMediaExportExtractor* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelMediaExportExtractorClass* _klass_;
	_klass_ = RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS (self);
	if (_klass_->run) {
		_klass_->run (self, _callback_, _user_data_);
	}
}

void
rygel_media_export_extractor_run_finish (RygelMediaExportExtractor* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	RygelMediaExportExtractorClass* _klass_;
	_klass_ = RYGEL_MEDIA_EXPORT_EXTRACTOR_GET_CLASS (self);
	if (_klass_->run_finish) {
		_klass_->run_finish (self, _res_, error);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

GVariant*
rygel_media_export_extractor_get (RygelMediaExportExtractor* self)
{
	GVariant* date = NULL;
	GVariantDict* _tmp0_;
	const GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	GVariantDict* _tmp12_;
	GVariant* _tmp13_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->serialized_info;
	_tmp1_ = G_VARIANT_TYPE_STRING;
	_tmp2_ = g_variant_dict_lookup_value (_tmp0_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, _tmp1_);
	date = _tmp2_;
	_tmp3_ = date;
	_tmp4_ = g_variant_get_string (_tmp3_, NULL);
	if (string_contains (_tmp4_, "T")) {
		GDateTime* fixed_date = NULL;
		GVariant* _tmp5_;
		const gchar* _tmp6_;
		GDateTime* _tmp7_;
		gchar* new_date = NULL;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		GVariantDict* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = date;
		_tmp6_ = g_variant_get_string (_tmp5_, NULL);
		_tmp7_ = g_date_time_new_from_iso8601 (_tmp6_, NULL);
		fixed_date = _tmp7_;
		_tmp8_ = fixed_date;
		_tmp9_ = gupnp_format_date_time_for_didl_lite (_tmp8_, FALSE);
		new_date = _tmp9_;
		_tmp10_ = self->serialized_info;
		_tmp11_ = new_date;
		g_variant_dict_insert (_tmp10_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, "s", _tmp11_, NULL);
		_g_free0 (new_date);
		_g_date_time_unref0 (fixed_date);
	}
	_tmp12_ = self->serialized_info;
	_tmp13_ = g_variant_dict_end (_tmp12_);
	g_variant_ref_sink (_tmp13_);
	result = _tmp13_;
	_g_variant_unref0 (date);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
_vala_array_add1 (GRegex** * array,
                  gint* length,
                  gint* size,
                  GRegex* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (GRegex** * array,
                  gint* length,
                  gint* size,
                  GRegex* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
_vala_array_add3 (GRegex** * array,
                  gint* length,
                  gint* size,
                  GRegex* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GRegex*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
rygel_media_export_extractor_strip_invalid_entities (RygelMediaExportExtractor* self,
                                                     const gchar* original)
{
	GRegex* _tmp0_;
	gchar* p = NULL;
	gchar* _tmp56_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = rygel_media_export_extractor_char_remove_regex;
	if (_tmp0_ == NULL) {
		{
			gchar* regex_string = NULL;
			gchar* _tmp1_;
			GRegex* _tmp2_ = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GRegex* _tmp6_;
			GRegex* _tmp7_;
			GRegex* _tmp8_;
			gchar* _tmp9_;
			GRegex* _tmp10_ = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GRegex* _tmp14_;
			GRegex* _tmp15_;
			GRegex* _tmp16_;
			GRegex* _tmp17_ = NULL;
			GRegex* _tmp18_;
			GRegex* _tmp19_;
			GRegex** _tmp20_;
			_tmp1_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_EXTRACTOR_INVALID_CHARS, -1);
			regex_string = _tmp1_;
			_tmp3_ = regex_string;
			_tmp4_ = g_strdup_printf ("[%s]", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error0_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_tmp2_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (regex_string);
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp8_ = _tmp2_;
			_tmp2_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_char_remove_regex);
			rygel_media_export_extractor_char_remove_regex = _tmp8_;
			_tmp9_ = g_regex_escape_string (RYGEL_MEDIA_EXPORT_EXTRACTOR_CONVERT_CHARS, -1);
			_g_free0 (regex_string);
			regex_string = _tmp9_;
			_tmp11_ = regex_string;
			_tmp12_ = g_strdup_printf ("[%s]", _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_regex_new (_tmp13_, 0, 0, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			_tmp10_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp16_ = _tmp10_;
			_tmp10_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_char_convert_regex);
			rygel_media_export_extractor_char_convert_regex = _tmp16_;
			_tmp18_ = g_regex_new ("\\s+", 0, 0, &_inner_error0_);
			_tmp17_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (_tmp10_);
				_g_regex_unref0 (_tmp2_);
				_g_free0 (regex_string);
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp19_ = _tmp17_;
			_tmp17_ = NULL;
			_g_regex_unref0 (rygel_media_export_extractor_space_compress_regex);
			rygel_media_export_extractor_space_compress_regex = _tmp19_;
			_tmp20_ = g_new0 (GRegex*, 0 + 1);
			rygel_media_export_extractor_block_regexes = (_vala_array_free (rygel_media_export_extractor_block_regexes, rygel_media_export_extractor_block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
			rygel_media_export_extractor_block_regexes = _tmp20_;
			rygel_media_export_extractor_block_regexes_length1 = 0;
			_rygel_media_export_extractor_block_regexes_size_ = rygel_media_export_extractor_block_regexes_length1;
			{
				const gchar** block_collection = NULL;
				gint block_collection_length1 = 0;
				gint _block_collection_size_ = 0;
				gint block_it = 0;
				block_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS;
				block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCKS);
				for (block_it = 0; block_it < block_collection_length1; block_it = block_it + 1) {
					const gchar* block = NULL;
					block = block_collection[block_it];
					{
						gchar* block_re = NULL;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						GRegex* _tmp38_ = NULL;
						const gchar* _tmp39_;
						GRegex* _tmp40_;
						GRegex* _tmp41_;
						_tmp21_ = block;
						_tmp22_ = g_strdup_printf ("%C", string_get (_tmp21_, (glong) 0));
						_tmp23_ = _tmp22_;
						_tmp24_ = g_regex_escape_string (_tmp23_, -1);
						_tmp25_ = _tmp24_;
						_tmp26_ = block;
						_tmp27_ = g_strdup_printf ("%C", string_get (_tmp26_, (glong) 1));
						_tmp28_ = _tmp27_;
						_tmp29_ = g_regex_escape_string (_tmp28_, -1);
						_tmp30_ = _tmp29_;
						_tmp31_ = block;
						_tmp32_ = g_strdup_printf ("%C", string_get (_tmp31_, (glong) 1));
						_tmp33_ = _tmp32_;
						_tmp34_ = g_regex_escape_string (_tmp33_, -1);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strdup_printf (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLOCK_PATTERN, _tmp25_, _tmp30_, _tmp35_);
						_tmp37_ = _tmp36_;
						_g_free0 (_tmp35_);
						_g_free0 (_tmp33_);
						_g_free0 (_tmp30_);
						_g_free0 (_tmp28_);
						_g_free0 (_tmp25_);
						_g_free0 (_tmp23_);
						block_re = _tmp37_;
						_tmp39_ = block_re;
						_tmp40_ = g_regex_new (_tmp39_, 0, 0, &_inner_error0_);
						_tmp38_ = _tmp40_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (block_re);
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error0_->domain == G_REGEX_ERROR) {
								goto __catch0_g_regex_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp41_ = _tmp38_;
						_tmp38_ = NULL;
						_vala_array_add1 (&rygel_media_export_extractor_block_regexes, &rygel_media_export_extractor_block_regexes_length1, &_rygel_media_export_extractor_block_regexes_size_, _tmp41_);
						_g_regex_unref0 (_tmp38_);
						_g_free0 (block_re);
					}
				}
			}
			{
				const gchar** blacklist_collection = NULL;
				gint blacklist_collection_length1 = 0;
				gint _blacklist_collection_size_ = 0;
				gint blacklist_it = 0;
				blacklist_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST;
				blacklist_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_BLACKLIST);
				for (blacklist_it = 0; blacklist_it < blacklist_collection_length1; blacklist_it = blacklist_it + 1) {
					const gchar* blacklist = NULL;
					blacklist = blacklist_collection[blacklist_it];
					{
						GRegex* _tmp42_ = NULL;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						GRegex* _tmp46_;
						GRegex* _tmp47_;
						GRegex* _tmp48_;
						_tmp43_ = blacklist;
						_tmp44_ = g_regex_escape_string (_tmp43_, -1);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_regex_new (_tmp45_, 0, 0, &_inner_error0_);
						_tmp47_ = _tmp46_;
						_g_free0 (_tmp45_);
						_tmp42_ = _tmp47_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error0_->domain == G_REGEX_ERROR) {
								goto __catch0_g_regex_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp48_ = _tmp42_;
						_tmp42_ = NULL;
						_vala_array_add2 (&rygel_media_export_extractor_blacklist_regexes, &rygel_media_export_extractor_blacklist_regexes_length1, &_rygel_media_export_extractor_blacklist_regexes_size_, _tmp48_);
						_g_regex_unref0 (_tmp42_);
					}
				}
			}
			{
				const gchar** suffix_collection = NULL;
				gint suffix_collection_length1 = 0;
				gint _suffix_collection_size_ = 0;
				gint suffix_it = 0;
				suffix_collection = RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES;
				suffix_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_EXPORT_EXTRACTOR_VIDEO_SUFFIXES);
				for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
					const gchar* suffix = NULL;
					suffix = suffix_collection[suffix_it];
					{
						GRegex* regex = NULL;
						const gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						GRegex* _tmp52_;
						GRegex* _tmp53_;
						GRegex* _tmp54_;
						GRegex* _tmp55_;
						_tmp49_ = suffix;
						_tmp50_ = g_regex_escape_string (_tmp49_, -1);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_regex_new (_tmp51_, G_REGEX_CASELESS, 0, &_inner_error0_);
						_tmp53_ = _tmp52_;
						_g_free0 (_tmp51_);
						regex = _tmp53_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_regex_unref0 (_tmp17_);
							_g_regex_unref0 (_tmp10_);
							_g_regex_unref0 (_tmp2_);
							_g_free0 (regex_string);
							if (_inner_error0_->domain == G_REGEX_ERROR) {
								goto __catch0_g_regex_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp54_ = regex;
						_tmp55_ = _g_regex_ref0 (_tmp54_);
						_vala_array_add3 (&rygel_media_export_extractor_video_suffix_regexes, &rygel_media_export_extractor_video_suffix_regexes_length1, &_rygel_media_export_extractor_video_suffix_regexes_size_, _tmp55_);
						_g_regex_unref0 (regex);
					}
				}
			}
			_g_regex_unref0 (_tmp17_);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp2_);
			_g_free0 (regex_string);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
			g_assert_not_reached ();
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp56_ = g_strdup (original);
	_g_free0 (p);
	p = _tmp56_;
	{
		GRegex** _tmp57_;
		gint _tmp57__length1;
		GRegex** _tmp64_;
		gint _tmp64__length1;
		GRegex** _tmp71_;
		gint _tmp71__length1;
		gchar* _tmp78_ = NULL;
		GRegex* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_ = NULL;
		GRegex* _tmp84_;
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_ = NULL;
		GRegex* _tmp89_;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		const gchar* _tmp93_;
		_tmp57_ = rygel_media_export_extractor_blacklist_regexes;
		_tmp57__length1 = rygel_media_export_extractor_blacklist_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp57_;
			re_collection_length1 = _tmp57__length1;
			for (re_it = 0; re_it < re_collection_length1; re_it = re_it + 1) {
				GRegex* _tmp58_;
				GRegex* re = NULL;
				_tmp58_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp58_;
				{
					gchar* _tmp59_ = NULL;
					GRegex* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp60_ = re;
					_tmp61_ = p;
					_tmp62_ = g_regex_replace_literal (_tmp60_, _tmp61_, (gssize) -1, 0, "", 0, &_inner_error0_);
					_tmp59_ = _tmp62_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp63_ = _tmp59_;
					_tmp59_ = NULL;
					_g_free0 (p);
					p = _tmp63_;
					_g_free0 (_tmp59_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp64_ = rygel_media_export_extractor_video_suffix_regexes;
		_tmp64__length1 = rygel_media_export_extractor_video_suffix_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp64_;
			re_collection_length1 = _tmp64__length1;
			for (re_it = 0; re_it < re_collection_length1; re_it = re_it + 1) {
				GRegex* _tmp65_;
				GRegex* re = NULL;
				_tmp65_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp65_;
				{
					gchar* _tmp66_ = NULL;
					GRegex* _tmp67_;
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					_tmp67_ = re;
					_tmp68_ = p;
					_tmp69_ = g_regex_replace_literal (_tmp67_, _tmp68_, (gssize) -1, 0, "", 0, &_inner_error0_);
					_tmp66_ = _tmp69_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp70_ = _tmp66_;
					_tmp66_ = NULL;
					_g_free0 (p);
					p = _tmp70_;
					_g_free0 (_tmp66_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp71_ = rygel_media_export_extractor_block_regexes;
		_tmp71__length1 = rygel_media_export_extractor_block_regexes_length1;
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
			re_collection = _tmp71_;
			re_collection_length1 = _tmp71__length1;
			for (re_it = 0; re_it < re_collection_length1; re_it = re_it + 1) {
				GRegex* _tmp72_;
				GRegex* re = NULL;
				_tmp72_ = _g_regex_ref0 (re_collection[re_it]);
				re = _tmp72_;
				{
					gchar* _tmp73_ = NULL;
					GRegex* _tmp74_;
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp74_ = re;
					_tmp75_ = p;
					_tmp76_ = g_regex_replace_literal (_tmp74_, _tmp75_, (gssize) -1, 0, "", 0, &_inner_error0_);
					_tmp73_ = _tmp76_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_regex_unref0 (re);
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch1_g_regex_error;
						}
						_g_free0 (p);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp77_ = _tmp73_;
					_tmp73_ = NULL;
					_g_free0 (p);
					p = _tmp77_;
					_g_free0 (_tmp73_);
					_g_regex_unref0 (re);
				}
			}
		}
		_tmp79_ = rygel_media_export_extractor_char_remove_regex;
		_tmp80_ = p;
		_tmp81_ = g_regex_replace_literal (_tmp79_, _tmp80_, (gssize) -1, 0, "", 0, &_inner_error0_);
		_tmp78_ = _tmp81_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp82_ = _tmp78_;
		_tmp78_ = NULL;
		_g_free0 (p);
		p = _tmp82_;
		_tmp84_ = rygel_media_export_extractor_char_convert_regex;
		_tmp85_ = p;
		_tmp86_ = g_regex_replace_literal (_tmp84_, _tmp85_, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp83_ = _tmp86_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp78_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp87_ = _tmp83_;
		_tmp83_ = NULL;
		_g_free0 (p);
		p = _tmp87_;
		_tmp89_ = rygel_media_export_extractor_space_compress_regex;
		_tmp90_ = p;
		_tmp91_ = g_regex_replace_literal (_tmp89_, _tmp90_, (gssize) -1, 0, " ", 0, &_inner_error0_);
		_tmp88_ = _tmp91_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp83_);
			_g_free0 (_tmp78_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_free0 (p);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp92_ = _tmp88_;
		_tmp88_ = NULL;
		_g_free0 (p);
		p = _tmp92_;
		_tmp93_ = p;
		g_strstrip (_tmp93_);
		result = p;
		_g_free0 (_tmp88_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp78_);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally1:
	_g_free0 (p);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

GFile*
rygel_media_export_extractor_get_file (RygelMediaExportExtractor* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

void
rygel_media_export_extractor_set_file (RygelMediaExportExtractor* self,
                                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_export_extractor_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_extractor_properties[RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY]);
	}
}

gboolean
rygel_media_export_extractor_get_extract_metadata (RygelMediaExportExtractor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_extract_metadata;
	return result;
}

void
rygel_media_export_extractor_set_extract_metadata (RygelMediaExportExtractor* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_export_extractor_get_extract_metadata (self);
	if (old_value != value) {
		self->priv->_extract_metadata = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_extractor_properties[RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY]);
	}
}

static void
rygel_media_export_extractor_class_init (RygelMediaExportExtractorClass * klass,
                                         gpointer klass_data)
{
	rygel_media_export_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportExtractor_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_media_export_extractor_real_constructed;
	((RygelMediaExportExtractorClass *) klass)->run = (void (*) (RygelMediaExportExtractor*, GAsyncReadyCallback, gpointer)) rygel_media_export_extractor_real_run;
	((RygelMediaExportExtractorClass *) klass)->run_finish = (void (*) (RygelMediaExportExtractor*, GAsyncResult*, GError**)) rygel_media_export_extractor_real_run_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_extractor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_extractor_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_extractor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY, rygel_media_export_extractor_properties[RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY, rygel_media_export_extractor_properties[RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY] = g_param_spec_boolean ("extract-metadata", "extract-metadata", "extract-metadata", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
rygel_media_export_extractor_instance_init (RygelMediaExportExtractor * self,
                                            gpointer klass)
{
	self->priv = rygel_media_export_extractor_get_instance_private (self);
	self->priv->_extract_metadata = TRUE;
}

static void
rygel_media_export_extractor_finalize (GObject * obj)
{
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	_g_object_unref0 (self->priv->_file);
	_g_variant_dict_unref0 (self->serialized_info);
	G_OBJECT_CLASS (rygel_media_export_extractor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_media_export_extractor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportExtractor), 0, (GInstanceInitFunc) rygel_media_export_extractor_instance_init, NULL };
	GType rygel_media_export_extractor_type_id;
	rygel_media_export_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportExtractor", &g_define_type_info, 0);
	RygelMediaExportExtractor_private_offset = g_type_add_instance_private (rygel_media_export_extractor_type_id, sizeof (RygelMediaExportExtractorPrivate));
	return rygel_media_export_extractor_type_id;
}

GType
rygel_media_export_extractor_get_type (void)
{
	static volatile gsize rygel_media_export_extractor_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_extractor_type_id__once)) {
		GType rygel_media_export_extractor_type_id;
		rygel_media_export_extractor_type_id = rygel_media_export_extractor_get_type_once ();
		g_once_init_leave (&rygel_media_export_extractor_type_id__once, rygel_media_export_extractor_type_id);
	}
	return rygel_media_export_extractor_type_id__once;
}

static void
_vala_rygel_media_export_extractor_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY:
		g_value_set_object (value, rygel_media_export_extractor_get_file (self));
		break;
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY:
		g_value_set_boolean (value, rygel_media_export_extractor_get_extract_metadata (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_export_extractor_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelMediaExportExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_EXTRACTOR, RygelMediaExportExtractor);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_FILE_PROPERTY:
		rygel_media_export_extractor_set_file (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_EXPORT_EXTRACTOR_EXTRACT_METADATA_PROPERTY:
		rygel_media_export_extractor_set_extract_metadata (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

