
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "addressableitemcontextmenu_wrapper.h"

// Wrappers providing overrides
#include "mainwindow_wrapper.h"
#include "cutterdockwidget_wrapper.h"

// Argument includes
#include <MainWindow.h>
#include <QString>
#include <qaction.h>
#include <qbytearray.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_AddressableItemContextMenu_Type = nullptr;
static PyTypeObject *Sbk_AddressableItemContextMenu_TypeF(void)
{
    return _Sbk_AddressableItemContextMenu_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void AddressableItemContextMenuWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

AddressableItemContextMenuWrapper::AddressableItemContextMenuWrapper(::QWidget * parent, ::MainWindow * mainWindow) : AddressableItemContextMenu(parent, mainWindow)
{
}

void AddressableItemContextMenuWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::actionEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_actionEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::changeEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_changeEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    MainWindowWrapper::sbk_o_childEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    MainWindowWrapper::sbk_o_closeEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("AddressableItemContextMenu", funcName, gil, pyOverride, signal);
}

void AddressableItemContextMenuWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    MainWindowWrapper::sbk_o_contextMenuEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    MainWindowWrapper::sbk_o_customEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

int AddressableItemContextMenuWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return MainWindowWrapper::sbk_o_devType("AddressableItemContextMenu", funcName, gil, pyOverride);
}

void AddressableItemContextMenuWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("AddressableItemContextMenu", funcName, gil, pyOverride, signal);
}

void AddressableItemContextMenuWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    MainWindowWrapper::sbk_o_dragEnterEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    MainWindowWrapper::sbk_o_dragLeaveEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    MainWindowWrapper::sbk_o_dragMoveEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    MainWindowWrapper::sbk_o_dropEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::enterEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_enterEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

bool AddressableItemContextMenuWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::event(arg__1);
    }
    return CutterDockWidgetWrapper::sbk_o_event("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

bool AddressableItemContextMenuWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return CutterDockWidgetWrapper::sbk_o_eventFilter("AddressableItemContextMenu", funcName, gil, pyOverride, watched, event);
}

void AddressableItemContextMenuWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    MainWindowWrapper::sbk_o_focusInEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

bool AddressableItemContextMenuWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::focusNextPrevChild(next);
    }
    return MainWindowWrapper::sbk_o_focusNextPrevChild("AddressableItemContextMenu", funcName, gil, pyOverride, next);
}

void AddressableItemContextMenuWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    MainWindowWrapper::sbk_o_focusOutEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

bool AddressableItemContextMenuWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return MainWindowWrapper::sbk_o_hasHeightForWidth("AddressableItemContextMenu", funcName, gil, pyOverride);
}

int AddressableItemContextMenuWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return MainWindowWrapper::sbk_o_heightForWidth("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::hideEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_hideEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    MainWindowWrapper::sbk_o_initPainter("AddressableItemContextMenu", funcName, gil, pyOverride, painter);
}

void AddressableItemContextMenuWrapper::initStyleOption(::QStyleOptionMenuItem * option, const ::QAction * action) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::initStyleOption(option, action);
    }
    sbk_o_initStyleOption("AddressableItemContextMenu", funcName, gil, pyOverride, option, action);
}

void AddressableItemContextMenuWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionMenuItem * option, const ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void AddressableItemContextMenuWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    MainWindowWrapper::sbk_o_inputMethodEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

::QVariant AddressableItemContextMenuWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return MainWindowWrapper::sbk_o_inputMethodQuery("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::keyPressEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_keyPressEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    MainWindowWrapper::sbk_o_keyReleaseEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::leaveEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_leaveEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

int AddressableItemContextMenuWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return MainWindowWrapper::sbk_o_metric("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

::QSize AddressableItemContextMenuWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return MainWindowWrapper::sbk_o_minimumSizeHint("AddressableItemContextMenu", funcName, gil, pyOverride);
}

void AddressableItemContextMenuWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    MainWindowWrapper::sbk_o_mouseDoubleClickEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseMoveEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_mouseMoveEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mousePressEvent(arg__1);
    }
    CutterDockWidgetWrapper::sbk_o_mousePressEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseReleaseEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_mouseReleaseEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    MainWindowWrapper::sbk_o_moveEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

bool AddressableItemContextMenuWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return MainWindowWrapper::sbk_o_nativeEvent("AddressableItemContextMenu", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * AddressableItemContextMenuWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return MainWindowWrapper::sbk_o_paintEngine("AddressableItemContextMenu", funcName, gil, pyOverride);
}

void AddressableItemContextMenuWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::paintEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_paintEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * AddressableItemContextMenuWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return MainWindowWrapper::sbk_o_redirected("AddressableItemContextMenu", funcName, gil, pyOverride, offset);
}

void AddressableItemContextMenuWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    MainWindowWrapper::sbk_o_resizeEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    MainWindowWrapper::sbk_o_setVisible("AddressableItemContextMenu", funcName, gil, pyOverride, visible);
}

::QPainter * AddressableItemContextMenuWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return MainWindowWrapper::sbk_o_sharedPainter("AddressableItemContextMenu", funcName, gil, pyOverride);
}

void AddressableItemContextMenuWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    MainWindowWrapper::sbk_o_showEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

::QSize AddressableItemContextMenuWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::sizeHint();
    }
    return MainWindowWrapper::sbk_o_minimumSizeHint("AddressableItemContextMenu", funcName, gil, pyOverride);
}

void AddressableItemContextMenuWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    MainWindowWrapper::sbk_o_tabletEvent("AddressableItemContextMenu", funcName, gil, pyOverride, event);
}

void AddressableItemContextMenuWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::timerEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_timerEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

void AddressableItemContextMenuWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AddressableItemContextMenu_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::wheelEvent(arg__1);
    }
    MainWindowWrapper::sbk_o_wheelEvent("AddressableItemContextMenu", funcName, gil, pyOverride, arg__1);
}

const QMetaObject *AddressableItemContextMenuWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return AddressableItemContextMenu::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int AddressableItemContextMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = AddressableItemContextMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *AddressableItemContextMenuWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< AddressableItemContextMenuWrapper *>(this));
    }
    return AddressableItemContextMenu::qt_metacast(_clname);
}

AddressableItemContextMenuWrapper::~AddressableItemContextMenuWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_AddressableItemContextMenu_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_AddressableItemContextMenu_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::AddressableItemContextMenu >()))
        return -1;

    AddressableItemContextMenuWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "AddressableItemContextMenu", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: AddressableItemContextMenu::AddressableItemContextMenu(QWidget*,MainWindow*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_MainWindow_IDX]), (pyArgs[1])))) {
        overloadId = 0; // AddressableItemContextMenu(QWidget*,MainWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::MainWindow *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // AddressableItemContextMenu(QWidget*,MainWindow*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) AddressableItemContextMenuWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new AddressableItemContextMenuWrapper(cppArg0, cppArg1);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< AddressableItemContextMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);
    };


    return 1;
}

static PyObject *Sbk_AddressableItemContextMenuFunc_clearTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearTarget()
        cppSelf->clearTarget();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AddressableItemContextMenuFunc_setHasTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AddressableItemContextMenu::setHasTarget(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setHasTarget(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHasTarget", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHasTarget(bool)
            cppSelf->setHasTarget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AddressableItemContextMenuFunc_setOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AddressableItemContextMenu::setOffset(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // setOffset(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOffset", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOffset(qulonglong)
            cppSelf->setOffset(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AddressableItemContextMenuFunc_setTarget(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setTarget", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setTarget", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: AddressableItemContextMenu::setTarget(qulonglong,QString=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setTarget(qulonglong,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setTarget(qulonglong,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTarget", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"name", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setTarget", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);
            }
        }
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTarget(qulonglong,QString)
            cppSelf->setTarget(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AddressableItemContextMenuFunc_setWholeFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: AddressableItemContextMenu::setWholeFunction(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWholeFunction(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWholeFunction", errInfo, SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWholeFunction(bool)
            cppSelf->setWholeFunction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_AddressableItemContextMenu_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_AddressableItemContextMenu_methods[] = {
    {"clearTarget", reinterpret_cast<PyCFunction>(Sbk_AddressableItemContextMenuFunc_clearTarget), METH_NOARGS, nullptr},
    {"setHasTarget", reinterpret_cast<PyCFunction>(Sbk_AddressableItemContextMenuFunc_setHasTarget), METH_O, nullptr},
    {"setOffset", reinterpret_cast<PyCFunction>(Sbk_AddressableItemContextMenuFunc_setOffset), METH_O, nullptr},
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_AddressableItemContextMenuFunc_setTarget), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setWholeFunction", reinterpret_cast<PyCFunction>(Sbk_AddressableItemContextMenuFunc_setWholeFunction), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_AddressableItemContextMenu_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<AddressableItemContextMenuWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_AddressableItemContextMenu_get_actionShowInMenu(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppSelf->actionShowInMenu);
}
static int Sbk_AddressableItemContextMenu_set_actionShowInMenu(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("actionShowInMenu");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("actionShowInMenu", "QAction");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->actionShowInMenu;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "actionShowInMenu", pyIn);
    return 0;
}

static PyObject *Sbk_AddressableItemContextMenu_get_actionCopyAddress(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppSelf->actionCopyAddress);
}
static int Sbk_AddressableItemContextMenu_set_actionCopyAddress(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("actionCopyAddress");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("actionCopyAddress", "QAction");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->actionCopyAddress;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "actionCopyAddress", pyIn);
    return 0;
}

static PyObject *Sbk_AddressableItemContextMenu_get_actionShowXrefs(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppSelf->actionShowXrefs);
}
static int Sbk_AddressableItemContextMenu_set_actionShowXrefs(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("actionShowXrefs");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("actionShowXrefs", "QAction");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->actionShowXrefs;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "actionShowXrefs", pyIn);
    return 0;
}

static PyObject *Sbk_AddressableItemContextMenu_get_actionAddcomment(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppSelf->actionAddcomment);
}
static int Sbk_AddressableItemContextMenu_set_actionAddcomment(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("actionAddcomment");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("actionAddcomment", "QAction");
        return -1;
    }

    auto *&cppOut_ptr = cppSelf->actionAddcomment;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "actionAddcomment", pyIn);
    return 0;
}

static PyObject *Sbk_AddressableItemContextMenu_get_name(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->name);
}
static int Sbk_AddressableItemContextMenu_set_name(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("name");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("name", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->name;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_AddressableItemContextMenu_get_wholeFunction(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->wholeFunction;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_AddressableItemContextMenu_set_wholeFunction(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::AddressableItemContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("wholeFunction");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("wholeFunction", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->wholeFunction;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->wholeFunction = cppOut_local;

    return 0;
}

// Getters and Setters for AddressableItemContextMenu
static PyGetSetDef Sbk_AddressableItemContextMenu_getsetlist[] = {
    {const_cast<char *>("actionShowInMenu"), Sbk_AddressableItemContextMenu_get_actionShowInMenu, Sbk_AddressableItemContextMenu_set_actionShowInMenu, nullptr, nullptr},
    {const_cast<char *>("actionCopyAddress"), Sbk_AddressableItemContextMenu_get_actionCopyAddress, Sbk_AddressableItemContextMenu_set_actionCopyAddress, nullptr, nullptr},
    {const_cast<char *>("actionShowXrefs"), Sbk_AddressableItemContextMenu_get_actionShowXrefs, Sbk_AddressableItemContextMenu_set_actionShowXrefs, nullptr, nullptr},
    {const_cast<char *>("actionAddcomment"), Sbk_AddressableItemContextMenu_get_actionAddcomment, Sbk_AddressableItemContextMenu_set_actionAddcomment, nullptr, nullptr},
    {const_cast<char *>("name"), Sbk_AddressableItemContextMenu_get_name, Sbk_AddressableItemContextMenu_set_name, nullptr, nullptr},
    {const_cast<char *>("wholeFunction"), Sbk_AddressableItemContextMenu_get_wholeFunction, Sbk_AddressableItemContextMenu_set_wholeFunction, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_AddressableItemContextMenu_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_AddressableItemContextMenu_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_AddressableItemContextMenuSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::AddressableItemContextMenu *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))
        return static_cast< ::QMenu *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_AddressableItemContextMenu_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_AddressableItemContextMenu_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_AddressableItemContextMenu_spec = {
    "1:CutterBindings.AddressableItemContextMenu",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_AddressableItemContextMenu_slots
};

} //extern "C"

static void *Sbk_AddressableItemContextMenu_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::AddressableItemContextMenu *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::AddressableItemContextMenu *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::AddressableItemContextMenu *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void AddressableItemContextMenu_PythonToCpp_AddressableItemContextMenu_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_AddressableItemContextMenu_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_AddressableItemContextMenu_PythonToCpp_AddressableItemContextMenu_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_AddressableItemContextMenu_TypeF()))
        return AddressableItemContextMenu_PythonToCpp_AddressableItemContextMenu_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *AddressableItemContextMenu_PTR_CppToPython_AddressableItemContextMenu(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::AddressableItemContextMenu *>(const_cast<void *>(cppIn)), Sbk_AddressableItemContextMenu_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *AddressableItemContextMenu_SignatureStrings[] = {
    "CutterBindings.AddressableItemContextMenu(self,parent:PySide6.QtWidgets.QWidget,mainWindow:CutterBindings.MainWindow)",
    "CutterBindings.AddressableItemContextMenu.clearTarget(self)",
    "CutterBindings.AddressableItemContextMenu.setHasTarget(self,hasTarget:bool)",
    "CutterBindings.AddressableItemContextMenu.setOffset(self,offset:unsigned long long)",
    "CutterBindings.AddressableItemContextMenu.setTarget(self,offset:unsigned long long,name:QString=QString())",
    "CutterBindings.AddressableItemContextMenu.setWholeFunction(self,wholeFunciton:bool)",
    nullptr}; // Sentinel
#else
static constexpr size_t AddressableItemContextMenu_SignatureByteSize = 198;
static constexpr uint8_t AddressableItemContextMenu_SignatureBytes[198] = {
    0x78, 0xda, 0x95, 0x90, 0x3d, 0x0b, 0xc2, 0x40, 0x0c, 0x86, 0x77, 0x7f, 0x85, 0xa3, 0x85, 0xd2,
    0xd1, 0xe1, 0xc0, 0x41, 0x0b, 0xa2, 0x43, 0xd1, 0x52, 0xa1, 0xf3, 0xd5, 0x4b, 0xeb, 0xc1, 0x35,
    0x91, 0x4b, 0x4a, 0xf5, 0xdf, 0x5b, 0xfa, 0x21, 0x3a, 0x08, 0x76, 0xc9, 0x27, 0x79, 0xde, 0x97,
    0xc4, 0x8d, 0x08, 0xf8, 0x9d, 0x45, 0x63, 0xb1, 0xe2, 0x68, 0x6b, 0x8c, 0x07, 0x66, 0x5d, 0x38,
    0x38, 0x0a, 0xd4, 0x31, 0xa1, 0xc0, 0x43, 0x12, 0xc0, 0x66, 0xc5, 0xe0, 0xca, 0xf0, 0xae, 0x3d,
    0xa0, 0xa8, 0xf3, 0x33, 0xb3, 0x06, 0xd6, 0x51, 0x2a, 0xb9, 0x35, 0x15, 0x08, 0x47, 0xe9, 0x50,
    0x84, 0xb5, 0xb6, 0x98, 0x77, 0x34, 0x6a, 0x55, 0xfc, 0x8d, 0x4e, 0xde, 0x9b, 0x60, 0x11, 0xff,
    0xab, 0x1a, 0x5d, 0x1d, 0x68, 0x7f, 0xd1, 0xbe, 0x63, 0xf7, 0x0e, 0xe6, 0xdc, 0x32, 0xc8, 0x41,
    0xf3, 0xc7, 0x71, 0x78, 0x9b, 0x5a, 0x55, 0x10, 0xb9, 0x99, 0xac, 0x53, 0x59, 0xf2, 0x04, 0xa2,
    0xbe, 0x56, 0x0d, 0xb2, 0xad, 0x10, 0xcc, 0xd2, 0x11, 0x56, 0x7d, 0x98, 0xc9, 0xfc, 0x34, 0xf7,
    0x93, 0x19, 0xa2, 0xae, 0x41, 0xa5, 0x99, 0xf8, 0x8e, 0xb8, 0x19, 0xf3, 0x2a, 0x98, 0x29, 0x95,
    0xdf, 0xc8, 0xc1, 0xbe, 0xc1, 0xab, 0x58, 0xc2, 0x41, 0xb1, 0x9d, 0x46, 0x56, 0x08, 0xc7, 0x97,
    0xbc, 0x00, 0xaa, 0xd5, 0xc9, 0x16
};
#endif

PyTypeObject *init_AddressableItemContextMenu(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX].type;

    Shiboken::AutoDecRef Sbk_AddressableItemContextMenu_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))));

    _Sbk_AddressableItemContextMenu_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "AddressableItemContextMenu",
        "AddressableItemContextMenu*",
        &Sbk_AddressableItemContextMenu_spec,
        &Shiboken::callCppDestructor< AddressableItemContextMenu >,
        Sbk_AddressableItemContextMenu_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_AddressableItemContextMenu_TypeF(); // references _Sbk_AddressableItemContextMenu_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, AddressableItemContextMenu_SignatureStrings);
#else
    InitSignatureBytes(pyType, AddressableItemContextMenu_SignatureBytes, AddressableItemContextMenu_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_AddressableItemContextMenu_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        AddressableItemContextMenu_PythonToCpp_AddressableItemContextMenu_PTR,
        is_AddressableItemContextMenu_PythonToCpp_AddressableItemContextMenu_PTR_Convertible,
        AddressableItemContextMenu_PTR_CppToPython_AddressableItemContextMenu);

    Shiboken::Conversions::registerConverterName(converter, "AddressableItemContextMenu");
    Shiboken::Conversions::registerConverterName(converter, "AddressableItemContextMenu*");
    Shiboken::Conversions::registerConverterName(converter, "AddressableItemContextMenu&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::AddressableItemContextMenu).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(AddressableItemContextMenuWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_AddressableItemContextMenu_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_AddressableItemContextMenu_TypeF(), &Sbk_AddressableItemContextMenuSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_AddressableItemContextMenu_TypeF(), &Sbk_AddressableItemContextMenu_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::AddressableItemContextMenu::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::AddressableItemContextMenu::staticMetaObject, sizeof(AddressableItemContextMenuWrapper));

    return pyType;
}
