/* RygelConfigFile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RygelConfigFile.vala, do not modify */

/*
 * Copyright (c) 2011-2015 elementary Developers (https://launchpad.net/elementary)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "io.elementary.settings.sharing.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SHARING_BACKEND_RYGEL_CONFIG_FILE_0_PROPERTY,
	SHARING_BACKEND_RYGEL_CONFIG_FILE_NUM_PROPERTIES
};
static GParamSpec* sharing_backend_rygel_config_file_properties[SHARING_BACKEND_RYGEL_CONFIG_FILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SharingBackendRygelConfigFilePrivate {
	gchar* config_filename;
	GKeyFile* config_file;
	gchar** media_uris;
	gint media_uris_length1;
	gint _media_uris_size_;
};

static gint SharingBackendRygelConfigFile_private_offset;
static gpointer sharing_backend_rygel_config_file_parent_class = NULL;

static void sharing_backend_rygel_config_file_setup_config_file (SharingBackendRygelConfigFile* self);
static GObject * sharing_backend_rygel_config_file_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void sharing_backend_rygel_config_file_finalize (GObject * obj);
static GType sharing_backend_rygel_config_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sharing_backend_rygel_config_file_get_instance_private (SharingBackendRygelConfigFile* self)
{
	return G_STRUCT_MEMBER_P (self, SharingBackendRygelConfigFile_private_offset);
}

gboolean
sharing_backend_rygel_config_file_get_media_type_enabled (SharingBackendRygelConfigFile* self,
                                                          const gchar* media_type_id)
{
	GKeyFile* _tmp0_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (media_type_id != NULL, FALSE);
	_tmp0_ = self->priv->config_file;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	{
		gboolean _tmp1_ = FALSE;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->config_file;
		_tmp3_ = g_strdup_printf ("share-%s", media_type_id);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_key_file_get_boolean (_tmp2_, "Tracker", _tmp4_, &_inner_error0_);
		_g_free0 (_tmp4_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp1_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("RygelConfigFile.vala:65: Reading configuration file failed: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

gchar*
sharing_backend_rygel_config_file_get_media_type_folder (SharingBackendRygelConfigFile* self,
                                                         const gchar* media_type_id)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_type_id != NULL, NULL);
	_tmp0_ = media_type_id;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("music")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_ = NULL;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar* _tmp7_;
				_tmp4_ = self->priv->media_uris;
				_tmp4__length1 = self->priv->media_uris_length1;
				if (_tmp4__length1 > 0) {
					gchar** _tmp5_;
					gint _tmp5__length1;
					const gchar* _tmp6_;
					_tmp5_ = self->priv->media_uris;
					_tmp5__length1 = self->priv->media_uris_length1;
					_tmp6_ = _tmp5_[0];
					_tmp3_ = _tmp6_;
				} else {
					_tmp3_ = "";
				}
				_tmp7_ = g_strdup (_tmp3_);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_ = NULL;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gchar* _tmp12_;
				_tmp9_ = self->priv->media_uris;
				_tmp9__length1 = self->priv->media_uris_length1;
				if (_tmp9__length1 > 1) {
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					_tmp10_ = self->priv->media_uris;
					_tmp10__length1 = self->priv->media_uris_length1;
					_tmp11_ = _tmp10_[1];
					_tmp8_ = _tmp11_;
				} else {
					_tmp8_ = "";
				}
				_tmp12_ = g_strdup (_tmp8_);
				result = _tmp12_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("pictures")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp13_ = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar* _tmp17_;
				_tmp14_ = self->priv->media_uris;
				_tmp14__length1 = self->priv->media_uris_length1;
				if (_tmp14__length1 > 2) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					_tmp15_ = self->priv->media_uris;
					_tmp15__length1 = self->priv->media_uris_length1;
					_tmp16_ = _tmp15_[2];
					_tmp13_ = _tmp16_;
				} else {
					_tmp13_ = "";
				}
				_tmp17_ = g_strdup (_tmp13_);
				result = _tmp17_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				_tmp18_ = g_strdup ("");
				result = _tmp18_;
				return result;
			}
		}
	}
}

void
sharing_backend_rygel_config_file_set_media_type_enabled (SharingBackendRygelConfigFile* self,
                                                          const gchar* media_type_id,
                                                          gboolean enable)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media_type_id != NULL);
	_tmp0_ = self->priv->config_file;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->config_file;
	_tmp2_ = g_strdup_printf ("share-%s", media_type_id);
	_tmp3_ = _tmp2_;
	g_key_file_set_boolean (_tmp1_, "Tracker", _tmp3_, enable);
	_g_free0 (_tmp3_);
}

void
sharing_backend_rygel_config_file_set_media_type_folder (SharingBackendRygelConfigFile* self,
                                                         const gchar* media_type_id,
                                                         const gchar* folder_path)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	GKeyFile* _tmp13_;
	GKeyFile* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media_type_id != NULL);
	g_return_if_fail (folder_path != NULL);
	if (g_strcmp0 (media_type_id, "music") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (folder_path);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = sharing_backend_rygel_config_file_get_media_type_folder (self, "music");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	if (g_strcmp0 (media_type_id, "videos") == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (folder_path);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = sharing_backend_rygel_config_file_get_media_type_folder (self, "videos");
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	if (g_strcmp0 (media_type_id, "pictures") == 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (folder_path);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp7_;
	} else {
		gchar* _tmp8_;
		_tmp8_ = sharing_backend_rygel_config_file_get_media_type_folder (self, "pictures");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp8_;
	}
	_tmp9_ = g_strdup (_tmp0_);
	_tmp10_ = g_strdup (_tmp3_);
	_tmp11_ = g_strdup (_tmp6_);
	_tmp12_ = g_new0 (gchar*, 3 + 1);
	_tmp12_[0] = _tmp9_;
	_tmp12_[1] = _tmp10_;
	_tmp12_[2] = _tmp11_;
	self->priv->media_uris = (_vala_array_free (self->priv->media_uris, self->priv->media_uris_length1, (GDestroyNotify) g_free), NULL);
	self->priv->media_uris = _tmp12_;
	self->priv->media_uris_length1 = 3;
	self->priv->_media_uris_size_ = self->priv->media_uris_length1;
	_tmp13_ = self->priv->config_file;
	if (_tmp13_ == NULL) {
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp14_ = self->priv->config_file;
	_tmp15_ = self->priv->media_uris;
	_tmp15__length1 = self->priv->media_uris_length1;
	g_key_file_set_string_list (_tmp14_, "MediaExport", "uris", (const gchar* const*) _tmp15_, (gint) _tmp15__length1);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp0_);
}

gboolean
sharing_backend_rygel_config_file_save (SharingBackendRygelConfigFile* self)
{
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->config_file;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->config_filename;
		g_warning ("RygelConfigFile.vala:115: The loaded configuration file %s wasn't vali" \
"d. Saving isn't allowed to prevent overwriting a broken rygel.conf.", _tmp1_);
		result = FALSE;
		return result;
	}
	{
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->config_file;
		_tmp3_ = self->priv->config_filename;
		g_key_file_save_to_file (_tmp2_, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = self->priv->config_filename;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("RygelConfigFile.vala:123: Saving configuration file %s failed: %s", _tmp4_, _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

static void
sharing_backend_rygel_config_file_setup_config_file (SharingBackendRygelConfigFile* self)
{
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	GKeyFile* _tmp6_;
	GKeyFile* _tmp7_;
	GKeyFile* _tmp8_;
	GKeyFile* _tmp9_;
	GKeyFile* _tmp10_;
	GKeyFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GKeyFile* _tmp20_;
	GKeyFile* _tmp21_;
	GKeyFile* _tmp22_;
	GKeyFile* _tmp23_;
	GKeyFile* _tmp24_;
	GKeyFile* _tmp25_;
	GKeyFile* _tmp26_;
	GKeyFile* _tmp27_;
	GKeyFile* _tmp28_;
	GKeyFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	GKeyFile* _tmp35_;
	GKeyFile* _tmp36_;
	GKeyFile* _tmp37_;
	GKeyFile* _tmp38_;
	GKeyFile* _tmp39_;
	GKeyFile* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp0_, "general", "upnp-enabled", TRUE);
	_tmp1_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp1_, "general", "enable-transcoding", TRUE);
	_tmp2_ = self->priv->config_file;
	g_key_file_set_string (_tmp2_, "general", "video-upload-folder", "@VIDEOS@");
	_tmp3_ = self->priv->config_file;
	g_key_file_set_string (_tmp3_, "general", "music-upload-folder", "@MUSIC@");
	_tmp4_ = self->priv->config_file;
	g_key_file_set_string (_tmp4_, "general", "picture-upload-folder", "@PICTURES@");
	_tmp5_ = self->priv->config_file;
	g_key_file_set_string (_tmp5_, "general", "media-engine", "librygel-media-engine-gst.so");
	_tmp6_ = self->priv->config_file;
	g_key_file_set_string (_tmp6_, "general", "interface", "");
	_tmp7_ = self->priv->config_file;
	g_key_file_set_integer (_tmp7_, "general", "port", 0);
	_tmp8_ = self->priv->config_file;
	g_key_file_set_string (_tmp8_, "general", "log-level", "*:4");
	_tmp9_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp9_, "general", "allow-upload", TRUE);
	_tmp10_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp10_, "general", "allow-deletion", TRUE);
	_tmp11_ = self->priv->config_file;
	_tmp12_ = g_strdup ("mp3");
	_tmp13_ = g_strdup ("lpcm");
	_tmp14_ = g_strdup ("mp2ts");
	_tmp15_ = g_strdup ("wmv");
	_tmp16_ = g_strdup ("aac");
	_tmp17_ = g_strdup ("avc");
	_tmp18_ = g_new0 (gchar*, 6 + 1);
	_tmp18_[0] = _tmp12_;
	_tmp18_[1] = _tmp13_;
	_tmp18_[2] = _tmp14_;
	_tmp18_[3] = _tmp15_;
	_tmp18_[4] = _tmp16_;
	_tmp18_[5] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 6;
	g_key_file_set_string_list (_tmp11_, "GstMediaEngine", "transcoders", (const gchar* const*) _tmp19_, (gint) 6);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = self->priv->config_file;
	g_key_file_set_integer (_tmp20_, "Renderer", "image-timeout", 15);
	_tmp21_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp21_, "Tracker", "enabled", TRUE);
	_tmp22_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp22_, "Tracker", "share-pictures", TRUE);
	_tmp23_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp23_, "Tracker", "share-videos", TRUE);
	_tmp24_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp24_, "Tracker", "share-music", TRUE);
	_tmp25_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp25_, "Tracker", "strict-sharing", FALSE);
	_tmp26_ = self->priv->config_file;
	g_key_file_set_string (_tmp26_, "Tracker", "title", "@HOSTNAME@: @REALNAME@");
	_tmp27_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp27_, "MediaExport", "enabled", TRUE);
	_tmp28_ = self->priv->config_file;
	g_key_file_set_string (_tmp28_, "MediaExport", "title", "@HOSTNAME@: @REALNAME@");
	_tmp29_ = self->priv->config_file;
	_tmp30_ = g_strdup ("@MUSIC@");
	_tmp31_ = g_strdup ("@VIDEOS@");
	_tmp32_ = g_strdup ("@PICTURES@");
	_tmp33_ = g_new0 (gchar*, 3 + 1);
	_tmp33_[0] = _tmp30_;
	_tmp33_[1] = _tmp31_;
	_tmp33_[2] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 3;
	g_key_file_set_string_list (_tmp29_, "MediaExport", "uris", (const gchar* const*) _tmp34_, (gint) 3);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp35_, "MediaExport", "extract-metadata", TRUE);
	_tmp36_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp36_, "MediaExport", "monitor-changes", TRUE);
	_tmp37_ = self->priv->config_file;
	g_key_file_set_integer (_tmp37_, "MediaExport", "monitor-grace-timeout", 5);
	_tmp38_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp38_, "MediaExport", "virtual-folders", TRUE);
	_tmp39_ = self->priv->config_file;
	g_key_file_set_boolean (_tmp39_, "Playbin", "enabled", TRUE);
	_tmp40_ = self->priv->config_file;
	g_key_file_set_string (_tmp40_, "Playbin", "title", "Audio/Video playback on @HOSTNAME@");
}

SharingBackendRygelConfigFile*
sharing_backend_rygel_config_file_construct (GType object_type)
{
	SharingBackendRygelConfigFile * self = NULL;
	self = (SharingBackendRygelConfigFile*) g_object_new (object_type, NULL);
	return self;
}

SharingBackendRygelConfigFile*
sharing_backend_rygel_config_file_new (void)
{
	return sharing_backend_rygel_config_file_construct (SHARING_BACKEND_TYPE_RYGEL_CONFIG_FILE);
}

static GObject *
sharing_backend_rygel_config_file_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SharingBackendRygelConfigFile * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GKeyFile* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (sharing_backend_rygel_config_file_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_BACKEND_TYPE_RYGEL_CONFIG_FILE, SharingBackendRygelConfigFile);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "rygel.conf", NULL);
	_g_free0 (self->priv->config_filename);
	self->priv->config_filename = _tmp1_;
	_tmp2_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->config_file);
	self->priv->config_file = _tmp2_;
	_tmp3_ = self->priv->config_filename;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		{
			GKeyFile* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->config_file;
			_tmp8_ = self->priv->config_filename;
			g_key_file_load_from_file (_tmp7_, _tmp8_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = self->priv->config_filename;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("RygelConfigFile.vala:34: Loading configuration file %s failed: %s", _tmp9_, _tmp11_);
			_g_key_file_unref0 (self->priv->config_file);
			self->priv->config_file = NULL;
			_g_error_free0 (e);
			return obj;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	} else {
		g_debug ("RygelConfigFile.vala:41: Setting up new rygel.conf…");
		sharing_backend_rygel_config_file_setup_config_file (self);
	}
	{
		gchar** _tmp12_ = NULL;
		GKeyFile* _tmp13_;
		gsize _tmp14_ = 0;
		gchar** _tmp15_;
		gint _tmp12__length1;
		gint __tmp12__size_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp13_ = self->priv->config_file;
		_tmp15_ = g_key_file_get_string_list (_tmp13_, "MediaExport", "uris", &_tmp14_, &_inner_error0_);
		_tmp12_ = _tmp15_;
		_tmp12__length1 = _tmp14_;
		__tmp12__size_ = _tmp12__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp12_;
		_tmp16__length1 = _tmp12__length1;
		_tmp12_ = NULL;
		_tmp12__length1 = 0;
		self->priv->media_uris = (_vala_array_free (self->priv->media_uris, self->priv->media_uris_length1, (GDestroyNotify) g_free), NULL);
		self->priv->media_uris = _tmp16_;
		self->priv->media_uris_length1 = _tmp16__length1;
		self->priv->_media_uris_size_ = self->priv->media_uris_length1;
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = self->priv->config_filename;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("RygelConfigFile.vala:49: Reading configuration file %s failed: %s", _tmp17_, _tmp19_);
		_g_key_file_unref0 (self->priv->config_file);
		self->priv->config_file = NULL;
		_g_error_free0 (e);
		return obj;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
sharing_backend_rygel_config_file_class_init (SharingBackendRygelConfigFileClass * klass,
                                              gpointer klass_data)
{
	sharing_backend_rygel_config_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SharingBackendRygelConfigFile_private_offset);
	G_OBJECT_CLASS (klass)->constructor = sharing_backend_rygel_config_file_constructor;
	G_OBJECT_CLASS (klass)->finalize = sharing_backend_rygel_config_file_finalize;
}

static void
sharing_backend_rygel_config_file_instance_init (SharingBackendRygelConfigFile * self,
                                                 gpointer klass)
{
	self->priv = sharing_backend_rygel_config_file_get_instance_private (self);
	self->priv->config_file = NULL;
}

static void
sharing_backend_rygel_config_file_finalize (GObject * obj)
{
	SharingBackendRygelConfigFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SHARING_BACKEND_TYPE_RYGEL_CONFIG_FILE, SharingBackendRygelConfigFile);
	_g_free0 (self->priv->config_filename);
	_g_key_file_unref0 (self->priv->config_file);
	self->priv->media_uris = (_vala_array_free (self->priv->media_uris, self->priv->media_uris_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (sharing_backend_rygel_config_file_parent_class)->finalize (obj);
}

static GType
sharing_backend_rygel_config_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SharingBackendRygelConfigFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sharing_backend_rygel_config_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SharingBackendRygelConfigFile), 0, (GInstanceInitFunc) sharing_backend_rygel_config_file_instance_init, NULL };
	GType sharing_backend_rygel_config_file_type_id;
	sharing_backend_rygel_config_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SharingBackendRygelConfigFile", &g_define_type_info, 0);
	SharingBackendRygelConfigFile_private_offset = g_type_add_instance_private (sharing_backend_rygel_config_file_type_id, sizeof (SharingBackendRygelConfigFilePrivate));
	return sharing_backend_rygel_config_file_type_id;
}

GType
sharing_backend_rygel_config_file_get_type (void)
{
	static volatile gsize sharing_backend_rygel_config_file_type_id__once = 0;
	if (g_once_init_enter (&sharing_backend_rygel_config_file_type_id__once)) {
		GType sharing_backend_rygel_config_file_type_id;
		sharing_backend_rygel_config_file_type_id = sharing_backend_rygel_config_file_get_type_once ();
		g_once_init_leave (&sharing_backend_rygel_config_file_type_id__once, sharing_backend_rygel_config_file_type_id);
	}
	return sharing_backend_rygel_config_file_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

