/* desktop-file-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from desktop-file-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <synapse-core.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH (synapse_desktop_file_plugin_desktop_file_match_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatchClass))

typedef struct _SynapseDesktopFilePluginDesktopFileMatch SynapseDesktopFilePluginDesktopFileMatch;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchClass SynapseDesktopFilePluginDesktopFileMatchClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION (synapse_desktop_file_plugin_open_with_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_WITH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithActionClass))

typedef struct _SynapseDesktopFilePluginOpenWithAction SynapseDesktopFilePluginOpenWithAction;
typedef struct _SynapseDesktopFilePluginOpenWithActionClass SynapseDesktopFilePluginOpenWithActionClass;

#define SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION (synapse_desktop_file_plugin_open_app_action_get_type ())
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppActionClass))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_APP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_IS_OPEN_APP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION))
#define SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppActionClass))

typedef struct _SynapseDesktopFilePluginOpenAppAction SynapseDesktopFilePluginOpenAppAction;
typedef struct _SynapseDesktopFilePluginOpenAppActionClass SynapseDesktopFilePluginOpenAppActionClass;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseDesktopFilePluginLoadAllDesktopFilesData SynapseDesktopFilePluginLoadAllDesktopFilesData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _SynapseDesktopFilePluginSearchData SynapseDesktopFilePluginSearchData;
typedef struct _SynapseDesktopFilePluginDesktopFileMatchPrivate SynapseDesktopFilePluginDesktopFileMatchPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_NUM_PROPERTIES];
typedef struct _SynapseDesktopFilePluginOpenWithActionPrivate SynapseDesktopFilePluginOpenWithActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseDesktopFilePluginOpenAppActionPrivate SynapseDesktopFilePluginOpenAppActionPrivate;
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY,
	SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_NUM_PROPERTIES];
enum  {
	SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS
};
static guint synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_NUM_SIGNALS] = {0};

struct _SynapseDesktopFilePluginPrivate {
	gboolean _enabled;
	GeeList* desktop_files;
	gboolean loading_in_progress;
	GeeMap* mimetype_map;
	GeeMap* actions_map;
};

struct _SynapseDesktopFilePluginLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseDesktopFileService* dfs;
	SynapseDesktopFileService* _tmp0_;
	GeeList* _dfi_list;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	gint _dfi_size;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _dfi_index;
	gint _tmp6_;
	gint _tmp7_;
	SynapseDesktopFileInfo* dfi;
	GeeList* _tmp8_;
	gpointer _tmp9_;
	GeeList* _tmp10_;
	SynapseDesktopFileInfo* _tmp11_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp12_;
	SynapseDesktopFilePluginDesktopFileMatch* _tmp13_;
};

struct _Block1Data {
	int _ref_count_;
	SynapseDesktopFilePlugin* self;
	gpointer _async_data_;
};

struct _SynapseDesktopFilePluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFilePlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	Block1Data* _data1_;
	gulong signal_id;
	gulong _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	SynapseMatcherFlags flags;
	SynapseQuery _tmp4_;
	SynapseResultSet* _tmp5_;
	SynapseQuery _tmp6_;
	SynapseResultSet* _tmp7_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFilePluginDesktopFileMatch {
	SynapseApplicationMatch parent_instance;
	SynapseDesktopFilePluginDesktopFileMatchPrivate * priv;
};

struct _SynapseDesktopFilePluginDesktopFileMatchClass {
	SynapseApplicationMatchClass parent_class;
};

struct _SynapseDesktopFilePluginDesktopFileMatchPrivate {
	SynapseDesktopFileInfo* _desktop_info;
	gchar* _title_folded;
	gchar* _title_unaccented;
	gchar* _desktop_id;
	gchar* _exec;
};

struct _SynapseDesktopFilePluginOpenWithAction {
	SynapseAction parent_instance;
	SynapseDesktopFilePluginOpenWithActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenWithActionClass {
	SynapseActionClass parent_class;
};

struct _SynapseDesktopFilePluginOpenWithActionPrivate {
	SynapseDesktopFileInfo* _desktop_info;
};

struct _SynapseDesktopFilePluginOpenAppAction {
	SynapseAction parent_instance;
	SynapseDesktopFilePluginOpenAppActionPrivate * priv;
};

struct _SynapseDesktopFilePluginOpenAppActionClass {
	SynapseActionClass parent_class;
};

struct _SynapseDesktopFilePluginOpenAppActionPrivate {
	SynapseDesktopFileInfo* _desktop_info;
	gchar* _action;
	GDesktopAppInfo* app_info;
};

static gint SynapseDesktopFilePlugin_private_offset;
static gpointer synapse_desktop_file_plugin_parent_class = NULL;
static gint SynapseDesktopFilePluginDesktopFileMatch_private_offset;
static gpointer synapse_desktop_file_plugin_desktop_file_match_parent_class = NULL;
static gint SynapseDesktopFilePluginOpenWithAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_with_action_parent_class = NULL;
static gint SynapseDesktopFilePluginOpenAppAction_private_offset;
static gpointer synapse_desktop_file_plugin_open_app_action_parent_class = NULL;
static SynapseActivatableIface * synapse_desktop_file_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_desktop_file_plugin_synapse_item_provider_parent_iface = NULL;
static SynapseActionProviderIface * synapse_desktop_file_plugin_synapse_action_provider_parent_iface = NULL;

static GType synapse_desktop_file_plugin_desktop_file_match_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType synapse_desktop_file_plugin_open_with_action_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType synapse_desktop_file_plugin_open_app_action_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_desktop_file_plugin_real_activate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_desktop_file_plugin_register_plugin (void);
static void _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void);
static void synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data);
static void synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                                GAsyncResult* _res_);
static gboolean synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_);
static gboolean _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginDesktopFileMatch* synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type,
                                                                                                    SynapseDesktopFileInfo* info);
static gint synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                                    SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                                    gint base_relevancy);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                              SynapseQuery* q,
                                              SynapseResultSet* results,
                                              SynapseMatcherFlags flags);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self);
static const gchar* synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self);
static gboolean synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                         SynapseQuery* q);
static void synapse_desktop_file_plugin_real_search_data_free (gpointer _data);
static void synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                              SynapseQuery* q,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_);
static void ____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                             gpointer self);
static gboolean _synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self);
static SynapseResultSet* synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                                   SynapseQuery* query,
                                                                   SynapseMatch* match);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenWithAction* synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                                                                SynapseDesktopFileInfo* info);
static SynapseDesktopFilePluginOpenAppAction* synapse_desktop_file_plugin_open_app_action_new (SynapseDesktopFileInfo* info,
                                                                                        const gchar* action);
static SynapseDesktopFilePluginOpenAppAction* synapse_desktop_file_plugin_open_app_action_construct (GType object_type,
                                                                                              SynapseDesktopFileInfo* info,
                                                                                              const gchar* action);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                      const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                          const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                    const gchar* value);
static void synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                              const gchar* value);
static GObject * synapse_desktop_file_plugin_desktop_file_match_constructor (GType type,
                                                                      guint n_construct_properties,
                                                                      GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_desktop_file_match_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_with_action_real_do_execute (SynapseAction* base,
                                                                   SynapseMatch* match,
                                                                   SynapseMatch* target);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean synapse_desktop_file_plugin_open_with_action_real_valid_for_match (SynapseAction* base,
                                                                            SynapseMatch* match);
static void synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                                    SynapseDesktopFileInfo* value);
static GObject * synapse_desktop_file_plugin_open_with_action_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_open_with_action_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                      guint property_id,
                                                                      GValue * value,
                                                                      GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                      guint property_id,
                                                                      const GValue * value,
                                                                      GParamSpec * pspec);
static void synapse_desktop_file_plugin_open_app_action_real_do_execute (SynapseAction* base,
                                                                  SynapseMatch* match,
                                                                  SynapseMatch* target);
static const gchar* synapse_desktop_file_plugin_open_app_action_get_action (SynapseDesktopFilePluginOpenAppAction* self);
static gboolean synapse_desktop_file_plugin_open_app_action_real_valid_for_match (SynapseAction* base,
                                                                           SynapseMatch* match);
static SynapseDesktopFileInfo* synapse_desktop_file_plugin_open_app_action_get_desktop_info (SynapseDesktopFilePluginOpenAppAction* self);
static void synapse_desktop_file_plugin_open_app_action_set_desktop_info (SynapseDesktopFilePluginOpenAppAction* self,
                                                                   SynapseDesktopFileInfo* value);
static void synapse_desktop_file_plugin_open_app_action_set_action (SynapseDesktopFilePluginOpenAppAction* self,
                                                             const gchar* value);
static GObject * synapse_desktop_file_plugin_open_app_action_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties);
static void synapse_desktop_file_plugin_open_app_action_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_open_app_action_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_open_app_action_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_open_app_action_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec);
static GObject * synapse_desktop_file_plugin_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                           gpointer self);
static void _synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self);
static void __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                        gpointer self);
static void synapse_desktop_file_plugin_finalize (GObject * obj);
static GType synapse_desktop_file_plugin_get_type_once (void);
static void _vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
synapse_desktop_file_plugin_get_instance_private (SynapseDesktopFilePlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePlugin_private_offset);
}

static void
synapse_desktop_file_plugin_real_activate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 28 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 400 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseDesktopFilePlugin * self;
#line 33 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 409 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 67 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 417 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
#line 67 "desktop-file-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 67 "desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 67 "desktop-file-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, "Application Search", _ ("Search for and run applications on your computer."), "system-run", _synapse_desktop_file_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
#line 67 "desktop-file-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 433 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 24 "desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginLoadAllDesktopFilesData, _data_);
#line 445 "desktop-file-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "desktop-file-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 453 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files (SynapseDesktopFilePlugin* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
#line 24 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 24 "desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginLoadAllDesktopFilesData);
#line 24 "desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_load_all_desktop_files_data_free);
#line 24 "desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files_co (_data_);
#line 477 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_load_all_desktop_files_finish (SynapseDesktopFilePlugin* self,
                                                           GAsyncResult* _res_)
{
	SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_;
#line 24 "desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 487 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_load_all_desktop_files_co (self);
#line 108 "desktop-file-plugin.vala"
	return result;
#line 497 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_load_all_desktop_files_co (SynapseDesktopFilePluginLoadAllDesktopFilesData* _data_)
{
#line 105 "desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 105 "desktop-file-plugin.vala"
		case 0:
#line 507 "desktop-file-plugin.c"
		goto _state_0;
#line 105 "desktop-file-plugin.vala"
		case 1:
#line 511 "desktop-file-plugin.c"
		goto _state_1;
		default:
#line 105 "desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 516 "desktop-file-plugin.c"
	}
	_state_0:
#line 107 "desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = TRUE;
#line 108 "desktop-file-plugin.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_plugin_load_all_desktop_files_co_gsource_func, _data_, NULL);
#line 109 "desktop-file-plugin.vala"
	_data_->_state_ = 1;
#line 109 "desktop-file-plugin.vala"
	return FALSE;
#line 527 "desktop-file-plugin.c"
	_state_1:
	;
#line 111 "desktop-file-plugin.vala"
	_data_->_tmp0_ = synapse_desktop_file_service_get_default ();
#line 111 "desktop-file-plugin.vala"
	_data_->dfs = _data_->_tmp0_;
#line 534 "desktop-file-plugin.c"
	{
#line 113 "desktop-file-plugin.vala"
		_data_->_tmp1_ = _data_->dfs;
#line 113 "desktop-file-plugin.vala"
		_data_->_tmp2_ = synapse_desktop_file_service_get_desktop_files (_data_->_tmp1_);
#line 113 "desktop-file-plugin.vala"
		_data_->_dfi_list = _data_->_tmp2_;
#line 113 "desktop-file-plugin.vala"
		_data_->_tmp3_ = _data_->_dfi_list;
#line 113 "desktop-file-plugin.vala"
		_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 113 "desktop-file-plugin.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 113 "desktop-file-plugin.vala"
		_data_->_dfi_size = _data_->_tmp5_;
#line 113 "desktop-file-plugin.vala"
		_data_->_dfi_index = -1;
#line 113 "desktop-file-plugin.vala"
		while (TRUE) {
#line 113 "desktop-file-plugin.vala"
			_data_->_dfi_index = _data_->_dfi_index + 1;
#line 113 "desktop-file-plugin.vala"
			_data_->_tmp6_ = _data_->_dfi_index;
#line 113 "desktop-file-plugin.vala"
			_data_->_tmp7_ = _data_->_dfi_size;
#line 113 "desktop-file-plugin.vala"
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
#line 113 "desktop-file-plugin.vala"
				break;
#line 564 "desktop-file-plugin.c"
			}
#line 113 "desktop-file-plugin.vala"
			_data_->_tmp8_ = _data_->_dfi_list;
#line 113 "desktop-file-plugin.vala"
			_data_->_tmp9_ = gee_list_get (_data_->_tmp8_, _data_->_dfi_index);
#line 113 "desktop-file-plugin.vala"
			_data_->dfi = (SynapseDesktopFileInfo*) _data_->_tmp9_;
#line 115 "desktop-file-plugin.vala"
			_data_->_tmp10_ = _data_->self->priv->desktop_files;
#line 115 "desktop-file-plugin.vala"
			_data_->_tmp11_ = _data_->dfi;
#line 115 "desktop-file-plugin.vala"
			_data_->_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_new (_data_->_tmp11_);
#line 115 "desktop-file-plugin.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 115 "desktop-file-plugin.vala"
			gee_collection_add ((GeeCollection*) _data_->_tmp10_, _data_->_tmp13_);
#line 115 "desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_tmp13_);
#line 113 "desktop-file-plugin.vala"
			_g_object_unref0 (_data_->dfi);
#line 586 "desktop-file-plugin.c"
		}
#line 113 "desktop-file-plugin.vala"
		_g_object_unref0 (_data_->_dfi_list);
#line 590 "desktop-file-plugin.c"
	}
#line 118 "desktop-file-plugin.vala"
	_data_->self->priv->loading_in_progress = FALSE;
#line 119 "desktop-file-plugin.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL], 0);
#line 105 "desktop-file-plugin.vala"
	_g_object_unref0 (_data_->dfs);
#line 105 "desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 105 "desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 105 "desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 105 "desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 606 "desktop-file-plugin.c"
		}
	}
#line 105 "desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 105 "desktop-file-plugin.vala"
	return FALSE;
#line 613 "desktop-file-plugin.c"
}

static gint
synapse_desktop_file_plugin_compute_relevancy (SynapseDesktopFilePlugin* self,
                                               SynapseDesktopFilePluginDesktopFileMatch* dfm,
                                               gint base_relevancy)
{
	SynapseRelevancyService* rs = NULL;
	SynapseRelevancyService* _tmp0_;
	gfloat popularity = 0.0F;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint r = 0;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
#line 122 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 122 "desktop-file-plugin.vala"
	g_return_val_if_fail (dfm != NULL, 0);
#line 124 "desktop-file-plugin.vala"
	_tmp0_ = synapse_relevancy_service_get_default ();
#line 124 "desktop-file-plugin.vala"
	rs = _tmp0_;
#line 125 "desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 125 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 125 "desktop-file-plugin.vala"
	popularity = synapse_relevancy_service_get_application_popularity (rs, _tmp2_);
#line 127 "desktop-file-plugin.vala"
	r = synapse_relevancy_service_compute_relevancy (base_relevancy, popularity);
#line 128 "desktop-file-plugin.vala"
	_tmp3_ = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (dfm);
#line 128 "desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 128 "desktop-file-plugin.vala"
	g_debug ("desktop-file-plugin.vala:128: relevancy for %s: %d", _tmp4_, r);
#line 130 "desktop-file-plugin.vala"
	result = r;
#line 130 "desktop-file-plugin.vala"
	_g_object_unref0 (rs);
#line 130 "desktop-file-plugin.vala"
	return result;
#line 658 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_full_search (SynapseDesktopFilePlugin* self,
                                         SynapseQuery* q,
                                         SynapseResultSet* results,
                                         SynapseMatcherFlags flags)
{
	GeeList* matchers = NULL;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	GeeList* _tmp2_;
#line 133 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 133 "desktop-file-plugin.vala"
	g_return_if_fail (q != NULL);
#line 133 "desktop-file-plugin.vala"
	g_return_if_fail (results != NULL);
#line 137 "desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 137 "desktop-file-plugin.vala"
	_tmp1_ = _tmp0_.query_string_folded;
#line 137 "desktop-file-plugin.vala"
	_tmp2_ = synapse_query_get_matchers_for_query (_tmp1_, flags, G_REGEX_OPTIMIZE);
#line 137 "desktop-file-plugin.vala"
	matchers = _tmp2_;
#line 685 "desktop-file-plugin.c"
	{
		GeeList* _dfm_list = NULL;
		GeeList* _tmp3_;
		gint _dfm_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _dfm_index = 0;
#line 140 "desktop-file-plugin.vala"
		_tmp3_ = self->priv->desktop_files;
#line 140 "desktop-file-plugin.vala"
		_dfm_list = _tmp3_;
#line 140 "desktop-file-plugin.vala"
		_tmp4_ = _dfm_list;
#line 140 "desktop-file-plugin.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 140 "desktop-file-plugin.vala"
		_tmp6_ = _tmp5_;
#line 140 "desktop-file-plugin.vala"
		_dfm_size = _tmp6_;
#line 140 "desktop-file-plugin.vala"
		_dfm_index = -1;
#line 140 "desktop-file-plugin.vala"
		while (TRUE) {
#line 710 "desktop-file-plugin.c"
			gint _tmp7_;
			gint _tmp8_;
			SynapseDesktopFilePluginDesktopFileMatch* dfm = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			const gchar* folded_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* unaccented_title = NULL;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gboolean matched = FALSE;
			gboolean _tmp45_ = FALSE;
#line 140 "desktop-file-plugin.vala"
			_dfm_index = _dfm_index + 1;
#line 140 "desktop-file-plugin.vala"
			_tmp7_ = _dfm_index;
#line 140 "desktop-file-plugin.vala"
			_tmp8_ = _dfm_size;
#line 140 "desktop-file-plugin.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 140 "desktop-file-plugin.vala"
				break;
#line 736 "desktop-file-plugin.c"
			}
#line 140 "desktop-file-plugin.vala"
			_tmp9_ = _dfm_list;
#line 140 "desktop-file-plugin.vala"
			_tmp10_ = gee_list_get (_tmp9_, _dfm_index);
#line 140 "desktop-file-plugin.vala"
			dfm = (SynapseDesktopFilePluginDesktopFileMatch*) _tmp10_;
#line 142 "desktop-file-plugin.vala"
			_tmp11_ = dfm;
#line 142 "desktop-file-plugin.vala"
			_tmp12_ = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (_tmp11_);
#line 142 "desktop-file-plugin.vala"
			_tmp13_ = _tmp12_;
#line 142 "desktop-file-plugin.vala"
			folded_title = _tmp13_;
#line 143 "desktop-file-plugin.vala"
			_tmp14_ = dfm;
#line 143 "desktop-file-plugin.vala"
			_tmp15_ = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (_tmp14_);
#line 143 "desktop-file-plugin.vala"
			_tmp16_ = _tmp15_;
#line 143 "desktop-file-plugin.vala"
			unaccented_title = _tmp16_;
#line 144 "desktop-file-plugin.vala"
			matched = FALSE;
#line 762 "desktop-file-plugin.c"
			{
				GeeList* _matcher_list = NULL;
				GeeList* _tmp17_;
				gint _matcher_size = 0;
				GeeList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _matcher_index = 0;
#line 148 "desktop-file-plugin.vala"
				_tmp17_ = matchers;
#line 148 "desktop-file-plugin.vala"
				_matcher_list = _tmp17_;
#line 148 "desktop-file-plugin.vala"
				_tmp18_ = _matcher_list;
#line 148 "desktop-file-plugin.vala"
				_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
#line 148 "desktop-file-plugin.vala"
				_tmp20_ = _tmp19_;
#line 148 "desktop-file-plugin.vala"
				_matcher_size = _tmp20_;
#line 148 "desktop-file-plugin.vala"
				_matcher_index = -1;
#line 148 "desktop-file-plugin.vala"
				while (TRUE) {
#line 787 "desktop-file-plugin.c"
					gint _tmp21_;
					gint _tmp22_;
					GeeMapEntry* matcher = NULL;
					GeeList* _tmp23_;
					gpointer _tmp24_;
					GeeMapEntry* _tmp25_;
					gconstpointer _tmp26_;
					gconstpointer _tmp27_;
					const gchar* _tmp28_;
#line 148 "desktop-file-plugin.vala"
					_matcher_index = _matcher_index + 1;
#line 148 "desktop-file-plugin.vala"
					_tmp21_ = _matcher_index;
#line 148 "desktop-file-plugin.vala"
					_tmp22_ = _matcher_size;
#line 148 "desktop-file-plugin.vala"
					if (!(_tmp21_ < _tmp22_)) {
#line 148 "desktop-file-plugin.vala"
						break;
#line 807 "desktop-file-plugin.c"
					}
#line 148 "desktop-file-plugin.vala"
					_tmp23_ = _matcher_list;
#line 148 "desktop-file-plugin.vala"
					_tmp24_ = gee_list_get (_tmp23_, _matcher_index);
#line 148 "desktop-file-plugin.vala"
					matcher = (GeeMapEntry*) _tmp24_;
#line 150 "desktop-file-plugin.vala"
					_tmp25_ = matcher;
#line 150 "desktop-file-plugin.vala"
					_tmp26_ = gee_map_entry_get_key (_tmp25_);
#line 150 "desktop-file-plugin.vala"
					_tmp27_ = _tmp26_;
#line 150 "desktop-file-plugin.vala"
					_tmp28_ = folded_title;
#line 150 "desktop-file-plugin.vala"
					if (g_regex_match ((GRegex*) _tmp27_, _tmp28_, 0, NULL)) {
#line 825 "desktop-file-plugin.c"
						SynapseDesktopFilePluginDesktopFileMatch* _tmp29_;
						SynapseDesktopFilePluginDesktopFileMatch* _tmp30_;
						GeeMapEntry* _tmp31_;
						gconstpointer _tmp32_;
						gconstpointer _tmp33_;
#line 152 "desktop-file-plugin.vala"
						_tmp29_ = dfm;
#line 152 "desktop-file-plugin.vala"
						_tmp30_ = dfm;
#line 152 "desktop-file-plugin.vala"
						_tmp31_ = matcher;
#line 152 "desktop-file-plugin.vala"
						_tmp32_ = gee_map_entry_get_value (_tmp31_);
#line 152 "desktop-file-plugin.vala"
						_tmp33_ = _tmp32_;
#line 152 "desktop-file-plugin.vala"
						synapse_result_set_add (results, (SynapseMatch*) _tmp29_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp30_, (gint) ((gintptr) _tmp33_)));
#line 153 "desktop-file-plugin.vala"
						matched = TRUE;
#line 154 "desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 154 "desktop-file-plugin.vala"
						break;
#line 849 "desktop-file-plugin.c"
					} else {
						gboolean _tmp34_ = FALSE;
						const gchar* _tmp35_;
#line 156 "desktop-file-plugin.vala"
						_tmp35_ = unaccented_title;
#line 156 "desktop-file-plugin.vala"
						if (_tmp35_ != NULL) {
#line 857 "desktop-file-plugin.c"
							GeeMapEntry* _tmp36_;
							gconstpointer _tmp37_;
							gconstpointer _tmp38_;
							const gchar* _tmp39_;
#line 156 "desktop-file-plugin.vala"
							_tmp36_ = matcher;
#line 156 "desktop-file-plugin.vala"
							_tmp37_ = gee_map_entry_get_key (_tmp36_);
#line 156 "desktop-file-plugin.vala"
							_tmp38_ = _tmp37_;
#line 156 "desktop-file-plugin.vala"
							_tmp39_ = unaccented_title;
#line 156 "desktop-file-plugin.vala"
							_tmp34_ = g_regex_match ((GRegex*) _tmp38_, _tmp39_, 0, NULL);
#line 872 "desktop-file-plugin.c"
						} else {
#line 156 "desktop-file-plugin.vala"
							_tmp34_ = FALSE;
#line 876 "desktop-file-plugin.c"
						}
#line 156 "desktop-file-plugin.vala"
						if (_tmp34_) {
#line 880 "desktop-file-plugin.c"
							SynapseDesktopFilePluginDesktopFileMatch* _tmp40_;
							SynapseDesktopFilePluginDesktopFileMatch* _tmp41_;
							GeeMapEntry* _tmp42_;
							gconstpointer _tmp43_;
							gconstpointer _tmp44_;
#line 158 "desktop-file-plugin.vala"
							_tmp40_ = dfm;
#line 158 "desktop-file-plugin.vala"
							_tmp41_ = dfm;
#line 158 "desktop-file-plugin.vala"
							_tmp42_ = matcher;
#line 158 "desktop-file-plugin.vala"
							_tmp43_ = gee_map_entry_get_value (_tmp42_);
#line 158 "desktop-file-plugin.vala"
							_tmp44_ = _tmp43_;
#line 158 "desktop-file-plugin.vala"
							synapse_result_set_add (results, (SynapseMatch*) _tmp40_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp41_, ((gint) ((gintptr) _tmp44_)) - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL));
#line 159 "desktop-file-plugin.vala"
							matched = TRUE;
#line 160 "desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 160 "desktop-file-plugin.vala"
							break;
#line 904 "desktop-file-plugin.c"
						}
					}
#line 148 "desktop-file-plugin.vala"
					_g_object_unref0 (matcher);
#line 909 "desktop-file-plugin.c"
				}
			}
#line 163 "desktop-file-plugin.vala"
			if (!matched) {
#line 914 "desktop-file-plugin.c"
				SynapseDesktopFilePluginDesktopFileMatch* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				SynapseQuery _tmp49_;
				const gchar* _tmp50_;
#line 163 "desktop-file-plugin.vala"
				_tmp46_ = dfm;
#line 163 "desktop-file-plugin.vala"
				_tmp47_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp46_);
#line 163 "desktop-file-plugin.vala"
				_tmp48_ = _tmp47_;
#line 163 "desktop-file-plugin.vala"
				_tmp49_ = *q;
#line 163 "desktop-file-plugin.vala"
				_tmp50_ = _tmp49_.query_string;
#line 163 "desktop-file-plugin.vala"
				_tmp45_ = g_str_has_prefix (_tmp48_, _tmp50_);
#line 932 "desktop-file-plugin.c"
			} else {
#line 163 "desktop-file-plugin.vala"
				_tmp45_ = FALSE;
#line 936 "desktop-file-plugin.c"
			}
#line 163 "desktop-file-plugin.vala"
			if (_tmp45_) {
#line 940 "desktop-file-plugin.c"
				SynapseMatchScore _tmp51_ = 0;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				SynapseQuery _tmp55_;
				const gchar* _tmp56_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp57_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp58_;
#line 165 "desktop-file-plugin.vala"
				_tmp52_ = dfm;
#line 165 "desktop-file-plugin.vala"
				_tmp53_ = synapse_desktop_file_plugin_desktop_file_match_get_exec (_tmp52_);
#line 165 "desktop-file-plugin.vala"
				_tmp54_ = _tmp53_;
#line 165 "desktop-file-plugin.vala"
				_tmp55_ = *q;
#line 165 "desktop-file-plugin.vala"
				_tmp56_ = _tmp55_.query_string;
#line 165 "desktop-file-plugin.vala"
				if (g_strcmp0 (_tmp54_, _tmp56_) == 0) {
#line 166 "desktop-file-plugin.vala"
					_tmp51_ = SYNAPSE_MATCH_SCORE_VERY_GOOD;
#line 963 "desktop-file-plugin.c"
				} else {
#line 166 "desktop-file-plugin.vala"
					_tmp51_ = SYNAPSE_MATCH_SCORE_AVERAGE - SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 967 "desktop-file-plugin.c"
				}
#line 165 "desktop-file-plugin.vala"
				_tmp57_ = dfm;
#line 165 "desktop-file-plugin.vala"
				_tmp58_ = dfm;
#line 165 "desktop-file-plugin.vala"
				synapse_result_set_add (results, (SynapseMatch*) _tmp57_, synapse_desktop_file_plugin_compute_relevancy (self, _tmp58_, (gint) _tmp51_));
#line 975 "desktop-file-plugin.c"
			}
#line 140 "desktop-file-plugin.vala"
			_g_object_unref0 (dfm);
#line 979 "desktop-file-plugin.c"
		}
	}
#line 133 "desktop-file-plugin.vala"
	_g_object_unref0 (matchers);
#line 984 "desktop-file-plugin.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1005 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_handles_query (SynapseItemProvider* base,
                                                SynapseQuery* q)
{
	SynapseDesktopFilePlugin * self;
	SynapseQuery _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
#line 171 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 171 "desktop-file-plugin.vala"
	g_return_val_if_fail (q != NULL, FALSE);
#line 174 "desktop-file-plugin.vala"
	_tmp0_ = *q;
#line 174 "desktop-file-plugin.vala"
	if (!((_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
#line 174 "desktop-file-plugin.vala"
		result = FALSE;
#line 174 "desktop-file-plugin.vala"
		return result;
#line 1032 "desktop-file-plugin.c"
	}
#line 175 "desktop-file-plugin.vala"
	_tmp1_ = *q;
#line 175 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_.query_string;
#line 175 "desktop-file-plugin.vala"
	_tmp3_ = string_strip (_tmp2_);
#line 175 "desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 175 "desktop-file-plugin.vala"
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
#line 175 "desktop-file-plugin.vala"
	_g_free0 (_tmp4_);
#line 175 "desktop-file-plugin.vala"
	if (_tmp5_) {
#line 175 "desktop-file-plugin.vala"
		result = FALSE;
#line 175 "desktop-file-plugin.vala"
		return result;
#line 1052 "desktop-file-plugin.c"
	}
#line 177 "desktop-file-plugin.vala"
	result = TRUE;
#line 177 "desktop-file-plugin.vala"
	return result;
#line 1058 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search_data_free (gpointer _data)
{
	SynapseDesktopFilePluginSearchData* _data_;
	_data_ = _data;
#line 24 "desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "desktop-file-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "desktop-file-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "desktop-file-plugin.vala"
	g_slice_free (SynapseDesktopFilePluginSearchData, _data_);
#line 1074 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFilePlugin * self;
	SynapseDesktopFilePluginSearchData* _data_;
	SynapseDesktopFilePlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "desktop-file-plugin.vala"
	g_return_if_fail (q != NULL);
#line 24 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 24 "desktop-file-plugin.vala"
	_data_ = g_slice_new0 (SynapseDesktopFilePluginSearchData);
#line 24 "desktop-file-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "desktop-file-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_plugin_real_search_data_free);
#line 24 "desktop-file-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "desktop-file-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "desktop-file-plugin.vala"
	_tmp1_ = *q;
#line 24 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "desktop-file-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "desktop-file-plugin.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "desktop-file-plugin.vala"
	_data_->q = _tmp3_;
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data_);
#line 1115 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_search_finish (SynapseItemProvider* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	SynapseResultSet* result;
	SynapseDesktopFilePluginSearchData* _data_;
#line 24 "desktop-file-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "desktop-file-plugin.vala"
	if (NULL == _data_) {
#line 24 "desktop-file-plugin.vala"
		return NULL;
#line 1131 "desktop-file-plugin.c"
	}
#line 24 "desktop-file-plugin.vala"
	result = _data_->result;
#line 24 "desktop-file-plugin.vala"
	_data_->result = NULL;
#line 24 "desktop-file-plugin.vala"
	return result;
#line 1139 "desktop-file-plugin.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 180 "desktop-file-plugin.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 180 "desktop-file-plugin.vala"
	return _data1_;
#line 1149 "desktop-file-plugin.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 180 "desktop-file-plugin.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1159 "desktop-file-plugin.c"
		SynapseDesktopFilePlugin* self;
#line 180 "desktop-file-plugin.vala"
		self = _data1_->self;
#line 180 "desktop-file-plugin.vala"
		_g_object_unref0 (self);
#line 180 "desktop-file-plugin.vala"
		g_slice_free (Block1Data, _data1_);
#line 1167 "desktop-file-plugin.c"
	}
}

static void
___lambda4_ (Block1Data* _data1_)
{
	SynapseDesktopFilePlugin* self;
#line 185 "desktop-file-plugin.vala"
	self = _data1_->self;
#line 186 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_real_search_co (_data1_->_async_data_);
#line 1179 "desktop-file-plugin.c"
}

static void
____lambda4__synapse_desktop_file_plugin_load_complete (SynapseDesktopFilePlugin* _sender,
                                                        gpointer self)
{
#line 185 "desktop-file-plugin.vala"
	___lambda4_ (self);
#line 1188 "desktop-file-plugin.c"
}

static gboolean
_synapse_desktop_file_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_plugin_real_search_co (self);
#line 196 "desktop-file-plugin.vala"
	return result;
#line 1198 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_search_co (SynapseDesktopFilePluginSearchData* _data_)
{
#line 180 "desktop-file-plugin.vala"
	switch (_data_->_state_) {
#line 180 "desktop-file-plugin.vala"
		case 0:
#line 1208 "desktop-file-plugin.c"
		goto _state_0;
#line 180 "desktop-file-plugin.vala"
		case 1:
#line 1212 "desktop-file-plugin.c"
		goto _state_1;
#line 180 "desktop-file-plugin.vala"
		case 2:
#line 1216 "desktop-file-plugin.c"
		goto _state_2;
		default:
#line 180 "desktop-file-plugin.vala"
		g_assert_not_reached ();
#line 1221 "desktop-file-plugin.c"
	}
	_state_0:
#line 180 "desktop-file-plugin.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 180 "desktop-file-plugin.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 180 "desktop-file-plugin.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 180 "desktop-file-plugin.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 182 "desktop-file-plugin.vala"
	if (_data_->self->priv->loading_in_progress) {
#line 185 "desktop-file-plugin.vala"
		_data_->_tmp0_ = g_signal_connect_data (_data_->self, "load-complete", (GCallback) ____lambda4__synapse_desktop_file_plugin_load_complete, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
#line 185 "desktop-file-plugin.vala"
		_data_->signal_id = _data_->_tmp0_;
#line 188 "desktop-file-plugin.vala"
		_data_->_state_ = 1;
#line 188 "desktop-file-plugin.vala"
		return FALSE;
#line 1242 "desktop-file-plugin.c"
		_state_1:
		;
#line 189 "desktop-file-plugin.vala"
		g_signal_handler_disconnect (_data_->self, _data_->signal_id);
#line 1247 "desktop-file-plugin.c"
	} else {
#line 196 "desktop-file-plugin.vala"
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, _synapse_desktop_file_plugin_real_search_co_gsource_func, _data_, NULL);
#line 197 "desktop-file-plugin.vala"
		_data_->_state_ = 2;
#line 197 "desktop-file-plugin.vala"
		return FALSE;
#line 1255 "desktop-file-plugin.c"
		_state_2:
		;
	}
#line 200 "desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 200 "desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 200 "desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 200 "desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 200 "desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 200 "desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 200 "desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 200 "desktop-file-plugin.vala"
			return FALSE;
#line 1275 "desktop-file-plugin.c"
		} else {
#line 200 "desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 200 "desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 200 "desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 200 "desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 200 "desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 200 "desktop-file-plugin.vala"
			return FALSE;
#line 1289 "desktop-file-plugin.c"
		}
	}
#line 203 "desktop-file-plugin.vala"
	_data_->_tmp1_ = synapse_result_set_new ();
#line 203 "desktop-file-plugin.vala"
	_data_->_result_ = _data_->_tmp1_;
#line 205 "desktop-file-plugin.vala"
	_data_->_tmp2_ = _data_->q;
#line 205 "desktop-file-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
#line 205 "desktop-file-plugin.vala"
	if (g_utf8_strlen (_data_->_tmp3_, (gssize) -1) == 1) {
#line 207 "desktop-file-plugin.vala"
		_data_->flags = (SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING | SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) | SYNAPSE_MATCHER_FLAGS_NO_FUZZY;
#line 209 "desktop-file-plugin.vala"
		_data_->_tmp4_ = _data_->q;
#line 209 "desktop-file-plugin.vala"
		_data_->_tmp5_ = _data_->_result_;
#line 209 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp4_, _data_->_tmp5_, _data_->flags);
#line 1310 "desktop-file-plugin.c"
	} else {
#line 213 "desktop-file-plugin.vala"
		_data_->_tmp6_ = _data_->q;
#line 213 "desktop-file-plugin.vala"
		_data_->_tmp7_ = _data_->_result_;
#line 213 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_full_search (_data_->self, &_data_->_tmp6_, _data_->_tmp7_, 0);
#line 1318 "desktop-file-plugin.c"
	}
#line 216 "desktop-file-plugin.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 216 "desktop-file-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 216 "desktop-file-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 216 "desktop-file-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 216 "desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 216 "desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 216 "desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 216 "desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 216 "desktop-file-plugin.vala"
			return FALSE;
#line 1338 "desktop-file-plugin.c"
		} else {
#line 216 "desktop-file-plugin.vala"
			_g_object_unref0 (_data_->_result_);
#line 216 "desktop-file-plugin.vala"
			block1_data_unref (_data_->_data1_);
#line 216 "desktop-file-plugin.vala"
			_data_->_data1_ = NULL;
#line 216 "desktop-file-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 216 "desktop-file-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 216 "desktop-file-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 216 "desktop-file-plugin.vala"
			return FALSE;
#line 1354 "desktop-file-plugin.c"
		}
	}
#line 218 "desktop-file-plugin.vala"
	_data_->result = _data_->_result_;
#line 218 "desktop-file-plugin.vala"
	block1_data_unref (_data_->_data1_);
#line 218 "desktop-file-plugin.vala"
	_data_->_data1_ = NULL;
#line 218 "desktop-file-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 218 "desktop-file-plugin.vala"
	if (_data_->_state_ != 0) {
#line 218 "desktop-file-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 218 "desktop-file-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1371 "desktop-file-plugin.c"
		}
	}
#line 218 "desktop-file-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 218 "desktop-file-plugin.vala"
	return FALSE;
#line 1378 "desktop-file-plugin.c"
}

static SynapseResultSet*
synapse_desktop_file_plugin_real_find_for_match (SynapseActionProvider* base,
                                                 SynapseQuery* query,
                                                 SynapseMatch* match)
{
	SynapseDesktopFilePlugin * self;
	SynapseUriMatch* uri_match = NULL;
	SynapseDesktopFilePluginDesktopFileMatch* app_match = NULL;
	GeeList* any_list = NULL;
	SynapseUriMatch* _tmp0_;
	gboolean _tmp72_ = FALSE;
	GeeList* _tmp73_;
	SynapseResultSet* rs = NULL;
	SynapseResultSet* _tmp77_;
	SynapseQuery _tmp78_;
	const gchar* _tmp79_;
	SynapseResultSet* result;
#line 298 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 298 "desktop-file-plugin.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 298 "desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 300 "desktop-file-plugin.vala"
	uri_match = NULL;
#line 301 "desktop-file-plugin.vala"
	app_match = NULL;
#line 302 "desktop-file-plugin.vala"
	any_list = NULL;
#line 304 "desktop-file-plugin.vala"
	uri_match = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL;
#line 304 "desktop-file-plugin.vala"
	_tmp0_ = uri_match;
#line 304 "desktop-file-plugin.vala"
	if (_tmp0_ != NULL) {
#line 1416 "desktop-file-plugin.c"
		SynapseDesktopFileService* dfs = NULL;
		SynapseDesktopFileService* _tmp1_;
		GeeList* list_for_mimetype = NULL;
		SynapseDesktopFileService* _tmp2_;
		SynapseUriMatch* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 306 "desktop-file-plugin.vala"
		_tmp1_ = synapse_desktop_file_service_get_default ();
#line 306 "desktop-file-plugin.vala"
		dfs = _tmp1_;
#line 307 "desktop-file-plugin.vala"
		_tmp2_ = dfs;
#line 307 "desktop-file-plugin.vala"
		_tmp3_ = uri_match;
#line 307 "desktop-file-plugin.vala"
		_tmp4_ = synapse_uri_match_get_mime_type (_tmp3_);
#line 307 "desktop-file-plugin.vala"
		_tmp5_ = _tmp4_;
#line 307 "desktop-file-plugin.vala"
		_tmp6_ = synapse_desktop_file_service_get_desktop_files_for_type (_tmp2_, _tmp5_);
#line 307 "desktop-file-plugin.vala"
		list_for_mimetype = _tmp6_;
#line 309 "desktop-file-plugin.vala"
		_tmp7_ = list_for_mimetype;
#line 309 "desktop-file-plugin.vala"
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
#line 309 "desktop-file-plugin.vala"
		_tmp9_ = _tmp8_;
#line 309 "desktop-file-plugin.vala"
		if (_tmp9_ > 1) {
#line 1452 "desktop-file-plugin.c"
			GeeList* ow_list = NULL;
			GeeMap* _tmp10_;
			SynapseUriMatch* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_;
			GeeList* _tmp15_;
			GeeList* _tmp34_;
			GeeList* _tmp35_;
#line 312 "desktop-file-plugin.vala"
			_tmp10_ = self->priv->mimetype_map;
#line 312 "desktop-file-plugin.vala"
			_tmp11_ = uri_match;
#line 312 "desktop-file-plugin.vala"
			_tmp12_ = synapse_uri_match_get_mime_type (_tmp11_);
#line 312 "desktop-file-plugin.vala"
			_tmp13_ = _tmp12_;
#line 312 "desktop-file-plugin.vala"
			_tmp14_ = gee_map_get (_tmp10_, _tmp13_);
#line 312 "desktop-file-plugin.vala"
			ow_list = (GeeList*) _tmp14_;
#line 313 "desktop-file-plugin.vala"
			_tmp15_ = ow_list;
#line 313 "desktop-file-plugin.vala"
			if (_tmp15_ == NULL) {
#line 1478 "desktop-file-plugin.c"
				GeeLinkedList* _tmp16_;
				GeeMap* _tmp17_;
				SynapseUriMatch* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				GeeList* _tmp21_;
#line 315 "desktop-file-plugin.vala"
				_tmp16_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 315 "desktop-file-plugin.vala"
				_g_object_unref0 (ow_list);
#line 315 "desktop-file-plugin.vala"
				ow_list = (GeeList*) _tmp16_;
#line 316 "desktop-file-plugin.vala"
				_tmp17_ = self->priv->mimetype_map;
#line 316 "desktop-file-plugin.vala"
				_tmp18_ = uri_match;
#line 316 "desktop-file-plugin.vala"
				_tmp19_ = synapse_uri_match_get_mime_type (_tmp18_);
#line 316 "desktop-file-plugin.vala"
				_tmp20_ = _tmp19_;
#line 316 "desktop-file-plugin.vala"
				_tmp21_ = ow_list;
#line 316 "desktop-file-plugin.vala"
				gee_map_set (_tmp17_, _tmp20_, _tmp21_);
#line 1503 "desktop-file-plugin.c"
				{
					GeeList* _entry_list = NULL;
					GeeList* _tmp22_;
					gint _entry_size = 0;
					GeeList* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _entry_index = 0;
#line 318 "desktop-file-plugin.vala"
					_tmp22_ = list_for_mimetype;
#line 318 "desktop-file-plugin.vala"
					_entry_list = _tmp22_;
#line 318 "desktop-file-plugin.vala"
					_tmp23_ = _entry_list;
#line 318 "desktop-file-plugin.vala"
					_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
#line 318 "desktop-file-plugin.vala"
					_tmp25_ = _tmp24_;
#line 318 "desktop-file-plugin.vala"
					_entry_size = _tmp25_;
#line 318 "desktop-file-plugin.vala"
					_entry_index = -1;
#line 318 "desktop-file-plugin.vala"
					while (TRUE) {
#line 1528 "desktop-file-plugin.c"
						gint _tmp26_;
						gint _tmp27_;
						SynapseDesktopFileInfo* entry = NULL;
						GeeList* _tmp28_;
						gpointer _tmp29_;
						GeeList* _tmp30_;
						SynapseDesktopFileInfo* _tmp31_;
						SynapseDesktopFilePluginOpenWithAction* _tmp32_;
						SynapseDesktopFilePluginOpenWithAction* _tmp33_;
#line 318 "desktop-file-plugin.vala"
						_entry_index = _entry_index + 1;
#line 318 "desktop-file-plugin.vala"
						_tmp26_ = _entry_index;
#line 318 "desktop-file-plugin.vala"
						_tmp27_ = _entry_size;
#line 318 "desktop-file-plugin.vala"
						if (!(_tmp26_ < _tmp27_)) {
#line 318 "desktop-file-plugin.vala"
							break;
#line 1548 "desktop-file-plugin.c"
						}
#line 318 "desktop-file-plugin.vala"
						_tmp28_ = _entry_list;
#line 318 "desktop-file-plugin.vala"
						_tmp29_ = gee_list_get (_tmp28_, _entry_index);
#line 318 "desktop-file-plugin.vala"
						entry = (SynapseDesktopFileInfo*) _tmp29_;
#line 320 "desktop-file-plugin.vala"
						_tmp30_ = ow_list;
#line 320 "desktop-file-plugin.vala"
						_tmp31_ = entry;
#line 320 "desktop-file-plugin.vala"
						_tmp32_ = synapse_desktop_file_plugin_open_with_action_new (_tmp31_);
#line 320 "desktop-file-plugin.vala"
						_tmp33_ = _tmp32_;
#line 320 "desktop-file-plugin.vala"
						gee_collection_add ((GeeCollection*) _tmp30_, _tmp33_);
#line 320 "desktop-file-plugin.vala"
						_g_object_unref0 (_tmp33_);
#line 318 "desktop-file-plugin.vala"
						_g_object_unref0 (entry);
#line 1570 "desktop-file-plugin.c"
					}
				}
			}
#line 324 "desktop-file-plugin.vala"
			_tmp34_ = ow_list;
#line 324 "desktop-file-plugin.vala"
			_tmp35_ = _g_object_ref0 (_tmp34_);
#line 324 "desktop-file-plugin.vala"
			_g_object_unref0 (any_list);
#line 324 "desktop-file-plugin.vala"
			any_list = _tmp35_;
#line 309 "desktop-file-plugin.vala"
			_g_object_unref0 (ow_list);
#line 1584 "desktop-file-plugin.c"
		}
#line 304 "desktop-file-plugin.vala"
		_g_object_unref0 (list_for_mimetype);
#line 304 "desktop-file-plugin.vala"
		_g_object_unref0 (dfs);
#line 1590 "desktop-file-plugin.c"
	} else {
		SynapseDesktopFilePluginDesktopFileMatch* _tmp36_;
#line 327 "desktop-file-plugin.vala"
		app_match = SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH (match) ? ((SynapseDesktopFilePluginDesktopFileMatch*) match) : NULL;
#line 327 "desktop-file-plugin.vala"
		_tmp36_ = app_match;
#line 327 "desktop-file-plugin.vala"
		if (_tmp36_ != NULL) {
#line 1599 "desktop-file-plugin.c"
			GeeList* oa_list = NULL;
			GeeMap* _tmp37_;
			SynapseDesktopFilePluginDesktopFileMatch* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gpointer _tmp41_;
			GeeList* _tmp42_;
			GeeList* _tmp70_;
			GeeList* _tmp71_;
#line 329 "desktop-file-plugin.vala"
			_tmp37_ = self->priv->actions_map;
#line 329 "desktop-file-plugin.vala"
			_tmp38_ = app_match;
#line 329 "desktop-file-plugin.vala"
			_tmp39_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp38_);
#line 329 "desktop-file-plugin.vala"
			_tmp40_ = _tmp39_;
#line 329 "desktop-file-plugin.vala"
			_tmp41_ = gee_map_get (_tmp37_, _tmp40_);
#line 329 "desktop-file-plugin.vala"
			oa_list = (GeeList*) _tmp41_;
#line 330 "desktop-file-plugin.vala"
			_tmp42_ = oa_list;
#line 330 "desktop-file-plugin.vala"
			if (_tmp42_ == NULL) {
#line 1625 "desktop-file-plugin.c"
				GeeLinkedList* _tmp43_;
				GeeMap* _tmp44_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				GeeList* _tmp48_;
				SynapseDesktopFileService* dfs = NULL;
				SynapseDesktopFileService* _tmp49_;
				SynapseDesktopFileInfo* desktop_file_info = NULL;
				SynapseDesktopFileService* _tmp50_;
				SynapseDesktopFilePluginDesktopFileMatch* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				SynapseDesktopFileInfo* _tmp56_;
				SynapseDesktopFileInfo* _tmp57_;
				SynapseDesktopFileInfo* _tmp58_;
#line 332 "desktop-file-plugin.vala"
				_tmp43_ = gee_linked_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 332 "desktop-file-plugin.vala"
				_g_object_unref0 (oa_list);
#line 332 "desktop-file-plugin.vala"
				oa_list = (GeeList*) _tmp43_;
#line 333 "desktop-file-plugin.vala"
				_tmp44_ = self->priv->actions_map;
#line 333 "desktop-file-plugin.vala"
				_tmp45_ = app_match;
#line 333 "desktop-file-plugin.vala"
				_tmp46_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp45_);
#line 333 "desktop-file-plugin.vala"
				_tmp47_ = _tmp46_;
#line 333 "desktop-file-plugin.vala"
				_tmp48_ = oa_list;
#line 333 "desktop-file-plugin.vala"
				gee_map_set (_tmp44_, _tmp47_, _tmp48_);
#line 335 "desktop-file-plugin.vala"
				_tmp49_ = synapse_desktop_file_service_get_default ();
#line 335 "desktop-file-plugin.vala"
				dfs = _tmp49_;
#line 336 "desktop-file-plugin.vala"
				_tmp50_ = dfs;
#line 336 "desktop-file-plugin.vala"
				_tmp51_ = app_match;
#line 336 "desktop-file-plugin.vala"
				_tmp52_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp51_);
#line 336 "desktop-file-plugin.vala"
				_tmp53_ = _tmp52_;
#line 336 "desktop-file-plugin.vala"
				_tmp54_ = g_path_get_basename (_tmp53_);
#line 336 "desktop-file-plugin.vala"
				_tmp55_ = _tmp54_;
#line 336 "desktop-file-plugin.vala"
				_tmp56_ = synapse_desktop_file_service_get_desktop_file_for_id (_tmp50_, _tmp55_);
#line 336 "desktop-file-plugin.vala"
				_tmp57_ = _tmp56_;
#line 336 "desktop-file-plugin.vala"
				_g_free0 (_tmp55_);
#line 336 "desktop-file-plugin.vala"
				desktop_file_info = _tmp57_;
#line 339 "desktop-file-plugin.vala"
				_tmp58_ = desktop_file_info;
#line 339 "desktop-file-plugin.vala"
				if (_tmp58_ != NULL) {
#line 1690 "desktop-file-plugin.c"
					SynapseDesktopFileInfo* _tmp59_;
					gchar** _tmp60_;
					gint _tmp60__length1;
#line 341 "desktop-file-plugin.vala"
					_tmp59_ = desktop_file_info;
#line 341 "desktop-file-plugin.vala"
					_tmp60_ = _tmp59_->actions;
#line 341 "desktop-file-plugin.vala"
					_tmp60__length1 = _tmp59_->actions_length1;
#line 1700 "desktop-file-plugin.c"
					{
						gchar** action_collection = NULL;
						gint action_collection_length1 = 0;
						gint _action_collection_size_ = 0;
						gint action_it = 0;
#line 341 "desktop-file-plugin.vala"
						action_collection = _tmp60_;
#line 341 "desktop-file-plugin.vala"
						action_collection_length1 = _tmp60__length1;
#line 341 "desktop-file-plugin.vala"
						for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
#line 1712 "desktop-file-plugin.c"
							gchar* _tmp61_;
							gchar* action = NULL;
#line 341 "desktop-file-plugin.vala"
							_tmp61_ = g_strdup (action_collection[action_it]);
#line 341 "desktop-file-plugin.vala"
							action = _tmp61_;
#line 1719 "desktop-file-plugin.c"
							{
								GeeList* _tmp62_;
								SynapseDesktopFileInfo* _tmp63_;
								const gchar* _tmp64_;
								SynapseDesktopFilePluginOpenAppAction* _tmp65_;
								SynapseDesktopFilePluginOpenAppAction* _tmp66_;
#line 343 "desktop-file-plugin.vala"
								_tmp62_ = oa_list;
#line 343 "desktop-file-plugin.vala"
								_tmp63_ = desktop_file_info;
#line 343 "desktop-file-plugin.vala"
								_tmp64_ = action;
#line 343 "desktop-file-plugin.vala"
								_tmp65_ = synapse_desktop_file_plugin_open_app_action_new (_tmp63_, _tmp64_);
#line 343 "desktop-file-plugin.vala"
								_tmp66_ = _tmp65_;
#line 343 "desktop-file-plugin.vala"
								gee_collection_add ((GeeCollection*) _tmp62_, _tmp66_);
#line 343 "desktop-file-plugin.vala"
								_g_object_unref0 (_tmp66_);
#line 341 "desktop-file-plugin.vala"
								_g_free0 (action);
#line 1742 "desktop-file-plugin.c"
							}
						}
					}
				} else {
					SynapseDesktopFilePluginDesktopFileMatch* _tmp67_;
					const gchar* _tmp68_;
					const gchar* _tmp69_;
#line 348 "desktop-file-plugin.vala"
					_tmp67_ = app_match;
#line 348 "desktop-file-plugin.vala"
					_tmp68_ = synapse_application_match_get_filename ((SynapseApplicationMatch*) _tmp67_);
#line 348 "desktop-file-plugin.vala"
					_tmp69_ = _tmp68_;
#line 348 "desktop-file-plugin.vala"
					g_warning ("desktop-file-plugin.vala:348: No DesktopInfoFile for %s", _tmp69_);
#line 1758 "desktop-file-plugin.c"
				}
#line 330 "desktop-file-plugin.vala"
				_g_object_unref0 (desktop_file_info);
#line 330 "desktop-file-plugin.vala"
				_g_object_unref0 (dfs);
#line 1764 "desktop-file-plugin.c"
			}
#line 352 "desktop-file-plugin.vala"
			_tmp70_ = oa_list;
#line 352 "desktop-file-plugin.vala"
			_tmp71_ = _g_object_ref0 (_tmp70_);
#line 352 "desktop-file-plugin.vala"
			_g_object_unref0 (any_list);
#line 352 "desktop-file-plugin.vala"
			any_list = _tmp71_;
#line 327 "desktop-file-plugin.vala"
			_g_object_unref0 (oa_list);
#line 1776 "desktop-file-plugin.c"
		}
	}
#line 355 "desktop-file-plugin.vala"
	_tmp73_ = any_list;
#line 355 "desktop-file-plugin.vala"
	if (_tmp73_ == NULL) {
#line 355 "desktop-file-plugin.vala"
		_tmp72_ = TRUE;
#line 1785 "desktop-file-plugin.c"
	} else {
		GeeList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
#line 355 "desktop-file-plugin.vala"
		_tmp74_ = any_list;
#line 355 "desktop-file-plugin.vala"
		_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
#line 355 "desktop-file-plugin.vala"
		_tmp76_ = _tmp75_;
#line 355 "desktop-file-plugin.vala"
		_tmp72_ = _tmp76_ == 0;
#line 1798 "desktop-file-plugin.c"
	}
#line 355 "desktop-file-plugin.vala"
	if (_tmp72_) {
#line 355 "desktop-file-plugin.vala"
		result = NULL;
#line 355 "desktop-file-plugin.vala"
		_g_object_unref0 (any_list);
#line 355 "desktop-file-plugin.vala"
		return result;
#line 1808 "desktop-file-plugin.c"
	}
#line 357 "desktop-file-plugin.vala"
	_tmp77_ = synapse_result_set_new ();
#line 357 "desktop-file-plugin.vala"
	rs = _tmp77_;
#line 359 "desktop-file-plugin.vala"
	_tmp78_ = *query;
#line 359 "desktop-file-plugin.vala"
	_tmp79_ = _tmp78_.query_string;
#line 359 "desktop-file-plugin.vala"
	if (g_strcmp0 (_tmp79_, "") == 0) {
#line 1820 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp80_;
			gint _action_size = 0;
			GeeList* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gint _action_index = 0;
#line 361 "desktop-file-plugin.vala"
			_tmp80_ = any_list;
#line 361 "desktop-file-plugin.vala"
			_action_list = _tmp80_;
#line 361 "desktop-file-plugin.vala"
			_tmp81_ = _action_list;
#line 361 "desktop-file-plugin.vala"
			_tmp82_ = gee_collection_get_size ((GeeCollection*) _tmp81_);
#line 361 "desktop-file-plugin.vala"
			_tmp83_ = _tmp82_;
#line 361 "desktop-file-plugin.vala"
			_action_size = _tmp83_;
#line 361 "desktop-file-plugin.vala"
			_action_index = -1;
#line 361 "desktop-file-plugin.vala"
			while (TRUE) {
#line 1845 "desktop-file-plugin.c"
				gint _tmp84_;
				gint _tmp85_;
				SynapseAction* action = NULL;
				GeeList* _tmp86_;
				gpointer _tmp87_;
				SynapseResultSet* _tmp88_;
				SynapseAction* _tmp89_;
#line 361 "desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 361 "desktop-file-plugin.vala"
				_tmp84_ = _action_index;
#line 361 "desktop-file-plugin.vala"
				_tmp85_ = _action_size;
#line 361 "desktop-file-plugin.vala"
				if (!(_tmp84_ < _tmp85_)) {
#line 361 "desktop-file-plugin.vala"
					break;
#line 1863 "desktop-file-plugin.c"
				}
#line 361 "desktop-file-plugin.vala"
				_tmp86_ = _action_list;
#line 361 "desktop-file-plugin.vala"
				_tmp87_ = gee_list_get (_tmp86_, _action_index);
#line 361 "desktop-file-plugin.vala"
				action = (SynapseAction*) _tmp87_;
#line 363 "desktop-file-plugin.vala"
				_tmp88_ = rs;
#line 363 "desktop-file-plugin.vala"
				_tmp89_ = action;
#line 363 "desktop-file-plugin.vala"
				synapse_result_set_add (_tmp88_, (SynapseMatch*) _tmp89_, (gint) SYNAPSE_MATCH_SCORE_POOR);
#line 361 "desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 1879 "desktop-file-plugin.c"
			}
		}
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp90_;
		const gchar* _tmp91_;
		GeeList* _tmp92_;
#line 368 "desktop-file-plugin.vala"
		_tmp90_ = *query;
#line 368 "desktop-file-plugin.vala"
		_tmp91_ = _tmp90_.query_string;
#line 368 "desktop-file-plugin.vala"
		_tmp92_ = synapse_query_get_matchers_for_query (_tmp91_, 0, G_REGEX_OPTIMIZE | G_REGEX_CASELESS);
#line 368 "desktop-file-plugin.vala"
		matchers = _tmp92_;
#line 1895 "desktop-file-plugin.c"
		{
			GeeList* _action_list = NULL;
			GeeList* _tmp93_;
			gint _action_size = 0;
			GeeList* _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			gint _action_index = 0;
#line 370 "desktop-file-plugin.vala"
			_tmp93_ = any_list;
#line 370 "desktop-file-plugin.vala"
			_action_list = _tmp93_;
#line 370 "desktop-file-plugin.vala"
			_tmp94_ = _action_list;
#line 370 "desktop-file-plugin.vala"
			_tmp95_ = gee_collection_get_size ((GeeCollection*) _tmp94_);
#line 370 "desktop-file-plugin.vala"
			_tmp96_ = _tmp95_;
#line 370 "desktop-file-plugin.vala"
			_action_size = _tmp96_;
#line 370 "desktop-file-plugin.vala"
			_action_index = -1;
#line 370 "desktop-file-plugin.vala"
			while (TRUE) {
#line 1920 "desktop-file-plugin.c"
				gint _tmp97_;
				gint _tmp98_;
				SynapseAction* action = NULL;
				GeeList* _tmp99_;
				gpointer _tmp100_;
#line 370 "desktop-file-plugin.vala"
				_action_index = _action_index + 1;
#line 370 "desktop-file-plugin.vala"
				_tmp97_ = _action_index;
#line 370 "desktop-file-plugin.vala"
				_tmp98_ = _action_size;
#line 370 "desktop-file-plugin.vala"
				if (!(_tmp97_ < _tmp98_)) {
#line 370 "desktop-file-plugin.vala"
					break;
#line 1936 "desktop-file-plugin.c"
				}
#line 370 "desktop-file-plugin.vala"
				_tmp99_ = _action_list;
#line 370 "desktop-file-plugin.vala"
				_tmp100_ = gee_list_get (_tmp99_, _action_index);
#line 370 "desktop-file-plugin.vala"
				action = (SynapseAction*) _tmp100_;
#line 1944 "desktop-file-plugin.c"
				{
					GeeList* _matcher_list = NULL;
					GeeList* _tmp101_;
					gint _matcher_size = 0;
					GeeList* _tmp102_;
					gint _tmp103_;
					gint _tmp104_;
					gint _matcher_index = 0;
#line 372 "desktop-file-plugin.vala"
					_tmp101_ = matchers;
#line 372 "desktop-file-plugin.vala"
					_matcher_list = _tmp101_;
#line 372 "desktop-file-plugin.vala"
					_tmp102_ = _matcher_list;
#line 372 "desktop-file-plugin.vala"
					_tmp103_ = gee_collection_get_size ((GeeCollection*) _tmp102_);
#line 372 "desktop-file-plugin.vala"
					_tmp104_ = _tmp103_;
#line 372 "desktop-file-plugin.vala"
					_matcher_size = _tmp104_;
#line 372 "desktop-file-plugin.vala"
					_matcher_index = -1;
#line 372 "desktop-file-plugin.vala"
					while (TRUE) {
#line 1969 "desktop-file-plugin.c"
						gint _tmp105_;
						gint _tmp106_;
						GeeMapEntry* matcher = NULL;
						GeeList* _tmp107_;
						gpointer _tmp108_;
						GeeMapEntry* _tmp109_;
						gconstpointer _tmp110_;
						gconstpointer _tmp111_;
						SynapseAction* _tmp112_;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
#line 372 "desktop-file-plugin.vala"
						_matcher_index = _matcher_index + 1;
#line 372 "desktop-file-plugin.vala"
						_tmp105_ = _matcher_index;
#line 372 "desktop-file-plugin.vala"
						_tmp106_ = _matcher_size;
#line 372 "desktop-file-plugin.vala"
						if (!(_tmp105_ < _tmp106_)) {
#line 372 "desktop-file-plugin.vala"
							break;
#line 1991 "desktop-file-plugin.c"
						}
#line 372 "desktop-file-plugin.vala"
						_tmp107_ = _matcher_list;
#line 372 "desktop-file-plugin.vala"
						_tmp108_ = gee_list_get (_tmp107_, _matcher_index);
#line 372 "desktop-file-plugin.vala"
						matcher = (GeeMapEntry*) _tmp108_;
#line 374 "desktop-file-plugin.vala"
						_tmp109_ = matcher;
#line 374 "desktop-file-plugin.vala"
						_tmp110_ = gee_map_entry_get_key (_tmp109_);
#line 374 "desktop-file-plugin.vala"
						_tmp111_ = _tmp110_;
#line 374 "desktop-file-plugin.vala"
						_tmp112_ = action;
#line 374 "desktop-file-plugin.vala"
						_tmp113_ = synapse_match_get_title ((SynapseMatch*) _tmp112_);
#line 374 "desktop-file-plugin.vala"
						_tmp114_ = _tmp113_;
#line 374 "desktop-file-plugin.vala"
						if (g_regex_match ((GRegex*) _tmp111_, _tmp114_, 0, NULL)) {
#line 2013 "desktop-file-plugin.c"
							SynapseResultSet* _tmp115_;
							SynapseAction* _tmp116_;
							GeeMapEntry* _tmp117_;
							gconstpointer _tmp118_;
							gconstpointer _tmp119_;
#line 376 "desktop-file-plugin.vala"
							_tmp115_ = rs;
#line 376 "desktop-file-plugin.vala"
							_tmp116_ = action;
#line 376 "desktop-file-plugin.vala"
							_tmp117_ = matcher;
#line 376 "desktop-file-plugin.vala"
							_tmp118_ = gee_map_entry_get_value (_tmp117_);
#line 376 "desktop-file-plugin.vala"
							_tmp119_ = _tmp118_;
#line 376 "desktop-file-plugin.vala"
							synapse_result_set_add (_tmp115_, (SynapseMatch*) _tmp116_, (gint) ((gintptr) _tmp119_));
#line 377 "desktop-file-plugin.vala"
							_g_object_unref0 (matcher);
#line 377 "desktop-file-plugin.vala"
							break;
#line 2035 "desktop-file-plugin.c"
						}
#line 372 "desktop-file-plugin.vala"
						_g_object_unref0 (matcher);
#line 2039 "desktop-file-plugin.c"
					}
				}
#line 370 "desktop-file-plugin.vala"
				_g_object_unref0 (action);
#line 2044 "desktop-file-plugin.c"
			}
		}
#line 359 "desktop-file-plugin.vala"
		_g_object_unref0 (matchers);
#line 2049 "desktop-file-plugin.c"
	}
#line 383 "desktop-file-plugin.vala"
	result = rs;
#line 383 "desktop-file-plugin.vala"
	_g_object_unref0 (any_list);
#line 383 "desktop-file-plugin.vala"
	return result;
#line 2057 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_construct (GType object_type)
{
	SynapseDesktopFilePlugin * self = NULL;
#line 24 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) g_object_new (object_type, NULL);
#line 24 "desktop-file-plugin.vala"
	return self;
#line 2068 "desktop-file-plugin.c"
}

SynapseDesktopFilePlugin*
synapse_desktop_file_plugin_new (void)
{
#line 24 "desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_construct (SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN);
#line 2076 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseDesktopFilePlugin* self;
#line 26 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 26 "desktop-file-plugin.vala"
	result = self->priv->_enabled;
#line 26 "desktop-file-plugin.vala"
	return result;
#line 2090 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_real_set_enabled (SynapseActivatable* base,
                                              gboolean value)
{
	SynapseDesktopFilePlugin* self;
	gboolean old_value;
#line 26 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePlugin*) base;
#line 26 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_real_get_enabled (base);
#line 26 "desktop-file-plugin.vala"
	if (old_value != value) {
#line 26 "desktop-file-plugin.vala"
		self->priv->_enabled = value;
#line 26 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY]);
#line 2109 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_desktop_file_match_get_instance_private (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginDesktopFileMatch_private_offset);
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_construct (GType object_type,
                                                          SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginDesktopFileMatch * self = NULL;
#line 46 "desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 48 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginDesktopFileMatch*) g_object_new (object_type, "desktop-info", info, NULL);
#line 46 "desktop-file-plugin.vala"
	return self;
#line 2130 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginDesktopFileMatch*
synapse_desktop_file_plugin_desktop_file_match_new (SynapseDesktopFileInfo* info)
{
#line 46 "desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_desktop_file_match_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, info);
#line 2138 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 40 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 40 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 40 "desktop-file-plugin.vala"
	return result;
#line 2154 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 40 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (self);
#line 40 "desktop-file-plugin.vala"
	if (old_value != value) {
#line 2168 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 40 "desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 40 "desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 40 "desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 40 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY]);
#line 2178 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title_folded;
#line 41 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 41 "desktop-file-plugin.vala"
	return result;
#line 2195 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_folded (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                 const gchar* value)
{
	gchar* old_value;
#line 41 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 41 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_folded (self);
#line 41 "desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2209 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 41 "desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 41 "desktop-file-plugin.vala"
		_g_free0 (self->priv->_title_folded);
#line 41 "desktop-file-plugin.vala"
		self->priv->_title_folded = _tmp0_;
#line 41 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY]);
#line 2219 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_title_unaccented;
#line 42 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 42 "desktop-file-plugin.vala"
	return result;
#line 2236 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                                     const gchar* value)
{
	gchar* old_value;
#line 42 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 42 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self);
#line 42 "desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2250 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 42 "desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 42 "desktop-file-plugin.vala"
		_g_free0 (self->priv->_title_unaccented);
#line 42 "desktop-file-plugin.vala"
		self->priv->_title_unaccented = _tmp0_;
#line 42 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY]);
#line 2260 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 43 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 43 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 43 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 43 "desktop-file-plugin.vala"
	return result;
#line 2277 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                               const gchar* value)
{
	gchar* old_value;
#line 43 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 43 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self);
#line 43 "desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2291 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 43 "desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 43 "desktop-file-plugin.vala"
		_g_free0 (self->priv->_desktop_id);
#line 43 "desktop-file-plugin.vala"
		self->priv->_desktop_id = _tmp0_;
#line 43 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY]);
#line 2301 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_desktop_file_match_get_exec (SynapseDesktopFilePluginDesktopFileMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 44 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_exec;
#line 44 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 44 "desktop-file-plugin.vala"
	return result;
#line 2318 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_set_exec (SynapseDesktopFilePluginDesktopFileMatch* self,
                                                         const gchar* value)
{
	gchar* old_value;
#line 44 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 44 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_desktop_file_match_get_exec (self);
#line 44 "desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2332 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 44 "desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 44 "desktop-file-plugin.vala"
		_g_free0 (self->priv->_exec);
#line 44 "desktop-file-plugin.vala"
		self->priv->_exec = _tmp0_;
#line 44 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY]);
#line 2342 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_desktop_file_match_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginDesktopFileMatch * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SynapseDesktopFileInfo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SynapseDesktopFileInfo* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SynapseDesktopFileInfo* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	SynapseDesktopFileInfo* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	SynapseDesktopFileInfo* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gchar* _tmp18_ = NULL;
	SynapseDesktopFileInfo* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SynapseDesktopFileInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
#line 51 "desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class);
#line 51 "desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 51 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 53 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 53 "desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_filename (_tmp0_);
#line 53 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 53 "desktop-file-plugin.vala"
	synapse_application_match_set_filename ((SynapseApplicationMatch*) self, _tmp2_);
#line 54 "desktop-file-plugin.vala"
	_tmp3_ = self->priv->_desktop_info;
#line 54 "desktop-file-plugin.vala"
	_tmp4_ = synapse_desktop_file_info_get_name (_tmp3_);
#line 54 "desktop-file-plugin.vala"
	_tmp5_ = _tmp4_;
#line 54 "desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp5_);
#line 55 "desktop-file-plugin.vala"
	_tmp6_ = self->priv->_desktop_info;
#line 55 "desktop-file-plugin.vala"
	_tmp7_ = synapse_desktop_file_info_get_comment (_tmp6_);
#line 55 "desktop-file-plugin.vala"
	_tmp8_ = _tmp7_;
#line 55 "desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp8_);
#line 56 "desktop-file-plugin.vala"
	_tmp9_ = self->priv->_desktop_info;
#line 56 "desktop-file-plugin.vala"
	_tmp10_ = synapse_desktop_file_info_get_icon_name (_tmp9_);
#line 56 "desktop-file-plugin.vala"
	_tmp11_ = _tmp10_;
#line 56 "desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp11_);
#line 57 "desktop-file-plugin.vala"
	_tmp12_ = self->priv->_desktop_info;
#line 57 "desktop-file-plugin.vala"
	_tmp13_ = synapse_desktop_file_info_get_exec (_tmp12_);
#line 57 "desktop-file-plugin.vala"
	_tmp14_ = _tmp13_;
#line 57 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_exec (self, _tmp14_);
#line 58 "desktop-file-plugin.vala"
	_tmp15_ = self->priv->_desktop_info;
#line 58 "desktop-file-plugin.vala"
	_tmp16_ = synapse_desktop_file_info_get_needs_terminal (_tmp15_);
#line 58 "desktop-file-plugin.vala"
	_tmp17_ = _tmp16_;
#line 58 "desktop-file-plugin.vala"
	synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, _tmp17_);
#line 59 "desktop-file-plugin.vala"
	_tmp19_ = self->priv->_desktop_info;
#line 59 "desktop-file-plugin.vala"
	_tmp20_ = synapse_desktop_file_info_get_name_folded (_tmp19_);
#line 59 "desktop-file-plugin.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 59 "desktop-file-plugin.vala"
	_tmp18_ = _tmp21_;
#line 59 "desktop-file-plugin.vala"
	if (_tmp18_ == NULL) {
#line 2448 "desktop-file-plugin.c"
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
#line 59 "desktop-file-plugin.vala"
		_tmp22_ = synapse_match_get_title ((SynapseMatch*) self);
#line 59 "desktop-file-plugin.vala"
		_tmp23_ = _tmp22_;
#line 59 "desktop-file-plugin.vala"
		_tmp24_ = g_utf8_casefold (_tmp23_, (gssize) -1);
#line 59 "desktop-file-plugin.vala"
		_g_free0 (_tmp18_);
#line 59 "desktop-file-plugin.vala"
		_tmp18_ = _tmp24_;
#line 2462 "desktop-file-plugin.c"
	}
#line 59 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_title_folded (self, _tmp18_);
#line 60 "desktop-file-plugin.vala"
	_tmp25_ = self->priv->_title_folded;
#line 60 "desktop-file-plugin.vala"
	_tmp26_ = synapse_utils_remove_accents (_tmp25_);
#line 60 "desktop-file-plugin.vala"
	_tmp27_ = _tmp26_;
#line 60 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, _tmp27_);
#line 60 "desktop-file-plugin.vala"
	_g_free0 (_tmp27_);
#line 61 "desktop-file-plugin.vala"
	_tmp28_ = self->priv->_desktop_info;
#line 61 "desktop-file-plugin.vala"
	_tmp29_ = synapse_desktop_file_info_get_desktop_id (_tmp28_);
#line 61 "desktop-file-plugin.vala"
	_tmp30_ = _tmp29_;
#line 61 "desktop-file-plugin.vala"
	_tmp31_ = g_strconcat ("application://", _tmp30_, NULL);
#line 61 "desktop-file-plugin.vala"
	_tmp32_ = _tmp31_;
#line 61 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, _tmp32_);
#line 61 "desktop-file-plugin.vala"
	_g_free0 (_tmp32_);
#line 51 "desktop-file-plugin.vala"
	_g_free0 (_tmp18_);
#line 51 "desktop-file-plugin.vala"
	return obj;
#line 2494 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_class_init (SynapseDesktopFilePluginDesktopFileMatchClass * klass,
                                                           gpointer klass_data)
{
#line 38 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_desktop_file_match_parent_class = g_type_class_peek_parent (klass);
#line 38 "desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginDesktopFileMatch_private_offset);
#line 38 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_desktop_file_match_get_property;
#line 38 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_desktop_file_match_set_property;
#line 38 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_desktop_file_match_constructor;
#line 38 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_desktop_file_match_finalize;
#line 38 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY] = g_param_spec_string ("title-folded", "title-folded", "title-folded", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY] = g_param_spec_string ("title-unaccented", "title-unaccented", "title-unaccented", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY, synapse_desktop_file_plugin_desktop_file_match_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2523 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_instance_init (SynapseDesktopFilePluginDesktopFileMatch * self,
                                                              gpointer klass)
{
#line 38 "desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_desktop_file_match_get_instance_private (self);
#line 2532 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_desktop_file_match_finalize (GObject * obj)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
#line 38 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 40 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 41 "desktop-file-plugin.vala"
	_g_free0 (self->priv->_title_folded);
#line 42 "desktop-file-plugin.vala"
	_g_free0 (self->priv->_title_unaccented);
#line 43 "desktop-file-plugin.vala"
	_g_free0 (self->priv->_desktop_id);
#line 44 "desktop-file-plugin.vala"
	_g_free0 (self->priv->_exec);
#line 38 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_desktop_file_match_parent_class)->finalize (obj);
#line 2553 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginDesktopFileMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_desktop_file_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginDesktopFileMatch), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_desktop_file_match_instance_init, NULL };
	GType synapse_desktop_file_plugin_desktop_file_match_type_id;
	synapse_desktop_file_plugin_desktop_file_match_type_id = g_type_register_static (SYNAPSE_TYPE_APPLICATION_MATCH, "SynapseDesktopFilePluginDesktopFileMatch", &g_define_type_info, 0);
	SynapseDesktopFilePluginDesktopFileMatch_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_desktop_file_match_type_id, sizeof (SynapseDesktopFilePluginDesktopFileMatchPrivate));
	return synapse_desktop_file_plugin_desktop_file_match_type_id;
}

static GType
synapse_desktop_file_plugin_desktop_file_match_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_desktop_file_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_desktop_file_match_type_id__once)) {
		GType synapse_desktop_file_plugin_desktop_file_match_type_id;
		synapse_desktop_file_plugin_desktop_file_match_type_id = synapse_desktop_file_plugin_desktop_file_match_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_desktop_file_match_type_id__once, synapse_desktop_file_plugin_desktop_file_match_type_id);
	}
	return synapse_desktop_file_plugin_desktop_file_match_type_id__once;
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 38 "desktop-file-plugin.vala"
	switch (property_id) {
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_info (self));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_folded (self));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_title_unaccented (self));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_desktop_id (self));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_desktop_file_match_get_exec (self));
#line 38 "desktop-file-plugin.vala"
		break;
#line 2618 "desktop-file-plugin.c"
		default:
#line 38 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "desktop-file-plugin.vala"
		break;
#line 2624 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_desktop_file_match_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	SynapseDesktopFilePluginDesktopFileMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, SynapseDesktopFilePluginDesktopFileMatch);
#line 38 "desktop-file-plugin.vala"
	switch (property_id) {
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_INFO_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_info (self, g_value_get_object (value));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_FOLDED_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_title_folded (self, g_value_get_string (value));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_TITLE_UNACCENTED_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_title_unaccented (self, g_value_get_string (value));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_DESKTOP_ID_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_desktop_id (self, g_value_get_string (value));
#line 38 "desktop-file-plugin.vala"
		break;
#line 38 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_DESKTOP_FILE_MATCH_EXEC_PROPERTY:
#line 38 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_desktop_file_match_set_exec (self, g_value_get_string (value));
#line 38 "desktop-file-plugin.vala"
		break;
#line 2668 "desktop-file-plugin.c"
		default:
#line 38 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "desktop-file-plugin.vala"
		break;
#line 2674 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_with_action_get_instance_private (SynapseDesktopFilePluginOpenWithAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenWithAction_private_offset);
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_construct (GType object_type,
                                                        SynapseDesktopFileInfo* info)
{
	SynapseDesktopFilePluginOpenWithAction * self = NULL;
#line 225 "desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 227 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) g_object_new (object_type, "desktop-info", info, NULL);
#line 225 "desktop-file-plugin.vala"
	return self;
#line 2695 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginOpenWithAction*
synapse_desktop_file_plugin_open_with_action_new (SynapseDesktopFileInfo* info)
{
#line 225 "desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_open_with_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, info);
#line 2703 "desktop-file-plugin.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 248 "desktop-file-plugin.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2711 "desktop-file-plugin.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 248 "desktop-file-plugin.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 2719 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_real_do_execute (SynapseAction* base,
                                                              SynapseMatch* match,
                                                              SynapseMatch* target)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseUriMatch* uri_match = NULL;
	GFile* f = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
#line 237 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 237 "desktop-file-plugin.vala"
	g_return_if_fail (match != NULL);
#line 239 "desktop-file-plugin.vala"
	uri_match = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH) ? ((SynapseUriMatch*) match) : NULL;
#line 240 "desktop-file-plugin.vala"
	g_return_if_fail (uri_match != NULL);
#line 242 "desktop-file-plugin.vala"
	_tmp0_ = synapse_uri_match_get_uri (uri_match);
#line 242 "desktop-file-plugin.vala"
	_tmp1_ = _tmp0_;
#line 242 "desktop-file-plugin.vala"
	_tmp2_ = g_file_new_for_uri (_tmp1_);
#line 242 "desktop-file-plugin.vala"
	f = _tmp2_;
#line 2750 "desktop-file-plugin.c"
	{
		GDesktopAppInfo* app_info = NULL;
		SynapseDesktopFileInfo* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GDesktopAppInfo* _tmp6_;
		GList* files = NULL;
		GFile* _tmp7_;
		GdkDisplay* _tmp8_;
		GdkAppLaunchContext* _tmp9_;
		GdkAppLaunchContext* _tmp10_;
#line 245 "desktop-file-plugin.vala"
		_tmp3_ = self->priv->_desktop_info;
#line 245 "desktop-file-plugin.vala"
		_tmp4_ = synapse_desktop_file_info_get_filename (_tmp3_);
#line 245 "desktop-file-plugin.vala"
		_tmp5_ = _tmp4_;
#line 245 "desktop-file-plugin.vala"
		_tmp6_ = g_desktop_app_info_new_from_filename (_tmp5_);
#line 245 "desktop-file-plugin.vala"
		app_info = _tmp6_;
#line 246 "desktop-file-plugin.vala"
		files = NULL;
#line 247 "desktop-file-plugin.vala"
		_tmp7_ = _g_object_ref0 (f);
#line 247 "desktop-file-plugin.vala"
		files = g_list_prepend (files, _tmp7_);
#line 248 "desktop-file-plugin.vala"
		_tmp8_ = gdk_display_get_default ();
#line 248 "desktop-file-plugin.vala"
		_tmp9_ = gdk_display_get_app_launch_context (_tmp8_);
#line 248 "desktop-file-plugin.vala"
		_tmp10_ = _tmp9_;
#line 248 "desktop-file-plugin.vala"
		g_app_info_launch ((GAppInfo*) app_info, files, (GAppLaunchContext*) _tmp10_, &_inner_error0_);
#line 248 "desktop-file-plugin.vala"
		_g_object_unref0 (_tmp10_);
#line 248 "desktop-file-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 248 "desktop-file-plugin.vala"
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 248 "desktop-file-plugin.vala"
			_g_object_unref0 (app_info);
#line 2794 "desktop-file-plugin.c"
			goto __catch0_g_error;
		}
#line 243 "desktop-file-plugin.vala"
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
#line 243 "desktop-file-plugin.vala"
		_g_object_unref0 (app_info);
#line 2801 "desktop-file-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 243 "desktop-file-plugin.vala"
		err = _inner_error0_;
#line 243 "desktop-file-plugin.vala"
		_inner_error0_ = NULL;
#line 252 "desktop-file-plugin.vala"
		_tmp11_ = err;
#line 252 "desktop-file-plugin.vala"
		_tmp12_ = _tmp11_->message;
#line 252 "desktop-file-plugin.vala"
		g_warning ("desktop-file-plugin.vala:252: %s", _tmp12_);
#line 243 "desktop-file-plugin.vala"
		_g_error_free0 (err);
#line 2821 "desktop-file-plugin.c"
	}
	__finally0:
#line 243 "desktop-file-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 243 "desktop-file-plugin.vala"
		_g_object_unref0 (f);
#line 243 "desktop-file-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 243 "desktop-file-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 243 "desktop-file-plugin.vala"
		return;
#line 2834 "desktop-file-plugin.c"
	}
#line 237 "desktop-file-plugin.vala"
	_g_object_unref0 (f);
#line 2838 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_open_with_action_real_valid_for_match (SynapseAction* base,
                                                                   SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	gboolean result;
#line 256 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenWithAction*) base;
#line 256 "desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 258 "desktop-file-plugin.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH);
#line 258 "desktop-file-plugin.vala"
	return result;
#line 2855 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_with_action_get_desktop_info (SynapseDesktopFilePluginOpenWithAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 223 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 223 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 223 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 223 "desktop-file-plugin.vala"
	return result;
#line 2871 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_set_desktop_info (SynapseDesktopFilePluginOpenWithAction* self,
                                                               SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 223 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 223 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_with_action_get_desktop_info (self);
#line 223 "desktop-file-plugin.vala"
	if (old_value != value) {
#line 2885 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 223 "desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 223 "desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 223 "desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 223 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY]);
#line 2895 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_open_with_action_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginOpenWithAction * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SynapseDesktopFileInfo* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	SynapseDesktopFileInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 230 "desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class);
#line 230 "desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 230 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 232 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 232 "desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_name (_tmp0_);
#line 232 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 232 "desktop-file-plugin.vala"
	_tmp3_ = g_strdup_printf (_ ("Open with %s"), _tmp2_);
#line 232 "desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 232 "desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp4_);
#line 232 "desktop-file-plugin.vala"
	_g_free0 (_tmp4_);
#line 233 "desktop-file-plugin.vala"
	_tmp5_ = self->priv->_desktop_info;
#line 233 "desktop-file-plugin.vala"
	_tmp6_ = synapse_desktop_file_info_get_icon_name (_tmp5_);
#line 233 "desktop-file-plugin.vala"
	_tmp7_ = _tmp6_;
#line 233 "desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp7_);
#line 234 "desktop-file-plugin.vala"
	_tmp8_ = self->priv->_desktop_info;
#line 234 "desktop-file-plugin.vala"
	_tmp9_ = synapse_desktop_file_info_get_name (_tmp8_);
#line 234 "desktop-file-plugin.vala"
	_tmp10_ = _tmp9_;
#line 234 "desktop-file-plugin.vala"
	_tmp11_ = g_strdup_printf (_ ("Opens current selection using %s"), _tmp10_);
#line 234 "desktop-file-plugin.vala"
	_tmp12_ = _tmp11_;
#line 234 "desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp12_);
#line 234 "desktop-file-plugin.vala"
	_g_free0 (_tmp12_);
#line 230 "desktop-file-plugin.vala"
	return obj;
#line 2964 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_class_init (SynapseDesktopFilePluginOpenWithActionClass * klass,
                                                         gpointer klass_data)
{
#line 221 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_with_action_parent_class = g_type_class_peek_parent (klass);
#line 221 "desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenWithAction_private_offset);
#line 221 "desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_do_execute;
#line 221 "desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_desktop_file_plugin_open_with_action_real_valid_for_match;
#line 221 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_with_action_get_property;
#line 221 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_with_action_set_property;
#line 221 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_open_with_action_constructor;
#line 221 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_with_action_finalize;
#line 221 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_with_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2989 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_instance_init (SynapseDesktopFilePluginOpenWithAction * self,
                                                            gpointer klass)
{
#line 221 "desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_open_with_action_get_instance_private (self);
#line 2998 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_with_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenWithAction * self;
#line 221 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 223 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 221 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_with_action_parent_class)->finalize (obj);
#line 3011 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenWithActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_with_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenWithAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_with_action_instance_init, NULL };
	GType synapse_desktop_file_plugin_open_with_action_type_id;
	synapse_desktop_file_plugin_open_with_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseDesktopFilePluginOpenWithAction", &g_define_type_info, 0);
	SynapseDesktopFilePluginOpenWithAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_with_action_type_id, sizeof (SynapseDesktopFilePluginOpenWithActionPrivate));
	return synapse_desktop_file_plugin_open_with_action_type_id;
}

static GType
synapse_desktop_file_plugin_open_with_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_with_action_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_with_action_type_id__once)) {
		GType synapse_desktop_file_plugin_open_with_action_type_id;
		synapse_desktop_file_plugin_open_with_action_type_id = synapse_desktop_file_plugin_open_with_action_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_open_with_action_type_id__once, synapse_desktop_file_plugin_open_with_action_type_id);
	}
	return synapse_desktop_file_plugin_open_with_action_type_id__once;
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 221 "desktop-file-plugin.vala"
	switch (property_id) {
#line 221 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 221 "desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_open_with_action_get_desktop_info (self));
#line 221 "desktop-file-plugin.vala"
		break;
#line 3052 "desktop-file-plugin.c"
		default:
#line 221 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 221 "desktop-file-plugin.vala"
		break;
#line 3058 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_open_with_action_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenWithAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_WITH_ACTION, SynapseDesktopFilePluginOpenWithAction);
#line 221 "desktop-file-plugin.vala"
	switch (property_id) {
#line 221 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_WITH_ACTION_DESKTOP_INFO_PROPERTY:
#line 221 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_with_action_set_desktop_info (self, g_value_get_object (value));
#line 221 "desktop-file-plugin.vala"
		break;
#line 3078 "desktop-file-plugin.c"
		default:
#line 221 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 221 "desktop-file-plugin.vala"
		break;
#line 3084 "desktop-file-plugin.c"
	}
}

static inline gpointer
synapse_desktop_file_plugin_open_app_action_get_instance_private (SynapseDesktopFilePluginOpenAppAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFilePluginOpenAppAction_private_offset);
}

static SynapseDesktopFilePluginOpenAppAction*
synapse_desktop_file_plugin_open_app_action_construct (GType object_type,
                                                       SynapseDesktopFileInfo* info,
                                                       const gchar* action)
{
	SynapseDesktopFilePluginOpenAppAction * self = NULL;
#line 269 "desktop-file-plugin.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 269 "desktop-file-plugin.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 271 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) g_object_new (object_type, "desktop-info", info, "action", action, NULL);
#line 269 "desktop-file-plugin.vala"
	return self;
#line 3108 "desktop-file-plugin.c"
}

static SynapseDesktopFilePluginOpenAppAction*
synapse_desktop_file_plugin_open_app_action_new (SynapseDesktopFileInfo* info,
                                                 const gchar* action)
{
#line 269 "desktop-file-plugin.vala"
	return synapse_desktop_file_plugin_open_app_action_construct (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, info, action);
#line 3117 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_real_do_execute (SynapseAction* base,
                                                             SynapseMatch* match,
                                                             SynapseMatch* target)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkAppLaunchContext* _tmp3_;
	GdkAppLaunchContext* _tmp4_;
	SynapseRelevancyService* _tmp5_;
	SynapseRelevancyService* _tmp6_;
	GDesktopAppInfo* _tmp7_;
#line 283 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) base;
#line 283 "desktop-file-plugin.vala"
	g_return_if_fail (match != NULL);
#line 285 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->app_info;
#line 285 "desktop-file-plugin.vala"
	_tmp1_ = self->priv->_action;
#line 285 "desktop-file-plugin.vala"
	_tmp2_ = gdk_display_get_default ();
#line 285 "desktop-file-plugin.vala"
	_tmp3_ = gdk_display_get_app_launch_context (_tmp2_);
#line 285 "desktop-file-plugin.vala"
	_tmp4_ = _tmp3_;
#line 285 "desktop-file-plugin.vala"
	g_desktop_app_info_launch_action (_tmp0_, _tmp1_, (GAppLaunchContext*) _tmp4_);
#line 285 "desktop-file-plugin.vala"
	_g_object_unref0 (_tmp4_);
#line 286 "desktop-file-plugin.vala"
	_tmp5_ = synapse_relevancy_service_get_default ();
#line 286 "desktop-file-plugin.vala"
	_tmp6_ = _tmp5_;
#line 286 "desktop-file-plugin.vala"
	_tmp7_ = self->priv->app_info;
#line 286 "desktop-file-plugin.vala"
	synapse_relevancy_service_application_launched (_tmp6_, (GAppInfo*) _tmp7_);
#line 286 "desktop-file-plugin.vala"
	_g_object_unref0 (_tmp6_);
#line 3162 "desktop-file-plugin.c"
}

static gboolean
synapse_desktop_file_plugin_open_app_action_real_valid_for_match (SynapseAction* base,
                                                                  SynapseMatch* match)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	gboolean result;
#line 289 "desktop-file-plugin.vala"
	self = (SynapseDesktopFilePluginOpenAppAction*) base;
#line 289 "desktop-file-plugin.vala"
	g_return_val_if_fail (match != NULL, FALSE);
#line 291 "desktop-file-plugin.vala"
	result = SYNAPSE_DESKTOP_FILE_PLUGIN_IS_DESKTOP_FILE_MATCH (match);
#line 291 "desktop-file-plugin.vala"
	return result;
#line 3179 "desktop-file-plugin.c"
}

static SynapseDesktopFileInfo*
synapse_desktop_file_plugin_open_app_action_get_desktop_info (SynapseDesktopFilePluginOpenAppAction* self)
{
	SynapseDesktopFileInfo* result;
	SynapseDesktopFileInfo* _tmp0_;
#line 264 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 264 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 264 "desktop-file-plugin.vala"
	return result;
#line 3195 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_set_desktop_info (SynapseDesktopFilePluginOpenAppAction* self,
                                                              SynapseDesktopFileInfo* value)
{
	SynapseDesktopFileInfo* old_value;
#line 264 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 264 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_app_action_get_desktop_info (self);
#line 264 "desktop-file-plugin.vala"
	if (old_value != value) {
#line 3209 "desktop-file-plugin.c"
		SynapseDesktopFileInfo* _tmp0_;
#line 264 "desktop-file-plugin.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 264 "desktop-file-plugin.vala"
		_g_object_unref0 (self->priv->_desktop_info);
#line 264 "desktop-file-plugin.vala"
		self->priv->_desktop_info = _tmp0_;
#line 264 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY]);
#line 3219 "desktop-file-plugin.c"
	}
}

static const gchar*
synapse_desktop_file_plugin_open_app_action_get_action (SynapseDesktopFilePluginOpenAppAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 265 "desktop-file-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 265 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_action;
#line 265 "desktop-file-plugin.vala"
	result = _tmp0_;
#line 265 "desktop-file-plugin.vala"
	return result;
#line 3236 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_set_action (SynapseDesktopFilePluginOpenAppAction* self,
                                                        const gchar* value)
{
	gchar* old_value;
#line 265 "desktop-file-plugin.vala"
	g_return_if_fail (self != NULL);
#line 265 "desktop-file-plugin.vala"
	old_value = synapse_desktop_file_plugin_open_app_action_get_action (self);
#line 265 "desktop-file-plugin.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3250 "desktop-file-plugin.c"
		gchar* _tmp0_;
#line 265 "desktop-file-plugin.vala"
		_tmp0_ = g_strdup (value);
#line 265 "desktop-file-plugin.vala"
		_g_free0 (self->priv->_action);
#line 265 "desktop-file-plugin.vala"
		self->priv->_action = _tmp0_;
#line 265 "desktop-file-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY]);
#line 3260 "desktop-file-plugin.c"
	}
}

static GObject *
synapse_desktop_file_plugin_open_app_action_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePluginOpenAppAction * self;
	SynapseDesktopFileInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	gchar* display_action = NULL;
	GDesktopAppInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	SynapseDesktopFileInfo* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
#line 274 "desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_open_app_action_parent_class);
#line 274 "desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 274 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 276 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->_desktop_info;
#line 276 "desktop-file-plugin.vala"
	_tmp1_ = synapse_desktop_file_info_get_filename (_tmp0_);
#line 276 "desktop-file-plugin.vala"
	_tmp2_ = _tmp1_;
#line 276 "desktop-file-plugin.vala"
	_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
#line 276 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->app_info);
#line 276 "desktop-file-plugin.vala"
	self->priv->app_info = _tmp3_;
#line 277 "desktop-file-plugin.vala"
	_tmp4_ = self->priv->app_info;
#line 277 "desktop-file-plugin.vala"
	_tmp5_ = self->priv->_action;
#line 277 "desktop-file-plugin.vala"
	_tmp6_ = g_desktop_app_info_get_action_name (_tmp4_, _tmp5_);
#line 277 "desktop-file-plugin.vala"
	display_action = _tmp6_;
#line 278 "desktop-file-plugin.vala"
	_tmp7_ = display_action;
#line 278 "desktop-file-plugin.vala"
	synapse_match_set_title ((SynapseMatch*) self, _tmp7_);
#line 279 "desktop-file-plugin.vala"
	_tmp8_ = self->priv->_desktop_info;
#line 279 "desktop-file-plugin.vala"
	_tmp9_ = synapse_desktop_file_info_get_icon_name (_tmp8_);
#line 279 "desktop-file-plugin.vala"
	_tmp10_ = _tmp9_;
#line 279 "desktop-file-plugin.vala"
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp10_);
#line 280 "desktop-file-plugin.vala"
	_tmp11_ = display_action;
#line 280 "desktop-file-plugin.vala"
	_tmp12_ = g_strdup_printf (_ ("Launch action '%s'"), _tmp11_);
#line 280 "desktop-file-plugin.vala"
	_tmp13_ = _tmp12_;
#line 280 "desktop-file-plugin.vala"
	synapse_match_set_description ((SynapseMatch*) self, _tmp13_);
#line 280 "desktop-file-plugin.vala"
	_g_free0 (_tmp13_);
#line 274 "desktop-file-plugin.vala"
	_g_free0 (display_action);
#line 274 "desktop-file-plugin.vala"
	return obj;
#line 3339 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_class_init (SynapseDesktopFilePluginOpenAppActionClass * klass,
                                                        gpointer klass_data)
{
#line 262 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_open_app_action_parent_class = g_type_class_peek_parent (klass);
#line 262 "desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePluginOpenAppAction_private_offset);
#line 262 "desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->do_execute = (void (*) (SynapseAction*, SynapseMatch*, SynapseMatch*)) synapse_desktop_file_plugin_open_app_action_real_do_execute;
#line 262 "desktop-file-plugin.vala"
	((SynapseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseAction*, SynapseMatch*)) synapse_desktop_file_plugin_open_app_action_real_valid_for_match;
#line 262 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_open_app_action_get_property;
#line 262 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_open_app_action_set_property;
#line 262 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_open_app_action_constructor;
#line 262 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_open_app_action_finalize;
#line 262 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY] = g_param_spec_object ("desktop-info", "desktop-info", "desktop-info", SYNAPSE_TYPE_DESKTOP_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 262 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY, synapse_desktop_file_plugin_open_app_action_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY] = g_param_spec_string ("action", "action", "action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 3366 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_instance_init (SynapseDesktopFilePluginOpenAppAction * self,
                                                           gpointer klass)
{
#line 262 "desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_open_app_action_get_instance_private (self);
#line 3375 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_open_app_action_finalize (GObject * obj)
{
	SynapseDesktopFilePluginOpenAppAction * self;
#line 262 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 264 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->_desktop_info);
#line 265 "desktop-file-plugin.vala"
	_g_free0 (self->priv->_action);
#line 267 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->app_info);
#line 262 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_open_app_action_parent_class)->finalize (obj);
#line 3392 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_open_app_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginOpenAppActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_open_app_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePluginOpenAppAction), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_open_app_action_instance_init, NULL };
	GType synapse_desktop_file_plugin_open_app_action_type_id;
	synapse_desktop_file_plugin_open_app_action_type_id = g_type_register_static (SYNAPSE_TYPE_ACTION, "SynapseDesktopFilePluginOpenAppAction", &g_define_type_info, 0);
	SynapseDesktopFilePluginOpenAppAction_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_open_app_action_type_id, sizeof (SynapseDesktopFilePluginOpenAppActionPrivate));
	return synapse_desktop_file_plugin_open_app_action_type_id;
}

static GType
synapse_desktop_file_plugin_open_app_action_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_open_app_action_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_open_app_action_type_id__once)) {
		GType synapse_desktop_file_plugin_open_app_action_type_id;
		synapse_desktop_file_plugin_open_app_action_type_id = synapse_desktop_file_plugin_open_app_action_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_open_app_action_type_id__once, synapse_desktop_file_plugin_open_app_action_type_id);
	}
	return synapse_desktop_file_plugin_open_app_action_type_id__once;
}

static void
_vala_synapse_desktop_file_plugin_open_app_action_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 262 "desktop-file-plugin.vala"
	switch (property_id) {
#line 262 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY:
#line 262 "desktop-file-plugin.vala"
		g_value_set_object (value, synapse_desktop_file_plugin_open_app_action_get_desktop_info (self));
#line 262 "desktop-file-plugin.vala"
		break;
#line 262 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY:
#line 262 "desktop-file-plugin.vala"
		g_value_set_string (value, synapse_desktop_file_plugin_open_app_action_get_action (self));
#line 262 "desktop-file-plugin.vala"
		break;
#line 3439 "desktop-file-plugin.c"
		default:
#line 262 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 262 "desktop-file-plugin.vala"
		break;
#line 3445 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_open_app_action_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec)
{
	SynapseDesktopFilePluginOpenAppAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_OPEN_APP_ACTION, SynapseDesktopFilePluginOpenAppAction);
#line 262 "desktop-file-plugin.vala"
	switch (property_id) {
#line 262 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_DESKTOP_INFO_PROPERTY:
#line 262 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_app_action_set_desktop_info (self, g_value_get_object (value));
#line 262 "desktop-file-plugin.vala"
		break;
#line 262 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_OPEN_APP_ACTION_ACTION_PROPERTY:
#line 262 "desktop-file-plugin.vala"
		synapse_desktop_file_plugin_open_app_action_set_action (self, g_value_get_string (value));
#line 262 "desktop-file-plugin.vala"
		break;
#line 3471 "desktop-file-plugin.c"
		default:
#line 262 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 262 "desktop-file-plugin.vala"
		break;
#line 3477 "desktop-file-plugin.c"
	}
}

static void
_synapse_desktop_file_plugin___lambda5_ (SynapseDesktopFilePlugin* self)
{
#line 91 "desktop-file-plugin.vala"
	self->priv->loading_in_progress = TRUE;
#line 3486 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started (SynapseDesktopFileService* _sender,
                                                                                      gpointer self)
{
#line 90 "desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda5_ ((SynapseDesktopFilePlugin*) self);
#line 3495 "desktop-file-plugin.c"
}

static void
_synapse_desktop_file_plugin___lambda6_ (SynapseDesktopFilePlugin* self)
{
	GeeMap* _tmp0_;
	GeeList* _tmp1_;
#line 94 "desktop-file-plugin.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 94 "desktop-file-plugin.vala"
	gee_map_clear (_tmp0_);
#line 95 "desktop-file-plugin.vala"
	_tmp1_ = self->priv->desktop_files;
#line 95 "desktop-file-plugin.vala"
	gee_collection_clear ((GeeCollection*) _tmp1_);
#line 96 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 3513 "desktop-file-plugin.c"
}

static void
__synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done (SynapseDesktopFileService* _sender,
                                                                                   gpointer self)
{
#line 93 "desktop-file-plugin.vala"
	_synapse_desktop_file_plugin___lambda6_ ((SynapseDesktopFilePlugin*) self);
#line 3522 "desktop-file-plugin.c"
}

static GObject *
synapse_desktop_file_plugin_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFilePlugin * self;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp3_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* _tmp5_;
#line 83 "desktop-file-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class);
#line 83 "desktop-file-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 83 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 85 "desktop-file-plugin.vala"
	_tmp0_ = gee_array_list_new (SYNAPSE_DESKTOP_FILE_PLUGIN_TYPE_DESKTOP_FILE_MATCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 85 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 85 "desktop-file-plugin.vala"
	self->priv->desktop_files = (GeeList*) _tmp0_;
#line 86 "desktop-file-plugin.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 86 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 86 "desktop-file-plugin.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp1_;
#line 87 "desktop-file-plugin.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 87 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->actions_map);
#line 87 "desktop-file-plugin.vala"
	self->priv->actions_map = (GeeMap*) _tmp2_;
#line 89 "desktop-file-plugin.vala"
	_tmp3_ = synapse_desktop_file_service_get_default ();
#line 89 "desktop-file-plugin.vala"
	dfs = _tmp3_;
#line 90 "desktop-file-plugin.vala"
	_tmp4_ = dfs;
#line 90 "desktop-file-plugin.vala"
	g_signal_connect_object (_tmp4_, "reload-started", (GCallback) __synapse_desktop_file_plugin___lambda5__synapse_desktop_file_service_reload_started, self, 0);
#line 93 "desktop-file-plugin.vala"
	_tmp5_ = dfs;
#line 93 "desktop-file-plugin.vala"
	g_signal_connect_object (_tmp5_, "reload-done", (GCallback) __synapse_desktop_file_plugin___lambda6__synapse_desktop_file_service_reload_done, self, 0);
#line 99 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_load_all_desktop_files (self, NULL, NULL);
#line 83 "desktop-file-plugin.vala"
	_g_object_unref0 (dfs);
#line 83 "desktop-file-plugin.vala"
	return obj;
#line 3582 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_class_init (SynapseDesktopFilePluginClass * klass,
                                        gpointer klass_data)
{
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "desktop-file-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFilePlugin_private_offset);
#line 24 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_plugin_get_property;
#line 24 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_plugin_set_property;
#line 24 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_plugin_constructor;
#line 24 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_plugin_finalize;
#line 24 "desktop-file-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY, synapse_desktop_file_plugin_properties[SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_signals[SYNAPSE_DESKTOP_FILE_PLUGIN_LOAD_COMPLETE_SIGNAL] = g_signal_new ("load-complete", SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 78 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_register_plugin ();
#line 3607 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                                gpointer iface_data)
{
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "desktop-file-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_activate;
#line 24 "desktop-file-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_desktop_file_plugin_real_deactivate;
#line 24 "desktop-file-plugin.vala"
	iface->get_enabled = synapse_desktop_file_plugin_real_get_enabled;
#line 24 "desktop-file-plugin.vala"
	iface->set_enabled = synapse_desktop_file_plugin_real_set_enabled;
#line 3624 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                  gpointer iface_data)
{
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "desktop-file-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_desktop_file_plugin_real_handles_query;
#line 24 "desktop-file-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_desktop_file_plugin_real_search;
#line 24 "desktop-file-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_desktop_file_plugin_search_finish;
#line 3639 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                                    gpointer iface_data)
{
#line 24 "desktop-file-plugin.vala"
	synapse_desktop_file_plugin_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "desktop-file-plugin.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_desktop_file_plugin_real_find_for_match;
#line 3650 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_instance_init (SynapseDesktopFilePlugin * self,
                                           gpointer klass)
{
#line 24 "desktop-file-plugin.vala"
	self->priv = synapse_desktop_file_plugin_get_instance_private (self);
#line 26 "desktop-file-plugin.vala"
	self->priv->_enabled = TRUE;
#line 103 "desktop-file-plugin.vala"
	self->priv->loading_in_progress = FALSE;
#line 3663 "desktop-file-plugin.c"
}

static void
synapse_desktop_file_plugin_finalize (GObject * obj)
{
	SynapseDesktopFilePlugin * self;
#line 24 "desktop-file-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 81 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->desktop_files);
#line 295 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 296 "desktop-file-plugin.vala"
	_g_object_unref0 (self->priv->actions_map);
#line 24 "desktop-file-plugin.vala"
	G_OBJECT_CLASS (synapse_desktop_file_plugin_parent_class)->finalize (obj);
#line 3680 "desktop-file-plugin.c"
}

static GType
synapse_desktop_file_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFilePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFilePlugin), 0, (GInstanceInitFunc) synapse_desktop_file_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_desktop_file_plugin_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_desktop_file_plugin_type_id;
	synapse_desktop_file_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFilePlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	g_type_add_interface_static (synapse_desktop_file_plugin_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseDesktopFilePlugin_private_offset = g_type_add_instance_private (synapse_desktop_file_plugin_type_id, sizeof (SynapseDesktopFilePluginPrivate));
	return synapse_desktop_file_plugin_type_id;
}

GType
synapse_desktop_file_plugin_get_type (void)
{
	static volatile gsize synapse_desktop_file_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_plugin_type_id__once)) {
		GType synapse_desktop_file_plugin_type_id;
		synapse_desktop_file_plugin_type_id = synapse_desktop_file_plugin_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_plugin_type_id__once, synapse_desktop_file_plugin_type_id);
	}
	return synapse_desktop_file_plugin_type_id__once;
}

static void
_vala_synapse_desktop_file_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "desktop-file-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "desktop-file-plugin.vala"
		break;
#line 3727 "desktop-file-plugin.c"
		default:
#line 24 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "desktop-file-plugin.vala"
		break;
#line 3733 "desktop-file-plugin.c"
	}
}

static void
_vala_synapse_desktop_file_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	SynapseDesktopFilePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_PLUGIN, SynapseDesktopFilePlugin);
#line 24 "desktop-file-plugin.vala"
	switch (property_id) {
#line 24 "desktop-file-plugin.vala"
		case SYNAPSE_DESKTOP_FILE_PLUGIN_ENABLED_PROPERTY:
#line 24 "desktop-file-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "desktop-file-plugin.vala"
		break;
#line 3753 "desktop-file-plugin.c"
		default:
#line 24 "desktop-file-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "desktop-file-plugin.vala"
		break;
#line 3759 "desktop-file-plugin.c"
	}
}

