const char metrics_tarantool_network_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update_network_metrics()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local box_stat_net = box.stat.net()\n"
"\n"
"    collectors_list.net_sent_total =\n"
"        utils.set_counter('net_sent_total', 'Totally sent in bytes',\n"
"            box_stat_net.SENT.total, nil, nil, {default = true})\n"
"    collectors_list.net_received_total =\n"
"        utils.set_counter('net_received_total', 'Totally received in bytes',\n"
"            box_stat_net.RECEIVED.total, nil, nil, {default = true})\n"
"\n"
"    -- https://github.com/tarantool/doc/issues/760\n"
"\n"
"    -- before tnt version 2.2.0\n"
"    if box_stat_net.CONNECTIONS ~= nil and type(box_stat_net.CONNECTIONS) ~= 'number' then\n"
"        collectors_list.net_connections_total =\n"
"            utils.set_counter('net_connections_total', 'Connections total amount',\n"
"                box_stat_net.CONNECTIONS.total, nil, nil, {default = true})\n"
"        collectors_list.net_connections_current =\n"
"            utils.set_gauge('net_connections_current', 'Current connections amount',\n"
"                box_stat_net.CONNECTIONS.current, nil, nil, {default = true})\n"
"    elseif box_stat_net.CONNECTIONS ~= nil then\n"
"        collectors_list.net_connections_current =\n"
"            utils.set_gauge('net_connections_current', 'Current connections amount',\n"
"                box_stat_net.CONNECTIONS, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    if box_stat_net.REQUESTS ~= nil then\n"
"        collectors_list.net_requests_total =\n"
"            utils.set_counter('net_requests_total', 'Requests total amount',\n"
"                box_stat_net.REQUESTS.total, nil, nil, {default = true})\n"
"        collectors_list.net_requests_current =\n"
"            utils.set_gauge('net_requests_current', 'Pending requests',\n"
"                box_stat_net.REQUESTS.current, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    if box_stat_net.REQUESTS_IN_PROGRESS ~= nil then\n"
"        collectors_list.net_requests_in_progress_total =\n"
"            utils.set_counter('net_requests_in_progress_total', 'Requests in progress total amount',\n"
"            box_stat_net.REQUESTS_IN_PROGRESS.total, nil, nil, {default = true})\n"
"        collectors_list.net_requests_in_progress_current =\n"
"            utils.set_gauge('net_requests_in_progress_current',\n"
"            'Count of requests currently being processed in the tx thread',\n"
"            box_stat_net.REQUESTS_IN_PROGRESS.current, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    if box_stat_net.REQUESTS_IN_STREAM_QUEUE ~= nil then\n"
"        collectors_list.net_requests_in_stream_total =\n"
"            utils.set_counter('net_requests_in_stream_queue_total',\n"
"            'Total count of requests, which was placed in queues of streams',\n"
"            box_stat_net.REQUESTS_IN_STREAM_QUEUE.total, nil, nil, {default = true})\n"
"        collectors_list.net_requests_in_stream_current =\n"
"            utils.set_gauge('net_requests_in_stream_queue_current',\n"
"            'count of requests currently waiting in queues of streams',\n"
"            box_stat_net.REQUESTS_IN_STREAM_QUEUE.current, nil, nil, {default = true})\n"
"    end\n"
"\n"
"    if box.stat.net.thread ~= nil then\n"
"        local box_stat_net_per_thread = box.stat.net.thread()\n"
"\n"
"        for k, per_thread_mertics in pairs(box_stat_net_per_thread) do\n"
"            local index = tostring(k)\n"
"\n"
"            collectors_list.net_per_thread_sent_total =\n"
"                utils.set_counter('net_per_thread_sent_total', 'Totally sent in bytes',\n"
"                    per_thread_mertics.SENT.total, {thread = index}, nil, {default = true})\n"
"\n"
"            collectors_list.net_per_thread_received_total =\n"
"                utils.set_counter('net_per_thread_received_total', 'Totally received in bytes',\n"
"                    per_thread_mertics.RECEIVED.total, {thread = index}, nil, {default = true})\n"
"\n"
"            if per_thread_mertics.CONNECTIONS ~= nil and type(per_thread_mertics.CONNECTIONS) ~= 'number' then\n"
"                collectors_list.net_per_thread_connections_total =\n"
"                    utils.set_counter('net_per_thread_connections_total', 'Connections total amount',\n"
"                        per_thread_mertics.CONNECTIONS.total, {thread = index}, nil, {default = true})\n"
"\n"
"                collectors_list.net_per_thread_connections_current =\n"
"                    utils.set_gauge('net_per_thread_connections_current', 'Current connections amount',\n"
"                        per_thread_mertics.CONNECTIONS.current, {thread = index}, nil, {default = true})\n"
"\n"
"            elseif per_thread_mertics.CONNECTIONS ~= nil then\n"
"                collectors_list.net_per_thread_connections_current =\n"
"                    utils.set_gauge('net_per_thread_connections_current', 'Current connections amount',\n"
"                        per_thread_mertics.CONNECTIONS, {thread = index}, nil, {default = true})\n"
"            end\n"
"\n"
"            if per_thread_mertics.REQUESTS ~= nil then\n"
"                collectors_list.net_per_thread_requests_total =\n"
"                    utils.set_counter('net_per_thread_requests_total', 'Requests total amount',\n"
"                        per_thread_mertics.REQUESTS.total, {thread = index}, nil, {default = true})\n"
"\n"
"                collectors_list.net_per_thread_requests_current =\n"
"                    utils.set_gauge('net_per_thread_requests_current', 'Pending requests',\n"
"                        per_thread_mertics.REQUESTS.current, {thread = index}, nil, {default = true})\n"
"            end\n"
"\n"
"            if per_thread_mertics.REQUESTS_IN_PROGRESS ~= nil then\n"
"                collectors_list.net_per_thread_requests_in_progress_total =\n"
"                    utils.set_counter('net_per_thread_requests_in_progress_total', 'Requests in progress total amount',\n"
"                        per_thread_mertics.REQUESTS_IN_PROGRESS.total, {thread = index}, nil, {default = true})\n"
"\n"
"                collectors_list.net_per_thread_requests_in_progress_current =\n"
"                    utils.set_gauge('net_per_thread_requests_in_progress_current',\n"
"                        'Count of requests currently being processed in the tx thread',\n"
"                        per_thread_mertics.REQUESTS_IN_PROGRESS.current, {thread = index}, nil, {default = true})\n"
"            end\n"
"\n"
"            if per_thread_mertics.REQUESTS_IN_STREAM_QUEUE ~= nil then\n"
"                collectors_list.net_per_thread_requests_in_stream_queue_total =\n"
"                    utils.set_counter('net_per_thread_requests_in_stream_queue_total',\n"
"                        'Total count of requests, which was placed in queues of streams',\n"
"                        per_thread_mertics.REQUESTS_IN_STREAM_QUEUE.total, {thread = index}, nil, {default = true})\n"
"\n"
"                collectors_list.net_per_thread_requests_in_stream_queue_current =\n"
"                    utils.set_gauge('net_per_thread_requests_in_stream_queue_current',\n"
"                        'Count of requests currently waiting in queues of streams',\n"
"                        per_thread_mertics.REQUESTS_IN_STREAM_QUEUE.current, {thread = index}, nil, {default = true})\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"\n"
"return {\n"
"    update = update_network_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
