/**
 * This file is generated by dconfig2cpp.
 * Command line arguments: /usr/lib/dtk6/DCore/bin/dconfig2cpp -o /build/treeland/src/treeland/build/src/outputconfig.hpp -c OutputConfig /build/treeland/src/treeland/misc/dconfig/org.deepin.dde.treeland.output.json
 * Generation time: 2026-01-29T19:55:18
 * JSON file version: 1.0
 *
 * WARNING: DO NOT MODIFY THIS FILE MANUALLY.
 * If you need to change the content, please modify the dconfig2cpp tool.
 */

#ifndef OUTPUTCONFIG_H
#define OUTPUTCONFIG_H

#include <QThread>
#include <QVariant>
#include <QPointer>
#include <QDebug>
#include <QAtomicPointer>
#include <QAtomicInteger>
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <QProperty>
#endif
#include <DSGApplication>
#include <DConfig>

class OutputConfig : public QObject {
    Q_OBJECT

    Q_PROPERTY(double brightness READ brightness WRITE setBrightness NOTIFY brightnessChanged RESET resetBrightness)
    Q_PROPERTY(qlonglong colorTemperature READ colorTemperature WRITE setColorTemperature NOTIFY colorTemperatureChanged RESET resetColorTemperature)
    Q_CLASSINFO("DConfigKeyList", "brightness;colorTemperature")
    Q_CLASSINFO("DConfigFileName", "org.deepin.dde.treeland.output")
    Q_CLASSINFO("DConfigFileVersion", "1.0")

public:
    explicit OutputConfig(QThread *thread, DTK_CORE_NAMESPACE::DConfigBackend *backend,
                        const QString &name, const QString &appId, const QString &subpath,
                        bool isGeneric, QObject *parent)
                : QObject(nullptr) {
        if (!thread->isRunning()) {
            qWarning() << QLatin1String("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QPointer<QObject> watcher(parent);
        QMetaObject::invokeMethod(worker, [=, this]() {
            DTK_CORE_NAMESPACE::DConfig *config = nullptr;
            if (isGeneric) {
                if (backend) {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(backend, name, subpath, nullptr);
                } else {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(name, subpath, nullptr);
                }
            } else {
                if (backend) {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, appId, name, subpath, nullptr);
                    }
                } else {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(appId, name, subpath, nullptr);
                    }
                }
            }
            if (!config) {
                qWarning() << QLatin1String("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initializeInConfigThread(config);
            if (watcher != parent) {
                // delete this if watcher is changed to nullptr.
                deleteLater();
            } else if (!this->parent() && parent) {
                // !parent() means that parent is not changed.
                this->setParent(watcher);
            }
            worker->deleteLater();
        });
    }
    static OutputConfig* create(const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, nullptr, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064\u002e\u006f\u0075\u0074\u0070\u0075\u0074"), appId, subpath, false, parent); }
    static OutputConfig* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, backend, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064\u002e\u006f\u0075\u0074\u0070\u0075\u0074"), appId, subpath, false, parent); }
    static OutputConfig* createByName(const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, nullptr, name, appId, subpath, false, parent); }
    static OutputConfig* createByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, backend, name, appId, subpath, false, parent); }
    static OutputConfig* createGeneric(const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, nullptr, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064\u002e\u006f\u0075\u0074\u0070\u0075\u0074"), {}, subpath, true, parent); }
    static OutputConfig* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, backend, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064\u002e\u006f\u0075\u0074\u0070\u0075\u0074"), {}, subpath, true, parent); }
    static OutputConfig* createGenericByName(const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, nullptr, name, {}, subpath, true, parent); }
    static OutputConfig* createGenericByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new OutputConfig(thread, backend, name, {}, subpath, true, parent); }
    ~OutputConfig() {
        if (m_config.loadRelaxed()) {
            m_config.loadRelaxed()->deleteLater();
            m_config.storeRelaxed(nullptr);
        }
    }

    Q_INVOKABLE DTK_CORE_NAMESPACE::DConfig *config() const {
        return m_config.loadRelaxed();
    }

    Q_INVOKABLE bool isInitializeSucceed() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Succeed);
    }

    Q_INVOKABLE bool isInitializeFailed() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Failed);
    }

    Q_INVOKABLE bool isInitializing() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Invalid);
    }

    Q_INVOKABLE QStringList keyList() const {
        return { QStringLiteral("brightness"),
                 QStringLiteral("colorTemperature")};
    }

    Q_INVOKABLE bool isDefaultValue(const QString &key) const {
        if (key == QStringLiteral("brightness"))
            return brightnessIsDefaultValue();
        if (key == QStringLiteral("colorTemperature"))
            return colorTemperatureIsDefaultValue();
        return false;
    }

    double brightness() const {
        return p_brightness;
    }
    void setBrightness(const double &value) {
        auto oldValue = p_brightness;
        p_brightness = value;
        markPropertySet(0);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("brightness"), value);
            });
        }
        if (p_brightness != oldValue) {
            Q_EMIT brightnessChanged();
            Q_EMIT valueChanged(QStringLiteral("brightness"), value);
        }
    }
    void resetBrightness() {
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this]() {
                m_config.loadRelaxed()->reset(QStringLiteral("brightness"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<double> bindableBrightness() {
        return QBindable<double>(this, "brightness");
    }
#endif
    Q_INVOKABLE bool brightnessIsDefaultValue() const {
        return !testPropertySet(0);
    }
    qlonglong colorTemperature() const {
        return p_colorTemperature;
    }
    void setColorTemperature(const qlonglong &value) {
        auto oldValue = p_colorTemperature;
        p_colorTemperature = value;
        markPropertySet(1);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("colorTemperature"), value);
            });
        }
        if (p_colorTemperature != oldValue) {
            Q_EMIT colorTemperatureChanged();
            Q_EMIT valueChanged(QStringLiteral("colorTemperature"), value);
        }
    }
    void resetColorTemperature() {
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this]() {
                m_config.loadRelaxed()->reset(QStringLiteral("colorTemperature"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<qlonglong> bindableColorTemperature() {
        return QBindable<qlonglong>(this, "colorTemperature");
    }
#endif
    Q_INVOKABLE bool colorTemperatureIsDefaultValue() const {
        return !testPropertySet(1);
    }
Q_SIGNALS:
    void configInitializeFailed(DTK_CORE_NAMESPACE::DConfig *config);
    void configInitializeSucceed(DTK_CORE_NAMESPACE::DConfig *config);
    void valueChanged(const QString &key, const QVariant &value);

    void brightnessChanged();
    void colorTemperatureChanged();
private:
    void initializeInConfigThread(DTK_CORE_NAMESPACE::DConfig *config) {
        Q_ASSERT(!m_config.loadRelaxed());
        m_config.storeRelaxed(config);
        if (!config->isValid()) {
           m_status.storeRelaxed(static_cast<int>(Status::Failed));
           Q_EMIT configInitializeFailed(config);
           return;
        }

        if (testPropertySet(0)) {
            config->setValue(QStringLiteral("brightness"), QVariant::fromValue(p_brightness));
        } else {
            updateValue(QStringLiteral("brightness"), QVariant::fromValue(p_brightness));
        }
        if (testPropertySet(1)) {
            config->setValue(QStringLiteral("colorTemperature"), QVariant::fromValue(p_colorTemperature));
        } else {
            updateValue(QStringLiteral("colorTemperature"), QVariant::fromValue(p_colorTemperature));
        }

        if (!m_config.loadRelaxed())
            return;
        connect(config, &DTK_CORE_NAMESPACE::DConfig::valueChanged, this, [this](const QString &key) {
            updateValue(key);
        }, Qt::DirectConnection);

        m_status.storeRelaxed(static_cast<int>(Status::Succeed));
        Q_EMIT configInitializeSucceed(config);
    }
    void updateValue(const QString &key, const QVariant &fallback = QVariant()) {
        if (!m_config.loadRelaxed())
            return;
        Q_ASSERT(QThread::currentThread() == m_config.loadRelaxed()->thread());
        const QVariant &value = m_config.loadRelaxed()->value(key, fallback);
        if (key == QStringLiteral("brightness")) {
            markPropertySet(0, !m_config.loadRelaxed()->isDefaultValue(key));
            auto newValue = qvariant_cast<double>(value);
            QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                Q_ASSERT(QThread::currentThread() == this->thread());
                if (p_brightness != newValue) {
                    p_brightness = newValue;
                    Q_EMIT brightnessChanged();
                    Q_EMIT valueChanged(key, value);
                }
            });
            return;
        }
        if (key == QStringLiteral("colorTemperature")) {
            markPropertySet(1, !m_config.loadRelaxed()->isDefaultValue(key));
            auto newValue = qvariant_cast<qlonglong>(value);
            QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                Q_ASSERT(QThread::currentThread() == this->thread());
                if (p_colorTemperature != newValue) {
                    p_colorTemperature = newValue;
                    Q_EMIT colorTemperatureChanged();
                    Q_EMIT valueChanged(key, value);
                }
            });
            return;
        }
    }
    inline void markPropertySet(const int index, bool on = true) {
        if (index < 32) {
            if (on)
                m_propertySetStatus0.fetchAndOrOrdered(1 << (index - 0));
            else
                m_propertySetStatus0.fetchAndAndOrdered(~(1 << (index - 0)));
            return;
        }
        Q_UNREACHABLE();
    }
    inline bool testPropertySet(const int index) const {
        if (index < 32) {
            return (m_propertySetStatus0.loadRelaxed() & (1 << (index - 0)));
        }
        Q_UNREACHABLE();
    }

    QAtomicPointer<DTK_CORE_NAMESPACE::DConfig> m_config = nullptr;

public:
    enum class Status {
        Invalid = 0,
        Succeed = 1,
        Failed = 2
    };
private:
    QAtomicInteger<int> m_status = static_cast<int>(Status::Invalid);

    double p_brightness { 1 };
    qlonglong p_colorTemperature { 6600 };
    QAtomicInteger<quint32> m_propertySetStatus0 = 0;
};

#endif // OUTPUTCONFIG_H
