/**
 * This file is generated by dconfig2cpp.
 * Command line arguments: /usr/lib/dtk6/DCore/bin/dconfig2cpp -o /build/treeland/src/treeland/build/src/treelandconfig.hpp -c TreelandConfig /build/treeland/src/treeland/misc/dconfig/org.deepin.dde.treeland.json
 * Generation time: 2026-01-29T19:55:18
 * JSON file version: 1.0
 *
 * WARNING: DO NOT MODIFY THIS FILE MANUALLY.
 * If you need to change the content, please modify the dconfig2cpp tool.
 */

#ifndef TREELANDCONFIG_H
#define TREELANDCONFIG_H

#include <QThread>
#include <QVariant>
#include <QPointer>
#include <QDebug>
#include <QAtomicPointer>
#include <QAtomicInteger>
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <QProperty>
#endif
#include <DSGApplication>
#include <DConfig>

class TreelandConfig : public QObject {
    Q_OBJECT

    Q_PROPERTY(bool enablePrelaunchSplash READ enablePrelaunchSplash WRITE setEnablePrelaunchSplash NOTIFY enablePrelaunchSplashChanged RESET resetEnablePrelaunchSplash)
    Q_PROPERTY(bool forceSoftwareCursor READ forceSoftwareCursor WRITE setForceSoftwareCursor NOTIFY forceSoftwareCursorChanged RESET resetForceSoftwareCursor)
    Q_PROPERTY(qlonglong prelaunchSplashTimeoutMs READ prelaunchSplashTimeoutMs WRITE setPrelaunchSplashTimeoutMs NOTIFY prelaunchSplashTimeoutMsChanged RESET resetPrelaunchSplashTimeoutMs)
    Q_CLASSINFO("DConfigKeyList", "enablePrelaunchSplash;forceSoftwareCursor;prelaunchSplashTimeoutMs")
    Q_CLASSINFO("DConfigFileName", "org.deepin.dde.treeland")
    Q_CLASSINFO("DConfigFileVersion", "1.0")

public:
    explicit TreelandConfig(QThread *thread, DTK_CORE_NAMESPACE::DConfigBackend *backend,
                        const QString &name, const QString &appId, const QString &subpath,
                        bool isGeneric, QObject *parent)
                : QObject(nullptr) {
        if (!thread->isRunning()) {
            qWarning() << QLatin1String("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QPointer<QObject> watcher(parent);
        QMetaObject::invokeMethod(worker, [=, this]() {
            DTK_CORE_NAMESPACE::DConfig *config = nullptr;
            if (isGeneric) {
                if (backend) {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(backend, name, subpath, nullptr);
                } else {
                    config = DTK_CORE_NAMESPACE::DConfig::createGeneric(name, subpath, nullptr);
                }
            } else {
                if (backend) {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(backend, appId, name, subpath, nullptr);
                    }
                } else {
                    if (appId.isNull()) {
                        config = DTK_CORE_NAMESPACE::DConfig::create(DTK_CORE_NAMESPACE::DSGApplication::id(),
                                                                     name, subpath, nullptr);
                    } else {
                        config = DTK_CORE_NAMESPACE::DConfig::create(appId, name, subpath, nullptr);
                    }
                }
            }
            if (!config) {
                qWarning() << QLatin1String("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initializeInConfigThread(config);
            if (watcher != parent) {
                // delete this if watcher is changed to nullptr.
                deleteLater();
            } else if (!this->parent() && parent) {
                // !parent() means that parent is not changed.
                this->setParent(watcher);
            }
            worker->deleteLater();
        });
    }
    static TreelandConfig* create(const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, nullptr, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064"), appId, subpath, false, parent); }
    static TreelandConfig* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, backend, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064"), appId, subpath, false, parent); }
    static TreelandConfig* createByName(const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, nullptr, name, appId, subpath, false, parent); }
    static TreelandConfig* createByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &appId = {}, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, backend, name, appId, subpath, false, parent); }
    static TreelandConfig* createGeneric(const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, nullptr, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064"), {}, subpath, true, parent); }
    static TreelandConfig* create(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, backend, QStringLiteral(u"\u006f\u0072\u0067\u002e\u0064\u0065\u0065\u0070\u0069\u006e\u002e\u0064\u0064\u0065\u002e\u0074\u0072\u0065\u0065\u006c\u0061\u006e\u0064"), {}, subpath, true, parent); }
    static TreelandConfig* createGenericByName(const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, nullptr, name, {}, subpath, true, parent); }
    static TreelandConfig* createGenericByName(DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &subpath = {}, QObject *parent = nullptr, QThread *thread = DTK_CORE_NAMESPACE::DConfig::globalThread())
    { return new TreelandConfig(thread, backend, name, {}, subpath, true, parent); }
    ~TreelandConfig() {
        if (m_config.loadRelaxed()) {
            m_config.loadRelaxed()->deleteLater();
            m_config.storeRelaxed(nullptr);
        }
    }

    Q_INVOKABLE DTK_CORE_NAMESPACE::DConfig *config() const {
        return m_config.loadRelaxed();
    }

    Q_INVOKABLE bool isInitializeSucceed() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Succeed);
    }

    Q_INVOKABLE bool isInitializeFailed() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Failed);
    }

    Q_INVOKABLE bool isInitializing() const {
        return m_status.loadRelaxed() == static_cast<int>(Status::Invalid);
    }

    Q_INVOKABLE QStringList keyList() const {
        return { QStringLiteral("enablePrelaunchSplash"),
                 QStringLiteral("forceSoftwareCursor"),
                 QStringLiteral("prelaunchSplashTimeoutMs")};
    }

    Q_INVOKABLE bool isDefaultValue(const QString &key) const {
        if (key == QStringLiteral("enablePrelaunchSplash"))
            return enablePrelaunchSplashIsDefaultValue();
        if (key == QStringLiteral("forceSoftwareCursor"))
            return forceSoftwareCursorIsDefaultValue();
        if (key == QStringLiteral("prelaunchSplashTimeoutMs"))
            return prelaunchSplashTimeoutMsIsDefaultValue();
        return false;
    }

    bool enablePrelaunchSplash() const {
        return p_enablePrelaunchSplash;
    }
    void setEnablePrelaunchSplash(const bool &value) {
        auto oldValue = p_enablePrelaunchSplash;
        p_enablePrelaunchSplash = value;
        markPropertySet(0);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("enablePrelaunchSplash"), value);
            });
        }
        if (p_enablePrelaunchSplash != oldValue) {
            Q_EMIT enablePrelaunchSplashChanged();
            Q_EMIT valueChanged(QStringLiteral("enablePrelaunchSplash"), value);
        }
    }
    void resetEnablePrelaunchSplash() {
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this]() {
                m_config.loadRelaxed()->reset(QStringLiteral("enablePrelaunchSplash"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<bool> bindableEnablePrelaunchSplash() {
        return QBindable<bool>(this, "enablePrelaunchSplash");
    }
#endif
    Q_INVOKABLE bool enablePrelaunchSplashIsDefaultValue() const {
        return !testPropertySet(0);
    }
    bool forceSoftwareCursor() const {
        return p_forceSoftwareCursor;
    }
    void setForceSoftwareCursor(const bool &value) {
        auto oldValue = p_forceSoftwareCursor;
        p_forceSoftwareCursor = value;
        markPropertySet(1);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("forceSoftwareCursor"), value);
            });
        }
        if (p_forceSoftwareCursor != oldValue) {
            Q_EMIT forceSoftwareCursorChanged();
            Q_EMIT valueChanged(QStringLiteral("forceSoftwareCursor"), value);
        }
    }
    void resetForceSoftwareCursor() {
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this]() {
                m_config.loadRelaxed()->reset(QStringLiteral("forceSoftwareCursor"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<bool> bindableForceSoftwareCursor() {
        return QBindable<bool>(this, "forceSoftwareCursor");
    }
#endif
    Q_INVOKABLE bool forceSoftwareCursorIsDefaultValue() const {
        return !testPropertySet(1);
    }
    qlonglong prelaunchSplashTimeoutMs() const {
        return p_prelaunchSplashTimeoutMs;
    }
    void setPrelaunchSplashTimeoutMs(const qlonglong &value) {
        auto oldValue = p_prelaunchSplashTimeoutMs;
        p_prelaunchSplashTimeoutMs = value;
        markPropertySet(2);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("prelaunchSplashTimeoutMs"), value);
            });
        }
        if (p_prelaunchSplashTimeoutMs != oldValue) {
            Q_EMIT prelaunchSplashTimeoutMsChanged();
            Q_EMIT valueChanged(QStringLiteral("prelaunchSplashTimeoutMs"), value);
        }
    }
    void resetPrelaunchSplashTimeoutMs() {
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this]() {
                m_config.loadRelaxed()->reset(QStringLiteral("prelaunchSplashTimeoutMs"));
            });
        }
    }
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
    QBindable<qlonglong> bindablePrelaunchSplashTimeoutMs() {
        return QBindable<qlonglong>(this, "prelaunchSplashTimeoutMs");
    }
#endif
    Q_INVOKABLE bool prelaunchSplashTimeoutMsIsDefaultValue() const {
        return !testPropertySet(2);
    }
Q_SIGNALS:
    void configInitializeFailed(DTK_CORE_NAMESPACE::DConfig *config);
    void configInitializeSucceed(DTK_CORE_NAMESPACE::DConfig *config);
    void valueChanged(const QString &key, const QVariant &value);

    void enablePrelaunchSplashChanged();
    void forceSoftwareCursorChanged();
    void prelaunchSplashTimeoutMsChanged();
private:
    void initializeInConfigThread(DTK_CORE_NAMESPACE::DConfig *config) {
        Q_ASSERT(!m_config.loadRelaxed());
        m_config.storeRelaxed(config);
        if (!config->isValid()) {
           m_status.storeRelaxed(static_cast<int>(Status::Failed));
           Q_EMIT configInitializeFailed(config);
           return;
        }

        if (testPropertySet(0)) {
            config->setValue(QStringLiteral("enablePrelaunchSplash"), QVariant::fromValue(p_enablePrelaunchSplash));
        } else {
            updateValue(QStringLiteral("enablePrelaunchSplash"), QVariant::fromValue(p_enablePrelaunchSplash));
        }
        if (testPropertySet(1)) {
            config->setValue(QStringLiteral("forceSoftwareCursor"), QVariant::fromValue(p_forceSoftwareCursor));
        } else {
            updateValue(QStringLiteral("forceSoftwareCursor"), QVariant::fromValue(p_forceSoftwareCursor));
        }
        if (testPropertySet(2)) {
            config->setValue(QStringLiteral("prelaunchSplashTimeoutMs"), QVariant::fromValue(p_prelaunchSplashTimeoutMs));
        } else {
            updateValue(QStringLiteral("prelaunchSplashTimeoutMs"), QVariant::fromValue(p_prelaunchSplashTimeoutMs));
        }

        if (!m_config.loadRelaxed())
            return;
        connect(config, &DTK_CORE_NAMESPACE::DConfig::valueChanged, this, [this](const QString &key) {
            updateValue(key);
        }, Qt::DirectConnection);

        m_status.storeRelaxed(static_cast<int>(Status::Succeed));
        Q_EMIT configInitializeSucceed(config);
    }
    void updateValue(const QString &key, const QVariant &fallback = QVariant()) {
        if (!m_config.loadRelaxed())
            return;
        Q_ASSERT(QThread::currentThread() == m_config.loadRelaxed()->thread());
        const QVariant &value = m_config.loadRelaxed()->value(key, fallback);
        if (key == QStringLiteral("enablePrelaunchSplash")) {
            markPropertySet(0, !m_config.loadRelaxed()->isDefaultValue(key));
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                Q_ASSERT(QThread::currentThread() == this->thread());
                if (p_enablePrelaunchSplash != newValue) {
                    p_enablePrelaunchSplash = newValue;
                    Q_EMIT enablePrelaunchSplashChanged();
                    Q_EMIT valueChanged(key, value);
                }
            });
            return;
        }
        if (key == QStringLiteral("forceSoftwareCursor")) {
            markPropertySet(1, !m_config.loadRelaxed()->isDefaultValue(key));
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                Q_ASSERT(QThread::currentThread() == this->thread());
                if (p_forceSoftwareCursor != newValue) {
                    p_forceSoftwareCursor = newValue;
                    Q_EMIT forceSoftwareCursorChanged();
                    Q_EMIT valueChanged(key, value);
                }
            });
            return;
        }
        if (key == QStringLiteral("prelaunchSplashTimeoutMs")) {
            markPropertySet(2, !m_config.loadRelaxed()->isDefaultValue(key));
            auto newValue = qvariant_cast<qlonglong>(value);
            QMetaObject::invokeMethod(this, [this, newValue, key, value]() {
                Q_ASSERT(QThread::currentThread() == this->thread());
                if (p_prelaunchSplashTimeoutMs != newValue) {
                    p_prelaunchSplashTimeoutMs = newValue;
                    Q_EMIT prelaunchSplashTimeoutMsChanged();
                    Q_EMIT valueChanged(key, value);
                }
            });
            return;
        }
    }
    inline void markPropertySet(const int index, bool on = true) {
        if (index < 32) {
            if (on)
                m_propertySetStatus0.fetchAndOrOrdered(1 << (index - 0));
            else
                m_propertySetStatus0.fetchAndAndOrdered(~(1 << (index - 0)));
            return;
        }
        Q_UNREACHABLE();
    }
    inline bool testPropertySet(const int index) const {
        if (index < 32) {
            return (m_propertySetStatus0.loadRelaxed() & (1 << (index - 0)));
        }
        Q_UNREACHABLE();
    }

    QAtomicPointer<DTK_CORE_NAMESPACE::DConfig> m_config = nullptr;

public:
    enum class Status {
        Invalid = 0,
        Succeed = 1,
        Failed = 2
    };
private:
    QAtomicInteger<int> m_status = static_cast<int>(Status::Invalid);

    bool p_enablePrelaunchSplash { false };
    bool p_forceSoftwareCursor { false };
    qlonglong p_prelaunchSplashTimeoutMs { 5000 };
    QAtomicInteger<quint32> m_propertySetStatus0 = 0;
};

#endif // TREELANDCONFIG_H
