// Display images inside a terminal
// Copyright (C) 2023  JustKidding
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef SWAY_SOCKET_H
#define SWAY_SOCKET_H

#include "../config.hpp"
#include "util/socket.hpp"

#include <nlohmann/json.hpp>
#include <spdlog/spdlog.h>

enum ipc_message_type { IPC_COMMAND = 0, IPC_GET_WORKSPACES = 1, IPC_GET_OUTPUTS = 3, IPC_GET_TREE = 4 };

struct SwayOutputInfo {
    int x;
    int y;
    float scale;
    std::string name;
};

class SwaySocket : public WaylandConfig
{
  public:
    explicit SwaySocket(std::string_view endpoint);
    ~SwaySocket() override = default;

    auto get_focused_output_name() -> std::string override;
    auto get_window_info() -> struct WaylandWindowGeometry override;
    void initial_setup(std::string_view appid) override;
    void move_window(std::string_view appid, int xcoord, int ycoord) override;
    static auto get_active_window(const std::vector<nlohmann::json> &nodes) -> nlohmann::json;

  private:
    void disable_focus(std::string_view appid);
    void enable_floating(std::string_view appid);
    void ipc_command(std::string_view appid, std::string_view command) const;
    void ipc_command(std::string_view payload) const;
    void set_active_output_info();

    [[nodiscard]] auto get_nodes() const -> std::vector<nlohmann::json>;
    [[nodiscard]] auto ipc_message(ipc_message_type type, std::string_view payload = "") const -> nlohmann::json;

    UnixSocket socket;
    std::shared_ptr<spdlog::logger> logger;
    struct SwayOutputInfo output_info;
};

#endif
