/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// NodeSpecApplyConfiguration represents a declarative configuration of the NodeSpec type for use
// with apply.
//
// NodeSpec describes the attributes that a node is created with.
type NodeSpecApplyConfiguration struct {
	// PodCIDR represents the pod IP range assigned to the node.
	PodCIDR *string `json:"podCIDR,omitempty"`
	// podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this
	// field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for
	// each of IPv4 and IPv6.
	PodCIDRs []string `json:"podCIDRs,omitempty"`
	// ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
	ProviderID *string `json:"providerID,omitempty"`
	// Unschedulable controls node schedulability of new pods. By default, node is schedulable.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
	Unschedulable *bool `json:"unschedulable,omitempty"`
	// If specified, the node's taints.
	Taints []TaintApplyConfiguration `json:"taints,omitempty"`
	// Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
	ConfigSource *NodeConfigSourceApplyConfiguration `json:"configSource,omitempty"`
	// Deprecated. Not all kubelets will set this field. Remove field after 1.13.
	// see: https://issues.k8s.io/61966
	DoNotUseExternalID *string `json:"externalID,omitempty"`
}

// NodeSpecApplyConfiguration constructs a declarative configuration of the NodeSpec type for use with
// apply.
func NodeSpec() *NodeSpecApplyConfiguration {
	return &NodeSpecApplyConfiguration{}
}

// WithPodCIDR sets the PodCIDR field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodCIDR field is set to the value of the last call.
func (b *NodeSpecApplyConfiguration) WithPodCIDR(value string) *NodeSpecApplyConfiguration {
	b.PodCIDR = &value
	return b
}

// WithPodCIDRs adds the given value to the PodCIDRs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PodCIDRs field.
func (b *NodeSpecApplyConfiguration) WithPodCIDRs(values ...string) *NodeSpecApplyConfiguration {
	for i := range values {
		b.PodCIDRs = append(b.PodCIDRs, values[i])
	}
	return b
}

// WithProviderID sets the ProviderID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ProviderID field is set to the value of the last call.
func (b *NodeSpecApplyConfiguration) WithProviderID(value string) *NodeSpecApplyConfiguration {
	b.ProviderID = &value
	return b
}

// WithUnschedulable sets the Unschedulable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Unschedulable field is set to the value of the last call.
func (b *NodeSpecApplyConfiguration) WithUnschedulable(value bool) *NodeSpecApplyConfiguration {
	b.Unschedulable = &value
	return b
}

// WithTaints adds the given value to the Taints field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Taints field.
func (b *NodeSpecApplyConfiguration) WithTaints(values ...*TaintApplyConfiguration) *NodeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTaints")
		}
		b.Taints = append(b.Taints, *values[i])
	}
	return b
}

// WithConfigSource sets the ConfigSource field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConfigSource field is set to the value of the last call.
func (b *NodeSpecApplyConfiguration) WithConfigSource(value *NodeConfigSourceApplyConfiguration) *NodeSpecApplyConfiguration {
	b.ConfigSource = value
	return b
}

// WithDoNotUseExternalID sets the DoNotUseExternalID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DoNotUseExternalID field is set to the value of the last call.
func (b *NodeSpecApplyConfiguration) WithDoNotUseExternalID(value string) *NodeSpecApplyConfiguration {
	b.DoNotUseExternalID = &value
	return b
}
