/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __FUNCLATENCY_BPF_SKEL_H__
#define __FUNCLATENCY_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct funclatency_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *cgroup_map;
		struct bpf_map *starts;
		struct bpf_map *rodata;
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *dummy_fentry;
		struct bpf_program *dummy_kprobe;
		struct bpf_program *dummy_fexit;
		struct bpf_program *dummy_kretprobe;
	} progs;
	struct {
		struct bpf_link *dummy_fentry;
		struct bpf_link *dummy_kprobe;
		struct bpf_link *dummy_fexit;
		struct bpf_link *dummy_kretprobe;
	} links;
	struct funclatency_bpf__rodata {
		pid_t targ_tgid;
		int units;
		bool filter_cg;
	} *rodata;
	struct funclatency_bpf__bss {
		__u32 hist[25];
	} *bss;

#ifdef __cplusplus
	static inline struct funclatency_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct funclatency_bpf *open_and_load();
	static inline int load(struct funclatency_bpf *skel);
	static inline int attach(struct funclatency_bpf *skel);
	static inline void detach(struct funclatency_bpf *skel);
	static inline void destroy(struct funclatency_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
funclatency_bpf__destroy(struct funclatency_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
funclatency_bpf__create_skeleton(struct funclatency_bpf *obj);

static inline struct funclatency_bpf *
funclatency_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct funclatency_bpf *obj;
	int err;

	obj = (struct funclatency_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = funclatency_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	funclatency_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct funclatency_bpf *
funclatency_bpf__open(void)
{
	return funclatency_bpf__open_opts(NULL);
}

static inline int
funclatency_bpf__load(struct funclatency_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct funclatency_bpf *
funclatency_bpf__open_and_load(void)
{
	struct funclatency_bpf *obj;
	int err;

	obj = funclatency_bpf__open();
	if (!obj)
		return NULL;
	err = funclatency_bpf__load(obj);
	if (err) {
		funclatency_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
funclatency_bpf__attach(struct funclatency_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
funclatency_bpf__detach(struct funclatency_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *funclatency_bpf__elf_bytes(size_t *sz);

static inline int
funclatency_bpf__create_skeleton(struct funclatency_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "funclatency_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 4;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "cgroup_map";
	s->maps[0].map = &obj->maps.cgroup_map;

	s->maps[1].name = "starts";
	s->maps[1].map = &obj->maps.starts;

	s->maps[2].name = "funclate.rodata";
	s->maps[2].map = &obj->maps.rodata;
	s->maps[2].mmaped = (void **)&obj->rodata;

	s->maps[3].name = "funclate.bss";
	s->maps[3].map = &obj->maps.bss;
	s->maps[3].mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 4;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "dummy_fentry";
	s->progs[0].prog = &obj->progs.dummy_fentry;
	s->progs[0].link = &obj->links.dummy_fentry;

	s->progs[1].name = "dummy_kprobe";
	s->progs[1].prog = &obj->progs.dummy_kprobe;
	s->progs[1].link = &obj->links.dummy_kprobe;

	s->progs[2].name = "dummy_fexit";
	s->progs[2].prog = &obj->progs.dummy_fexit;
	s->progs[2].link = &obj->links.dummy_fexit;

	s->progs[3].name = "dummy_kretprobe";
	s->progs[3].prog = &obj->progs.dummy_kretprobe;
	s->progs[3].link = &obj->links.dummy_kretprobe;

	s->data = (void *)funclatency_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *funclatency_bpf__elf_bytes(size_t *sz)
{
	*sz = 9800;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xc8\x20\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x16\0\
\x01\0\x85\0\0\0\x05\0\0\0\xbf\x06\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\
\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\
\x05\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x85\0\
\0\0\x25\0\0\0\x15\0\x52\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x4c\0\0\0\0\
\0\x79\x01\0\0\0\0\0\0\x1f\x16\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x61\x11\0\0\0\0\0\0\x16\x01\x03\0\x02\0\0\0\x56\x01\x03\0\x01\0\0\0\x37\x06\0\
\0\xe8\x03\0\0\x05\0\x01\0\0\0\0\0\x37\x06\0\0\x40\x42\x0f\0\x18\x01\0\0\0\0\0\
\0\0\0\0\0\x01\0\0\0\xad\x16\x1e\0\0\0\0\0\xb4\x02\0\0\x01\0\0\0\x18\x03\0\0\
\xff\xff\xff\xff\0\0\0\0\xff\xff\0\0\xb4\x01\0\0\x01\0\0\0\x2d\x36\x01\0\0\0\0\
\0\xb4\x01\0\0\0\0\0\0\x64\x01\0\0\x04\0\0\0\x77\x06\0\0\x20\0\0\0\x7c\x16\0\0\
\0\0\0\0\xb4\x03\0\0\x01\0\0\0\x26\x06\x01\0\xff\0\0\0\xb4\x03\0\0\0\0\0\0\x64\
\x03\0\0\x03\0\0\0\x7c\x36\0\0\0\0\0\0\xb4\x04\0\0\x01\0\0\0\x26\x06\x01\0\x0f\
\0\0\0\xb4\x04\0\0\0\0\0\0\x64\x04\0\0\x02\0\0\0\x7c\x46\0\0\0\0\0\0\x26\x06\
\x01\0\x03\0\0\0\xb4\x02\0\0\0\0\0\0\x64\x02\0\0\x01\0\0\0\x7c\x26\0\0\0\0\0\0\
\x74\x06\0\0\x01\0\0\0\x4c\x61\0\0\0\0\0\0\x4c\x31\0\0\0\0\0\0\x4c\x41\0\0\0\0\
\0\0\x4c\x21\0\0\0\0\0\0\x04\x01\0\0\x20\0\0\0\x05\0\x19\0\0\0\0\0\xb4\x02\0\0\
\x01\0\0\0\xb4\x01\0\0\x01\0\0\0\x25\x06\x01\0\xff\xff\0\0\xb4\x01\0\0\0\0\0\0\
\x64\x01\0\0\x04\0\0\0\x7c\x16\0\0\0\0\0\0\xb4\x03\0\0\x01\0\0\0\x26\x06\x01\0\
\xff\0\0\0\xb4\x03\0\0\0\0\0\0\x64\x03\0\0\x03\0\0\0\x7c\x36\0\0\0\0\0\0\xb4\
\x04\0\0\x01\0\0\0\x26\x06\x01\0\x0f\0\0\0\xb4\x04\0\0\0\0\0\0\x64\x04\0\0\x02\
\0\0\0\x7c\x46\0\0\0\0\0\0\x26\x06\x01\0\x03\0\0\0\xb4\x02\0\0\0\0\0\0\x64\x02\
\0\0\x01\0\0\0\x7c\x26\0\0\0\0\0\0\x74\x06\0\0\x01\0\0\0\x4c\x61\0\0\0\0\0\0\
\x4c\x31\0\0\0\0\0\0\x4c\x41\0\0\0\0\0\0\x4c\x21\0\0\0\0\0\0\xa6\x01\x01\0\x18\
\0\0\0\xb4\x01\0\0\x18\0\0\0\x67\x01\0\0\x02\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x0f\x12\0\0\0\0\0\0\xb4\x01\0\0\x01\0\0\0\xc3\x12\0\0\x01\0\0\0\x95\0\
\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\xbf\x06\0\0\0\0\0\0\x63\x6a\xfc\xff\0\0\0\0\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\x01\x05\0\x01\0\0\
\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x85\0\0\0\x25\0\0\0\
\x15\0\x11\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x12\0\0\0\0\0\0\
\x16\x02\x03\0\0\0\0\0\x77\x06\0\0\x20\0\0\0\x61\x11\0\0\0\0\0\0\x5e\x61\x0a\0\
\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\
\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\
\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\xbf\x06\0\0\0\0\0\0\x63\x6a\
\xfc\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x11\0\0\0\0\0\0\x56\
\x01\x05\0\x01\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\
\x85\0\0\0\x25\0\0\0\x15\0\x11\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x61\x12\0\0\0\0\0\0\x16\x02\x03\0\0\0\0\0\x77\x06\0\0\x20\0\0\0\x61\x11\0\0\0\
\0\0\0\x5e\x61\x0a\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\
\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\
\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\
\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\x10\0\0\xff\xff\xff\xff\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\x10\0\0\xff\xff\xff\xff\xb4\0\0\0\0\0\
\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x20\x06\0\0\
\x20\x06\0\0\x11\x06\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x08\0\0\0\x05\0\
\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\0\0\0\0\0\
\x08\x07\0\0\0\x1d\0\0\0\0\0\0\x08\x08\0\0\0\x23\0\0\0\0\0\0\x01\x04\0\0\0\x20\
\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\
\0\x01\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x30\0\0\0\x01\0\0\0\0\0\0\0\x35\0\0\
\0\x05\0\0\0\x40\0\0\0\x39\0\0\0\x05\0\0\0\x80\0\0\0\x3f\0\0\0\x09\0\0\0\xc0\0\
\0\0\x4b\0\0\0\0\0\0\x0e\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x0e\0\0\0\0\0\0\
\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\x90\x01\0\0\0\0\0\0\0\0\x02\x10\0\0\
\0\x56\0\0\0\0\0\0\x08\x11\0\0\0\x5a\0\0\0\0\0\0\x08\x12\0\0\0\x60\0\0\0\0\0\0\
\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x30\0\0\0\x09\0\0\0\0\0\
\0\0\x3f\0\0\0\x0d\0\0\0\x40\0\0\0\x35\0\0\0\x05\0\0\0\x80\0\0\0\x39\0\0\0\x0f\
\0\0\0\xc0\0\0\0\x73\0\0\0\0\0\0\x0e\x13\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x12\
\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x7a\0\0\0\x15\0\0\0\x7e\0\0\0\x01\0\0\x0c\
\x16\0\0\0\0\0\0\0\0\0\0\x02\x19\0\0\0\xd9\x01\0\0\x15\0\0\x04\xa8\0\0\0\xe1\
\x01\0\0\x1a\0\0\0\0\0\0\0\xe5\x01\0\0\x1a\0\0\0\x40\0\0\0\xe9\x01\0\0\x1a\0\0\
\0\x80\0\0\0\xed\x01\0\0\x1a\0\0\0\xc0\0\0\0\xf1\x01\0\0\x1a\0\0\0\0\x01\0\0\
\xf4\x01\0\0\x1a\0\0\0\x40\x01\0\0\xf7\x01\0\0\x1a\0\0\0\x80\x01\0\0\xfb\x01\0\
\0\x1a\0\0\0\xc0\x01\0\0\xff\x01\0\0\x1a\0\0\0\0\x02\0\0\x02\x02\0\0\x1a\0\0\0\
\x40\x02\0\0\x05\x02\0\0\x1a\0\0\0\x80\x02\0\0\x08\x02\0\0\x1a\0\0\0\xc0\x02\0\
\0\x0b\x02\0\0\x1a\0\0\0\0\x03\0\0\x0e\x02\0\0\x1a\0\0\0\x40\x03\0\0\x11\x02\0\
\0\x1a\0\0\0\x80\x03\0\0\x14\x02\0\0\x1a\0\0\0\xc0\x03\0\0\x1c\x02\0\0\x1a\0\0\
\0\0\x04\0\0\0\0\0\0\x1b\0\0\0\x40\x04\0\0\x1f\x02\0\0\x1a\0\0\0\x80\x04\0\0\
\x25\x02\0\0\x1a\0\0\0\xc0\x04\0\0\0\0\0\0\x20\0\0\0\0\x05\0\0\x28\x02\0\0\0\0\
\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\x36\x02\0\0\x1c\0\0\0\
\0\0\0\0\x39\x02\0\0\x10\0\0\0\0\0\0\0\x3d\x02\0\0\x1f\0\0\0\0\0\0\0\x45\x02\0\
\0\0\0\0\x08\x1d\0\0\0\x49\x02\0\0\0\0\0\x08\x1e\0\0\0\x4f\x02\0\0\0\0\0\x01\
\x02\0\0\0\x10\0\0\0\x3d\x02\0\0\x03\0\0\x84\x08\0\0\0\x36\x02\0\0\x10\0\0\0\0\
\0\0\x10\x5e\x02\0\0\x10\0\0\0\x10\0\0\x02\x61\x02\0\0\x10\0\0\0\x12\0\0\x01\0\
\0\0\0\x03\0\0\x05\x08\0\0\0\x65\x02\0\0\x1c\0\0\0\0\0\0\0\x68\x02\0\0\x10\0\0\
\0\0\0\0\0\x6c\x02\0\0\x21\0\0\0\0\0\0\0\x6c\x02\0\0\x0a\0\0\x84\x08\0\0\0\x65\
\x02\0\0\x10\0\0\0\0\0\0\x10\x74\x02\0\0\x10\0\0\0\x10\0\0\x01\x78\x02\0\0\x10\
\0\0\0\x11\0\0\x01\x80\x02\0\0\x10\0\0\0\x12\0\0\x01\x84\x02\0\0\x10\0\0\0\x20\
\0\0\x08\x30\0\0\0\x10\0\0\0\x30\0\0\x04\x8b\x02\0\0\x10\0\0\0\x38\0\0\x01\x93\
\x02\0\0\x10\0\0\0\x39\0\0\x01\x96\x02\0\0\x10\0\0\0\x3a\0\0\x01\x9d\x02\0\0\
\x10\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x7a\0\0\0\x18\0\0\0\xa5\
\x02\0\0\x01\0\0\x0c\x22\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x7a\0\0\0\x15\0\0\
\0\xe3\x02\0\0\x01\0\0\x0c\x24\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x7a\0\0\0\
\x18\0\0\0\x24\x03\0\0\x01\0\0\x0c\x26\0\0\0\0\0\0\0\0\0\0\x0d\0\0\0\0\x71\x03\
\0\0\0\0\0\x0c\x28\0\0\0\0\0\0\0\0\0\0\x0a\x2b\0\0\0\0\0\0\0\0\0\0\x09\x2c\0\0\
\0\xaa\x05\0\0\0\0\0\x08\x2d\0\0\0\xb0\x05\0\0\0\0\0\x08\x02\0\0\0\xbf\x05\0\0\
\0\0\0\x0e\x2a\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x30\0\0\0\0\0\0\0\0\0\0\x09\
\x02\0\0\0\xc9\x05\0\0\0\0\0\x0e\x2f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x33\0\0\
\0\0\0\0\0\0\0\0\x09\x34\0\0\0\xcf\x05\0\0\0\0\0\x08\x35\0\0\0\xd4\x05\0\0\0\0\
\0\x01\x01\0\0\0\x08\0\0\x04\xda\x05\0\0\0\0\0\x0e\x32\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\x03\0\0\0\0\x07\0\0\0\x04\0\0\0\x19\0\0\0\xe4\x05\0\0\0\0\0\x0e\x37\0\0\
\0\x01\0\0\0\xe9\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\
\0\0\x39\0\0\0\x04\0\0\0\x04\0\0\0\xee\x05\0\0\0\0\0\x0e\x3a\0\0\0\x01\0\0\0\
\xf6\x05\0\0\x01\0\0\x0f\0\0\0\0\x38\0\0\0\0\0\0\0\x64\0\0\0\xfb\x05\0\0\x02\0\
\0\x0f\0\0\0\0\x0c\0\0\0\0\0\0\0\x20\0\0\0\x14\0\0\0\0\0\0\0\x20\0\0\0\x01\x06\
\0\0\x03\0\0\x0f\0\0\0\0\x2e\0\0\0\0\0\0\0\x04\0\0\0\x31\0\0\0\0\0\0\0\x04\0\0\
\0\x36\0\0\0\0\0\0\0\x01\0\0\0\x09\x06\0\0\x01\0\0\x0f\0\0\0\0\x3b\0\0\0\0\0\0\
\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\
\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x74\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\
\x6c\x75\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x63\x67\x72\x6f\
\x75\x70\x5f\x6d\x61\x70\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x73\x74\x61\x72\x74\
\x73\0\x63\x74\x78\0\x64\x75\x6d\x6d\x79\x5f\x66\x65\x6e\x74\x72\x79\0\x66\x65\
\x6e\x74\x72\x79\x2f\x64\x75\x6d\x6d\x79\x5f\x66\x65\x6e\x74\x72\x79\0\x2f\x62\
\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\
\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x66\x75\x6e\x63\x6c\x61\x74\x65\
\x6e\x63\x79\x2e\x62\x70\x66\x2e\x63\0\x09\x75\x36\x34\x20\x69\x64\x20\x3d\x20\
\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\
\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x75\x33\x32\x20\x70\x69\x64\x20\x3d\x20\
\x69\x64\x3b\0\x09\x69\x66\x20\x28\x66\x69\x6c\x74\x65\x72\x5f\x63\x67\x20\x26\
\x26\x20\x21\x62\x70\x66\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x74\x61\x73\x6b\
\x5f\x75\x6e\x64\x65\x72\x5f\x63\x67\x72\x6f\x75\x70\x28\x26\x63\x67\x72\x6f\
\x75\x70\x5f\x6d\x61\x70\x2c\x20\x30\x29\x29\0\x09\x69\x66\x20\x28\x74\x61\x72\
\x67\x5f\x74\x67\x69\x64\x20\x26\x26\x20\x74\x61\x72\x67\x5f\x74\x67\x69\x64\
\x20\x21\x3d\x20\x74\x67\x69\x64\x29\0\x09\x6e\x73\x65\x63\x20\x3d\x20\x62\x70\
\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\x62\
\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\
\x26\x73\x74\x61\x72\x74\x73\x2c\x20\x26\x70\x69\x64\x2c\x20\x26\x6e\x73\x65\
\x63\x2c\x20\x42\x50\x46\x5f\x41\x4e\x59\x29\x3b\0\x69\x6e\x74\x20\x42\x50\x46\
\x5f\x50\x52\x4f\x47\x28\x64\x75\x6d\x6d\x79\x5f\x66\x65\x6e\x74\x72\x79\x29\0\
\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\x72\
\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\x38\0\
\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\x61\x78\
\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\x65\x64\
\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\x73\0\
\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\
\x68\x6f\x72\x74\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\
\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\
\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\
\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\x64\x75\x6d\x6d\x79\x5f\x6b\x70\
\x72\x6f\x62\x65\0\x6b\x70\x72\x6f\x62\x65\x2f\x64\x75\x6d\x6d\x79\x5f\x6b\x70\
\x72\x6f\x62\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\
\x64\x75\x6d\x6d\x79\x5f\x6b\x70\x72\x6f\x62\x65\x29\0\x64\x75\x6d\x6d\x79\x5f\
\x66\x65\x78\x69\x74\0\x66\x65\x78\x69\x74\x2f\x64\x75\x6d\x6d\x79\x5f\x66\x65\
\x78\x69\x74\0\x09\x65\x78\x69\x74\x28\x29\x3b\0\x69\x6e\x74\x20\x42\x50\x46\
\x5f\x50\x52\x4f\x47\x28\x64\x75\x6d\x6d\x79\x5f\x66\x65\x78\x69\x74\x29\0\x64\
\x75\x6d\x6d\x79\x5f\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\0\x6b\x72\x65\x74\x70\
\x72\x6f\x62\x65\x2f\x64\x75\x6d\x6d\x79\x5f\x6b\x72\x65\x74\x70\x72\x6f\x62\
\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x4b\x52\x45\x54\x50\x52\x4f\x42\x45\x28\
\x64\x75\x6d\x6d\x79\x5f\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x29\0\x65\x78\x69\
\x74\0\x2e\x74\x65\x78\x74\0\x09\x75\x36\x34\x20\x6e\x73\x65\x63\x20\x3d\x20\
\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\
\x09\x73\x74\x61\x72\x74\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\
\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x73\x2c\x20\
\x26\x70\x69\x64\x29\x3b\0\x09\x69\x66\x20\x28\x21\x73\x74\x61\x72\x74\x29\0\
\x09\x64\x65\x6c\x74\x61\x20\x3d\x20\x6e\x73\x65\x63\x20\x2d\x20\x2a\x73\x74\
\x61\x72\x74\x3b\0\x09\x73\x77\x69\x74\x63\x68\x20\x28\x75\x6e\x69\x74\x73\x29\
\x20\x7b\0\x09\x09\x64\x65\x6c\x74\x61\x20\x2f\x3d\x20\x31\x30\x30\x30\x3b\0\
\x09\x09\x62\x72\x65\x61\x6b\x3b\0\x09\x09\x64\x65\x6c\x74\x61\x20\x2f\x3d\x20\
\x31\x30\x30\x30\x30\x30\x30\x3b\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\
\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\
\x73\x2f\x2e\x2f\x62\x69\x74\x73\x2e\x62\x70\x66\x2e\x68\0\x09\x69\x66\x20\x28\
\x68\x69\x29\0\x09\x75\x33\x32\x20\x68\x69\x20\x3d\x20\x76\x20\x3e\x3e\x20\x33\
\x32\x3b\0\x09\x72\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x46\x46\x46\x46\x29\
\x20\x3c\x3c\x20\x34\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x72\x3b\0\x09\x73\x68\x69\
\x66\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x46\x46\x29\x20\x3c\x3c\x20\
\x33\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\
\x3d\x20\x73\x68\x69\x66\x74\x3b\0\x09\x73\x68\x69\x66\x74\x20\x3d\x20\x28\x76\
\x20\x3e\x20\x30\x78\x46\x29\x20\x3c\x3c\x20\x32\x3b\x20\x76\x20\x3e\x3e\x3d\
\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\x74\x3b\0\
\x09\x73\x68\x69\x66\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x33\x29\x20\
\x3c\x3c\x20\x31\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\
\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\x74\x3b\0\x09\x72\x20\x7c\x3d\x20\x28\x76\
\x20\x3e\x3e\x20\x31\x29\x3b\0\x09\x09\x72\x65\x74\x75\x72\x6e\x20\x6c\x6f\x67\
\x32\x28\x68\x69\x29\x20\x2b\x20\x33\x32\x3b\0\x09\x09\x72\x65\x74\x75\x72\x6e\
\x20\x6c\x6f\x67\x32\x28\x76\x29\x3b\0\x09\x69\x66\x20\x28\x73\x6c\x6f\x74\x20\
\x3e\x3d\x20\x4d\x41\x58\x5f\x53\x4c\x4f\x54\x53\x29\0\x09\x5f\x5f\x73\x79\x6e\
\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x68\x69\
\x73\x74\x5b\x73\x6c\x6f\x74\x5d\x2c\x20\x31\x29\x3b\0\x7d\0\x70\x69\x64\x5f\
\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\x5f\x70\x69\x64\x5f\x74\0\x74\x61\x72\
\x67\x5f\x74\x67\x69\x64\0\x75\x6e\x69\x74\x73\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\
\x6f\x6c\0\x66\x69\x6c\x74\x65\x72\x5f\x63\x67\0\x68\x69\x73\x74\0\x63\x68\x61\
\x72\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\
\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\
\0\x20\0\0\0\0\0\0\0\x54\0\0\0\x54\0\0\0\x0c\x05\0\0\x60\x05\0\0\0\0\0\0\x08\0\
\0\0\x8b\0\0\0\x01\0\0\0\0\0\0\0\x17\0\0\0\xb2\x02\0\0\x01\0\0\0\0\0\0\0\x23\0\
\0\0\xef\x02\0\0\x01\0\0\0\0\0\0\0\x25\0\0\0\x34\x03\0\0\x01\0\0\0\0\0\0\0\x27\
\0\0\0\x76\x03\0\0\x01\0\0\0\0\0\0\0\x29\0\0\0\x10\0\0\0\x8b\0\0\0\x0e\0\0\0\0\
\0\0\0\x9f\0\0\0\xd1\0\0\0\x0b\x84\0\0\x10\0\0\0\x9f\0\0\0\xf7\0\0\0\x06\x8c\0\
\0\x18\0\0\0\x9f\0\0\0\x06\x01\0\0\x06\x98\0\0\x30\0\0\0\x9f\0\0\0\x06\x01\0\0\
\x10\x98\0\0\x38\0\0\0\x9f\0\0\0\x06\x01\0\0\x14\x98\0\0\x58\0\0\0\x9f\0\0\0\
\x06\x01\0\0\x10\x98\0\0\x60\0\0\0\x9f\0\0\0\x48\x01\0\0\x06\xa4\0\0\x78\0\0\0\
\x9f\0\0\0\x48\x01\0\0\x10\xa4\0\0\x88\0\0\0\x9f\0\0\0\x48\x01\0\0\x13\xa4\0\0\
\x90\0\0\0\x9f\0\0\0\x48\x01\0\0\x10\xa4\0\0\x98\0\0\0\x9f\0\0\0\x6d\x01\0\0\
\x09\xac\0\0\xa0\0\0\0\x9f\0\0\0\x6d\x01\0\0\x07\xac\0\0\xc8\0\0\0\x9f\0\0\0\
\x89\x01\0\0\x02\xb0\0\0\xe8\0\0\0\x9f\0\0\0\xbe\x01\0\0\x05\xc0\0\0\xb2\x02\0\
\0\x0e\0\0\0\0\0\0\0\x9f\0\0\0\xd1\0\0\0\x0b\x84\0\0\x10\0\0\0\x9f\0\0\0\xf7\0\
\0\0\x06\x8c\0\0\x18\0\0\0\x9f\0\0\0\x06\x01\0\0\x06\x98\0\0\x30\0\0\0\x9f\0\0\
\0\x06\x01\0\0\x10\x98\0\0\x38\0\0\0\x9f\0\0\0\x06\x01\0\0\x14\x98\0\0\x58\0\0\
\0\x9f\0\0\0\x06\x01\0\0\x10\x98\0\0\x60\0\0\0\x9f\0\0\0\x48\x01\0\0\x06\xa4\0\
\0\x78\0\0\0\x9f\0\0\0\x48\x01\0\0\x10\xa4\0\0\x88\0\0\0\x9f\0\0\0\x48\x01\0\0\
\x13\xa4\0\0\x90\0\0\0\x9f\0\0\0\x48\x01\0\0\x10\xa4\0\0\x98\0\0\0\x9f\0\0\0\
\x6d\x01\0\0\x09\xac\0\0\xa0\0\0\0\x9f\0\0\0\x6d\x01\0\0\x07\xac\0\0\xc8\0\0\0\
\x9f\0\0\0\x89\x01\0\0\x02\xb0\0\0\xe8\0\0\0\x9f\0\0\0\xc6\x02\0\0\x05\xdc\0\0\
\xef\x02\0\0\x02\0\0\0\0\0\0\0\x9f\0\0\0\x01\x03\0\0\x02\x80\x01\0\x08\0\0\0\
\x9f\0\0\0\x0a\x03\0\0\x05\x78\x01\0\x34\x03\0\0\x02\0\0\0\0\0\0\0\x9f\0\0\0\
\x01\x03\0\0\x02\x9c\x01\0\x08\0\0\0\x9f\0\0\0\x4e\x03\0\0\x05\x94\x01\0\x76\
\x03\0\0\x2e\0\0\0\0\0\0\0\x9f\0\0\0\x7c\x03\0\0\x0d\0\x01\0\x10\0\0\0\x9f\0\0\
\0\xd1\0\0\0\x0b\x04\x01\0\x18\0\0\0\x9f\0\0\0\xf7\0\0\0\x06\x08\x01\0\x20\0\0\
\0\x9f\0\0\0\x06\x01\0\0\x06\x14\x01\0\x38\0\0\0\x9f\0\0\0\x06\x01\0\0\x10\x14\
\x01\0\x40\0\0\0\x9f\0\0\0\x06\x01\0\0\x14\x14\x01\0\x60\0\0\0\x9f\0\0\0\x06\
\x01\0\0\x10\x14\x01\0\x78\0\0\0\x9f\0\0\0\x9c\x03\0\0\x0a\x20\x01\0\x90\0\0\0\
\x9f\0\0\0\xc9\x03\0\0\x06\x24\x01\0\x98\0\0\0\x9f\0\0\0\xd6\x03\0\0\x11\x30\
\x01\0\xa0\0\0\0\x9f\0\0\0\xd6\x03\0\0\x0f\x30\x01\0\xa8\0\0\0\x9f\0\0\0\xee\
\x03\0\0\x0a\x38\x01\0\xc0\0\0\0\x9f\0\0\0\xee\x03\0\0\x02\x38\x01\0\xd0\0\0\0\
\x9f\0\0\0\0\x04\0\0\x09\x40\x01\0\xd8\0\0\0\x9f\0\0\0\x11\x04\0\0\x03\x44\x01\
\0\xe0\0\0\0\x9f\0\0\0\x1a\x04\0\0\x09\x4c\x01\0\xf8\0\0\0\x2e\x04\0\0\x5b\x04\
\0\0\x06\x64\0\0\x20\x01\0\0\x2e\x04\0\0\x64\x04\0\0\x0d\x5c\0\0\x30\x01\0\0\
\x2e\x04\0\0\x77\x04\0\0\x13\x30\0\0\x38\x01\0\0\x2e\x04\0\0\x64\x04\0\0\x0d\
\x5c\0\0\x40\x01\0\0\x2e\x04\0\0\x77\x04\0\0\x1b\x30\0\0\x60\x01\0\0\x2e\x04\0\
\0\x98\x04\0\0\x15\x34\0\0\x68\x01\0\0\x2e\x04\0\0\x98\x04\0\0\x1d\x34\0\0\x88\
\x01\0\0\x2e\x04\0\0\xcb\x04\0\0\x14\x38\0\0\x90\x01\0\0\x2e\x04\0\0\xcb\x04\0\
\0\x1c\x38\0\0\xa8\x01\0\0\x2e\x04\0\0\xfd\x04\0\0\x14\x3c\0\0\xb0\x01\0\0\x2e\
\x04\0\0\xfd\x04\0\0\x1c\x3c\0\0\xb8\x01\0\0\x2e\x04\0\0\x2f\x05\0\0\x0a\x40\0\
\0\xc0\x01\0\0\x2e\x04\0\0\x2f\x05\0\0\x04\x40\0\0\xe0\x01\0\0\x2e\x04\0\0\x3f\
\x05\0\0\x13\x68\0\0\xe8\x01\0\0\x2e\x04\0\0\x3f\x05\0\0\x03\x68\0\0\0\x02\0\0\
\x2e\x04\0\0\x57\x05\0\0\x0f\x70\0\0\x10\x02\0\0\x2e\x04\0\0\x77\x04\0\0\x13\
\x30\0\0\x18\x02\0\0\x2e\x04\0\0\x77\x04\0\0\x1b\x30\0\0\x38\x02\0\0\x2e\x04\0\
\0\x98\x04\0\0\x15\x34\0\0\x40\x02\0\0\x2e\x04\0\0\x98\x04\0\0\x1d\x34\0\0\x60\
\x02\0\0\x2e\x04\0\0\xcb\x04\0\0\x14\x38\0\0\x68\x02\0\0\x2e\x04\0\0\xcb\x04\0\
\0\x1c\x38\0\0\x80\x02\0\0\x2e\x04\0\0\xfd\x04\0\0\x14\x3c\0\0\x88\x02\0\0\x2e\
\x04\0\0\xfd\x04\0\0\x1c\x3c\0\0\x90\x02\0\0\x2e\x04\0\0\x2f\x05\0\0\x0a\x40\0\
\0\x98\x02\0\0\x2e\x04\0\0\x2f\x05\0\0\x04\x40\0\0\xb8\x02\0\0\x9f\0\0\0\x69\
\x05\0\0\x0b\x60\x01\0\xc8\x02\0\0\x9f\0\0\0\x81\x05\0\0\x18\x68\x01\0\xf0\x02\
\0\0\x9f\0\0\0\x81\x05\0\0\x02\x68\x01\0\xf8\x02\0\0\x9f\0\0\0\xa8\x05\0\0\x01\
\x6c\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\
\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x46\0\0\0\x02\0\x02\0\0\0\0\0\0\0\0\0\
\0\x03\0\0\0\0\0\0\0\0\0\0\x03\0\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0c\0\0\
\0\x12\0\x04\0\0\0\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\x7c\0\0\0\x11\0\x0c\0\x08\0\0\
\0\0\0\0\0\x01\0\0\0\0\0\0\0\x63\0\0\0\x11\0\x0f\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\
\0\0\0\xc4\0\0\0\x11\0\x0c\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x4b\0\0\0\x11\0\
\x0f\0\x20\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\xb7\0\0\0\x12\0\x06\0\0\0\0\0\0\0\0\
\0\xf8\0\0\0\0\0\0\0\x3f\0\0\0\x12\0\x08\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\
\x9c\0\0\0\x12\0\x0a\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x52\0\0\0\x11\0\x0c\0\
\x04\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x30\0\0\0\x11\0\x0d\0\0\0\0\0\0\0\0\0\x64\
\0\0\0\0\0\0\0\xef\0\0\0\x11\0\x0e\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x20\0\0\
\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x78\0\0\0\
\0\0\0\0\x01\0\0\0\x0b\0\0\0\xa8\0\0\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\xd0\x02\0\0\
\0\0\0\0\x01\0\0\0\x10\0\0\0\x18\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x38\0\0\0\0\
\0\0\0\x01\0\0\0\x09\0\0\0\x60\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xc8\0\0\0\0\0\
\0\0\x01\0\0\0\x0b\0\0\0\x18\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x38\0\0\0\0\0\0\
\0\x01\0\0\0\x09\0\0\0\x60\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\xc8\0\0\0\0\0\0\0\
\x01\0\0\0\x0b\0\0\0\0\0\0\0\0\0\0\0\x0a\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\x0a\0\
\0\0\x01\0\0\0\xc4\x05\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\xdc\x05\0\0\0\0\0\0\x04\
\0\0\0\x09\0\0\0\xe8\x05\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\0\x06\0\0\0\0\0\0\x03\
\0\0\0\x0a\0\0\0\x0c\x06\0\0\0\0\0\0\x03\0\0\0\x0f\0\0\0\x18\x06\0\0\0\0\0\0\
\x03\0\0\0\x08\0\0\0\x30\x06\0\0\0\0\0\0\x04\0\0\0\x11\0\0\0\x2c\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x4c\0\0\0\0\0\0\0\
\x04\0\0\0\x04\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x6c\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x90\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x10\x01\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\x01\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x68\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x78\x01\0\0\0\
\0\0\0\x04\0\0\0\x03\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x98\x01\0\0\
\0\0\0\0\x04\0\0\0\x03\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xb8\x01\0\
\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xd8\x01\
\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xf8\
\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\
\x18\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\
\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x50\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\
\0\0\x60\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x06\
\0\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xa0\x02\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xb0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x02\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\xd0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\x02\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\xf0\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x03\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x10\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x20\x03\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x30\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\x03\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x50\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x60\x03\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x70\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x80\x03\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x90\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x03\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\xb0\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x03\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\x03\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\x03\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x04\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x20\x04\
\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x40\
\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x60\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x80\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\xa0\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\x04\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\xc0\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\x04\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xe0\x04\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\x04\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\0\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x05\0\0\0\0\0\0\x04\0\0\
\0\x01\0\0\0\x20\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x05\0\0\0\0\0\0\x04\0\
\0\0\x01\0\0\0\x40\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x05\0\0\0\0\0\0\x04\
\0\0\0\x01\0\0\0\x60\x05\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x05\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x11\x16\x17\x18\x14\x19\x12\x1a\x1b\x13\x15\0\x2e\x72\x65\
\x6c\x66\x65\x6e\x74\x72\x79\x2f\x64\x75\x6d\x6d\x79\x5f\x66\x65\x6e\x74\x72\
\x79\0\x2e\x72\x65\x6c\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\
\x2e\x65\x78\x74\0\x68\x69\x73\x74\0\x2e\x72\x65\x6c\x66\x65\x78\x69\x74\x2f\
\x64\x75\x6d\x6d\x79\x5f\x66\x65\x78\x69\x74\0\x73\x74\x61\x72\x74\x73\0\x75\
\x6e\x69\x74\x73\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x63\x67\x72\x6f\x75\
\x70\x5f\x6d\x61\x70\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\
\x66\x69\x6c\x74\x65\x72\x5f\x63\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\
\x65\x6c\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x2f\x64\x75\x6d\x6d\x79\x5f\x6b\
\x72\x65\x74\x70\x72\x6f\x62\x65\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\
\x64\x75\x6d\x6d\x79\x5f\x6b\x70\x72\x6f\x62\x65\0\x74\x61\x72\x67\x5f\x74\x67\
\x69\x64\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\
\x6f\x64\x61\x74\x61\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\
\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xce\0\
\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xcb\x1f\0\0\0\0\0\0\xf7\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1d\0\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x19\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x30\x19\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x15\0\0\0\x02\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x05\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x40\x03\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x80\x19\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x15\0\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\xb0\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\
\x04\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\xac\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc0\x19\0\0\0\0\0\
\0\x40\0\0\0\0\0\0\0\x15\0\0\0\x06\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x39\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x30\x05\0\0\0\0\0\0\x18\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x35\0\0\0\x09\
\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x1a\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x15\0\0\0\x08\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x92\0\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x48\x05\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x8e\0\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x10\x1a\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x15\0\0\0\x0a\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xde\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x60\x05\0\0\0\0\0\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x58\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x6c\x05\0\0\0\0\0\0\x64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x86\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6c\x05\0\0\0\
\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5d\
\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x05\0\0\0\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xea\0\0\0\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\x05\0\0\0\0\0\0\x49\x0c\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe6\0\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x20\x1a\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\x15\0\0\0\x10\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x27\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xfc\x11\0\0\0\0\0\0\x80\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x23\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x90\x1a\0\0\0\0\0\0\x30\x05\0\0\0\0\0\0\x15\0\0\0\x12\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x6e\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\
\xc0\x1f\0\0\0\0\0\0\x0b\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xd6\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x17\0\0\0\0\
\0\0\xb0\x01\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\
\0";
}

#ifdef __cplusplus
struct funclatency_bpf *funclatency_bpf::open(const struct bpf_object_open_opts *opts) { return funclatency_bpf__open_opts(opts); }
struct funclatency_bpf *funclatency_bpf::open_and_load() { return funclatency_bpf__open_and_load(); }
int funclatency_bpf::load(struct funclatency_bpf *skel) { return funclatency_bpf__load(skel); }
int funclatency_bpf::attach(struct funclatency_bpf *skel) { return funclatency_bpf__attach(skel); }
void funclatency_bpf::detach(struct funclatency_bpf *skel) { funclatency_bpf__detach(skel); }
void funclatency_bpf::destroy(struct funclatency_bpf *skel) { funclatency_bpf__destroy(skel); }
const void *funclatency_bpf::elf_bytes(size_t *sz) { return funclatency_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
funclatency_bpf__assert(struct funclatency_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->targ_tgid) == 4, "unexpected size of 'targ_tgid'");
	_Static_assert(sizeof(s->rodata->units) == 4, "unexpected size of 'units'");
	_Static_assert(sizeof(s->rodata->filter_cg) == 1, "unexpected size of 'filter_cg'");
	_Static_assert(sizeof(s->bss->hist) == 100, "unexpected size of 'hist'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __FUNCLATENCY_BPF_SKEL_H__ */
