{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Encapsulates information about a key event.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.KeyEventStruct
    ( 

-- * Exported types
    KeyEventStruct(..)                      ,
    newZeroKeyEventStruct                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveKeyEventStructMethod             ,
#endif



 -- * Properties


-- ** keycode #attr:keycode#
-- | The raw hardware code that generated the key event.  This field is raraly useful.

    getKeyEventStructKeycode                ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_keycode                  ,
#endif
    setKeyEventStructKeycode                ,


-- ** keyval #attr:keyval#
-- | A guint representing a keysym value corresponding to those used by GDK and X11: see
-- \/usr\/X11\/include\/keysymdef.h.

    getKeyEventStructKeyval                 ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_keyval                   ,
#endif
    setKeyEventStructKeyval                 ,


-- ** length #attr:length#
-- | The length of member @/string/@.

    getKeyEventStructLength                 ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_length                   ,
#endif
    setKeyEventStructLength                 ,


-- ** state #attr:state#
-- | A bitmask representing the state of the modifier keys immediately after the event takes place.
-- The meaning of the bits is currently defined to match the bitmask used by GDK in
-- GdkEventType.state, see
-- http:\/\/developer.gnome.org\/doc\/API\/2.0\/gdk\/gdk-Event-Structures.html@/GdkEventKey/@

    getKeyEventStructState                  ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_state                    ,
#endif
    setKeyEventStructState                  ,


-- ** string #attr:string#
-- | A string containing one of the following: either a string approximating the text that would
-- result from this keypress, if the key is a control or graphic character, or a symbolic name for this keypress.
-- Alphanumeric and printable keys will have the symbolic key name in this string member, for instance \"A\". \"0\",
-- \"semicolon\", \"aacute\".  Keypad keys have the prefix \"KP\".

    clearKeyEventStructString               ,
    getKeyEventStructString                 ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_string                   ,
#endif
    setKeyEventStructString                 ,


-- ** timestamp #attr:timestamp#
-- | A timestamp in milliseconds indicating when the event occurred.
-- These timestamps are relative to a starting point which should be considered arbitrary,
-- and only used to compare the dispatch times of events to one another.

    getKeyEventStructTimestamp              ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_timestamp                ,
#endif
    setKeyEventStructTimestamp              ,


-- ** type #attr:type#
-- | An AtkKeyEventType, generally one of ATK_KEY_EVENT_PRESS or ATK_KEY_EVENT_RELEASE

    getKeyEventStructType                   ,
#if defined(ENABLE_OVERLOADING)
    keyEventStruct_type                     ,
#endif
    setKeyEventStructType                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype KeyEventStruct = KeyEventStruct (SP.ManagedPtr KeyEventStruct)
    deriving (Eq)

instance SP.ManagedPtrNewtype KeyEventStruct where
    toManagedPtr (KeyEventStruct p) = p

instance BoxedPtr KeyEventStruct where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr KeyEventStruct)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr KeyEventStruct where
    boxedPtrCalloc = callocBytes 32


-- | Construct a t'KeyEventStruct' struct initialized to zero.
newZeroKeyEventStruct :: MonadIO m => m KeyEventStruct
newZeroKeyEventStruct = liftIO $ boxedPtrCalloc >>= wrapPtr KeyEventStruct

instance tag ~ 'AttrSet => Constructible KeyEventStruct tag where
    new _ attrs = do
        o <- newZeroKeyEventStruct
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #type
-- @
getKeyEventStructType :: MonadIO m => KeyEventStruct -> m Int32
getKeyEventStructType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructType :: MonadIO m => KeyEventStruct -> Int32 -> m ()
setKeyEventStructType s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructTypeFieldInfo
instance AttrInfo KeyEventStructTypeFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructTypeFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructTypeFieldInfo = (~) Int32
    type AttrTransferTypeConstraint KeyEventStructTypeFieldInfo = (~)Int32
    type AttrTransferType KeyEventStructTypeFieldInfo = Int32
    type AttrGetType KeyEventStructTypeFieldInfo = Int32
    type AttrLabel KeyEventStructTypeFieldInfo = "type"
    type AttrOrigin KeyEventStructTypeFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructType
    attrSet = setKeyEventStructType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:type"
        })

keyEventStruct_type :: AttrLabelProxy "type"
keyEventStruct_type = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #state
-- @
getKeyEventStructState :: MonadIO m => KeyEventStruct -> m Word32
getKeyEventStructState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructState :: MonadIO m => KeyEventStruct -> Word32 -> m ()
setKeyEventStructState s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructStateFieldInfo
instance AttrInfo KeyEventStructStateFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructStateFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructStateFieldInfo = (~) Word32
    type AttrTransferTypeConstraint KeyEventStructStateFieldInfo = (~)Word32
    type AttrTransferType KeyEventStructStateFieldInfo = Word32
    type AttrGetType KeyEventStructStateFieldInfo = Word32
    type AttrLabel KeyEventStructStateFieldInfo = "state"
    type AttrOrigin KeyEventStructStateFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructState
    attrSet = setKeyEventStructState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:state"
        })

keyEventStruct_state :: AttrLabelProxy "state"
keyEventStruct_state = AttrLabelProxy

#endif


-- | Get the value of the “@keyval@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #keyval
-- @
getKeyEventStructKeyval :: MonadIO m => KeyEventStruct -> m Word32
getKeyEventStructKeyval s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@keyval@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #keyval 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructKeyval :: MonadIO m => KeyEventStruct -> Word32 -> m ()
setKeyEventStructKeyval s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructKeyvalFieldInfo
instance AttrInfo KeyEventStructKeyvalFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructKeyvalFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructKeyvalFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructKeyvalFieldInfo = (~) Word32
    type AttrTransferTypeConstraint KeyEventStructKeyvalFieldInfo = (~)Word32
    type AttrTransferType KeyEventStructKeyvalFieldInfo = Word32
    type AttrGetType KeyEventStructKeyvalFieldInfo = Word32
    type AttrLabel KeyEventStructKeyvalFieldInfo = "keyval"
    type AttrOrigin KeyEventStructKeyvalFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructKeyval
    attrSet = setKeyEventStructKeyval
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.keyval"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:keyval"
        })

keyEventStruct_keyval :: AttrLabelProxy "keyval"
keyEventStruct_keyval = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #length
-- @
getKeyEventStructLength :: MonadIO m => KeyEventStruct -> m Int32
getKeyEventStructLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructLength :: MonadIO m => KeyEventStruct -> Int32 -> m ()
setKeyEventStructLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructLengthFieldInfo
instance AttrInfo KeyEventStructLengthFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructLengthFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint KeyEventStructLengthFieldInfo = (~)Int32
    type AttrTransferType KeyEventStructLengthFieldInfo = Int32
    type AttrGetType KeyEventStructLengthFieldInfo = Int32
    type AttrLabel KeyEventStructLengthFieldInfo = "length"
    type AttrOrigin KeyEventStructLengthFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructLength
    attrSet = setKeyEventStructLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:length"
        })

keyEventStruct_length :: AttrLabelProxy "length"
keyEventStruct_length = AttrLabelProxy

#endif


-- | Get the value of the “@string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #string
-- @
getKeyEventStructString :: MonadIO m => KeyEventStruct -> m (Maybe T.Text)
getKeyEventStructString s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@string@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #string 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructString :: MonadIO m => KeyEventStruct -> CString -> m ()
setKeyEventStructString s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@string@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #string
-- @
clearKeyEventStructString :: MonadIO m => KeyEventStruct -> m ()
clearKeyEventStructString s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructStringFieldInfo
instance AttrInfo KeyEventStructStringFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructStringFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructStringFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint KeyEventStructStringFieldInfo = (~) CString
    type AttrTransferTypeConstraint KeyEventStructStringFieldInfo = (~)CString
    type AttrTransferType KeyEventStructStringFieldInfo = CString
    type AttrGetType KeyEventStructStringFieldInfo = Maybe T.Text
    type AttrLabel KeyEventStructStringFieldInfo = "string"
    type AttrOrigin KeyEventStructStringFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructString
    attrSet = setKeyEventStructString
    attrConstruct = undefined
    attrClear = clearKeyEventStructString
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.string"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:string"
        })

keyEventStruct_string :: AttrLabelProxy "string"
keyEventStruct_string = AttrLabelProxy

#endif


-- | Get the value of the “@keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #keycode
-- @
getKeyEventStructKeycode :: MonadIO m => KeyEventStruct -> m Word16
getKeyEventStructKeycode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word16
    return val

-- | Set the value of the “@keycode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #keycode 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructKeycode :: MonadIO m => KeyEventStruct -> Word16 -> m ()
setKeyEventStructKeycode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word16)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructKeycodeFieldInfo
instance AttrInfo KeyEventStructKeycodeFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructKeycodeFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructKeycodeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructKeycodeFieldInfo = (~) Word16
    type AttrTransferTypeConstraint KeyEventStructKeycodeFieldInfo = (~)Word16
    type AttrTransferType KeyEventStructKeycodeFieldInfo = Word16
    type AttrGetType KeyEventStructKeycodeFieldInfo = Word16
    type AttrLabel KeyEventStructKeycodeFieldInfo = "keycode"
    type AttrOrigin KeyEventStructKeycodeFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructKeycode
    attrSet = setKeyEventStructKeycode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.keycode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:keycode"
        })

keyEventStruct_keycode :: AttrLabelProxy "keycode"
keyEventStruct_keycode = AttrLabelProxy

#endif


-- | Get the value of the “@timestamp@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' keyEventStruct #timestamp
-- @
getKeyEventStructTimestamp :: MonadIO m => KeyEventStruct -> m Word32
getKeyEventStructTimestamp s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@timestamp@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' keyEventStruct [ #timestamp 'Data.GI.Base.Attributes.:=' value ]
-- @
setKeyEventStructTimestamp :: MonadIO m => KeyEventStruct -> Word32 -> m ()
setKeyEventStructTimestamp s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data KeyEventStructTimestampFieldInfo
instance AttrInfo KeyEventStructTimestampFieldInfo where
    type AttrBaseTypeConstraint KeyEventStructTimestampFieldInfo = (~) KeyEventStruct
    type AttrAllowedOps KeyEventStructTimestampFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint KeyEventStructTimestampFieldInfo = (~) Word32
    type AttrTransferTypeConstraint KeyEventStructTimestampFieldInfo = (~)Word32
    type AttrTransferType KeyEventStructTimestampFieldInfo = Word32
    type AttrGetType KeyEventStructTimestampFieldInfo = Word32
    type AttrLabel KeyEventStructTimestampFieldInfo = "timestamp"
    type AttrOrigin KeyEventStructTimestampFieldInfo = KeyEventStruct
    attrGet = getKeyEventStructTimestamp
    attrSet = setKeyEventStructTimestamp
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.KeyEventStruct.timestamp"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-KeyEventStruct.html#g:attr:timestamp"
        })

keyEventStruct_timestamp :: AttrLabelProxy "timestamp"
keyEventStruct_timestamp = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList KeyEventStruct
type instance O.AttributeList KeyEventStruct = KeyEventStructAttributeList
type KeyEventStructAttributeList = ('[ '("type", KeyEventStructTypeFieldInfo), '("state", KeyEventStructStateFieldInfo), '("keyval", KeyEventStructKeyvalFieldInfo), '("length", KeyEventStructLengthFieldInfo), '("string", KeyEventStructStringFieldInfo), '("keycode", KeyEventStructKeycodeFieldInfo), '("timestamp", KeyEventStructTimestampFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveKeyEventStructMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveKeyEventStructMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveKeyEventStructMethod t KeyEventStruct, O.OverloadedMethod info KeyEventStruct p) => OL.IsLabel t (KeyEventStruct -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveKeyEventStructMethod t KeyEventStruct, O.OverloadedMethod info KeyEventStruct p, R.HasField t KeyEventStruct p) => R.HasField t KeyEventStruct p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveKeyEventStructMethod t KeyEventStruct, O.OverloadedMethodInfo info KeyEventStruct) => OL.IsLabel t (O.MethodProxy info KeyEventStruct) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


