{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GCharsetConverter@ is an implementation of t'GI.Gio.Interfaces.Converter.Converter' based on
-- @/GLib.IConv/@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.CharsetConverter
    ( 

-- * Exported types
    CharsetConverter(..)                    ,
    IsCharsetConverter                      ,
    toCharsetConverter                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [convert]("GI.Gio.Interfaces.Converter#g:method:convert"), [convertBytes]("GI.Gio.Interfaces.Converter#g:method:convertBytes"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [init]("GI.Gio.Interfaces.Initable#g:method:init"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gio.Interfaces.Converter#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getNumFallbacks]("GI.Gio.Objects.CharsetConverter#g:method:getNumFallbacks"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getUseFallback]("GI.Gio.Objects.CharsetConverter#g:method:getUseFallback").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setUseFallback]("GI.Gio.Objects.CharsetConverter#g:method:setUseFallback").

#if defined(ENABLE_OVERLOADING)
    ResolveCharsetConverterMethod           ,
#endif

-- ** getNumFallbacks #method:getNumFallbacks#

#if defined(ENABLE_OVERLOADING)
    CharsetConverterGetNumFallbacksMethodInfo,
#endif
    charsetConverterGetNumFallbacks         ,


-- ** getUseFallback #method:getUseFallback#

#if defined(ENABLE_OVERLOADING)
    CharsetConverterGetUseFallbackMethodInfo,
#endif
    charsetConverterGetUseFallback          ,


-- ** new #method:new#

    charsetConverterNew                     ,


-- ** setUseFallback #method:setUseFallback#

#if defined(ENABLE_OVERLOADING)
    CharsetConverterSetUseFallbackMethodInfo,
#endif
    charsetConverterSetUseFallback          ,




 -- * Properties


-- ** fromCharset #attr:fromCharset#
-- | The character encoding to convert from.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    CharsetConverterFromCharsetPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    charsetConverterFromCharset             ,
#endif
    constructCharsetConverterFromCharset    ,
    getCharsetConverterFromCharset          ,


-- ** toCharset #attr:toCharset#
-- | The character encoding to convert to.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    CharsetConverterToCharsetPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    charsetConverterToCharset               ,
#endif
    constructCharsetConverterToCharset      ,
    getCharsetConverterToCharset            ,


-- ** useFallback #attr:useFallback#
-- | Use fallback (of form @\\\<hexval>@) for invalid bytes.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    CharsetConverterUseFallbackPropertyInfo ,
#endif
#if defined(ENABLE_OVERLOADING)
    charsetConverterUseFallback             ,
#endif
    constructCharsetConverterUseFallback    ,
    getCharsetConverterUseFallback          ,
    setCharsetConverterUseFallback          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable

#endif

-- | Memory-managed wrapper type.
newtype CharsetConverter = CharsetConverter (SP.ManagedPtr CharsetConverter)
    deriving (Eq)

instance SP.ManagedPtrNewtype CharsetConverter where
    toManagedPtr (CharsetConverter p) = p

foreign import ccall "g_charset_converter_get_type"
    c_g_charset_converter_get_type :: IO B.Types.GType

instance B.Types.TypedObject CharsetConverter where
    glibType = c_g_charset_converter_get_type

instance B.Types.GObject CharsetConverter

-- | Type class for types which can be safely cast to t'CharsetConverter', for instance with `toCharsetConverter`.
class (SP.GObject o, O.IsDescendantOf CharsetConverter o) => IsCharsetConverter o
instance (SP.GObject o, O.IsDescendantOf CharsetConverter o) => IsCharsetConverter o

instance O.HasParentTypes CharsetConverter
type instance O.ParentTypes CharsetConverter = '[GObject.Object.Object, Gio.Converter.Converter, Gio.Initable.Initable]

-- | Cast to t'CharsetConverter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCharsetConverter :: (MIO.MonadIO m, IsCharsetConverter o) => o -> m CharsetConverter
toCharsetConverter = MIO.liftIO . B.ManagedPtr.unsafeCastTo CharsetConverter

-- | Convert t'CharsetConverter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CharsetConverter) where
    gvalueGType_ = c_g_charset_converter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CharsetConverter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CharsetConverter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CharsetConverter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCharsetConverterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCharsetConverterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCharsetConverterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCharsetConverterMethod "convert" o = Gio.Converter.ConverterConvertMethodInfo
    ResolveCharsetConverterMethod "convertBytes" o = Gio.Converter.ConverterConvertBytesMethodInfo
    ResolveCharsetConverterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCharsetConverterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCharsetConverterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCharsetConverterMethod "init" o = Gio.Initable.InitableInitMethodInfo
    ResolveCharsetConverterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCharsetConverterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCharsetConverterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCharsetConverterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCharsetConverterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCharsetConverterMethod "reset" o = Gio.Converter.ConverterResetMethodInfo
    ResolveCharsetConverterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCharsetConverterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCharsetConverterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCharsetConverterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCharsetConverterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCharsetConverterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCharsetConverterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCharsetConverterMethod "getNumFallbacks" o = CharsetConverterGetNumFallbacksMethodInfo
    ResolveCharsetConverterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCharsetConverterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCharsetConverterMethod "getUseFallback" o = CharsetConverterGetUseFallbackMethodInfo
    ResolveCharsetConverterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCharsetConverterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCharsetConverterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCharsetConverterMethod "setUseFallback" o = CharsetConverterSetUseFallbackMethodInfo
    ResolveCharsetConverterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCharsetConverterMethod t CharsetConverter, O.OverloadedMethod info CharsetConverter p) => OL.IsLabel t (CharsetConverter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCharsetConverterMethod t CharsetConverter, O.OverloadedMethod info CharsetConverter p, R.HasField t CharsetConverter p) => R.HasField t CharsetConverter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCharsetConverterMethod t CharsetConverter, O.OverloadedMethodInfo info CharsetConverter) => OL.IsLabel t (O.MethodProxy info CharsetConverter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "from-charset"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@from-charset@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' charsetConverter #fromCharset
-- @
getCharsetConverterFromCharset :: (MonadIO m, IsCharsetConverter o) => o -> m (Maybe T.Text)
getCharsetConverterFromCharset obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "from-charset"

-- | Construct a t'GValueConstruct' with valid value for the “@from-charset@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCharsetConverterFromCharset :: (IsCharsetConverter o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructCharsetConverterFromCharset val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "from-charset" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data CharsetConverterFromCharsetPropertyInfo
instance AttrInfo CharsetConverterFromCharsetPropertyInfo where
    type AttrAllowedOps CharsetConverterFromCharsetPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CharsetConverterFromCharsetPropertyInfo = IsCharsetConverter
    type AttrSetTypeConstraint CharsetConverterFromCharsetPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint CharsetConverterFromCharsetPropertyInfo = (~) T.Text
    type AttrTransferType CharsetConverterFromCharsetPropertyInfo = T.Text
    type AttrGetType CharsetConverterFromCharsetPropertyInfo = (Maybe T.Text)
    type AttrLabel CharsetConverterFromCharsetPropertyInfo = "from-charset"
    type AttrOrigin CharsetConverterFromCharsetPropertyInfo = CharsetConverter
    attrGet = getCharsetConverterFromCharset
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructCharsetConverterFromCharset
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.fromCharset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#g:attr:fromCharset"
        })
#endif

-- VVV Prop "to-charset"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@to-charset@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' charsetConverter #toCharset
-- @
getCharsetConverterToCharset :: (MonadIO m, IsCharsetConverter o) => o -> m (Maybe T.Text)
getCharsetConverterToCharset obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "to-charset"

-- | Construct a t'GValueConstruct' with valid value for the “@to-charset@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCharsetConverterToCharset :: (IsCharsetConverter o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructCharsetConverterToCharset val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "to-charset" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data CharsetConverterToCharsetPropertyInfo
instance AttrInfo CharsetConverterToCharsetPropertyInfo where
    type AttrAllowedOps CharsetConverterToCharsetPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CharsetConverterToCharsetPropertyInfo = IsCharsetConverter
    type AttrSetTypeConstraint CharsetConverterToCharsetPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint CharsetConverterToCharsetPropertyInfo = (~) T.Text
    type AttrTransferType CharsetConverterToCharsetPropertyInfo = T.Text
    type AttrGetType CharsetConverterToCharsetPropertyInfo = (Maybe T.Text)
    type AttrLabel CharsetConverterToCharsetPropertyInfo = "to-charset"
    type AttrOrigin CharsetConverterToCharsetPropertyInfo = CharsetConverter
    attrGet = getCharsetConverterToCharset
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructCharsetConverterToCharset
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.toCharset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#g:attr:toCharset"
        })
#endif

-- VVV Prop "use-fallback"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' charsetConverter #useFallback
-- @
getCharsetConverterUseFallback :: (MonadIO m, IsCharsetConverter o) => o -> m Bool
getCharsetConverterUseFallback obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-fallback"

-- | Set the value of the “@use-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' charsetConverter [ #useFallback 'Data.GI.Base.Attributes.:=' value ]
-- @
setCharsetConverterUseFallback :: (MonadIO m, IsCharsetConverter o) => o -> Bool -> m ()
setCharsetConverterUseFallback obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-fallback" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-fallback@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCharsetConverterUseFallback :: (IsCharsetConverter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCharsetConverterUseFallback val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-fallback" val

#if defined(ENABLE_OVERLOADING)
data CharsetConverterUseFallbackPropertyInfo
instance AttrInfo CharsetConverterUseFallbackPropertyInfo where
    type AttrAllowedOps CharsetConverterUseFallbackPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CharsetConverterUseFallbackPropertyInfo = IsCharsetConverter
    type AttrSetTypeConstraint CharsetConverterUseFallbackPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CharsetConverterUseFallbackPropertyInfo = (~) Bool
    type AttrTransferType CharsetConverterUseFallbackPropertyInfo = Bool
    type AttrGetType CharsetConverterUseFallbackPropertyInfo = Bool
    type AttrLabel CharsetConverterUseFallbackPropertyInfo = "use-fallback"
    type AttrOrigin CharsetConverterUseFallbackPropertyInfo = CharsetConverter
    attrGet = getCharsetConverterUseFallback
    attrSet = setCharsetConverterUseFallback
    attrTransfer _ v = do
        return v
    attrConstruct = constructCharsetConverterUseFallback
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.useFallback"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#g:attr:useFallback"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CharsetConverter
type instance O.AttributeList CharsetConverter = CharsetConverterAttributeList
type CharsetConverterAttributeList = ('[ '("fromCharset", CharsetConverterFromCharsetPropertyInfo), '("toCharset", CharsetConverterToCharsetPropertyInfo), '("useFallback", CharsetConverterUseFallbackPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
charsetConverterFromCharset :: AttrLabelProxy "fromCharset"
charsetConverterFromCharset = AttrLabelProxy

charsetConverterToCharset :: AttrLabelProxy "toCharset"
charsetConverterToCharset = AttrLabelProxy

charsetConverterUseFallback :: AttrLabelProxy "useFallback"
charsetConverterUseFallback = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CharsetConverter = CharsetConverterSignalList
type CharsetConverterSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CharsetConverter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "to_charset"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destination charset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "from_charset"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source charset" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "CharsetConverter" })
-- throws : True
-- Skip return : False

foreign import ccall "g_charset_converter_new" g_charset_converter_new :: 
    CString ->                              -- to_charset : TBasicType TUTF8
    CString ->                              -- from_charset : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CharsetConverter)

-- | Creates a new t'GI.Gio.Objects.CharsetConverter.CharsetConverter'.
-- 
-- /Since: 2.24/
charsetConverterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@toCharset@/: destination charset
    -> T.Text
    -- ^ /@fromCharset@/: source charset
    -> m CharsetConverter
    -- ^ __Returns:__ a new t'GI.Gio.Objects.CharsetConverter.CharsetConverter' or 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
charsetConverterNew toCharset fromCharset = liftIO $ do
    toCharset' <- textToCString toCharset
    fromCharset' <- textToCString fromCharset
    onException (do
        result <- propagateGError $ g_charset_converter_new toCharset' fromCharset'
        checkUnexpectedReturnNULL "charsetConverterNew" result
        result' <- (wrapObject CharsetConverter) result
        freeMem toCharset'
        freeMem fromCharset'
        return result'
     ) (do
        freeMem toCharset'
        freeMem fromCharset'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method CharsetConverter::get_num_fallbacks
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "converter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "CharsetConverter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCharsetConverter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_charset_converter_get_num_fallbacks" g_charset_converter_get_num_fallbacks :: 
    Ptr CharsetConverter ->                 -- converter : TInterface (Name {namespace = "Gio", name = "CharsetConverter"})
    IO Word32

-- | Gets the number of fallbacks that /@converter@/ has applied so far.
-- 
-- /Since: 2.24/
charsetConverterGetNumFallbacks ::
    (B.CallStack.HasCallStack, MonadIO m, IsCharsetConverter a) =>
    a
    -- ^ /@converter@/: a t'GI.Gio.Objects.CharsetConverter.CharsetConverter'
    -> m Word32
    -- ^ __Returns:__ the number of fallbacks that /@converter@/ has applied
charsetConverterGetNumFallbacks converter = liftIO $ do
    converter' <- unsafeManagedPtrCastPtr converter
    result <- g_charset_converter_get_num_fallbacks converter'
    touchManagedPtr converter
    return result

#if defined(ENABLE_OVERLOADING)
data CharsetConverterGetNumFallbacksMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsCharsetConverter a) => O.OverloadedMethod CharsetConverterGetNumFallbacksMethodInfo a signature where
    overloadedMethod = charsetConverterGetNumFallbacks

instance O.OverloadedMethodInfo CharsetConverterGetNumFallbacksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.charsetConverterGetNumFallbacks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#v:charsetConverterGetNumFallbacks"
        })


#endif

-- method CharsetConverter::get_use_fallback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "converter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "CharsetConverter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCharsetConverter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_charset_converter_get_use_fallback" g_charset_converter_get_use_fallback :: 
    Ptr CharsetConverter ->                 -- converter : TInterface (Name {namespace = "Gio", name = "CharsetConverter"})
    IO CInt

-- | Gets the [CharsetConverter:useFallback]("GI.Gio.Objects.CharsetConverter#g:attr:useFallback") property.
-- 
-- /Since: 2.24/
charsetConverterGetUseFallback ::
    (B.CallStack.HasCallStack, MonadIO m, IsCharsetConverter a) =>
    a
    -- ^ /@converter@/: a t'GI.Gio.Objects.CharsetConverter.CharsetConverter'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if fallbacks are used by /@converter@/
charsetConverterGetUseFallback converter = liftIO $ do
    converter' <- unsafeManagedPtrCastPtr converter
    result <- g_charset_converter_get_use_fallback converter'
    let result' = (/= 0) result
    touchManagedPtr converter
    return result'

#if defined(ENABLE_OVERLOADING)
data CharsetConverterGetUseFallbackMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCharsetConverter a) => O.OverloadedMethod CharsetConverterGetUseFallbackMethodInfo a signature where
    overloadedMethod = charsetConverterGetUseFallback

instance O.OverloadedMethodInfo CharsetConverterGetUseFallbackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.charsetConverterGetUseFallback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#v:charsetConverterGetUseFallback"
        })


#endif

-- method CharsetConverter::set_use_fallback
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "converter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "CharsetConverter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCharsetConverter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_fallback"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to use fallbacks"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_charset_converter_set_use_fallback" g_charset_converter_set_use_fallback :: 
    Ptr CharsetConverter ->                 -- converter : TInterface (Name {namespace = "Gio", name = "CharsetConverter"})
    CInt ->                                 -- use_fallback : TBasicType TBoolean
    IO ()

-- | Sets the [CharsetConverter:useFallback]("GI.Gio.Objects.CharsetConverter#g:attr:useFallback") property.
-- 
-- /Since: 2.24/
charsetConverterSetUseFallback ::
    (B.CallStack.HasCallStack, MonadIO m, IsCharsetConverter a) =>
    a
    -- ^ /@converter@/: a t'GI.Gio.Objects.CharsetConverter.CharsetConverter'
    -> Bool
    -- ^ /@useFallback@/: 'P.True' to use fallbacks
    -> m ()
charsetConverterSetUseFallback converter useFallback = liftIO $ do
    converter' <- unsafeManagedPtrCastPtr converter
    let useFallback' = (P.fromIntegral . P.fromEnum) useFallback
    g_charset_converter_set_use_fallback converter' useFallback'
    touchManagedPtr converter
    return ()

#if defined(ENABLE_OVERLOADING)
data CharsetConverterSetUseFallbackMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCharsetConverter a) => O.OverloadedMethod CharsetConverterSetUseFallbackMethodInfo a signature where
    overloadedMethod = charsetConverterSetUseFallback

instance O.OverloadedMethodInfo CharsetConverterSetUseFallbackMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.CharsetConverter.charsetConverterSetUseFallback",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-CharsetConverter.html#v:charsetConverterSetUseFallback"
        })


#endif


