{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque type which identifies a specific node in a t'GI.GLib.Structs.Tree.Tree'.
-- 
-- /Since: 2.68/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TreeNode
    ( 

-- * Exported types
    TreeNode(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [key]("GI.GLib.Structs.TreeNode#g:method:key"), [next]("GI.GLib.Structs.TreeNode#g:method:next"), [previous]("GI.GLib.Structs.TreeNode#g:method:previous"), [value]("GI.GLib.Structs.TreeNode#g:method:value").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTreeNodeMethod                   ,
#endif

-- ** key #method:key#

#if defined(ENABLE_OVERLOADING)
    TreeNodeKeyMethodInfo                   ,
#endif
    treeNodeKey                             ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    TreeNodeNextMethodInfo                  ,
#endif
    treeNodeNext                            ,


-- ** previous #method:previous#

#if defined(ENABLE_OVERLOADING)
    TreeNodePreviousMethodInfo              ,
#endif
    treeNodePrevious                        ,


-- ** value #method:value#

#if defined(ENABLE_OVERLOADING)
    TreeNodeValueMethodInfo                 ,
#endif
    treeNodeValue                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TreeNode = TreeNode (SP.ManagedPtr TreeNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype TreeNode where
    toManagedPtr (TreeNode p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TreeNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TreeNode
type instance O.AttributeList TreeNode = TreeNodeAttributeList
type TreeNodeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TreeNode::key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TreeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_key" g_tree_node_key :: 
    Ptr TreeNode ->                         -- node : TInterface (Name {namespace = "GLib", name = "TreeNode"})
    IO (Ptr ())

-- | Gets the key stored at a particular tree node.
-- 
-- /Since: 2.68/
treeNodeKey ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.Tree.Tree' node
    -> m (Ptr ())
    -- ^ __Returns:__ the key at the node.
treeNodeKey node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_tree_node_key node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data TreeNodeKeyMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod TreeNodeKeyMethodInfo TreeNode signature where
    overloadedMethod = treeNodeKey

instance O.OverloadedMethodInfo TreeNodeKeyMethodInfo TreeNode where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TreeNode.treeNodeKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TreeNode.html#v:treeNodeKey"
        })


#endif

-- method TreeNode::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TreeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_next" g_tree_node_next :: 
    Ptr TreeNode ->                         -- node : TInterface (Name {namespace = "GLib", name = "TreeNode"})
    IO (Ptr TreeNode)

-- | Returns the next in-order node of the tree, or 'P.Nothing'
-- if the passed node was already the last one.
-- 
-- /Since: 2.68/
treeNodeNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.Tree.Tree' node
    -> m (Maybe TreeNode)
    -- ^ __Returns:__ the next node in the tree
treeNodeNext node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_tree_node_next node'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TreeNode) result'
        return result''
    touchManagedPtr node
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeNodeNextMethodInfo
instance (signature ~ (m (Maybe TreeNode)), MonadIO m) => O.OverloadedMethod TreeNodeNextMethodInfo TreeNode signature where
    overloadedMethod = treeNodeNext

instance O.OverloadedMethodInfo TreeNodeNextMethodInfo TreeNode where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TreeNode.treeNodeNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TreeNode.html#v:treeNodeNext"
        })


#endif

-- method TreeNode::previous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TreeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "TreeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_previous" g_tree_node_previous :: 
    Ptr TreeNode ->                         -- node : TInterface (Name {namespace = "GLib", name = "TreeNode"})
    IO (Ptr TreeNode)

-- | Returns the previous in-order node of the tree, or 'P.Nothing'
-- if the passed node was already the first one.
-- 
-- /Since: 2.68/
treeNodePrevious ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.Tree.Tree' node
    -> m (Maybe TreeNode)
    -- ^ __Returns:__ the previous node in the tree
treeNodePrevious node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_tree_node_previous node'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr TreeNode) result'
        return result''
    touchManagedPtr node
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeNodePreviousMethodInfo
instance (signature ~ (m (Maybe TreeNode)), MonadIO m) => O.OverloadedMethod TreeNodePreviousMethodInfo TreeNode signature where
    overloadedMethod = treeNodePrevious

instance O.OverloadedMethodInfo TreeNodePreviousMethodInfo TreeNode where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TreeNode.treeNodePrevious",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TreeNode.html#v:treeNodePrevious"
        })


#endif

-- method TreeNode::value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TreeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_tree_node_value" g_tree_node_value :: 
    Ptr TreeNode ->                         -- node : TInterface (Name {namespace = "GLib", name = "TreeNode"})
    IO (Ptr ())

-- | Gets the value stored at a particular tree node.
-- 
-- /Since: 2.68/
treeNodeValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.Tree.Tree' node
    -> m (Ptr ())
    -- ^ __Returns:__ the value at the node.
treeNodeValue node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_tree_node_value node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data TreeNodeValueMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod TreeNodeValueMethodInfo TreeNode signature where
    overloadedMethod = treeNodeValue

instance O.OverloadedMethodInfo TreeNodeValueMethodInfo TreeNode where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TreeNode.treeNodeValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-TreeNode.html#v:treeNodeValue"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTreeNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTreeNodeMethod "key" o = TreeNodeKeyMethodInfo
    ResolveTreeNodeMethod "next" o = TreeNodeNextMethodInfo
    ResolveTreeNodeMethod "previous" o = TreeNodePreviousMethodInfo
    ResolveTreeNodeMethod "value" o = TreeNodeValueMethodInfo
    ResolveTreeNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTreeNodeMethod t TreeNode, O.OverloadedMethod info TreeNode p) => OL.IsLabel t (TreeNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTreeNodeMethod t TreeNode, O.OverloadedMethod info TreeNode p, R.HasField t TreeNode p) => R.HasField t TreeNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTreeNodeMethod t TreeNode, O.OverloadedMethodInfo info TreeNode) => OL.IsLabel t (O.MethodProxy info TreeNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


