{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GValueArray@ is a container structure to hold an array of generic values.
-- 
-- The prime purpose of a @GValueArray@ is for it to be used as an
-- object property that holds an array of values. A @GValueArray@ wraps
-- an array of @GValue@ elements in order for it to be used as a boxed
-- type through @G_TYPE_VALUE_ARRAY@.
-- 
-- @GValueArray@ is deprecated in favour of @GArray@ since GLib 2.32.
-- It is possible to create a @GArray@ that behaves like a @GValueArray@
-- by using the size of @GValue@ as the element size, and by setting
-- 'GI.GObject.Structs.Value.valueUnset' as the clear function using
-- t'GI.GLib.Structs.Array.Array'.@/set_clear_func/@(), for instance, the following code:
-- 
-- 
-- === /c code/
-- >  GValueArray *array = g_value_array_new (10);
-- 
-- 
-- can be replaced by:
-- 
-- 
-- === /c code/
-- >  GArray *array = g_array_sized_new (FALSE, TRUE, sizeof (GValue), 10);
-- >  g_array_set_clear_func (array, (GDestroyNotify) g_value_unset);
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.ValueArray
    ( 

-- * Exported types
    ValueArray(..)                          ,
    newZeroValueArray                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.GObject.Structs.ValueArray#g:method:append"), [copy]("GI.GObject.Structs.ValueArray#g:method:copy"), [insert]("GI.GObject.Structs.ValueArray#g:method:insert"), [prepend]("GI.GObject.Structs.ValueArray#g:method:prepend"), [remove]("GI.GObject.Structs.ValueArray#g:method:remove"), [sort]("GI.GObject.Structs.ValueArray#g:method:sort").
-- 
-- ==== Getters
-- [getNth]("GI.GObject.Structs.ValueArray#g:method:getNth").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveValueArrayMethod                 ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    ValueArrayAppendMethodInfo              ,
#endif
    valueArrayAppend                        ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    ValueArrayCopyMethodInfo                ,
#endif
    valueArrayCopy                          ,


-- ** getNth #method:getNth#

#if defined(ENABLE_OVERLOADING)
    ValueArrayGetNthMethodInfo              ,
#endif
    valueArrayGetNth                        ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    ValueArrayInsertMethodInfo              ,
#endif
    valueArrayInsert                        ,


-- ** new #method:new#

    valueArrayNew                           ,


-- ** prepend #method:prepend#

#if defined(ENABLE_OVERLOADING)
    ValueArrayPrependMethodInfo             ,
#endif
    valueArrayPrepend                       ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    ValueArrayRemoveMethodInfo              ,
#endif
    valueArrayRemove                        ,


-- ** sort #method:sort#

#if defined(ENABLE_OVERLOADING)
    ValueArraySortMethodInfo                ,
#endif
    valueArraySort                          ,




 -- * Properties


-- ** nValues #attr:nValues#
-- | number of values contained in the array

    getValueArrayNValues                    ,
    setValueArrayNValues                    ,
#if defined(ENABLE_OVERLOADING)
    valueArray_nValues                      ,
#endif


-- ** values #attr:values#
-- | array of values

    clearValueArrayValues                   ,
    getValueArrayValues                     ,
    setValueArrayValues                     ,
#if defined(ENABLE_OVERLOADING)
    valueArray_values                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ValueArray = ValueArray (SP.ManagedPtr ValueArray)
    deriving (Eq)

instance SP.ManagedPtrNewtype ValueArray where
    toManagedPtr (ValueArray p) = p

foreign import ccall "g_value_array_get_type" c_g_value_array_get_type :: 
    IO GType

type instance O.ParentTypes ValueArray = '[]
instance O.HasParentTypes ValueArray

instance B.Types.TypedObject ValueArray where
    glibType = c_g_value_array_get_type

instance B.Types.GBoxed ValueArray

-- | Convert t'ValueArray' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ValueArray) where
    gvalueGType_ = c_g_value_array_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ValueArray)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ValueArray)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ValueArray ptr
        else return P.Nothing
        
    

-- | Construct a t'ValueArray' struct initialized to zero.
newZeroValueArray :: MonadIO m => m ValueArray
newZeroValueArray = liftIO $ callocBoxedBytes 24 >>= wrapBoxed ValueArray

instance tag ~ 'AttrSet => Constructible ValueArray tag where
    new _ attrs = do
        o <- newZeroValueArray
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' valueArray #nValues
-- @
getValueArrayNValues :: MonadIO m => ValueArray -> m Word32
getValueArrayNValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@n_values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' valueArray [ #nValues 'Data.GI.Base.Attributes.:=' value ]
-- @
setValueArrayNValues :: MonadIO m => ValueArray -> Word32 -> m ()
setValueArrayNValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data ValueArrayNValuesFieldInfo
instance AttrInfo ValueArrayNValuesFieldInfo where
    type AttrBaseTypeConstraint ValueArrayNValuesFieldInfo = (~) ValueArray
    type AttrAllowedOps ValueArrayNValuesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ValueArrayNValuesFieldInfo = (~) Word32
    type AttrTransferTypeConstraint ValueArrayNValuesFieldInfo = (~)Word32
    type AttrTransferType ValueArrayNValuesFieldInfo = Word32
    type AttrGetType ValueArrayNValuesFieldInfo = Word32
    type AttrLabel ValueArrayNValuesFieldInfo = "n_values"
    type AttrOrigin ValueArrayNValuesFieldInfo = ValueArray
    attrGet = getValueArrayNValues
    attrSet = setValueArrayNValues
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.nValues"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#g:attr:nValues"
        })

valueArray_nValues :: AttrLabelProxy "nValues"
valueArray_nValues = AttrLabelProxy

#endif


-- | Get the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' valueArray #values
-- @
getValueArrayValues :: MonadIO m => ValueArray -> m (Maybe GValue)
getValueArrayValues s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr GValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GValue.newGValueFromPtr val'
        return val''
    return result

-- | Set the value of the “@values@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' valueArray [ #values 'Data.GI.Base.Attributes.:=' value ]
-- @
setValueArrayValues :: MonadIO m => ValueArray -> Ptr GValue -> m ()
setValueArrayValues s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr GValue)

-- | Set the value of the “@values@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #values
-- @
clearValueArrayValues :: MonadIO m => ValueArray -> m ()
clearValueArrayValues s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr GValue)

#if defined(ENABLE_OVERLOADING)
data ValueArrayValuesFieldInfo
instance AttrInfo ValueArrayValuesFieldInfo where
    type AttrBaseTypeConstraint ValueArrayValuesFieldInfo = (~) ValueArray
    type AttrAllowedOps ValueArrayValuesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ValueArrayValuesFieldInfo = (~) (Ptr GValue)
    type AttrTransferTypeConstraint ValueArrayValuesFieldInfo = (~)(Ptr GValue)
    type AttrTransferType ValueArrayValuesFieldInfo = (Ptr GValue)
    type AttrGetType ValueArrayValuesFieldInfo = Maybe GValue
    type AttrLabel ValueArrayValuesFieldInfo = "values"
    type AttrOrigin ValueArrayValuesFieldInfo = ValueArray
    attrGet = getValueArrayValues
    attrSet = setValueArrayValues
    attrConstruct = undefined
    attrClear = clearValueArrayValues
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.values"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#g:attr:values"
        })

valueArray_values :: AttrLabelProxy "values"
valueArray_values = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ValueArray
type instance O.AttributeList ValueArray = ValueArrayAttributeList
type ValueArrayAttributeList = ('[ '("nValues", ValueArrayNValuesFieldInfo), '("values", ValueArrayValuesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method ValueArray::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "n_prealloced"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of values to preallocate space for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_new" g_value_array_new :: 
    Word32 ->                               -- n_prealloced : TBasicType TUInt
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayNew ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_sized_new()/@ instead."] #-}
-- | Allocate and initialize a new t'GI.GObject.Structs.ValueArray.ValueArray', optionally preserve space
-- for /@nPrealloced@/ elements. New arrays always contain 0 elements,
-- regardless of the value of /@nPrealloced@/.
valueArrayNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@nPrealloced@/: number of values to preallocate space for
    -> m ValueArray
    -- ^ __Returns:__ a newly allocated t'GI.GObject.Structs.ValueArray.ValueArray' with 0 values
valueArrayNew nPrealloced = liftIO $ do
    result <- g_value_array_new nPrealloced
    checkUnexpectedReturnNULL "valueArrayNew" result
    result' <- (wrapBoxed ValueArray) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ValueArray::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to add an element to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValue to copy into #GValueArray, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_append" g_value_array_append :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayAppend ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_append_val()/@ instead."] #-}
-- | Insert a copy of /@value@/ as last element of /@valueArray@/. If /@value@/ is
-- 'P.Nothing', an uninitialized value is appended.
valueArrayAppend ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to add an element to
    -> Maybe (GValue)
    -- ^ /@value@/: t'GI.GObject.Structs.Value.Value' to copy into t'GI.GObject.Structs.ValueArray.ValueArray', or 'P.Nothing'
    -> m ValueArray
    -- ^ __Returns:__ the t'GI.GObject.Structs.ValueArray.ValueArray' passed in as /@valueArray@/
valueArrayAppend valueArray value = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- unsafeManagedPtrGetPtr jValue
            return jValue'
    result <- g_value_array_append valueArray' maybeValue
    checkUnexpectedReturnNULL "valueArrayAppend" result
    result' <- (newBoxed ValueArray) result
    touchManagedPtr valueArray
    whenJust value touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayAppendMethodInfo
instance (signature ~ (Maybe (GValue) -> m ValueArray), MonadIO m) => O.OverloadedMethod ValueArrayAppendMethodInfo ValueArray signature where
    overloadedMethod = valueArrayAppend

instance O.OverloadedMethodInfo ValueArrayAppendMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayAppend"
        })


#endif

-- method ValueArray::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_copy" g_value_array_copy :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayCopy ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_ref()/@ instead."] #-}
-- | Construct an exact copy of a t'GI.GObject.Structs.ValueArray.ValueArray' by duplicating all its
-- contents.
valueArrayCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to copy
    -> m ValueArray
    -- ^ __Returns:__ Newly allocated copy of t'GI.GObject.Structs.ValueArray.ValueArray'
valueArrayCopy valueArray = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    result <- g_value_array_copy valueArray'
    checkUnexpectedReturnNULL "valueArrayCopy" result
    result' <- (wrapBoxed ValueArray) result
    touchManagedPtr valueArray
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayCopyMethodInfo
instance (signature ~ (m ValueArray), MonadIO m) => O.OverloadedMethod ValueArrayCopyMethodInfo ValueArray signature where
    overloadedMethod = valueArrayCopy

instance O.OverloadedMethodInfo ValueArrayCopyMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayCopy"
        })


#endif

-- method ValueArray::get_nth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to get a value from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the value of interest"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TGValue
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_get_nth" g_value_array_get_nth :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    Word32 ->                               -- index_ : TBasicType TUInt
    IO (Ptr GValue)

{-# DEPRECATED valueArrayGetNth ["(Since version 2.32)","Use @/g_array_index()/@ instead."] #-}
-- | Return a pointer to the value at /@index_@/ contained in /@valueArray@/.
valueArrayGetNth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to get a value from
    -> Word32
    -- ^ /@index_@/: index of the value of interest
    -> m GValue
    -- ^ __Returns:__ pointer to a value at /@index_@/ in /@valueArray@/
valueArrayGetNth valueArray index_ = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    result <- g_value_array_get_nth valueArray' index_
    checkUnexpectedReturnNULL "valueArrayGetNth" result
    result' <- B.GValue.newGValueFromPtr result
    touchManagedPtr valueArray
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayGetNthMethodInfo
instance (signature ~ (Word32 -> m GValue), MonadIO m) => O.OverloadedMethod ValueArrayGetNthMethodInfo ValueArray signature where
    overloadedMethod = valueArrayGetNth

instance O.OverloadedMethodInfo ValueArrayGetNthMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayGetNth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayGetNth"
        })


#endif

-- method ValueArray::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to add an element to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "insertion position, must be <= value_array->;n_values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValue to copy into #GValueArray, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_insert" g_value_array_insert :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    Word32 ->                               -- index_ : TBasicType TUInt
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayInsert ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_insert_val()/@ instead."] #-}
-- | Insert a copy of /@value@/ at specified position into /@valueArray@/. If /@value@/
-- is 'P.Nothing', an uninitialized value is inserted.
valueArrayInsert ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to add an element to
    -> Word32
    -- ^ /@index_@/: insertion position, must be \<= value_array->;n_values
    -> Maybe (GValue)
    -- ^ /@value@/: t'GI.GObject.Structs.Value.Value' to copy into t'GI.GObject.Structs.ValueArray.ValueArray', or 'P.Nothing'
    -> m ValueArray
    -- ^ __Returns:__ the t'GI.GObject.Structs.ValueArray.ValueArray' passed in as /@valueArray@/
valueArrayInsert valueArray index_ value = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- unsafeManagedPtrGetPtr jValue
            return jValue'
    result <- g_value_array_insert valueArray' index_ maybeValue
    checkUnexpectedReturnNULL "valueArrayInsert" result
    result' <- (newBoxed ValueArray) result
    touchManagedPtr valueArray
    whenJust value touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayInsertMethodInfo
instance (signature ~ (Word32 -> Maybe (GValue) -> m ValueArray), MonadIO m) => O.OverloadedMethod ValueArrayInsertMethodInfo ValueArray signature where
    overloadedMethod = valueArrayInsert

instance O.OverloadedMethodInfo ValueArrayInsertMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayInsert"
        })


#endif

-- method ValueArray::prepend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to add an element to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValue to copy into #GValueArray, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_prepend" g_value_array_prepend :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayPrepend ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_prepend_val()/@ instead."] #-}
-- | Insert a copy of /@value@/ as first element of /@valueArray@/. If /@value@/ is
-- 'P.Nothing', an uninitialized value is prepended.
valueArrayPrepend ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to add an element to
    -> Maybe (GValue)
    -- ^ /@value@/: t'GI.GObject.Structs.Value.Value' to copy into t'GI.GObject.Structs.ValueArray.ValueArray', or 'P.Nothing'
    -> m ValueArray
    -- ^ __Returns:__ the t'GI.GObject.Structs.ValueArray.ValueArray' passed in as /@valueArray@/
valueArrayPrepend valueArray value = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- unsafeManagedPtrGetPtr jValue
            return jValue'
    result <- g_value_array_prepend valueArray' maybeValue
    checkUnexpectedReturnNULL "valueArrayPrepend" result
    result' <- (newBoxed ValueArray) result
    touchManagedPtr valueArray
    whenJust value touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayPrependMethodInfo
instance (signature ~ (Maybe (GValue) -> m ValueArray), MonadIO m) => O.OverloadedMethod ValueArrayPrependMethodInfo ValueArray signature where
    overloadedMethod = valueArrayPrepend

instance O.OverloadedMethodInfo ValueArrayPrependMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayPrepend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayPrepend"
        })


#endif

-- method ValueArray::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to remove an element from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "position of value to remove, which must be less than\n    @value_array->n_values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_remove" g_value_array_remove :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    Word32 ->                               -- index_ : TBasicType TUInt
    IO (Ptr ValueArray)

{-# DEPRECATED valueArrayRemove ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_remove_index()/@ instead."] #-}
-- | Remove the value at position /@index_@/ from /@valueArray@/.
valueArrayRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to remove an element from
    -> Word32
    -- ^ /@index_@/: position of value to remove, which must be less than
    --     /@valueArray@/->n_values
    -> m ValueArray
    -- ^ __Returns:__ the t'GI.GObject.Structs.ValueArray.ValueArray' passed in as /@valueArray@/
valueArrayRemove valueArray index_ = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    result <- g_value_array_remove valueArray' index_
    checkUnexpectedReturnNULL "valueArrayRemove" result
    result' <- (newBoxed ValueArray) result
    touchManagedPtr valueArray
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArrayRemoveMethodInfo
instance (signature ~ (Word32 -> m ValueArray), MonadIO m) => O.OverloadedMethod ValueArrayRemoveMethodInfo ValueArray signature where
    overloadedMethod = valueArrayRemove

instance O.OverloadedMethodInfo ValueArrayRemoveMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArrayRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArrayRemove"
        })


#endif

-- method ValueArray::sort
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "value_array"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ValueArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValueArray to sort"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "compare_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to compare elements"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "extra data argument provided for @compare_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "ValueArray" })
-- throws : False
-- Skip return : False

foreign import ccall "g_value_array_sort_with_data" g_value_array_sort_with_data :: 
    Ptr ValueArray ->                       -- value_array : TInterface (Name {namespace = "GObject", name = "ValueArray"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- compare_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr ValueArray)

{-# DEPRECATED valueArraySort ["(Since version 2.32)","Use t'GI.GLib.Structs.Array.Array' and @/g_array_sort_with_data()/@."] #-}
-- | Sort /@valueArray@/ using /@compareFunc@/ to compare the elements according
-- to the semantics of t'GI.GLib.Callbacks.CompareDataFunc'.
-- 
-- The current implementation uses the same sorting algorithm as standard
-- C @/qsort()/@ function.
valueArraySort ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ValueArray
    -- ^ /@valueArray@/: t'GI.GObject.Structs.ValueArray.ValueArray' to sort
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@compareFunc@/: function to compare elements
    -> m ValueArray
    -- ^ __Returns:__ the t'GI.GObject.Structs.ValueArray.ValueArray' passed in as /@valueArray@/
valueArraySort valueArray compareFunc = liftIO $ do
    valueArray' <- unsafeManagedPtrGetPtr valueArray
    compareFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc compareFunc))
    let userData = nullPtr
    result <- g_value_array_sort_with_data valueArray' compareFunc' userData
    checkUnexpectedReturnNULL "valueArraySort" result
    result' <- (newBoxed ValueArray) result
    safeFreeFunPtr $ castFunPtrToPtr compareFunc'
    touchManagedPtr valueArray
    return result'

#if defined(ENABLE_OVERLOADING)
data ValueArraySortMethodInfo
instance (signature ~ (GLib.Callbacks.CompareDataFunc -> m ValueArray), MonadIO m) => O.OverloadedMethod ValueArraySortMethodInfo ValueArray signature where
    overloadedMethod = valueArraySort

instance O.OverloadedMethodInfo ValueArraySortMethodInfo ValueArray where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.ValueArray.valueArraySort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-ValueArray.html#v:valueArraySort"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveValueArrayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveValueArrayMethod "append" o = ValueArrayAppendMethodInfo
    ResolveValueArrayMethod "copy" o = ValueArrayCopyMethodInfo
    ResolveValueArrayMethod "insert" o = ValueArrayInsertMethodInfo
    ResolveValueArrayMethod "prepend" o = ValueArrayPrependMethodInfo
    ResolveValueArrayMethod "remove" o = ValueArrayRemoveMethodInfo
    ResolveValueArrayMethod "sort" o = ValueArraySortMethodInfo
    ResolveValueArrayMethod "getNth" o = ValueArrayGetNthMethodInfo
    ResolveValueArrayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveValueArrayMethod t ValueArray, O.OverloadedMethod info ValueArray p) => OL.IsLabel t (ValueArray -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveValueArrayMethod t ValueArray, O.OverloadedMethod info ValueArray p, R.HasField t ValueArray p) => R.HasField t ValueArray p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveValueArrayMethod t ValueArray, O.OverloadedMethodInfo info ValueArray) => OL.IsLabel t (O.MethodProxy info ValueArray) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


