// Copyright 2017-2018 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: networking/v1alpha3/virtual_service.proto

// $schema: istio.networking.v1alpha3.VirtualService
// $title: Virtual Service
// $description: Configuration affecting label/content routing, sni routing, etc.
// $location: https://istio.io/docs/reference/config/networking/virtual-service.html
// $aliases: [/docs/reference/config/networking/v1alpha3/virtual-service]

// Configuration affecting traffic routing. Here are a few terms useful to define
// in the context of traffic routing.
//
// `Service` a unit of application behavior bound to a unique name in a
// service registry. Services consist of multiple network *endpoints*
// implemented by workload instances running on pods, containers, VMs etc.
//
// `Service versions (a.k.a. subsets)` - In a continuous deployment
// scenario, for a given service, there can be distinct subsets of
// instances running different variants of the application binary. These
// variants are not necessarily different API versions. They could be
// iterative changes to the same service, deployed in different
// environments (prod, staging, dev, etc.). Common scenarios where this
// occurs include A/B testing, canary rollouts, etc. The choice of a
// particular version can be decided based on various criterion (headers,
// url, etc.) and/or by weights assigned to each version. Each service has
// a default version consisting of all its instances.
//
// `Source` - A downstream client calling a service.
//
// `Host` - The address used by a client when attempting to connect to a
// service.
//
// `Access model` - Applications address only the destination service
// (Host) without knowledge of individual service versions (subsets). The
// actual choice of the version is determined by the proxy/sidecar, enabling the
// application code to decouple itself from the evolution of dependent
// services.
//
// A `VirtualService` defines a set of traffic routing rules to apply when a host is
// addressed. Each routing rule defines matching criteria for traffic of a specific
// protocol. If the traffic is matched, then it is sent to a named destination service
// (or subset/version of it) defined in the registry.
//
// The source of traffic can also be matched in a routing rule. This allows routing
// to be customized for specific client contexts.
//
// The following example on Kubernetes, routes all HTTP traffic by default to
// pods of the reviews service with label "version: v1". In addition,
// HTTP requests with path starting with /wpcatalog/ or /consumercatalog/ will
// be rewritten to /newcatalog and sent to pods with label "version: v2".
//
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//   name: reviews-route
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   http:
//   - name: "reviews-v2-routes"
//     match:
//     - uri:
//         prefix: "/wpcatalog"
//     - uri:
//         prefix: "/consumercatalog"
//     rewrite:
//       uri: "/newcatalog"
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v2
//   - name: "reviews-v1-route"
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v1
// ```
//
// A subset/version of a route destination is identified with a reference
// to a named service subset which must be declared in a corresponding
// `DestinationRule`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//   name: reviews-destination
// spec:
//   host: reviews.prod.svc.cluster.local
//   subsets:
//   - name: v1
//     labels:
//       version: v1
//   - name: v2
//     labels:
//       version: v2
// ```
//

package v1alpha3

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type HTTPRedirect_RedirectPortSelection int32

const (
	HTTPRedirect_FROM_PROTOCOL_DEFAULT HTTPRedirect_RedirectPortSelection = 0
	HTTPRedirect_FROM_REQUEST_PORT     HTTPRedirect_RedirectPortSelection = 1
)

// Enum value maps for HTTPRedirect_RedirectPortSelection.
var (
	HTTPRedirect_RedirectPortSelection_name = map[int32]string{
		0: "FROM_PROTOCOL_DEFAULT",
		1: "FROM_REQUEST_PORT",
	}
	HTTPRedirect_RedirectPortSelection_value = map[string]int32{
		"FROM_PROTOCOL_DEFAULT": 0,
		"FROM_REQUEST_PORT":     1,
	}
)

func (x HTTPRedirect_RedirectPortSelection) Enum() *HTTPRedirect_RedirectPortSelection {
	p := new(HTTPRedirect_RedirectPortSelection)
	*p = x
	return p
}

func (x HTTPRedirect_RedirectPortSelection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPRedirect_RedirectPortSelection) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_virtual_service_proto_enumTypes[0].Descriptor()
}

func (HTTPRedirect_RedirectPortSelection) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_virtual_service_proto_enumTypes[0]
}

func (x HTTPRedirect_RedirectPortSelection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPRedirect_RedirectPortSelection.Descriptor instead.
func (HTTPRedirect_RedirectPortSelection) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{12, 0}
}

type CorsPolicy_UnmatchedPreflights int32

const (
	// Default to FORWARD
	CorsPolicy_UNSPECIFIED CorsPolicy_UnmatchedPreflights = 0
	// Preflight requests not matching the configured allowed origin
	// will be forwarded to the upstream.
	CorsPolicy_FORWARD CorsPolicy_UnmatchedPreflights = 1
	// Preflight requests not matching the configured allowed origin
	// will not be forwarded to the upstream.
	CorsPolicy_IGNORE CorsPolicy_UnmatchedPreflights = 2
)

// Enum value maps for CorsPolicy_UnmatchedPreflights.
var (
	CorsPolicy_UnmatchedPreflights_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "FORWARD",
		2: "IGNORE",
	}
	CorsPolicy_UnmatchedPreflights_value = map[string]int32{
		"UNSPECIFIED": 0,
		"FORWARD":     1,
		"IGNORE":      2,
	}
)

func (x CorsPolicy_UnmatchedPreflights) Enum() *CorsPolicy_UnmatchedPreflights {
	p := new(CorsPolicy_UnmatchedPreflights)
	*p = x
	return p
}

func (x CorsPolicy_UnmatchedPreflights) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CorsPolicy_UnmatchedPreflights) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_virtual_service_proto_enumTypes[1].Descriptor()
}

func (CorsPolicy_UnmatchedPreflights) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_virtual_service_proto_enumTypes[1]
}

func (x CorsPolicy_UnmatchedPreflights) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CorsPolicy_UnmatchedPreflights.Descriptor instead.
func (CorsPolicy_UnmatchedPreflights) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{19, 0}
}

// Configuration affecting traffic routing.
//
// <!-- crd generation tags
// +cue-gen:VirtualService:groupName:networking.istio.io
// +cue-gen:VirtualService:versions:v1,v1beta1,v1alpha3
// +cue-gen:VirtualService:annotations:helm.sh/resource-policy=keep
// +cue-gen:VirtualService:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:VirtualService:subresource:status
// +cue-gen:VirtualService:scope:Namespaced
// +cue-gen:VirtualService:resource:categories=istio-io,networking-istio-io,shortNames=vs
// +cue-gen:VirtualService:printerColumn:name=Gateways,type=string,JSONPath=.spec.gateways,description="The names of gateways and sidecars
// that should apply these routes"
// +cue-gen:VirtualService:printerColumn:name=Hosts,type=string,JSONPath=.spec.hosts,description="The destination hosts to which traffic is being sent"
// +cue-gen:VirtualService:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:VirtualService:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type VirtualService struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The destination hosts to which traffic is being sent. Could
	// be a DNS name with wildcard prefix or an IP address.  Depending on the
	// platform, short-names can also be used instead of a FQDN (i.e. has no
	// dots in the name). In such a scenario, the FQDN of the host would be
	// derived based on the underlying platform.
	//
	// A single VirtualService can be used to describe all the traffic
	// properties of the corresponding hosts, including those for multiple
	// HTTP and TCP ports. Alternatively, the traffic properties of a host
	// can be defined using more than one VirtualService, with certain
	// caveats. Refer to the
	// [Operations Guide](https://istio.io/docs/ops/best-practices/traffic-management/#split-virtual-services)
	// for details.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews" will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. _To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names._
	//
	// The hosts field applies to both HTTP and TCP services. Service inside
	// the mesh, i.e., those found in the service registry, must always be
	// referred to using their alphanumeric names. IP addresses are allowed
	// only for services defined via the Gateway.
	//
	// *Note*: It must be empty for a delegate VirtualService.
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// The names of gateways and sidecars that should apply these routes.
	// Gateways in other namespaces may be referred to by
	// `<gateway namespace>/<gateway name>`; specifying a gateway with no
	// namespace qualifier is the same as specifying the VirtualService's
	// namespace. A single VirtualService is used for sidecars inside the mesh as
	// well as for one or more gateways. The selection condition imposed by this
	// field can be overridden using the source field in the match conditions
	// of protocol-specific routes. The reserved word `mesh` is used to imply
	// all the sidecars in the mesh. When this field is omitted, the default
	// gateway (`mesh`) will be used, which would apply the rule to all
	// sidecars in the mesh. If a list of gateway names is provided, the
	// rules will apply only to the gateways. To apply the rules to both
	// gateways and sidecars, specify `mesh` as one of the gateway names.
	Gateways []string `protobuf:"bytes,2,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// An ordered list of route rules for HTTP traffic. HTTP routes will be
	// applied to platform service ports using HTTP/HTTP2/GRPC protocols, gateway
	// ports with protocol HTTP/HTTP2/GRPC/TLS-terminated-HTTPS and service
	// entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
	// an incoming request is used.
	Http []*HTTPRoute `protobuf:"bytes,3,rep,name=http,proto3" json:"http,omitempty"`
	// An ordered list of route rule for non-terminated TLS & HTTPS
	// traffic. Routing is typically performed using the SNI value presented
	// by the ClientHello message. TLS routes will be applied to platform
	// service ports named 'https-*', 'tls-*', unterminated gateway ports using
	// HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
	// entry ports using HTTPS/TLS protocols.  The first rule matching an
	// incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
	// without associated virtual service will be treated as opaque TCP
	// traffic.
	Tls []*TLSRoute `protobuf:"bytes,5,rep,name=tls,proto3" json:"tls,omitempty"`
	// An ordered list of route rules for opaque TCP traffic. TCP routes will
	// be applied to any port that is not a HTTP or TLS port. The first rule
	// matching an incoming request is used.
	Tcp []*TCPRoute `protobuf:"bytes,4,rep,name=tcp,proto3" json:"tcp,omitempty"`
	// A list of namespaces to which this virtual service is exported. Exporting a
	// virtual service allows it to be used by sidecars and gateways defined in
	// other namespaces. This feature provides a mechanism for service owners
	// and mesh administrators to control the visibility of virtual services
	// across namespace boundaries.
	//
	// If no namespaces are specified then the virtual service is exported to all
	// namespaces by default.
	//
	// The value "." is reserved and defines an export to the same namespace that
	// the virtual service is declared in. Similarly the value "*" is reserved and
	// defines an export to all namespaces.
	ExportTo      []string `protobuf:"bytes,6,rep,name=export_to,json=exportTo,proto3" json:"export_to,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *VirtualService) Reset() {
	*x = VirtualService{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirtualService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualService) ProtoMessage() {}

func (x *VirtualService) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualService.ProtoReflect.Descriptor instead.
func (*VirtualService) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{0}
}

func (x *VirtualService) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *VirtualService) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *VirtualService) GetHttp() []*HTTPRoute {
	if x != nil {
		return x.Http
	}
	return nil
}

func (x *VirtualService) GetTls() []*TLSRoute {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *VirtualService) GetTcp() []*TCPRoute {
	if x != nil {
		return x.Tcp
	}
	return nil
}

func (x *VirtualService) GetExportTo() []string {
	if x != nil {
		return x.ExportTo
	}
	return nil
}

// Destination indicates the network addressable service to which the
// request/connection will be sent after processing a routing rule. The
// destination.host should unambiguously refer to a service in the service
// registry. Istio's service registry is composed of all the services found
// in the platform's service registry (e.g., Kubernetes services, Consul
// services), as well as services declared through the
// [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry) resource.
//
// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
// instead of "reviews.default.svc.cluster.local"), Istio will interpret
// the short name based on the namespace of the rule, not the service. A
// rule in the "default" namespace containing a host "reviews" will be
// interpreted as "reviews.default.svc.cluster.local", irrespective of the
// actual namespace associated with the reviews service. _To avoid potential
// misconfigurations, it is recommended to always use fully qualified
// domain names over short names._
//
// The following Kubernetes example routes all traffic by default to pods
// of the reviews service with label "version: v1" (i.e., subset v1), and
// some to subset v2, in a Kubernetes environment.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews-route
//	namespace: foo
//
// spec:
//
//	hosts:
//	- reviews # interpreted as reviews.foo.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      prefix: "/wpcatalog"
//	  - uri:
//	      prefix: "/consumercatalog"
//	  rewrite:
//	    uri: "/newcatalog"
//	  route:
//	  - destination:
//	      host: reviews # interpreted as reviews.foo.svc.cluster.local
//	      subset: v2
//	- route:
//	  - destination:
//	      host: reviews # interpreted as reviews.foo.svc.cluster.local
//	      subset: v1
//
// ```
//
// # And the associated DestinationRule
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: reviews-destination
//	namespace: foo
//
// spec:
//
//	host: reviews # interpreted as reviews.foo.svc.cluster.local
//	subsets:
//	- name: v1
//	  labels:
//	    version: v1
//	- name: v2
//	  labels:
//	    version: v2
//
// ```
//
// The following VirtualService sets a timeout of 5s for all calls to
// productpage.prod.svc.cluster.local service in Kubernetes. Notice that
// there are no subsets defined in this rule. Istio will fetch all
// instances of productpage.prod.svc.cluster.local service from the service
// registry and populate the sidecar's load balancing pool. Also, notice
// that this rule is set in the istio-system namespace but uses the fully
// qualified domain name of the productpage service,
// productpage.prod.svc.cluster.local. Therefore the rule's namespace does
// not have an impact in resolving the name of the productpage service.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: my-productpage-rule
//	namespace: istio-system
//
// spec:
//
//	hosts:
//	- productpage.prod.svc.cluster.local # ignores rule namespace
//	http:
//	- timeout: 5s
//	  route:
//	  - destination:
//	      host: productpage.prod.svc.cluster.local
//
// ```
//
// To control routing for traffic bound to services outside the mesh, external
// services must first be added to Istio's internal service registry using the
// ServiceEntry resource. VirtualServices can then be defined to control traffic
// bound to these external services. For example, the following rules define a
// Service for wikipedia.org and set a timeout of 5s for HTTP requests.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//
//	name: external-svc-wikipedia
//
// spec:
//
//	hosts:
//	- wikipedia.org
//	location: MESH_EXTERNAL
//	ports:
//	- number: 80
//	  name: example-http
//	  protocol: HTTP
//	resolution: DNS
//
// ---
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: my-wiki-rule
//
// spec:
//
//	hosts:
//	- wikipedia.org
//	http:
//	- timeout: 5s
//	  route:
//	  - destination:
//	      host: wikipedia.org
//
// ```
type Destination struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name of a service from the service registry. Service
	// names are looked up from the platform's service registry (e.g.,
	// Kubernetes services, Consul services, etc.) and from the hosts
	// declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
	// destinations that are not found in either of the two, will be dropped.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews" will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. To avoid
	// potential misconfiguration, it is recommended to always use fully
	// qualified domain names over short names.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// The name of a subset within the service. Applicable only to services
	// within the mesh. The subset must be defined in a corresponding
	// DestinationRule.
	Subset string `protobuf:"bytes,2,opt,name=subset,proto3" json:"subset,omitempty"`
	// Specifies the port on the host that is being addressed. If a service
	// exposes only a single port it is not required to explicitly select the
	// port.
	Port          *PortSelector `protobuf:"bytes,3,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Destination) Reset() {
	*x = Destination{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Destination) ProtoMessage() {}

func (x *Destination) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Destination.ProtoReflect.Descriptor instead.
func (*Destination) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{1}
}

func (x *Destination) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Destination) GetSubset() string {
	if x != nil {
		return x.Subset
	}
	return ""
}

func (x *Destination) GetPort() *PortSelector {
	if x != nil {
		return x.Port
	}
	return nil
}

// Describes match conditions and actions for routing HTTP/1.1, HTTP2, and
// gRPC traffic. See VirtualService for usage examples.
type HTTPRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name assigned to the route for debugging purposes. The
	// route's name will be concatenated with the match's name and will
	// be logged in the access logs for requests matching this
	// route/match.
	Name string `protobuf:"bytes,17,opt,name=name,proto3" json:"name,omitempty"`
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*HTTPMatchRequest `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// A HTTP rule can either return a direct_response, redirect or forward (default) traffic.
	// The forwarding target can be one of several versions of a service (see
	// glossary in beginning of document). Weights associated with the
	// service version determine the proportion of traffic it receives.
	Route []*HTTPRouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	// A HTTP rule can either return a direct_response, redirect or forward (default) traffic.
	// If traffic passthrough option is specified in the rule,
	// route/redirect will be ignored. The redirect primitive can be used to
	// send a HTTP 301 redirect to a different URI or Authority.
	Redirect *HTTPRedirect `protobuf:"bytes,3,opt,name=redirect,proto3" json:"redirect,omitempty"`
	// A HTTP rule can either return a direct_response, redirect or forward (default) traffic.
	// Direct Response is used to specify a fixed response that should
	// be sent to clients.
	//
	// It can be set only when `Route` and `Redirect` are empty.
	DirectResponse *HTTPDirectResponse `protobuf:"bytes,21,opt,name=direct_response,json=directResponse,proto3" json:"direct_response,omitempty"`
	// Delegate is used to specify the particular VirtualService which
	// can be used to define delegate HTTPRoute.
	//
	// It can be set only when `Route` and `Redirect` are empty, and the route
	// rules of the delegate VirtualService will be merged with that in the
	// current one.
	//
	// **NOTE**:
	//
	//  1. Only one level delegation is supported.
	//  2. The delegate's HTTPMatchRequest must be a strict subset of the root's,
	//     otherwise there is a conflict and the HTTPRoute will not take effect.
	Delegate *Delegate `protobuf:"bytes,20,opt,name=delegate,proto3" json:"delegate,omitempty"`
	// Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
	// Redirect primitive. Rewrite will be performed before forwarding.
	Rewrite *HTTPRewrite `protobuf:"bytes,4,opt,name=rewrite,proto3" json:"rewrite,omitempty"`
	// Timeout for HTTP requests, default is disabled.
	Timeout *duration.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Retry policy for HTTP requests.
	//
	// Note: the default cluster-wide retry policy, if not specified, is:
	//
	// ```yaml
	// attempts: 2
	// retryOn: "connect-failure,refused-stream,unavailable,cancelled"
	// ```
	//
	// This can be customized in [`Mesh Config` `defaultHttpRetryPolicy`](https://istio.io/latest/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig).
	Retries *HTTPRetry `protobuf:"bytes,7,opt,name=retries,proto3" json:"retries,omitempty"`
	// Fault injection policy to apply on HTTP traffic at the client side.
	// Note that timeouts or retries will not be enabled when faults are
	// enabled on the client side.
	Fault *HTTPFaultInjection `protobuf:"bytes,8,opt,name=fault,proto3" json:"fault,omitempty"`
	// Mirror HTTP traffic to a another destination in addition to forwarding
	// the requests to the intended destination. Mirrored traffic is on a
	// best effort basis where the sidecar/gateway will not wait for the
	// mirrored cluster to respond before returning the response from the
	// original destination.  Statistics will be generated for the mirrored
	// destination.
	Mirror *Destination `protobuf:"bytes,9,opt,name=mirror,proto3" json:"mirror,omitempty"`
	// Specifies the destinations to mirror HTTP traffic in addition
	// to the original destination. Mirrored traffic is on a
	// best effort basis where the sidecar/gateway will not wait for the
	// mirrored destinations to respond before returning the response from the
	// original destination. Statistics will be generated for the mirrored
	// destination.
	Mirrors []*HTTPMirrorPolicy `protobuf:"bytes,22,rep,name=mirrors,proto3" json:"mirrors,omitempty"`
	// Percentage of the traffic to be mirrored by the `mirror` field.
	// Use of integer `mirror_percent` value is deprecated. Use the
	// double `mirror_percentage` field instead
	// $hide_from_docs
	// +kubebuilder:altName=mirror_percent
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
	MirrorPercent *wrappers.UInt32Value `protobuf:"bytes,18,opt,name=mirror_percent,json=mirrorPercent,proto3" json:"mirror_percent,omitempty"`
	// Percentage of the traffic to be mirrored by the `mirror` field.
	// If this field is absent, all the traffic (100%) will be mirrored.
	// Max value is 100.
	MirrorPercentage *Percent `protobuf:"bytes,19,opt,name=mirror_percentage,json=mirrorPercentage,proto3" json:"mirror_percentage,omitempty"`
	// Cross-Origin Resource Sharing policy (CORS). Refer to
	// [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
	// for further details about cross origin resource sharing.
	CorsPolicy *CorsPolicy `protobuf:"bytes,10,opt,name=cors_policy,json=corsPolicy,proto3" json:"cors_policy,omitempty"`
	// Header manipulation rules
	Headers       *Headers `protobuf:"bytes,16,opt,name=headers,proto3" json:"headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPRoute) Reset() {
	*x = HTTPRoute{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRoute) ProtoMessage() {}

func (x *HTTPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRoute.ProtoReflect.Descriptor instead.
func (*HTTPRoute) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{2}
}

func (x *HTTPRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPRoute) GetMatch() []*HTTPMatchRequest {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *HTTPRoute) GetRoute() []*HTTPRouteDestination {
	if x != nil {
		return x.Route
	}
	return nil
}

func (x *HTTPRoute) GetRedirect() *HTTPRedirect {
	if x != nil {
		return x.Redirect
	}
	return nil
}

func (x *HTTPRoute) GetDirectResponse() *HTTPDirectResponse {
	if x != nil {
		return x.DirectResponse
	}
	return nil
}

func (x *HTTPRoute) GetDelegate() *Delegate {
	if x != nil {
		return x.Delegate
	}
	return nil
}

func (x *HTTPRoute) GetRewrite() *HTTPRewrite {
	if x != nil {
		return x.Rewrite
	}
	return nil
}

func (x *HTTPRoute) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *HTTPRoute) GetRetries() *HTTPRetry {
	if x != nil {
		return x.Retries
	}
	return nil
}

func (x *HTTPRoute) GetFault() *HTTPFaultInjection {
	if x != nil {
		return x.Fault
	}
	return nil
}

func (x *HTTPRoute) GetMirror() *Destination {
	if x != nil {
		return x.Mirror
	}
	return nil
}

func (x *HTTPRoute) GetMirrors() []*HTTPMirrorPolicy {
	if x != nil {
		return x.Mirrors
	}
	return nil
}

// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
func (x *HTTPRoute) GetMirrorPercent() *wrappers.UInt32Value {
	if x != nil {
		return x.MirrorPercent
	}
	return nil
}

func (x *HTTPRoute) GetMirrorPercentage() *Percent {
	if x != nil {
		return x.MirrorPercentage
	}
	return nil
}

func (x *HTTPRoute) GetCorsPolicy() *CorsPolicy {
	if x != nil {
		return x.CorsPolicy
	}
	return nil
}

func (x *HTTPRoute) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

// Describes the delegate VirtualService.
// The following routing rules forward the traffic to `/productpage` by a delegate VirtualService named `productpage`,
// forward the traffic to `/reviews` by a delegate VirtualService named `reviews`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: bookinfo
//
// spec:
//
//	hosts:
//	- "bookinfo.com"
//	gateways:
//	- mygateway
//	http:
//	- match:
//	  - uri:
//	      prefix: "/productpage"
//	  delegate:
//	     name: productpage
//	     namespace: nsA
//	- match:
//	  - uri:
//	      prefix: "/reviews"
//	  delegate:
//	      name: reviews
//	      namespace: nsB
//
// ```
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: productpage
//	namespace: nsA
//
// spec:
//
//	http:
//	- match:
//	   - uri:
//	      prefix: "/productpage/v1/"
//	  route:
//	  - destination:
//	      host: productpage-v1.nsA.svc.cluster.local
//	- route:
//	  - destination:
//	      host: productpage.nsA.svc.cluster.local
//
// ```
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews
//	namespace: nsB
//
// spec:
//
//	http:
//	- route:
//	  - destination:
//	      host: reviews.nsB.svc.cluster.local
//
// ```
type Delegate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name specifies the name of the delegate VirtualService.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace specifies the namespace where the delegate VirtualService resides.
	// By default, it is same to the root's.
	Namespace     string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Delegate) Reset() {
	*x = Delegate{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Delegate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Delegate) ProtoMessage() {}

func (x *Delegate) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Delegate.ProtoReflect.Descriptor instead.
func (*Delegate) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{3}
}

func (x *Delegate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Delegate) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// Message headers can be manipulated when Envoy forwards requests to,
// or responses from, a destination service. Header manipulation rules can
// be specified for a specific route destination or for all destinations.
// The following VirtualService adds a `test` header with the value `true`
// to requests that are routed to any `reviews` service destination.
// It also removes the `foo` response header, but only from responses
// coming from the `v1` subset (version) of the `reviews` service.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews-route
//
// spec:
//
//	hosts:
//	- reviews.prod.svc.cluster.local
//	http:
//	- headers:
//	    request:
//	      set:
//	        test: "true"
//	  route:
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//	      subset: v2
//	    weight: 25
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//	      subset: v1
//	    headers:
//	      response:
//	        remove:
//	        - foo
//	    weight: 75
//
// ```
type Headers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Header manipulation rules to apply before forwarding a request
	// to the destination service
	Request *Headers_HeaderOperations `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
	// Header manipulation rules to apply before returning a response
	// to the caller
	Response      *Headers_HeaderOperations `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Headers) Reset() {
	*x = Headers{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Headers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Headers) ProtoMessage() {}

func (x *Headers) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Headers.ProtoReflect.Descriptor instead.
func (*Headers) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{4}
}

func (x *Headers) GetRequest() *Headers_HeaderOperations {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *Headers) GetResponse() *Headers_HeaderOperations {
	if x != nil {
		return x.Response
	}
	return nil
}

// Describes match conditions and actions for routing unterminated TLS
// traffic (TLS/HTTPS) The following routing rule forwards unterminated TLS
// traffic arriving at port 443 of gateway called "mygateway" to internal
// services in the mesh based on the SNI value.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: bookinfo-sni
//
// spec:
//
//	hosts:
//	- "*.bookinfo.com"
//	gateways:
//	- mygateway
//	tls:
//	- match:
//	  - port: 443
//	    sniHosts:
//	    - login.bookinfo.com
//	  route:
//	  - destination:
//	      host: login.prod.svc.cluster.local
//	- match:
//	  - port: 443
//	    sniHosts:
//	    - reviews.bookinfo.com
//	  route:
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//
// ```
type TLSRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*TLSMatchAttributes `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// The destination to which the connection should be forwarded to.
	Route         []*RouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TLSRoute) Reset() {
	*x = TLSRoute{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TLSRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSRoute) ProtoMessage() {}

func (x *TLSRoute) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSRoute.ProtoReflect.Descriptor instead.
func (*TLSRoute) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{5}
}

func (x *TLSRoute) GetMatch() []*TLSMatchAttributes {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *TLSRoute) GetRoute() []*RouteDestination {
	if x != nil {
		return x.Route
	}
	return nil
}

// Describes match conditions and actions for routing TCP traffic. The
// following routing rule forwards traffic arriving at port 27017 for
// mongo.prod.svc.cluster.local to another Mongo server on port 5555.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: bookinfo-mongo
//
// spec:
//
//	hosts:
//	- mongo.prod.svc.cluster.local
//	tcp:
//	- match:
//	  - port: 27017
//	  route:
//	  - destination:
//	      host: mongo.backup.svc.cluster.local
//	      port:
//	        number: 5555
//
// ```
type TCPRoute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*L4MatchAttributes `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// The destination to which the connection should be forwarded to.
	Route         []*RouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TCPRoute) Reset() {
	*x = TCPRoute{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TCPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPRoute) ProtoMessage() {}

func (x *TCPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPRoute.ProtoReflect.Descriptor instead.
func (*TCPRoute) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{6}
}

func (x *TCPRoute) GetMatch() []*L4MatchAttributes {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *TCPRoute) GetRoute() []*RouteDestination {
	if x != nil {
		return x.Route
	}
	return nil
}

// HttpMatchRequest specifies a set of criteria to be met in order for the
// rule to be applied to the HTTP request. For example, the following
// restricts the rule to match only requests where the URL path
// starts with /ratings/v2/ and the request contains a custom `end-user` header
// with value `jason`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - headers:
//	      end-user:
//	        exact: jason
//	    uri:
//	      prefix: "/ratings/v2/"
//	    ignoreUriCase: true
//	  route:
//	  - destination:
//	      host: ratings.prod.svc.cluster.local
//
// ```
//
// HTTPMatchRequest CANNOT be empty.
// **Note:**
// 1. If a root VirtualService have matched any property (path, header etc.) by regex, delegate VirtualServices should not have any other matches on the same property.
// 2. If a delegate VirtualService have matched any property (path, header etc.) by regex, root VirtualServices should not have any other matches on the same property.
type HTTPMatchRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The name assigned to a match. The match's name will be
	// concatenated with the parent route's name and will be logged in
	// the access logs for requests matching this route.
	Name string `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// URI to match
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	//
	// **Note:** Case-insensitive matching could be enabled via the
	// `ignoreUriCase` flag.
	Uri *StringMatch `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI Scheme
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	Scheme *StringMatch `protobuf:"bytes,2,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// HTTP Method
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	Method *StringMatch `protobuf:"bytes,3,opt,name=method,proto3" json:"method,omitempty"`
	// HTTP Authority
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	Authority *StringMatch `protobuf:"bytes,4,opt,name=authority,proto3" json:"authority,omitempty"`
	// The header keys must be lowercase and use hyphen as the separator,
	// e.g. _x-request-id_.
	//
	// Header values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	//
	// If the value is empty and only the name of header is specified, presence of the header is checked.
	// To provide an empty value, use `{}`, for example:
	//
	// ```
	//   - match:
	//   - headers:
	//     myheader: {}
	//
	// ```
	// **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
	Headers map[string]*StringMatch `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Specifies the ports on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they support,
	// in these cases it is not required to explicitly select the port.
	Port uint32 `protobuf:"varint,6,opt,name=port,proto3" json:"port,omitempty"`
	// One or more labels that constrain the applicability of a rule to source (client) workloads
	// with the given labels. If the VirtualService has a list of gateways specified
	// in the top-level `gateways` field, it must include the reserved gateway
	// `mesh` for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceLabels map[string]string `protobuf:"bytes,7,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Names of gateways where the rule should be applied. Gateway names
	// in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
	// match is independent of sourceLabels.
	Gateways []string `protobuf:"bytes,8,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Query parameters for matching.
	//
	// Ex:
	//
	//   - For a query parameter like "?key=true", the map key would be "key" and
	//     the string match could be defined as `exact: "true"`.
	//
	//   - For a query parameter like "?key", the map key would be "key" and the
	//     string match could be defined as `exact: ""`.
	//
	//   - For a query parameter like "?key=abc" or "?key=abx", the map key would be "key" and the
	//     string match could be defined as `prefix: "ab"`.
	//
	//   - For a query parameter like "?key=123", the map key would be "key" and the
	//     string match could be defined as `regex: "\d+$"`. Note that this
	//     configuration will only match values like "123" but not "a123" or "123a".
	QueryParams map[string]*StringMatch `protobuf:"bytes,9,rep,name=query_params,json=queryParams,proto3" json:"query_params,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Flag to specify whether the URI matching should be case-insensitive.
	//
	// **Note:** The case will be ignored only in the case of `exact` and `prefix`
	// URI matches.
	IgnoreUriCase bool `protobuf:"varint,10,opt,name=ignore_uri_case,json=ignoreUriCase,proto3" json:"ignore_uri_case,omitempty"`
	// withoutHeader has the same syntax with the header, but has opposite meaning.
	// If a header is matched with a matching rule among withoutHeader, the traffic becomes not matched one.
	WithoutHeaders map[string]*StringMatch `protobuf:"bytes,12,rep,name=without_headers,json=withoutHeaders,proto3" json:"without_headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Source namespace constraining the applicability of a rule to workloads in that namespace.
	// If the VirtualService has a list of gateways specified in the top-level `gateways` field,
	// it must include the reserved gateway `mesh` for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceNamespace string `protobuf:"bytes,13,opt,name=source_namespace,json=sourceNamespace,proto3" json:"source_namespace,omitempty"`
	// The human readable prefix to use when emitting statistics for this route.
	// The statistics are generated with prefix route.<stat_prefix>.
	// This should be set for highly critical routes that one wishes to get "per-route" statistics on.
	// This prefix is only for proxy-level statistics (envoy_*) and not service-level (istio_*) statistics.
	// Refer to https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/route/v3/route_components.proto#envoy-v3-api-field-config-route-v3-route-stat-prefix
	// for statistics that are generated when this is configured.
	StatPrefix    string `protobuf:"bytes,14,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPMatchRequest) Reset() {
	*x = HTTPMatchRequest{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPMatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPMatchRequest) ProtoMessage() {}

func (x *HTTPMatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPMatchRequest.ProtoReflect.Descriptor instead.
func (*HTTPMatchRequest) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{7}
}

func (x *HTTPMatchRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPMatchRequest) GetUri() *StringMatch {
	if x != nil {
		return x.Uri
	}
	return nil
}

func (x *HTTPMatchRequest) GetScheme() *StringMatch {
	if x != nil {
		return x.Scheme
	}
	return nil
}

func (x *HTTPMatchRequest) GetMethod() *StringMatch {
	if x != nil {
		return x.Method
	}
	return nil
}

func (x *HTTPMatchRequest) GetAuthority() *StringMatch {
	if x != nil {
		return x.Authority
	}
	return nil
}

func (x *HTTPMatchRequest) GetHeaders() map[string]*StringMatch {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HTTPMatchRequest) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *HTTPMatchRequest) GetSourceLabels() map[string]string {
	if x != nil {
		return x.SourceLabels
	}
	return nil
}

func (x *HTTPMatchRequest) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *HTTPMatchRequest) GetQueryParams() map[string]*StringMatch {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *HTTPMatchRequest) GetIgnoreUriCase() bool {
	if x != nil {
		return x.IgnoreUriCase
	}
	return false
}

func (x *HTTPMatchRequest) GetWithoutHeaders() map[string]*StringMatch {
	if x != nil {
		return x.WithoutHeaders
	}
	return nil
}

func (x *HTTPMatchRequest) GetSourceNamespace() string {
	if x != nil {
		return x.SourceNamespace
	}
	return ""
}

func (x *HTTPMatchRequest) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

// Each routing rule is associated with one or more service versions (see
// glossary in beginning of document). Weights associated with the version
// determine the proportion of traffic it receives. For example, the
// following rule will route 25% of traffic for the "reviews" service to
// instances with the "v2" tag and the remaining traffic (i.e., 75%) to
// "v1".
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews-route
//
// spec:
//
//	hosts:
//	- reviews.prod.svc.cluster.local
//	http:
//	- route:
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//	      subset: v2
//	    weight: 25
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//	      subset: v1
//	    weight: 75
//
// ```
//
// # And the associated DestinationRule
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: DestinationRule
// metadata:
//
//	name: reviews-destination
//
// spec:
//
//	host: reviews.prod.svc.cluster.local
//	subsets:
//	- name: v1
//	  labels:
//	    version: v1
//	- name: v2
//	  labels:
//	    version: v2
//
// ```
//
// Traffic can also be split across two entirely different services without
// having to define new subsets. For example, the following rule forwards 25% of
// traffic to reviews.com to dev.reviews.com
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews-route-two-domains
//
// spec:
//
//	hosts:
//	- reviews.com
//	http:
//	- route:
//	  - destination:
//	      host: dev.reviews.com
//	    weight: 25
//	  - destination:
//	      host: reviews.com
//	    weight: 75
//
// ```
type HTTPRouteDestination struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Destination uniquely identifies the instances of a service
	// to which the request/connection should be forwarded to.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// Weight specifies the relative proportion of traffic to be forwarded to the destination. A destination will receive `weight/(sum of all weights)` requests.
	// If there is only one destination in a rule, it will receive all traffic.
	// Otherwise, if weight is `0`, the destination will not receive any traffic.
	Weight int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Header manipulation rules
	Headers       *Headers `protobuf:"bytes,7,opt,name=headers,proto3" json:"headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPRouteDestination) Reset() {
	*x = HTTPRouteDestination{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPRouteDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRouteDestination) ProtoMessage() {}

func (x *HTTPRouteDestination) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRouteDestination.ProtoReflect.Descriptor instead.
func (*HTTPRouteDestination) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{8}
}

func (x *HTTPRouteDestination) GetDestination() *Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *HTTPRouteDestination) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *HTTPRouteDestination) GetHeaders() *Headers {
	if x != nil {
		return x.Headers
	}
	return nil
}

// L4 routing rule weighted destination.
type RouteDestination struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Destination uniquely identifies the instances of a service
	// to which the request/connection should be forwarded to.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// Weight specifies the relative proportion of traffic to be forwarded to the destination. A destination will receive `weight/(sum of all weights)` requests.
	// If there is only one destination in a rule, it will receive all traffic.
	// Otherwise, if weight is `0`, the destination will not receive any traffic.
	Weight        int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RouteDestination) Reset() {
	*x = RouteDestination{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RouteDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteDestination) ProtoMessage() {}

func (x *RouteDestination) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteDestination.ProtoReflect.Descriptor instead.
func (*RouteDestination) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{9}
}

func (x *RouteDestination) GetDestination() *Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *RouteDestination) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

// L4 connection match attributes. Note that L4 connection matching support
// is incomplete.
type L4MatchAttributes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
	// a.b.c.d/xx form or just a.b.c.d.
	DestinationSubnets []string `protobuf:"bytes,1,rep,name=destination_subnets,json=destinationSubnets,proto3" json:"destination_subnets,omitempty"`
	// Specifies the port on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they support,
	// in these cases it is not required to explicitly select the port.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
	// form or just a.b.c.d
	// $hide_from_docs
	SourceSubnet string `protobuf:"bytes,3,opt,name=source_subnet,json=sourceSubnet,proto3" json:"source_subnet,omitempty"`
	// One or more labels that constrain the applicability of a rule to
	// workloads with the given labels. If the VirtualService has a list of
	// gateways specified in the top-level `gateways` field, it should include the reserved gateway
	// `mesh` in order for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceLabels map[string]string `protobuf:"bytes,4,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Names of gateways where the rule should be applied. Gateway names
	// in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
	// match is independent of sourceLabels.
	Gateways []string `protobuf:"bytes,5,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Source namespace constraining the applicability of a rule to workloads in that namespace.
	// If the VirtualService has a list of gateways specified in the top-level `gateways` field,
	// it must include the reserved gateway `mesh` for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceNamespace string `protobuf:"bytes,6,opt,name=source_namespace,json=sourceNamespace,proto3" json:"source_namespace,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *L4MatchAttributes) Reset() {
	*x = L4MatchAttributes{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *L4MatchAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L4MatchAttributes) ProtoMessage() {}

func (x *L4MatchAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L4MatchAttributes.ProtoReflect.Descriptor instead.
func (*L4MatchAttributes) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{10}
}

func (x *L4MatchAttributes) GetDestinationSubnets() []string {
	if x != nil {
		return x.DestinationSubnets
	}
	return nil
}

func (x *L4MatchAttributes) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *L4MatchAttributes) GetSourceSubnet() string {
	if x != nil {
		return x.SourceSubnet
	}
	return ""
}

func (x *L4MatchAttributes) GetSourceLabels() map[string]string {
	if x != nil {
		return x.SourceLabels
	}
	return nil
}

func (x *L4MatchAttributes) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *L4MatchAttributes) GetSourceNamespace() string {
	if x != nil {
		return x.SourceNamespace
	}
	return ""
}

// TLS connection match attributes.
type TLSMatchAttributes struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SNI (server name indicator) to match on. Wildcard prefixes
	// can be used in the SNI value, e.g., *.com will match foo.example.com
	// as well as example.com. An SNI value must be a subset (i.e., fall
	// within the domain) of the corresponding virtual service's hosts.
	SniHosts []string `protobuf:"bytes,1,rep,name=sni_hosts,json=sniHosts,proto3" json:"sni_hosts,omitempty"`
	// IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
	// a.b.c.d/xx form or just a.b.c.d.
	DestinationSubnets []string `protobuf:"bytes,2,rep,name=destination_subnets,json=destinationSubnets,proto3" json:"destination_subnets,omitempty"`
	// Specifies the port on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they
	// support, in these cases it is not required to explicitly select the
	// port.
	Port uint32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// One or more labels that constrain the applicability of a rule to
	// workloads with the given labels. If the VirtualService has a list of
	// gateways specified in the top-level `gateways` field, it should include the reserved gateway
	// `mesh` in order for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceLabels map[string]string `protobuf:"bytes,5,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Names of gateways where the rule should be applied. Gateway names
	// in the top-level `gateways` field of the VirtualService (if any) are overridden. The gateway
	// match is independent of sourceLabels.
	Gateways []string `protobuf:"bytes,6,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Source namespace constraining the applicability of a rule to workloads in that namespace.
	// If the VirtualService has a list of gateways specified in the top-level `gateways` field,
	// it must include the reserved gateway `mesh` for this field to be applicable.
	//
	// **Note:** This is not a runtime match, but is a selector; it filters which workloads the
	// VirtualService applies to.
	SourceNamespace string `protobuf:"bytes,7,opt,name=source_namespace,json=sourceNamespace,proto3" json:"source_namespace,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TLSMatchAttributes) Reset() {
	*x = TLSMatchAttributes{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TLSMatchAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSMatchAttributes) ProtoMessage() {}

func (x *TLSMatchAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSMatchAttributes.ProtoReflect.Descriptor instead.
func (*TLSMatchAttributes) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{11}
}

func (x *TLSMatchAttributes) GetSniHosts() []string {
	if x != nil {
		return x.SniHosts
	}
	return nil
}

func (x *TLSMatchAttributes) GetDestinationSubnets() []string {
	if x != nil {
		return x.DestinationSubnets
	}
	return nil
}

func (x *TLSMatchAttributes) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *TLSMatchAttributes) GetSourceLabels() map[string]string {
	if x != nil {
		return x.SourceLabels
	}
	return nil
}

func (x *TLSMatchAttributes) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *TLSMatchAttributes) GetSourceNamespace() string {
	if x != nil {
		return x.SourceNamespace
	}
	return ""
}

// HTTPRedirect can be used to send a 301 redirect response to the caller,
// where the Authority/Host and the URI in the response can be swapped with
// the specified values. For example, the following rule redirects
// requests for /v1/getProductRatings API on the ratings service to
// /v1/bookRatings provided by the bookratings service.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      exact: /v1/getProductRatings
//	  redirect:
//	    uri: /v1/bookRatings
//	    authority: newratings.default.svc.cluster.local
//	...
//
// ```
type HTTPRedirect struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// On a redirect, overwrite the Path portion of the URL with this
	// value. Note that the entire path will be replaced, irrespective of the
	// request URI being matched as an exact path or prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// On a redirect, overwrite the Authority/Host portion of the URL with
	// this value.
	Authority string `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	// Types that are valid to be assigned to RedirectPort:
	//
	//	*HTTPRedirect_Port
	//	*HTTPRedirect_DerivePort
	RedirectPort isHTTPRedirect_RedirectPort `protobuf_oneof:"redirect_port"`
	// On a redirect, overwrite the scheme portion of the URL with this value.
	// For example, `http` or `https`.
	// If unset, the original scheme will be used.
	// If `derivePort` is set to `FROM_PROTOCOL_DEFAULT`, this will impact the port used as well
	Scheme string `protobuf:"bytes,6,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// On a redirect, Specifies the HTTP status code to use in the redirect
	// response. The default response code is MOVED_PERMANENTLY (301).
	RedirectCode  uint32 `protobuf:"varint,3,opt,name=redirect_code,json=redirectCode,proto3" json:"redirect_code,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPRedirect) Reset() {
	*x = HTTPRedirect{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPRedirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRedirect) ProtoMessage() {}

func (x *HTTPRedirect) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRedirect.ProtoReflect.Descriptor instead.
func (*HTTPRedirect) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{12}
}

func (x *HTTPRedirect) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *HTTPRedirect) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *HTTPRedirect) GetRedirectPort() isHTTPRedirect_RedirectPort {
	if x != nil {
		return x.RedirectPort
	}
	return nil
}

func (x *HTTPRedirect) GetPort() uint32 {
	if x != nil {
		if x, ok := x.RedirectPort.(*HTTPRedirect_Port); ok {
			return x.Port
		}
	}
	return 0
}

func (x *HTTPRedirect) GetDerivePort() HTTPRedirect_RedirectPortSelection {
	if x != nil {
		if x, ok := x.RedirectPort.(*HTTPRedirect_DerivePort); ok {
			return x.DerivePort
		}
	}
	return HTTPRedirect_FROM_PROTOCOL_DEFAULT
}

func (x *HTTPRedirect) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *HTTPRedirect) GetRedirectCode() uint32 {
	if x != nil {
		return x.RedirectCode
	}
	return 0
}

type isHTTPRedirect_RedirectPort interface {
	isHTTPRedirect_RedirectPort()
}

type HTTPRedirect_Port struct {
	// On a redirect, overwrite the port portion of the URL with this value.
	Port uint32 `protobuf:"varint,4,opt,name=port,proto3,oneof"`
}

type HTTPRedirect_DerivePort struct {
	// On a redirect, dynamically set the port:
	// * FROM_PROTOCOL_DEFAULT: automatically set to 80 for HTTP and 443 for HTTPS.
	// * FROM_REQUEST_PORT: automatically use the port of the request.
	DerivePort HTTPRedirect_RedirectPortSelection `protobuf:"varint,5,opt,name=derive_port,json=derivePort,proto3,enum=istio.networking.v1alpha3.HTTPRedirect_RedirectPortSelection,oneof"`
}

func (*HTTPRedirect_Port) isHTTPRedirect_RedirectPort() {}

func (*HTTPRedirect_DerivePort) isHTTPRedirect_RedirectPort() {}

// HTTPDirectResponse can be used to send a fixed response to clients.
// For example, the following rule returns a fixed 503 status with a body
// to requests for /v1/getProductRatings API.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      exact: /v1/getProductRatings
//	  directResponse:
//	    status: 503
//	    body:
//	      string: "unknown error"
//	...
//
// ```
//
// It is also possible to specify a binary response body.
// This is mostly useful for non text-based protocols such as gRPC.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      exact: /v1/getProductRatings
//	  directResponse:
//	    status: 503
//	    body:
//	      bytes: "dW5rbm93biBlcnJvcg==" # "unknown error" in base64
//	...
//
// ```
//
// It is good practice to add headers in the HTTPRoute
// as well as the direct_response, for example to specify
// the returned Content-Type.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      exact: /v1/getProductRatings
//	  directResponse:
//	    status: 503
//	    body:
//	      string: "{\"error\": \"unknown error\"}"
//	  headers:
//	    response:
//	      set:
//	        content-type: "text/plain"
//	...
//
// ```
type HTTPDirectResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the HTTP response status to be returned.
	Status uint32 `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// Specifies the content of the response body. If this setting is omitted,
	// no body is included in the generated response.
	Body          *HTTPBody `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPDirectResponse) Reset() {
	*x = HTTPDirectResponse{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPDirectResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPDirectResponse) ProtoMessage() {}

func (x *HTTPDirectResponse) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPDirectResponse.ProtoReflect.Descriptor instead.
func (*HTTPDirectResponse) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{13}
}

func (x *HTTPDirectResponse) GetStatus() uint32 {
	if x != nil {
		return x.Status
	}
	return 0
}

func (x *HTTPDirectResponse) GetBody() *HTTPBody {
	if x != nil {
		return x.Body
	}
	return nil
}

type HTTPBody struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Specifier:
	//
	//	*HTTPBody_String_
	//	*HTTPBody_Bytes
	Specifier     isHTTPBody_Specifier `protobuf_oneof:"specifier"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPBody) Reset() {
	*x = HTTPBody{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPBody) ProtoMessage() {}

func (x *HTTPBody) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPBody.ProtoReflect.Descriptor instead.
func (*HTTPBody) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{14}
}

func (x *HTTPBody) GetSpecifier() isHTTPBody_Specifier {
	if x != nil {
		return x.Specifier
	}
	return nil
}

func (x *HTTPBody) GetString_() string {
	if x != nil {
		if x, ok := x.Specifier.(*HTTPBody_String_); ok {
			return x.String_
		}
	}
	return ""
}

func (x *HTTPBody) GetBytes() []byte {
	if x != nil {
		if x, ok := x.Specifier.(*HTTPBody_Bytes); ok {
			return x.Bytes
		}
	}
	return nil
}

type isHTTPBody_Specifier interface {
	isHTTPBody_Specifier()
}

type HTTPBody_String_ struct {
	// response body as a string
	String_ string `protobuf:"bytes,1,opt,name=string,proto3,oneof"`
}

type HTTPBody_Bytes struct {
	// response body as base64 encoded bytes.
	Bytes []byte `protobuf:"bytes,2,opt,name=bytes,proto3,oneof"`
}

func (*HTTPBody_String_) isHTTPBody_Specifier() {}

func (*HTTPBody_Bytes) isHTTPBody_Specifier() {}

// HTTPRewrite can be used to rewrite specific parts of a HTTP request
// before forwarding the request to the destination. Rewrite primitive can
// be used only with HTTPRouteDestination. The following example
// demonstrates how to rewrite the URL prefix for api call (/ratings) to
// ratings service before making the actual API call.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- match:
//	  - uri:
//	      prefix: /ratings
//	  rewrite:
//	    uri: /v1/bookRatings
//	  route:
//	  - destination:
//	      host: ratings.prod.svc.cluster.local
//	      subset: v1
//
// ```
type HTTPRewrite struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// rewrite the path (or the prefix) portion of the URI with this
	// value. If the original URI was matched based on prefix, the value
	// provided in this field will replace the corresponding matched prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// rewrite the Authority/Host header with this value.
	Authority string `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	// rewrite the path portion of the URI with the specified regex.
	UriRegexRewrite *RegexRewrite `protobuf:"bytes,3,opt,name=uri_regex_rewrite,json=uriRegexRewrite,proto3" json:"uri_regex_rewrite,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *HTTPRewrite) Reset() {
	*x = HTTPRewrite{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPRewrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRewrite) ProtoMessage() {}

func (x *HTTPRewrite) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRewrite.ProtoReflect.Descriptor instead.
func (*HTTPRewrite) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{15}
}

func (x *HTTPRewrite) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *HTTPRewrite) GetAuthority() string {
	if x != nil {
		return x.Authority
	}
	return ""
}

func (x *HTTPRewrite) GetUriRegexRewrite() *RegexRewrite {
	if x != nil {
		return x.UriRegexRewrite
	}
	return nil
}

type RegexRewrite struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// The string that should replace into matching portions of original URI.
	// Capture groups in the pattern can be referenced in the new URI.
	// Examples:
	//
	// Example 1: rewrite with capture groups
	// Path pattern "/service/update/v1/api" with match "^/service/([^/]+)(/.*)$" and
	// rewrite string of "/customprefix/\2/\1" would transform into "/customprefix/v1/api/update".
	//
	// Example 2: case insensitive rewrite
	// Path pattern "/aaa/XxX/bbb" with match "(?i)/xxx/" and a rewrite string of /yyy/ would do a
	// case-insensitive match and transform the path to "/aaa/yyy/bbb".
	Rewrite       string `protobuf:"bytes,2,opt,name=rewrite,proto3" json:"rewrite,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegexRewrite) Reset() {
	*x = RegexRewrite{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegexRewrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegexRewrite) ProtoMessage() {}

func (x *RegexRewrite) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegexRewrite.ProtoReflect.Descriptor instead.
func (*RegexRewrite) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{16}
}

func (x *RegexRewrite) GetMatch() string {
	if x != nil {
		return x.Match
	}
	return ""
}

func (x *RegexRewrite) GetRewrite() string {
	if x != nil {
		return x.Rewrite
	}
	return ""
}

// Describes how to match a given string in HTTP headers. `exact` and `prefix` matching is
// case-sensitive. `regex` matching supports case-insensitive matches.
type StringMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to MatchType:
	//
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Regex
	MatchType     isStringMatch_MatchType `protobuf_oneof:"match_type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StringMatch) Reset() {
	*x = StringMatch{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringMatch) ProtoMessage() {}

func (x *StringMatch) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringMatch.ProtoReflect.Descriptor instead.
func (*StringMatch) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{17}
}

func (x *StringMatch) GetMatchType() isStringMatch_MatchType {
	if x != nil {
		return x.MatchType
	}
	return nil
}

func (x *StringMatch) GetExact() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Exact); ok {
			return x.Exact
		}
	}
	return ""
}

func (x *StringMatch) GetPrefix() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Prefix); ok {
			return x.Prefix
		}
	}
	return ""
}

func (x *StringMatch) GetRegex() string {
	if x != nil {
		if x, ok := x.MatchType.(*StringMatch_Regex); ok {
			return x.Regex
		}
	}
	return ""
}

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
}

type StringMatch_Exact struct {
	// exact string match
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}

type StringMatch_Prefix struct {
	// prefix-based match
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}

type StringMatch_Regex struct {
	// [RE2 style regex-based match](https://github.com/google/re2/wiki/Syntax).
	//
	// Example: `(?i)^aaa$` can be used to case-insensitive match a string consisting of three a's.
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType() {}

func (*StringMatch_Prefix) isStringMatch_MatchType() {}

func (*StringMatch_Regex) isStringMatch_MatchType() {}

// Describes the retry policy to use when a HTTP request fails. For
// example, the following rule sets the maximum number of retries to 3 when
// calling ratings:v1 service, with a 2s timeout per retry attempt.
// A retry will be attempted if there is a connect-failure, refused_stream
// or when the upstream server responds with Service Unavailable(503).
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- route:
//	  - destination:
//	      host: ratings.prod.svc.cluster.local
//	      subset: v1
//	  retries:
//	    attempts: 3
//	    perTryTimeout: 2s
//	    retryOn: gateway-error,connect-failure,refused-stream
//
// ```
type HTTPRetry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of retries to be allowed for a given request. The interval
	// between retries will be determined automatically (25ms+). When request
	// `timeout` of the [HTTP route](https://istio.io/docs/reference/config/networking/virtual-service/#HTTPRoute)
	// or `per_try_timeout` is configured, the actual number of retries attempted also depends on
	// the specified request `timeout` and `per_try_timeout` values. MUST be >= 0. If `0`, retries will be disabled.
	// The maximum possible number of requests made will be 1 + `attempts`.
	Attempts int32 `protobuf:"varint,1,opt,name=attempts,proto3" json:"attempts,omitempty"`
	// Timeout per attempt for a given request, including the initial call and any retries. Format: 1h/1m/1s/1ms. MUST be >=1ms.
	// Default is same value as request
	// `timeout` of the [HTTP route](https://istio.io/docs/reference/config/networking/virtual-service/#HTTPRoute),
	// which means no timeout.
	PerTryTimeout *duration.Duration `protobuf:"bytes,2,opt,name=per_try_timeout,json=perTryTimeout,proto3" json:"per_try_timeout,omitempty"`
	// Specifies the conditions under which retry takes place.
	// One or more policies can be specified using a ‘,’ delimited list.
	// See the [retry policies](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on)
	// and [gRPC retry policies](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-grpc-on) for more details.
	//
	// In addition to the policies specified above, a list of HTTP status codes can be passed, such as `retryOn: "503,reset"`.
	// Note these status codes refer to the actual responses received from the destination.
	// For example, if a connection is reset, Istio will translate this to 503 for it's response.
	// However, the destination did not return a 503 error, so this would not match `"503"` (it would, however, match `"reset"`).
	//
	// If not specified, this defaults to `connect-failure,refused-stream,unavailable,cancelled`.
	RetryOn string `protobuf:"bytes,3,opt,name=retry_on,json=retryOn,proto3" json:"retry_on,omitempty"`
	// Flag to specify whether the retries should retry to other localities.
	// See the [retry plugin configuration](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/http/http_connection_management#retry-plugin-configuration) for more details.
	RetryRemoteLocalities *wrappers.BoolValue `protobuf:"bytes,4,opt,name=retry_remote_localities,json=retryRemoteLocalities,proto3" json:"retry_remote_localities,omitempty"`
	// Flag to specify whether the retries should ignore previously tried hosts during retry.
	// Defaults to true.
	RetryIgnorePreviousHosts *wrappers.BoolValue `protobuf:"bytes,5,opt,name=retry_ignore_previous_hosts,json=retryIgnorePreviousHosts,proto3" json:"retry_ignore_previous_hosts,omitempty"`
	// Specifies the minimum duration between retry attempts.
	// If unset, default minimum duration of 25ms is used as base interval for exponetial backoff.
	// This has an impact on the total number of retries that will be attempted based on the `attempts` field
	// and route timeout. For example, with attempts is set to 3, backoff to 2s and timeout to 3s, the request will
	// be retried only once.
	Backoff       *duration.Duration `protobuf:"bytes,6,opt,name=backoff,proto3" json:"backoff,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPRetry) Reset() {
	*x = HTTPRetry{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPRetry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRetry) ProtoMessage() {}

func (x *HTTPRetry) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRetry.ProtoReflect.Descriptor instead.
func (*HTTPRetry) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{18}
}

func (x *HTTPRetry) GetAttempts() int32 {
	if x != nil {
		return x.Attempts
	}
	return 0
}

func (x *HTTPRetry) GetPerTryTimeout() *duration.Duration {
	if x != nil {
		return x.PerTryTimeout
	}
	return nil
}

func (x *HTTPRetry) GetRetryOn() string {
	if x != nil {
		return x.RetryOn
	}
	return ""
}

func (x *HTTPRetry) GetRetryRemoteLocalities() *wrappers.BoolValue {
	if x != nil {
		return x.RetryRemoteLocalities
	}
	return nil
}

func (x *HTTPRetry) GetRetryIgnorePreviousHosts() *wrappers.BoolValue {
	if x != nil {
		return x.RetryIgnorePreviousHosts
	}
	return nil
}

func (x *HTTPRetry) GetBackoff() *duration.Duration {
	if x != nil {
		return x.Backoff
	}
	return nil
}

// Describes the Cross-Origin Resource Sharing (CORS) policy, for a given
// service. Refer to [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS)
// for further details about cross origin resource sharing. For example,
// the following rule restricts cross origin requests to those originating
// from example.com domain using HTTP POST/GET, and sets the
// `Access-Control-Allow-Credentials` header to false. In addition, it only
// exposes `X-Foo-bar` header and sets an expiry period of 1 day.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- route:
//	  - destination:
//	      host: ratings.prod.svc.cluster.local
//	      subset: v1
//	  corsPolicy:
//	    allowOrigins:
//	    - exact: https://example.com
//	    allowMethods:
//	    - POST
//	    - GET
//	    allowCredentials: false
//	    allowHeaders:
//	    - X-Foo-Bar
//	    maxAge: "24h"
//
// ```
type CorsPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The list of origins that are allowed to perform CORS requests. The
	// content will be serialized into the Access-Control-Allow-Origin
	// header. Wildcard * will allow all origins.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
	AllowOrigin []string `protobuf:"bytes,1,rep,name=allow_origin,json=allowOrigin,proto3" json:"allow_origin,omitempty"`
	// String patterns that match allowed origins.
	// An origin is allowed if any of the string matchers match.
	// If a match is found, then the outgoing Access-Control-Allow-Origin would be set to the origin as provided by the client.
	AllowOrigins []*StringMatch `protobuf:"bytes,7,rep,name=allow_origins,json=allowOrigins,proto3" json:"allow_origins,omitempty"`
	// List of HTTP methods allowed to access the resource. The content will
	// be serialized into the Access-Control-Allow-Methods header.
	AllowMethods []string `protobuf:"bytes,2,rep,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// List of HTTP headers that can be used when requesting the
	// resource. Serialized to Access-Control-Allow-Headers header.
	AllowHeaders []string `protobuf:"bytes,3,rep,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// A list of HTTP headers that the browsers are allowed to
	// access. Serialized into Access-Control-Expose-Headers header.
	ExposeHeaders []string `protobuf:"bytes,4,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies how long the results of a preflight request can be
	// cached. Translates to the `Access-Control-Max-Age` header.
	MaxAge *duration.Duration `protobuf:"bytes,5,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// Indicates whether the caller is allowed to send the actual request
	// (not the preflight) using credentials. Translates to
	// `Access-Control-Allow-Credentials` header.
	AllowCredentials *wrappers.BoolValue `protobuf:"bytes,6,opt,name=allow_credentials,json=allowCredentials,proto3" json:"allow_credentials,omitempty"`
	// Indicates whether preflight requests not matching the configured
	// allowed origin shouldn't be forwarded to the upstream.
	// Default is forward to upstream.
	UnmatchedPreflights CorsPolicy_UnmatchedPreflights `protobuf:"varint,8,opt,name=unmatched_preflights,json=unmatchedPreflights,proto3,enum=istio.networking.v1alpha3.CorsPolicy_UnmatchedPreflights" json:"unmatched_preflights,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CorsPolicy) Reset() {
	*x = CorsPolicy{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorsPolicy) ProtoMessage() {}

func (x *CorsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorsPolicy.ProtoReflect.Descriptor instead.
func (*CorsPolicy) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{19}
}

// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
func (x *CorsPolicy) GetAllowOrigin() []string {
	if x != nil {
		return x.AllowOrigin
	}
	return nil
}

func (x *CorsPolicy) GetAllowOrigins() []*StringMatch {
	if x != nil {
		return x.AllowOrigins
	}
	return nil
}

func (x *CorsPolicy) GetAllowMethods() []string {
	if x != nil {
		return x.AllowMethods
	}
	return nil
}

func (x *CorsPolicy) GetAllowHeaders() []string {
	if x != nil {
		return x.AllowHeaders
	}
	return nil
}

func (x *CorsPolicy) GetExposeHeaders() []string {
	if x != nil {
		return x.ExposeHeaders
	}
	return nil
}

func (x *CorsPolicy) GetMaxAge() *duration.Duration {
	if x != nil {
		return x.MaxAge
	}
	return nil
}

func (x *CorsPolicy) GetAllowCredentials() *wrappers.BoolValue {
	if x != nil {
		return x.AllowCredentials
	}
	return nil
}

func (x *CorsPolicy) GetUnmatchedPreflights() CorsPolicy_UnmatchedPreflights {
	if x != nil {
		return x.UnmatchedPreflights
	}
	return CorsPolicy_UNSPECIFIED
}

// HTTPFaultInjection can be used to specify one or more faults to inject
// while forwarding HTTP requests to the destination specified in a route.
// Fault specification is part of a VirtualService rule. Faults include
// aborting the Http request from downstream service, and/or delaying
// proxying of requests. A fault rule MUST HAVE delay or abort or both.
//
// *Note:* Delay and abort faults are independent of one another, even if
// both are specified simultaneously.
type HTTPFaultInjection struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Delay requests before forwarding, emulating various failures such as
	// network issues, overloaded upstream service, etc.
	Delay *HTTPFaultInjection_Delay `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
	// Abort Http request attempts and return error codes back to downstream
	// service, giving the impression that the upstream service is faulty.
	Abort         *HTTPFaultInjection_Abort `protobuf:"bytes,2,opt,name=abort,proto3" json:"abort,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPFaultInjection) Reset() {
	*x = HTTPFaultInjection{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPFaultInjection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPFaultInjection) ProtoMessage() {}

func (x *HTTPFaultInjection) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPFaultInjection.ProtoReflect.Descriptor instead.
func (*HTTPFaultInjection) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{20}
}

func (x *HTTPFaultInjection) GetDelay() *HTTPFaultInjection_Delay {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *HTTPFaultInjection) GetAbort() *HTTPFaultInjection_Abort {
	if x != nil {
		return x.Abort
	}
	return nil
}

// HTTPMirrorPolicy can be used to specify the destinations to mirror HTTP traffic in addition
// to the original destination. Mirrored traffic is on a
// best effort basis where the sidecar/gateway will not wait for the
// mirrored destinations to respond before returning the response from the
// original destination. Statistics will be generated for the mirrored
// destination.
type HTTPMirrorPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Destination specifies the target of the mirror operation.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// Percentage of the traffic to be mirrored by the `destination` field.
	// If this field is absent, all the traffic (100%) will be mirrored.
	// Max value is 100.
	Percentage    *Percent `protobuf:"bytes,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPMirrorPolicy) Reset() {
	*x = HTTPMirrorPolicy{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPMirrorPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPMirrorPolicy) ProtoMessage() {}

func (x *HTTPMirrorPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPMirrorPolicy.ProtoReflect.Descriptor instead.
func (*HTTPMirrorPolicy) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{21}
}

func (x *HTTPMirrorPolicy) GetDestination() *Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *HTTPMirrorPolicy) GetPercentage() *Percent {
	if x != nil {
		return x.Percentage
	}
	return nil
}

// PortSelector specifies the number of a port to be used for
// matching or selection for final routing.
type PortSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Valid port number
	Number        uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortSelector) Reset() {
	*x = PortSelector{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortSelector) ProtoMessage() {}

func (x *PortSelector) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortSelector.ProtoReflect.Descriptor instead.
func (*PortSelector) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{22}
}

func (x *PortSelector) GetNumber() uint32 {
	if x != nil {
		return x.Number
	}
	return 0
}

// Percent specifies a percentage in the range of [0.0, 100.0].
type Percent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         float64                `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Percent) Reset() {
	*x = Percent{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Percent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Percent) ProtoMessage() {}

func (x *Percent) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Percent.ProtoReflect.Descriptor instead.
func (*Percent) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{23}
}

func (x *Percent) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// HeaderOperations Describes the header manipulations to apply
type Headers_HeaderOperations struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Overwrite the headers specified by key with the given values
	Set map[string]string `protobuf:"bytes,1,rep,name=set,proto3" json:"set,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Append the given values to the headers specified by keys
	// (will create a comma-separated list of values)
	Add map[string]string `protobuf:"bytes,2,rep,name=add,proto3" json:"add,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Remove the specified headers
	Remove        []string `protobuf:"bytes,3,rep,name=remove,proto3" json:"remove,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Headers_HeaderOperations) Reset() {
	*x = Headers_HeaderOperations{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Headers_HeaderOperations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Headers_HeaderOperations) ProtoMessage() {}

func (x *Headers_HeaderOperations) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Headers_HeaderOperations.ProtoReflect.Descriptor instead.
func (*Headers_HeaderOperations) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Headers_HeaderOperations) GetSet() map[string]string {
	if x != nil {
		return x.Set
	}
	return nil
}

func (x *Headers_HeaderOperations) GetAdd() map[string]string {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *Headers_HeaderOperations) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

// Delay specification is used to inject latency into the request
// forwarding path. The following example will introduce a 5 second delay
// in 1 out of every 1000 requests to the "v1" version of the "reviews"
// service from all pods with label env: prod
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: reviews-route
//
// spec:
//
//	hosts:
//	- reviews.prod.svc.cluster.local
//	http:
//	- match:
//	  - sourceLabels:
//	      env: prod
//	  route:
//	  - destination:
//	      host: reviews.prod.svc.cluster.local
//	      subset: v1
//	  fault:
//	    delay:
//	      percentage:
//	        value: 0.1
//	      fixedDelay: 5s
//
// ```
//
// The _fixedDelay_ field is used to indicate the amount of delay in seconds.
// The optional _percentage_ field can be used to only delay a certain
// percentage of requests. If left unspecified, no request will be delayed.
type HTTPFaultInjection_Delay struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Percentage of requests on which the delay will be injected (0-100).
	// Use of integer `percent` value is deprecated. Use the double `percentage`
	// field instead.
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
	Percent int32 `protobuf:"varint,1,opt,name=percent,proto3" json:"percent,omitempty"`
	// Types that are valid to be assigned to HttpDelayType:
	//
	//	*HTTPFaultInjection_Delay_FixedDelay
	//	*HTTPFaultInjection_Delay_ExponentialDelay
	HttpDelayType isHTTPFaultInjection_Delay_HttpDelayType `protobuf_oneof:"http_delay_type"`
	// Percentage of requests on which the delay will be injected.
	// If left unspecified, no request will be delayed.
	Percentage    *Percent `protobuf:"bytes,5,opt,name=percentage,proto3" json:"percentage,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPFaultInjection_Delay) Reset() {
	*x = HTTPFaultInjection_Delay{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPFaultInjection_Delay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPFaultInjection_Delay) ProtoMessage() {}

func (x *HTTPFaultInjection_Delay) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPFaultInjection_Delay.ProtoReflect.Descriptor instead.
func (*HTTPFaultInjection_Delay) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{20, 0}
}

// Deprecated: Marked as deprecated in networking/v1alpha3/virtual_service.proto.
func (x *HTTPFaultInjection_Delay) GetPercent() int32 {
	if x != nil {
		return x.Percent
	}
	return 0
}

func (x *HTTPFaultInjection_Delay) GetHttpDelayType() isHTTPFaultInjection_Delay_HttpDelayType {
	if x != nil {
		return x.HttpDelayType
	}
	return nil
}

func (x *HTTPFaultInjection_Delay) GetFixedDelay() *duration.Duration {
	if x != nil {
		if x, ok := x.HttpDelayType.(*HTTPFaultInjection_Delay_FixedDelay); ok {
			return x.FixedDelay
		}
	}
	return nil
}

func (x *HTTPFaultInjection_Delay) GetExponentialDelay() *duration.Duration {
	if x != nil {
		if x, ok := x.HttpDelayType.(*HTTPFaultInjection_Delay_ExponentialDelay); ok {
			return x.ExponentialDelay
		}
	}
	return nil
}

func (x *HTTPFaultInjection_Delay) GetPercentage() *Percent {
	if x != nil {
		return x.Percentage
	}
	return nil
}

type isHTTPFaultInjection_Delay_HttpDelayType interface {
	isHTTPFaultInjection_Delay_HttpDelayType()
}

type HTTPFaultInjection_Delay_FixedDelay struct {
	// Add a fixed delay before forwarding the request. Format:
	// 1h/1m/1s/1ms. MUST be >=1ms.
	FixedDelay *duration.Duration `protobuf:"bytes,2,opt,name=fixed_delay,json=fixedDelay,proto3,oneof"`
}

type HTTPFaultInjection_Delay_ExponentialDelay struct {
	// $hide_from_docs
	ExponentialDelay *duration.Duration `protobuf:"bytes,3,opt,name=exponential_delay,json=exponentialDelay,proto3,oneof"`
}

func (*HTTPFaultInjection_Delay_FixedDelay) isHTTPFaultInjection_Delay_HttpDelayType() {}

func (*HTTPFaultInjection_Delay_ExponentialDelay) isHTTPFaultInjection_Delay_HttpDelayType() {}

// Abort specification is used to prematurely abort a request with a
// pre-specified error code. The following example will return an HTTP 400
// error code for 1 out of every 1000 requests to the "ratings" service "v1".
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//
//	name: ratings-route
//
// spec:
//
//	hosts:
//	- ratings.prod.svc.cluster.local
//	http:
//	- route:
//	  - destination:
//	      host: ratings.prod.svc.cluster.local
//	      subset: v1
//	  fault:
//	    abort:
//	      percentage:
//	        value: 0.1
//	      httpStatus: 400
//
// ```
//
// The _httpStatus_ field is used to indicate the HTTP status code to
// return to the caller. The optional _percentage_ field can be used to only
// abort a certain percentage of requests. If not specified, no request will be
// aborted.
type HTTPFaultInjection_Abort struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to ErrorType:
	//
	//	*HTTPFaultInjection_Abort_HttpStatus
	//	*HTTPFaultInjection_Abort_GrpcStatus
	//	*HTTPFaultInjection_Abort_Http2Error
	ErrorType isHTTPFaultInjection_Abort_ErrorType `protobuf_oneof:"error_type"`
	// Percentage of requests to be aborted with the error code provided.
	// If not specified, no request will be aborted.
	Percentage    *Percent `protobuf:"bytes,5,opt,name=percentage,proto3" json:"percentage,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPFaultInjection_Abort) Reset() {
	*x = HTTPFaultInjection_Abort{}
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPFaultInjection_Abort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPFaultInjection_Abort) ProtoMessage() {}

func (x *HTTPFaultInjection_Abort) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_virtual_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPFaultInjection_Abort.ProtoReflect.Descriptor instead.
func (*HTTPFaultInjection_Abort) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_virtual_service_proto_rawDescGZIP(), []int{20, 1}
}

func (x *HTTPFaultInjection_Abort) GetErrorType() isHTTPFaultInjection_Abort_ErrorType {
	if x != nil {
		return x.ErrorType
	}
	return nil
}

func (x *HTTPFaultInjection_Abort) GetHttpStatus() int32 {
	if x != nil {
		if x, ok := x.ErrorType.(*HTTPFaultInjection_Abort_HttpStatus); ok {
			return x.HttpStatus
		}
	}
	return 0
}

func (x *HTTPFaultInjection_Abort) GetGrpcStatus() string {
	if x != nil {
		if x, ok := x.ErrorType.(*HTTPFaultInjection_Abort_GrpcStatus); ok {
			return x.GrpcStatus
		}
	}
	return ""
}

func (x *HTTPFaultInjection_Abort) GetHttp2Error() string {
	if x != nil {
		if x, ok := x.ErrorType.(*HTTPFaultInjection_Abort_Http2Error); ok {
			return x.Http2Error
		}
	}
	return ""
}

func (x *HTTPFaultInjection_Abort) GetPercentage() *Percent {
	if x != nil {
		return x.Percentage
	}
	return nil
}

type isHTTPFaultInjection_Abort_ErrorType interface {
	isHTTPFaultInjection_Abort_ErrorType()
}

type HTTPFaultInjection_Abort_HttpStatus struct {
	// HTTP status code to use to abort the Http request.
	HttpStatus int32 `protobuf:"varint,2,opt,name=http_status,json=httpStatus,proto3,oneof"`
}

type HTTPFaultInjection_Abort_GrpcStatus struct {
	// GRPC status code to use to abort the request. The supported
	// codes are documented in https://github.com/grpc/grpc/blob/master/doc/statuscodes.md
	// Note: If you want to return the status "Unavailable", then you should
	// specify the code as `UNAVAILABLE`(all caps), but not `14`.
	GrpcStatus string `protobuf:"bytes,3,opt,name=grpc_status,json=grpcStatus,proto3,oneof"`
}

type HTTPFaultInjection_Abort_Http2Error struct {
	// $hide_from_docs
	Http2Error string `protobuf:"bytes,4,opt,name=http2_error,json=http2Error,proto3,oneof"`
}

func (*HTTPFaultInjection_Abort_HttpStatus) isHTTPFaultInjection_Abort_ErrorType() {}

func (*HTTPFaultInjection_Abort_GrpcStatus) isHTTPFaultInjection_Abort_ErrorType() {}

func (*HTTPFaultInjection_Abort_Http2Error) isHTTPFaultInjection_Abort_ErrorType() {}

var File_networking_v1alpha3_virtual_service_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_virtual_service_proto_rawDesc = "" +
	"\n" +
	")networking/v1alpha3/virtual_service.proto\x12\x19istio.networking.v1alpha3\x1a\x1fgoogle/api/field_behavior.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\"\x87\x02\n" +
	"\x0eVirtualService\x12\x14\n" +
	"\x05hosts\x18\x01 \x03(\tR\x05hosts\x12\x1a\n" +
	"\bgateways\x18\x02 \x03(\tR\bgateways\x128\n" +
	"\x04http\x18\x03 \x03(\v2$.istio.networking.v1alpha3.HTTPRouteR\x04http\x125\n" +
	"\x03tls\x18\x05 \x03(\v2#.istio.networking.v1alpha3.TLSRouteR\x03tls\x125\n" +
	"\x03tcp\x18\x04 \x03(\v2#.istio.networking.v1alpha3.TCPRouteR\x03tcp\x12\x1b\n" +
	"\texport_to\x18\x06 \x03(\tR\bexportTo\"|\n" +
	"\vDestination\x12\x18\n" +
	"\x04host\x18\x01 \x01(\tB\x04\xe2A\x01\x02R\x04host\x12\x16\n" +
	"\x06subset\x18\x02 \x01(\tR\x06subset\x12;\n" +
	"\x04port\x18\x03 \x01(\v2'.istio.networking.v1alpha3.PortSelectorR\x04port\"\xbb\t\n" +
	"\tHTTPRoute\x12\x12\n" +
	"\x04name\x18\x11 \x01(\tR\x04name\x12A\n" +
	"\x05match\x18\x01 \x03(\v2+.istio.networking.v1alpha3.HTTPMatchRequestR\x05match\x12E\n" +
	"\x05route\x18\x02 \x03(\v2/.istio.networking.v1alpha3.HTTPRouteDestinationR\x05route\x12C\n" +
	"\bredirect\x18\x03 \x01(\v2'.istio.networking.v1alpha3.HTTPRedirectR\bredirect\x12V\n" +
	"\x0fdirect_response\x18\x15 \x01(\v2-.istio.networking.v1alpha3.HTTPDirectResponseR\x0edirectResponse\x12?\n" +
	"\bdelegate\x18\x14 \x01(\v2#.istio.networking.v1alpha3.DelegateR\bdelegate\x12@\n" +
	"\arewrite\x18\x04 \x01(\v2&.istio.networking.v1alpha3.HTTPRewriteR\arewrite\x123\n" +
	"\atimeout\x18\x06 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x12>\n" +
	"\aretries\x18\a \x01(\v2$.istio.networking.v1alpha3.HTTPRetryR\aretries\x12C\n" +
	"\x05fault\x18\b \x01(\v2-.istio.networking.v1alpha3.HTTPFaultInjectionR\x05fault\x12>\n" +
	"\x06mirror\x18\t \x01(\v2&.istio.networking.v1alpha3.DestinationR\x06mirror\x12E\n" +
	"\amirrors\x18\x16 \x03(\v2+.istio.networking.v1alpha3.HTTPMirrorPolicyR\amirrors\x12G\n" +
	"\x0emirror_percent\x18\x12 \x01(\v2\x1c.google.protobuf.UInt32ValueB\x02\x18\x01R\rmirrorPercent\x12O\n" +
	"\x11mirror_percentage\x18\x13 \x01(\v2\".istio.networking.v1alpha3.PercentR\x10mirrorPercentage\x12F\n" +
	"\vcors_policy\x18\n" +
	" \x01(\v2%.istio.networking.v1alpha3.CorsPolicyR\n" +
	"corsPolicy\x12<\n" +
	"\aheaders\x18\x10 \x01(\v2\".istio.networking.v1alpha3.HeadersR\aheadersJ\x04\b\x05\x10\x06J\x04\b\v\x10\x10R\x11websocket_upgradeR\x0eappend_headersR\x17remove_response_headersR\x17append_response_headersR\x16remove_request_headersR\x16append_request_headers\"<\n" +
	"\bDelegate\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\"\xe6\x03\n" +
	"\aHeaders\x12M\n" +
	"\arequest\x18\x01 \x01(\v23.istio.networking.v1alpha3.Headers.HeaderOperationsR\arequest\x12O\n" +
	"\bresponse\x18\x02 \x01(\v23.istio.networking.v1alpha3.Headers.HeaderOperationsR\bresponse\x1a\xba\x02\n" +
	"\x10HeaderOperations\x12N\n" +
	"\x03set\x18\x01 \x03(\v2<.istio.networking.v1alpha3.Headers.HeaderOperations.SetEntryR\x03set\x12N\n" +
	"\x03add\x18\x02 \x03(\v2<.istio.networking.v1alpha3.Headers.HeaderOperations.AddEntryR\x03add\x12\x16\n" +
	"\x06remove\x18\x03 \x03(\tR\x06remove\x1a6\n" +
	"\bSetEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a6\n" +
	"\bAddEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x98\x01\n" +
	"\bTLSRoute\x12I\n" +
	"\x05match\x18\x01 \x03(\v2-.istio.networking.v1alpha3.TLSMatchAttributesB\x04\xe2A\x01\x02R\x05match\x12A\n" +
	"\x05route\x18\x02 \x03(\v2+.istio.networking.v1alpha3.RouteDestinationR\x05route\"\x91\x01\n" +
	"\bTCPRoute\x12B\n" +
	"\x05match\x18\x01 \x03(\v2,.istio.networking.v1alpha3.L4MatchAttributesR\x05match\x12A\n" +
	"\x05route\x18\x02 \x03(\v2+.istio.networking.v1alpha3.RouteDestinationR\x05route\"\xc5\t\n" +
	"\x10HTTPMatchRequest\x12\x12\n" +
	"\x04name\x18\v \x01(\tR\x04name\x128\n" +
	"\x03uri\x18\x01 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x03uri\x12>\n" +
	"\x06scheme\x18\x02 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x06scheme\x12>\n" +
	"\x06method\x18\x03 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x06method\x12D\n" +
	"\tauthority\x18\x04 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\tauthority\x12R\n" +
	"\aheaders\x18\x05 \x03(\v28.istio.networking.v1alpha3.HTTPMatchRequest.HeadersEntryR\aheaders\x12\x12\n" +
	"\x04port\x18\x06 \x01(\rR\x04port\x12b\n" +
	"\rsource_labels\x18\a \x03(\v2=.istio.networking.v1alpha3.HTTPMatchRequest.SourceLabelsEntryR\fsourceLabels\x12\x1a\n" +
	"\bgateways\x18\b \x03(\tR\bgateways\x12_\n" +
	"\fquery_params\x18\t \x03(\v2<.istio.networking.v1alpha3.HTTPMatchRequest.QueryParamsEntryR\vqueryParams\x12&\n" +
	"\x0fignore_uri_case\x18\n" +
	" \x01(\bR\rignoreUriCase\x12h\n" +
	"\x0fwithout_headers\x18\f \x03(\v2?.istio.networking.v1alpha3.HTTPMatchRequest.WithoutHeadersEntryR\x0ewithoutHeaders\x12)\n" +
	"\x10source_namespace\x18\r \x01(\tR\x0fsourceNamespace\x12\x1f\n" +
	"\vstat_prefix\x18\x0e \x01(\tR\n" +
	"statPrefix\x1ab\n" +
	"\fHeadersEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12<\n" +
	"\x05value\x18\x02 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x05value:\x028\x01\x1a?\n" +
	"\x11SourceLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1af\n" +
	"\x10QueryParamsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12<\n" +
	"\x05value\x18\x02 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x05value:\x028\x01\x1ai\n" +
	"\x13WithoutHeadersEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12<\n" +
	"\x05value\x18\x02 \x01(\v2&.istio.networking.v1alpha3.StringMatchR\x05value:\x028\x01\"\xa4\x02\n" +
	"\x14HTTPRouteDestination\x12N\n" +
	"\vdestination\x18\x01 \x01(\v2&.istio.networking.v1alpha3.DestinationB\x04\xe2A\x01\x02R\vdestination\x12\x16\n" +
	"\x06weight\x18\x02 \x01(\x05R\x06weight\x12<\n" +
	"\aheaders\x18\a \x01(\v2\".istio.networking.v1alpha3.HeadersR\aheadersJ\x04\b\x03\x10\aR\x17remove_response_headersR\x17append_response_headersR\x16remove_request_headersR\x16append_request_headers\"z\n" +
	"\x10RouteDestination\x12N\n" +
	"\vdestination\x18\x01 \x01(\v2&.istio.networking.v1alpha3.DestinationB\x04\xe2A\x01\x02R\vdestination\x12\x16\n" +
	"\x06weight\x18\x02 \x01(\x05R\x06weight\"\xea\x02\n" +
	"\x11L4MatchAttributes\x12/\n" +
	"\x13destination_subnets\x18\x01 \x03(\tR\x12destinationSubnets\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12#\n" +
	"\rsource_subnet\x18\x03 \x01(\tR\fsourceSubnet\x12c\n" +
	"\rsource_labels\x18\x04 \x03(\v2>.istio.networking.v1alpha3.L4MatchAttributes.SourceLabelsEntryR\fsourceLabels\x12\x1a\n" +
	"\bgateways\x18\x05 \x03(\tR\bgateways\x12)\n" +
	"\x10source_namespace\x18\x06 \x01(\tR\x0fsourceNamespace\x1a?\n" +
	"\x11SourceLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xff\x02\n" +
	"\x12TLSMatchAttributes\x12!\n" +
	"\tsni_hosts\x18\x01 \x03(\tB\x04\xe2A\x01\x02R\bsniHosts\x12/\n" +
	"\x13destination_subnets\x18\x02 \x03(\tR\x12destinationSubnets\x12\x12\n" +
	"\x04port\x18\x03 \x01(\rR\x04port\x12d\n" +
	"\rsource_labels\x18\x05 \x03(\v2?.istio.networking.v1alpha3.TLSMatchAttributes.SourceLabelsEntryR\fsourceLabels\x12\x1a\n" +
	"\bgateways\x18\x06 \x03(\tR\bgateways\x12)\n" +
	"\x10source_namespace\x18\a \x01(\tR\x0fsourceNamespace\x1a?\n" +
	"\x11SourceLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01J\x04\b\x04\x10\x05R\rsource_subnet\"\xcf\x02\n" +
	"\fHTTPRedirect\x12\x10\n" +
	"\x03uri\x18\x01 \x01(\tR\x03uri\x12\x1c\n" +
	"\tauthority\x18\x02 \x01(\tR\tauthority\x12\x14\n" +
	"\x04port\x18\x04 \x01(\rH\x00R\x04port\x12`\n" +
	"\vderive_port\x18\x05 \x01(\x0e2=.istio.networking.v1alpha3.HTTPRedirect.RedirectPortSelectionH\x00R\n" +
	"derivePort\x12\x16\n" +
	"\x06scheme\x18\x06 \x01(\tR\x06scheme\x12#\n" +
	"\rredirect_code\x18\x03 \x01(\rR\fredirectCode\"I\n" +
	"\x15RedirectPortSelection\x12\x19\n" +
	"\x15FROM_PROTOCOL_DEFAULT\x10\x00\x12\x15\n" +
	"\x11FROM_REQUEST_PORT\x10\x01B\x0f\n" +
	"\rredirect_port\"k\n" +
	"\x12HTTPDirectResponse\x12\x1c\n" +
	"\x06status\x18\x01 \x01(\rB\x04\xe2A\x01\x02R\x06status\x127\n" +
	"\x04body\x18\x02 \x01(\v2#.istio.networking.v1alpha3.HTTPBodyR\x04body\"I\n" +
	"\bHTTPBody\x12\x18\n" +
	"\x06string\x18\x01 \x01(\tH\x00R\x06string\x12\x16\n" +
	"\x05bytes\x18\x02 \x01(\fH\x00R\x05bytesB\v\n" +
	"\tspecifier\"\x92\x01\n" +
	"\vHTTPRewrite\x12\x10\n" +
	"\x03uri\x18\x01 \x01(\tR\x03uri\x12\x1c\n" +
	"\tauthority\x18\x02 \x01(\tR\tauthority\x12S\n" +
	"\x11uri_regex_rewrite\x18\x03 \x01(\v2'.istio.networking.v1alpha3.RegexRewriteR\x0furiRegexRewrite\">\n" +
	"\fRegexRewrite\x12\x14\n" +
	"\x05match\x18\x01 \x01(\tR\x05match\x12\x18\n" +
	"\arewrite\x18\x02 \x01(\tR\arewrite\"e\n" +
	"\vStringMatch\x12\x16\n" +
	"\x05exact\x18\x01 \x01(\tH\x00R\x05exact\x12\x18\n" +
	"\x06prefix\x18\x02 \x01(\tH\x00R\x06prefix\x12\x16\n" +
	"\x05regex\x18\x03 \x01(\tH\x00R\x05regexB\f\n" +
	"\n" +
	"match_type\"\xe9\x02\n" +
	"\tHTTPRetry\x12\x1a\n" +
	"\battempts\x18\x01 \x01(\x05R\battempts\x12A\n" +
	"\x0fper_try_timeout\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\rperTryTimeout\x12\x19\n" +
	"\bretry_on\x18\x03 \x01(\tR\aretryOn\x12R\n" +
	"\x17retry_remote_localities\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x15retryRemoteLocalities\x12Y\n" +
	"\x1bretry_ignore_previous_hosts\x18\x05 \x01(\v2\x1a.google.protobuf.BoolValueR\x18retryIgnorePreviousHosts\x123\n" +
	"\abackoff\x18\x06 \x01(\v2\x19.google.protobuf.DurationR\abackoff\"\x9d\x04\n" +
	"\n" +
	"CorsPolicy\x12%\n" +
	"\fallow_origin\x18\x01 \x03(\tB\x02\x18\x01R\vallowOrigin\x12K\n" +
	"\rallow_origins\x18\a \x03(\v2&.istio.networking.v1alpha3.StringMatchR\fallowOrigins\x12#\n" +
	"\rallow_methods\x18\x02 \x03(\tR\fallowMethods\x12#\n" +
	"\rallow_headers\x18\x03 \x03(\tR\fallowHeaders\x12%\n" +
	"\x0eexpose_headers\x18\x04 \x03(\tR\rexposeHeaders\x122\n" +
	"\amax_age\x18\x05 \x01(\v2\x19.google.protobuf.DurationR\x06maxAge\x12G\n" +
	"\x11allow_credentials\x18\x06 \x01(\v2\x1a.google.protobuf.BoolValueR\x10allowCredentials\x12l\n" +
	"\x14unmatched_preflights\x18\b \x01(\x0e29.istio.networking.v1alpha3.CorsPolicy.UnmatchedPreflightsR\x13unmatchedPreflights\"?\n" +
	"\x13UnmatchedPreflights\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\v\n" +
	"\aFORWARD\x10\x01\x12\n" +
	"\n" +
	"\x06IGNORE\x10\x02\"\x85\x05\n" +
	"\x12HTTPFaultInjection\x12I\n" +
	"\x05delay\x18\x01 \x01(\v23.istio.networking.v1alpha3.HTTPFaultInjection.DelayR\x05delay\x12I\n" +
	"\x05abort\x18\x02 \x01(\v23.istio.networking.v1alpha3.HTTPFaultInjection.AbortR\x05abort\x1a\x84\x02\n" +
	"\x05Delay\x12\x1c\n" +
	"\apercent\x18\x01 \x01(\x05B\x02\x18\x01R\apercent\x12<\n" +
	"\vfixed_delay\x18\x02 \x01(\v2\x19.google.protobuf.DurationH\x00R\n" +
	"fixedDelay\x12H\n" +
	"\x11exponential_delay\x18\x03 \x01(\v2\x19.google.protobuf.DurationH\x00R\x10exponentialDelay\x12B\n" +
	"\n" +
	"percentage\x18\x05 \x01(\v2\".istio.networking.v1alpha3.PercentR\n" +
	"percentageB\x11\n" +
	"\x0fhttp_delay_type\x1a\xd1\x01\n" +
	"\x05Abort\x12!\n" +
	"\vhttp_status\x18\x02 \x01(\x05H\x00R\n" +
	"httpStatus\x12!\n" +
	"\vgrpc_status\x18\x03 \x01(\tH\x00R\n" +
	"grpcStatus\x12!\n" +
	"\vhttp2_error\x18\x04 \x01(\tH\x00R\n" +
	"http2Error\x12B\n" +
	"\n" +
	"percentage\x18\x05 \x01(\v2\".istio.networking.v1alpha3.PercentR\n" +
	"percentageB\f\n" +
	"\n" +
	"error_typeJ\x04\b\x01\x10\x02R\apercent\"\xa6\x01\n" +
	"\x10HTTPMirrorPolicy\x12N\n" +
	"\vdestination\x18\x01 \x01(\v2&.istio.networking.v1alpha3.DestinationB\x04\xe2A\x01\x02R\vdestination\x12B\n" +
	"\n" +
	"percentage\x18\x02 \x01(\v2\".istio.networking.v1alpha3.PercentR\n" +
	"percentage\"2\n" +
	"\fPortSelector\x12\x16\n" +
	"\x06number\x18\x01 \x01(\rR\x06numberJ\x04\b\x02\x10\x03R\x04name\"\x1f\n" +
	"\aPercent\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05valueB\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_virtual_service_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_virtual_service_proto_rawDescData []byte
)

func file_networking_v1alpha3_virtual_service_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_virtual_service_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_virtual_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_virtual_service_proto_rawDesc), len(file_networking_v1alpha3_virtual_service_proto_rawDesc)))
	})
	return file_networking_v1alpha3_virtual_service_proto_rawDescData
}

var file_networking_v1alpha3_virtual_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_networking_v1alpha3_virtual_service_proto_msgTypes = make([]protoimpl.MessageInfo, 35)
var file_networking_v1alpha3_virtual_service_proto_goTypes = []any{
	(HTTPRedirect_RedirectPortSelection)(0), // 0: istio.networking.v1alpha3.HTTPRedirect.RedirectPortSelection
	(CorsPolicy_UnmatchedPreflights)(0),     // 1: istio.networking.v1alpha3.CorsPolicy.UnmatchedPreflights
	(*VirtualService)(nil),                  // 2: istio.networking.v1alpha3.VirtualService
	(*Destination)(nil),                     // 3: istio.networking.v1alpha3.Destination
	(*HTTPRoute)(nil),                       // 4: istio.networking.v1alpha3.HTTPRoute
	(*Delegate)(nil),                        // 5: istio.networking.v1alpha3.Delegate
	(*Headers)(nil),                         // 6: istio.networking.v1alpha3.Headers
	(*TLSRoute)(nil),                        // 7: istio.networking.v1alpha3.TLSRoute
	(*TCPRoute)(nil),                        // 8: istio.networking.v1alpha3.TCPRoute
	(*HTTPMatchRequest)(nil),                // 9: istio.networking.v1alpha3.HTTPMatchRequest
	(*HTTPRouteDestination)(nil),            // 10: istio.networking.v1alpha3.HTTPRouteDestination
	(*RouteDestination)(nil),                // 11: istio.networking.v1alpha3.RouteDestination
	(*L4MatchAttributes)(nil),               // 12: istio.networking.v1alpha3.L4MatchAttributes
	(*TLSMatchAttributes)(nil),              // 13: istio.networking.v1alpha3.TLSMatchAttributes
	(*HTTPRedirect)(nil),                    // 14: istio.networking.v1alpha3.HTTPRedirect
	(*HTTPDirectResponse)(nil),              // 15: istio.networking.v1alpha3.HTTPDirectResponse
	(*HTTPBody)(nil),                        // 16: istio.networking.v1alpha3.HTTPBody
	(*HTTPRewrite)(nil),                     // 17: istio.networking.v1alpha3.HTTPRewrite
	(*RegexRewrite)(nil),                    // 18: istio.networking.v1alpha3.RegexRewrite
	(*StringMatch)(nil),                     // 19: istio.networking.v1alpha3.StringMatch
	(*HTTPRetry)(nil),                       // 20: istio.networking.v1alpha3.HTTPRetry
	(*CorsPolicy)(nil),                      // 21: istio.networking.v1alpha3.CorsPolicy
	(*HTTPFaultInjection)(nil),              // 22: istio.networking.v1alpha3.HTTPFaultInjection
	(*HTTPMirrorPolicy)(nil),                // 23: istio.networking.v1alpha3.HTTPMirrorPolicy
	(*PortSelector)(nil),                    // 24: istio.networking.v1alpha3.PortSelector
	(*Percent)(nil),                         // 25: istio.networking.v1alpha3.Percent
	(*Headers_HeaderOperations)(nil),        // 26: istio.networking.v1alpha3.Headers.HeaderOperations
	nil,                                     // 27: istio.networking.v1alpha3.Headers.HeaderOperations.SetEntry
	nil,                                     // 28: istio.networking.v1alpha3.Headers.HeaderOperations.AddEntry
	nil,                                     // 29: istio.networking.v1alpha3.HTTPMatchRequest.HeadersEntry
	nil,                                     // 30: istio.networking.v1alpha3.HTTPMatchRequest.SourceLabelsEntry
	nil,                                     // 31: istio.networking.v1alpha3.HTTPMatchRequest.QueryParamsEntry
	nil,                                     // 32: istio.networking.v1alpha3.HTTPMatchRequest.WithoutHeadersEntry
	nil,                                     // 33: istio.networking.v1alpha3.L4MatchAttributes.SourceLabelsEntry
	nil,                                     // 34: istio.networking.v1alpha3.TLSMatchAttributes.SourceLabelsEntry
	(*HTTPFaultInjection_Delay)(nil),        // 35: istio.networking.v1alpha3.HTTPFaultInjection.Delay
	(*HTTPFaultInjection_Abort)(nil),        // 36: istio.networking.v1alpha3.HTTPFaultInjection.Abort
	(*duration.Duration)(nil),               // 37: google.protobuf.Duration
	(*wrappers.UInt32Value)(nil),            // 38: google.protobuf.UInt32Value
	(*wrappers.BoolValue)(nil),              // 39: google.protobuf.BoolValue
}
var file_networking_v1alpha3_virtual_service_proto_depIdxs = []int32{
	4,  // 0: istio.networking.v1alpha3.VirtualService.http:type_name -> istio.networking.v1alpha3.HTTPRoute
	7,  // 1: istio.networking.v1alpha3.VirtualService.tls:type_name -> istio.networking.v1alpha3.TLSRoute
	8,  // 2: istio.networking.v1alpha3.VirtualService.tcp:type_name -> istio.networking.v1alpha3.TCPRoute
	24, // 3: istio.networking.v1alpha3.Destination.port:type_name -> istio.networking.v1alpha3.PortSelector
	9,  // 4: istio.networking.v1alpha3.HTTPRoute.match:type_name -> istio.networking.v1alpha3.HTTPMatchRequest
	10, // 5: istio.networking.v1alpha3.HTTPRoute.route:type_name -> istio.networking.v1alpha3.HTTPRouteDestination
	14, // 6: istio.networking.v1alpha3.HTTPRoute.redirect:type_name -> istio.networking.v1alpha3.HTTPRedirect
	15, // 7: istio.networking.v1alpha3.HTTPRoute.direct_response:type_name -> istio.networking.v1alpha3.HTTPDirectResponse
	5,  // 8: istio.networking.v1alpha3.HTTPRoute.delegate:type_name -> istio.networking.v1alpha3.Delegate
	17, // 9: istio.networking.v1alpha3.HTTPRoute.rewrite:type_name -> istio.networking.v1alpha3.HTTPRewrite
	37, // 10: istio.networking.v1alpha3.HTTPRoute.timeout:type_name -> google.protobuf.Duration
	20, // 11: istio.networking.v1alpha3.HTTPRoute.retries:type_name -> istio.networking.v1alpha3.HTTPRetry
	22, // 12: istio.networking.v1alpha3.HTTPRoute.fault:type_name -> istio.networking.v1alpha3.HTTPFaultInjection
	3,  // 13: istio.networking.v1alpha3.HTTPRoute.mirror:type_name -> istio.networking.v1alpha3.Destination
	23, // 14: istio.networking.v1alpha3.HTTPRoute.mirrors:type_name -> istio.networking.v1alpha3.HTTPMirrorPolicy
	38, // 15: istio.networking.v1alpha3.HTTPRoute.mirror_percent:type_name -> google.protobuf.UInt32Value
	25, // 16: istio.networking.v1alpha3.HTTPRoute.mirror_percentage:type_name -> istio.networking.v1alpha3.Percent
	21, // 17: istio.networking.v1alpha3.HTTPRoute.cors_policy:type_name -> istio.networking.v1alpha3.CorsPolicy
	6,  // 18: istio.networking.v1alpha3.HTTPRoute.headers:type_name -> istio.networking.v1alpha3.Headers
	26, // 19: istio.networking.v1alpha3.Headers.request:type_name -> istio.networking.v1alpha3.Headers.HeaderOperations
	26, // 20: istio.networking.v1alpha3.Headers.response:type_name -> istio.networking.v1alpha3.Headers.HeaderOperations
	13, // 21: istio.networking.v1alpha3.TLSRoute.match:type_name -> istio.networking.v1alpha3.TLSMatchAttributes
	11, // 22: istio.networking.v1alpha3.TLSRoute.route:type_name -> istio.networking.v1alpha3.RouteDestination
	12, // 23: istio.networking.v1alpha3.TCPRoute.match:type_name -> istio.networking.v1alpha3.L4MatchAttributes
	11, // 24: istio.networking.v1alpha3.TCPRoute.route:type_name -> istio.networking.v1alpha3.RouteDestination
	19, // 25: istio.networking.v1alpha3.HTTPMatchRequest.uri:type_name -> istio.networking.v1alpha3.StringMatch
	19, // 26: istio.networking.v1alpha3.HTTPMatchRequest.scheme:type_name -> istio.networking.v1alpha3.StringMatch
	19, // 27: istio.networking.v1alpha3.HTTPMatchRequest.method:type_name -> istio.networking.v1alpha3.StringMatch
	19, // 28: istio.networking.v1alpha3.HTTPMatchRequest.authority:type_name -> istio.networking.v1alpha3.StringMatch
	29, // 29: istio.networking.v1alpha3.HTTPMatchRequest.headers:type_name -> istio.networking.v1alpha3.HTTPMatchRequest.HeadersEntry
	30, // 30: istio.networking.v1alpha3.HTTPMatchRequest.source_labels:type_name -> istio.networking.v1alpha3.HTTPMatchRequest.SourceLabelsEntry
	31, // 31: istio.networking.v1alpha3.HTTPMatchRequest.query_params:type_name -> istio.networking.v1alpha3.HTTPMatchRequest.QueryParamsEntry
	32, // 32: istio.networking.v1alpha3.HTTPMatchRequest.without_headers:type_name -> istio.networking.v1alpha3.HTTPMatchRequest.WithoutHeadersEntry
	3,  // 33: istio.networking.v1alpha3.HTTPRouteDestination.destination:type_name -> istio.networking.v1alpha3.Destination
	6,  // 34: istio.networking.v1alpha3.HTTPRouteDestination.headers:type_name -> istio.networking.v1alpha3.Headers
	3,  // 35: istio.networking.v1alpha3.RouteDestination.destination:type_name -> istio.networking.v1alpha3.Destination
	33, // 36: istio.networking.v1alpha3.L4MatchAttributes.source_labels:type_name -> istio.networking.v1alpha3.L4MatchAttributes.SourceLabelsEntry
	34, // 37: istio.networking.v1alpha3.TLSMatchAttributes.source_labels:type_name -> istio.networking.v1alpha3.TLSMatchAttributes.SourceLabelsEntry
	0,  // 38: istio.networking.v1alpha3.HTTPRedirect.derive_port:type_name -> istio.networking.v1alpha3.HTTPRedirect.RedirectPortSelection
	16, // 39: istio.networking.v1alpha3.HTTPDirectResponse.body:type_name -> istio.networking.v1alpha3.HTTPBody
	18, // 40: istio.networking.v1alpha3.HTTPRewrite.uri_regex_rewrite:type_name -> istio.networking.v1alpha3.RegexRewrite
	37, // 41: istio.networking.v1alpha3.HTTPRetry.per_try_timeout:type_name -> google.protobuf.Duration
	39, // 42: istio.networking.v1alpha3.HTTPRetry.retry_remote_localities:type_name -> google.protobuf.BoolValue
	39, // 43: istio.networking.v1alpha3.HTTPRetry.retry_ignore_previous_hosts:type_name -> google.protobuf.BoolValue
	37, // 44: istio.networking.v1alpha3.HTTPRetry.backoff:type_name -> google.protobuf.Duration
	19, // 45: istio.networking.v1alpha3.CorsPolicy.allow_origins:type_name -> istio.networking.v1alpha3.StringMatch
	37, // 46: istio.networking.v1alpha3.CorsPolicy.max_age:type_name -> google.protobuf.Duration
	39, // 47: istio.networking.v1alpha3.CorsPolicy.allow_credentials:type_name -> google.protobuf.BoolValue
	1,  // 48: istio.networking.v1alpha3.CorsPolicy.unmatched_preflights:type_name -> istio.networking.v1alpha3.CorsPolicy.UnmatchedPreflights
	35, // 49: istio.networking.v1alpha3.HTTPFaultInjection.delay:type_name -> istio.networking.v1alpha3.HTTPFaultInjection.Delay
	36, // 50: istio.networking.v1alpha3.HTTPFaultInjection.abort:type_name -> istio.networking.v1alpha3.HTTPFaultInjection.Abort
	3,  // 51: istio.networking.v1alpha3.HTTPMirrorPolicy.destination:type_name -> istio.networking.v1alpha3.Destination
	25, // 52: istio.networking.v1alpha3.HTTPMirrorPolicy.percentage:type_name -> istio.networking.v1alpha3.Percent
	27, // 53: istio.networking.v1alpha3.Headers.HeaderOperations.set:type_name -> istio.networking.v1alpha3.Headers.HeaderOperations.SetEntry
	28, // 54: istio.networking.v1alpha3.Headers.HeaderOperations.add:type_name -> istio.networking.v1alpha3.Headers.HeaderOperations.AddEntry
	19, // 55: istio.networking.v1alpha3.HTTPMatchRequest.HeadersEntry.value:type_name -> istio.networking.v1alpha3.StringMatch
	19, // 56: istio.networking.v1alpha3.HTTPMatchRequest.QueryParamsEntry.value:type_name -> istio.networking.v1alpha3.StringMatch
	19, // 57: istio.networking.v1alpha3.HTTPMatchRequest.WithoutHeadersEntry.value:type_name -> istio.networking.v1alpha3.StringMatch
	37, // 58: istio.networking.v1alpha3.HTTPFaultInjection.Delay.fixed_delay:type_name -> google.protobuf.Duration
	37, // 59: istio.networking.v1alpha3.HTTPFaultInjection.Delay.exponential_delay:type_name -> google.protobuf.Duration
	25, // 60: istio.networking.v1alpha3.HTTPFaultInjection.Delay.percentage:type_name -> istio.networking.v1alpha3.Percent
	25, // 61: istio.networking.v1alpha3.HTTPFaultInjection.Abort.percentage:type_name -> istio.networking.v1alpha3.Percent
	62, // [62:62] is the sub-list for method output_type
	62, // [62:62] is the sub-list for method input_type
	62, // [62:62] is the sub-list for extension type_name
	62, // [62:62] is the sub-list for extension extendee
	0,  // [0:62] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_virtual_service_proto_init() }
func file_networking_v1alpha3_virtual_service_proto_init() {
	if File_networking_v1alpha3_virtual_service_proto != nil {
		return
	}
	file_networking_v1alpha3_virtual_service_proto_msgTypes[12].OneofWrappers = []any{
		(*HTTPRedirect_Port)(nil),
		(*HTTPRedirect_DerivePort)(nil),
	}
	file_networking_v1alpha3_virtual_service_proto_msgTypes[14].OneofWrappers = []any{
		(*HTTPBody_String_)(nil),
		(*HTTPBody_Bytes)(nil),
	}
	file_networking_v1alpha3_virtual_service_proto_msgTypes[17].OneofWrappers = []any{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Regex)(nil),
	}
	file_networking_v1alpha3_virtual_service_proto_msgTypes[33].OneofWrappers = []any{
		(*HTTPFaultInjection_Delay_FixedDelay)(nil),
		(*HTTPFaultInjection_Delay_ExponentialDelay)(nil),
	}
	file_networking_v1alpha3_virtual_service_proto_msgTypes[34].OneofWrappers = []any{
		(*HTTPFaultInjection_Abort_HttpStatus)(nil),
		(*HTTPFaultInjection_Abort_GrpcStatus)(nil),
		(*HTTPFaultInjection_Abort_Http2Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_virtual_service_proto_rawDesc), len(file_networking_v1alpha3_virtual_service_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   35,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_virtual_service_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_virtual_service_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_virtual_service_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_virtual_service_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_virtual_service_proto = out.File
	file_networking_v1alpha3_virtual_service_proto_goTypes = nil
	file_networking_v1alpha3_virtual_service_proto_depIdxs = nil
}
