/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

public class InlineUtil {
    public static boolean isInlineParameterExceptNullability(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            InlineUtil.$$$reportNull$$$0(0);
        }
        return (!(valueParameterOrReceiver instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)valueParameterOrReceiver).isNoinline()) && FunctionTypesKt.isBuiltinFunctionalType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInlineParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        if (valueParameterOrReceiver == null) {
            InlineUtil.$$$reportNull$$$0(1);
        }
        return InlineUtil.isInlineParameterExceptNullability(valueParameterOrReceiver) && !valueParameterOrReceiver.getOriginal().getType().isMarkedNullable();
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isInline();
    }

    public static boolean hasInlineAccessors(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            InlineUtil.$$$reportNull$$$0(2);
        }
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
        return getter2 != null && getter2.isInline() || setter2 != null && setter2.isInline();
    }

    public static boolean isPropertyWithAllAccessorsAreInline(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            InlineUtil.$$$reportNull$$$0(3);
        }
        if (!(descriptor instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyGetterDescriptor getter2 = ((PropertyDescriptor)descriptor).getGetter();
        if (getter2 == null || !getter2.isInline()) {
            return false;
        }
        if (((PropertyDescriptor)descriptor).isVar()) {
            PropertySetterDescriptor setter2 = ((PropertyDescriptor)descriptor).getSetter();
            return setter2 != null && setter2.isInline();
        }
        return true;
    }

    public static boolean isInlineOrContainingInline(@Nullable DeclarationDescriptor descriptor) {
        if (InlineUtil.isInline(descriptor)) {
            return true;
        }
        if (descriptor == null) {
            return false;
        }
        return InlineUtil.isInlineOrContainingInline(descriptor.getContainingDeclaration());
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull KtExpression startExpression, @NotNull ResolutionContext<?> context2) {
        Object containingFunction;
        if (fromFunction == null) {
            InlineUtil.$$$reportNull$$$0(4);
        }
        if (startExpression == null) {
            InlineUtil.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            InlineUtil.$$$reportNull$$$0(6);
        }
        if ((containingFunction = context2.getContextParentOfType(startExpression, KtClassOrObject.class, KtDeclarationWithBody.class)) == null) {
            return false;
        }
        return InlineUtil.checkNonLocalReturnUsage(fromFunction, context2.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction), containingFunction, context2.trace.getBindingContext());
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @Nullable DeclarationDescriptor containingFunctionDescriptor, @Nullable PsiElement containingFunction, @NotNull BindingContext bindingContext) {
        if (fromFunction == null) {
            InlineUtil.$$$reportNull$$$0(7);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(8);
        }
        if (containingFunctionDescriptor == null) {
            return false;
        }
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            Boolean isLambdaDefinitelyInline = bindingContext.get(BindingContext.NEW_INFERENCE_IS_LAMBDA_FOR_OVERLOAD_RESOLUTION_INLINE, containingFunction);
            if (isLambdaDefinitelyInline != null) {
                return isLambdaDefinitelyInline;
            }
            if (!InlineUtil.isInlinedArgument((KtFunction)containingFunction, bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull KtFunction argument, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        ValueParameterDescriptor descriptor;
        if (argument == null) {
            InlineUtil.$$$reportNull$$$0(9);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(10);
        }
        if ((descriptor = InlineUtil.getInlineArgumentDescriptor(argument, bindingContext)) != null) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(descriptor);
        }
        return false;
    }

    @Nullable
    public static ValueParameterDescriptor getInlineArgumentDescriptor(@NotNull KtFunction argument, @NotNull BindingContext bindingContext) {
        if (argument == null) {
            InlineUtil.$$$reportNull$$$0(11);
        }
        if (bindingContext == null) {
            InlineUtil.$$$reportNull$$$0(12);
        }
        if (!InlineUtil.canBeInlineArgument(argument)) {
            return null;
        }
        KtExpression call2 = KtPsiUtil.getParentCallIfPresent(argument);
        if (call2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        CallableDescriptor descriptor = resolvedCall2.getResultingDescriptor();
        if (!InlineUtil.isInline(descriptor) && !InlineUtil.isArrayConstructorWithLambda(descriptor)) {
            return null;
        }
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), argument);
        if (valueArgument == null) {
            return null;
        }
        ArgumentMapping mapping = resolvedCall2.getArgumentMapping(valueArgument);
        if (!(mapping instanceof ArgumentMatch)) {
            return null;
        }
        ValueParameterDescriptor parameter = ((ArgumentMatch)mapping).getValueParameter();
        return InlineUtil.isInlineParameter(parameter) ? parameter : null;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof KtFunctionLiteral || functionalExpression instanceof KtNamedFunction;
    }

    public static boolean isArrayConstructorWithLambda(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            InlineUtil.$$$reportNull$$$0(13);
        }
        return descriptor.getValueParameters().size() == 2 && descriptor instanceof ConstructorDescriptor && KotlinBuiltIns.isArrayOrPrimitiveArray(((ConstructorDescriptor)descriptor).getConstructedClass());
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor, boolean strict) {
        DeclarationDescriptor current;
        if (descriptor == null) {
            InlineUtil.$$$reportNull$$$0(14);
        }
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor.getContainingDeclaration() : descriptor;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda) {
        if (lambda == null) {
            InlineUtil.$$$reportNull$$$0(15);
        }
        return !(lambda instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)lambda).isCrossinline();
    }

    public static boolean isInlinableParameterExpression(@Nullable KtExpression deparenthesized) {
        return deparenthesized instanceof KtLambdaExpression || deparenthesized instanceof KtNamedFunction || deparenthesized instanceof KtCallableReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParameterOrReceiver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 3: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFunction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/inline/InlineUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlineParameterExceptNullability";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlineParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInlineAccessors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyWithAllAccessorsAreInline";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNonLocalReturnUsage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isInlinedArgument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getInlineArgumentDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayConstructorWithLambda";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getContainingClassOrFunctionDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "allowsNonLocalReturns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

