/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandBranchInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BIntInstr
extends TwoOperandBranchInstr
implements FixedArityInstr {
    private final Op op;

    public BIntInstr(Label jumpTarget, Op op, Operand v1, Operand v2) {
        super(Operation.B_INT, jumpTarget, v1, v2);
        this.op = op;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BIntInstr(ii.getRenamedLabel(this.getJumpTarget()), this.op, this.getArg1().cloneForInlining(ii), this.getArg2().cloneForInlining(ii));
    }

    public static BIntInstr decode(IRReaderDecoder d) {
        Label label2 = d.decodeLabel();
        Operand arg1 = d.decodeOperand();
        Operand arg2 = d.decodeOperand();
        return new BIntInstr(label2, Op.fromOrdinal(d.decodeInt()), arg1, arg2);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.op.ordinal());
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        int value1 = (Integer)this.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
        int value2 = (Integer)this.getArg2().retrieve(context, self2, currScope, currDynScope, temp);
        return (switch (this.op.ordinal()) {
            case 0 -> value1 < value2;
            case 1 -> value1 > value2;
            case 2 -> value1 <= value2;
            case 3 -> value1 >= value2;
            case 4 -> value1 == value2;
            case 5 -> value1 != value2;
            default -> throw new RuntimeException("BIntInstr has unknown op");
        }) ? this.getJumpTarget().getTargetPC() : ipc;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BIntInstr(this);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{this.op.toString()};
    }

    public Op getOp() {
        return this.op;
    }

    public static enum Op {
        LT("<"),
        GT(">"),
        LTE("<="),
        GTE(">="),
        EQ("=="),
        NEQ("!=");

        private final String label;

        private Op(String label2) {
            this.label = label2;
        }

        public String toString() {
            return this.label;
        }

        public static Op fromOrdinal(int value2) {
            return value2 < 0 || value2 >= Op.values().length ? null : Op.values()[value2];
        }
    }
}

