/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class EncryptedDataKeyDescriptionOutput {
    private final String keyProviderId;
    private final String keyProviderInfo;
    private final String branchKeyId;
    private final String branchKeyVersion;

    protected EncryptedDataKeyDescriptionOutput(BuilderImpl builder) {
        this.keyProviderId = builder.keyProviderId();
        this.keyProviderInfo = builder.keyProviderInfo();
        this.branchKeyId = builder.branchKeyId();
        this.branchKeyVersion = builder.branchKeyVersion();
    }

    public String keyProviderId() {
        return this.keyProviderId;
    }

    public String keyProviderInfo() {
        return this.keyProviderInfo;
    }

    public String branchKeyId() {
        return this.branchKeyId;
    }

    public String branchKeyVersion() {
        return this.branchKeyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyProviderId;
        protected String keyProviderInfo;
        protected String branchKeyId;
        protected String branchKeyVersion;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptedDataKeyDescriptionOutput model) {
            this.keyProviderId = model.keyProviderId();
            this.keyProviderInfo = model.keyProviderInfo();
            this.branchKeyId = model.branchKeyId();
            this.branchKeyVersion = model.branchKeyVersion();
        }

        @Override
        public Builder keyProviderId(String keyProviderId) {
            this.keyProviderId = keyProviderId;
            return this;
        }

        @Override
        public String keyProviderId() {
            return this.keyProviderId;
        }

        @Override
        public Builder keyProviderInfo(String keyProviderInfo) {
            this.keyProviderInfo = keyProviderInfo;
            return this;
        }

        @Override
        public String keyProviderInfo() {
            return this.keyProviderInfo;
        }

        @Override
        public Builder branchKeyId(String branchKeyId) {
            this.branchKeyId = branchKeyId;
            return this;
        }

        @Override
        public String branchKeyId() {
            return this.branchKeyId;
        }

        @Override
        public Builder branchKeyVersion(String branchKeyVersion) {
            this.branchKeyVersion = branchKeyVersion;
            return this;
        }

        @Override
        public String branchKeyVersion() {
            return this.branchKeyVersion;
        }

        @Override
        public EncryptedDataKeyDescriptionOutput build() {
            if (Objects.isNull(this.keyProviderId())) {
                throw new IllegalArgumentException("Missing value for required field `keyProviderId`");
            }
            return new EncryptedDataKeyDescriptionOutput(this);
        }
    }

    public static interface Builder {
        public Builder keyProviderId(String var1);

        public String keyProviderId();

        public Builder keyProviderInfo(String var1);

        public String keyProviderInfo();

        public Builder branchKeyId(String var1);

        public String branchKeyId();

        public Builder branchKeyVersion(String var1);

        public String branchKeyVersion();

        public EncryptedDataKeyDescriptionOutput build();
    }
}

