/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.StorageChannelUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.function.Consumer;

final class Buffers {
    private Buffers() {
    }

    static void clear(Buffer b) {
        b.clear();
    }

    static void flip(Buffer b) {
        b.flip();
    }

    static void limit(Buffer b, int limit) {
        b.limit(limit);
    }

    static void position(Buffer b, int position) {
        b.position(position);
    }

    static int position(Buffer b) {
        return b.position();
    }

    static int remaining(Buffer b) {
        return b.remaining();
    }

    static boolean hasRemaining(Buffer b) {
        return b.hasRemaining();
    }

    static void compact(ByteBuffer b) {
        b.compact();
    }

    static long copy(ByteBuffer content, ByteBuffer dst) {
        return Buffers.copy(content, new ByteBuffer[]{dst}, 0, 1);
    }

    static long copy(ByteBuffer content, ByteBuffer[] dsts) {
        return Buffers.copy(content, dsts, 0, dsts.length);
    }

    static long copy(ByteBuffer content, ByteBuffer[] dsts, int offset, int length) {
        int contentRemaining;
        long total = 0L;
        for (int i = offset; i < length && (contentRemaining = content.remaining()) > 0; ++i) {
            ByteBuffer buf = dsts[i];
            int bufRemaining = buf.remaining();
            if (bufRemaining == 0) continue;
            if (bufRemaining < contentRemaining) {
                Buffers.sliceAndConsume(content, bufRemaining, buf::put);
            } else {
                buf.put(content);
            }
            int written = bufRemaining - buf.remaining();
            total += (long)written;
        }
        return total;
    }

    static void sliceAndConsume(ByteBuffer src, int limit, Consumer<ByteBuffer> c) {
        ByteBuffer slice = src.slice();
        slice.limit(limit);
        c.accept(slice);
        Buffers.position(src, src.position() + limit);
    }

    static ByteBuffer allocate(long l) {
        return ByteBuffer.allocate(Math.toIntExact(l));
    }

    static ByteBuffer allocate(int i) {
        return ByteBuffer.allocate(i);
    }

    static ByteBuffer allocateAligned(int size, int alignmentMultiple) {
        int actualSize = Buffers.alignSize(size, alignmentMultiple);
        return Buffers.allocate(actualSize);
    }

    static int alignSize(int size, int alignmentMultiple) {
        int alignedSize = size;
        if (size < alignmentMultiple) {
            alignedSize = alignmentMultiple;
        } else if (size % alignmentMultiple != 0) {
            alignedSize = (size + alignmentMultiple - 1) / alignmentMultiple * alignmentMultiple;
        }
        return alignedSize;
    }

    static int fillFrom(ByteBuffer buf, ReadableByteChannel c) throws IOException {
        return StorageChannelUtils.blockingFillFrom(buf, c);
    }

    static int emptyTo(ByteBuffer buf, WritableByteChannel c) throws IOException {
        return StorageChannelUtils.blockingEmptyTo(buf, c);
    }

    static long totalRemaining(ByteBuffer[] buffers, int offset, int length) {
        long totalRemaning = 0L;
        for (int i = offset; i < length; ++i) {
            ByteBuffer buffer = buffers[i];
            totalRemaning += (long)buffer.remaining();
        }
        return totalRemaning;
    }

    static long copyUsingBuffer(ByteBuffer buf, ReadableByteChannel r, WritableByteChannel w) throws IOException {
        long total = 0L;
        while (r.read(buf) != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                total += (long)w.write(buf);
            }
            buf.clear();
        }
        return total;
    }
}

