/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.storage.RewindableContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;

@BetaApi
@InternalExtensionOnly
public final class RequestBody {
    private final RewindableContent content;

    private RequestBody(RewindableContent content) {
        this.content = content;
    }

    RewindableContent getContent() {
        return this.content;
    }

    @BetaApi
    public static RequestBody empty() {
        return new RequestBody(RewindableContent.empty());
    }

    @BetaApi
    public static RequestBody of(ByteBuffer ... buffers) {
        return new RequestBody(RewindableContent.of(buffers));
    }

    @BetaApi
    public static RequestBody of(ByteBuffer[] srcs, int srcsOffset, int srcsLength) {
        return new RequestBody(RewindableContent.of(srcs, srcsOffset, srcsLength));
    }

    @BetaApi
    public static RequestBody of(Path path) throws IOException {
        return new RequestBody(RewindableContent.of(path));
    }
}

