/*
 * Copyright Collabora Ltd
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include <stdint.h>

#pragma once
#include "util/macros.h"

struct panlib_clear_afbc_metadata_args {
   uint64_t p;
   uint32_t layer_or_slice_stride;
} PACKED;

static_assert(offsetof(struct panlib_clear_afbc_metadata_args, p) == 0, "");
static_assert(offsetof(struct panlib_clear_afbc_metadata_args, layer_or_slice_stride) == 8, "");
static_assert(sizeof(struct panlib_clear_afbc_metadata_args) == 12, "");

struct panlib_copy_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint8_t _pad5[4];
   uint64_t dst_addr;
   uint64_t dst_stride;
   uint32_t query_type;
   uint32_t flags;
   uint32_t report_count;
} PACKED;

static_assert(offsetof(struct panlib_copy_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_copy_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_copy_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_copy_query_result_args, dst_addr) == 32, "");
static_assert(offsetof(struct panlib_copy_query_result_args, dst_stride) == 40, "");
static_assert(offsetof(struct panlib_copy_query_result_args, query_type) == 48, "");
static_assert(offsetof(struct panlib_copy_query_result_args, flags) == 52, "");
static_assert(offsetof(struct panlib_copy_query_result_args, report_count) == 56, "");
static_assert(sizeof(struct panlib_copy_query_result_args) == 60, "");

struct panlib_clear_query_result_args {
   uint64_t pool_addr;
   uint64_t available_addr;
   uint32_t query_stride;
   uint32_t first_query;
   uint32_t query_count;
   uint32_t report_count;
   uint32_t availaible_value;
} PACKED;

static_assert(offsetof(struct panlib_clear_query_result_args, pool_addr) == 0, "");
static_assert(offsetof(struct panlib_clear_query_result_args, available_addr) == 8, "");
static_assert(offsetof(struct panlib_clear_query_result_args, query_stride) == 16, "");
static_assert(offsetof(struct panlib_clear_query_result_args, first_query) == 20, "");
static_assert(offsetof(struct panlib_clear_query_result_args, query_count) == 24, "");
static_assert(offsetof(struct panlib_clear_query_result_args, report_count) == 28, "");
static_assert(offsetof(struct panlib_clear_query_result_args, availaible_value) == 32, "");
static_assert(sizeof(struct panlib_clear_query_result_args) == 36, "");

struct panlib_draw_indirect_helper_args {
   uint64_t cmd;
   uint64_t varying_bufs_descs;
   uint64_t varying_bufs_info;
   uint64_t attrib_bufs_descs;
   uint64_t attrib_bufs_infos;
   uint32_t attrib_bufs_valid;
   uint32_t attribs_valid;
   uint64_t attribs_descs;
   uint64_t attribs_infos;
   uint64_t first_vertex_sysval;
   uint64_t first_instance_sysval;
   uint64_t raw_vertex_offset_sysval;
   uint64_t idvs_job;
   uint64_t vertex_job;
   uint64_t tiler_job;
   uint32_t primitive_vertex_count;
} PACKED;

static_assert(offsetof(struct panlib_draw_indirect_helper_args, cmd) == 0, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, varying_bufs_descs) == 8, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, varying_bufs_info) == 16, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attrib_bufs_descs) == 24, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attrib_bufs_infos) == 32, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attrib_bufs_valid) == 40, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attribs_valid) == 44, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attribs_descs) == 48, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, attribs_infos) == 56, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, first_vertex_sysval) == 64, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, first_instance_sysval) == 72, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, raw_vertex_offset_sysval) == 80, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, idvs_job) == 88, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, vertex_job) == 96, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, tiler_job) == 104, "");
static_assert(offsetof(struct panlib_draw_indirect_helper_args, primitive_vertex_count) == 112, "");
static_assert(sizeof(struct panlib_draw_indirect_helper_args) == 116, "");

struct panlib_draw_indexed_indirect_helper_args {
   uint64_t cmd;
   uint64_t index_buffer_ptr;
   uint64_t index_min_max_res;
   uint32_t index_size;
   uint32_t primitive_vertex_count;
   uint32_t attrib_bufs_valid;
   uint32_t attribs_valid;
   uint64_t varying_bufs_descs;
   uint64_t varying_bufs_info;
   uint64_t attrib_bufs_descs;
   uint64_t attrib_bufs_infos;
   uint64_t attribs_descs;
   uint64_t attribs_infos;
   uint64_t first_vertex_sysval;
   uint64_t first_instance_sysval;
   uint64_t raw_vertex_offset_sysval;
   uint64_t idvs_job;
   uint64_t vertex_job;
   uint64_t tiler_job;
} PACKED;

static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, cmd) == 0, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, index_buffer_ptr) == 8, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, index_min_max_res) == 16, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, index_size) == 24, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, primitive_vertex_count) == 28, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attrib_bufs_valid) == 32, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attribs_valid) == 36, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, varying_bufs_descs) == 40, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, varying_bufs_info) == 48, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attrib_bufs_descs) == 56, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attrib_bufs_infos) == 64, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attribs_descs) == 72, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, attribs_infos) == 80, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, first_vertex_sysval) == 88, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, first_instance_sysval) == 96, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, raw_vertex_offset_sysval) == 104, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, idvs_job) == 112, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, vertex_job) == 120, "");
static_assert(offsetof(struct panlib_draw_indexed_indirect_helper_args, tiler_job) == 128, "");
static_assert(sizeof(struct panlib_draw_indexed_indirect_helper_args) == 136, "");

struct panlib_draw_index_minmax_search_helper_args {
   uint64_t index_buffer_ptr;
   uint64_t cmd;
   uint64_t min_ptr;
   uint64_t max_ptr;
} PACKED;

static_assert(offsetof(struct panlib_draw_index_minmax_search_helper_args, index_buffer_ptr) == 0, "");
static_assert(offsetof(struct panlib_draw_index_minmax_search_helper_args, cmd) == 8, "");
static_assert(offsetof(struct panlib_draw_index_minmax_search_helper_args, min_ptr) == 16, "");
static_assert(offsetof(struct panlib_draw_index_minmax_search_helper_args, max_ptr) == 24, "");
static_assert(sizeof(struct panlib_draw_index_minmax_search_helper_args) == 32, "");

struct panlib_indirect_dispatch_args {
   uint64_t cmd;
   uint32_t size_x;
   uint32_t size_y;
   uint32_t size_z;
   uint8_t _pad4[4];
   uint64_t indirect_job;
   uint64_t num_wg_sysval_x;
   uint64_t num_wg_sysval_y;
   uint64_t num_wg_sysval_z;
} PACKED;

static_assert(offsetof(struct panlib_indirect_dispatch_args, cmd) == 0, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_x) == 8, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_y) == 12, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, size_z) == 16, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, indirect_job) == 24, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_x) == 32, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_y) == 40, "");
static_assert(offsetof(struct panlib_indirect_dispatch_args, num_wg_sysval_z) == 48, "");
static_assert(sizeof(struct panlib_indirect_dispatch_args) == 56, "");

enum libpan_shaders_program {
    PANLIB_CLEAR_AFBC_METADATA = 0,
    PANLIB_COPY_QUERY_RESULT = 1,
    PANLIB_CLEAR_QUERY_RESULT = 2,
    PANLIB_DRAW_INDIRECT_HELPER = 3,
    PANLIB_DRAW_INDEXED_INDIRECT_HELPER = 4,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_0 = 5,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_1 = 6,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_2 = 7,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_3 = 8,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_4 = 9,
    PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_5 = 10,
    PANLIB_INDIRECT_DISPATCH = 11,
    LIBPAN_SHADERS_NUM_PROGRAMS,
};

static inline unsigned
PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER(unsigned index_bytes_log2__3, unsigned primitive_restart__2)
{
   assert(index_bytes_log2__3 < 3);
   assert(primitive_restart__2 < 2);

   unsigned idx = primitive_restart__2;
   idx = (idx * 3) + index_bytes_log2__3;

   assert(idx < 6);
   return PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER_0 + idx;
}


#define panlib_clear_afbc_metadata_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_clear_afbc_metadata_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_AFBC_METADATA, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_afbc_metadata(_context, _grid, _barrier, p, layer_or_slice_stride) do { \
   struct panlib_clear_afbc_metadata_args _args = {p, layer_or_slice_stride};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_AFBC_METADATA, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_copy_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_copy_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, dst_addr, dst_stride, query_type, flags, report_count) do { \
   struct panlib_copy_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, {0}, dst_addr, dst_stride, query_type, flags, report_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_COPY_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_query_result_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_clear_query_result_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_clear_query_result(_context, _grid, _barrier, pool_addr, available_addr, query_stride, first_query, query_count, report_count, availaible_value) do { \
   struct panlib_clear_query_result_args _args = {pool_addr, available_addr, query_stride, first_query, query_count, report_count, availaible_value};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_CLEAR_QUERY_RESULT, &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_indirect_helper_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_draw_indirect_helper_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDIRECT_HELPER, &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_indirect_helper(_context, _grid, _barrier, cmd, varying_bufs_descs, varying_bufs_info, attrib_bufs_descs, attrib_bufs_infos, attrib_bufs_valid, attribs_valid, attribs_descs, attribs_infos, first_vertex_sysval, first_instance_sysval, raw_vertex_offset_sysval, idvs_job, vertex_job, tiler_job, primitive_vertex_count) do { \
   struct panlib_draw_indirect_helper_args _args = {cmd, varying_bufs_descs, varying_bufs_info, attrib_bufs_descs, attrib_bufs_infos, attrib_bufs_valid, attribs_valid, attribs_descs, attribs_infos, first_vertex_sysval, first_instance_sysval, raw_vertex_offset_sysval, idvs_job, vertex_job, tiler_job, primitive_vertex_count};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDIRECT_HELPER, &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_indexed_indirect_helper_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_draw_indexed_indirect_helper_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDEXED_INDIRECT_HELPER, &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_indexed_indirect_helper(_context, _grid, _barrier, cmd, index_buffer_ptr, index_min_max_res, index_size, primitive_vertex_count, attrib_bufs_valid, attribs_valid, varying_bufs_descs, varying_bufs_info, attrib_bufs_descs, attrib_bufs_infos, attribs_descs, attribs_infos, first_vertex_sysval, first_instance_sysval, raw_vertex_offset_sysval, idvs_job, vertex_job, tiler_job) do { \
   struct panlib_draw_indexed_indirect_helper_args _args = {cmd, index_buffer_ptr, index_min_max_res, index_size, primitive_vertex_count, attrib_bufs_valid, attribs_valid, varying_bufs_descs, varying_bufs_info, attrib_bufs_descs, attrib_bufs_infos, attribs_descs, attribs_infos, first_vertex_sysval, first_instance_sysval, raw_vertex_offset_sysval, idvs_job, vertex_job, tiler_job};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDEXED_INDIRECT_HELPER, &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_index_minmax_search_helper_struct(_context, _grid, _barrier, _data, index_bytes_log2__3, primitive_restart__2) do { \
   struct panlib_draw_index_minmax_search_helper_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER(index_bytes_log2__3, primitive_restart__2), &_args, sizeof(_args)); \
} while(0);

#define panlib_draw_index_minmax_search_helper(_context, _grid, _barrier, index_buffer_ptr, cmd, min_ptr, max_ptr, index_bytes_log2__3, primitive_restart__2) do { \
   struct panlib_draw_index_minmax_search_helper_args _args = {index_buffer_ptr, cmd, min_ptr, max_ptr};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_DRAW_INDEX_MINMAX_SEARCH_HELPER(index_bytes_log2__3, primitive_restart__2), &_args, sizeof(_args)); \
} while(0);

#define panlib_indirect_dispatch_struct(_context, _grid, _barrier, _data) do { \
   struct panlib_indirect_dispatch_args _args = _data;\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_INDIRECT_DISPATCH, &_args, sizeof(_args)); \
} while(0);

#define panlib_indirect_dispatch(_context, _grid, _barrier, cmd, size_x, size_y, size_z, indirect_job, num_wg_sysval_x, num_wg_sysval_y, num_wg_sysval_z) do { \
   struct panlib_indirect_dispatch_args _args = {cmd, size_x, size_y, size_z, {0}, indirect_job, num_wg_sysval_x, num_wg_sysval_y, num_wg_sysval_z};\
   MESA_DISPATCH_PRECOMP(_context, _grid, _barrier, PANLIB_INDIRECT_DISPATCH, &_args, sizeof(_args)); \
} while(0);


extern const uint32_t *libpan_shaders_default_v6[LIBPAN_SHADERS_NUM_PROGRAMS];
