/*
    replace: a mini-app to replace a token in a string with another token.
    Copyright (C) 2006, Aaron Griffin <aaronmgriffin@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <stdio.h>
#include <string.h>

int main(int argc, char **argv)
{
    int q = 0;
    char* with_what = " ";
    char* tok = NULL;

    if(argc < 3 || argc > 5)
        printf("usage: %s [-q] <string> <to replace> [<with what>]",argv[0]);

    //use -q to quote output
    if(strcmp(argv[1],"-q") == 0) q = 1;

    if(argc == 4+q) with_what = argv[3+q];

    tok = strtok(argv[1+q],argv[2+q]);
    while(tok)
    {
        if(q) printf("\"%s\"",tok);
        else printf("%s",tok);

        tok = strtok(NULL,argv[2+q]);
        if(tok) printf("%s",with_what);
    }
    printf("\n");

    return 0;
}

