# netcfg interface...
import os.path

profile_dir="/etc/network.d/"
state_dir="/var/run/network/profiles/"

def read_config(config):
    import shlex
    cfg = shlex.split(open(config, "r").read())
    options = {}
    for line in cfg:
        (var, delim, value) = line.partition('=')  
        if delim and var.lstrip()[0] != "#":
            options[var] = value
    return options

def get_profiles():
    profs= [Profile(x) for x in os.listdir(profile_dir) if not os.path.isdir(os.path.join(profile_dir,x)) ]   
    return [x for x in profs if x.has_key("CONNECTION")]
   
def get_active_profiles():
    profs=[Profile(x) for x in os.listdir(state_dir) if not os.path.isdir(os.path.join(state_dir,x)) ]   
    return [x for x in profs if x.has_key("CONNECTION")]
class Profile (dict):

    def __init__(self,profile_name):
        self.name=profile_name
        self.filename=os.path.join(profile_dir, profile_name)
        self.update(read_config(self.filename))

    def active(self):
        return os.path.isfile(os.path.join(state_dir,self.name))


