/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 64 bit ELF emulation code for aarch64elfb
   Copyright (C) 1991-2025 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_aarch64elfb

#include "sysdep.h"
#include "bfd.h"
#include "libiberty.h"
#include "getopt.h"
#include "bfdlink.h"
#include "ctf-api.h"
#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldlex.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf-bfd.h"
#include "ldelf.h"
#include "ldelfgen.h"

/* Declare functions used by various EXTRA_EM_FILEs.  */
static void gldaarch64elfb_before_parse (void);
static void gldaarch64elfb_before_plugin_all_symbols_read
  (void);
static void gldaarch64elfb_after_open (void);
static void gldaarch64elfb_before_allocation (void);
static void gldaarch64elfb_after_allocation (void);


#include "ldctor.h"
#include "elf/aarch64.h"
#include "elfxx-aarch64.h"

static int no_enum_size_warning = 0;
static int no_wchar_size_warning = 0;
static int pic_veneer = 0;
static int fix_erratum_835769 = 0;
static erratum_84319_opts fix_erratum_843419 = ERRAT_NONE;
static int no_apply_dynamic_relocs = 0;
static aarch64_protection_opts sw_protections = {
  .plt_type = PLT_NORMAL,
  .bti_report = MARKING_WARN,
  .gcs_type = GCS_IMPLICIT,
  .gcs_report = MARKING_WARN,
  .gcs_report_dynamic = MARKING_UNSET,
};

#define COMPILE_TIME_STRLEN(s)   (sizeof(s) - 1)

static void
gldaarch64elfb_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("aarch64", bfd_arch_unknown);
#endif /* not TARGET_ */
  input_flags.dynamic = true;
  config.has_shared = true;
  config.separate_code = false;
  link_info.check_relocs_after_open_input = true;
  link_info.separate_code = DEFAULT_LD_Z_SEPARATE_CODE;
  link_info.warn_execstack = DEFAULT_LD_WARN_EXECSTACK;
  link_info.no_warn_rwx_segments = ! DEFAULT_LD_WARN_RWX_SEGMENTS;
  link_info.default_execstack = DEFAULT_LD_EXECSTACK;
}

static void
aarch64_elf_before_allocation (void)
{
  /* We should be able to set the size of the interworking stub section.  We
     can't do it until later if we have dynamic sections, though.  */
  if (! elf_hash_table (&link_info)->dynamic_sections_created)
    {
      /* Here we rummage through the found bfds to collect information.  */
      LANG_FOR_EACH_INPUT_STATEMENT (is)
      {
	/* Initialise mapping tables for code/data.  */
	bfd_elf64_aarch64_init_maps (is->the_bfd);
      }
    }

  /* Call the standard elf routine.  */
  gldaarch64elfb_before_allocation ();
}

/* Fake input file for stubs.  */
static lang_input_statement_type *stub_file;

/* Whether we need to call gldarm_layout_sections_again.  */
static int need_laying_out = 0;

/* Maximum size of a group of input sections that can be handled by
   one stub section.  A value of +/-1 indicates the bfd back-end
   should use a suitable default size.  */
static bfd_signed_vma group_size = 1;

struct hook_stub_info
{
  lang_statement_list_type add;
  asection *input_section;
};

/* Traverse the linker tree to find the spot where the stub goes.  */

static bool
hook_in_stub (struct hook_stub_info *info, lang_statement_union_type **lp)
{
  lang_statement_union_type *l;
  bool ret;

  for (; (l = *lp) != NULL; lp = &l->header.next)
    {
      switch (l->header.type)
	{
	case lang_constructors_statement_enum:
	  ret = hook_in_stub (info, &constructor_list.head);
	  if (ret)
	    return ret;
	  break;

	case lang_output_section_statement_enum:
	  ret = hook_in_stub (info,
			      &l->output_section_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_wild_statement_enum:
	  ret = hook_in_stub (info, &l->wild_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_group_statement_enum:
	  ret = hook_in_stub (info, &l->group_statement.children.head);
	  if (ret)
	    return ret;
	  break;

	case lang_input_section_enum:
	  if (l->input_section.section == info->input_section)
	    {
	      /* We've found our section.  Insert the stub immediately
		 after its associated input section.  */
	      *(info->add.tail) = l->header.next;
	      l->header.next = info->add.head;
	      return true;
	    }
	  break;

	case lang_data_statement_enum:
	case lang_reloc_statement_enum:
	case lang_object_symbols_statement_enum:
	case lang_output_statement_enum:
	case lang_target_statement_enum:
	case lang_input_statement_enum:
	case lang_assignment_statement_enum:
	case lang_padding_statement_enum:
	case lang_address_statement_enum:
	case lang_fill_statement_enum:
	  break;

	default:
	  FAIL ();
	  break;
	}
    }
  return false;
}


/* Call-back for elf64_aarch64_size_stubs.  */

/* Create a new stub section, and arrange for it to be linked
   immediately after INPUT_SECTION.  */

static asection *
elf64_aarch64_add_stub_section (const char *stub_sec_name,
					asection *input_section)
{
  asection *stub_sec;
  flagword flags;
  asection *output_section;
  lang_output_section_statement_type *os;
  struct hook_stub_info info;

  flags = (SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_CODE
	   | SEC_HAS_CONTENTS | SEC_RELOC | SEC_IN_MEMORY | SEC_KEEP);
  stub_sec = bfd_make_section_anyway_with_flags (stub_file->the_bfd,
						 stub_sec_name, flags);
  if (stub_sec == NULL)
    goto err_ret;

  /* Long branch stubs contain a 64-bit address, so the section requires
     8 byte alignment.  */
  bfd_set_section_alignment (stub_sec, 3);

  output_section = input_section->output_section;
  os = lang_output_section_get (output_section);

  info.input_section = input_section;
  lang_list_init (&info.add);
  lang_add_section (&info.add, stub_sec, NULL, NULL, os);

  if (info.add.head == NULL)
    goto err_ret;

  if (hook_in_stub (&info, &os->children.head))
    return stub_sec;

 err_ret:
  einfo (_("%X%P: can not make stub section: %E\n"));
  return NULL;
}

/* Another call-back for elf64_aarch64_size_stubs.  */

static void
gldaarch64_layout_sections_again (void)
{
  /* If we have changed sizes of the stub sections, then we need
     to recalculate all the section offsets.  This may mean we need to
     add even more stubs.  */
  ldelf_map_segments (true);
  need_laying_out = -1;
}

static void
build_section_lists (lang_statement_union_type *statement)
{
  if (statement->header.type == lang_input_section_enum)
    {
      asection *i = statement->input_section.section;

      if (!bfd_input_just_syms (i->owner)
	  && (i->flags & SEC_EXCLUDE) == 0
	  && i->output_section != NULL
	  && i->output_section->owner == link_info.output_bfd)
	elf64_aarch64_next_input_section (& link_info, i);
    }
}

static void
gldaarch64elfb_after_allocation (void)
{
  int ret;

  /* bfd_elf32_discard_info just plays with debugging sections,
     ie. doesn't affect any code, so we can delay resizing the
     sections.  It's likely we'll resize everything in the process of
     adding stubs.  */
  ret = bfd_elf_discard_info (link_info.output_bfd, & link_info);
  if (ret < 0)
    {
      einfo (_("%X%P: .eh_frame/.stab edit: %E\n"));
      return;
    }
  else if (ret > 0)
    need_laying_out = 1;

  /* If generating a relocatable output file, then we don't
     have to examine the relocs.  */
  if (stub_file != NULL && !bfd_link_relocatable (&link_info))
    {
      ret = elf64_aarch64_setup_section_lists (link_info.output_bfd,
						       &link_info);
      if (ret != 0)
	{
	  if (ret < 0)
	    {
	      einfo (_("%X%P: could not compute sections lists "
		       "for stub generation: %E\n"));
	      return;
	    }

	  lang_for_each_statement (build_section_lists);

	  /* Call into the BFD backend to do the real work.  */
	  if (! elf64_aarch64_size_stubs (link_info.output_bfd,
					  stub_file->the_bfd,
					  & link_info,
					  group_size,
					  & elf64_aarch64_add_stub_section,
					  & gldaarch64_layout_sections_again))
	    {
	      einfo (_("%X%P: can not size stub section: %E\n"));
	      return;
	    }
	}
    }

  if (need_laying_out != -1)
    ldelf_map_segments (need_laying_out);
}

static void
gldaarch64elfb_finish (void)
{
  if (!bfd_link_relocatable (&link_info))
    {
      /* Now build the linker stubs.  */
      if (stub_file->the_bfd->sections != NULL)
	{
	  if (! elf64_aarch64_build_stubs (& link_info))
	    einfo (_("%X%P: can not build stubs: %E\n"));
	}
    }

  ldelf_finish ();
}

/* This is a convenient point to tell BFD about target specific flags.
   After the output has been created, but before inputs are read.  */
static void
aarch64_elf_create_output_section_statements (void)
{
  if (strstr (bfd_get_target (link_info.output_bfd), "aarch64") == NULL)
    {
      /* The AArch64 backend needs special fields in the output hash structure.
	 These will only be created if the output format is an AArch64 format,
	 hence we do not support linking and changing output formats at the
	 same time.  Use a link followed by objcopy to change output formats.  */
      einfo (_("%F%P: error: cannot change output format "
	       "whilst linking %s binaries\n"), "AArch64");
      return;
    }

  bfd_elf64_aarch64_set_options (link_info.output_bfd, &link_info,
				 no_enum_size_warning,
				 no_wchar_size_warning,
				 pic_veneer,
				 fix_erratum_835769, fix_erratum_843419,
				 no_apply_dynamic_relocs,
				 &sw_protections);

  stub_file = lang_add_input_file ("linker stubs",
				   lang_input_file_is_fake_enum,
				   NULL);
  stub_file->the_bfd = bfd_create ("linker stubs", link_info.output_bfd);
  if (stub_file->the_bfd == NULL
      || ! bfd_set_arch_mach (stub_file->the_bfd,
			      bfd_get_arch (link_info.output_bfd),
			      bfd_get_mach (link_info.output_bfd)))
    {
      einfo (_("%F%P: can not create BFD: %E\n"));
      return;
    }

  stub_file->the_bfd->flags |= BFD_LINKER_CREATED;
  ldlang_add_file (stub_file);
}

static bool
aarch64_parse_feature_report_option (const char *_optarg,
				     const char *report_opt,
				     const size_t report_opt_len,
				     bool allow_empty_value,
				     aarch64_feature_marking_report *level)
{
  if (strncmp (_optarg, report_opt, report_opt_len) != 0)
    return false;

  if (strcmp (_optarg + report_opt_len, "=warning") == 0)
    *level = MARKING_WARN;
  else if (strcmp (_optarg + report_opt_len, "=none") == 0)
    *level = MARKING_NONE;
  else if (strcmp (_optarg + report_opt_len, "=error") == 0)
    *level = MARKING_ERROR;
  else if (allow_empty_value && strlen (_optarg) == report_opt_len)
    *level = MARKING_WARN;
  else
    einfo (_("%X%P: error: unrecognized value '-z %s'\n"), _optarg);

  return true;
}

static bool
aarch64_parse_bti_report_option (const char *_optarg)
{
  #define BTI_REPORT      "bti-report"
  #define BTI_REPORT_LEN  COMPILE_TIME_STRLEN (BTI_REPORT)

  return aarch64_parse_feature_report_option (_optarg, BTI_REPORT,
    BTI_REPORT_LEN, true, &sw_protections.bti_report);

  #undef BTI_REPORT
  #undef BTI_REPORT_LEN
}

static bool
aarch64_parse_gcs_report_option (const char *_optarg)
{
  #define GCS_REPORT      "gcs-report"
  #define GCS_REPORT_LEN  COMPILE_TIME_STRLEN (GCS_REPORT)

  return aarch64_parse_feature_report_option (_optarg, GCS_REPORT,
    GCS_REPORT_LEN, true, &sw_protections.gcs_report);

  #undef GCS_REPORT
  #undef GCS_REPORT_LEN
}

static bool
aarch64_parse_gcs_report_dynamic_option (const char *_optarg)
{
  #define GCS_REPORT_DYNAMIC      "gcs-report-dynamic"
  #define GCS_REPORT_DYNAMIC_LEN  COMPILE_TIME_STRLEN (GCS_REPORT_DYNAMIC)

  return aarch64_parse_feature_report_option (_optarg, GCS_REPORT_DYNAMIC,
    GCS_REPORT_DYNAMIC_LEN, false, &sw_protections.gcs_report_dynamic);

  #undef GCS_REPORT_DYNAMIC
  #undef GCS_REPORT_DYNAMIC_LEN
}

static bool
aarch64_parse_gcs_option (const char *_optarg)
{
  #define GCS      "gcs"
  #define GCS_LEN  COMPILE_TIME_STRLEN (GCS)

  if (strncmp (_optarg, GCS, GCS_LEN) != 0)
    return false;

  if (strcmp (_optarg + GCS_LEN, "=always") == 0)
    sw_protections.gcs_type = GCS_ALWAYS;
  else if (strcmp (_optarg + GCS_LEN, "=never") == 0)
    sw_protections.gcs_type = GCS_NEVER;
  else if (strcmp (_optarg + GCS_LEN, "=implicit") == 0)
    sw_protections.gcs_type = GCS_IMPLICIT;
  else
    einfo (_("%X%P: error: unrecognized value '-z %s'\n"), _optarg);

  return true;

  #undef GCS
  #undef GCS_LEN
}

/* These variables are used to implement target options */

static char *audit; /* colon (typically) separated list of libs */
static char *depaudit; /* colon (typically) separated list of libs */


/* This is called before calling plugin 'all symbols read' hook.  */

static void
gldaarch64elfb_before_plugin_all_symbols_read (void)
{
  ldelf_before_plugin_all_symbols_read (false, false,
				        true,
					false,
					64, "/usr");
}

/* This is called after all the input files have been opened.  */

static void
gldaarch64elfb_after_open (void)
{
  ldelf_after_open (false, false,
		    true, false, 64, "/usr");
}


/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldaarch64elfb_before_allocation (void)
{
  ldelf_before_allocation (audit, depaudit, NULL);
}


static char *
gldaarch64elfb_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/aarch64elfb.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/aarch64elfb.xr";
  else if (!config.text_read_only)
    return "ldscripts/aarch64elfb.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/aarch64elfb.xn";
  else if (bfd_link_pie (&link_info)
	   && link_info.combreloc
	   && link_info.relro
	   && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xdwer";
	  else
	    return "ldscripts/aarch64elfb.xdwe";
	}
      else
	return "ldscripts/aarch64elfb.xdw";
    }
  else if (bfd_link_pie (&link_info)
	   && link_info.combreloc)
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xdcer";
	  else
	    return "ldscripts/aarch64elfb.xdce";
	}
      else
	return "ldscripts/aarch64elfb.xdc";
    }
  else if (bfd_link_pie (&link_info))
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xder";
	  else
	    return "ldscripts/aarch64elfb.xde";
	}
      else
	return "ldscripts/aarch64elfb.xd";
    }
  else if (bfd_link_dll (&link_info) && link_info.combreloc
	   && link_info.relro && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xswer";
	  else
	    return "ldscripts/aarch64elfb.xswe";
	}
      else
	return "ldscripts/aarch64elfb.xsw";
    }
  else if (bfd_link_dll (&link_info) && link_info.combreloc)
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xscer";
	  else
	    return "ldscripts/aarch64elfb.xsce";
	}
      else
	return "ldscripts/aarch64elfb.xsc";
    }
  else if (bfd_link_dll (&link_info))
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xser";
	  else
	    return "ldscripts/aarch64elfb.xse";
	}
      else
	return "ldscripts/aarch64elfb.xs";
    }
  else if (link_info.combreloc && link_info.relro
	   && (link_info.flags & DF_BIND_NOW))
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xwer";
	  else
	    return "ldscripts/aarch64elfb.xwe";
	}
      else
	return "ldscripts/aarch64elfb.xw";
    }
  else if (link_info.combreloc)
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xcer";
	  else
	    return "ldscripts/aarch64elfb.xce";
	}
      else
	return "ldscripts/aarch64elfb.xc";
    }
  else
    {
      if (link_info.separate_code)
	{
	  if (link_info.one_rosegment)
	    return "ldscripts/aarch64elfb.xer";
	  else
	    return "ldscripts/aarch64elfb.xe";
	}
      else
	return "ldscripts/aarch64elfb.x";
    }
}


static void
gldaarch64elfb_add_options
  (int ns, char **shortopts, int nl, struct option **longopts,
   int nrl ATTRIBUTE_UNUSED, struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const char xtra_short[] = "pz:P:";
  static const struct option xtra_long[] = {
    {"audit", required_argument, NULL, OPTION_AUDIT},
    {"Bgroup", no_argument, NULL, OPTION_GROUP},
    {"build-id", optional_argument, NULL, OPTION_BUILD_ID},
    {"package-metadata", optional_argument, NULL, OPTION_PACKAGE_METADATA},
    {"compress-debug-sections", required_argument, NULL, OPTION_COMPRESS_DEBUG},
    {"rosegment", no_argument, NULL, OPTION_ROSEGMENT},
    {"no-rosegment", no_argument, NULL, OPTION_NO_ROSEGMENT},
    {"depaudit", required_argument, NULL, 'P'},
    {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
    {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
    {"eh-frame-hdr", no_argument, NULL, OPTION_EH_FRAME_HDR},
    {"no-eh-frame-hdr", no_argument, NULL, OPTION_NO_EH_FRAME_HDR},
    {"exclude-libs", required_argument, NULL, OPTION_EXCLUDE_LIBS},
    {"hash-style", required_argument, NULL, OPTION_HASH_STYLE},
    
  { "no-pipeline-knowledge", no_argument, NULL, 'p'},
  { "no-enum-size-warning", no_argument, NULL, OPTION_NO_ENUM_SIZE_WARNING},
  { "pic-veneer", no_argument, NULL, OPTION_PIC_VENEER},
  { "stub-group-size", required_argument, NULL, OPTION_STUBGROUP_SIZE },
  { "no-wchar-size-warning", no_argument, NULL, OPTION_NO_WCHAR_SIZE_WARNING},
  { "fix-cortex-a53-835769", no_argument, NULL, OPTION_FIX_ERRATUM_835769},
  { "fix-cortex-a53-843419", optional_argument, NULL, OPTION_FIX_ERRATUM_843419},
  { "no-apply-dynamic-relocs", no_argument, NULL, OPTION_NO_APPLY_DYNAMIC_RELOCS},

    {NULL, no_argument, NULL, 0}
  };

  *shortopts = (char *) xrealloc (*shortopts, ns + sizeof (xtra_short));
  memcpy (*shortopts + ns, &xtra_short, sizeof (xtra_short));
  *longopts = (struct option *)
    xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

#define DEFAULT_BUILD_ID_STYLE	"sha1"

static bool
gldaarch64elfb_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return false;

    case OPTION_BUILD_ID:
      free ((char *) ldelf_emit_note_gnu_build_id);
      ldelf_emit_note_gnu_build_id = NULL;
      if (optarg == NULL)
	optarg = DEFAULT_BUILD_ID_STYLE;
      if (strcmp (optarg, "none"))
	ldelf_emit_note_gnu_build_id = xstrdup (optarg);
      break;

    case OPTION_PACKAGE_METADATA:
      free ((char *) ldelf_emit_note_fdo_package_metadata);
      ldelf_emit_note_fdo_package_metadata = NULL;
      if (optarg != NULL)
	{
	  size_t len = strlen (optarg);
	  if (len > 0)
	    {
	      char *package_metadata = xmalloc (len + 1);
	      percent_decode (optarg, package_metadata);
	      ldelf_emit_note_fdo_package_metadata = package_metadata;
	    }
	}
      break;

    case OPTION_COMPRESS_DEBUG:
      config.compress_debug = bfd_get_compression_algorithm (optarg);
      if (strcasecmp (optarg, "zstd") == 0)
	{
#ifndef HAVE_ZSTD
	  if (config.compress_debug == COMPRESS_DEBUG_ZSTD)
	    einfo (_ ("%F%P: --compress-debug-sections=zstd: ld is not built "
		  "with zstd support\n"));
#endif
	}
      if (config.compress_debug == COMPRESS_UNKNOWN)
	einfo (_("%F%P: invalid --compress-debug-sections option: `%s'\n"),
	       optarg);
      break;

    case OPTION_ROSEGMENT:
      link_info.one_rosegment = true;
      break;
    case OPTION_NO_ROSEGMENT:
      link_info.one_rosegment = false;
      break;      
    case OPTION_AUDIT:
	ldelf_append_to_separated_string (&audit, optarg);
	break;

    case 'P':
	ldelf_append_to_separated_string (&depaudit, optarg);
	break;

    case OPTION_DISABLE_NEW_DTAGS:
      link_info.new_dtags = false;
      break;

    case OPTION_ENABLE_NEW_DTAGS:
      link_info.new_dtags = true;
      break;

    case OPTION_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = DWARF2_EH_HDR;
      break;

    case OPTION_NO_EH_FRAME_HDR:
      link_info.eh_frame_hdr_type = 0;
      break;

    case OPTION_GROUP:
      link_info.flags_1 |= (bfd_vma) DF_1_GROUP;
      /* Groups must be self-contained.  */
      link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      link_info.unresolved_syms_in_shared_libs = RM_DIAGNOSE;
      break;

    case OPTION_EXCLUDE_LIBS:
      add_excluded_libs (optarg);
      break;

    case OPTION_HASH_STYLE:
      link_info.emit_hash = false;
      link_info.emit_gnu_hash = false;
      if (strcmp (optarg, "sysv") == 0)
	link_info.emit_hash = true;
      else if (strcmp (optarg, "gnu") == 0)
	link_info.emit_gnu_hash = true;
      else if (strcmp (optarg, "both") == 0)
	{
	  link_info.emit_hash = true;
	  link_info.emit_gnu_hash = true;
	}
      else
	einfo (_("%F%P: invalid hash style `%s'\n"), optarg);
      break;

    case 'z':
      if (strcmp (optarg, "defs") == 0)
	link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      else if (strcmp (optarg, "undefs") == 0)
	link_info.unresolved_syms_in_objects = RM_IGNORE;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = true;
      else if (startswith (optarg, "max-page-size="))
	{
	  char *end;

	  link_info.maxpagesize = strtoul (optarg + 14, &end, 0);
	  if (*end
	      || (link_info.maxpagesize & (link_info.maxpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid maximum page size `%s'\n"),
		   optarg + 14);
	  link_info.maxpagesize_is_set = true;
	}
      else if (startswith (optarg, "common-page-size="))
	{
	  char *end;
	  link_info.commonpagesize = strtoul (optarg + 17, &end, 0);
	  if (*end
	      || (link_info.commonpagesize & (link_info.commonpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid common page size `%s'\n"),
		   optarg + 17);
	  link_info.commonpagesize_is_set = true;
	}
      else if (startswith (optarg, "stack-size="))
	{
	  char *end;
	  link_info.stacksize = strtoul (optarg + 11, &end, 0);
	  if (*end || link_info.stacksize < 0)
	    einfo (_("%F%P: invalid stack size `%s'\n"), optarg + 11);
	  if (!link_info.stacksize)
	    /* Use -1 for explicit no-stack, because zero means
	       'default'.   */
	    link_info.stacksize = -1;
	}
      else if (strcmp (optarg, "execstack") == 0)
	{
	  link_info.execstack = true;
	  link_info.noexecstack = false;
	}
      else if (strcmp (optarg, "noexecstack") == 0)
	{
	  link_info.noexecstack = true;
	  link_info.execstack = false;
	}
      else if (strcmp (optarg, "unique-symbol") == 0)
	link_info.unique_symbol = true;
      else if (strcmp (optarg, "nounique-symbol") == 0)
	link_info.unique_symbol = false;
      else if (strcmp (optarg, "globalaudit") == 0)
	{
	  link_info.flags_1 |= DF_1_GLOBAUDIT;
	}
      else if (startswith (optarg, "start-stop-gc"))
	link_info.start_stop_gc = true;
      else if (startswith (optarg, "nostart-stop-gc"))
	link_info.start_stop_gc = false;
      else if (startswith (optarg, "start-stop-visibility="))
	{
	  if (strcmp (optarg, "start-stop-visibility=default") == 0)
	    link_info.start_stop_visibility = STV_DEFAULT;
	  else if (strcmp (optarg, "start-stop-visibility=internal") == 0)
	    link_info.start_stop_visibility = STV_INTERNAL;
	  else if (strcmp (optarg, "start-stop-visibility=hidden") == 0)
	    link_info.start_stop_visibility = STV_HIDDEN;
	  else if (strcmp (optarg, "start-stop-visibility=protected") == 0)
	    link_info.start_stop_visibility = STV_PROTECTED;
	  else
	    einfo (_("%F%P: invalid visibility in `-z %s'; "
		     "must be default, internal, hidden, or protected"),
		   optarg);
	}
      else if (strcmp (optarg, "sectionheader") == 0)
	config.no_section_header = false;
      else if (strcmp (optarg, "nosectionheader") == 0)
	config.no_section_header = true;
      else if (strcmp (optarg, "global") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_GLOBAL;
      else if (strcmp (optarg, "initfirst") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INITFIRST;
      else if (strcmp (optarg, "interpose") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INTERPOSE;
      else if (strcmp (optarg, "loadfltr") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_LOADFLTR;
      else if (strcmp (optarg, "nodefaultlib") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODEFLIB;
      else if (strcmp (optarg, "nodelete") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODELETE;
      else if (strcmp (optarg, "nodlopen") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NOOPEN;
      else if (strcmp (optarg, "nodump") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODUMP;
      else if (strcmp (optarg, "now") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 |= (bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "lazy") == 0)
	{
	  link_info.flags &= ~(bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 &= ~(bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "origin") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_ORIGIN;
	  link_info.flags_1 |= (bfd_vma) DF_1_ORIGIN;
	}
      else if (strcmp (optarg, "unique") == 0)
	link_info.gnu_flags_1 |= (bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "nounique") == 0)
	link_info.gnu_flags_1 &= ~(bfd_vma) DF_GNU_1_UNIQUE;
      else if (strcmp (optarg, "combreloc") == 0)
	link_info.combreloc = true;
      else if (strcmp (optarg, "nocombreloc") == 0)
	link_info.combreloc = false;
      else if (strcmp (optarg, "nocopyreloc") == 0)
	link_info.nocopyreloc = true;
      else if (strcmp (optarg, "memory-seal") == 0)
       link_info.memory_seal = true;
      else if (strcmp (optarg, "nomemory-seal") == 0)
       link_info.memory_seal = false;
      else if (strcmp (optarg, "separate-code") == 0)
	link_info.separate_code = true;
      else if (strcmp (optarg, "noseparate-code") == 0)
	link_info.separate_code = false;
      else if (strcmp (optarg, "common") == 0)
	link_info.elf_stt_common = elf_stt_common;
      else if (strcmp (optarg, "nocommon") == 0)
	link_info.elf_stt_common = no_elf_stt_common;
      else if (strcmp (optarg, "text") == 0)
	link_info.textrel_check = textrel_check_error;
      else if (strcmp (optarg, "notext") == 0)
	link_info.textrel_check = textrel_check_none;
      else if (strcmp (optarg, "textoff") == 0)
	link_info.textrel_check = textrel_check_none;
  
      else if (strcmp (optarg, "pack-relative-relocs") == 0)
	link_info.enable_dt_relr = true;
      else if (strcmp (optarg, "nopack-relative-relocs") == 0)
	link_info.enable_dt_relr = false;
 
     else if (strcmp (optarg, "force-bti") == 0)
	sw_protections.plt_type |= PLT_BTI;
     else if (aarch64_parse_bti_report_option (optarg))
	{}
     else if (strcmp (optarg, "pac-plt") == 0)
	sw_protections.plt_type |= PLT_PAC;
     else if (aarch64_parse_gcs_report_dynamic_option (optarg))
	{}
     else if (aarch64_parse_gcs_report_option (optarg))
	{}
     else if (aarch64_parse_gcs_option (optarg))
	{}

      else
	queue_unknown_cmdline_warning ("-z %s", optarg);
      break;
 
    case 'p':
      /* Only here for backwards compatibility.  */
      break;

    case OPTION_NO_ENUM_SIZE_WARNING:
      no_enum_size_warning = 1;
      break;

    case OPTION_NO_WCHAR_SIZE_WARNING:
      no_wchar_size_warning = 1;
      break;

    case OPTION_PIC_VENEER:
      pic_veneer = 1;
      break;

    case OPTION_FIX_ERRATUM_835769:
      fix_erratum_835769 = 1;
      break;

    case OPTION_FIX_ERRATUM_843419:
      fix_erratum_843419 = ERRAT_ADR | ERRAT_ADRP;
      if (optarg && *optarg)
	{
	  if (strcmp ("full", optarg) == 0)
	    fix_erratum_843419 = ERRAT_ADR | ERRAT_ADRP;
	  else if (strcmp ("adrp", optarg) == 0)
	    fix_erratum_843419 = ERRAT_ADRP;
	  else if (strcmp ("adr", optarg) == 0)
	    fix_erratum_843419 = ERRAT_ADR;
	  else
	    einfo (_("%P: error: unrecognized option for "
		     "--fix-cortex-a53-843419: %s\n"), optarg);
	}
      break;

    case OPTION_NO_APPLY_DYNAMIC_RELOCS:
      no_apply_dynamic_relocs = 1;
      break;

    case OPTION_STUBGROUP_SIZE:
      {
	const char *end;

	group_size = bfd_scan_vma (optarg, &end, 0);
	if (*end)
	  einfo (_("%F%P: invalid number `%s'\n"), optarg);
      }
      break;

    }

  return true;
}


static void
gldaarch64elfb_list_options (FILE * file)
{
 
  fprintf (file, _("  --no-enum-size-warning      Don't warn about objects with incompatible\n"
		   "                                enum sizes\n"));
  fprintf (file, _("  --no-wchar-size-warning     Don't warn about objects with incompatible\n"
		   "                                wchar_t sizes\n"));
  fprintf (file, _("  --pic-veneer                Always generate PIC interworking veneers\n"));
  fprintf (file, _("\
  --stub-group-size=N         Maximum size of a group of input sections that\n\
                                can be handled by one stub section.  A negative\n\
                                value locates all stubs after their branches\n\
                                (with a group size of -N), while a positive\n\
                                value allows two groups of input sections, one\n\
                                before, and one after each stub section.\n\
                                Values of +/-1 indicate the linker should\n\
                                choose suitable defaults.\n"));
  fprintf (file, _("  --fix-cortex-a53-835769      Fix erratum 835769\n"));
  fprintf (file, _("\
  --fix-cortex-a53-843419[=full|adr|adrp]      Fix erratum 843419 and optionally specify which workaround to use.\n\
                                               full (default): Use both ADRP and ADR workaround, this will \n\
                                                 increase the size of your binaries.\n\
                                               adr: Only use the ADR workaround, this will not cause any increase\n\
                                                 in binary size but linking will fail if the referenced address is\n\
                                                 out of range of an ADR instruction.  This will remove the need of using\n\
                                                 a veneer and results in both performance and size benefits.\n\
                                               adrp: Use only the ADRP workaround, this will never rewrite your ADRP\n\
                                                 instruction into an ADR.  As such the workaround will always use a\n\
                                                 veneer and this will give you both a performance and size overhead.\n"));
  fprintf (file, _("  --no-apply-dynamic-relocs    Do not apply link-time values for dynamic relocations\n"));
  fprintf (file, _("\
  -z force-bti                         Turn on Branch Target Identification mechanism and generate PLTs with BTI.\n\
                                         Generate warnings for missing BTI markings on inputs\n"));
  fprintf (file, _("\
  -z bti-report[=none|warning|error]   Emit warning/error on mismatch of BTI marking between input objects and ouput.\n\
                                         none: Does not emit any warning/error messages.\n\
                                         warning (default): Emit warning when the input objects are missing BTI markings\n\
                                           and output has BTI marking.\n\
                                         error: Emit error when the input objects are missing BTI markings\n\
                                           and output has BTI marking.\n"));
  fprintf (file, _("\
  -z pac-plt                           Protect PLTs with Pointer Authentication.\n"));
  fprintf (file, _("\
  -z gcs=[always|never|implicit]       Controls whether the output supports the Guarded Control Stack (GCS) mechanism.\n\
                                         implicit (default if '-z gcs' is omitted): deduce GCS from input objects.\n\
                                         always: always marks the output with GCS.\n\
                                         never: never marks the output with GCS.\n"));
  fprintf (file, _("\
  -z gcs-report[=none|warning|error]   Emit warning/error on mismatch of GCS marking between input objects and ouput.\n\
                                         none: Does not emit any warning/error messages.\n\
                                         warning (default): Emit warning when the input objects are missing GCS markings\n\
                                           and output have GCS marking.\n\
                                         error: Emit error when the input objects are missing GCS markings\n\
                                           and output have GCS marking.\n"));
  fprintf (file, _("\
  -z gcs-report-dynamic=none|warning|error   Emit warning/error on mismatch of GCS marking between the current link\n\
                                             unit and input dynamic objects.\n\
                                               none: Does not emit any warning/error messages.\n\
                                               warning: Emit warning when the input objects are missing GCS markings\n\
                                                 and output have GCS marking.\n\
                                               error: Emit error when the input objects are missing GCS markings\n\
                                                 and output have GCS marking.\n"));

}

struct ld_emulation_xfer_struct ld_aarch64elfb_emulation =
{
  gldaarch64elfb_before_parse,
  syslib_default,
  hll_default,
  ldelf_after_parse,
  gldaarch64elfb_before_plugin_all_symbols_read,
  gldaarch64elfb_after_open,
  after_check_relocs_default,
  ldelf_before_place_orphans,
  gldaarch64elfb_after_allocation,
  ldelf_set_output_arch,
  ldemul_default_target,
  aarch64_elf_before_allocation,
  gldaarch64elfb_get_script,
  "aarch64elfb",
  "elf64-bigaarch64",
  gldaarch64elfb_finish,
  aarch64_elf_create_output_section_statements,
  ldelf_open_dynamic_archive,
  ldelf_place_orphan,
  NULL,
  NULL,
  gldaarch64elfb_add_options,
  gldaarch64elfb_handle_option,
  NULL,
  gldaarch64elfb_list_options,
  ldelf_load_symbols,
  NULL,
  NULL,
  NULL,
  ldelf_emit_ctf_early,
  ldelf_acquire_strings_for_ctf,
  ldelf_new_dynsym_for_ctf,
  NULL
};
