// This file is generated by kconfig_compiler_kf6 from amarokconfig.kcfg.
// All changes you do to this file will be lost.

#include "amarokconfig.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

class AmarokConfigHelper
{
  public:
    AmarokConfigHelper() : q(nullptr) {}
    ~AmarokConfigHelper() { delete q; q = nullptr; }
    AmarokConfigHelper(const AmarokConfigHelper&) = delete;
    AmarokConfigHelper& operator=(const AmarokConfigHelper&) = delete;
    AmarokConfig *q;
};
Q_GLOBAL_STATIC(AmarokConfigHelper, s_globalAmarokConfig)
AmarokConfig *AmarokConfig::self()
{
  if (!s_globalAmarokConfig()->q)
     qFatal("you need to call AmarokConfig::instance before using");
  return s_globalAmarokConfig()->q;
}

void AmarokConfig::instance(const QString& cfgfilename)
{
  if (s_globalAmarokConfig()->q) {
     qDebug() << "AmarokConfig::instance called after the first use - ignoring";
     return;
  }
  new AmarokConfig(KSharedConfig::openConfig(cfgfilename));
  s_globalAmarokConfig()->q->read();
}

void AmarokConfig::instance(KSharedConfig::Ptr config)
{
  if (s_globalAmarokConfig()->q) {
     qDebug() << "AmarokConfig::instance called after the first use - ignoring";
     return;
  }
  new AmarokConfig(std::move(config));
  s_globalAmarokConfig()->q->read();
}

AmarokConfig::AmarokConfig( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  Q_ASSERT(!s_globalAmarokConfig()->q);
  s_globalAmarokConfig()->q = this;
  setCurrentGroup( QStringLiteral( "General Options" ) );

  KConfigSkeleton::ItemBool  *itemLeftTimeDisplayEnabled;
  itemLeftTimeDisplayEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Left Time Display Enabled" ), mLeftTimeDisplayEnabled, true );
  addItem( itemLeftTimeDisplayEnabled, QStringLiteral( "LeftTimeDisplayEnabled" ) );
  KConfigSkeleton::ItemBool  *itemLeftTimeDisplayRemaining;
  itemLeftTimeDisplayRemaining = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Left Time Display Remaining" ), mLeftTimeDisplayRemaining, false );
  addItem( itemLeftTimeDisplayRemaining, QStringLiteral( "LeftTimeDisplayRemaining" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesFavorTracks;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Off");
    valuesFavorTracks.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HigherScores");
    valuesFavorTracks.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HigherRatings");
    valuesFavorTracks.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("LessRecentlyPlayed");
    valuesFavorTracks.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemFavorTracks;
  itemFavorTracks = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Favor Tracks" ), mFavorTracks, valuesFavorTracks, EnumFavorTracks::Off );
  addItem( itemFavorTracks, QStringLiteral( "FavorTracks" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesTrackProgression;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Normal");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("OnlyQueue");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RepeatTrack");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RepeatAlbum");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RepeatPlaylist");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RandomTrack");
    valuesTrackProgression.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("RandomAlbum");
    valuesTrackProgression.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemTrackProgression;
  itemTrackProgression = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Track Progression" ), mTrackProgression, valuesTrackProgression, EnumTrackProgression::Normal );
  addItem( itemTrackProgression, QStringLiteral( "TrackProgression" ) );
  KConfigSkeleton::ItemBool  *itemDynamicMode;
  itemDynamicMode = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Dynamic Mode" ), mDynamicMode, false );
  addItem( itemDynamicMode, QStringLiteral( "DynamicMode" ) );
  KConfigSkeleton::ItemBool  *itemDynamicDuplicates;
  itemDynamicDuplicates = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Dynamic Duplicates" ), mDynamicDuplicates, false );
  addItem( itemDynamicDuplicates, QStringLiteral( "DynamicDuplicates" ) );
  KConfigSkeleton::ItemInt  *itemPreviousTracks;
  itemPreviousTracks = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Previous Tracks" ), mPreviousTracks, 5 );
  addItem( itemPreviousTracks, QStringLiteral( "PreviousTracks" ) );
  KConfigSkeleton::ItemInt  *itemUpcomingTracks;
  itemUpcomingTracks = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Upcoming Tracks" ), mUpcomingTracks, 10 );
  addItem( itemUpcomingTracks, QStringLiteral( "UpcomingTracks" ) );
  KConfigSkeleton::ItemBool  *itemShowTrayIcon;
  itemShowTrayIcon = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Show Tray Icon" ), mShowTrayIcon, true );
  addItem( itemShowTrayIcon, QStringLiteral( "ShowTrayIcon" ) );
  KConfigSkeleton::ItemBool  *itemHideContextView;
  itemHideContextView = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "HideContextView" ), mHideContextView, false );
  addItem( itemHideContextView, QStringLiteral( "HideContextView" ) );
  KConfigSkeleton::ItemInt  *itemUndoLevels;
  itemUndoLevels = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Undo Levels" ), mUndoLevels, 30 );
  addItem( itemUndoLevels, QStringLiteral( "UndoLevels" ) );
  KConfigSkeleton::ItemBool  *itemRelativePlaylist;
  itemRelativePlaylist = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Relative Playlist" ), mRelativePlaylist, true );
  addItem( itemRelativePlaylist, QStringLiteral( "RelativePlaylist" ) );
  KConfigSkeleton::ItemString  *itemExternalBrowser;
  itemExternalBrowser = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "External Browser" ), mExternalBrowser, QStringLiteral( "xdg-open" ) );
  addItem( itemExternalBrowser, QStringLiteral( "ExternalBrowser" ) );
  KConfigSkeleton::ItemBool  *itemAutoGetCoverArt;
  itemAutoGetCoverArt = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoGetCoverArt" ), mAutoGetCoverArt, false );
  addItem( itemAutoGetCoverArt, QStringLiteral( "AutoGetCoverArt" ) );
  KConfigSkeleton::ItemBool  *itemShowBrowserBackgroundImage;
  itemShowBrowserBackgroundImage = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowBrowserBackgroundImage" ), mShowBrowserBackgroundImage, true );
  addItem( itemShowBrowserBackgroundImage, QStringLiteral( "ShowBrowserBackgroundImage" ) );
  KConfigSkeleton::ItemBool  *itemAutoScrollPlaylist;
  itemAutoScrollPlaylist = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoScrollPlaylist" ), mAutoScrollPlaylist, true );
  addItem( itemAutoScrollPlaylist, QStringLiteral( "AutoScrollPlaylist" ) );
  KConfigSkeleton::ItemBool  *itemShowAlbumArt;
  itemShowAlbumArt = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Show Album Art" ), mShowAlbumArt, true );
  addItem( itemShowAlbumArt, QStringLiteral( "ShowAlbumArt" ) );
  KConfigSkeleton::ItemBool  *itemLockLayout;
  itemLockLayout = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Lock Layout" ), mLockLayout, true );
  addItem( itemLockLayout, QStringLiteral( "LockLayout" ) );
  KConfigSkeleton::ItemBool  *itemPlayFirstRunJingle;
  itemPlayFirstRunJingle = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PlayFirstRunJingle" ), mPlayFirstRunJingle, true );
  addItem( itemPlayFirstRunJingle, QStringLiteral( "PlayFirstRunJingle" ) );
  KConfigSkeleton::ItemBool  *itemAnimateAppletCollapse;
  itemAnimateAppletCollapse = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AnimateAppletCollapse" ), mAnimateAppletCollapse, false );
  addItem( itemAnimateAppletCollapse, QStringLiteral( "AnimateAppletCollapse" ) );
  KConfigSkeleton::ItemBool  *itemShowArtistForVarious;
  itemShowArtistForVarious = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowArtistForVarious" ), mShowArtistForVarious, true );
  addItem( itemShowArtistForVarious, QStringLiteral( "ShowArtistForVarious" ) );

  setCurrentGroup( QStringLiteral( "OrganizeCollectionDialog" ) );

  KConfigSkeleton::ItemBool  *itemOverwriteFiles;
  itemOverwriteFiles = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Overwrite Files" ), mOverwriteFiles, false );
  addItem( itemOverwriteFiles, QStringLiteral( "OverwriteFiles" ) );
  KConfigSkeleton::ItemBool  *itemIgnoreThe;
  itemIgnoreThe = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Ignore The" ), mIgnoreThe, true );
  addItem( itemIgnoreThe, QStringLiteral( "IgnoreThe" ) );
  KConfigSkeleton::ItemBool  *itemReplaceSpace;
  itemReplaceSpace = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Replace Space" ), mReplaceSpace, false );
  addItem( itemReplaceSpace, QStringLiteral( "ReplaceSpace" ) );
  KConfigSkeleton::ItemBool  *itemCoverIcons;
  itemCoverIcons = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Cover Icons" ), mCoverIcons, true );
  addItem( itemCoverIcons, QStringLiteral( "CoverIcons" ) );
  KConfigSkeleton::ItemString  *itemOrganizeDirectory;
  itemOrganizeDirectory = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Organize Directory" ), mOrganizeDirectory );
  addItem( itemOrganizeDirectory, QStringLiteral( "OrganizeDirectory" ) );
  KConfigSkeleton::ItemBool  *itemVfatCompatible;
  itemVfatCompatible = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Vfat Compatible" ), mVfatCompatible, true );
  addItem( itemVfatCompatible, QStringLiteral( "VfatCompatible" ) );
  KConfigSkeleton::ItemBool  *itemAsciiOnly;
  itemAsciiOnly = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Ascii Only" ), mAsciiOnly, false );
  addItem( itemAsciiOnly, QStringLiteral( "AsciiOnly" ) );
  KConfigSkeleton::ItemBool  *itemUseCustomScheme;
  itemUseCustomScheme = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Use Custom Scheme" ), mUseCustomScheme, false );
  addItem( itemUseCustomScheme, QStringLiteral( "UseCustomScheme" ) );
  KConfigSkeleton::ItemString  *itemCustomScheme;
  itemCustomScheme = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Custom Scheme" ), mCustomScheme, QStringLiteral( "%artist%/%album%/%track%_-_%title%" ) );
  addItem( itemCustomScheme, QStringLiteral( "CustomScheme" ) );
  KConfigSkeleton::ItemString  *itemReplacementRegexp;
  itemReplacementRegexp = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Replacement Regexp" ), mReplacementRegexp );
  addItem( itemReplacementRegexp, QStringLiteral( "ReplacementRegexp" ) );
  KConfigSkeleton::ItemString  *itemReplacementString;
  itemReplacementString = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Replacement String" ), mReplacementString );
  addItem( itemReplacementString, QStringLiteral( "ReplacementString" ) );
  KConfigSkeleton::ItemString  *itemMode;
  itemMode = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Mode" ), mMode, QStringLiteral( "Basic" ) );
  addItem( itemMode, QStringLiteral( "Mode" ) );
  QStringList defaultFormatPresets;
  defaultFormatPresets.append( QString::fromUtf8( "Default#DELIM#%artist%/%album%/%track%_-_%title%" ) );

  KConfigSkeleton::ItemStringList  *itemFormatPresets;
  itemFormatPresets = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "Format Presets" ), mFormatPresets, defaultFormatPresets );
  addItem( itemFormatPresets, QStringLiteral( "FormatPresets" ) );

  setCurrentGroup( QStringLiteral( "Playback" ) );

  KConfigSkeleton::ItemInt  *itemMasterVolume;
  itemMasterVolume = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Master Volume" ), mMasterVolume, 80 );
  itemMasterVolume->setMinValue(0);
  itemMasterVolume->setMaxValue(100);
  addItem( itemMasterVolume, QStringLiteral( "MasterVolume" ) );
  KConfigSkeleton::ItemBool  *itemMuteState;
  itemMuteState = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Mute State" ), mMuteState, false );
  addItem( itemMuteState, QStringLiteral( "MuteState" ) );
  KConfigSkeleton::ItemBool  *itemFadeoutOnStop;
  itemFadeoutOnStop = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "FadeoutOnStop" ), mFadeoutOnStop, false );
  addItem( itemFadeoutOnStop, QStringLiteral( "FadeoutOnStop" ) );
  KConfigSkeleton::ItemBool  *itemFadeoutOnPause;
  itemFadeoutOnPause = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "FadeoutOnPause" ), mFadeoutOnPause, false );
  addItem( itemFadeoutOnPause, QStringLiteral( "FadeoutOnPause" ) );
  KConfigSkeleton::ItemInt  *itemFadeoutLength;
  itemFadeoutLength = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Fadeout Length" ), mFadeoutLength, 2000 );
  itemFadeoutLength->setMinValue(400);
  addItem( itemFadeoutLength, QStringLiteral( "FadeoutLength" ) );
  KConfigSkeleton::ItemInt  *itemEqualizerMode;
  itemEqualizerMode = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "EqualizerMode" ), mEqualizerMode, false );
  addItem( itemEqualizerMode, QStringLiteral( "EqualizerMode" ) );
  QList<int> defaultEqualizerGains;
  defaultEqualizerGains.append( 0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );
  defaultEqualizerGains.append(  0 );

  KConfigSkeleton::ItemIntList  *itemEqualizerGains;
  itemEqualizerGains = new KConfigSkeleton::ItemIntList( currentGroup(), QStringLiteral( "EqualizerGains" ), mEqualizerGains, defaultEqualizerGains );
  addItem( itemEqualizerGains, QStringLiteral( "EqualizerGains" ) );
  KConfigSkeleton::ItemStringList  *itemEqualizerPresetsNames;
  itemEqualizerPresetsNames = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "EqualizerPresetsNames" ), mEqualizerPresetsNames );
  addItem( itemEqualizerPresetsNames, QStringLiteral( "EqualizerPresetsNames" ) );
  QList<int> defaultEqualizerPresestValues;

  KConfigSkeleton::ItemIntList  *itemEqualizerPresestValues;
  itemEqualizerPresestValues = new KConfigSkeleton::ItemIntList( currentGroup(), QStringLiteral( "EqualizerPresestValues" ), mEqualizerPresestValues, defaultEqualizerPresestValues );
  addItem( itemEqualizerPresestValues, QStringLiteral( "EqualizerPresestValues" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesReplayGainMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Off");
    valuesReplayGainMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Track");
    valuesReplayGainMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Album");
    valuesReplayGainMode.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemReplayGainMode;
  itemReplayGainMode = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Replay Gain Mode" ), mReplayGainMode, valuesReplayGainMode, EnumReplayGainMode::Track );
  addItem( itemReplayGainMode, QStringLiteral( "ReplayGainMode" ) );
  KConfigSkeleton::ItemInt  *itemSeekShort;
  itemSeekShort = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Seek Short" ), mSeekShort, 2 );
  itemSeekShort->setMinValue(1);
  addItem( itemSeekShort, QStringLiteral( "SeekShort" ) );
  KConfigSkeleton::ItemInt  *itemSeekMedium;
  itemSeekMedium = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Seek Medium" ), mSeekMedium, 10 );
  itemSeekMedium->setMinValue(1);
  addItem( itemSeekMedium, QStringLiteral( "SeekMedium" ) );
  KConfigSkeleton::ItemInt  *itemSeekLong;
  itemSeekLong = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Seek Long" ), mSeekLong, 60 );
  itemSeekLong->setMinValue(1);
  addItem( itemSeekLong, QStringLiteral( "SeekLong" ) );
  KConfigSkeleton::ItemBool  *itemPauseOnSuspend;
  itemPauseOnSuspend = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Pause On Suspend" ), mPauseOnSuspend, false );
  addItem( itemPauseOnSuspend, QStringLiteral( "PauseOnSuspend" ) );
  KConfigSkeleton::ItemBool  *itemInhibitSuspend;
  itemInhibitSuspend = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Inhibit Suspend" ), mInhibitSuspend, true );
  addItem( itemInhibitSuspend, QStringLiteral( "InhibitSuspend" ) );
  KConfigSkeleton::ItemBool  *itemStartPlayingOnAdd;
  itemStartPlayingOnAdd = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Start Playing On Add" ), mStartPlayingOnAdd, true );
  addItem( itemStartPlayingOnAdd, QStringLiteral( "StartPlayingOnAdd" ) );

  setCurrentGroup( QStringLiteral( "Cover Manager" ) );

  KConfigSkeleton::ItemString  *itemAmazonLocale;
  itemAmazonLocale = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Amazon Locale" ), mAmazonLocale, QStringLiteral( "us" ) );
  addItem( itemAmazonLocale, QStringLiteral( "AmazonLocale" ) );

  setCurrentGroup( QStringLiteral( "Wikipedia" ) );

  KConfigSkeleton::ItemString  *itemWikipediaLocale;
  itemWikipediaLocale = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Wikipedia Locale" ), mWikipediaLocale, QStringLiteral( "en" ) );
  addItem( itemWikipediaLocale, QStringLiteral( "WikipediaLocale" ) );

  setCurrentGroup( QStringLiteral( "KNotify" ) );

  KConfigSkeleton::ItemBool  *itemKNotifyEnabled;
  itemKNotifyEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "KNotify Enabled" ), mKNotifyEnabled, false );
  addItem( itemKNotifyEnabled, QStringLiteral( "KNotifyEnabled" ) );

  setCurrentGroup( QStringLiteral( "OSD" ) );

  KConfigSkeleton::ItemBool  *itemOsdEnabled;
  itemOsdEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Osd Enabled" ), mOsdEnabled, true );
  addItem( itemOsdEnabled, QStringLiteral( "OsdEnabled" ) );
  KConfigSkeleton::ItemBool  *itemGrowlEnabled;
  itemGrowlEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Growl Enabled" ), mGrowlEnabled, false );
  addItem( itemGrowlEnabled, QStringLiteral( "GrowlEnabled" ) );
  KConfigSkeleton::ItemBool  *itemOsdUseTranslucency;
  itemOsdUseTranslucency = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Osd Use Translucency" ), mOsdUseTranslucency, true );
  addItem( itemOsdUseTranslucency, QStringLiteral( "OsdUseTranslucency" ) );
  KConfigSkeleton::ItemBool  *itemOsdUseCustomColors;
  itemOsdUseCustomColors = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Osd Use Custom Colors" ), mOsdUseCustomColors, false );
  addItem( itemOsdUseCustomColors, QStringLiteral( "OsdUseCustomColors" ) );
  KConfigSkeleton::ItemColor  *itemOsdTextColor;
  itemOsdTextColor = new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "Osd Text Color" ), mOsdTextColor, QColor( "#ffff00" ) );
  addItem( itemOsdTextColor, QStringLiteral( "OsdTextColor" ) );
  KConfigSkeleton::ItemInt  *itemOsdFontScaling;
  itemOsdFontScaling = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Osd Font Scaling" ), mOsdFontScaling, 115 );
  itemOsdFontScaling->setMinValue(0);
  itemOsdFontScaling->setMaxValue(1000);
  addItem( itemOsdFontScaling, QStringLiteral( "OsdFontScaling" ) );
  KConfigSkeleton::ItemInt  *itemOsdDuration;
  itemOsdDuration = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Osd Duration" ), mOsdDuration, 5000 );
  itemOsdDuration->setMinValue(0);
  addItem( itemOsdDuration, QStringLiteral( "OsdDuration" ) );
  KConfigSkeleton::ItemInt  *itemOsdYOffset;
  itemOsdYOffset = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Osd Y Offset" ), mOsdYOffset, 50 );
  itemOsdYOffset->setMinValue(0);
  itemOsdYOffset->setMaxValue(10000);
  addItem( itemOsdYOffset, QStringLiteral( "OsdYOffset" ) );
  KConfigSkeleton::ItemInt  *itemOsdScreen;
  itemOsdScreen = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Osd Screen" ), mOsdScreen, 0 );
  addItem( itemOsdScreen, QStringLiteral( "OsdScreen" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesOsdAlignment;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Left");
    valuesOsdAlignment.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Middle");
    valuesOsdAlignment.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Center");
    valuesOsdAlignment.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Right");
    valuesOsdAlignment.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemOsdAlignment;
  itemOsdAlignment = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Osd Alignment" ), mOsdAlignment, valuesOsdAlignment, EnumOsdAlignment::Middle );
  addItem( itemOsdAlignment, QStringLiteral( "OsdAlignment" ) );
  KConfigSkeleton::ItemBool  *itemOsdHideOnFullscreen;
  itemOsdHideOnFullscreen = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "OsdHideOnFullscreen" ), mOsdHideOnFullscreen, false );
  addItem( itemOsdHideOnFullscreen, QStringLiteral( "OsdHideOnFullscreen" ) );

  setCurrentGroup( QStringLiteral( "Session" ) );

  KConfigSkeleton::ItemBool  *itemResumePlayback;
  itemResumePlayback = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Resume Playback" ), mResumePlayback, false );
  addItem( itemResumePlayback, QStringLiteral( "ResumePlayback" ) );
  KConfigSkeleton::ItemPath  *itemResumeTrack;
  itemResumeTrack = new KConfigSkeleton::ItemPath( currentGroup(), QStringLiteral( "Resume Track" ), mResumeTrack );
  addItem( itemResumeTrack, QStringLiteral( "ResumeTrack" ) );
  KConfigSkeleton::ItemBool  *itemResumePaused;
  itemResumePaused = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Resume Paused" ), mResumePaused, false );
  addItem( itemResumePaused, QStringLiteral( "ResumePaused" ) );
  KConfigSkeleton::ItemInt  *itemResumeTime;
  itemResumeTime = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Resume Time" ), mResumeTime );
  addItem( itemResumeTime, QStringLiteral( "ResumeTime" ) );
  QList<int> defaultVisibleBrowsers;

  KConfigSkeleton::ItemIntList  *itemVisibleBrowsers;
  itemVisibleBrowsers = new KConfigSkeleton::ItemIntList( currentGroup(), QStringLiteral( "Visible Browsers" ), mVisibleBrowsers, defaultVisibleBrowsers );
  addItem( itemVisibleBrowsers, QStringLiteral( "VisibleBrowsers" ) );
  KConfigSkeleton::ItemInt  *itemLastPlaying;
  itemLastPlaying = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "LastPlaying" ), mLastPlaying, -1 );
  addItem( itemLastPlaying, QStringLiteral( "LastPlaying" ) );
  KConfigSkeleton::ItemInt  *itemActiveBrowser;
  itemActiveBrowser = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Active Browser" ), mActiveBrowser );
  addItem( itemActiveBrowser, QStringLiteral( "ActiveBrowser" ) );

  setCurrentGroup( QStringLiteral( "Collection" ) );

  KConfigSkeleton::ItemBool  *itemScanRecursively;
  itemScanRecursively = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Scan Recursively" ), mScanRecursively, true );
  addItem( itemScanRecursively, QStringLiteral( "ScanRecursively" ) );
  KConfigSkeleton::ItemBool  *itemMonitorChanges;
  itemMonitorChanges = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Monitor Changes" ), mMonitorChanges, true );
  addItem( itemMonitorChanges, QStringLiteral( "MonitorChanges" ) );
  KConfigSkeleton::ItemBool  *itemWriteBack;
  itemWriteBack = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Write Back" ), mWriteBack, true );
  addItem( itemWriteBack, QStringLiteral( "WriteBack" ) );
  KConfigSkeleton::ItemBool  *itemWriteBackStatistics;
  itemWriteBackStatistics = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Write Back Statistics" ), mWriteBackStatistics, false );
  addItem( itemWriteBackStatistics, QStringLiteral( "WriteBackStatistics" ) );
  KConfigSkeleton::ItemBool  *itemWriteBackCover;
  itemWriteBackCover = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Write Back Cover" ), mWriteBackCover, false );
  addItem( itemWriteBackCover, QStringLiteral( "WriteBackCover" ) );
  KConfigSkeleton::ItemInt  *itemWriteBackCoverDimensions;
  itemWriteBackCoverDimensions = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Write Back Cover Dimensions" ), mWriteBackCoverDimensions, 400 );
  addItem( itemWriteBackCoverDimensions, QStringLiteral( "WriteBackCoverDimensions" ) );
  KConfigSkeleton::ItemPathList  *itemCollectionFolders;
  itemCollectionFolders = new KConfigSkeleton::ItemPathList( currentGroup(), QStringLiteral( "Collection Folders" ), mCollectionFolders );
  addItem( itemCollectionFolders, QStringLiteral( "CollectionFolders" ) );
  KConfigSkeleton::ItemBool  *itemShowTrackNumbers;
  itemShowTrackNumbers = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Show Track Numbers" ), mShowTrackNumbers, true );
  addItem( itemShowTrackNumbers, QStringLiteral( "ShowTrackNumbers" ) );
  KConfigSkeleton::ItemBool  *itemShowYears;
  itemShowYears = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Show Years" ), mShowYears, true );
  addItem( itemShowYears, QStringLiteral( "ShowYears" ) );
  KConfigSkeleton::ItemBool  *itemUseCharsetDetector;
  itemUseCharsetDetector = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Use Charset Detector" ), mUseCharsetDetector, false );
  addItem( itemUseCharsetDetector, QStringLiteral( "UseCharsetDetector" ) );

  setCurrentGroup( QStringLiteral( "Scrobbler" ) );

  KConfigSkeleton::ItemBool  *itemSubmitPlayedSongs;
  itemSubmitPlayedSongs = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SubmitPlayedSongs" ), mSubmitPlayedSongs, true );
  addItem( itemSubmitPlayedSongs, QStringLiteral( "SubmitPlayedSongs" ) );
  KConfigSkeleton::ItemString  *itemScrobblerUsername;
  itemScrobblerUsername = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ScrobblerUsername" ), mScrobblerUsername );
  addItem( itemScrobblerUsername, QStringLiteral( "ScrobblerUsername" ) );
  KConfigSkeleton::ItemPassword  *itemScrobblerPassword;
  itemScrobblerPassword = new KConfigSkeleton::ItemPassword( currentGroup(), QStringLiteral( "ScrobblerPassword" ), mScrobblerPassword );
  addItem( itemScrobblerPassword, QStringLiteral( "ScrobblerPassword" ) );
  KConfigSkeleton::ItemBool  *itemScrobbleComposer;
  itemScrobbleComposer = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ScrobbleComposer" ), mScrobbleComposer, false );
  addItem( itemScrobbleComposer, QStringLiteral( "ScrobbleComposer" ) );
  KConfigSkeleton::ItemBool  *itemRetrieveSimilarArtists;
  itemRetrieveSimilarArtists = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "RetrieveSimilarArtists" ), mRetrieveSimilarArtists, false );
  addItem( itemRetrieveSimilarArtists, QStringLiteral( "RetrieveSimilarArtists" ) );

  setCurrentGroup( QStringLiteral( "MediaDevice" ) );

  KConfigSkeleton::ItemString  *itemDeviceType;
  itemDeviceType = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "DeviceType" ), mDeviceType );
  addItem( itemDeviceType, QStringLiteral( "DeviceType" ) );
  KConfigSkeleton::ItemString  *itemMountPoint;
  itemMountPoint = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "MountPoint" ), mMountPoint );
  addItem( itemMountPoint, QStringLiteral( "MountPoint" ) );
  KConfigSkeleton::ItemString  *itemMountCommand;
  itemMountCommand = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "MountCommand" ), mMountCommand );
  addItem( itemMountCommand, QStringLiteral( "MountCommand" ) );
  KConfigSkeleton::ItemString  *itemUmountCommand;
  itemUmountCommand = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "UmountCommand" ), mUmountCommand );
  addItem( itemUmountCommand, QStringLiteral( "UmountCommand" ) );
  KConfigSkeleton::ItemBool  *itemAutoDeletePodcasts;
  itemAutoDeletePodcasts = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoDeletePodcasts" ), mAutoDeletePodcasts );
  addItem( itemAutoDeletePodcasts, QStringLiteral( "AutoDeletePodcasts" ) );
  KConfigSkeleton::ItemBool  *itemSyncStats;
  itemSyncStats = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SyncStats" ), mSyncStats );
  addItem( itemSyncStats, QStringLiteral( "SyncStats" ) );

  setCurrentGroup( QStringLiteral( "Daap" ) );

  KConfigSkeleton::ItemStringList  *itemManuallyAddedServers;
  itemManuallyAddedServers = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "ManuallyAddedServers" ), mManuallyAddedServers );
  addItem( itemManuallyAddedServers, QStringLiteral( "ManuallyAddedServers" ) );
  KConfigSkeleton::ItemStringList  *itemServerPasswords;
  itemServerPasswords = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "ServerPasswords" ), mServerPasswords );
  addItem( itemServerPasswords, QStringLiteral( "ServerPasswords" ) );

  setCurrentGroup( QStringLiteral( "Playlist Search" ) );

  KConfigSkeleton::ItemBool  *itemMatchTrack;
  itemMatchTrack = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchTrack" ), mMatchTrack, true );
  addItem( itemMatchTrack, QStringLiteral( "MatchTrack" ) );
  KConfigSkeleton::ItemBool  *itemMatchAlbum;
  itemMatchAlbum = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchAlbum" ), mMatchAlbum, true );
  addItem( itemMatchAlbum, QStringLiteral( "MatchAlbum" ) );
  KConfigSkeleton::ItemBool  *itemMatchArtist;
  itemMatchArtist = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchArtist" ), mMatchArtist, true );
  addItem( itemMatchArtist, QStringLiteral( "MatchArtist" ) );
  KConfigSkeleton::ItemBool  *itemMatchGenre;
  itemMatchGenre = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchGenre" ), mMatchGenre, false );
  addItem( itemMatchGenre, QStringLiteral( "MatchGenre" ) );
  KConfigSkeleton::ItemBool  *itemMatchComposer;
  itemMatchComposer = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchComposer" ), mMatchComposer, false );
  addItem( itemMatchComposer, QStringLiteral( "MatchComposer" ) );
  KConfigSkeleton::ItemBool  *itemMatchYear;
  itemMatchYear = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "MatchYear" ), mMatchYear, false );
  addItem( itemMatchYear, QStringLiteral( "MatchYear" ) );
  KConfigSkeleton::ItemBool  *itemShowOnlyMatches;
  itemShowOnlyMatches = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowOnlyMatches" ), mShowOnlyMatches, false );
  addItem( itemShowOnlyMatches, QStringLiteral( "ShowOnlyMatches" ) );

  setCurrentGroup( QStringLiteral( "Playlist Layout" ) );

  KConfigSkeleton::ItemString  *itemCurrentLayout;
  itemCurrentLayout = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "CurrentLayout" ), mCurrentLayout, QStringLiteral( "Default" ) );
  addItem( itemCurrentLayout, QStringLiteral( "CurrentLayout" ) );

  setCurrentGroup( QStringLiteral( "MySQL" ) );

  KConfigSkeleton::ItemBool  *itemUseServer;
  itemUseServer = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "UseServer" ), mUseServer, false );
  addItem( itemUseServer, QStringLiteral( "UseServer" ) );
  KConfigSkeleton::ItemString  *itemHost;
  itemHost = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Host" ), mHost, QStringLiteral( "localhost" ) );
  addItem( itemHost, QStringLiteral( "Host" ) );
  KConfigSkeleton::ItemInt  *itemPort;
  itemPort = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "Port" ), mPort, 3306 );
  addItem( itemPort, QStringLiteral( "Port" ) );
  KConfigSkeleton::ItemString  *itemDatabase;
  itemDatabase = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Database" ), mDatabase, QStringLiteral( "amarokdb" ) );
  addItem( itemDatabase, QStringLiteral( "Database" ) );
  KConfigSkeleton::ItemString  *itemUser;
  itemUser = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "User" ), mUser, QStringLiteral( "amarokuser" ) );
  addItem( itemUser, QStringLiteral( "User" ) );
  KConfigSkeleton::ItemString  *itemPassword;
  itemPassword = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Password" ), mPassword, QStringLiteral( "password" ) );
  addItem( itemPassword, QStringLiteral( "Password" ) );
  KConfigSkeleton::ItemInt  *itemCheckCount;
  itemCheckCount = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "CheckCount" ), mCheckCount, 0 );
  addItem( itemCheckCount, QStringLiteral( "CheckCount" ) );

  setCurrentGroup( QStringLiteral( "ScriptManager" ) );

  KConfigSkeleton::ItemBool  *itemEnableScripts;
  itemEnableScripts = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Enable Scripts" ), mEnableScripts, false );
  addItem( itemEnableScripts, QStringLiteral( "EnableScripts" ) );
  KConfigSkeleton::ItemBool  *itemAutoUpdateScripts;
  itemAutoUpdateScripts = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoUpdateScripts" ), mAutoUpdateScripts, true );
  addItem( itemAutoUpdateScripts, QStringLiteral( "AutoUpdateScripts" ) );
  KConfigSkeleton::ItemBool  *itemEnableScriptConsole;
  itemEnableScriptConsole = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EnableScriptConsole" ), mEnableScriptConsole, false );
  addItem( itemEnableScriptConsole, QStringLiteral( "EnableScriptConsole" ) );
  KConfigSkeleton::ItemBool  *itemEnableDeprecationWarnings;
  itemEnableDeprecationWarnings = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EnableDeprecationWarnings" ), mEnableDeprecationWarnings, true );
  addItem( itemEnableDeprecationWarnings, QStringLiteral( "EnableDeprecationWarnings" ) );

  setCurrentGroup( QStringLiteral( "ScriptConsole" ) );

  KConfigSkeleton::ItemBool  *itemSaveSession;
  itemSaveSession = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SaveSession" ), mSaveSession, true );
  addItem( itemSaveSession, QStringLiteral( "SaveSession" ) );

  setCurrentGroup( QStringLiteral( "Moodbar" ) );

  KConfigSkeleton::ItemBool  *itemShowMoodbarInSlider;
  itemShowMoodbarInSlider = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowMoodbarInSlider" ), mShowMoodbarInSlider, false );
  addItem( itemShowMoodbarInSlider, QStringLiteral( "ShowMoodbarInSlider" ) );
  KConfigSkeleton::ItemInt  *itemMoodbarPaintStyle;
  itemMoodbarPaintStyle = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "MoodbarPaintStyle" ), mMoodbarPaintStyle, 0 );
  addItem( itemMoodbarPaintStyle, QStringLiteral( "MoodbarPaintStyle" ) );

  setCurrentGroup( QStringLiteral( "PlaylistGenerator" ) );

  KConfigSkeleton::ItemInt  *itemQualityFactorAPG;
  itemQualityFactorAPG = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "qualityFactorAPG" ), mQualityFactorAPG, 7 );
  addItem( itemQualityFactorAPG, QStringLiteral( "qualityFactorAPG" ) );
}

AmarokConfig::~AmarokConfig()
{
  if (s_globalAmarokConfig.exists() && !s_globalAmarokConfig.isDestroyed()) {
    s_globalAmarokConfig()->q = nullptr;
  }
}

