//////////////////////////////////////////////////////////////////////
//
// BeeBEEP Copyright (C) 2010-2021 Marco Mastroddi
//
// BeeBEEP is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 3 of the License,
// or (at your option) any later version.
//
// BeeBEEP is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with BeeBEEP. If not, see <http://www.gnu.org/licenses/>.
//
// Author: Marco Mastroddi <marco.mastroddi(AT)gmail.com>
//
// $Id: GuiRecordVoiceMessageSettings.h 1455 2020-12-23 10:17:53Z mastroddi $
//
//////////////////////////////////////////////////////////////////////

#ifndef BEEBEEP_GUIRECORDVOICEMESSAGESETTINGS_H
#define BEEBEEP_GUIRECORDVOICEMESSAGESETTINGS_H

#include "ui_GuiRecordVoiceMessageSettings.h"
#include "Config.h"


class GuiRecordVoiceMessageSettings : public QDialog, private Ui::GuiRecordVoiceMessageSettingsDialog
{
  Q_OBJECT

public:
  explicit GuiRecordVoiceMessageSettings( QWidget *parent = Q_NULLPTR );

  void init();

  void loadSettings();

protected slots:
  void resetSettings();
  void saveSettings();
  void toggleCustomSettings( bool );
  void encodingModeChanged( int );

protected:
  void updateGui();

private:
  QButtonGroup* mp_bgEncodingMode;
  QString m_currentInputDevice;
  QString m_currentFileContainer;
  QAudioEncoderSettings m_currentAudioEncoderSettings;
  QAudioRecorder* mp_audioRecorder;

};

#endif // BEEBEEP_GUIRECORDVOICEMESSAGESETTINGS_H
