/* Text.c generated by valac 0.56.17, the Vala compiler
 * generated from Text.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <cairo-gobject.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TEXT_0_PROPERTY,
	BIRD_FONT_TEXT_NUM_PROPERTIES
};
static GParamSpec* bird_font_text_properties[BIRD_FONT_TEXT_NUM_PROPERTIES];
#define _bird_font_font_cache_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_font_cache_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
typedef struct _Block84Data Block84Data;
typedef struct _Block85Data Block85Data;
typedef struct _Block86Data Block86Data;
typedef struct _Block87Data Block87Data;
typedef struct _Block88Data Block88Data;
typedef struct _Block89Data Block89Data;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _BirdFontTextPrivate {
	BirdFontFontCache* font_cache;
	cairo_surface_t* cache;
	gboolean use_cache;
	GeeArrayList* glyph_names;
	BirdFontGlyphSequence* gs;
	gdouble sidebearing_extent;
	gdouble truncated_width;
	gdouble margin_left;
};

struct _Block84Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble x;
};

struct _Block85Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble x;
};

struct _Block86Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble max_height;
};

struct _Block87Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble x;
	gboolean first;
};

struct _Block88Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble decender;
	gdouble decender_max;
};

struct _Block89Data {
	int _ref_count_;
	BirdFontText* self;
	gdouble y;
	gdouble ratio;
	gdouble cc_y;
	cairo_t* cr;
	gdouble x;
	gchar* cacheid;
};

static gint BirdFontText_private_offset;
static gpointer bird_font_text_parent_class = NULL;

static BirdFontGlyphSequence* bird_font_text_generate_glyphs (BirdFontText* self);
static BirdFontGlyphSequence* bird_font_text_get_glyph_sequence (BirdFontText* self);
static Block84Data* block84_data_ref (Block84Data* _data84_);
static void block84_data_unref (void * _userdata_);
static void __lambda89_ (Block84Data* _data84_,
                  BirdFontGlyph* glyph,
                  gdouble kerning,
                  gboolean last);
static void ___lambda89__bird_font_text_iterator (BirdFontGlyph* glyph,
                                           gdouble kerning,
                                           gboolean last,
                                           gpointer self);
static Block85Data* block85_data_ref (Block85Data* _data85_);
static void block85_data_unref (void * _userdata_);
static void __lambda19_ (Block85Data* _data85_,
                  BirdFontGlyph* glyph,
                  gdouble kerning,
                  gboolean last);
static void ___lambda19__bird_font_text_iterator (BirdFontGlyph* glyph,
                                           gdouble kerning,
                                           gboolean last,
                                           gpointer self);
static gdouble bird_font_text_real_get_height (BirdFontWidget* base);
static Block86Data* block86_data_ref (Block86Data* _data86_);
static void block86_data_unref (void * _userdata_);
static void __lambda256_ (Block86Data* _data86_,
                   BirdFontGlyph* glyph,
                   gdouble kerning,
                   gboolean last);
static void ___lambda256__bird_font_text_iterator (BirdFontGlyph* glyph,
                                            gdouble kerning,
                                            gboolean last,
                                            gpointer self);
static gdouble bird_font_text_real_get_width (BirdFontWidget* base);
static Block87Data* block87_data_ref (Block87Data* _data87_);
static void block87_data_unref (void * _userdata_);
static void __lambda381_ (Block87Data* _data87_,
                   BirdFontGlyph* glyph,
                   gdouble kerning,
                   gboolean last);
static void ___lambda381__bird_font_text_iterator (BirdFontGlyph* glyph,
                                            gdouble kerning,
                                            gboolean last,
                                            gpointer self);
static gdouble bird_font_text_get_max_decender (BirdFontText* self);
static Block88Data* block88_data_ref (Block88Data* _data88_);
static void block88_data_unref (void * _userdata_);
static void __lambda257_ (Block88Data* _data88_,
                   BirdFontGlyph* glyph,
                   gdouble kerning,
                   gboolean last);
static void ___lambda257__bird_font_text_iterator (BirdFontGlyph* glyph,
                                            gdouble kerning,
                                            gboolean last,
                                            gpointer self);
static void bird_font_text_real_draw (BirdFontWidget* base,
                               cairo_t* cr);
static cairo_surface_t* bird_font_text_draw_on_cache_surface (BirdFontText* self,
                                                       const gchar* cacheid);
static Block89Data* block89_data_ref (Block89Data* _data89_);
static void block89_data_unref (void * _userdata_);
static void __lambda75_ (Block89Data* _data89_,
                  BirdFontGlyph* glyph,
                  gdouble kerning,
                  gboolean last);
static void bird_font_text_draw_chached (BirdFontText* self,
                                  cairo_t* cr,
                                  BirdFontGlyph* glyph,
                                  gdouble kerning,
                                  gboolean last,
                                  gdouble x,
                                  gdouble y,
                                  gdouble cc_y,
                                  gdouble ratio,
                                  const gchar* cacheid);
static void bird_font_text_draw_without_cache (BirdFontText* self,
                                        cairo_t* cr,
                                        BirdFontGlyph* glyph,
                                        gdouble kerning,
                                        gboolean last,
                                        gdouble x,
                                        gdouble y,
                                        gdouble cc_y,
                                        gdouble ratio);
static void ___lambda75__bird_font_text_iterator (BirdFontGlyph* glyph,
                                           gdouble kerning,
                                           gboolean last,
                                           gpointer self);
static void bird_font_text_draw_path (BirdFontText* self,
                               cairo_t* cr,
                               BirdFontGlyph* glyph,
                               BirdFontPath* path,
                               gdouble lsb,
                               gdouble x,
                               gdouble y,
                               gdouble scale);
static void bird_font_text_finalize (GObject * obj);
static GType bird_font_text_get_type_once (void);
static void _vala_bird_font_text_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_text_get_instance_private (BirdFontText* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontText_private_offset);
}

BirdFontText*
bird_font_text_construct (GType object_type,
                          const gchar* text,
                          gdouble size,
                          gdouble margin_bottom)
{
	BirdFontText * self = NULL;
	BirdFontFontCache* _tmp0_;
	BirdFontFontCache* _tmp1_;
	BirdFontCachedFont* _tmp2_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (BirdFontText*) bird_font_widget_construct (object_type);
	((BirdFontWidget*) self)->margin_bottom = margin_bottom;
	_tmp0_ = bird_font_font_cache_get_default_cache ();
	_bird_font_font_cache_unref0 (self->priv->font_cache);
	self->priv->font_cache = _tmp0_;
	_tmp1_ = self->priv->font_cache;
	_tmp2_ = bird_font_font_cache_get_fallback (_tmp1_);
	_g_object_unref0 (self->cached_font);
	self->cached_font = _tmp2_;
	bird_font_text_set_text (self, text);
	bird_font_text_set_font_size (self, size);
	return self;
}

BirdFontText*
bird_font_text_new (const gchar* text,
                    gdouble size,
                    gdouble margin_bottom)
{
	return bird_font_text_construct (BIRD_FONT_TYPE_TEXT, text, size, margin_bottom);
}

void
bird_font_text_set_use_cache (BirdFontText* self,
                              gboolean cache)
{
	g_return_if_fail (self != NULL);
	self->priv->use_cache = cache;
}

gchar*
bird_font_text_get_text (BirdFontText* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->text;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/** Set font for this text area.
 * @param font_absolute path to the font file or a file name for one of the font files in search paths.
 * @return true if the font was found
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
bird_font_text_load_font (BirdFontText* self,
                          const gchar* font_file)
{
	GFile* path = NULL;
	GFile* f = NULL;
	BirdFontFontCache* fc = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* _tmp6_;
	BirdFontFontCache* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	BirdFontCachedFont* _tmp10_;
	BirdFontGlyphSequence* _tmp11_;
	BirdFontCachedFont* _tmp12_;
	BirdFontFont* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (font_file != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (font_file);
	_g_object_unref0 (f);
	f = _tmp0_;
	_tmp2_ = f;
	if (g_file_query_exists (_tmp2_, NULL)) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = f;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		GFile* _tmp5_;
		_tmp5_ = bird_font_search_paths_find_file (NULL, font_file);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (path);
	path = _tmp6_;
	_tmp7_ = bird_font_font_cache_get_default_cache ();
	_bird_font_font_cache_unref0 (fc);
	fc = _tmp7_;
	_tmp8_ = g_file_get_path (path);
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = bird_font_font_cache_get_font (fc, _tmp9_);
	_g_object_unref0 (self->cached_font);
	self->cached_font = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = bird_font_text_generate_glyphs (self);
	_g_object_unref0 (self->priv->gs);
	self->priv->gs = _tmp11_;
	_tmp12_ = self->cached_font;
	_tmp13_ = _tmp12_->font;
	result = _tmp13_ != NULL;
	_g_object_unref0 (_tmp1_);
	_bird_font_font_cache_unref0 (fc);
	_g_object_unref0 (f);
	_g_object_unref0 (path);
	return result;
}

void
bird_font_text_set_font_size (BirdFontText* self,
                              gdouble height_in_pixels)
{
	BirdFontGlyphSequence* _tmp0_;
	g_return_if_fail (self != NULL);
	self->font_size = height_in_pixels;
	self->priv->sidebearing_extent = (gdouble) 0;
	_tmp0_ = self->priv->gs;
	if (_tmp0_ == NULL) {
		BirdFontGlyphSequence* _tmp1_;
		_tmp1_ = bird_font_text_generate_glyphs (self);
		_g_object_unref0 (self->priv->gs);
		self->priv->gs = _tmp1_;
	}
}

static gpointer
_bird_font_font_cache_ref0 (gpointer self)
{
	return self ? bird_font_font_cache_ref (self) : NULL;
}

void
bird_font_text_set_font_cache (BirdFontText* self,
                               BirdFontFontCache* font_cache)
{
	BirdFontFontCache* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font_cache != NULL);
	_tmp0_ = _bird_font_font_cache_ref0 (font_cache);
	_bird_font_font_cache_unref0 (self->priv->font_cache);
	self->priv->font_cache = _tmp0_;
}

void
bird_font_text_set_text (BirdFontText* self,
                         const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->text);
	self->text = _tmp0_;
	_g_object_unref0 (self->priv->gs);
	self->priv->gs = NULL;
	self->priv->sidebearing_extent = (gdouble) 0;
	_cairo_surface_destroy0 (self->priv->cache);
	self->priv->cache = NULL;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static BirdFontGlyphSequence*
bird_font_text_generate_glyphs (BirdFontText* self)
{
	gint index = 0;
	gunichar c = 0U;
	gchar* name = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontGlyphSequence* gs = NULL;
	BirdFontGlyphSequence* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_sequence_new ();
	_g_object_unref0 (gs);
	gs = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->glyph_names);
	self->priv->glyph_names = _tmp1_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gchar* _tmp5_;
		BirdFontCachedFont* _tmp6_;
		const gchar* _tmp7_;
		BirdFontGlyph* _tmp8_;
		BirdFontGlyphSequence* _tmp9_;
		GeeArrayList* _tmp10_;
		BirdFontGlyph* _tmp11_;
		GeeArrayList* _tmp12_;
		const gchar* _tmp13_;
		_tmp2_ = self->text;
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
		c = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = g_unichar_to_string (c);
		_g_free0 (name);
		name = (gchar*) _tmp5_;
		_tmp6_ = self->cached_font;
		_tmp7_ = name;
		_tmp8_ = bird_font_cached_font_get_glyph_by_name (_tmp6_, _tmp7_);
		_g_object_unref0 (g);
		g = _tmp8_;
		_tmp9_ = gs;
		_tmp10_ = _tmp9_->glyph;
		_tmp11_ = g;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
		_tmp12_ = self->priv->glyph_names;
		_tmp13_ = name;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
	}
	result = gs;
	_g_object_unref0 (g);
	_g_free0 (name);
	return result;
}

void
bird_font_text_iterate (BirdFontText* self,
                        BirdFontTextIterator iter,
                        gpointer iter_target)
{
	BirdFontGlyph* glyph = NULL;
	gdouble w = 0.0;
	gdouble kern = 0.0;
	gint wi = 0;
	BirdFontGlyph* prev = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontGlyphSequence* word_with_ligatures = NULL;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	BirdFontGlyphSequence* word = NULL;
	BirdFontKerningClasses* kc = NULL;
	BirdFontFont* empty = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyphSequence* _tmp3_;
	BirdFontGlyphSequence* _tmp4_;
	BirdFontGlyphSequence* _tmp5_;
	BirdFontCachedFont* _tmp6_;
	BirdFontFont* _tmp7_;
	BirdFontCachedFont* _tmp16_;
	BirdFontFont* _tmp17_;
	BirdFontGlyphSequence* _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_empty;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	empty = _tmp1_;
	_tmp2_ = bird_font_glyph_new_no_lines ("", (gunichar) '\0');
	_g_object_unref0 (glyph);
	glyph = _tmp2_;
	w = (gdouble) 0;
	_g_object_unref0 (prev);
	prev = NULL;
	kern = (gdouble) 0;
	_tmp3_ = bird_font_text_get_glyph_sequence (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (word);
	word = _tmp5_;
	wi = 0;
	_tmp6_ = self->cached_font;
	_tmp7_ = _tmp6_->font;
	if (_tmp7_ != NULL) {
		BirdFontGlyphSequence* _tmp8_;
		BirdFontCachedFont* _tmp9_;
		BirdFontFont* _tmp10_;
		BirdFontGlyphSequence* _tmp11_;
		_tmp8_ = word;
		_tmp9_ = self->cached_font;
		_tmp10_ = _tmp9_->font;
		_tmp11_ = bird_font_glyph_sequence_process_ligatures (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_FONT, BirdFontFont));
		_g_object_unref0 (word_with_ligatures);
		word_with_ligatures = _tmp11_;
	} else {
		BirdFontGlyphSequence* _tmp12_;
		BirdFontFont* _tmp13_;
		BirdFontFont* _tmp14_;
		BirdFontGlyphSequence* _tmp15_;
		_tmp12_ = word;
		_tmp13_ = bird_font_font_new ();
		_tmp14_ = _tmp13_;
		_tmp15_ = bird_font_glyph_sequence_process_ligatures (_tmp12_, _tmp14_);
		_g_object_unref0 (word_with_ligatures);
		word_with_ligatures = _tmp15_;
		_g_object_unref0 (_tmp14_);
	}
	_bird_font_glyph_range_unref0 (gr_left);
	gr_left = NULL;
	_bird_font_glyph_range_unref0 (gr_right);
	gr_right = NULL;
	_tmp16_ = self->cached_font;
	_tmp17_ = _tmp16_->font;
	if (_tmp17_ != NULL) {
		BirdFontCachedFont* _tmp18_;
		BirdFontFont* _tmp19_;
		BirdFontKerningClasses* _tmp20_;
		_tmp18_ = self->cached_font;
		_tmp19_ = _tmp18_->font;
		_tmp20_ = bird_font_font_get_kerning_classes (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, BIRD_FONT_TYPE_FONT, BirdFontFont));
		_g_object_unref0 (kc);
		kc = _tmp20_;
	} else {
		BirdFontFont* _tmp21_;
		BirdFontKerningClasses* _tmp22_;
		_tmp21_ = empty;
		_tmp22_ = bird_font_kerning_classes_new (_tmp21_);
		_g_object_unref0 (kc);
		kc = _tmp22_;
	}
	_tmp23_ = word_with_ligatures;
	_tmp24_ = _tmp23_->glyph;
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		BirdFontGlyphSequence* _tmp27_;
		GeeArrayList* _tmp28_;
		gpointer _tmp29_;
		BirdFontGlyph* _tmp30_;
		_tmp27_ = word_with_ligatures;
		_tmp28_ = _tmp27_->glyph;
		_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
		_g_object_unref0 (g);
		g = (BirdFontGlyph*) _tmp29_;
		_tmp30_ = g;
		if (_tmp30_ != NULL) {
			BirdFontGlyph* _tmp31_;
			_tmp31_ = g;
			self->priv->margin_left = bird_font_glyph_get_left_side_bearing (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			if (self->priv->margin_left < ((gdouble) 0)) {
				self->priv->margin_left = -self->priv->margin_left;
			} else {
				self->priv->margin_left = (gdouble) 0;
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				BirdFontGlyphSequence* _tmp34_;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				BirdFontGlyphSequence* _tmp38_;
				GeeArrayList* _tmp39_;
				gpointer _tmp40_;
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
				BirdFontGlyph* _tmp43_;
				gboolean _tmp64_ = FALSE;
				BirdFontGlyph* _tmp65_;
				BirdFontGlyph* _tmp75_ = NULL;
				BirdFontGlyph* _tmp76_;
				BirdFontGlyph* _tmp80_;
				BirdFontGlyph* _tmp81_;
				BirdFontGlyphSequence* _tmp82_;
				GeeArrayList* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				BirdFontGlyph* _tmp86_;
				BirdFontGlyph* _tmp87_;
				gint _tmp88_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = word_with_ligatures;
				_tmp35_ = _tmp34_->glyph;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (!(i < _tmp37_)) {
					break;
				}
				_tmp38_ = word_with_ligatures;
				_tmp39_ = _tmp38_->glyph;
				_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, i);
				_g_object_unref0 (g);
				g = (BirdFontGlyph*) _tmp40_;
				_tmp43_ = g;
				if (_tmp43_ == NULL) {
					_tmp42_ = TRUE;
				} else {
					BirdFontGlyph* _tmp44_;
					_tmp44_ = prev;
					_tmp42_ = _tmp44_ == NULL;
				}
				if (_tmp42_) {
					_tmp41_ = TRUE;
				} else {
					_tmp41_ = wi == 0;
				}
				if (_tmp41_) {
					kern = (gdouble) 0;
				} else {
					BirdFontGlyphSequence* _tmp45_;
					GeeArrayList* _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					BirdFontGlyphSequence* _tmp49_;
					GeeArrayList* _tmp50_;
					gpointer _tmp51_;
					BirdFontGlyphSequence* _tmp52_;
					GeeArrayList* _tmp53_;
					gpointer _tmp54_;
					BirdFontKerningClasses* _tmp55_;
					BirdFontGlyph* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					BirdFontGlyph* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					BirdFontGlyphRange* _tmp62_;
					BirdFontGlyphRange* _tmp63_;
					_tmp45_ = word_with_ligatures;
					_tmp46_ = _tmp45_->ranges;
					_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
					_tmp48_ = _tmp47_;
					g_return_if_fail (wi < _tmp48_);
					g_return_if_fail ((wi - 1) >= 0);
					_tmp49_ = word_with_ligatures;
					_tmp50_ = _tmp49_->ranges;
					_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, wi - 1);
					_bird_font_glyph_range_unref0 (gr_left);
					gr_left = (BirdFontGlyphRange*) _tmp51_;
					_tmp52_ = word_with_ligatures;
					_tmp53_ = _tmp52_->ranges;
					_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, wi);
					_bird_font_glyph_range_unref0 (gr_right);
					gr_right = (BirdFontGlyphRange*) _tmp54_;
					_tmp55_ = kc;
					_tmp56_ = prev;
					_tmp57_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					_tmp58_ = _tmp57_;
					_tmp59_ = g;
					_tmp60_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					_tmp61_ = _tmp60_;
					_tmp62_ = gr_left;
					_tmp63_ = gr_right;
					kern = bird_font_kerning_classes_get_kerning_for_pair (_tmp55_, _tmp58_, _tmp61_, _tmp62_, _tmp63_);
					_g_free0 (_tmp61_);
					_g_free0 (_tmp58_);
				}
				_tmp65_ = g;
				if (_tmp65_ == NULL) {
					GeeArrayList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					_tmp66_ = self->priv->glyph_names;
					_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = i;
					_tmp64_ = (0 <= _tmp69_) && (_tmp69_ < _tmp68_);
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					BirdFontCachedFont* _tmp70_;
					GeeArrayList* _tmp71_;
					gpointer _tmp72_;
					gchar* _tmp73_;
					BirdFontGlyph* _tmp74_;
					_tmp70_ = self->cached_font;
					_tmp71_ = self->priv->glyph_names;
					_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, i);
					_tmp73_ = (gchar*) _tmp72_;
					_tmp74_ = bird_font_cached_font_get_glyph_by_name (_tmp70_, _tmp73_);
					_g_object_unref0 (g);
					g = _tmp74_;
					_g_free0 (_tmp73_);
				}
				_tmp76_ = g;
				if (_tmp76_ == NULL) {
					BirdFontGlyph* _tmp77_;
					_tmp77_ = bird_font_glyph_new ("", (gunichar) 0);
					_g_object_unref0 (_tmp75_);
					_tmp75_ = _tmp77_;
				} else {
					BirdFontGlyph* _tmp78_;
					BirdFontGlyph* _tmp79_;
					_tmp78_ = g;
					_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					_g_object_unref0 (_tmp75_);
					_tmp75_ = _tmp79_;
				}
				_tmp80_ = _g_object_ref0 (_tmp75_);
				_g_object_unref0 (glyph);
				glyph = _tmp80_;
				_tmp81_ = glyph;
				_tmp82_ = word_with_ligatures;
				_tmp83_ = _tmp82_->glyph;
				_tmp84_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp83_);
				_tmp85_ = _tmp84_;
				iter (_tmp81_, kern, (i + 1) == _tmp85_, iter_target);
				_tmp86_ = g;
				_tmp87_ = _g_object_ref0 (_tmp86_);
				_g_object_unref0 (prev);
				prev = _tmp87_;
				_tmp88_ = wi;
				wi = _tmp88_ + 1;
				_g_object_unref0 (_tmp75_);
			}
		}
	}
	_g_object_unref0 (empty);
	_g_object_unref0 (kc);
	_g_object_unref0 (word);
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_object_unref0 (word_with_ligatures);
	_g_object_unref0 (g);
	_g_object_unref0 (prev);
	_g_object_unref0 (glyph);
}

static Block84Data*
block84_data_ref (Block84Data* _data84_)
{
	g_atomic_int_inc (&_data84_->_ref_count_);
	return _data84_;
}

static void
block84_data_unref (void * _userdata_)
{
	Block84Data* _data84_;
	_data84_ = (Block84Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data84_->_ref_count_)) {
		BirdFontText* self;
		self = _data84_->self;
		_g_object_unref0 (self);
		g_slice_free (Block84Data, _data84_);
	}
}

static void
__lambda89_ (Block84Data* _data84_,
             BirdFontGlyph* glyph,
             gdouble kerning,
             gboolean last)
{
	BirdFontText* self;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble lsb = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = _data84_->self;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (glyph);
	_tmp1_ = _tmp0_;
	lsb = _tmp1_;
	if (!last) {
		_data84_->x += (bird_font_glyph_get_width (glyph) + kerning) * bird_font_text_get_scale (self, glyph);
	} else {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		bird_font_glyph_boundaries (glyph, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		x1 = _tmp2_;
		y1 = _tmp3_;
		x2 = _tmp4_;
		y2 = _tmp5_;
		_data84_->x += (x2 - lsb) * bird_font_text_get_scale (self, glyph);
	}
}

static void
___lambda89__bird_font_text_iterator (BirdFontGlyph* glyph,
                                      gdouble kerning,
                                      gboolean last,
                                      gpointer self)
{
	__lambda89_ (self, glyph, kerning, last);
}

gdouble
bird_font_text_get_extent (BirdFontText* self)
{
	Block84Data* _data84_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_data84_ = g_slice_new0 (Block84Data);
	_data84_->_ref_count_ = 1;
	_data84_->self = g_object_ref (self);
	_data84_->x = (gdouble) 0;
	bird_font_text_iterate (self, ___lambda89__bird_font_text_iterator, _data84_);
	result = _data84_->x;
	block84_data_unref (_data84_);
	_data84_ = NULL;
	return result;
}

static Block85Data*
block85_data_ref (Block85Data* _data85_)
{
	g_atomic_int_inc (&_data85_->_ref_count_);
	return _data85_;
}

static void
block85_data_unref (void * _userdata_)
{
	Block85Data* _data85_;
	_data85_ = (Block85Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data85_->_ref_count_)) {
		BirdFontText* self;
		self = _data85_->self;
		_g_object_unref0 (self);
		g_slice_free (Block85Data, _data85_);
	}
}

static void
__lambda19_ (Block85Data* _data85_,
             BirdFontGlyph* glyph,
             gdouble kerning,
             gboolean last)
{
	BirdFontText* self;
	gdouble lsb = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = _data85_->self;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (glyph);
	_tmp1_ = _tmp0_;
	lsb = _tmp1_;
	_data85_->x += (bird_font_glyph_get_width (glyph) + kerning) * bird_font_text_get_scale (self, glyph);
}

static void
___lambda19__bird_font_text_iterator (BirdFontGlyph* glyph,
                                      gdouble kerning,
                                      gboolean last,
                                      gpointer self)
{
	__lambda19_ (self, glyph, kerning, last);
}

gdouble
bird_font_text_get_sidebearing_extent (BirdFontText* self)
{
	Block85Data* _data85_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_data85_ = g_slice_new0 (Block85Data);
	_data85_->_ref_count_ = 1;
	_data85_->self = g_object_ref (self);
	if (G_LIKELY (self->priv->sidebearing_extent > ((gdouble) 0))) {
		result = self->priv->sidebearing_extent;
		block85_data_unref (_data85_);
		_data85_ = NULL;
		return result;
	}
	_data85_->x = (gdouble) 0;
	bird_font_text_iterate (self, ___lambda19__bird_font_text_iterator, _data85_);
	self->priv->sidebearing_extent = _data85_->x;
	result = _data85_->x;
	block85_data_unref (_data85_);
	_data85_ = NULL;
	return result;
}

static gdouble
bird_font_text_real_get_height (BirdFontWidget* base)
{
	BirdFontText * self;
	gdouble result;
	self = (BirdFontText*) base;
	result = self->font_size;
	return result;
}

static Block86Data*
block86_data_ref (Block86Data* _data86_)
{
	g_atomic_int_inc (&_data86_->_ref_count_);
	return _data86_;
}

static void
block86_data_unref (void * _userdata_)
{
	Block86Data* _data86_;
	_data86_ = (Block86Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data86_->_ref_count_)) {
		BirdFontText* self;
		self = _data86_->self;
		_g_object_unref0 (self);
		g_slice_free (Block86Data, _data86_);
	}
}

static void
__lambda256_ (Block86Data* _data86_,
              BirdFontGlyph* glyph,
              gdouble kerning,
              gboolean last)
{
	BirdFontText* self;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble h = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	self = _data86_->self;
	g_return_if_fail (glyph != NULL);
	bird_font_glyph_boundaries (glyph, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x1 = _tmp0_;
	y1 = _tmp1_;
	x2 = _tmp2_;
	y2 = _tmp3_;
	h = fmax (y1, y2) - fmin (y1, y2);
	h *= bird_font_text_get_scale (self, glyph) - (glyph->baseline * bird_font_text_get_scale (self, glyph));
	if (h > _data86_->max_height) {
		_data86_->max_height = h;
	}
}

static void
___lambda256__bird_font_text_iterator (BirdFontGlyph* glyph,
                                       gdouble kerning,
                                       gboolean last,
                                       gpointer self)
{
	__lambda256_ (self, glyph, kerning, last);
}

gdouble
bird_font_text_get_acender (BirdFontText* self)
{
	Block86Data* _data86_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_data86_ = g_slice_new0 (Block86Data);
	_data86_->_ref_count_ = 1;
	_data86_->self = g_object_ref (self);
	_data86_->max_height = (gdouble) 0;
	bird_font_text_iterate (self, ___lambda256__bird_font_text_iterator, _data86_);
	result = _data86_->max_height;
	block86_data_unref (_data86_);
	_data86_ = NULL;
	return result;
}

static Block87Data*
block87_data_ref (Block87Data* _data87_)
{
	g_atomic_int_inc (&_data87_->_ref_count_);
	return _data87_;
}

static void
block87_data_unref (void * _userdata_)
{
	Block87Data* _data87_;
	_data87_ = (Block87Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data87_->_ref_count_)) {
		BirdFontText* self;
		self = _data87_->self;
		_g_object_unref0 (self);
		g_slice_free (Block87Data, _data87_);
	}
}

static void
__lambda381_ (Block87Data* _data87_,
              BirdFontGlyph* glyph,
              gdouble kerning,
              gboolean last)
{
	BirdFontText* self;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble lsb = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = _data87_->self;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (glyph);
	_tmp1_ = _tmp0_;
	lsb = _tmp1_;
	if (_data87_->first) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		bird_font_glyph_boundaries (glyph, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		x1 = _tmp2_;
		y1 = _tmp3_;
		x2 = _tmp4_;
		y2 = _tmp5_;
		_data87_->x += ((bird_font_glyph_get_width (glyph) + kerning) - fmin (x1, x2)) * bird_font_text_get_scale (self, glyph);
		_data87_->first = FALSE;
	} else {
		if (!last) {
			_data87_->x += (bird_font_glyph_get_width (glyph) + kerning) * bird_font_text_get_scale (self, glyph);
		} else {
			gdouble _tmp6_ = 0.0;
			gdouble _tmp7_ = 0.0;
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			bird_font_glyph_boundaries (glyph, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
			x1 = _tmp6_;
			y1 = _tmp7_;
			x2 = _tmp8_;
			y2 = _tmp9_;
			_data87_->x += (x2 - lsb) * bird_font_text_get_scale (self, glyph);
		}
	}
}

static void
___lambda381__bird_font_text_iterator (BirdFontGlyph* glyph,
                                       gdouble kerning,
                                       gboolean last,
                                       gpointer self)
{
	__lambda381_ (self, glyph, kerning, last);
}

static gdouble
bird_font_text_real_get_width (BirdFontWidget* base)
{
	BirdFontText * self;
	Block87Data* _data87_;
	gdouble result;
	self = (BirdFontText*) base;
	_data87_ = g_slice_new0 (Block87Data);
	_data87_->_ref_count_ = 1;
	_data87_->self = g_object_ref (self);
	_data87_->x = (gdouble) 0;
	_data87_->first = TRUE;
	bird_font_text_iterate (self, ___lambda381__bird_font_text_iterator, _data87_);
	result = _data87_->x;
	block87_data_unref (_data87_);
	_data87_ = NULL;
	return result;
}

gdouble
bird_font_text_get_decender (BirdFontText* self)
{
	gdouble decender_max = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	decender_max = bird_font_text_get_max_decender (self);
	if (decender_max > ((gdouble) 0)) {
		_tmp0_ = decender_max;
	} else {
		_tmp0_ = (gdouble) 0;
	}
	result = _tmp0_;
	return result;
}

static Block88Data*
block88_data_ref (Block88Data* _data88_)
{
	g_atomic_int_inc (&_data88_->_ref_count_);
	return _data88_;
}

static void
block88_data_unref (void * _userdata_)
{
	Block88Data* _data88_;
	_data88_ = (Block88Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data88_->_ref_count_)) {
		BirdFontText* self;
		self = _data88_->self;
		_g_object_unref0 (self);
		g_slice_free (Block88Data, _data88_);
	}
}

static void
__lambda257_ (Block88Data* _data88_,
              BirdFontGlyph* glyph,
              gdouble kerning,
              gboolean last)
{
	BirdFontText* self;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	self = _data88_->self;
	g_return_if_fail (glyph != NULL);
	bird_font_glyph_boundaries (glyph, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x1 = _tmp0_;
	y1 = _tmp1_;
	x2 = _tmp2_;
	y2 = _tmp3_;
	y = fmin (y1, y2);
	_data88_->decender = (glyph->baseline - y) * bird_font_text_get_scale (self, glyph);
	if (_data88_->decender > _data88_->decender_max) {
		_data88_->decender_max = _data88_->decender;
	}
}

static void
___lambda257__bird_font_text_iterator (BirdFontGlyph* glyph,
                                       gdouble kerning,
                                       gboolean last,
                                       gpointer self)
{
	__lambda257_ (self, glyph, kerning, last);
}

static gdouble
bird_font_text_get_max_decender (BirdFontText* self)
{
	Block88Data* _data88_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_data88_ = g_slice_new0 (Block88Data);
	_data88_->_ref_count_ = 1;
	_data88_->self = g_object_ref (self);
	_data88_->decender = (gdouble) 0;
	_data88_->decender_max = (gdouble) 0;
	bird_font_text_iterate (self, ___lambda257__bird_font_text_iterator, _data88_);
	result = _data88_->decender_max;
	block88_data_unref (_data88_);
	_data88_ = NULL;
	return result;
}

static void
bird_font_text_real_draw (BirdFontWidget* base,
                          cairo_t* cr)
{
	BirdFontText * self;
	gdouble descender = 0.0;
	BirdFontCachedFont* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontCachedFont* _tmp3_;
	gdouble y = 0.0;
	self = (BirdFontText*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->cached_font;
	_tmp1_ = bird_font_cached_font_get_bottom_limit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->cached_font;
	descender = _tmp2_ + _tmp3_->base_line;
	y = (((BirdFontWidget*) self)->widget_y + bird_font_widget_get_height ((BirdFontWidget*) self)) + (bird_font_text_get_font_scale (self) * descender);
	bird_font_text_draw_at_baseline (self, cr, ((BirdFontWidget*) self)->widget_x, y, "");
}

void
bird_font_text_draw_at_top (BirdFontText* self,
                            cairo_t* cr,
                            gdouble px,
                            gdouble py,
                            const gchar* cacheid)
{
	gdouble s = 0.0;
	gdouble y = 0.0;
	BirdFontCachedFont* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontCachedFont* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (cacheid != NULL);
	s = bird_font_text_get_font_scale (self);
	_tmp0_ = self->cached_font;
	_tmp1_ = bird_font_cached_font_get_top_limit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->cached_font;
	y = py + (s * (_tmp2_ - _tmp3_->base_line));
	bird_font_text_draw_at_baseline (self, cr, px, y, cacheid);
}

void
bird_font_text_set_source_rgba (BirdFontText* self,
                                gdouble r,
                                gdouble g,
                                gdouble b,
                                gdouble a)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->r != r) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->g != g;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->b != b;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->a != a;
	}
	if (_tmp0_) {
		self->r = r;
		self->g = g;
		self->b = b;
		self->a = a;
		_cairo_surface_destroy0 (self->priv->cache);
		self->priv->cache = NULL;
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

gchar*
bird_font_text_get_cache_id (BirdFontText* self,
                             gint offset_x,
                             gint offset_y)
{
	gchar* key = NULL;
	gint64 c = 0LL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	c = (((((gint64) (self->r * 255)) << 24) | (((gint64) (self->g * 255)) << 16)) | (((gint64) (self->b * 255)) << 8)) | (((gint64) (self->a * 255)) << 0);
	_tmp0_ = double_to_string (self->font_size);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, c);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", offset_x);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", offset_y);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp1_, " ", _tmp3_, " ", _tmp5_, " ", _tmp7_, NULL);
	_g_free0 (key);
	key = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = key;
	return result;
}

void
bird_font_text_draw_at_baseline (BirdFontText* self,
                                 cairo_t* cr,
                                 gdouble px,
                                 gdouble py,
                                 const gchar* cacheid)
{
	cairo_surface_t* _tmp0_;
	gdouble screen_scale = 0.0;
	gdouble font_scale = 0.0;
	gdouble cache_y = 0.0;
	BirdFontCachedFont* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	BirdFontCachedFont* _tmp5_;
	gdouble scaled_x = 0.0;
	gdouble scaled_y = 0.0;
	cairo_surface_t* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (cacheid != NULL);
	_tmp0_ = self->priv->cache;
	if (_tmp0_ == NULL) {
		cairo_surface_t* _tmp1_;
		_tmp1_ = bird_font_text_draw_on_cache_surface (self, cacheid);
		_cairo_surface_destroy0 (self->priv->cache);
		self->priv->cache = _tmp1_;
	}
	screen_scale = bird_font_screen_get_scale ();
	font_scale = bird_font_text_get_font_scale (self);
	_tmp2_ = self->cached_font;
	_tmp3_ = bird_font_cached_font_get_top_limit (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->cached_font;
	cache_y = py - (font_scale * (_tmp4_ - _tmp5_->base_line));
	cairo_save (cr);
	cairo_scale (cr, 1 / screen_scale, 1 / screen_scale);
	scaled_x = (px - self->priv->margin_left) * screen_scale;
	scaled_y = cache_y * screen_scale;
	_tmp6_ = self->priv->cache;
	cairo_set_source_surface (cr, (cairo_surface_t*) _tmp6_, (gdouble) ((gint) rint (scaled_x)), (gdouble) ((gint) rint (scaled_y)));
	cairo_paint (cr);
	cairo_restore (cr);
}

static Block89Data*
block89_data_ref (Block89Data* _data89_)
{
	g_atomic_int_inc (&_data89_->_ref_count_);
	return _data89_;
}

static void
block89_data_unref (void * _userdata_)
{
	Block89Data* _data89_;
	_data89_ = (Block89Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data89_->_ref_count_)) {
		BirdFontText* self;
		self = _data89_->self;
		_cairo_destroy0 (_data89_->cr);
		_g_free0 (_data89_->cacheid);
		_g_object_unref0 (self);
		g_slice_free (Block89Data, _data89_);
	}
}

static void
__lambda75_ (Block89Data* _data89_,
             BirdFontGlyph* glyph,
             gdouble kerning,
             gboolean last)
{
	BirdFontText* self;
	gdouble end = 0.0;
	gboolean _tmp0_ = FALSE;
	self = _data89_->self;
	g_return_if_fail (glyph != NULL);
	_data89_->x += kerning * _data89_->ratio;
	end = _data89_->x + (bird_font_glyph_get_width (glyph) * _data89_->ratio);
	if (self->priv->truncated_width > ((gdouble) 0)) {
		_tmp0_ = end > self->priv->truncated_width;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->use_cache) {
		cairo_t* _tmp1_;
		_tmp1_ = _data89_->cr;
		bird_font_text_draw_chached (self, _tmp1_, glyph, kerning, last, _data89_->x, _data89_->y, _data89_->cc_y, _data89_->ratio, _data89_->cacheid);
	} else {
		cairo_t* _tmp2_;
		_tmp2_ = _data89_->cr;
		bird_font_text_draw_without_cache (self, _tmp2_, glyph, kerning, last, _data89_->x, _data89_->y, _data89_->cc_y, _data89_->ratio);
	}
	_data89_->x = end;
}

static void
___lambda75__bird_font_text_iterator (BirdFontGlyph* glyph,
                                      gdouble kerning,
                                      gboolean last,
                                      gpointer self)
{
	__lambda75_ (self, glyph, kerning, last);
}

static cairo_surface_t*
bird_font_text_draw_on_cache_surface (BirdFontText* self,
                                      const gchar* cacheid)
{
	Block89Data* _data89_;
	gchar* _tmp0_;
	cairo_surface_t* cache_surface = NULL;
	gdouble screen_scale = 0.0;
	gdouble h = 0.0;
	BirdFontCachedFont* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	BirdFontCachedFont* _tmp4_;
	gdouble w = 0.0;
	gboolean _tmp5_ = FALSE;
	cairo_surface_t* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	BirdFontCachedFont* _tmp17_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cacheid != NULL, NULL);
	_data89_ = g_slice_new0 (Block89Data);
	_data89_->_ref_count_ = 1;
	_data89_->self = g_object_ref (self);
	_tmp0_ = g_strdup (cacheid);
	_g_free0 (_data89_->cacheid);
	_data89_->cacheid = _tmp0_;
	screen_scale = bird_font_screen_get_scale ();
	h = (self->font_size * screen_scale) + 1;
	_data89_->ratio = bird_font_text_get_font_scale (self);
	_tmp1_ = self->cached_font;
	_tmp2_ = bird_font_cached_font_get_top_limit (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->cached_font;
	_data89_->cc_y = (_tmp3_ - _tmp4_->base_line) * _data89_->ratio;
	_data89_->x = (gdouble) 0;
	w = (((bird_font_text_get_sidebearing_extent (self) * screen_scale) + _data89_->x) + self->priv->margin_left) + 1;
	if (!isnormal (w)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = !isnormal (h);
	}
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		cairo_surface_t* _tmp12_;
		_tmp6_ = double_to_string (h);
		_tmp7_ = _tmp6_;
		_tmp8_ = double_to_string (w);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Bad text size, h: ", _tmp7_, " w: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_warning ("Text.vala:397: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp12_ = bird_font_screen_create_background_surface (1, 1);
		result = _tmp12_;
		_cairo_surface_destroy0 (cache_surface);
		block89_data_unref (_data89_);
		_data89_ = NULL;
		return result;
	}
	_tmp13_ = bird_font_screen_create_background_surface ((gint) w, (gint) h);
	_cairo_surface_destroy0 (cache_surface);
	cache_surface = _tmp13_;
	_tmp14_ = cache_surface;
	_tmp15_ = cairo_create (_tmp14_);
	_cairo_destroy0 (_data89_->cr);
	_data89_->cr = _tmp15_;
	_tmp16_ = _data89_->cr;
	cairo_scale (_tmp16_, screen_scale, screen_scale);
	_data89_->y = _data89_->cc_y;
	_tmp17_ = self->cached_font;
	if (G_UNLIKELY (_tmp17_->base_line != ((gdouble) 0))) {
		g_warning ("Text.vala:408: Base line not zero.");
	}
	bird_font_text_iterate (self, ___lambda75__bird_font_text_iterator, _data89_);
	result = cache_surface;
	block89_data_unref (_data89_);
	_data89_ = NULL;
	return result;
}

static void
bird_font_text_draw_without_cache (BirdFontText* self,
                                   cairo_t* cr,
                                   BirdFontGlyph* glyph,
                                   gdouble kerning,
                                   gboolean last,
                                   gdouble x,
                                   gdouble y,
                                   gdouble cc_y,
                                   gdouble ratio)
{
	gdouble lsb = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	cairo_save (cr);
	cairo_set_source_rgba (cr, self->r, self->g, self->b, self->a);
	cairo_new_path (cr);
	_tmp0_ = bird_font_glyph_get_left_limit (glyph);
	_tmp1_ = _tmp0_;
	lsb = _tmp1_;
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp2_ = bird_font_glyph_get_visible_paths (glyph);
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (BirdFontPath*) _tmp9_;
			_tmp10_ = path;
			bird_font_text_draw_path (self, cr, glyph, _tmp10_, lsb, x, y, ratio);
			_g_object_unref0 (path);
		}
		_g_object_unref0 (_path_list);
	}
	cairo_fill (cr);
	cairo_restore (cr);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static void
bird_font_text_draw_chached (BirdFontText* self,
                             cairo_t* cr,
                             BirdFontGlyph* glyph,
                             gdouble kerning,
                             gboolean last,
                             gdouble x,
                             gdouble y,
                             gdouble cc_y,
                             gdouble ratio,
                             const gchar* cacheid)
{
	gdouble lsb = 0.0;
	cairo_surface_t* cache = NULL;
	cairo_surface_t* cached_glyph = NULL;
	cairo_t* cc = NULL;
	gchar* cache_id = NULL;
	gdouble glyph_margin_left = 0.0;
	gdouble xp = 0.0;
	gdouble yp = 0.0;
	gint offset_x = 0;
	gint offset_y = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	cairo_surface_t* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	g_return_if_fail (cacheid != NULL);
	glyph_margin_left = bird_font_glyph_get_left_side_bearing (glyph);
	if (glyph_margin_left < ((gdouble) 0)) {
		glyph_margin_left = -glyph_margin_left;
	} else {
		glyph_margin_left = (gdouble) 0;
	}
	xp = (x - (glyph_margin_left * ratio)) * bird_font_screen_get_scale ();
	yp = (y - cc_y) * bird_font_screen_get_scale ();
	offset_x = (gint) (10 * (xp - ((gint) xp)));
	offset_y = (gint) (10 * (yp - ((gint) yp)));
	if (g_strcmp0 (cacheid, "") == 0) {
		gchar* _tmp1_;
		_tmp1_ = bird_font_text_get_cache_id (self, offset_x, offset_y);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (cacheid);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (cache_id);
	cache_id = _tmp3_;
	_tmp4_ = cache_id;
	if (!bird_font_glyph_has_cache (glyph, _tmp4_)) {
		gint w = 0;
		gint h = 0;
		cairo_surface_t* _tmp5_;
		cairo_surface_t* _tmp6_;
		cairo_t* _tmp7_;
		cairo_t* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		cairo_t* _tmp11_;
		cairo_t* _tmp12_;
		cairo_t* _tmp13_;
		cairo_t* _tmp24_;
		cairo_t* _tmp25_;
		cairo_surface_t* _tmp28_;
		cairo_surface_t* _tmp29_;
		w = ((gint) ((((2 * glyph_margin_left) * ratio) + bird_font_glyph_get_width (glyph)) * ratio)) + 2;
		h = ((gint) self->font_size) + 2;
		_tmp5_ = bird_font_screen_create_background_surface (w, h);
		_cairo_surface_destroy0 (cache);
		cache = _tmp5_;
		_tmp6_ = cache;
		_tmp7_ = cairo_create (_tmp6_);
		_cairo_destroy0 (cc);
		cc = _tmp7_;
		_tmp8_ = cc;
		cairo_scale (_tmp8_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
		_tmp9_ = bird_font_glyph_get_left_limit (glyph);
		_tmp10_ = _tmp9_;
		lsb = _tmp10_ - glyph_margin_left;
		_tmp11_ = cc;
		cairo_save (_tmp11_);
		_tmp12_ = cc;
		cairo_set_source_rgba (_tmp12_, self->r, self->g, self->b, self->a);
		_tmp13_ = cc;
		cairo_new_path (_tmp13_);
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp14_;
			gint _path_size = 0;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _path_index = 0;
			_tmp14_ = bird_font_glyph_get_visible_paths (glyph);
			_path_list = _tmp14_;
			_tmp15_ = _path_list;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_path_size = _tmp17_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				BirdFontPath* path = NULL;
				GeeArrayList* _tmp20_;
				gpointer _tmp21_;
				cairo_t* _tmp22_;
				BirdFontPath* _tmp23_;
				_path_index = _path_index + 1;
				_tmp18_ = _path_index;
				_tmp19_ = _path_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _path_list;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _path_index);
				path = (BirdFontPath*) _tmp21_;
				_tmp22_ = cc;
				_tmp23_ = path;
				bird_font_text_draw_path (self, _tmp22_, glyph, _tmp23_, lsb, (glyph_margin_left * ratio) + (offset_x / 10.0), cc_y + (offset_y / 10.0), ratio);
				_g_object_unref0 (path);
			}
			_g_object_unref0 (_path_list);
		}
		_tmp24_ = cc;
		cairo_fill (_tmp24_);
		_tmp25_ = cc;
		cairo_restore (_tmp25_);
		if (self->priv->use_cache) {
			const gchar* _tmp26_;
			cairo_surface_t* _tmp27_;
			_tmp26_ = cache_id;
			_tmp27_ = cache;
			bird_font_glyph_set_cache (glyph, _tmp26_, _tmp27_);
		}
		_tmp28_ = cache;
		_tmp29_ = _cairo_surface_reference0 (_tmp28_);
		_cairo_surface_destroy0 (cached_glyph);
		cached_glyph = _tmp29_;
	} else {
		const gchar* _tmp30_;
		cairo_surface_t* _tmp31_;
		_tmp30_ = cache_id;
		_tmp31_ = bird_font_glyph_get_cache (glyph, _tmp30_);
		_cairo_surface_destroy0 (cached_glyph);
		cached_glyph = _tmp31_;
	}
	cairo_save (cr);
	cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
	cairo_scale (cr, 1 / bird_font_screen_get_scale (), 1 / bird_font_screen_get_scale ());
	_tmp32_ = cached_glyph;
	cairo_set_source_surface (cr, _tmp32_, (gdouble) ((gint) xp), (gdouble) ((gint) yp));
	cairo_paint (cr);
	cairo_restore (cr);
	_g_free0 (_tmp0_);
	_g_free0 (cache_id);
	_cairo_destroy0 (cc);
	_cairo_surface_destroy0 (cached_glyph);
	_cairo_surface_destroy0 (cache);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_text_draw_path (BirdFontText* self,
                          cairo_t* cr,
                          BirdFontGlyph* glyph,
                          BirdFontPath* path,
                          gdouble lsb,
                          gdouble x,
                          gdouble y,
                          gdouble scale)
{
	BirdFontEditPoint* e = NULL;
	BirdFontEditPoint* prev = NULL;
	gdouble xa = 0.0;
	gdouble ya = 0.0;
	gdouble xb = 0.0;
	gdouble yb = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xd = 0.0;
	gdouble yd = 0.0;
	gdouble by = 0.0;
	gdouble s = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	g_return_if_fail (path != NULL);
	s = bird_font_text_get_scale (self, glyph);
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gpointer _tmp15_;
		BirdFontEditPoint* _tmp16_;
		BirdFontEditPoint* _tmp17_;
		BirdFontCachedFont* _tmp18_;
		if (G_UNLIKELY (bird_font_path_is_open (path))) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp4_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) glyph);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_to_string (_tmp5_);
			_tmp7_ = g_strconcat ("Path is open in ", _tmp6_, ".", NULL);
			_tmp8_ = _tmp7_;
			g_warning ("Text.vala:531: %s", _tmp8_);
			_g_free0 (_tmp8_);
			_g_free0 (_tmp5_);
		}
		_tmp9_ = bird_font_path_get_points (path);
		_tmp10_ = _tmp9_;
		_tmp11_ = bird_font_path_get_points (path);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp14_ - 1);
		_g_object_unref0 (prev);
		prev = (BirdFontEditPoint*) _tmp15_;
		_tmp16_ = prev;
		xa = ((_tmp16_->x - lsb) * s) + x;
		_tmp17_ = prev;
		ya = y - (_tmp17_->y * s);
		cairo_move_to (cr, xa, ya);
		_tmp18_ = self->cached_font;
		by = y - (_tmp18_->base_line * s);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp21_;
					GeeArrayList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					GeeArrayList* _tmp25_;
					GeeArrayList* _tmp26_;
					gpointer _tmp27_;
					BirdFontEditPoint* _tmp28_;
					BirdFontEditPoint* _tmp29_;
					BirdFontEditPoint* _tmp30_;
					BirdFontEditPoint* _tmp31_;
					BirdFontEditPoint* _tmp32_;
					BirdFontEditPointHandle* _tmp33_;
					gdouble _tmp34_;
					gdouble _tmp35_;
					BirdFontEditPoint* _tmp36_;
					BirdFontEditPointHandle* _tmp37_;
					gdouble _tmp38_;
					gdouble _tmp39_;
					BirdFontEditPoint* _tmp40_;
					BirdFontEditPointHandle* _tmp41_;
					gdouble _tmp42_;
					gdouble _tmp43_;
					BirdFontEditPoint* _tmp44_;
					BirdFontEditPointHandle* _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					BirdFontEditPoint* _tmp48_;
					BirdFontEditPoint* _tmp49_;
					BirdFontEditPoint* _tmp50_;
					BirdFontEditPoint* _tmp51_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = bird_font_path_get_points (path);
					_tmp22_ = _tmp21_;
					_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					if (!(i < _tmp24_)) {
						break;
					}
					_tmp25_ = bird_font_path_get_points (path);
					_tmp26_ = _tmp25_;
					_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, i);
					_tmp28_ = (BirdFontEditPoint*) _tmp27_;
					_tmp29_ = bird_font_edit_point_copy (_tmp28_);
					_g_object_unref0 (e);
					e = _tmp29_;
					_g_object_unref0 (_tmp28_);
					_tmp30_ = prev;
					_tmp31_ = e;
					bird_font_pen_tool_convert_point_segment_type (_tmp30_, _tmp31_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp32_ = prev;
					_tmp33_ = bird_font_edit_point_get_right_handle (_tmp32_);
					_tmp34_ = bird_font_edit_point_handle_get_x (_tmp33_);
					_tmp35_ = _tmp34_;
					xb = ((_tmp35_ - lsb) * s) + x;
					_tmp36_ = prev;
					_tmp37_ = bird_font_edit_point_get_right_handle (_tmp36_);
					_tmp38_ = bird_font_edit_point_handle_get_y (_tmp37_);
					_tmp39_ = _tmp38_;
					yb = by - (_tmp39_ * s);
					_tmp40_ = e;
					_tmp41_ = bird_font_edit_point_get_left_handle (_tmp40_);
					_tmp42_ = bird_font_edit_point_handle_get_x (_tmp41_);
					_tmp43_ = _tmp42_;
					xc = ((_tmp43_ - lsb) * s) + x;
					_tmp44_ = e;
					_tmp45_ = bird_font_edit_point_get_left_handle (_tmp44_);
					_tmp46_ = bird_font_edit_point_handle_get_y (_tmp45_);
					_tmp47_ = _tmp46_;
					yc = by - (_tmp47_ * s);
					_tmp48_ = e;
					xd = ((_tmp48_->x - lsb) * s) + x;
					_tmp49_ = e;
					yd = by - (_tmp49_->y * s);
					cairo_curve_to (cr, xb, yb, xc, yc, xd, yd);
					cairo_line_to (cr, xd, yd);
					_tmp50_ = e;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					_g_object_unref0 (prev);
					prev = _tmp51_;
				}
			}
		}
	}
	_g_object_unref0 (prev);
	_g_object_unref0 (e);
}

gdouble
bird_font_text_get_baseline_to_bottom (BirdFontText* self,
                                       BirdFontGlyph* g)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (g != NULL, 0.0);
	result = bird_font_text_get_scale (self, g) * ((-g->baseline) - g->bottom_limit);
	return result;
}

gdouble
bird_font_text_get_scale (BirdFontText* self,
                          BirdFontGlyph* g)
{
	gdouble s = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (g != NULL, 0.0);
	s = g->top_limit - g->bottom_limit;
	if (s == ((gdouble) 0)) {
		BirdFontCachedFont* _tmp0_;
		gdouble _tmp1_;
		gdouble _tmp2_;
		BirdFontCachedFont* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp0_ = self->cached_font;
		_tmp1_ = bird_font_cached_font_get_top_limit (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->cached_font;
		_tmp4_ = bird_font_cached_font_get_bottom_limit (_tmp3_);
		_tmp5_ = _tmp4_;
		s = _tmp2_ - _tmp5_;
	}
	result = self->font_size / s;
	return result;
}

gdouble
bird_font_text_get_font_scale (BirdFontText* self)
{
	BirdFontCachedFont* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontCachedFont* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->cached_font;
	_tmp1_ = bird_font_cached_font_get_top_limit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->cached_font;
	_tmp4_ = bird_font_cached_font_get_bottom_limit (_tmp3_);
	_tmp5_ = _tmp4_;
	result = self->font_size / (_tmp2_ - _tmp5_);
	return result;
}

gdouble
bird_font_text_get_baseline_to_bottom_for_font (BirdFontText* self)
{
	BirdFontCachedFont* _tmp0_;
	BirdFontCachedFont* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->cached_font;
	_tmp1_ = self->cached_font;
	_tmp2_ = bird_font_cached_font_get_bottom_limit (_tmp1_);
	_tmp3_ = _tmp2_;
	result = bird_font_text_get_font_scale (self) * ((-_tmp0_->base_line) - _tmp3_);
	return result;
}

void
bird_font_text_truncate (BirdFontText* self,
                         gdouble max_width)
{
	g_return_if_fail (self != NULL);
	self->priv->truncated_width = max_width;
}

static BirdFontGlyphSequence*
bird_font_text_get_glyph_sequence (BirdFontText* self)
{
	BirdFontGlyphSequence* result;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontGlyphSequence* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->gs;
	if (_tmp0_ == NULL) {
		BirdFontGlyphSequence* _tmp1_;
		_tmp1_ = bird_font_text_generate_glyphs (self);
		_g_object_unref0 (self->priv->gs);
		self->priv->gs = _tmp1_;
	}
	_tmp2_ = self->priv->gs;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_SEQUENCE, BirdFontGlyphSequence);
	return result;
}

static void
bird_font_text_class_init (BirdFontTextClass * klass,
                           gpointer klass_data)
{
	bird_font_text_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontText_private_offset);
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_text_real_get_height;
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_text_real_get_width;
	((BirdFontWidgetClass *) klass)->draw = (void (*) (BirdFontWidget*, cairo_t*)) bird_font_text_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_text_get_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_text_finalize;
}

static void
bird_font_text_instance_init (BirdFontText * self,
                              gpointer klass)
{
	self->priv = bird_font_text_get_instance_private (self);
	self->priv->cache = NULL;
	self->priv->use_cache = TRUE;
	self->priv->gs = NULL;
	self->priv->sidebearing_extent = (gdouble) 0;
	self->r = (gdouble) 0;
	self->g = (gdouble) 0;
	self->b = (gdouble) 0;
	self->a = (gdouble) 1;
	self->priv->truncated_width = (gdouble) -1;
	self->priv->margin_left = (gdouble) 0;
}

static void
bird_font_text_finalize (GObject * obj)
{
	BirdFontText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TEXT, BirdFontText);
	_bird_font_font_cache_unref0 (self->priv->font_cache);
	_g_object_unref0 (self->cached_font);
	_cairo_surface_destroy0 (self->priv->cache);
	_g_free0 (self->text);
	_g_object_unref0 (self->priv->glyph_names);
	_g_object_unref0 (self->priv->gs);
	G_OBJECT_CLASS (bird_font_text_parent_class)->finalize (obj);
}

/** Test implementation of a birdfont rendering engine. */
static GType
bird_font_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontText), 0, (GInstanceInitFunc) bird_font_text_instance_init, NULL };
	GType bird_font_text_type_id;
	bird_font_text_type_id = g_type_register_static (BIRD_FONT_TYPE_WIDGET, "BirdFontText", &g_define_type_info, 0);
	BirdFontText_private_offset = g_type_add_instance_private (bird_font_text_type_id, sizeof (BirdFontTextPrivate));
	return bird_font_text_type_id;
}

GType
bird_font_text_get_type (void)
{
	static volatile gsize bird_font_text_type_id__once = 0;
	if (g_once_init_enter (&bird_font_text_type_id__once)) {
		GType bird_font_text_type_id;
		bird_font_text_type_id = bird_font_text_get_type_once ();
		g_once_init_leave (&bird_font_text_type_id__once, bird_font_text_type_id);
	}
	return bird_font_text_type_id__once;
}

static void
_vala_bird_font_text_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BirdFontText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_TEXT, BirdFontText);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

